<?php
/**
 * Gogle Fonts
 */

if(!function_exists('wt_googlefonts_getfonts')){
	function wt_googlefonts_getfonts(){
		return array(
			"Abel"=>"Abel",
			"Abril Fatface"=>"Abril Fatface",
			"Aclonica"=>"Aclonica",
			"Acme"=>"Acme",
			"Actor"=>"Actor",
			"Adamina"=>"Adamina",
			"Advent Pro"=>"Advent Pro",
			"Advent Pro:100,200,300,400,500,600,700"=>"Advent Pro (plus all weights)",
			"Aguafina Script"=>"Aguafina Script",
			"Aladin"=>"Aladin",
			"Aldrich"=>"Aldrich",
			"Alex Brush"=>"Alex Brush",
			"Alfa Slab One"=>"Alfa Slab One",
			"Alice"=>"Alice",
			"Alike Angular"=>"Alike Angular",
			"Alike"=>"Alike",
			"Allan"=>"Allan",
			"Allerta Stencil"=>"Allerta Stencil",
			"Allerta"=>"Allerta",
			"Allura"=>"Allura",
			"Almendra SC"=>"Almendra SC",
			"Almendra"=>"Almendra",
			"Almendra:400,bold"=>"Almendra:400,bold",
			"Amaranth"=>"Amaranth",
			"Amatic SC"=>"Amatic SC",
			"Amatic SC:400,700"=>"Amatic SC:400,700",
			"Amethysta"=>"Amethysta",
			"Andada"=>"Andada",
			"Andika"=>"Andika",
			"Annie Use Your Telescope"=>"Annie Use Your Telescope",
			"Anonymous Pro"=>"Anonymous Pro",
			"Anonymous Pro:regular,italic,bold,bolditalic"=>"Anonymous Pro (plus italic, bold, and bold italic)",
			"Antic Didone"=>"Antic Didone",
			"Antic Slab"=>"Antic Slab",
			"Antic"=>"Antic",
			"Anton"=>"Anton",
			"Arapey"=>"Arapey",
			"Arapey:400,400italic"=>"Arapey:400,400italic",
			"Arbutus"=>"Arbutus",
			"Architects Daughter"=>"Architects Daughter",
			"Arimo"=>"Arimo",
			"Arimo:regular,italic,bold,bolditalic"=>"Arimo (plus italic, bold, and bold italic)",
			"Arizonia"=>"Arizonia",
			"Armata"=>"Armata",
			"Artifika"=>"Artifika",
			"Arvo"=>"Arvo",
			"Arvo:regular,italic,bold,bolditalic"=>"Arvo (plus italic, bold, and bold italic)",
			"Asap"=>"Asap",
			"Asap:400,400italic,700,700italic"=>"Asap (plus all weights and italics)",
			"Asset"=>"Asset",
			"Astloch"=>"Astloch",
			"Astloch:regular,bold"=>"Astloch (plus bold)",
			"Asul"=>"Asul",
			"Asul:400,bold"=>"Asul:400,bold",
			"Atomic Age"=>"Atomic Age",
			"Aubrey"=>"Aubrey",
			"Average"=>"Average",
			"Averia Gruesa Libre"=>"Averia Gruesa Libre",
			"Averia Libre"=>"Averia Libre",
			"Averia Libre:300,300italic,400,400italic,700,700italic"=>"Averia Libre (plus all weights and italics)",
			"Averia Sans Libre"=>"Averia Sans Libre",
			"Averia Sans Libre:300,300italic,400,400italic,700,700italic"=>"Averia Sans Libre (plus all weights and italics)",
			"Averia Serif Libre"=>"Averia Serif Libre", 
			"Averia Serif Libre:300,300italic,400,400italic,700,700italic"=>"Averia Serif Libre (plus all weights and italics)",
			"Bad Script"=>"Bad Script",
			"Balthazar"=>"Balthazar",
			"Bangers"=>"Bangers",
			"Basic"=>"Basic",
			"Baumans"=>"Baumans",
			"Belgrano"=>"Belgrano",
			"Bentham"=>"Bentham",
			"Berkshire Swash"=>"Berkshire Swash",
			"Bevan"=>"Bevan",
			"Bigshot One"=>"Bigshot One",
			"Bilbo Swash Caps"=>"Bilbo Swash Caps",
			"Bilbo"=>"Bilbo",
			"Bitter"=>"Bitter",
			"Bitter:400,400italic,700"=>"Bitter:400,400italic,700",
			"Black Ops One"=>"Black Ops One",
			"Bonbon"=>"Bonbon",
			"Boogaloo"=>"Boogaloo",
			"Bowlby One SC"=>"Bowlby One SC",
			"Bowlby One"=>"Bowlby One",
			"Brawler"=>"Brawler",
			"Bree Serif"=>"Bree Serif",
			"Bubblegum Sans"=>"Bubblegum Sans",
			"Buda:light"=>"Buda",
			"Buenard"=>"Buenard",
			"Buenard:400,bold"=>"Buenard:400,bold",
			"Butcherman"=>"Butcherman",
			"Butterfly Kids"=>"Butterfly Kids",
			"Cabin Condensed"=>"Cabin Condensed",
			"Cabin Condensed:400,500,600,700"=>"Cabin Condensed:400,500,600,700",
			"Cabin Sketch"=>"Cabin Sketch",
			"Cabin Sketch:bold"=>"Cabin Sketch Bold",
			"Cabin Sketch:regular,bold"=>"Cabin Sketch:regular,bold",
			"Cabin"=>"Cabin",
			"Cabin:regular,500,600,bold"=>"Cabin (plus 500, 600, and bold)",
			"Caesar Dressing"=>"Caesar Dressing",
			"Cagliostro"=>"Cagliostro",
			"Calligraffitti"=>"Calligraffitti",
			"Cambo"=>"Cambo",
			"Candal"=>"Candal",
			"Cantarell"=>"Cantarell",
			"Cantarell:regular,italic,bold,bolditalic"=>"Cantarell (plus italic, bold, and bold italic)",
			"Cantata One"=>"Cantata One",
			"Cardo"=>"Cardo",
			"Carme"=>"Carme",
			"Carter One"=>"Carter One",
			"Caudex"=>"Caudex",
			"Caudex:regular,italic,bold,bolditalic"=>"Caudex (plus italic, bold, and bold italic)",
			"Cedarville Cursive"=>"Cedarville Cursive",
			"Ceviche One"=>"Ceviche One",
			"Changa One"=>"Changa One",
			"Chango"=>"Chango",
			"Chelsea Market"=>"Chelsea Market",
			"Cherry Cream Soda"=>"Cherry Cream Soda",
			"Chewy"=>"Chewy",
			"Chicle"=>"Chicle",
			"Chivo"=>"Chivo",
			"Chivo:400,900"=>"Chivo (plus bold)",
			"Coda"=>"Coda",
			"Coda:400,800"=>"Coda:400,800",
			"Codystar"=>"Codystar",
			"Codystar:300,400"=>"Codystar (plus all weights)",
			"Comfortaa"=>"Comfortaa",
			"Comfortaa:300,400,700"=>"Comfortaa (plus book and bold)",
			"Coming Soon"=>"Coming Soon",
			"Concert One"=>"Concert One",
			"Condiment"=>"Condiment",
			"Contrail One"=>"Contrail One",
			"Convergence"=>"Convergence",
			"Cookie"=>"Cookie",
			"Copse"=>"Copse",
			"Corben"=>"Corben",
			"Corben:400,bold"=>"Corben:400,bold",
			"Corben:bold"=>"Corben Bold",
			"Cousine"=>"Cousine",
			"Cousine:regular,italic,bold,bolditalic"=>"Cousine (plus italic, bold, and bold italic)",
			"Coustard"=>"Coustard",
			"Coustard:400,900"=>"Coustard (plus ultra bold)",
			"Covered By Your Grace"=>"Covered By Your Grace",
			"Crafty Girls"=>"Crafty Girls",
			"Creepster"=>"Creepster",
			"Crete Round"=>"Crete Round",
			"Crete Round:400,400italic"=>"Crete Round:400,400italic",
			"Crimson Text"=>"Crimson Text",
			"Crushed"=>"Crushed",
			"Cuprum"=>"Cuprum",
			"Cutive"=>"Cutive",
			"Damion"=>"Damion",
			"Dancing Script"=>"Dancing Script",
			"Dawning of a New Day"=>"Dawning of a New Day",
			"Days One"=>"Days One",
			"Delius Swash Caps"=>"Delius Swash Caps",
			"Delius Unicase"=>"Delius Unicase",
			"Delius"=>"Delius",
			"Devonshire"=>"Devonshire",
			"Didact Gothic"=>"Didact Gothic",
			"Diplomata SC"=>"Diplomata SC",
			"Diplomata"=>"Diplomata",
			"Doppio One"=>"Doppio One",
			"Dorsa"=>"Dorsa",
			"Dr Sugiyama"=>"Dr Sugiyama",
			"Droid Sans Mono"=>"Droid Sans Mono",
			"Droid Sans"=>"Droid Sans",
			"Droid Sans:regular,bold"=>"Droid Sans (plus bold)",
			"Droid Serif"=>"Droid Serif",
			"Droid Serif:regular,italic,bold,bolditalic"=>"Droid Serif (plus italic, bold, and bold italic)",
			"Duru Sans"=>"Duru Sans",
			"Dynalight"=>"Dynalight",
			"EB Garamond"=>"EB Garamond",
			"Eater"=>"Eater",
			"Economica"=>"Economica",
			"Economica:400,400italic,700,700italic"=>"Economica (plus all weights and italics)",
			"Electrolize"=>"Electrolize",
			"Emblema One"=>"Emblema One",
			"Emilys Candy"=>"Emilys Candy",
			"Engagement"=>"Engagement",
			"Enriqueta"=>"Enriqueta",
			"Enriqueta:400,700"=>"Enriqueta:400,700",
			"Erica One"=>"Erica One",
			"Esteban"=>"Esteban",
			"Euphoria Script"=>"Euphoria Script",
			"Ewert"=>"Ewert",
			"Exo"=>"Exo",
			"Exo:100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic"=>"Exo (plus all weights and italics)",
			"Expletus Sans"=>"Expletus Sans",
			"Expletus Sans:regular,500,600,bold"=>"Expletus Sans (plus 500, 600, and bold)",
			"Fanwood Text"=>"Fanwood Text",
			"Fanwood Text:400,400italic"=>"Fanwood Text (plus italic)",
			"Fascinate Inline"=>"Fascinate Inline",
			"Fascinate"=>"Fascinate",
			"Federant"=>"Federant",
			"Federo"=>"Federo",
			"Felipa"=>"Felipa",
			"Fjord One"=>"Fjord One",
			"Flamenco"=>"Flamenco",
			"Flamenco:300"=>"Flamenco:300",
			"Flavors"=>"Flavors",
			"Fondamento"=>"Fondamento",
			"Fondamento:400,400italic"=>"Fondamento:400,400italic",
			"Fontdiner Swanky"=>"Fontdiner Swanky",
			"Forum"=>"Forum",
			"Francois One"=>"Francois One",
			"Fredoka One"=>"Fredoka One",
			"Fresca"=>"Fresca",
			"Frijole"=>"Frijole",
			"Fugaz One"=>"Fugaz One",
			"Galdeano"=>"Galdeano",
			"Gentium Basic"=>"Gentium Basic",
			"Gentium Basic:400,700,400italic,700italic"=>"Gentium Basic (plus bold and italic)",
			"Gentium Book Basic"=>"Gentium Book Basic",
			"Gentium Book Basic:400,400italic,700,700italic"=>"Gentium Book Basic (plus bold and italic)",
			"Geo"=>"Geo",
			"Geostar Fill"=>"Geostar Fill",
			"Geostar"=>"Geostar",
			"Germania One"=>"Germania One",
			"Give You Glory"=>"Give You Glory",
			"Glass Antiqua"=>"Glass Antiqua",
			"Glegoo"=>"Glegoo",
			"Gloria Hallelujah"=>"Gloria Hallelujah",
			"Goblin One"=>"Goblin One",
			"Gochi Hand"=>"Gochi Hand",
			"Gochi Hand:400"=>"Gochi Hand:400",
			"Gorditas"=>"Gorditas",
			"Gorditas:400,bold"=>"Gorditas (plus bold)",
			"Goudy Bookletter 1911"=>"Goudy Bookletter 1911",
			"Graduate"=>"Graduate",
			"Gravitas One"=>"Gravitas One",
			"Gruppo"=>"Gruppo",
			"Gudea"=>"Gudea",
			"Gudea:400,italic,bold"=>"Gudea:400,italic,bold",
			"Habibi"=>"Habibi",
			"Hammersmith One"=>"Hammersmith One",
			"Handlee"=>"Handlee",
			"Happy Monkey"=>"Happy Monkey",
			"Henny Penny"=>"Henny Penny",
			"Herr Von Muellerhoff"=>"Herr Von Muellerhoff",
			"Holtwood One SC"=>"Holtwood One SC",
			"Homemade Apple"=>"Homemade Apple",
			"Homenaje"=>"Homenaje",
			"IM Fell DW Pica SC"=>"IM Fell DW Pica SC",
			"IM Fell DW Pica"=>"IM Fell DW Pica",
			"IM Fell DW Pica:regular,italic"=>"IM Fell DW Pica (plus italic)",
			"IM Fell Double Pica SC"=>"IM Fell Double Pica SC",
			"IM Fell Double Pica"=>"IM Fell Double Pica",
			"IM Fell Double Pica:regular,italic"=>"IM Fell Double Pica (plus italic)",
			"IM Fell English SC"=>"IM Fell English SC",
			"IM Fell English"=>"IM Fell English",
			"IM Fell English:regular,italic"=>"IM Fell English (plus italic)",
			"IM Fell French Canon SC"=>"IM Fell French Canon SC",
			"IM Fell French Canon"=>"IM Fell French Canon",
			"IM Fell French Canon:regular,italic"=>"IM Fell French Canon (plus italic)",
			"IM Fell Great Primer SC"=>"IM Fell Great Primer SC",
			"IM Fell Great Primer"=>"IM Fell Great Primer",
			"IM Fell Great Primer:regular,italic"=>"IM Fell Great Primer (plus italic)",
			"Iceberg"=>"Iceberg",
			"Iceland"=>"Iceland",
			"Imprima"=>"Imprima",
			"Inconsolata"=>"Inconsolata",
			"Inder"=>"Inder",
			"Indie Flower"=>"Indie Flower",
			"Inika"=>"Inika",
			"Inika:400,bold"=>"Inika (plus bold)",
			"Irish Grover"=>"Irish Grover",
			"Irish Growler"=>"Irish Growler",
			"Istok Web"=>"Istok Web",
			"Istok Web:400,700,400italic,700italic"=>"Istok Web (plus italic, bold, and bold italic)",
			"Italiana"=>"Italiana",
			"Italianno"=>"Italianno",
			"Jim Nightshade"=>"Jim Nightshade",
			"Jockey One"=>"Jockey One",
			"Jolly Lodger"=>"Jolly Lodger",
			"Josefin Sans"=>"Josefin Sans Regular 400",
			"Josefin Sans:100"=>"Josefin Sans 100",
			"Josefin Sans:100,100italic"=>"Josefin Sans 100 (plus italic)",
			"Josefin Sans:600"=>"Josefin Sans 600",
			"Josefin Sans:600,600italic"=>"Josefin Sans 600 (plus italic)",
			"Josefin Sans:bold"=>"Josefin Sans Bold 700",
			"Josefin Sans:bold,bolditalic"=>"Josefin Sans Bold 700 (plus italic)",
			"Josefin Sans:light"=>"Josefin Sans Light 300",
			"Josefin Sans:light,lightitalic"=>"Josefin Sans Light 300 (plus italic)",
			"Josefin Sans:regular,regularitalic"=>"Josefin Sans Regular 400 (plus italic)",
			"Josefin Slab"=>"Josefin Slab Regular 400",
			"Josefin Slab:100"=>"Josefin Slab 100",
			"Josefin Slab:100,100italic"=>"Josefin Slab 100 (plus italic)",
			"Josefin Slab:600"=>"Josefin Slab 600",
			"Josefin Slab:600,600italic"=>"Josefin Slab 600 (plus italic)",
			"Josefin Slab:bold"=>"Josefin Slab Bold 700",
			"Josefin Slab:bold,bolditalic"=>"Josefin Slab Bold 700 (plus italic)",
			"Josefin Slab:light"=>"Josefin Slab Light 300",
			"Josefin Slab:light,lightitalic"=>"Josefin Slab Light 300 (plus italic)",
			"Josefin Slab:regular,regularitalic"=>"Josefin Slab Regular 400 (plus italic)",
			"Judson"=>"Judson",
			"Judson:regular,regularitalic,bold"=>"Judson (plus bold)",
			"Julee"=>"Julee",
			"Junge"=>"Junge",
			"Jura"=>" Jura Regular",
			"Jura:500"=>" Jura 500",
			"Jura:600"=>" Jura 600",
			"Jura:light"=>" Jura Light",
			"Just Another Hand"=>"Just Another Hand",
			"Just Me Again Down Here"=>"Just Me Again Down Here",
			"Kameron"=>"Kameron",
			"Kameron:400,700"=>"Kameron (plus bold)",
			"Karla"=>"Karla",
			"Karla:400,400italic,700,700italic"=>"Karla (plus all weights and italics)",
			"Kaushan Script"=>"Kaushan Script",
			"Kelly Slab"=>"Kelly Slab",
			"Kenia"=>"Kenia",
			"Knewave"=>"Knewave",
			"Kotta One"=>"Kotta One",
			"Kranky"=>"Kranky",
			"Kreon"=>"Kreon",
			"Kreon:light,regular,bold"=>"Kreon (plus light and bold)",
			"Kristi"=>"Kristi",
			"Krona One"=>"Krona One",
			"La Belle Aurore"=>"La Belle Aurore",
			"Lancelot"=>"Lancelot",
			"Lato:100"=>"Lato 100",
			"Lato:100,100italic"=>"Lato 100 (plus italic)",
			"Lato:900"=>"Lato 900",
			"Lato:900,900italic"=>"Lato 900 (plus italic)",
			"Lato:bold"=>"Lato Bold 700",
			"Lato:bold,bolditalic"=>"Lato Bold 700 (plus italic)",
			"Lato:light"=>"Lato Light 300",
			"Lato:light,lightitalic"=>"Lato Light 300 (plus italic)",
			"Lato:regular"=>"Lato Regular 400",
			"Lato:regular,regularitalic"=>"Lato Regular 400 (plus italic)",
			"League Script"=>"League Script",
			"Leckerli One"=>"Leckerli One",
			"Ledger"=>"Ledger",
			"Lekton"=>" Lekton",
			"Lekton:regular,italic,bold"=>"Lekton (plus italic and bold)",
			"Lemon"=>"Lemon",
			"Lilita One"=>"Lilita One",
			"Limelight"=>" Limelight",
			"Linden Hill"=>"Linden Hill",
			"Linden Hill:400,400italic"=>"Linden Hill:400,400italic",
			"Lobster Two"=>"Lobster Two",
			"Lobster Two:400,400italic,700,700italic"=>"Lobster Two (plus italic, bold, and bold italic)",
			"Lobster"=>"Lobster",
			"Londrina Outline"=>"Londrina Outline",
			"Londrina Shadow"=>"Londrina Shadow",
			"Londrina Sketch"=>"Londrina Sketch",
			"Londrina Solid"=>"Londrina Solid",
			"Lora"=>"Lora",
			"Lora:400,700,400italic,700italic"=>"Lora (plus bold and italic)",
			"Love Ya Like A Sister"=>"Love Ya Like A Sister",
			"Loved by the King"=>"Loved by the King",
			"Luckiest Guy"=>"Luckiest Guy",
			"Lusitana"=>"Lusitana",
			"Lusitana:400,bold"=>"Lusitana (plus bold)",
			"Lustria"=>"Lustria",
			"Macondo Swash Caps"=>"Macondo Swash Caps",
			"Macondo"=>"Macondo",
			"Magra"=>"Magra",
			"Magra:400,bold"=>"Magra (plus bold)",
			"Maiden Orange"=>"Maiden Orange",
			"Mako"=>"Mako",
			"Marck Script"=>"Marck Script",
			"Marko One"=>"Marko One",
			"Marmelad"=>"Marmelad",
			"Marvel"=>"Marvel",
			"Marvel:400,400italic,700,700italic"=>"Marvel (plus bold and italic)",
			"Mate SC"=>"Mate SC",
			"Mate"=>"Mate",
			"Mate:400,400italic"=>"Mate:400,400italic",
			"Maven Pro"=>" Maven Pro",
			"Maven Pro:500"=>" Maven Pro 500",
			"Maven Pro:900"=>" Maven Pro 900",
			"Maven Pro:bold"=>" Maven Pro 700",
			"Meddon"=>"Meddon",
			"MedievalSharp"=>"MedievalSharp",
			"Medula One"=>"Medula One",
			"Megrim"=>"Megrim",
			"Merienda One"=>"Merienda One",
			"Merriweather"=>"Merriweather",
			"Metamorphous"=>"Metamorphous",
			"Metrophobic"=>"Metrophobic",
			"Michroma"=>"Michroma",
			"Miltonian Tattoo"=>"Miltonian Tattoo",
			"Miltonian"=>"Miltonian",
			"Miniver"=>"Miniver",
			"Miss Fajardose"=>"Miss Fajardose",
			"Miss Saint Delafield"=>"Miss Saint Delafield",
			"Modern Antiqua"=>"Modern Antiqua",
			"Molengo"=>"Molengo",
			"Monofett"=>"Monofett",
			"Monoton"=>"Monoton",
			"Monsieur La Doulaise"=>"Monsieur La Doulaise",
			"Montaga"=>"Montaga",
			"Montez"=>"Montez",
			"Montserrat"=>"Montserrat",
			"Mountains of Christmas"=>"Mountains of Christmas",
			"Mr Bedford"=>"Mr Bedford",
			"Mr Dafoe"=>"Mr Dafoe",
			"Mr De Haviland"=>"Mr De Haviland",
			"Mrs Saint Delafield"=>"Mrs Saint Delafield",
			"Mrs Sheppards"=>"Mrs Sheppards",
			"Muli"=>"Muli Regular",
			"Muli:light"=>"Muli Light",
			"Muli:light,lightitalic"=>"Muli Light (plus italic)",
			"Muli:regular,regularitalic"=>"Muli Regular (plus italic)",
			"Mystery Quest"=>"Mystery Quest",
			"Neucha"=>"Neucha",
			"Neuton"=>"Neuton",
			"News Cycle"=>"News Cycle",
			"Niconne"=>"Niconne",
			"Nixie One"=>"Nixie One",
			"Nobile"=>"Nobile",
			"Nobile:regular,italic,bold,bolditalic"=>"Nobile (plus italic, bold, and bold italic)",
			"Nokora"=>"Nokora",
			"Nokora:400,700"=>"Nokora:400,700",
			"Norican"=>"Norican",
			"Nosifer"=>"Nosifer",
			"Noticia Text"=>"Noticia Text",
			"Noticia Text:400,400italic,700,700italic"=>"Noticia Text:400,400italic,700,700italic",
			"Nova Cut"=>"Nova Cut",
			"Nova Flat"=>"Nova Flat",
			"Nova Mono"=>"Nova Mono",
			"Nova Oval"=>"Nova Oval",
			"Nova Round"=>"Nova Round",
			"Nova Script"=>"Nova Script",
			"Nova Slim"=>"Nova Slim",
			"Nova Square"=>"Nova Square",
			"Numans"=>"Numans",
			"Nunito"=>" Nunito Regular",
			"Nunito:light"=>" Nunito Light",
			"OFL Sorts Mill Goudy TT"=>"OFL Sorts Mill Goudy TT",
			"OFL Sorts Mill Goudy TT:regular,italic"=>"OFL Sorts Mill Goudy TT (plus italic)",
			"Old Standard TT"=>"Old Standard TT",
			"Old Standard TT:regular,italic,bold"=>"Old Standard TT (plus italic and bold)",
			"Oldenburg"=>"Oldenburg",
			"Open Sans Condensed"=>"Open Sans Condensed",
			"Open Sans Condensed:300,300italic,700"=>"Open Sans Condensed (plus all weights and italics)",
			"Open Sans Condensed:light,lightitalic"=>"Open Sans Condensed Light (plus italic)",
			"Open Sans:300,300italic"=>"Open Sans Book",
			"Open Sans:600,600italic"=>"Open Sans 600",
			"Open Sans:800,800italic"=>"Open Sans 800",
			"Open Sans:bold,bolditalic"=>"Open Sans bold",
			"Open Sans:light,lightitalic"=>"Open Sans light",
			"Open Sans:light,lightitalic,regular,regularitalic,600,600italic,bold,bolditalic,800,800italic"=>"Open Sans (all weights)",
			"Open Sans:regular,regularitalic"=>"Open Sans regular",
			"Orbitron"=>"Orbitron Regular (400)",
			"Orbitron:500"=>"Orbitron 500",
			"Orbitron:900"=>"Orbitron 900",
			"Orbitron:bold"=>"Orbitron Regular (700)",
			"Original Surfer"=>"Original Surfer",
			"Oswald"=>"Oswald",
			"Over the Rainbow"=>"Over the Rainbow",
			"Overlock SC"=>"Overlock SC",
			"Overlock"=>"Overlock",
			"Overlock:400,400italic,700,700italic,900,900italic"=>"Overlock:400,400italic,700,700italic,900,900italic",
			"Ovo"=>"Ovo",
			"Oxygen"=>"Oxygen",
			"PT Mono"=>"PT Mono",
			"PT Sans Caption"=>"PT Sans Caption",
			"PT Sans Caption:regular,bold"=>"PT Sans Caption (plus bold)",
			"PT Sans Narrow"=>"PT Sans Narrow",
			"PT Sans Narrow:regular,bold"=>"PT Sans Narrow (plus bold)",
			"PT Sans"=>"PT Sans",
			"PT Sans:regular,italic,bold,bolditalic"=>"PT Sans (plus itlic, bold, and bold italic)",
			"PT Serif Caption"=>"PT Serif Caption",
			"PT Serif Caption:regular,italic"=>"PT Serif Caption (plus italic)",
			"PT Serif"=>"PT Serif",
			"PT Serif:regular,italic,bold,bolditalic"=>"PT Serif (plus italic, bold, and bold italic)",
			"Pacifico"=>"Pacifico",
			"Parisienne"=>"Parisienne",
			"Passero One"=>"Passero One",
			"Passion One"=>"Passion One",
			"Passion One:400,700,900"=>"Passion One:400,700,900",
			"Patrick Hand"=>"Patrick Hand",
			"Patua One"=>"Patua One",
			"Paytone One"=>"Paytone One",
			"Permanent Marker"=>"Permanent Marker",
			"Petrona"=>"Petrona",
			"Philosopher"=>"Philosopher",
			"Piedra"=>"Piedra",
			"Pinyon Script"=>"Pinyon Script",
			"Plaster"=>"Plaster",
			"Play"=>"Play",
			"Play:regular,bold"=>"Play (plus bold)",
			"Playball"=>"Playball",
			"Playfair Display"=>" Playfair Display",
			"Podkova"=>" Podkova",
			"Poiret One"=>"Poiret One",
			"Poller One"=>"Poller One",
			"Poly"=>"Poly",
			"Poly:400,400italic"=>"Poly:400,400italic",
			"Pompiere"=>"Pompiere",
			"Pontano Sans"=>"Pontano Sans",
			"Port Lligat Sans"=>"Port Lligat Sans",
			"Port Lligat Slab"=>"Port Lligat Slab",
			"Prata"=>"Prata",
			"Princess Sofia"=>"Princess Sofia",
			"Prociono"=>"Prociono",
			"Prosto One"=>"Prosto One",
			"Puritan"=>"Puritan",
			"Puritan:regular,italic,bold,bolditalic"=>"Puritan (plus italic, bold, and bold italic)",
			"Quando"=>"Quando",
			"Quantico"=>"Quantico",
			"Quantico:400,400italic,700,700italic"=>"Quantico:400,400italic,700,700italic",
			"Quattrocento Sans"=>"Quattrocento Sans",
			"Quattrocento"=>"Quattrocento",
			"Questrial"=>"Questrial",
			"Quicksand"=>"Quicksand",
			"Quicksand:300,400,700"=>"Quicksand:300,400,700",
			"Qwigley"=>"Qwigley",
			"Radley"=>"Radley",
			"Raleway:300,400,700"=>"Raleway:300,400,700",
			"Rammetto One"=>"Rammetto One",
			"Rancho"=>"Rancho",
			"Rationale"=>"Rationale",
			"Redressed"=>"Redressed",
			"Reenie Beanie"=>"Reenie Beanie",
			"Revalia"=>"Revalia",
			"Ribeye Marrow"=>"Ribeye Marrow",
			"Ribeye"=>"Ribeye",
			"Righteous"=>"Righteous",
			"Rochester"=>"Rochester",
			"Rock Salt"=>"Rock Salt",
			"Rokkitt"=>"Rokkitt",
			"Ropa Sans"=>"Ropa Sans",
			"Ropa Sans:400,400italic"=>"Ropa Sans (plus italics)",
			"Rosario"=>"Rosario",
			"Rouge Script"=>"Rouge Script",
			"Ruda"=>"Ruda",
			"Ruda:400,bold,900"=>"Ruda (plus all bold and 900)",
			"Ruge Boogie"=>"Ruge Boogie",
			"Ruluko"=>"Ruluko",
			"Ruslan Display"=>"Ruslan Display",
			"Ruthie"=>"Ruthie",
			"Sail"=>"Sail",
			"Salsa"=>"Salsa",
			"Sancreek"=>"Sancreek",
			"Sansita One"=>"Sansita One",
			"Sarina"=>"Sarina",
			"Satisfy"=>"Satisfy",
			"Scada"=>"Scada",
			"Schoolbell"=>"Schoolbell",
			"Seaweed Script"=>"Seaweed Script",
			"Sevillana"=>"Sevillana",
			"Shadows Into Light Two"=>"Shadows Into Light Two",
			"Shadows Into Light"=>"Shadows Into Light",
			"Shanti"=>"Shanti",
			"Share"=>"Share",
			"Share:400,400italic,700,700italic"=>"Share (plus all weights and italics)",
			"Shojumaru"=>"Shojumaru",
			"Short Stack"=>"Short Stack",
			"Sigmar One"=>"Sigmar One",
			"Signika Negative"=>"Signika Negative",
			"Signika Negative:300,400,600,700"=>"Signika Negative:300,400,600,700",
			"Signika"=>"Signika",
			"Signika:300,400,600,700"=>"Signika:300,400,600,700",
			"Simonetta"=>"Simonetta",
			"Simonetta:400,400italic"=>"Simonetta (plus italic)",
			"Sirin Stencil"=>"Sirin Stencil",
			"Six Caps"=>"Six Caps",
			"Slackey"=>"Slackey",
			"Smokum"=>"Smokum",
			"Smythe"=>"Smythe",
			"Sniglet:800"=>"Sniglet",
			"Snippet"=>"Snippet",
			"Sofia"=>"Sofia",
			"Sonsie One"=>"Sonsie One",
			"Sorts Mill Goudy"=>"Sorts Mill Goudy",
			"Sorts Mill Goudy:400,400italic"=>"Sorts Mill Goudy (plus italic)",
			"Special Elite"=>"Special Elite",
			"Spicy Rice"=>"Spicy Rice",
			"Spinnaker"=>"Spinnaker",
			"Spirax"=>"Spirax",
			"Squada One"=>"Squada One",
			"Stardos Stencil"=>"Stardos Stencil",
			"Stardos Stencil:400,700"=>"Stardos Stencil (plus bold)",
			"Stint Ultra Condensed"=>"Stint Ultra Condensed",
			"Stint Ultra Expanded"=>"Stint Ultra Expanded",
			"Stoke"=>"Stoke",
			"Sue Ellen Francisco"=>"Sue Ellen Francisco",
			"Sunshiney"=>"Sunshiney",
			"Supermercado One"=>"Supermercado One",
			"Swanky and Moo Moo"=>"Swanky and Moo Moo",
			"Syncopate"=>"Syncopate",
			"Tangerine"=>"Tangerine",
			"Telex"=>"Telex",
			"Tenor Sans"=>" Tenor Sans",
			"Terminal Dosis Light"=>"Terminal Dosis Light",
			"Terminal Dosis"=>"Terminal Dosis Regular",
			"Terminal Dosis:200"=>"Terminal Dosis 200",
			"Terminal Dosis:300"=>"Terminal Dosis 300",
			"Terminal Dosis:500"=>"Terminal Dosis 500",
			"Terminal Dosis:600"=>"Terminal Dosis 600",
			"Terminal Dosis:700"=>"Terminal Dosis 700",
			"Terminal Dosis:800"=>"Terminal Dosis 800",
			"The Girl Next Door"=>"The Girl Next Door",
			"Tinos"=>"Tinos",
			"Tinos:regular,italic,bold,bolditalic"=>"Tinos (plus italic, bold, and bold italic)",
			"Titan One"=>"Titan One",
			"Trade Winds"=>"Trade Winds",
			"Trochut"=>"Trochut",
			"Trochut:400,italic,bold"=>"Trochut (plus bold and italic)",
			"Trykker"=>"Trykker",
			"Tulpen One"=>"Tulpen One",
			"Ubuntu Condensed"=>"Ubuntu Condensed",
			"Ubuntu Mono"=>"Ubuntu Mono",
			"Ubuntu Mono:regular,italic,bold,bolditalic"=>"Ubuntu Mono:regular,italic,bold,bolditalic",
			"Ubuntu"=>"Ubuntu",
			"Ubuntu:regular,italic,bold,bolditalic"=>"Ubuntu (plus italic, bold, and bold italic)",
			"Ultra"=>"Ultra",
			"Uncial Antiqua"=>"Uncial Antiqua",
			"UnifrakturCook:bold"=>"UnifrakturCook",
			"UnifrakturMaguntia"=>"UnifrakturMaguntia",
			"Unkempt"=>"Unkempt",
			"Unlock"=>"Unlock",
			"Unna"=>"Unna",
			"VT323"=>"VT323",
			"Varela Round"=>"Varela Round",
			"Varela"=>"Varela",
			"Vast Shadow"=>"Vast Shadow",
			"Vibur"=>"Vibur",
			"Vidaloka"=>"Vidaloka",
			"Viga"=>"Viga",
			"Voces"=>"Voces",
			"Volkhov"=>"Volkhov",
			"Volkhov:400,400italic,700,700italic"=>"Volkhov (plus bold and italic)",
			"Vollkorn"=>"Vollkorn",
			"Vollkorn:regular,italic,bold,bolditalic"=>"Vollkorn (plus italic, bold, and bold italic)",
			"Voltaire"=>"Voltaire",
			"Waiting for the Sunrise"=>"Waiting for the Sunrise",
			"Wallpoet"=>"Wallpoet",
			"Walter Turncoat"=>"Walter Turncoat",
			"Wellfleet"=>"Wellfleet",
			"Wire One"=>"Wire One",
			"Yanone Kaffeesatz"=>"Yanone Kaffeesatz",
			"Yanone Kaffeesatz:300"=>"Yanone Kaffeesatz:300",
			"Yanone Kaffeesatz:400"=>"Yanone Kaffeesatz:400",
			"Yanone Kaffeesatz:700"=>"Yanone Kaffeesatz:700",
			"Yellowtail"=>"Yellowtail",
			"Yeseva One"=>"Yeseva One",
			"Yesteryear"=>"Yesteryear",
			"Zeyada"=>"Zeyada",
		);
	}
	function wt_googlefonts_getfontname($font){
		$fonts = wt_googlefonts_getfonts();
		if(array_key_exists($font,$fonts)){
			return $fonts[$font];
		}else{
			return false;
		}
	}
}

/**
 * Font Face
 */
 
if(isset($_GET['page']) && $_GET['page']=='fonts'){
	if (! function_exists("font_face_getfonts")){
		function font_face_getfonts(){
			$fonts = array();
			$dirs = array_filter(glob(THEME_FONTFACE_DIR.'/*'), 'is_dir');
			
			foreach($dirs as $dir){
				$stylesheet = $dir.'/stylesheet.css';
				if(file_exists($stylesheet)){
					$file_content = file_get_contents($stylesheet);
					if( preg_match_all("/@font-face\s*{.*?font-family\s*:\s*('|\")(.*?)\\1.*?}/is", $file_content, $matchs) ){
						foreach($matchs[0] as $index => $css){
							$font_folder = basename($dir);
							$fonts[$font_folder.'|'.$matchs[2][$index]] = array(
								'folder' => $font_folder,
								'name' => $matchs[2][$index],
								'css' => $css,
							);
						}
						
					}
				}
			}
			return $fonts;
		}
	}
	
	if (! function_exists("font_face_add_head")){
		function font_face_add_head(){
			$fonts = font_face_getfonts();
			
			global $count;
			$count = 1;
			
			$style = "<style type='text/css'>\n";
			foreach($fonts as $value => $font){
				wp_enqueue_style('font|'.$value , THEME_FONTFACE_URI . '/'.$font['folder'].'/stylesheet.css');
				$style .= "#preview-".$count."{\n\tfont-family:".$font['name'].";\n}\n";
				$count ++;
			}
			
			$style .= "</style>";
			echo $style;
			
			wp_enqueue_script( 'ZeroClipboard', THEME_ADMIN_ASSETS_URI .'/js/ZeroClipboard.js');
			do_action('admin_enqueue_scripts');
			$scripts = "<script type='text/javascript'>\njQuery(document).ready(function($) {\n";
			$scripts .= "ZeroClipboard.setMoviePath('".THEME_ADMIN_ASSETS_URI."/js/ZeroClipboard.swf');\njQuery('.fontface_font_name').each(function(){\nvar clip = new ZeroClipboard.Client();\nclip.setText(jQuery(this).text());\nclip.glue(this,jQuery(this).parent('.font_name_wrap')[0]);\n});";
			echo $scripts."});\n</script>";
		}
		add_filter('admin_head', 'font_face_add_head');
	}
}
if (! function_exists("wt_font_face_fonts_option")) {
	function wt_font_face_fonts_option($value, $default) {
		$fonts = font_face_getfonts();
		echo '<tr colspan="2"><td style="padding:0"><table class="widefat fontface_table" cellspacing="0"><tbody>';
		
		global $count;
		$count = 1;
		
		foreach($fonts as $value => $font){
			if(is_array($default)){
				$checked = in_array($value,$default)?' checked="checked"':'';
			}else{
				$checked = '';
			}
			
			echo '<tr><td style="width:15%"><div class="font_name_wrap" style="position: relative;"><a class="fontface_font_name" href="#" title="'.$font['name'].'">'.$font['name'].'</a></div></td><td style="width:10%"><input type="checkbox" name="fonts[]" class="toggle-button" value="'.$value.'"'.$checked.'/></td><td><span class="fontface_preview" id="preview-'.$count.'">This is a preview of the <span style="color:  #379BFF;">'.$font['name'].'</span> font. Some numbers: 0123456789 &amp; so on..</span></td></tr>';
			$count ++;
		}
		echo '</tbody></table></td></tr>';
	}
}

/**
 * Cufon Fonts
 */
 
if (! function_exists("cufon_get_fonts")){
	function cufon_get_fonts(){
		$cufonfonts = array();
		foreach(glob(THEME_FONT_DIR."/*.js") as $font_file){
			$file_content = file_get_contents($font_file);
			if(preg_match('/font-family":"(.*?)"/i',$file_content,$match)){
				$cufonfonts[$match[1]] = basename($font_file);
			}
		}
		return $cufonfonts;
	}
}
if(isset($_GET['page']) && $_GET['page']=='fonts'){
	if (! function_exists("cufon_add_script_option")){
		function cufon_add_script_option(){
			wp_enqueue_script( 'cufon-yui', THEME_JS .'/vendor/cufon-yui.js');
			wp_enqueue_script( 'ZeroClipboard', THEME_ADMIN_ASSETS_URI .'/js/ZeroClipboard.js');
			$cufon_scripts = "<script type='text/javascript'>\njQuery(document).ready(function($) {\n";
			
			global $count;
			//$count = 1;
			
			foreach(cufon_get_fonts() as $font_name => $file_name){
				wp_enqueue_script( $font_name, THEME_FONT_URI .'/'.$file_name);
				$cufon_scripts .= stripslashes("Cufon('#preview-$count', { fontFamily: '$font_name' });\n");
				$count ++;
			}
			do_action('admin_enqueue_scripts');
			$cufon_scripts .= "ZeroClipboard.setMoviePath('".THEME_ADMIN_ASSETS_URI."/js/ZeroClipboard.swf');\njQuery('.cufon_font_name').each(function(){\nvar clip = new ZeroClipboard.Client();\nclip.setText(jQuery(this).text());\nclip.glue(this,jQuery(this).parent('.font_name_wrap')[0]);\n});";
			echo $cufon_scripts."});\n</script>";
		}
		add_filter('admin_head', 'cufon_add_script_option');
	}
}
if (! function_exists("wt_cufon_fonts_option")) {
	function wt_cufon_fonts_option($value, $default) {
		echo '<tr colspan="2"><td style="padding:0"><table class="widefat cufon_table" cellspacing="0"><tbody>';
		
		global $count;
		//$count = 1;
		
		foreach(cufon_get_fonts() as $font_name => $file_name){
			if(is_array($default)){
				$checked = in_array($file_name,$default)?' checked="checked"':'';
			}else{
				$checked = '';
			}
			echo '<tr><td style="width:15%"><div class="font_name_wrap" style="position: relative;"><a class="cufon_font_name" href="#" title="'.$file_name.'">'.$font_name.'</a></div></td><td style="width:10%"><input type="checkbox" name="cufonfonts[]" class="toggle-button" value="'.$file_name.'"'.$checked.'/></td><td><span class="cufon_preview" id="preview-'.$count.'">This is a preview of the <span style="color:  #00438E;">'.$font_name.'</span> font.</span></td></tr>';
			$count ++;
		}
		echo '</tbody></table></td></tr>';
	}
}

$wt_options = array(
	array(
		"class" => "nav-tab-wrapper",
		"default" => '',
		"options" => array(
			"font_size" => __('Font Size','wt_admin'),
			"google_fonts" => __('Google Fonts','wt_admin'),
			"font_face" => __('Font Face','wt_admin'),
			"cufon_fonts" => __('Cufon Fonts','wt_admin'),
		),
		"type" => "wt_navigation",
	),
	
	array(
		"type" => "wt_group_start",
		"group_id" => "font_size",
	),
	
		array(
			"name" => __("Font General",'wt_admin'),
			"type" => "wt_open"
		),
		array(
			"name" => __("Font Family",'wt_admin'),
			"desc" => 'Choose the font-family you want to use on your site.',
			"id" => "font_family",
			"default" => '"Helvetica Neue", Helvetica, Arial, sans-serif;',
			"options" => array(
				'"Helvetica Neue", Helvetica, Arial, sans-serif;' => '"Helvetica Neue", Helvetica, Arial, sans-serif;',
				'"Arial Black",Gadget,sans-serif' => '"Arial Black",Gadget,sans-serif',
				'Verdana,Geneva,Kalimati,sans-serif' => 'Verdana,Geneva,Kalimati,sans-serif',
				'"Lucida Sans Unicode","Lucida Grande","Droid Sans",sans-serif' => '"Lucida Sans Unicode","Lucida Grande","Droid Sans",sans-serif',
				'Georgia,"Nimbus Roman No9 L",serif' => 'Georgia,"Nimbus Roman No9 L",serif',
				'"Palatino Linotype","Book Antiqua",Palatino,FreeSerif,serif' => '"Palatino Linotype","Book Antiqua",Palatino,FreeSerif,serif',
				'Tahoma,Geneva,Kalimati,sans-serif' => 'Tahoma,Geneva,Kalimati,sans-serif',
				'"Times New Roman",Times,FreeSerif,serif' => '"Times New Roman",Times,FreeSerif,serif',
				'"Trebuchet MS",Helvetica,Jamrul,sans-serif' => '"Trebuchet MS",Helvetica,Jamrul,sans-serif',
			),
			"type" => "wt_select",
		),
		array(
			"name" => __("Page Text Size",'wt_admin'),
			"id" => "content_page",
			"min" => "1",
			"max" => "60",
			"step" => "0.5",
			"unit" => 'px',
			"default" => "14",
			"type" => "wt_range"
		),
		array(
			"type" => "wt_close"
		),
		array(
			"type" => "wt_reset"
		),
		array(
			"name" => __("Font Size",'wt_admin'),
			"type" => "wt_open"
		),
		array(
			"name" => __("Logo Text Size",'wt_admin'),
			"id" => "logo_size",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "26",
			"type" => "wt_range"
		),
		array(
			"name" => __("Logo Description Size",'wt_admin'),
			"id" => "logo_size_desc",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "12",
			"type" => "wt_range"
		),
		array(
			"name" => __("Top Level Menu Text Size",'wt_admin'),
			"id" => "menu_top",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "14",
			"type" => "wt_range"
		),
		array(
			"name" => __("Sub Level Menu Text Size",'wt_admin'),
			"id" => "menu_sub",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "13",
			"type" => "wt_range"
		),
		array(
			"name" => sprintf(__("%s Size",'wt_admin'),'H1'),
			"id" => "content_h1",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "36",
			"type" => "wt_range"
		),
		array(
			"name" => sprintf(__("%s Size",'wt_admin'),'H2'),
			"id" => "content_h2",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "30",
			"type" => "wt_range"
		),
		array(
			"name" =>  sprintf(__("%s Size",'wt_admin'),'H3'),
			"id" => "content_h3",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "24",
			"type" => "wt_range"
		),
		array(
			"name" =>  sprintf(__("%s Size",'wt_admin'),'H4'),
			"id" => "content_h4",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "18",
			"type" => "wt_range"
		),
		array(
			"name" =>  sprintf(__("%s Size",'wt_admin'),'H5'),
			"id" => "content_h5",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "14",
			"type" => "wt_range"
		),
		array(
			"name" =>  sprintf(__("%s Size",'wt_admin'),'H6'),
			"id" => "content_h6",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "12",
			"type" => "wt_range"
		),
		array(
			"name" => __("Sidebar Widget Title",'wt_admin'),
			"id" => "sidebar_widget_title",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "18",
			"type" => "wt_range"
		),
		/*array(
			"name" => __("Intro Header Title Size",'wt_admin'),
			"id" => "description_title",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "40",
			"type" => "wt_range"
		),
		array(
			"name" => __("Intro Header Text Size",'wt_admin'),
			"id" => "description_text",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "24",
			"type" => "wt_range"
		),*/
		array(
			"name" => __("Footer Text",'wt_admin'),
			"id" => "footer_text",
			"min" => "1",
			"max" => "60",
			"step" => "0.5",
			"unit" => 'px',
			"default" => "13.5",
			"type" => "wt_range"
		),
		array(
			"name" => __("Footer Widget Title",'wt_admin'),
			"id" => "footer_title",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "18",
			"type" => "wt_range"
		),
		array(
			"name" => __("Copyright Text Size",'wt_admin'),
			"id" => "copyright",
			"min" => "1",
			"max" => "60",
			"step" => "0.5",
			"unit" => 'px',
			"default" => "14",
			"type" => "wt_range"
		),
		/*array(
			"name" => __("Footer Menu Text Size",'wt_admin'),
			"id" => "footer_menu",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "12",
			"type" => "wt_range"
		),
		array(
			"name" => __("Footer Bottom Menu Text Size",'wt_admin'),
			"id" => "footer_bottom_menu",
			"min" => "1",
			"max" => "60",
			"step" => "1",
			"unit" => 'px',
			"default" => "12",
			"type" => "wt_range"
		),*/
		array(
			"type" => "wt_close"
		),
		array(
			"type" => "wt_reset"
		),
	
	array(
		"type" => "wt_group_end",
	),	
	
	array(
		"type" => "wt_group_start",
		"group_id" => "google_fonts",
	),
	
		array(
			"name" => __("Google Fonts",'wt_admin'),
			"type" => "wt_open"
		),
			array(
				"name" => __("Enable Google Fonts",'wt_admin'),
				"id" => "enable_googlefonts",
				"default" => true,
				"type" => "wt_toggle"
			),
			array(
				"name" => __("Google Fonts",'wt_admin'),
				"desc" => __('Go to <a href="http://www.google.com/webfonts" target="_blank">Google webfonts library</a> to choose the fonts. In order to select a font you should click on it.','wt_admin'),
				"id" => "used_googlefonts",
				"default" => array('Lato:light,lightitalic','Lato:light','Lato:regular','Lato:regular,regularitalic','Lato:900', 'Lato:bold,bolditalic'),
				"prompt" => __("Choose google font...","wt_admin"),
				"chosen" => "true",
				"type" => "wt_multiselect",
				"options"=> wt_googlefonts_getfonts(),
			),
			array(
				"name" => __("Google Fonts Custom CSS",'wt_admin'),
				"desc" => __('sample:<p><code>h1,h2,h3,h4,h5 { font-family: Droid Sans; }</code>.</p> You should use this option if there are more google fonts selected.','wt_admin'),
				"id" => "gfonts_code",
				"default" => 
'
h1, h2, h3, h4, h5, h6, #nav.wt_nav_top .navbar-nav > li > a, .wt_counter_sc .stat-count, .wt_counter_sc .wt_stat_detail, .wt_testimonial_content, .wt_google_font, .wt_pricing_content, .btn-theme, .copyright, .wt_portfolioCategory {
	font-family: \'Lato\';
}
',
				"rows" => '8',
				"type" => "wt_textarea"
			),
		array(
			"type" => "wt_close"
		),
		array(
			"type" => "wt_reset"
		),
		
	array(
		"type" => "wt_group_end",
	),
	
	array(
		"type" => "wt_group_start",
		"group_id" => "font_face",
	),
	
		array(
			"name" => __("@font-face General",'wt_admin'),
			"type" => "wt_open"
		),
			array(
				"name" => __("Enable @font-face",'wt_admin'),
				"id" => "enable_fontface",
				"default" => false,
				"type" => "wt_toggle"
			),
			array(
				"name" => __("@font-face Custom CSS",'wt_admin'),
				"desc" => __('sample:<p><code>h1,h2,h3,h4,h5 { font-family:CuprumFFURegular; }</code></p>','wt_admin'),
				"id" => "fontface_code",
				"default" => "",
				"rows" => '8',
				"type" => "wt_textarea"
			),
		array(
			"type" => "wt_close"
		),
		array(
			"type" => "wt_reset"
		),
		array(
			"name" => sprintf(__('Fonts located in "%s"','wt_admin'),'<code>'.str_replace( WP_CONTENT_DIR, '', THEME_FONTFACE_DIR ).'</code>'),
			"type" => "wt_open"
		),
			array(
				"id" => "fonts",
				"layout" => false,
				"function" => "wt_font_face_fonts_option",
				"default" => array(),
				//"default" => array('Bebas-neue|bebasneueregular', 'roboto|robotothin', 'roboto|robotoregular'),
				"type" => "wt_custom"
			),
		array(
			"type" => "wt_close"
		),
		array(
			"type" => "wt_reset"
		),
		
	array(
		"type" => "wt_group_end",
	),
	
	array(
		"type" => "wt_group_start",
		"group_id" => "cufon_fonts",
	),
	
		array(
			"name" => __("Cufón Fonts",'wt_admin'),
			"type" => "wt_open"
		),
			array(
				"name" => __("Enable Cufon",'wt_admin'),
				"id" => "enable_cufon",
				"default" => false,
				"type" => "wt_toggle"
			),
			array(
				"name" => __("Cufon Code",'wt_admin'),
				"desc" => __('Cufon samples:<br />Cufon.replace("h1,h2,h3", {fontFamily : "Segan"});<br />Cufon.replace(".cufon-gradient-shadow", { color: "-linear-gradient(blue, yellow)", textShadow: "2px 2px #C0C0C0" });<br />For more examples, go to official <a href="http://wiki.github.com/sorccu/cufon/styling">Cufon\'s site</a>','wt_admin'),
				"id" => "cufon_code",
				"default" => '',
				"rows" => '8',
				"type" => "wt_textarea"
			),
		array(
			"type" => "wt_close"
		),
		array(
			"name" => sprintf(__('Fonts located in "%s"','wt_admin'),'<code>'.str_replace( WP_CONTENT_DIR, '', THEME_FONT_DIR ).'</code>'),
			"type" => "wt_open"
		),
			array(
				"id" => "cufonfonts",
				"layout" => false,
				"function" => "wt_cufon_fonts_option",
				"default" => '',
				"type" => "wt_custom"
			),
		array(
			"type" => "wt_close"
		),	
		
	array(
		"type" => "wt_group_end",
	),
);
return array(
	'auto' => true,
	'name' => 'fonts',
	'options' => $wt_options
);