<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
if (!class_exists('Redux_Validation_font_load')) {

	class Redux_Validation_font_load {
		/* @var $parent ReduxFramework */

		public $parent;
		public $value;
		public $current;
		/* @var $inst ReduxFramework_extension_custom_font */
		private $inst;
		public static $valid_helper;
		public $count;

		/**
		 * Field Constructor.
		 * Required - must call the parent constructor, then assign field and value to vars, and obviously call the render field function
		 *
		 */
		function __construct($parent, $field, &$value, $current) {

			if(!isset($value) || $value == '' || empty($value)) return;
			
			if(!isset($value['attachment_id']) || $value['attachment_id'] == '') return;

			$this->parent = $parent;
			$this->field = $field;
			$this->field['msg'] = ( isset($this->field['msg']) ) ? $this->field['msg'] : __('You must provide a numerical value for this option.', 'dfd');
			$this->current = $current;
			$this->inst = Custom_Font_Validator::getMainExtensition();
			$options = isset($this->parent->options[$this->field["id"]]) ? $this->parent->options[$this->field["id"]] : '';

			if (!empty($options) && isset($options[0]["attachment_id"]) && !empty($options[0]["attachment_id"])) {
				if ($value["attachment_id"] == "") {
					$this->field["msg"] = __("No attached file", 'dfd');
					$this->error = $this->field;
					unset($value);
				}
			}
			$this->value = $value;
			$this->validate();
		}

//function

		/**
		 * Field Render Function.
		 * Takes the vars and outputs the HTML for the field in the settings
		 *
		 */
		function validate() {

			if ($this->value["attachment_id"] == "13857" || $this->value["attachment_id"] == "13866") {
				
			} else {
//				die();
			}
			$field_id = $this->field["id"];
			$options = isset($this->parent->options[$this->field["id"]]) ? $this->parent->options[$this->field["id"]] : '';

			if (isset($this->value["attachment_id"]) && !empty($this->value["attachment_id"])) {


				$this->count = Custom_Font_Validator::CountCheck($this->value["attachment_id"]);
				//chack if the folder exists
				if (Custom_Font_Validator::checkIfFontExist($this->value["attachment_id"])) {
					//if we have more than one instance 
					if ($this->count > 0) {
						$this->field["msg"] = __("Font already exists", 'dfd');
						$this->error = $this->field;
						unset($this->value);
					}
					//if font exist in one instance that indicate we don't do anything
					return false;
				}
				$format = Custom_Font_Validator::checkFormat($this->value["attachment_id"]);
				if (!$format) {
					$this->field["msg"] = __("Your must download .zip format file", 'dfd');
					$this->error = $this->field;
					unset($this->value);
					return false;
				}
				$attach = get_attached_file($this->value["attachment_id"]);
				$this->attach = $attach;
				//Run//
				$this->upload();
			} else {
//				$c = count($options);
//				die();
//				if (count($options) >= 1) {
//					$this->field["msg"] = __("No attached file2", "dfd");
//					$this->error = $this->field;
//				}
			}
		}

		/**
		 * 
		 * @return boolean
		 */
		private function upload() {
			$info = pathinfo($this->attach);
			$file_name = basename($this->attach, '.' . $info['extension']);
			$temp_folder = $this->inst->upload_dir . "temp/" . $file_name;
			if (!file_exists($temp_folder)) {
				mkdir($temp_folder, 0777, true);
			}

			if (!file_exists($temp_folder)) {
				Custom_Font_Validator::remove_folder($temp_folder);
			} else {
				WP_Filesystem();
				unzip_file($this->attach, $temp_folder);
				$font_file_name = Custom_Font_Validator::get_zip_fontname($temp_folder);
				$has_font = Custom_Font_Validator::instance()->hasFont($font_file_name);
				if ($has_font) {
					$this->field["msg"] = __("Font exist", "dfd");
					$this->error = $this->field;
					unset($this->value);
					Custom_Font_Validator::remove_folder($temp_folder);
					return false;
				}
				if (trim($font_file_name) == '') {
					$this->field["msg"] = __("No found font file", "dfd");
					$this->error = $this->field;
					unset($this->value);
					Custom_Font_Validator::remove_folder($temp_folder);
				} else {
					if (file_exists($this->inst->upload_dir . $this->value["attachment_id"] . '/' . $font_file_name)) {
						if ($this->count > 0) {
							$this->field["msg"] = __('There is already a font with the same name', 'dfd');
							$this->error = $this->field;
							unset($this->value);
							Custom_Font_Validator::remove_folder($temp_folder);
						}
					} else {
						if (!Custom_Font_Validator::copy_zip_fontfiles($temp_folder, $this->inst->upload_dir . $this->value["attachment_id"] . '/' . $font_file_name)) {
							$this->field["msg"] = __('Error during file upload', 'dfd');
							$this->error = $this->field;
							unset($this->value);
						}
					}
				}
			}
		}

//function
	}

}