<?php //
if ( ! defined( 'ABSPATH' ) ) { exit; }
/*
* Add-on Name: Clients Testimonials
*/
if(!class_exists('Dfd_Contact_Block_Horizontal')) {
	
	class Dfd_Contact_Block_Horizontal {
		function __construct(){
			add_action('init',array($this,'dfd_contact_block_horizontal_init'));
			add_shortcode('dfd_contact_block_horizontal', array($this,'dfd_contact_block_horizontal_shortcode'));
		}
		function dfd_contact_block_horizontal_init() {
			if(function_exists('vc_map')) {
				$module_images = DFD_RONNEBY_PLUGIN_URL .'inc/vc_custom/dfd_vc_addons/admin/img/contact_block_horizontal/';
				vc_map(
					array(
					   'name'				=> esc_html__('Contact Block Horizontal','dfd'),
					   'base'				=> 'dfd_contact_block_horizontal',
					   'icon'				=> 'dfd_contact_block_horizontal dfd_shortcode',
					   'category'			=> esc_html__('Ronneby','dfd'),
					   'description'		=> esc_html__('Display your contact info in horizontal block','dfd'),
					   'params'				=> array(
							array(
								'heading'			=> esc_html__( 'Style', 'dfd' ),
								'description'		=> '',
								'type'				=> 'radio_image_select',
								'param_name'		=> 'main_style',
								'simple_mode'		=> false,
								'options'			=> array(
									'style-1'	=> array(
										'tooltip'	=> esc_attr__('Simple','dfd'),
										'src'		=> $module_images . 'style-1.png'
									),
									'style-2'	=> array(
										'tooltip'	=> esc_attr__('Bordered','dfd'),
										'src'		=> $module_images . 'style-2.png'
									),
									'style-3'	=> array(
										'tooltip'	=> esc_attr__('Underlined','dfd'),
										'src'		=> $module_images . 'style-3.png'
									),
									'style-4'	=> array(
										'tooltip'	=> esc_attr__('Background','dfd'),
										'src'		=> $module_images . 'style-4.png'
									),
								),
							),
							array(
								'type'				=> 'textfield',
								'heading'	  => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Add the unique class name for the element which can be used for custom CSS codes','dfd').'</span></span>'.esc_html__('Custom CSS Class', 'dfd'),
								'param_name'		=> 'el_class',
							),
							array(
								'type'				=> 'dfd_radio_advanced',
                                'heading'	  => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to choose which element should be set before content. Images allow you to upload your custom images images from the media library','dfd').'</span></span>'.esc_html__('Images/icons before content', 'dfd'),
								'param_name'		=> 'icon_image',
                                'value'				=> 'icons',
								'options'			=> array(
									esc_html__('Icons','dfd')	=> 'icons',
									esc_html__('Images','dfd')	=> 'images',
								),
								'group'				=> esc_html__('Content', 'dfd'),
							),
							array(
								'type'				=> 'textfield',
								'heading'	  => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Enter the postal address which will be shown in address field','dfd').'</span></span>'.esc_html__('Our address', 'dfd'),
								'param_name'		=> 'fild_address',
								'value'				=> '',
								'admin_label'		=> true,
								'group'				=> esc_html__('Content', 'dfd')
							),
							array(
								'type'				=> 'attach_image',
								'heading'		=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Upload the custom image from media library','dfd').'</span></span>'.esc_html__('Upload Image', 'dfd'),
								'param_name'		=> 'address_img',
								'value'				=> '',
								'group'				=> esc_html__('Content', 'dfd'),
								'dependency'		=> array( 'element' => 'icon_image', 'value'   => array( 'images' ) ),
							),
							array(
								'type'				=> 'textfield',
								'heading'	  => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Enter the telephone number which will be shown in telephone field','dfd').'</span></span>'.esc_html__('Our phone', 'dfd'),
								'param_name'		=> 'fild_phone',
								'value'				=> '',
								'group'				=> esc_html__('Content', 'dfd')
							),
							array(
								'type'				=> 'attach_image',
								'heading'		=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Upload the custom image from media library','dfd').'</span></span>'.esc_html__('Upload Image', 'dfd'),
								'param_name'		=> 'phones_img',
								'value'				=> '',
								'group'				=> esc_html__('Content', 'dfd'),
								'dependency'		=> array( 'element' => 'icon_image', 'value'   => array( 'images' ) ),
							),
							array(
								'type'				=> 'textfield',
								'heading'	  => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Enter the email address which will be shown in email field','dfd').'</span></span>'.esc_html__('Our email', 'dfd'),
								'param_name'		=> 'fild_email',
								'value'				=> '',
								'group'				=> esc_html__('Content', 'dfd')
							),
							array(
								'type'				=> 'attach_image',
								'heading'		=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Upload the custom image from media library','dfd').'</span></span>'.esc_html__('Upload Image', 'dfd'),
								'param_name'		=> 'email_img',
								'value'				=> '',
								'group'				=> esc_html__('Content', 'dfd'),
								'dependency'		=> array( 'element' => 'icon_image', 'value'   => array( 'images' ) ),
							),
							array(
								'type'				=> 'dfd_param_heading',
								'text'				=> esc_html__('Icon decoration', 'dfd'),
								'param_name'		=> 'icon_decoration',
								'class'				=> 'ult-param-heading',
								'edit_field_class'	=> 'dfd-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
								'group'				=> esc_html__('Decoration', 'dfd'),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to specify the size for the icon. The default size is 36px. The min icon size is 5, the max icon size is 100px.','dfd').'</span></span>'.esc_html__('Icon size', 'dfd'),
								'param_name'		=> 'icon_size',
								'value'				=> '',
								'min'				=> 5,
								'max'				=> 100,
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'dependency'		=> array( 'element' => 'icon_image', 'value'   => array( 'icons' ) ),
							),
							array(
								'type'				=> 'colorpicker',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Specify the color of your icons. The default value is inherited from Theme Options > Styling options > Default title color. For the style Background the icon color is #fff.','dfd').'</span></span>'.esc_html__('Icon color', 'dfd'),
								'param_name'		=> 'icon_color',
								'value'				=> '',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc',
								'dependency'		=> array( 'element' => 'icon_image', 'value'   => array( 'icons' ) ),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to set the size of the icon\'s thumbnail. Max size is 500px.','dfd').'</span></span>'.esc_html__('Thumb Size', 'dfd'),
								'param_name'		=> 'thumb_size',
								'value'				=> '',
								'min'				=> 0,
								'max'				=> 500,
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
							),
							array(
								'type'				=> 'colorpicker',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the background color for the icon\'s thumbnail. The default vale is inherited from Theme Options > Styling options > Default title color','dfd').'</span></span>'.esc_html__('Thumb background Color', 'dfd'),
								'param_name'		=> 'icon_background_color',
								'value'				=> '',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc',
								'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-4' ) ),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to set the border radius of the icon\'s thumbnail. Max value is 500px','dfd').'</span></span>'.esc_html__('Border Radius', 'dfd'),
								'param_name'		=> 'icon_border_radius',
								'value'				=> '',
								'min'				=> 0,
								'max'				=> 500,
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
                                'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-2', 'style-3', 'style-4' )),
							),
							array(
								'type'				=> 'dropdown',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose one of the border styles for the icon\'s thumbnail','dfd').'</span></span>'.esc_html__('Thumb Border Style', 'dfd'),
								'param_name'		=> 'icon_border_style',
								'value'				=> array(
									esc_html__('Solid','dfd')	=> 'solid',
									esc_html__('Dashed','dfd')	=> 'dashed',
									esc_html__('Dotted','dfd')	=> 'dotted',
									esc_html__('Double','dfd')	=> 'double',
									esc_html__('Inset','dfd')	=> 'inset',
									esc_html__('Outset','dfd')	=> 'outset',
								),
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-2' ) ),
							),
							array(
								'type'				=> 'number',
                                'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose border width for the icon\'s thumbnail.','dfd').'</span></span>'.esc_html__('Thumb Border width', 'dfd'),
								'param_name'		=> 'icon_border_width',
								'value'				=> '',
								'min'				=> 1,
								'max'				=> 10,
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-2' ) ),
							),
							array(
								'type'				=> 'colorpicker',
                                'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose border color for the icon\'s thumbnail. The default value is inherited from Theme Options > Styling options > Default border color','dfd').'</span></span>'.esc_html__('Thumb Border color', 'dfd'),
								'param_name'		=> 'icon_border_color',
								'value'				=> '',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-2', 'style-3' ) ),
							),
							array(
								'type'				=> 'dropdown',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose one of the border styles for the thumbnail','dfd').'</span></span>'.esc_html__('Border Style', 'dfd'),
								'param_name'		=> 'icon_border_style4',
								'value'				=> array(
									esc_html__('None','dfd')	=> 'none',
									esc_html__('Solid','dfd')	=> 'solid',
									esc_html__('Dashed','dfd')	=> 'dashed',
									esc_html__('Dotted','dfd')	=> 'dotted',
								),
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'dependency'		=> array( 'element' => 'main_style', 'value'   => array( 'style-4' ) ),
							),
							array(
								'type'				=> 'colorpicker',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose one of the border color for the icon\'s thumbnail. The default value is inherited from Theme Options > Styling options > Default border color','dfd').'</span></span>'.esc_html__('Thumb Border color', 'dfd'),
								'param_name'		=> 'icon_border_color4',
								'value'				=> '',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array( 'element' => 'icon_border_style4', 'value'   => array( 'solid', 'dashed', 'dotted'/*, 'double', 'inset', 'outset'*/ ) ),
							),
							array(
								'type'        => 'dfd_single_checkbox',
								'heading'     => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to enable or disable triple border at the bottom of the thumbnail','dfd').'</span></span>'.esc_html__('triple border bottom', 'dfd'),
								'param_name'  => 'triple_border_bottom4',
								'value'				=> '',
								'options'			=> array(
									'yes'			=> array(
										'yes'				=> esc_attr__('Yes', 'dfd'),
										'no'				=> esc_attr__('No', 'dfd')
									),
								),
								'group'       => esc_attr__( 'Decoration', 'dfd' ),
								'dependency'		=> array( 'element' => 'icon_border_style4', 'value'   => array( 'solid', 'dashed', 'dotted'/*, 'double', 'inset', 'outset'*/ ) ),
							),
							array(
								'type'				=> 'dfd_param_heading',
								'text'				=> esc_html__('Delimiter decoration', 'dfd'),
								'param_name'		=> 'delimiter_decoration',
								'class'				=> 'ult-param-heading',
								'edit_field_class'	=> 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
								'group'				=> esc_html__('Decoration', 'dfd'),
							),
							array(
								'type'				=> 'dropdown',
                                'heading'     => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to choose one of the delimiter styles','dfd').'</span></span>'.esc_html__('Delimiter Style', 'dfd'),
								'param_name'		=> 'delimiter_border_style',
								'value'				=> array(
									esc_html__('Dotted','dfd')	=> 'dotted',
									esc_html__('Solid','dfd')	=> 'solid',
									esc_html__('Dashed','dfd')	=> 'dashed',
									esc_html__('Double','dfd')	=> 'double',
									esc_html__('Inset','dfd')	=> 'inset',
									esc_html__('Outset','dfd')	=> 'outset',
									esc_html__('None','dfd')	=> 'none',
								),
								'group'				=> esc_html__('Decoration', 'dfd'),
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
							),
							array(
								'type'				=> 'number',
								'heading'     => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to specify the height of the delimiter','dfd').'</span></span>'.esc_html__('Delimiter height', 'dfd'),
								'param_name'		=> 'delimiter_height',
								'value'				=> '',
								'min'				=> 1,
								'max'				=> 10,
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array('element' => 'delimiter_border_style', 'value' => array('solid', 'dashed', 'dotted', 'double', 'inset', 'outset')),
							),
							array(
								'type'				=> 'colorpicker',
								'heading'     => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to specify the delimiter color. The default value is inherited from Theme Options > Styling options > Default border color.','dfd').'</span></span>'.esc_html__('Delimiter color', 'dfd'),
								'param_name'		=> 'delimiter_color',
								'value'				=> '',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array('element' => 'delimiter_border_style', 'value' => array('solid', 'dashed', 'dotted', 'double', 'inset', 'outset')),
							),
							array(
								'type'				=> 'dfd_single_checkbox',
								'heading'     => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to align the delimiter. If the option is enabled the delimiter will start from icon\'s thumbnail.','dfd').'</span></span>'.esc_html__('Align to icon', 'dfd'),
								'param_name'		=> 'delimiter_align',
								'value'				=> '',
								'options'			=> array(
									'yes'			=> array(
										'yes'				=> esc_attr__('Yes', 'dfd'),
										'no'				=> esc_attr__('No', 'dfd')
									),
								),
								'group'				=> esc_html__('Decoration', 'dfd'),
								'dependency'		=> array('element' => 'delimiter_border_style', 'value' => array('solid', 'dashed', 'dotted', 'double', 'inset', 'outset')),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Title', 'dfd' ) . ' ' . esc_attr__( 'Typography', 'dfd' ),
								'param_name'       => 'title_t_heading',
								'group'            => esc_attr__( 'Typography', 'dfd' ),
                                'class'				=> 'ult-param-heading',
								'edit_field_class'	=> 'dfd-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
							),
							array(
								'type'       => 'dfd_font_container_param',
								'heading'    => '',
								'param_name' => 'title_font_options',
								'settings'   => array(
									'fields' => array(
										'tag' => 'div',
										'letter_spacing',
										'font_size',
										'line_height',
										'color',
										'font_style'
									),
								),
								'group'      => esc_attr__( 'Typography', 'dfd' ),
							),
							array(
								'type'        => 'dfd_single_checkbox',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to use custom Google font','dfd').'</span></span>'.esc_html__('Custom font family', 'dfd'),
								'param_name'  => 'title_google_fonts',
								'value'				=> '',
								'options'			=> array(
									'yes'			=> array(
										'yes'				=> esc_attr__('Yes', 'dfd'),
										'no'				=> esc_attr__('No', 'dfd')
									),
								),
								'group'       => esc_attr__( 'Typography', 'dfd' ),
							),
							array(
								'type'       => 'google_fonts',
								'param_name' => 'title_custom_fonts',
								'value'      => '',
								'group'      => esc_attr__( 'Typography', 'dfd' ),
								'settings'   => array(
									'fields' => array(
										'font_family_description' => esc_html__( 'Select font family.', 'dfd' ),
										'font_style_description'  => esc_html__( 'Select font styling.', 'dfd' ),
									),
								),
								'dependency' => array(
									'element' => 'title_google_fonts',
									'value'   => 'yes',
								),
							),
							array(
								'type'				=> 'dropdown',
								'heading'	 => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the appear effect for the element','dfd').'</span></span>'.esc_html__('Animation', 'dfd'),
								'param_name'		=> 'module_animation',
								'value'				=> Dfd_Theme_Helpers::module_animation_styles(),
								'group'				=> esc_html__('Animation Settings', 'dfd'),
							),
						),
					)
				);
			}
		}
		// Shortcode handler function
		function dfd_contact_block_horizontal_shortcode($atts) {
			$main_style = $el_class = $fild_address = $fild_phone = $fild_email = $module_animation = $animate = $animation_data = $output = $fild_name_css = '';
			$filds = $icon = $fild_email_html = $prefix = $field_html = $icon_class = $icon_border_style = $icon_border_width = $icon_border_color = $icon_border_radius = '';
			$icon_background_color = $icon_size = $thumb_size = $delimiter_border_style = $delimiter_height = $delimiter_color = $delim_html = $thumb_style = '';
			$block_content_style = $margin_left_style1 = $delimiter_align = $icon_color = $delimiter_style = $address_img = $phones_img = $avatar = '';
			$title_font_options = $title_google_fonts = $title_custom_fonts = $title_options = $icon_content = $img_size = $icon_image = $email_img = $link_css = '';
			$icon_content_phones = $icon_content_email = $img_padding = $icon_border_style4 = $icon_border_color4 = $triple_border_bottom4 = $general_class = '';
			$address_var = $phones_var = $email_var = '';
			
			extract(shortcode_atts( array(
				'main_style' => 'style-1',
				'el_class' => '',
				'icon_image' => 'icons',
				'fild_address' => '',
				'address_img' => '',
				'fild_phone' => '',
				'phones_img' => '',
				'fild_email' => '',
				'email_img' => '',
				'icon_border_style' => 'solid',
				'icon_border_width' => '',
				'icon_border_color' => '',
				'icon_border_radius' => '',
				'icon_background_color' => '',
				'icon_size' => '',
				'icon_color' => '',
				'thumb_size' => '',
				'icon_border_style4' => 'none',
				'icon_border_color4' => '',
				'triple_border_bottom4' => '',
				'delimiter_border_style' => 'dotted',
				'delimiter_height' => '',
				'delimiter_color' => '',
				'delimiter_align' => '',
				'title_font_options' => '',
				'title_google_fonts' => '',
				'title_custom_fonts' => '',
				'module_animation' => ''
			),$atts));
			
			$thumb_style .= 'style="';
			$block_content_style .= 'style="';
			$delimiter_style .= 'style="';
			
			$uniqid = uniqid('dfd-contacts-') .'-'.rand(1,9999);
			
			$fild_email_html = '<a href="mailto:'.esc_attr($fild_email).'">'.esc_attr($fild_email).'</a>';
			
			$prefix = __('Our', 'dfd');
			$address_var	= __('address', 'dfd');
			$phones_var		= __('phones', 'dfd');
			$email_var		= __('email', 'dfd');
			$filds = array (
				$address_var	=> $fild_address,
				$phones_var		=> $fild_phone,
				$email_var		=> $fild_email_html
			);

			if (isset($thumb_size) && !empty($thumb_size)) {
				$thumb_style .= 'width: '.esc_attr($thumb_size).'px; ';
				$thumb_style .= 'height: '.esc_attr($thumb_size).'px; ';
				$block_content_style .= 'margin-left: '.esc_attr($thumb_size).'px; ';
				$img_size = $thumb_size;
				$img_padding = $thumb_size * 15 / 100;
				$thumb_style .= 'padding: '.esc_attr($img_padding).'px; ';
			} else {
				$img_size = 80;
			}
			
			global $dfd_ronneby;
			$lazy_load = false;
			if(isset($dfd_ronneby['enable_images_lazy_load']) && $dfd_ronneby['enable_images_lazy_load'] == 'on') {
				$lazy_load = true;
				$icon_class .= ' dfd-img-lazy-load';
				$loading_img_src = "data:image/svg+xml;charset=utf-8,%3Csvg xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg' viewBox%3D'0 0 $img_size $img_size'%2F%3E";
			}
			
			if (isset($address_img) && !empty($address_img)) {
				$address_img_src = wp_get_attachment_image_src( $address_img, 'full' );
				$avatar = dfd_aq_resize( $address_img_src[0], $img_size, $img_size, true, true, false );
				
				if(!$avatar) {
					$avatar = $address_img_src[0];
				}
				
				$attr = Dfd_Theme_Helpers::get_image_attrs($avatar, $address_img, $img_size, $img_size);
				
				if($lazy_load) {
					$icon_content_address = '<img src="'.$loading_img_src.'" data-src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				} else {
					$icon_content_address = '<img src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				}
			} else {
				$icon_content_address = '<i class="dfd-icon-navigation"></i>';
			}
			
			if (isset($phones_img) && !empty($phones_img)) {
				$phones_img_src = wp_get_attachment_image_src( $phones_img, 'full' );
				$avatar = dfd_aq_resize( $phones_img_src[0], $img_size, $img_size, true, true, false );
				
				if(!$avatar) {
					$avatar = $phones_img_src[0];
				}
				
				$attr = Dfd_Theme_Helpers::get_image_attrs($avatar, $phones_img, $img_size, $img_size);
				
				if($lazy_load) {
					$icon_content_phones = '<img src="'.$loading_img_src.'" data-src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				} else {
					$icon_content_phones = '<img src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				}
			}else{
				$icon_content_phones = '<i class="dfd-icon-call_incoming"></i>';
			}
			
			if (isset($email_img) && !empty($email_img)) {
				$email_img_src = wp_get_attachment_image_src( $email_img, 'full' );
				$avatar = dfd_aq_resize( $email_img_src[0], $img_size, $img_size, true, true, false );
				
				if(!$avatar) {
					$avatar = $email_img_src[0];
				}
				
				$attr = Dfd_Theme_Helpers::get_image_attrs($avatar, $email_img, $img_size, $img_size);
				
				if($lazy_load) {
					$icon_content_email = '<img src="'.$loading_img_src.'" data-src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				} else {
					$icon_content_email = '<img src="' . esc_url( $avatar ) . '" '.$attr.'/>';
				}
			} else {
				$icon_content_email = '<i class="dfd-icon-network"></i>';
			}
			
			$icon = array (
				$address_var	=> $icon_content_address,
				$phones_var		=> $icon_content_phones,
				$email_var		=> $icon_content_email
			);
			
			if ( ! ( $module_animation == '' ) ) {
				$animate        = ' cr-animate-gen';
				$animation_data = 'data-animate-type = "' . esc_attr($module_animation) . '" ';
			}
			
			if (isset($icon_size) && !empty($icon_size)) {
				$thumb_style .= 'font-size: '.esc_attr($icon_size).'px; ';
				if(isset($main_style) && strcmp($main_style, 'style-1') === 0) {
					$margin_left_style1 = esc_attr($icon_size) * 2;
					$block_content_style .= 'margin-left: '.esc_attr($margin_left_style1).'px; ';
					$link_css .= '#'.esc_attr($uniqid).' .block-icon {width: '.esc_attr($margin_left_style1).'px; height: '.esc_attr($margin_left_style1).'px;}';
				}
			}
			if (isset($icon_background_color) && !empty($icon_background_color)) {
				$thumb_style .= 'background: '.esc_attr($icon_background_color).'; ';
			}
			if (isset($icon_color) && !empty($icon_color)) {
				$thumb_style .= 'color: '.esc_attr($icon_color).'; ';
			}
			if ((isset($icon_border_radius) && !empty($icon_border_radius)) || strcmp($icon_border_radius, '0') === 0) {
				$thumb_style .= 'border-radius: '.esc_attr($icon_border_radius).'px; ';
			}
			if(isset($main_style) && strcmp($main_style, 'style-2') === 0 || strcmp($main_style, 'style-3') === 0) {
				if ( $icon_border_style || $icon_border_width ) {
					if ($icon_border_style) {
						$thumb_style .= 'border-style: '.esc_attr($icon_border_style).'; ';
					}
					if ($icon_border_width) {
						$thumb_style .= 'border-width: '.esc_attr($icon_border_width).'px; ';
						$link_css .= '#'.esc_attr($uniqid).' .block-icon i {margin-left: -'.esc_attr($icon_border_width).'px;}';
					}
				}
			}
			if ( $icon_border_color ) {
				$thumb_style .= 'border-color: '.esc_attr($icon_border_color).'; ';
			}
			if($delimiter_align !== 'yes') {
				$delimiter_style .= 'margin-left: 20px;';
			}
			if(isset($delimiter_border_style) && strcmp($delimiter_border_style, 'none') !== 0) {
				if ( $delimiter_border_style || $delimiter_height || $delimiter_color ) {
					if ($delimiter_border_style) {
						$delimiter_style .= 'border-bottom-style: '.esc_attr($delimiter_border_style).'; ';
					}
					if ($delimiter_height) {
						$delimiter_style .= 'border-bottom-width: '.esc_attr($delimiter_height).'px; ';
					}
					if ( $delimiter_color ) {
						$delimiter_style .= 'border-bottom-color: '.esc_attr($delimiter_color).'; ';
					}
				}
			}
			if(isset($icon_border_style4) && strcmp($icon_border_style4, 'none') !== 0) {
				$thumb_style .= 'border-style: '.esc_attr($icon_border_style4).'; ';
				if ($icon_border_color4) {
					$thumb_style .= 'border-color: '.esc_attr($icon_border_color4).'; ';
				}
			}
			
			$delimiter_style .= '"';
			$block_content_style .= '"';
			$thumb_style .= '"';
			
			if(isset($delimiter_border_style) && strcmp($delimiter_border_style, 'none') !== 0) {
				$delim_html = '<span class="delimiter" '.$delimiter_style.'></span>';
			}
			if($triple_border_bottom4 === 'yes') {
				$general_class .= ' triple-border';
			}
			$general_class .= ' '.esc_attr($main_style).'';
			//Title Typography
			$title_options = _crum_parse_text_shortcode_params( $title_font_options, '', $title_google_fonts, $title_custom_fonts );
			
			$output .= '<div id="'.esc_attr($uniqid).'" class="dfd-contact-block-horizontal clearfix '.$general_class.' '.esc_attr($el_class).' '.esc_attr($animate).'" '.$animation_data.'>';
				
				foreach($filds as $key => $value){
					if(isset($value) && !empty($value)){
						if(key_exists($key, $icon)){
							$icon_html = $icon[$key];
						};
						$field_html .= '
						<div class="fild-content columns">
							<div class="block-icon '.$icon_class.'" '.$thumb_style.'>'.$icon_html.'</div>
							<div class="block-content" '.$block_content_style.'>
								<'.$title_options['tag'].' class="widget-title fild-name ' . $title_options['class'] . '" ' . $title_options['style'] . '>' .$prefix.' '.$key. ':</'.$title_options['tag'].'>'
								.$delim_html.
								'<p class="'.$key.'">'.$value.'</p>
							</div>
						</div>';
					}
				}
				$output .= $field_html;

			$output .= '</div>';
			
			$output .= '<script type="text/javascript">
							(function($) {
								var $column = $("#'.esc_js($uniqid).' .fild-content"),
									columnClass = ["twelve","six","four"],
									columnsCount = $column.length;
								
								$column.addClass(columnClass[columnsCount - 1]);
						
								$("head").append("<style>'. esc_js($link_css) .'</style>");
									
							})(jQuery);
						</script>';
			
			return $output;
		}
	}
}
if(class_exists('Dfd_Contact_Block_Horizontal')) {
	$Dfd_Contact_Block_Horizontal = new Dfd_Contact_Block_Horizontal;
}