<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
/*
* Add-on Name: Clients Testimonials
*/
if ( ! class_exists( 'Dfd_Testimonials' ) ) {
	/**
	 * Class Dfd_Testimonials
	 */
	class Dfd_Testimonials {
		/**
		 * Main construct class.
		 */
		function __construct() {
			add_action( 'init', array( $this, '_dfd_testimonials_init' ) );
			add_shortcode( 'new_testimonials', array( $this, '_dfd_testimonials_shortcode' ) );
		}

		/**
		 * Block options.
		 */
		function _dfd_testimonials_init() {
			if ( function_exists( 'vc_map' ) ) {
				$module_images = DFD_RONNEBY_PLUGIN_URL .'inc/vc_custom/dfd_vc_addons/admin/img/testimonials/';
				vc_map(
					array(
						'name'        => esc_html__( 'Testimonial', 'dfd' ),
						'base'        => 'new_testimonials',
						'icon'        => 'new_testimonials dfd_shortcode',
						'category'    => esc_html__( 'Ronneby', 'dfd' ),
						'description' => esc_html__( 'Display client testimonial', 'dfd' ),
						'params'      => array(
							array(
								'heading'    => esc_html__( 'Style', 'dfd' ),
								'type'       => 'radio_image_select',
								'param_name' => 'main_style',
								'simple_mode' => false,
								'options'    => array(
									'style-1'	=> array(
										'tooltip'	=> esc_attr__('Simple','dfd'),
										'src'		=> $module_images . 'style-1.png'
									),
									'style-2'	=> array(
										'tooltip'	=> esc_attr__('Decorated','dfd'),
										'src'		=> $module_images . 'style-2.png'
									),
									'style-3'	=> array(
										'tooltip'	=> esc_attr__('Background','dfd'),
										'src'		=> $module_images . 'style-3.png'
									),
								),
							),
							array(
								'heading'     => esc_html__( 'Layout', 'dfd' ),
								'type'        => 'radio_image_select',
								'param_name'  => 'main_layout',
								'simple_mode' => false,
								'options'     => array(
									'layout-1'	=> array(
										'tooltip'	=> esc_attr__('Middle line','dfd'),
										'src'		=> $module_images . 'layout-1.png'
									),
									'layout-2'	=> array(
										'tooltip'	=> esc_attr__('Top line','dfd'),
										'src'		=> $module_images . 'layout-2.png'
									),
									'layout-3'	=> array(
										'tooltip'	=> esc_attr__('Big quotes','dfd'),
										'src'		=> $module_images . 'layout-3.png'
									),
									'layout-4'	=> array(
										'tooltip'	=> esc_attr__('Bottom line','dfd'),
										'src'		=> $module_images . 'layout-4.png'
									),
									'layout-5'	=> array(
										'tooltip'	=> esc_attr__('Top info','dfd'),
										'src'		=> $module_images . 'layout-5.png'
									),
									'layout-6'	=> array(
										'tooltip'	=> esc_attr__('Top image','dfd'),
										'src'		=> $module_images . 'layout-6.png'
									),
									'layout-7'	=> array(
										'tooltip'	=> esc_attr__('Bottom quotes','dfd'),
										'src'		=> $module_images . 'layout-7.png'
									),
									'layout-11'	=> array(
										'tooltip'	=> esc_attr__('Bottom title','dfd'),
										'src'		=> $module_images . 'layout-11.png'
									),
									'layout-8'	=> array(
										'tooltip'	=> esc_attr__('Top quotes','dfd'),
										'src'		=> $module_images . 'layout-8.png'
									),
									'layout-9'	=> array(
										'tooltip'	=> esc_attr__('Left image','dfd'),
										'src'		=> $module_images . 'layout-9.png'
									),
									'layout-10'	=> array(
										'tooltip'	=> esc_attr__('Right image','dfd'),
										'src'		=> $module_images . 'layout-10.png'
									),
									'layout-12'	=> array(
										'tooltip'	=> esc_attr__('Combined info','dfd'),
										'src'		=> $module_images . 'layout-12.png'
									),
								),
							),
							array(
								'type'       => 'dfd_radio_advanced',
								'heading'    => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the alignment for the testimonial','dfd').'</span></span>'.esc_html__('Alignment', 'dfd'),
								'param_name' => 'align',
								'value'      => 'align-center',
								'options'      => array(
									esc_html__( 'Center', 'dfd' ) => 'align-center',
									esc_html__( 'Left', 'dfd' )   => 'align-left',
									esc_html__( 'Right', 'dfd' )  => 'align-right',
								),
								'dependency' => array(
									'element' => 'main_layout',
									'value_not_equal_to' => array( 'layout-9', 'layout-10', 'layout-12' ),
								),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Extra features', 'dfd' ),
								'param_name'       => 'extra_features_elements_heading',
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
							),
							array(
								'type'        => 'dropdown',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the appear effect for the element','dfd').'</span></span>'.esc_html__('Animation', 'dfd'),
								'param_name'  => 'module_animation',
								'value'       => Dfd_Theme_Helpers::module_animation_styles(),
							),
							array(
								'type'        => 'textfield',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Add the unique class name for the element which can be used for custom CSS codes','dfd').'</span></span>'.esc_html__('Custom CSS Class', 'dfd'),
								'param_name'  => 'el_class',
							),
							array(
								'type'        => 'attach_image',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Upload the testimonial author image','dfd').'</span></span>'.esc_attr__('Author Image', 'dfd'),
								'param_name'  => 'image',
								'group'       => esc_attr__( 'Content', 'dfd' ),
							),
							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Title', 'dfd' ),
								'param_name'  => 'author',
								'admin_label' => true,
								'group'       => esc_attr__( 'Content', 'dfd' ),
							),

							array(
								'type'        => 'textfield',
								'heading'     => esc_html__( 'Subtitle', 'dfd' ),
								'param_name'  => 'subtitle',
								'group'       => esc_attr__( 'Content', 'dfd' ),
							),
							array(
								'type'        => 'textarea',
								'heading'     => esc_html__( 'Testimonial', 'dfd' ),
								'param_name'  => 'description',
								'group'       => esc_attr__( 'Content', 'dfd' ),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Testimonial', 'dfd' ) . ' ' . esc_attr__( 'Typography', 'dfd' ),
								'param_name'       => 'content_t_heading',
								'group'            => esc_attr__( 'Typography', 'dfd' ),
								'edit_field_class' => 'dfd-heading-param-wrapper no-top-margin vc_column vc_col-sm-12',
							),
							array(
								'type'       => 'dfd_font_container_param',
								'heading'    => '',
								'param_name' => 'content_font_options',
								'settings'   => array(
									'fields' => array(
										'letter_spacing',
										'font_size',
										'line_height',
										'color',
										'font_style',
									),
								),
								'group'      => esc_attr__( 'Typography', 'dfd' ),
							),

							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Title', 'dfd' ).' '.esc_attr__( 'Typography', 'dfd' ),
								'param_name'       => 'title_t_heading',
								'group'            => esc_attr__( 'Typography', 'dfd' ),
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
							),
							array(
								'type'        => 'dfd_font_container_param',
								'heading'     => '',
								'param_name' => 'title_font_options',
								'settings'   => array(
									'fields' => array(
										'tag'=>'div',
										'letter_spacing',
										'font_size',
										'line_height',
										'color',
									),
								),
								'group'       => esc_attr__( 'Typography', 'dfd' ),
							),
							array(
								'type'			=> 'dfd_radio_advanced',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the text transform for the title','dfd').'</span></span>'. esc_html__('Text transform', 'dfd'),
								'param_name'	=> 'title_uppercase',
								'value'			=> 'uppercase',
								'options'		=> array(
									esc_html__('None', 'dfd') => 'none',
									esc_html__('Capitalize', 'dfd') => 'capitalize',
									esc_html__('Lowercase', 'dfd') => 'lowercase',
									esc_html__('Uppercase', 'dfd') => 'uppercase',
								),
								'edit_field_class' => 'vc_column vc_col-sm-12',
								'group'			=> esc_html__('Typography', 'dfd')
							),
							array(
								'type'        => 'dfd_single_checkbox',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Allows you to use custom Google font','dfd').'</span></span>'.esc_html__('Custom font family', 'dfd'),
								'param_name'  => 'use_google_fonts',
								'options'	  => array(
									'yes'		  => array(
											'yes'				=> esc_attr__('Yes', 'dfd'),
											'no'				=> esc_attr__('No', 'dfd'),
										),
									),
								'group'       => esc_attr__( 'Typography', 'dfd' ),
							),
							array(
								'type'       => 'google_fonts',
								'param_name' => 'custom_fonts',
								'value'      => '',
								'group'      => esc_attr__( 'Typography', 'dfd' ),
								'settings'   => array(
									'fields' => array(
										'font_family_description' => esc_html__( 'Select font family.', 'dfd' ),
										'font_style_description'  => esc_html__( 'Select font styling.', 'dfd' ),
									),
								),
								'dependency' => array(
									'element' => 'use_google_fonts',
									'value'   => 'yes',
								),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Subtitle', 'dfd' ).' '.esc_attr__( 'Typography', 'dfd' ),
								'param_name'       => 'subtitle_t_heading',
								'group'            => esc_html__( 'Typography', 'dfd' ),
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
							),
							array(
								'type'        => 'dfd_font_container_param',
								'heading'     => '',
								'param_name' => 'subtitle_font_options',
								'settings'   => array(
									'fields' => array(
										'tag'=>'div',
										'letter_spacing',
										'font_size',
										'line_height',
										'color',
									),
								),
								'group'       => esc_html__( 'Typography', 'dfd' ),
							),
							array(
								'type' => 'dfd_single_checkbox',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">' . esc_html__('Allows you to use custom Google font', 'dfd') . '</span></span>' . esc_html__('Custom font family', 'dfd'),
								'param_name' => 'subtitle_use_google_fonts',
								'options' => array(
									'yes' => array(
										'yes' => esc_attr__('Yes', 'dfd'),
										'no' => esc_attr__('No', 'dfd'),
									),
								),
								'group' => esc_attr__('Typography', 'dfd'),
							),
							array(
								'type' => 'google_fonts',
								'param_name' => 'subtitle_custom_fonts',
								'value' => '',
								'settings' => array(
									'fields' => array(
										'font_family_description' => esc_html__('Select font family.', 'dfd'),
										'font_style_description' => esc_html__('Select font styling.', 'dfd'),
									),
								),
								'dependency' => array('element' => 'subtitle_use_google_fonts', 'value' => 'yes'),
								'group' => esc_attr__('Typography', 'dfd'),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Author thumbnail', 'dfd' ),
								'param_name'       => 'thumb_t_heading',
								'edit_field_class' => 'dfd-heading-param-wrapper no-top-margin vc_column vc_col-sm-12',
								'group'       => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">' . esc_html__('Set the border radius for the testimonial author\'s image', 'dfd') . '</span></span>' .esc_html__('Border radius', 'dfd'),
								'param_name' => 'thumb_radius',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to set the width for the border. The default value is not set','dfd').'</span></span>'.esc_html__('Border width', 'dfd'),
								'param_name' => 'thumb_border_width',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'colorpicker',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the color for the border. The default value is not set','dfd').'</span></span>'.esc_html__('Border color', 'dfd'),
								'param_name' => 'thumb_color',
								'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Set the size for the testimonial author\'s image','dfd').'</span></span>'. esc_html__('Image size', 'dfd'),
								'param_name' => 'thumb_size',
								'min'        => 80,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to add space between the author\'s image and testimonial\'s content','dfd').'</span></span>'.esc_html__( 'Image offset ', 'dfd' ),
								'param_name' => 'image_offset',
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'dependency' => array('element' => 'main_layout', 'value' => array('layout-9', 'layout-10')),
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Delimiter style', 'dfd' ),
								'param_name'       => 'del_t_heading',
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
								'group'       => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the width of the testimonial\'s delimiter. The default value is 380px','dfd').'</span></span>'.esc_html__( 'Width', 'dfd' ),
								'param_name' => 'line_width',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the height of the testimonial\'s delimiter. The default value is 1px','dfd').'</span></span>'. esc_html__( 'Height', 'dfd' ),
								'param_name' => 'line_border',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'colorpicker',
								'heading' => '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to  specify the color of the testimonial\'s delimiter. The default value is rgba(0,0,0,0.1)','dfd').'</span></span>'.esc_html__( 'Color', 'dfd' ),
								'param_name' => 'line_color',
								'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'             => 'dfd_single_checkbox',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to hide the delimiter','dfd').'</span></span>'.esc_html__( 'Disable element', 'dfd' ),
								'options'			=> array(
									'yes'				=> array(
										'yes'				=> esc_attr__('Yes', 'dfd'),
										'no'				=> esc_attr__('No', 'dfd'),
									),
								),
								'param_name'       => 'line_hide',
								'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
								'group'            => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Content', 'dfd' ),
								'param_name'       => 'bg_t_heading',
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
								'dependency' => array(
									'element' => 'main_style',
									'value_not_equal_to' => 'style-1',
								),
								'group'       => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'colorpicker',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the background color for the testimonial. The default value is #f4f4f4','dfd').'</span></span>'.esc_html__('Color', 'dfd'),
								'param_name' => 'bg_color',
								'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
								'dependency' => array(
									'element' => 'main_style',
									'value_not_equal_to' => 'style-1',
								),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to set the border radius for the testimonial\'s background','dfd').'</span></span>'.esc_html__('Border radius', 'dfd'),
								'param_name' => 'bg_radius',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
								'dependency' => array(
									'element' => 'main_style',
									'value_not_equal_to' => 'style-1',
								),
							),
							array(
								'type'             => 'dfd_param_heading',
								'text'             => esc_html__( 'Quote symbol', 'dfd' ),
								'param_name'       => 'quote_t_heading',
								'edit_field_class' => 'dfd-heading-param-wrapper vc_column vc_col-sm-12',
								'group'       => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'colorpicker',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the quote color for the testimonial. The default value is #d2d2d2','dfd').'</span></span>'.esc_html__('Color', 'dfd'),
								'param_name' => 'quote_color',
								'edit_field_class' => 'vc_column vc_col-sm-6 crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('Choose the size for the testimonial\'s quote symbol. The default value is 30px','dfd').'</span></span>'.esc_html__( 'Size', 'dfd' ),
								'param_name' => 'quote_size',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
							),
							array(
								'type'       => 'number',
								'heading' => '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to add space between the quote symbol and testimonial','dfd').'</span></span>'. esc_html__( 'Margin from testimonial content', 'dfd' ),
								'param_name' => 'quote_margin',
								'min'        => 0,
								'edit_field_class' => 'vc_column vc_col-sm-6 dfd-number-wrap crum_vc',
								'group'      => esc_html__( 'Style', 'dfd' ),
								'dependency' => array(
									'element' => 'main_layout',
									'value'   => array('layout-1','layout-2','layout-4')
								),
							),
							array(
								'type'				=> 'dfd_single_checkbox',
								'heading'			=> '<span class="dfd-vc-toolip tooltip-bottom"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to hide the quote symbol','dfd').'</span></span>'. esc_html__('Disable element', 'dfd'),
								'param_name'		=> 'quote_hide',
								'options'			=> array(
									'yes'			=> array(
										'on'			=> 'Yes',
										'off'			=> 'No',
									),
								),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc',
								'group'				=> esc_html__('Style', 'dfd'),
							),
							array(
								'type'				=> 'dfd_single_checkbox',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to add the background to quote symbol and add its decoration. Option is not available if the option \'Disable element\' is enabled','dfd').'</span></span>'.esc_html__('Background decoration', 'dfd'),
								'param_name'		=> 'enabled_bg_decor',
								'options'			=> array(
									'enable'			=> array(
										'on'			=> 'Yes',
										'off'			=> 'No',
									),
								),
								'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc',
								'dependency'		=> array('element' => 'main_layout', 'value' => array('layout-1', 'layout-11')),
								'group'				=> esc_html__('Style', 'dfd'),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the background size for the quote symbol','dfd').'</span></span>'. esc_html__('Background size', 'dfd'),
								'param_name'		=> 'bg_size',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
								'dependency'		=> array('element' => 'enabled_bg_decor', 'value'   => array('enable')),
								'group'				=> esc_html__('Style', 'dfd'),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the border radius for the quote symbol\'s background. The default value is 50%','dfd').'</span></span>'.esc_html__('Border radius', 'dfd'),
								'param_name'		=> 'bg_border_radius',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
								'dependency'		=> array('element' => 'enabled_bg_decor', 'value'   => array('enable')),
								'group'				=> esc_html__('Style', 'dfd'),
							),
							array(
								'type'				=> 'colorpicker',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to specify the color for the quote symbol\'s background. The default value is rgba(0,0,0,0.5)','dfd').'</span></span>'. esc_html__('Background color', 'dfd'),
								'param_name'		=> 'bg_background',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
								'dependency'		=> array('element' => 'enabled_bg_decor', 'value'   => array('enable')),
								'group'				=> esc_html__('Style', 'dfd'),
							),
							array(
								'type'				=> 'number',
								'heading'			=> '<span class="dfd-vc-toolip"><i class="dfd-socicon-question-sign"></i><span class="dfd-vc-tooltip-text">'.esc_html__('This option allows you to add space under the quote symbol. The default value is 10px','dfd').'</span></span>'. esc_html__('Bottom offset', 'dfd'),
								'param_name'		=> 'icon_offset_bottom',
								'edit_field_class'	=> 'vc_column vc_col-sm-4 dfd-number-wrap crum_vc',
								'dependency'		=> array('element' => 'enabled_bg_decor', 'value'   => array('enable')),
								'group'				=> esc_html__('Style', 'dfd'),
							),
						),
					)
				);
			}
		}

		/**
		 * Shortcode handler function.
		 *
		 * @param $atts
		 *
		 * @return string
		 */
		function _dfd_testimonials_shortcode( $atts ) {
			$main_style = $main_layout = $thumb_color = $quote_hide = $line_width = $line_hide = $line_border = $line_color = $bg_color = $bg_radius = $quote_color = $align = '';
			$image = $author = $subtitle = $description = $content_font_options = $use_google_fonts = $custom_fonts = $title_font_options = $subtitle_font_options = '';
			$thumb_radius = $thumb_size = $thumb_border_width = $avatar_html = $avatar_style = $author_style = $subtitle_html = $subtitle_style = $content_style = '';
			$delimiter_html = $delimiter_style = $content_bg = $bg_style = $quote_style = $quote_size = $quote_margin =  $icon_html = $content_html = $css_rules = '';
			$output = $el_class = $module_animation = $enabled_bg_decor = $bg_size = $bg_border_radius = $bg_background = $animation_data = $uniqid = $title_uppercase = '';
			$title_subtitle_nowrap = $image_offset = $icon_offset_bottom = $subtitle_use_google_fonts = $subtitle_custom_fonts = '';

			//new_testimonials
			
//			extract( shortcode_atts( array(
//				'main_style'            => 'style-1',
//				'main_layout'           => 'layout-1',
//				'align'                 => 'align-center',
//				'image'                 => '',
//				'author'                => __( 'Author name', 'dfd' ),
//				'subtitle'              => '',
//				'description'           => __( 'Please add some review text in admin panel', 'dfd' ),
//				'content_font_options'  => '',
//				'use_google_fonts'      => '',
//				'custom_fonts'          => '',
//				'title_font_options'    => '',
//				'subtitle_font_options' => '',
//				'thumb_radius'          => '',
//				'thumb_size'            => '80',
//				'image_offset'          => '',
//				'thumb_color'           => '',
//				'thumb_border_width'    => '',
//				'line_hide'             => '',
//				'line_width'            => '',
//				'line_border'           => '',
//				'line_color'            => '',
//				'bg_color'              => '',
//				'bg_radius'             => '',
//				'quote_hide'            => '',
//				'quote_size'            => '',
//				'quote_margin'          => '',
//				'quote_color'           => '',
//				'module_animation'      => '',
//				'el_class'              => '',
//				'bg_size'				=> '',
//				'bg_border_radius'      => '',
//				'bg_background'         => '',
//				'enabled_bg_decor'      => '',
//				'title_uppercase'		=> 'uppercase',
//				'title_subtitle_nowrap' => '',
//				'icon_offset_bottom' => '',
//			), $atts ) );
			
			$atts = vc_map_get_attributes('new_testimonials', $atts);
			extract($atts);

			$uniqid = uniqid('dfd-testimonial-').rand(1,9999);
			
			$el_class .= ' '.esc_attr($uniqid);

			/**************************
			 * Appear Animation
			 *************************/
			
			if ( ! ( $module_animation == '' ) ) {
				$el_class       .= ' cr-animate-gen';
				$animation_data = 'data-animate-type = "' . esc_attr($module_animation) . '" ';
			}
			
			if(isset($title_subtitle_nowrap) && $title_subtitle_nowrap == 'nowrap') {
				$el_class .= ' title-subtitle-nowrap';
			}

			// Create parts of module according to parameters.
			// Avatar HTML.
			if ( ! empty( $image ) ) {
				if(empty($thumb_size)) {
					$thumb_size = 80;
				}
				$image_src = wp_get_attachment_image_src( $image, 'full' );
				$avatar = dfd_aq_resize( $image_src[0], $thumb_size, $thumb_size, true, true, true );

				if ( ( ! empty( $thumb_radius ) ) || ( ! empty( $thumb_border_width ) ) ) {
					$avatar_style .= 'style="';
					if ( ! empty( $thumb_radius ) ) {
						$avatar_style .= 'border-radius:' . esc_html( $thumb_radius ) . 'px; ';
					}
					if ( ! empty( $thumb_border_width ) ) {
						$avatar_style .= 'border:' . esc_html( $thumb_border_width ) . 'px solid ';
					}
					if ( ! empty( $thumb_color ) ) {
						$avatar_style .= esc_html( $thumb_color ) . '; ';
					}
					$avatar_style .= '"';
				}
				
				$attr = Dfd_Theme_Helpers::get_image_attrs($avatar, $image, $thumb_size, $thumb_size);
				global $dfd_ronneby;
				$cover_class = '';
				if(isset($dfd_ronneby['enable_images_lazy_load']) && $dfd_ronneby['enable_images_lazy_load'] == 'on') {
					$cover_class = 'dfd-img-lazy-load';
					$loading_img_src = "data:image/svg+xml;charset=utf-8,%3Csvg xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg' viewBox%3D'0 0 $thumb_size $thumb_size'%2F%3E";
					$img_html = '<img ' .  $avatar_style . ' src="'.$loading_img_src.'" data-src="' . esc_url( $avatar ) . '" width="'.$thumb_size.'" height="'.$thumb_size.'" '.$attr.' />';
				} else {
					$img_html = '<img ' .  $avatar_style . ' src="' . esc_url( $avatar ) . '" width="'.$thumb_size.'" height="'.$thumb_size.'" '.$attr.' />';
				}

				$avatar_html = '<div class="image-wrap '.$cover_class.'">';
				$avatar_html .= $img_html;
				$avatar_html .= '</div>';
			}

			// Author name HTML.
			$author_font_options = _crum_parse_text_shortcode_params( $title_font_options,'feature-title', $use_google_fonts, $custom_fonts );
			$author_style .= $author_font_options['style'];

			$author_html = '<'.$author_font_options['tag'].' class="'.$author_font_options['class'].' testimonial-title" ' . $author_style . '>' . esc_html( $author ) . '</'.$author_font_options['tag'].'>';
			
			if(isset($title_uppercase) && !empty($title_uppercase)) {
				$css_rules .= '.'.esc_js($uniqid).'.dfd-testimonial-item .feature-title {text-transform: '.esc_js($title_uppercase).';}'; 
			}
				
			// Subtitle HTML.
			if ( ! empty( $subtitle ) ) {
				$subtitle_font_options = _crum_parse_text_shortcode_params( $subtitle_font_options, '', $subtitle_use_google_fonts, $subtitle_custom_fonts );
				$subtitle_style .= $subtitle_font_options['style'];

				$subtitle_html = '<'.$subtitle_font_options['tag'].' class="subtitle testimonial-subtitle" ' . $subtitle_style . '>' . esc_html( $subtitle ) . '</'.$subtitle_font_options['tag'].'>';
			}
			// Content HTML.
			$content_font_options = _crum_parse_text_shortcode_params( $content_font_options, '' );
			$content_style .= $content_font_options['style'];

			if ( ( 'style-1' !== $main_style && ! empty( $bg_radius ) ) || ( 'style-1' !== $main_style && ! empty( $bg_color ) ) || ( '80' !== $thumb_size ) ) {
				$content_bg .= 'style="';
				if ( ! empty( $bg_radius ) ) {
					$content_bg .= 'border-radius:' . $bg_radius . 'px;';
				}
				if ( ! empty( $bg_color ) ) {
					$content_bg .= 'background-color: '.$bg_color.';';
				}
				if('style-2' === $main_style){
					if ( '80' !== $thumb_size ) {
						if('layout-1' === $main_layout) {
							$margin = 21;
						} else {
							$margin = 0;
						}
						if ( '80' !== $thumb_size ){
							if ( 'layout-1' === $main_layout || 'layout-2' === $main_layout || 'layout-3' === $main_layout || 'layout-4' === $main_layout ) {
								$bottom = ( intval( (int)$thumb_size / 2 ) + intval((int)$margin) );
								if (!empty($thumb_border_width)){
									$bottom = intval( (int)$thumb_border_width ) + intval( (int)$bottom );
								}
								$content_bg .= 'bottom:-' . $bottom . 'px;';
							} elseif ('layout-5' === $main_layout || 'layout-6' === $main_layout || 'layout-7' === $main_layout|| 'layout-8' === $main_layout){
								$top = ( intval( (int)$thumb_size / 2 ) + intval((int)$margin) );
								if (!empty($thumb_border_width)){
									$top = intval( (int)$thumb_border_width ) + intval( (int)$top );
								}
								$content_bg .= 'top:' . $top . 'px;';
							}
						}
					}
				}
				$content_bg .= '"';
			}

			if( 'style-1' !== $main_style){
				$content_html .= '<div class="content-wrap-bg" ' . $content_bg . '></div>';
			}
			$content_html .= '<div class="dfd-testimonial-content testimonial-content" ' . $content_style . '>';
			$content_html .= esc_html( $description );
			$content_html .= '</div>';

			if ( $line_width || $line_border || $line_color ) {
				$delimiter_style .= 'style="';
				if ( $line_width ) {
					$delimiter_style .= 'width:' . $line_width . 'px;';
				}
				if ( $line_border ) {
					$delimiter_style .= 'height:' . $line_border . 'px;';
				}
				if ( $line_color ) {
					$delimiter_style .= 'background:' . $line_color;
				}
				$delimiter_style .= '"';
			}
			if ( 'yes' !== $line_hide ) {
				$delimiter_html .= '<div class="wrap-delimiter"><div class="testimonial-delimiter" ' . $delimiter_style . '></div></div>';
			}

			if ( $quote_color || $quote_size || $quote_margin ) {
				$quote_style .= 'style="';
				if ( ! empty( $quote_color ) ) {
					$quote_style .= 'color:' . $quote_color . '; ';
				}
				if ( ! empty( $quote_size ) ) {
					$quote_style .= 'font-size:' . $quote_size . 'px; ';
				}
				if ( ! empty( $quote_margin ) ) {
					$quote_style .= 'margin-bottom:' . $quote_margin . 'px; display: inline-block;';
				}
				$quote_style .= '"';
			}
			if ( 'yes' !== $quote_hide ) {
				$icon_html .= '<div class="icon-wrap">';
					$icon_html .= '<i class="navicon-quote-right" ' . $quote_style . '></i>';
				$icon_html .= '</div>';
			}
			if ( 'layout-9' === $main_layout || 'layout-10' === $main_layout ) {
				$align = '';
			}
			
			if($main_style === 'style-1' && $main_layout === 'layout-12') {
				$align = '';
			}
			
			if(isset($enabled_bg_decor) && $enabled_bg_decor == 'enable') {
				$el_class .= ' simbol-with-bg';
				if(isset($bg_size) && $bg_size != '') {
					$css_rules .= '.'.esc_js($uniqid).'.simbol-with-bg .icon-wrap i {width: '.esc_js($bg_size).'px; height: '.esc_js($bg_size).'px; line-height: '.esc_js($bg_size).'px;}';
				}
				if(isset($bg_border_radius) && $bg_border_radius != '') {
					$css_rules .= '.'.esc_js($uniqid).'.simbol-with-bg .icon-wrap i {border-radius: '.esc_js($bg_border_radius).'px;}';
				}
				if(isset($bg_background) && !empty($bg_background)) {
					$css_rules .= '.'.esc_js($uniqid).'.simbol-with-bg .icon-wrap i {background: '.esc_js($bg_background).';}';
				}
				if(isset($icon_offset_bottom) && $icon_offset_bottom != '') {
					$css_rules .= '.'.esc_js($uniqid).'.simbol-with-bg .icon-wrap {padding-bottom: '.esc_js($icon_offset_bottom).'px;}';
				}
			}
			
			if(isset($image_offset) && $image_offset != '') {
				$css_rules .= '.'.esc_js($uniqid).'.layout-9 .image-wrap {margin-right: '.esc_js($image_offset).'px;}';
				$css_rules .= '.'.esc_js($uniqid).'.layout-10 .image-wrap {margin-left: '.esc_js($image_offset).'px;}';
			}

			/**************************
			 * Module Generation.
			 *************************/
			$output .= '<div id='.esc_attr($uniqid).' class="dfd-testimonial-item ' . $main_style . ' ' . $main_layout . ' ' . $align . ' ' . $el_class . '" ' . $animation_data . '>';

			switch ( $main_layout ) {
				case 'layout-1':
					$output .= $icon_html;
					$output .= '<div class="pos-rel">';
					$output .= $content_html;
					$output .= '</div>';
					$output .= '<div class="centered-line">';
					$output .= $delimiter_html;
					$output .= $avatar_html;
					$output .= '</div>';
					$output .= $author_html;
					$output .= $subtitle_html;

					break;
				case 'layout-2':
				case 'layout-3':

					$output .= $icon_html;
					$output .= '<div class="pos-rel">';
					$output .= $content_html;
					if ('style-2' === $main_style){
						$output .= $delimiter_html;
						$output .= '</div>';
					} else{
						$output .= '</div>';
						$output .= $delimiter_html;
					}
					$output .= $avatar_html;
					$output .= $author_html;
					$output .= $subtitle_html;

					break;
				case 'layout-4':
					$output .= $icon_html;
					$output .= '<div class="pos-rel">';
					$output .= $content_html;
					$output .= '</div>';
					$output .= $avatar_html;
					$output .= $author_html;
					$output .= $subtitle_html;
					$output .= $delimiter_html;

					break;
				case 'layout-5':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $author_html;
						$output .= $subtitle_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= $author_html;
						$output .= $subtitle_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $delimiter_html;
					$output .= $icon_html;

					break;
				case 'layout-6':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $delimiter_html;
					$output .= $author_html;
					$output .= $subtitle_html;
					$output .= $icon_html;

					break;
				case 'layout-7':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $delimiter_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= $delimiter_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $author_html;
					$output .= $subtitle_html;
					$output .= $icon_html;

					break;
				case 'layout-8':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $icon_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= $icon_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $delimiter_html;
					$output .= $author_html;
					$output .= $subtitle_html;

					break;
				case 'layout-9':
				case 'layout-10':
					$output .= $avatar_html;
					$output .= '<div class="content-wrap">';
					$output .= '<div class="pos-rel">';
					$output .= $content_html;
					$output .= '</div>';
					$output .= $delimiter_html;
					$output .= '<div class="title-wrap">';
					$output .= $icon_html;
					$output .= $author_html;
					$output .= '<br/>'.$subtitle_html;
					$output .= '</div>';
					$output .= '</div>';

					break;
				case 'layout-11':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $delimiter_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= $delimiter_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $icon_html;
					$output .= $author_html;
					$output .= $subtitle_html;

					break;
				case 'layout-12':
					if ('style-2' === $main_style){
						$output .= '<div class="pos-rel">';
						$output .= $avatar_html;
						$output .= $content_html;
					} else {
						$output .= $avatar_html;
						$output .= '<div class="pos-rel">';
						$output .= $content_html;
					}
					$output .= '</div>';
					$output .= $delimiter_html;
					$output .= $author_html;
					$output .= $subtitle_html;
					$output .= $icon_html;

					break;
			}

			$output .= '</div>';

			if($css_rules != '') {
				$output .= '<script type="text/javascript">'
							. '(function($) {'
								. '$("head").append("<style>'.$css_rules.'</style>");'
							. '})(jQuery);'
						. '</script>';
			}
			
			return $output;
		}
	}
}
if ( class_exists( 'Dfd_Testimonials' ) ) {
	$Dfd_Testimonials = new Dfd_Testimonials;
}
