/**
 * Timeline - a horizontal / vertical timeline component
 * v. 1.1.4
 * Copyright Mike Collins
 * MIT License
 */
"use strict";function _slicedToArray(e,t){return _arrayWithHoles(e)||_iterableToArrayLimit(e,t)||_nonIterableRest()}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}function _iterableToArrayLimit(e,t){var i=[],n=!0,a=!1,l=void 0;try{for(var r,s=e[Symbol.iterator]();!(n=(r=s.next()).done)&&(i.push(r.value),!t||i.length!==t);n=!0);}catch(e){a=!0,l=e}finally{try{n||null==s.return||s.return()}finally{if(a)throw l}}return i}function _arrayWithHoles(e){if(Array.isArray(e))return e}function timeline(e,h){var t,v=[],g="Timeline:",i=window.innerWidth,r=0,p={forceVerticalMode:{type:"integer",defaultValue:600},horizontalStartPosition:{type:"string",acceptedValues:["bottom","top"],defaultValue:"top"},mode:{type:"string",acceptedValues:["horizontal","vertical"],defaultValue:"vertical"},moveItems:{type:"integer",defaultValue:1},startIndex:{type:"integer",defaultValue:0},verticalStartPosition:{type:"string",acceptedValues:["left","right"],defaultValue:"left"},verticalTrigger:{type:"string",defaultValue:"15%"},visibleItems:{type:"integer",defaultValue:3}};function n(e,t,i){t.classList.add(i),e.parentNode.insertBefore(t,e),t.appendChild(e)}function a(e,t){var i=e.getBoundingClientRect(),n=window.innerHeight||document.documentElement.clientHeight,a=p.verticalTrigger.defaultValue.match(/(\d*\.?\d*)(.*)/),l=t.unit,r=t.value,s=n;if("px"===l&&n<=r){console.warn('The value entered for the setting "verticalTrigger" is larger than the window height. The default value will be used instead.');var o=_slicedToArray(a,3);r=o[1],l=o[2]}return"px"===l?s=parseInt(s-r,10):"%"===l&&(s=parseInt(s*((100-r)/100),10)),i.top<=s&&i.left<=(window.innerWidth||document.documentElement.clientWidth)&&0<=i.top+i.height&&0<=i.left+i.width}function l(e,t){e.style.webkitTransform=t,e.style.msTransform=t,e.style.transform=t}function s(e){var t=e.items[r].offsetLeft,i="translate3d(-".concat(t,"px, 0, 0)");l(e.scroller,i)}function o(e){r=e.settings.startIndex,e.timelineEl.classList.add("timeline--horizontal"),function(a){window.innerWidth>a.settings.forceVerticalMode&&(a.itemWidth=a.wrap.offsetWidth/a.settings.visibleItems,a.items.forEach(function(e){e.style.width="".concat(a.itemWidth,"px")}),a.scrollerWidth=a.itemWidth*a.items.length,a.scroller.style.width="".concat(a.scrollerWidth,"px"),function(){var n=0;a.items.forEach(function(e,t){e.style.height="auto";var i=e.offsetHeight;n=n<i?i:n});var i="translateY(".concat(n,"px)");a.items.forEach(function(e,t){e.style.height="".concat(n,"px"),t%2==0?"bottom"===a.settings.horizontalStartPosition?(e.classList.add("timeline__item--bottom"),l(e,i)):e.classList.add("timeline__item--top"):"bottom"!==a.settings.horizontalStartPosition?(e.classList.add("timeline__item--bottom"),l(e,i)):e.classList.add("timeline__item--top")}),a.scroller.style.height="".concat(2*n,"px")}())}(e),s(e),function(e){if(e.items.length>e.settings.visibleItems){var t=document.createElement("button"),i=document.createElement("button"),n=e.items[0].offsetHeight;t.className="timeline-nav-button timeline-nav-button--prev",i.className="timeline-nav-button timeline-nav-button--next",t.textContent="",i.textContent="",t.style.top="".concat(n,"px"),i.style.top="".concat(n,"px"),0===r?t.disabled=!0:r===e.items.length-e.settings.visibleItems&&(i.disabled=!0),e.timelineEl.appendChild(t),e.timelineEl.appendChild(i)}}(e),function(e){var t=e.timelineEl.querySelector(".timeline-divider");t&&e.timelineEl.removeChild(t);var i=e.items[0].offsetHeight,n=document.createElement("span");n.className="timeline-divider",n.style.top="".concat(i,"px"),e.timelineEl.appendChild(n)}(e),function(t){var e=t.timelineEl.querySelectorAll(".timeline-nav-button"),i=t.timelineEl.querySelector(".timeline-nav-button--prev"),n=t.timelineEl.querySelector(".timeline-nav-button--next"),a=t.items.length-t.settings.visibleItems,l=parseInt(t.settings.moveItems,10);[].forEach.call(e,function(e){e.addEventListener("click",function(e){e.preventDefault(),0===(r=this.classList.contains("timeline-nav-button--next")?r+=l:r-=l)||r<0?(r=0,i.disabled=!0,n.disabled=!1):r===a||a<r?(r=a,i.disabled=!1,n.disabled=!0):(i.disabled=!1,n.disabled=!1),s(t)})})}(e)}function c(){v.forEach(function(e){e.timelineEl.style.opacity=0,e.timelineEl.classList.contains("timeline--loaded")||function(e){e.forEach(function(e){n(e.querySelector(".timeline__content"),document.createElement("div"),"timeline__content__wrap"),n(e.querySelector(".timeline__content__wrap"),document.createElement("div"),"timeline__item__inner")})}(e.items),function(e){e.timelineEl.classList.remove("timeline--horizontal","timeline--mobile"),e.scroller.removeAttribute("style"),e.items.forEach(function(e){e.removeAttribute("style"),e.classList.remove("animated","fadeIn","timeline__item--left","timeline__item--right")});var t=e.timelineEl.querySelectorAll(".timeline-nav-button");[].forEach.call(t,function(e){e.parentNode.removeChild(e)})}(e),window.innerWidth<=e.settings.forceVerticalMode&&e.timelineEl.classList.add("timeline--mobile"),"horizontal"===e.settings.mode&&window.innerWidth>e.settings.forceVerticalMode?o(e):function(i){var n=0;i.items.forEach(function(e,t){e.classList.remove("animated","fadeIn"),!a(e,i.settings.verticalTrigger)&&0<t?e.classList.add("animated"):n=t,t%2==("left"===i.settings.verticalStartPosition?1:0)&&window.innerWidth>i.settings.forceVerticalMode?e.classList.add("timeline__item--right"):e.classList.add("timeline__item--left")});for(var e=0;e<n;e+=1)i.items[e].classList.remove("animated","fadeIn");window.addEventListener("scroll",function(){i.items.forEach(function(e){a(e,i.settings.verticalTrigger)&&e.classList.add("fadeIn")})})}(e),e.timelineEl.classList.add("timeline--loaded"),setTimeout(function(){e.timelineEl.style.opacity=1},500)})}e.length&&[].forEach.call(e,function(e){var t,i,n,a=e.id?"#".concat(e.id):".".concat(e.className),l="could not be found as a direct descendant of",r=e.dataset,s={};try{if(!(t=e.querySelector(".timeline__wrap")))throw new Error("".concat(g," .timeline__wrap ").concat(l," ").concat(a));if(!(i=t.querySelector(".timeline__items")))throw new Error("".concat(g," .timeline__items ").concat(l," .timeline__wrap"));n=[].slice.call(i.children,0)}catch(e){return console.warn(e.message),!1}Object.keys(p).forEach(function(e){s[e]=p[e].defaultValue,r[e]?s[e]=r[e]:h&&h[e]&&(s[e]=h[e]),"integer"===p[e].type?s[e]&&function(e,t){return"number"==typeof e||e%1==0||(console.warn("".concat(g,' The value "').concat(e,'" entered for the setting "').concat(t,'" is not an integer.')),!1)}(s[e],e)||(s[e]=p[e].defaultValue):"string"===p[e].type&&p[e].acceptedValues&&-1===p[e].acceptedValues.indexOf(s[e])&&(console.warn("".concat(g,' The value "').concat(s[e],'" entered for the setting "').concat(e,'" was not recognised.')),s[e]=p[e].defaultValue)});var o=p.verticalTrigger.defaultValue.match(/(\d*\.?\d*)(.*)/),c=_slicedToArray(s.verticalTrigger.match(/(\d*\.?\d*)(.*)/),3),d=c[1],m=c[2],u=!0;if(d||(console.warn("".concat(g," No numercial value entered for the 'verticalTrigger' setting.")),u=!1),"px"!==m&&"%"!==m&&(console.warn("".concat(g," The setting 'verticalTrigger' must be a percentage or pixel value.")),u=!1),"%"===m&&(100<d||d<0)?(console.warn("".concat(g," The 'verticalTrigger' setting value must be between 0 and 100 if using a percentage value.")),u=!1):"px"===m&&d<0&&(console.warn("".concat(g," The 'verticalTrigger' setting value must be above 0 if using a pixel value.")),u=!1),!1===u){var f=_slicedToArray(o,3);d=f[1],m=f[2]}s.verticalTrigger={unit:m,value:d},s.moveItems>s.visibleItems&&(console.warn("".concat(g,' The value of "moveItems" (').concat(s.moveItems,') is larger than the number of "visibleItems" (').concat(s.visibleItems,'). The value of "visibleItems" has been used instead.')),s.moveItems=s.visibleItems),s.startIndex>n.length-s.visibleItems&&n.length>s.visibleItems?(console.warn("".concat(g," The 'startIndex' setting must be between 0 and ").concat(n.length-s.visibleItems," for this timeline. The value of ").concat(n.length-s.visibleItems," has been used instead.")),s.startIndex=n.length-s.visibleItems):n.length<=s.visibleItems?(console.warn("".concat(g," The number of items in the timeline must exceed the number of visible items to use the 'startIndex' option.")),s.startIndex=0):s.startIndex<0&&(console.warn("".concat(g," The 'startIndex' setting must be between 0 and ").concat(n.length-s.visibleItems," for this timeline. The value of 0 has been used instead.")),s.startIndex=0),v.push({timelineEl:e,wrap:t,scroller:i,items:n,settings:s})}),c(),window.addEventListener("resize",function(){clearTimeout(t),t=setTimeout(function(){var e=window.innerWidth;e!==i&&(c(),i=e)},250)})}window.jQuery&&(window.jQuery.fn.timeline=function(e){return timeline(this,e),this});