<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
global $dfd_ronneby;
if (isset($dfd_ronneby['custom_logo_image']['url']) && !empty($dfd_ronneby['custom_logo_image']['url'])) :
	$header_logo_width = (isset($dfd_ronneby['header_logo_width']) && !empty($dfd_ronneby['header_logo_width'])) ? $dfd_ronneby['header_logo_width'] : '';
	$header_logo_height = (isset($dfd_ronneby['header_logo_height']) && !empty($dfd_ronneby['header_logo_height'])) ? $dfd_ronneby['header_logo_height'] : '';
	
	$_logo_size = array($header_logo_width, $header_logo_height);
	$custom_logo_image_url = (isset($dfd_ronneby['custom_logo_image']['url']) && $dfd_ronneby['custom_logo_image']['url']) ? $dfd_ronneby['custom_logo_image']['url'] : '';
	$custom_logo_image = dfd_aq_resize($custom_logo_image_url, $_logo_size[0], $_logo_size[1]);
	
	if (empty($custom_logo_image)) {
		$custom_logo_image = $custom_logo_image_url;
	}
	
	$custom_retina_logo_image = '';
	$logo_image_w = '';
	$logo_image_h = '';
	
	if (
		isset($dfd_ronneby['custom_retina_logo_image']['url']) &&
		!empty($dfd_ronneby['custom_retina_logo_image']['url']) &&
		isset($dfd_ronneby['custom_retina_logo_image']['width']) &&
		!empty($dfd_ronneby['custom_retina_logo_image']['width']) &&
		isset($dfd_ronneby['custom_retina_logo_image']['height']) &&
		!empty($dfd_ronneby['custom_retina_logo_image']['height'])
	)
	{
		# Retina ready logo
		$custom_retina_logo_image = $dfd_ronneby['custom_retina_logo_image']['url'];
		$logo_image_w = $dfd_ronneby['custom_retina_logo_image']['width'];
		$logo_image_h = $dfd_ronneby['custom_retina_logo_image']['height'];
	}
		
?>
	<div class="logo-for-panel">
		<div class="inline-block">
			<a href="<?php echo home_url(); ?>">
				<img src="<?php echo esc_url($custom_logo_image); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" data-retina="<?php echo esc_url($custom_retina_logo_image); ?>" data-retina_w="<?php echo esc_attr($logo_image_w); ?>" data-retina_h="<?php echo esc_attr($logo_image_h); ?>" style="height: <?php echo esc_attr($header_logo_height); ?>px;" />
			</a>
		</div>
	</div>
<?php elseif(!class_exists('Dfd_Ronneby_Core_Plugin')) : ?>
	<div class="logo-for-panel">
		<div class="inline-block">
			<a href="<?php echo home_url(); ?>">
				<img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/logo-dark.png" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" width="160" height="33" />
			</a>
		</div>
	</div>
<?php endif;