<?php
/*
* Add-on Name: Portfolio Wide
*/
if(!class_exists('Dfd_Posts')) {
	class Dfd_Posts {
		function __construct(){
			add_action('admin_init',array($this,'blog_init'));
			add_shortcode('dfd_blog',array($this,'blog_shortcode'));
		}
		function blog_init(){
			if(function_exists('vc_map')) {
				vc_map(
					array(
					   'name' => __('Blog posts','dfd'),
					   'base' => 'dfd_blog',
					   'class' => 'vc_interactive_icon',
					   'icon' => 'vc_icon_interactive',
					   'category' => __('DFD VC Addons','dfd'),
					   'description' => __('Displays blog posts','dfd'),
					   'params' => array(
							array(
								'type' => 'dropdown',
								'heading' => __('Blog posts style','dfd'),
								'param_name' => 'blog_posts_styles',
								'value' => array(
									__('Blog isotope', 'dfd') => 'blog_masonry',
									__('Posts slider', 'dfd') => 'posts_slider',
									__('Wide posts', 'dfd') => 'wide_posts',
									__('Posts list', 'dfd') => 'posts_list',
									__('Single post item', 'dfd') => 'single_post',
									__('Last three posts', 'dfd') => 'last_three_posts',
									__('Last four posts', 'dfd') => 'last_four_posts',
								),
							),
							array(
								'type' => 'radio_image_box',
								'heading' => __('post to display','dfd'),
								'param_name' => 'single_custom_post_item',
								'value' => '',
								'options' => dfd_custom_taxonomy_item_select('post'),
								'css' => array(
									'width' => '120px',
									'height' => '120px',
									'background-repeat' => 'repeat',
									'background-size' => 'cover' 
								),
								'show_default' => false,
								'description' => __('Select portfolio item to display', 'dfd'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('single_post')),
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Categories','dfd'),
								'param_name' => 'post_categories',
								'value' => dfd_get_select_options_multi('category'),
								//"description" => __("If the description text is not suiting well on specific screen sizes, you may enable this option - which will hide the description text.",'dfd'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','posts_slider','wide_posts','last_three_posts','last_four_posts','posts_list')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Post categories param','dfd'),
								'param_name' => 'post_catgories_option',
								'value' => array(
									__('Show posts of selected categories','dfd') => 'include',
									__('Show posts excluding selected categories','dfd') => 'exclude',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','posts_slider','wide_posts','last_three_posts','last_four_posts','posts_list')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Image mask style','dfd'),
								'param_name' => 'image_mask_style',
								'value' => array(
									__('No mask','dfd') => '',
									__('Color','dfd') => 'color',
									__('Gradient','dfd') => 'gradient',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider','last_three_posts','last_four_posts','posts_list','single_post')),
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Enable mask by default','dfd'),
								'param_name' => 'image_mask_action',
								'value' => array('Yes, please' => 'yes'),
								'dependency' => array('element' => 'image_mask_style','value' => array('color','gradient')),
							),
							/*
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Image mask opacity', 'dfd'),
								'param_name' => 'image_mask_opacity',
								'value' => 0,
								'dependency' => array('element' => 'image_mask_style','value' => array('color','gradient')),
							),
							*/
							array(
								'type' => 'colorpicker',
								'param_name' => 'image_mask_color',
								'class' => '',
								'heading' => __('Image mask color', 'dfd'),
								'value' => '',
								'dependency' => array('element' => 'image_mask_style','value' => array('color')),
							),
							array(
								'type' => 'gradient',
								'param_name' => 'image_mask_gradient',
								'class' => '',
								'heading' => __('Image mask gradient', 'dfd'),						
								'description' => '',
								'dependency' => array('element' => 'image_mask_style','value' => array('gradient')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Image alignment','dfd'),
								'param_name' => 'posts_list_configuration',
								'value' => array(
									__('Image to the left from description','dfd') => 'left-image',
									__('Image to the right from description','dfd') => 'right-image',
									__('Description under image','dfd') => 'top-image',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_list','single_post')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Main news\' title position','dfd'),
								'param_name' => 'main_news_style',
								'value' => array(
									__('Under thumbnail image','dfd') => '',
									__('In front of thumbnail image','dfd') => 'title-on-image',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('last_three_posts')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Title position','dfd'),
								'param_name' => 'title_position',
								'value' => array(
									__('Over media content','dfd') => 'top',
									__('Under media content','dfd') => 'bottom',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','single_post','last_three_posts','last_four_posts')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Offset', 'dfd'),
								'param_name' => 'query_offset',
								'value' => '',
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','posts_slider','wide_posts','posts_list')),
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Hide excerpt','dfd'),
								'param_name' => 'hide_excerpt',
								'value' => array('Yes, please' => 'yes'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','wide_posts','posts_list','last_three_posts','last_four_posts','single_post')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Excerpt length', 'dfd'),
								'param_name' => 'excerpt_length',
								'value' => '',
								'min' => '1',
								'max' => '30',
								'description' => __('Please select value from 1 to 30 words','dfd'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','wide_posts','posts_list','last_three_posts','last_four_posts','single_post')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Image width', 'dfd'),
								'param_name' => 'image_width',
								'value' => 675,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider','last_three_posts','last_four_posts','posts_list','single_post')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Image height', 'dfd'),
								'param_name' => 'image_height',
								'value' => 450,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider','last_three_posts','last_four_posts','posts_list','single_post')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Small image width', 'dfd'),
								'param_name' => 'small_image_width',
								'value' => 400,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('last_three_posts', 'last_four_posts')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Small image height', 'dfd'),
								'param_name' => 'small_image_height',
								'value' => 350,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('last_three_posts' ,'last_four_posts')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Number of posts to display', 'dfd'),
								'param_name' => 'posts_to_show',
								'value' => 9,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry','posts_slider','wide_posts','posts_list')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Number of slides to display', 'dfd'),
								'param_name' => 'slides_to_show',
								'value' => 4,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Number of slides to scroll', 'dfd'),
								'param_name' => 'slides_to_scroll',
								'value' => 1,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Slideshow speed', 'dfd'),
								'param_name' => 'slideshow_speed',
								'value' => 3000,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Responsive breakpoint one', 'dfd'),
								'param_name' => 'responsive_brekpoint_first',
								'value' => 1280,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
								'group'       => 'Responsive',
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Responsive breakpoint two', 'dfd'),
								'param_name' => 'responsive_brekpoint_second',
								'value' => 1024,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
								'group'       => 'Responsive',
							),
							array(
								'type' => 'number',
								'class' => '',
								'heading' => __('Responsive breakpoint three', 'dfd'),
								'param_name' => 'responsive_brekpoint_third',
								'value' => 675,
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
								'group'       => 'Responsive',
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Enable autoslideshow','dfd'),
								'param_name' => 'auto_slideshow',
								'value' => array('Enable autoslideshow' => 'yes'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Enable pagination','dfd'),
								'param_name' => 'enable_dots',
								'value' => array('Enable pagination' => 'yes'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('posts_slider')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Content alignment','dfd'),
								'param_name' => 'content_alignment',
								"value" => array(
									__('Center','dfd') => "text-center",
									__('Left','dfd') => "text-left",
									__('Right','dfd') => "text-right"
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('wide_posts')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Content width','dfd'),
								'param_name' => 'layout_style',
								'value' => array(
									__('Boxed','dfd') => '',
									__('Full width','dfd') => 'dfd-blog-module-full-width'
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('wide_posts')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Layout mode','dfd'),
								'param_name' => 'masonry_layout_mode',
								'value' => array(
									__('Masonry','dfd') => 'masonry',
									__('Grid','dfd') => 'fitRows'
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry')),
							),
							array(
								'type' => 'checkbox',
								'class' => '',
								'heading' => __('Enable sort panel','dfd'),
								'param_name' => 'enable_sort_panel',
								'value' => array('Enable sort panel' => 'yes'),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Sort panel alignment','dfd'),
								'param_name' => 'sort_panel_alignment',
								'value' => array(
									__('Center','dfd') => 'text-center',
									__('Left','dfd') => 'text-left',
									__('Right','dfd') => 'text-right'
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry')),
							),
							array(
								'type' => 'dropdown',
								'class' => '',
								'heading' => __('Hover effect style for "MORE INFO" button','dfd'),
								'param_name' => 'hover_read_more_style',
								'value' => array(
									__('Shuffle', 'dfd') => 'chaffle',
									__('Slide up', 'dfd') => 'slide-up',
								),
								'dependency' => array('element' => 'blog_posts_styles','value' => array('blog_masonry', 'wide_posts')),
							),
							array(
								'type'        => 'dropdown',
								'class'       => '',
								'heading'     => __( 'Animation', 'dfd' ),
								'param_name'  => 'module_animation',
								'value'       => dfd_module_animation_styles(),
								'description' => __( '', 'dfd' ),
								'group'       => 'Animation Settings',
							),
						),
					)
				);
			}
		}
		// Shortcode handler function for stats banner
		function blog_shortcode($atts) {
			$output = $sort_panel_html = $image_width = $image_height = $works_num = $sort_panel_alignment = $content_alignment = /*$wide_posts_image_height = */ $query_offset = $module_animation = $hover_read_more_style = $single_custom_post_item = $title_position = $posts_to_show = $posts_list_configuration = $main_news_style = $image_mask_style = $image_mask_color = $image_mask_gradient = $image_mask_action = '';
			$hide_excerpt = $layout_style = $masonry_layout_mode = $responsive_brekpoint_first = $responsive_brekpoint_second = $responsive_brekpoint_third = $small_image_width = $small_image_height = 0;
			extract(shortcode_atts( array(
				'blog_posts_styles' => '',
				'post_categories' => '',
				'post_catgories_option' => 'include',
				'posts_list_configuration' => 'left-image',
				'main_news_style' => '',
				'title_position' => 'top',
				'image_width' => '675',
				'image_height' => '450',
				'small_image_width' => '165',
				'small_image_height' => '125',
				'posts_to_show' => '',
				'query_offset' => '',
				'image_mask_style' => '',
				'image_mask_action' => '',
				'image_mask_color' => '',
				'image_mask_gradient' => '',
				'single_custom_post_item' => '',
				'enable_sort_panel' => '',
				'sort_panel_alignment' => 'text-center',
				'slides_to_show' => '',
				'slides_to_scroll' => '',
				'slideshow_speed' => '',
				'responsive_brekpoint_first' => '',
				'responsive_brekpoint_second' => '',
				'responsive_brekpoint_third' => '',
				'auto_slideshow' => '',
				'layout_style' => '',
				'content_alignment' => 'text-center',
				'masonry_layout_mode' => '',
				'enable_dots' => '',
				'hover_read_more_style' => '',
				'module_animation' => '',
				'excerpt_length' => '',
				'hide_excerpt' => '',
			),$atts));
			
			if(empty($hover_read_more_style)) {
				$hover_read_more_style = 'chaffle';
			}
			
			if(empty($works_to_show)) {
				$works_to_show = -1;
			}
			
			if(empty($blog_posts_styles)) {
				$blog_posts_styles = 'blog_masonry';
			}
			
			if(strcmp($blog_posts_styles, 'wide_posts') === 0) {
				$image_width = 70;
			} elseif($image_width == '') {
				$image_width = 675;
			}
			
			if(strcmp($blog_posts_styles, 'wide_posts') === 0) {
				$image_height = 70;
			} elseif($image_height == '') {
				$image_height = 450;
			}
			
			if(empty($small_image_width)) {
				$small_image_width = 165;
			}
			
			if(empty($small_image_height)) {
				$small_image_height = 125;
			}
			
			if(empty($enable_sort_panel)) {
				$enable_sort_panel = false;
			}
			
			if(empty($posts_to_show)) {
				$posts_to_show = 9;
			}
			
			if($blog_posts_styles == 'last_three_posts' || $blog_posts_styles == 'last_four_posts') {
				$posts_to_show = 1;
			} elseif($blog_posts_styles == 'single_post') {
				$posts_to_show = -1;
			} elseif(empty($posts_to_show)) {
				$posts_to_show = 9;
			}
			
			if(empty($slides_to_show)) {
				$slides_to_show = 4;
			}
			
			if(empty($slides_to_scroll)) {
				$slides_to_scroll = 1;
			}
			
			if(empty($slideshow_speed)) {
				$slideshow_speed = 3000;
			}
			
			if(empty($responsive_brekpoint_first)) {
				$responsive_brekpoint_first = 1280;
			}
			
			if(empty($responsive_brekpoint_second)) {
				$responsive_brekpoint_second = 1025;
			}
			
			if(empty($responsive_brekpoint_third)) {
				$responsive_brekpoint_third = 675;
			}
			
			if(empty($auto_slideshow)) {
				$auto_slideshow = 'false';
			} else {
				$auto_slideshow = 'true';
			}
			
			if(empty($enable_dots)) {
				$enable_dots = 'false';
			} else {
				$enable_dots = 'true';
			}
			
			if(empty($masonry_layout_mode)) {
				$masonry_layout_mode = 'masonry';
			}
			
			if($single_custom_post_item == '') {
				$single_custom_post_item = false;
			}
			
			$alignment_class = $image_mask_html = $image_mask_class = '';
			if(strcmp($blog_posts_styles, 'wide_posts') === 0 && $content_alignment != '') {
				$alignment_class .= $content_alignment;
			}
			
			if(strcmp($blog_posts_styles, 'posts_list') === 0 && $posts_list_configuration != '') {
				$alignment_class .= ' dfd-'.$posts_list_configuration;
				$title_position = 'bottom';
			}
			
			if(strcmp($blog_posts_styles, 'last_three_posts') === 0 && $main_news_style != '') {
				$alignment_class .= ' dfd-'.$main_news_style;
			}
			
			if($image_mask_action) {
				$image_mask_class .= 'dfd-hide-on-hover';
			}
			
			if($image_mask_style == 'color' || $image_mask_color != '') {
				$image_mask_html .= '<div class="dfd-image-mask '.esc_attr($image_mask_class).'" style="background: '.esc_attr($image_mask_color).'"></div>';
			} elseif($image_mask_style == 'gradient' || $image_mask_gradient != '') {
				$image_mask_html .= '<div class="dfd-image-mask '.esc_attr($image_mask_class).'" style="'.$image_mask_gradient.'"></div>';
			}
			
			if(empty($image_mask_html) && ($blog_posts_styles == 'posts_slider' || ($blog_posts_styles == 'last_three_posts' && $main_news_style == 'title-on-image'))) {
				$image_mask_html .= '<div class="dfd-image-mask"></div>';
			}
			
			$animate = $animation_data = '';

			if ( ! ( $module_animation == '' ) ) {
				$animate        = ' cr-animate-gen';
				$animation_data = 'data-animate-type = "' . esc_attr($module_animation) . '" ';
			}
			
			$module_id = uniqid('blog-posts-');
			
			ob_start();
			
			echo '<div id="'.$module_id.'" class="dfd-blog-module '.esc_attr($alignment_class).' '.esc_attr($layout_style).' '. esc_attr($blog_posts_styles) .' '.esc_attr($animate).'" '.$animation_data.'>';
				$sticky = get_option( 'sticky_posts' );

				if (!empty($post_categories)){
					$args = array(
						//'category_name' => $post_categories,
						'posts_per_page' => $posts_to_show,
						'ignore_sticky_posts' => 1,
						'post__not_in' => $sticky,
					);
					if($post_catgories_option == 'exclude') {
						$exclude_cats = array();
						$exclude_array = explode(',', $post_categories);
						foreach($exclude_array as $cat) {
							$exclude_cat = get_term_by('slug', $cat, 'category');
							$exclude_cats[] = $exclude_cat->term_id;
						}
						$args['category__not_in'] = $exclude_cats;
					} else {
						$args['category_name'] = $post_categories;
					}
				} else {
					$args = array(
						'posts_per_page' => $posts_to_show,
						'ignore_sticky_posts' => 1,
						'post__not_in' => $sticky,
					);
				}
				
				if($query_offset != '') {
					$args['offset'] = $query_offset;
				}

				$taxonomy = 'category';

				$categories_arr = get_terms($taxonomy);

				if(!empty($categories_arr) && is_array($categories_arr) && !is_wp_error($categories_arr)) {
					$sort_panel_html .= '<div class="sort-panel '.$sort_panel_alignment.'">';
						$sort_panel_html .= '<ul class="filter">';
							$sort_panel_html .= '<li class="active"><a data-filter=".post" href="#">'. __('All', 'dfd') .'</a></li>';
							foreach ($categories_arr as $category) {
								$sort_panel_html .= '<li><a data-filter=".post[data-category~=\'' . strtolower(preg_replace('/\s+/', '-', $category->slug)) . '\']" href="#">' . $category->name . '</a></li>';
							}
						$sort_panel_html .= '</ul>';
					$sort_panel_html .= '</div>';
				}

				if(strcmp($blog_posts_styles, 'blog_masonry') === 0 && $enable_sort_panel) {
					echo $sort_panel_html;
				}

				$the_query = new WP_Query($args);
				
				$posts_list_class = $meta_postfix = '';
				if(strcmp($blog_posts_styles, 'wide_posts') === 0 || strcmp($blog_posts_styles, 'posts_slider') === 0) {
					$meta_postfix .= '-comments';
				}
				
				echo '<div class="posts-list '. esc_attr($posts_list_class) .'">';

					while ($the_query->have_posts()) : $the_query->the_post();

						$_post_id = get_the_ID();

						$terms = get_the_terms($_post_id, 'category');

						$data_categories = '';

						if(!empty($terms) && is_array($terms) && !is_wp_error($terms)) {
							foreach ($terms as $term) {
								$data_categories .= ' '.strtolower(preg_replace('/\s+/', '-', $term->slug));
							}
						}
						
						$heading_html = '';
						$heading_html .= '<div class="title-wrap">';
						$heading_html .= '<div class="block-title"><a href="'. get_permalink() .'">'. get_the_title() .'</a></div>';
						ob_start();
						get_template_part('templates/entry-meta', 'post-bottom'.$meta_postfix);
						$heading_html .= ob_get_clean();
						$heading_html .= '</div>';
						
						$post_class_elems = get_post_class();

						$post_class = implode(' ', $post_class_elems);

						if($_post_id != $single_custom_post_item && strcmp($blog_posts_styles, 'single_post') === 0) {
							continue;
						} else {
							echo '<div class="'. esc_attr($post_class) .'" data-category="'. esc_attr($data_categories) .'">';
								if($title_position == 'top') {
									echo $heading_html;
								}
								echo '<div class="entry-media">';
									if(strcmp($blog_posts_styles, 'blog_masonry') === 0) {
										switch(true) {
											case has_post_format('video'):
												get_template_part('templates/post', 'video');
												break;
											case has_post_format('audio'):
												get_template_part('templates/post', 'audio');
												break;
											case has_post_format('gallery'):
												get_template_part('templates/post', 'gallery');
												break;
											case has_post_format('quote'):
												get_template_part('templates/post', 'quote');
												break;
											default:
												if (has_post_thumbnail()) {
													$thumb = get_post_thumbnail_id();
													$img_url = wp_get_attachment_url($thumb, 'large'); //get img URL

													$article_image = dfd_aq_resize($img_url, 450, null, false, true, false);
													if(!$article_image) {
														$article_image = $img_url;
													}
													echo '<div class="entry-thumb">';
														echo '<img src="'. esc_url($article_image) .'" alt="'. esc_attr(get_the_title()) .'"/>';
														echo '<div class="post-like-wrap">';
															get_template_part('templates/entry-meta/mini', 'like');
														echo '</div>';
													echo '</div>';
												}
										}
									} elseif(strcmp($blog_posts_styles, 'posts_slider') === 0) {
										switch(true) {
											case has_post_format('quote'):
												get_template_part('templates/post', 'quote');
												break;
											default:
												if (has_post_thumbnail()) {
													$thumb = get_post_thumbnail_id();
													$img_url = wp_get_attachment_url($thumb, 'large'); //get img URL

													$article_image = dfd_aq_resize($img_url, $image_width, $image_height, true, true, true);
													if(!$article_image) {
														$article_image = $img_url;
													}
												} else {
													$article_image = get_template_directory_uri() . '/assets/images/no_image_resized_675-450.jpg';
												}
												echo '<div class="entry-thumb">';
													echo $image_mask_html;
													echo '<img src="'. esc_url($article_image) .'" alt="'. esc_attr(get_the_title()) .'"/>';
													echo '<div class="post-like-wrap">';
														get_template_part('templates/entry-meta/mini', 'like');
													echo '</div>';
												echo '</div>';
										}
									} else {
										if (has_post_thumbnail()) {
											$thumb = get_post_thumbnail_id();
											$img_url = wp_get_attachment_url($thumb, 'large'); //get img URL

											$article_image = dfd_aq_resize($img_url, $image_width, $image_height, true, true, true);
											if(!$article_image) {
												$article_image = $img_url;
											}
										} else {
											$article_image = get_template_directory_uri() . '/assets/images/no_image_resized_675-450.jpg';
										}
										echo '<div class="entry-thumb">';
											echo $image_mask_html;
											echo '<img src="'. esc_url($article_image) .'" alt="'. esc_attr(get_the_title()) .'"/>';
											if(strcmp($blog_posts_styles, 'wide_posts') !== 0) {
												echo '<div class="post-like-wrap">';
													get_template_part('templates/entry-meta/mini', 'like');
												echo '</div>';
											}
										echo '</div>';
									}
								echo '</div>';
								if($title_position == 'bottom') {
									echo $heading_html;
								}
								if(strcmp($blog_posts_styles, 'posts_slider') !== 0 && !$hide_excerpt) {
									echo '<div class="entry-content">';
										$content = get_the_excerpt();
										if($excerpt_length != '' && is_numeric($excerpt_length)) {
											$content = wp_trim_words($content, $excerpt_length);
										}
										echo '<p>'.$content.'</p>';
										if(strcmp($blog_posts_styles, 'blog_masonry') === 0 || strcmp($blog_posts_styles, 'wide_posts') === 0) {
											echo '<a href="'. get_permalink() .'" class="more-button '.$hover_read_more_style.'" data-lang="en" title="">'.__('Continue', 'dfd').'</a>';
											if(strcmp($blog_posts_styles, 'blog_masonry') === 0) {
												echo '<div class="entry-meta right">';
													get_template_part('templates/entry-meta/mini', 'comments');
												echo '</div>';
											}
										}
									echo '</div>';
								}
							echo '</div>';
						}

					endwhile; wp_reset_postdata();

				echo '</div>';
				if(strcmp($blog_posts_styles, 'blog_masonry') === 0) {
					echo '<div class="posts-list-hidden"></div>';
				}
			
			if(strcmp($blog_posts_styles, 'last_three_posts') === 0 || strcmp($blog_posts_styles, 'last_four_posts') === 0) {
				$extra_args = $args;
				if(strcmp($blog_posts_styles, 'last_three_posts') === 0) {
					$extra_args['posts_per_page'] = 2;
				}
				if(strcmp($blog_posts_styles, 'last_four_posts') === 0) {
					$extra_args['posts_per_page'] = 3;
				}
				$extra_args['offset'] = 1;
				$extra_query = new WP_Query($extra_args);
				echo '<div class="posts-list additional-posts '. esc_attr($posts_list_class) .'">';
					while ($extra_query->have_posts()) : $extra_query->the_post();
						if (has_post_thumbnail()) {
							$thumb = get_post_thumbnail_id();
							$img_url = wp_get_attachment_url($thumb, 'large'); //get img URL

							$article_image = dfd_aq_resize($img_url, $small_image_width, $small_image_height, true, true, true);
							if(!$article_image) {
								$article_image = $img_url;
							}
						} else {
							$article_image = get_template_directory_uri() . '/assets/images/no_image_resized_675-450.jpg';
						}
						echo '<div class="'. esc_attr($post_class) .' row" data-category="'. esc_attr($data_categories) .'">';
							echo '<div class="entry-media five mobile-two columns">';
								echo '<div class="entry-thumb">';
									echo '<img src="'. esc_url($article_image) .'" alt="'. esc_attr(get_the_title()) .'"/>';
									echo '<div class="post-like-wrap">';
										get_template_part('templates/entry-meta/mini', 'like');
									echo '</div>';
								echo '</div>';
							echo '</div>';
							echo '<div class="title-wrap seven mobile-two columns">';
								echo '<div class="box-name"><a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a></div>';
								echo '<div class="entry-meta meta-bottom">';
									get_template_part('templates/entry-meta/mini', 'date');
								echo '</div>';
							echo '</div>';
						echo '</div>';
					endwhile;
					wp_reset_postdata();
				echo '</div>';
			}
			echo '</div>';
			
			if(strcmp($blog_posts_styles, 'blog_masonry') === 0) {
				
				wp_enqueue_script('isotope');
				
				?>
				<script type="text/javascript">
					(function($) {
						"use strict";
						var $window = $(window);
						
						$(document).ready(function () {
							var $container = $('#<?php echo esc_js($module_id); ?> .posts-list');
							var $items = $('.post', $container);

							var columns = 3;
							var columnsWidth;
							var delim = 20;
														
							var setColumns = function () {
								$items = $('.post', $container);
								var width = $container.width();
								

								switch(true) {
									case (width > 1380): columns = 4; break;
									case (width > 980): columns = 3; break;
									case (width > 640): columns = 2; break;
									default: columns = 1;
								}
								columnsWidth = Math.floor($container.width() / columns);

								$items.width(columnsWidth);
							};

							var runIsotope = function() {
								setColumns();

								$container.isotope({
									layoutMode: '<?php echo esc_js($masonry_layout_mode) ?>',
									/*masonry: {
										columnWidth: columnsWidth,
									},*/
									itemSelector : '.post', 
									resizable : true
								});

								$('body').bind('isotope-add-item', function(e, item) {
									$(item).imagesLoaded(function() {
										$container.isotope('insert', $(item));
									});
								});
							};

							runIsotope();
							$container.imagesLoaded(runIsotope);
							$window.resize(runIsotope);

							$('#<?php echo esc_js($module_id); ?>').find('.sort-panel .filter a').click(function () { 
								var selector = $(this).attr('data-filter');

								$(this).parent().parent().find('> li.active').removeClass('active');
								$(this).parent().addClass('active');

								$container.isotope( { 
									filter : selector 
								});

								return false;
							});
						});
					})(jQuery);
				</script>
			<?php
			}
			
			if(strcmp($blog_posts_styles, 'posts_slider') === 0) {
				
				$breakpoint_first = ($slides_to_show > 3) ? 3 : $slides_to_show;
				
				$breakpoint_second = ($slides_to_show > 2) ? 2 : $slides_to_show;
				?>
				<script type="text/javascript">
					(function($){
						"use strict";
						var $carouselWrap = $("#<?php echo esc_js($module_id) ?>");
						var $carousel = $('.posts-list', $carouselWrap);
						var $window = $(window);
						var windowWidth;
						var postsCarouselFilter = function() {
							windowWidth = $window.width();
							if(windowWidth < 1600) {
								$carousel.slick('slickFilter','.post:not(.format-quote)');
							} else {
								$carousel.slick('slickUnfilter');
							}
						};
						$(document).ready(function(){
							$carousel.slick({
								infinite: true,
								slidesToShow: <?php echo esc_js($slides_to_show) ?>,
								slidesToScroll: <?php echo esc_js($slides_to_scroll) ?>,
								arrows: false,
								dots: <?php echo esc_js($enable_dots) ?>,
								autoplay: <?php echo esc_js($auto_slideshow) ?>,
								autoplaySpeed: <?php echo esc_js($slideshow_speed) ?>,
								responsive: [
									{
										breakpoint: <?php echo esc_js($responsive_brekpoint_first) ?>,
										settings: {
											slidesToShow: <?php echo esc_js($breakpoint_first) ?>,
											infinite: true,
											arrows: false
										}
									},
									{
										breakpoint: <?php echo esc_js($responsive_brekpoint_second) ?>,
										settings: {
											slidesToShow: <?php echo esc_js($breakpoint_second) ?>,
											infinite: true,
											arrows: false,
										}
									},
									{
										breakpoint: <?php echo esc_js($responsive_brekpoint_third) ?>,
										settings: {
											slidesToShow: 1,
											slidesToScroll: 1,
											arrows: false,
										}
									}
								]
							});
							postsCarouselFilter();
						});
						$window.on('load resize', postsCarouselFilter);
						$carouselWrap.find(".next").click(function(e) {
							$carousel.slickNext();

							e.preventDefault();
						});

						$carouselWrap.find(".prev").click(function(e) {
							$carousel.slickPrev();

							e.preventDefault();
						});
						$(".item", $carouselWrap).on("mousedown select",(function(e){
							e.preventDefault();
						}));
					})(jQuery);
				</script>
			<?php }
			
			$output .= ob_get_clean();

			return $output;
		}
	}
}
if(class_exists('Dfd_Posts')) {
	$Dfd_Posts = new Dfd_Posts;
}