<?php
global $dfd_ronneby;

while (have_posts()) : the_post();

get_template_part('templates/header/top', 'page');

$dfd_single_post_layout = get_post_meta(get_the_ID(), 'dfd_single_post_layout', true);
if(empty($dfd_single_post_layout) || $dfd_single_post_layout == 'boxed') {
	$dfd_single_post_layout .= ' row';
}

?>

<section id="layout" class="single-post dfd-equal-height-children">
    <div class="single-post dfd-single-layout-<?php echo esc_attr($dfd_single_post_layout) ?>">

        <?php

        set_layout('single', true);
		
		?>

		<?php get_template_part('templates/inside-pagination'); ?>

            <article <?php post_class(); ?>>
				<div class="entry-data">
					<figure class="author-photo">
						<?php echo get_avatar( get_the_author_meta('ID') , 40 ); ?>
					</figure>
					<?php get_template_part('templates/entry-meta', 'post-bottom'); ?>
				</div>
				<?php
				/*

				 * if (has_post_thumbnail()) {
					$thumb = get_post_thumbnail_id();
					$img_url = wp_get_attachment_url($thumb, 'full'); //get img URL
					if ($dfd_ronneby['post_thumbnails_width'] && $dfd_ronneby['post_thumbnails_height']) {
						$article_image = dfd_aq_resize($img_url, $dfd_ronneby['post_thumbnails_width'], $dfd_ronneby['post_thumbnails_height'], true, true, true);
					} else {
						$article_image = dfd_aq_resize($img_url, 1200, 500, true, true, true);
					}
					?>
					<div class="post-media clearfix">
						<div class="entry-thumb">
							<img src="<?php echo esc_url($article_image); ?>" alt="<?php the_title(); ?>"/>
						</div>
					</div>
				<?php
				}*/
				?>

				<div class="entry-content">

					<?php     

					if(!get_post_format()) {
						get_template_part($post->ID, 'standard');
						the_content();
					} elseif (has_post_format('video')) {
						get_template_part('templates/post', 'video');
						the_content();
					} elseif (has_post_format('gallery')) {
						get_template_part('templates/post', 'gallery');
						the_content();
					} elseif (has_post_format('quote')) {
						get_template_part('templates/post', 'quote');
					} elseif (has_post_format('audio')) {
						get_template_part('templates/post', 'audio');
						the_content();
					}
				 ?>

				</div>
				<div class="dfd-meta-container">
					<div class="post-like-wrap left">
						<?php get_template_part('templates/entry-meta/mini', 'like'); ?>
						<div class="box-name"><?php _e('Recommend', 'dfd'); ?></div>
					</div>
					<div class="dfd-single-share left">
						<?php
						if (isset($dfd_ronneby['post_share_button']) && $dfd_ronneby['post_share_button']) {
							get_template_part('templates/entry-meta/mini', 'share-popup');
						}
						?>
						<div class="box-name"><?php _e('Share', 'dfd'); ?></div>
					</div>
					<div class="dfd-single-tags right">
						<?php get_template_part('templates/entry-meta/mini', 'tags'); ?>
						<div class="box-name"><?php _e('Tagged in', 'dfd'); ?></div>
					</div>
				</div>
				
            </article>


        <?php endwhile; ?>
		
        <?php
		
//*comments_template();*//
echo do_shortcode('[contact-form-7 id="12061" title="homepage"]');

        set_layout('single', false);

        ?>

    </div>
	<?php
		if (isset($dfd_ronneby['blog_items_disp']) && $dfd_ronneby['blog_items_disp']) { ?>
			<div class="block-under-single-post">
				<div class="row">
					<?php echo do_shortcode($dfd_ronneby['block_single_blog_item']); ?>
				</div>
			</div>
	<?php } ?>
</section>

