<?php
global $dfd_ronneby;

$data_atts = '';

$folio_page_style = DfdMetaBoxSettings::compared('folio_layout_style', 'standard');

$folio_items_offset = DfdMetaBoxSettings::compared('folio_items_offset', 0);

$folio_hover_style = DfdMetaBoxSettings::get('folio_hover');
if($folio_hover_style) {
	$folio_hover_style = 'portfolio-hover-style-1';
}

$show_title = DfdMetaBoxSettings::compared('folio_show_title', false);

$show_meta = DfdMetaBoxSettings::compared('folio_show_meta', false);

$show_description = DfdMetaBoxSettings::compared('folio_show_description', false);

$content_alignment = DfdMetaBoxSettings::compared('folio_content_alignment', false);

if(strcmp($folio_page_style, 'masonry') === 0 || strcmp($folio_page_style, 'fitRows') === 0) {
	wp_enqueue_script('isotope');
	wp_enqueue_script('dfd-isotope-portfolio');
	$folio_page_columns = DfdMetaBoxSettings::compared('folio_columns', 1);
	
	$data_atts .= ' data-columns="'.esc_attr($folio_page_columns).'"';
	$data_atts .= ' data-layout-style="'.esc_attr($folio_page_style).'"';
}

$folio_number = get_post_meta($post->ID, 'folio_works_per_page', true);
$number_per_page = ($folio_number) ? $folio_number : '16';

$folio_custom_categories = array();

$selected_custom_categories = wp_get_object_terms($post->ID, 'my-product_category');
if (!empty($selected_custom_categories) && !is_wp_error($selected_custom_categories)) {
	foreach ($selected_custom_categories as $term) {
		$folio_custom_categories[] = $term->term_id;
	}
}

if ($folio_custom_categories) {
	$folio_custom_categories = implode(",", $folio_custom_categories);
}

if (is_front_page()) {
	$page = get_query_var('page');
	$paged = ($page) ? $page : 1;
} else {
	$page = get_query_var('paged');
	$paged = ($page) ? $page : 1;
}

if ($folio_custom_categories) {
	$args = array(
		'post_type' => 'my-product',
		'posts_per_page' => $number_per_page,
		'paged' => $paged,
		'tax_query' => array(
			array(
				'taxonomy' => 'my-product_category',
				'field' => 'id',
				'terms' => $folio_custom_categories,
			)
		)
	);
} else {
	$args = array(
		'post_type' => 'my-product',
		'posts_per_page' => $number_per_page,
		'paged' => $paged
	);
}

if($folio_items_offset) {
	$folio_items_offset = $folio_items_offset / 2;
}
?>
<div class="dfd-potfolio-wrap" <?php echo !empty($folio_items_offset) ? 'style="margin: -'.esc_attr($folio_items_offset).'px;"' : '' ?>>
	<div class="dfd-portfolio dfd-portfolio-<?php echo esc_attr($folio_page_style) ?>" <?php echo $data_atts ?>>
		<?php
		$wp_query = new WP_Query($args);

		while ($wp_query->have_posts()) : $wp_query->the_post();

			if (has_post_thumbnail()) {
				$thumb = get_post_thumbnail_id();
				$img_url = wp_get_attachment_url($thumb, 'full'); //get img URL

				$_folio_id = get_the_id();

				if (metadata_exists('post', $_folio_id, '_folio_image_gallery')) {
					$image_gallery = get_post_meta($_folio_id, '_folio_image_gallery', true);
				} else {
					// Backwards compat
					$attachment_ids = get_posts('post_parent=' . $_folio_id . '&numberposts=-1&post_type=attachment&orderby=menu_order&order=ASC&post_mime_type=image&fields=ids');
					$attachment_ids = array_diff($attachment_ids, array(get_post_thumbnail_id()));
					$image_gallery = implode(',', $attachment_ids);
				}

				$img_src = $img_url;

				if(strcmp($folio_page_style, 'fitRows') === 0) {
					$img_url = dfd_aq_resize($img_url, 900, 600, true, true, true);
				}

				if(!$img_url) {
					$img_url = $img_src;
				}

				$folio_id = uniqid($_folio_id);

				$attachments = array_filter(explode(',', $image_gallery));
				
			?>
				<div class="project <?php echo esc_attr($folio_hover_style); ?>">
					<div class="cover <?php echo esc_attr($content_alignment) ?>" <?php echo !empty($folio_items_offset) ? 'style="padding: '.esc_attr($folio_items_offset).'px;"' : '' ?>>
						<div class="entry-thumb">
							<img src="<?php echo esc_url($img_url); ?>" alt="<?php the_title(); ?>"/>
							<?php get_template_part('templates/portfolio/entry-hover'); ?>
						</div>
						<?php if($show_title || $show_meta || $show_description) : ?>
							<?php if($show_title) : ?>
								<div class="block-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
							<?php endif; ?>

							<?php if($show_meta) : ?>
								<?php get_template_part('templates/folio', 'terms'); ?>
							<?php endif; ?>

							<?php if($show_description) :
								$excerpt = '<p>'.get_the_excerpt().'</p>';
								?>
								<div class="entry-content">
									<?php echo $excerpt; ?>
									<a href="<?php the_permalink(); ?>" class="more-button chaffle" title="" data-lang="en"><?php _e('More', 'dfd'); ?></a>
								</div>
							<?php endif; ?>
						<?php endif; ?>
					</div>
				</div>
			<?php
			}

		endwhile;
		?>
	</div>
		
	<?php if ($wp_query->max_num_pages > 1) : ?>

		<nav class="page-nav">

			<?php echo dfd_kadabra_pagination(); ?>

		</nav>

	<?php endif; ?>

	<?php wp_reset_postdata(); ?>

</div>