<?php

class JPIBFI_Admin {

    private $file;
    private $version;

	private $admin_screen_hook = '';
    private $import_export_settings;
    private $selection_settings;
    private $visual_settings;

	function __construct($file, $version) {
        $this->file = $file;
        $this->version = $version;

        $this->load_dependencies();
        $this->init_settings();

		add_action( 'admin_menu', array( $this, 'print_admin_page_action') );
        add_action( 'admin_enqueue_scripts', array($this, 'add_admin_scripts') );
      
        $jpibfi_plugin = plugin_basename( $this->file );
        add_filter( "plugin_action_links_$jpibfi_plugin", array( $this, 'add_settings_link' ) );
        add_action( 'admin_notices', array( $this, 'show_lightbox_ad' ), 11 );
        add_action( 'admin_notices', array( $this, 'show_pro_ad') );
        add_filter( 'plugin_row_meta', array($this, 'plugin_meta_links'), 10, 2 );
        add_action( 'wp_ajax_jpibfi_remove_pro_ad', array($this, 'remove_pro_ad') );
	}

    function add_settings_link( $links ) {
        $settings_link = '<a href="options-general.php?page=jpibfi_settings">' . __( 'Settings', 'jquery-pin-it-button-for-images' ) . '</a>';
        array_unshift( $links, $settings_link );
        return $links;
    }

    private function load_dependencies(){
        $deps = array(
            'includes/class-jpibfi-ajax-result-builder.php',
            'settings/class-jpibfi-settings-base.php',
            'settings/class-jpibfi-settings-validator.php',
            'settings/class-jpibfi-import-export-settings.php',
            'settings/class-jpibfi-selection-settings.php',
            'settings/class-jpibfi-visual-settings.php'
        );
        foreach ($deps as $dep)
            require_once $dep;
    }

    private function init_settings(){
        $this->import_export_settings = new JPIBFI_Import_Export_Settings();
        $this->selection_settings = new JPIBFI_Selection_Settings();
        $this->visual_settings = new JPIBFI_Visual_Settings();
    }

	public function print_admin_page_action() {

        $name = 'jQuery Pin It Button For Images Lite';

		$this->admin_screen_hook = add_options_page(
			$name,
			$name,
			'manage_options',
			'jpibfi_settings',
			array( $this, 'print_admin_page' )
		);
	}

	public function add_admin_scripts($hook) {
        if ($this->admin_screen_hook === $hook) {
            $this->add_settings_scripts();
        }

        if ('plugins.php' === $hook) { 
            $this->add_remove_ad_scripts();
        }
	}

    private function add_settings_scripts() {
        $plugin_dir_url = plugin_dir_url($this->file);

		wp_enqueue_style( 'jquery-pin-it-button-admin-style', $plugin_dir_url . 'css/admin.css', array(), $this->version, 'all' );
        wp_enqueue_style( 'jpibfi-ad', $plugin_dir_url . 'css/admin-ad.css', array(), $this->version, 'all' );

        $slug = isset( $_GET[ 'tab' ] ) ? $_GET[ 'tab' ] : 'select';
        $settings = array (
            'ajax' => apply_filters('jpibfi_settings_ajax', array (
                'url' => admin_url( 'admin-ajax.php' ),
                'tab' => $slug,
            )),
            'tabs' => $this->get_sorted_tabs(),
            'currentTab' => $slug,
            'page' => 'jpibfi_settings',
            'settings' => apply_filters( 'jpibfi_settings_configuration_' . $slug, array()),
            'i18n' => array (
                'editor' => apply_filters( 'jpibfi_settings_i18n_' . $slug, array('submit' => __('Save Changes', 'jquery-pin-it-button-for-images'))),
                'status' => array (
                    'pending' => __('Saving changes ...', 'jquery-pin-it-button-for-images'),
                ),
            ),
        );
        $settings['version'] = 'lite';
		wp_enqueue_script( 'jpibfi', $plugin_dir_url . 'js/jpibfi.admin.js', array( 'jquery' ), $this->version, false );
        wp_localize_script('jpibfi', 'jpibfi_settings', $settings);

		if ( function_exists( "wp_enqueue_media") ) {
			wp_enqueue_media();
		}
    }

    private function get_sorted_tabs(){
        $settings_tabs = apply_filters('jpibfi_settings_tabs', array());

        /* order tabs by priority */
        $priority = array();
        foreach ($settings_tabs as $key => $tab){
            $priority[$key] = $tab['priority'];
        }
        array_multisort($priority, SORT_ASC, $settings_tabs);
        return $settings_tabs;
    }

	public function print_admin_page() {
        ?>
        <div ng-app="app" class="wrap">
            <h2><?php _e( 'jQuery Pin It Button For Images Options', 'jquery-pin-it-button-for-images' ); ?></h2>
            <div id="icon-plugins" class="icon32"></div>
            <app settings-name="jpibfi_settings"></app>
        </div>
        <?php
	}

    public function show_lightbox_ad() {
        global $hook_suffix;
        if ( $hook_suffix === $this->admin_screen_hook ) {
            ?>
            <div class="updated jpibfi-pro-notice">
                <p><?php echo sprintf(__('Lightbox feature has been transferred to another plugin. Click <a target="_blank" href="%s">here</a> to learn more.', 'jquery-pin-it-button-for-images'), 'http://bit.ly/2cXnS2D'); ?></p>
            </div>
            <?php
        }
    }

    private function add_remove_ad_scripts() {
        $plugin_dir_url = plugin_dir_url($this->file);
        wp_enqueue_style( 'jpibfi-ad', $plugin_dir_url . 'css/admin-ad.css', array(), $this->version, 'all' );
		wp_enqueue_script( 'jpibfi-ad', $plugin_dir_url . 'js/jpibfi-ad.admin.js', array( 'jquery' ), $this->version, false );
    }

    function show_pro_ad() {
        global $hook_suffix;
        $hooks = array();
        $hooks[] = $this->admin_screen_hook;
        if (get_option('jpibfi_pro_ad')) {
            $hooks[] = 'plugins.php';
        }

        if (in_array($hook_suffix, $hooks)) {
            $show_close = 'plugins.php' == $hook_suffix;
            ?>
            <div class="updated jpibfi-pro-notice">
                <p><?php echo sprintf(__('jQuery Pin It Button for Images Pro is available. Click <a target="_blank" href="%s">here</a> to learn more.', 'jquery-pin-it-button-for-images'), 'http://mrsztuczkens.me/jpibfi-pro/'); ?></p>
                <?php if ($show_close): ?><span id="jpibfi_remove_ad" class="dashicons dashicons-no"></span><?php endif; ?>
            </div>
            <?php
        }
    }

    function plugin_meta_links( $links, $file ) {
        $plugin = plugin_basename($this->file);
        if ( $file == $plugin ) {
            return array_merge($links, array( '<a href="http://mrsztuczkens.me/jpibfi-pro/">jQuery Pin It Button for Images Pro</a>' ));
        }
        return $links;
    }

    function remove_pro_ad(){
        delete_option('jpibfi_pro_ad');
        wp_die();
    }
}