<?php

class JPIBFI_Import_Export_Settings extends JPIBFI_Settings_Tab {

    private $ajax_import_action;

    function __construct() {
        parent::__construct();
        $this->ajax_import_action = '_import';
        add_filter( 'export_args', array( $this, 'export_args' ) );
        add_action( 'export_wp', array( $this, 'export_wp' ) );
        add_filter($this->ajax_custom_action . $this->ajax_import_action, array($this, 'ajax_import'));
    }

    function ajax_import() {
        $result = new JPIBFI_Ajax_Result_Builder();
        $file = wp_import_handle_upload();

        if ( isset( $file['error'] ) ) {
            return $result
                ->set_error(esc_html( $file['error'] ))
                ->build();
        }

        if ( ! isset( $file['file'], $file['id'] ) ) {
            return $result
                ->set_error(__( 'The file did not upload properly. Please try again.', 'jquery-pin-it-button-for-images' ))
                ->build();
        }

        if ( ! file_exists( $file['file'] ) ) {
            wp_import_cleanup( $file['id'] );
            return $result
                ->set_error(sprintf( __( 'The export file could not be found at <code>%s</code>. It is likely that this was caused by a permissions problem.', 'jquery-pin-it-button-for-images' ), esc_html( $file['file'] ) ))
                ->build();
        }

        if ( ! is_file( $file['file'] ) ) {
            wp_import_cleanup( $file['id'] );
            return $result
                ->set_error(__( 'The path is not a file, please try again.', 'jquery-pin-it-button-for-images' ))
                ->build();
        }

        $file_contents = file_get_contents( $file['file'] );
        $data = json_decode( $file_contents, true );
        wp_import_cleanup( $file['id']);

        $options_to_import = $data['options'];
        foreach ( (array)$options_to_import as $option_name => $option_value ) {
            $options_to_import[$option_name] = maybe_unserialize( $option_value );
        }

        $converter = new JPIBFI_Option_Converter();
        $converter->save_and_convert_if_needed($options_to_import);
        
        return $result
            ->set_model($input)
            ->set_message(__('Import Successful', 'jquery_pin_it_button_for_images'))
            ->build();
    }

    function filter_settings_i18n($i18n) {
        $i18n['export_title'] = __( 'Export', 'jquery-pin-it-button-for-images' );
        $i18n['export_url'] = admin_url('export.php?download=true&content=jpibfi');
        $i18n['export_button_text'] = __('Download Export File', 'jquery-pin-it-button-for-images');

        $i18n['import_title'] = __( 'Import', 'jquery-pin-it-button-for-images' );
        $i18n['import_button_text'] = __('Import Settings', 'jquery-pin-it-button-for-images');
        $i18n['import_action_name'] = $this->ajax_import_action;
		return $i18n;
	}

	function get_module_settings() {
        return array (
            'slug' => 'import',
            'name' => __( 'Import/Export Settings', 'jquery-pin-it-button-for-images' ),
            'priority' => 10,
            'setting_name' => ''
        );
    }

    /**
     * @param  array $args The export args being filtered.
     * @return array The (possibly modified) export args.
     */
    public function export_args( $args ) {
        if ( ! empty( $_GET['content'] ) && 'jpibfi' == $_GET['content'] ) {
            return array( 'jpibfi' => true );
        }
        return $args;
    }


    /**
     * Export options as a JSON file if that's what the user wants to do.
     *
     * @param  array $args The export arguments.
     * @return void
     */
    public function export_wp( $args ) {
        if (empty($args['jpibfi']))
            return;

        $filename = 'jpibfi_settings_' . date( 'Y-m-d' ) . '.json';

        header( 'Content-Description: File Transfer' );
        header( 'Content-Disposition: attachment; filename=' . $filename );
        header( 'Content-Type: application/json; charset=' . get_option( 'blog_charset' ), true );

        $option_names = apply_filters('jpibfi_option_names', array ('jpibfi_options_version'));

        $export_options = array();

        foreach ( $option_names as $option_name ) {

            $option_value = get_option( $option_name );
            if ( $option_value !== false ) {
                $export_options[ $option_name ] = maybe_serialize( $option_value );
            }
        }
        $JSON_PRETTY_PRINT = defined( 'JSON_PRETTY_PRINT' ) ? JSON_PRETTY_PRINT : null;
        echo json_encode( array( 'options' => $export_options ), $JSON_PRETTY_PRINT );
        exit;
    }
}