<?php

class JPIBFI_Selection_Settings extends JPIBFI_Settings_Base {

	function filter_settings_i18n($i18n) {
		$i18n['title'] = __('Selection settings', 'jquery-pin-it-button-for-images');
		$i18n['image_resolution_label'] = __( 'Minimum image resolution', 'jquery-pin-it-button-for-images' );
		$i18n['image_resolution_desc'] = __( 'Use this settings to hide the "Pin it" button on small images (e.g. social media icons).', 'jquery-pin-it-button-for-images' );
		$i18n['image_resolution_desc_2'] = __( '* - screen that is less than 768 pixels wide', 'jquery-pin-it-button-for-images' );
		$i18n['min_resolution_template_small'] = __('For small screens* the "Pin it" button will show up if the image is at least %height% pixels high and %width% pixels wide.', 'jquery-pin-it-button-for-images');
		$i18n['min_resolution_template'] = __('Otherwise, the "Pin it" button will show up if the image is at least %height% pixels high and %width% pixels wide.', 'jquery-pin-it-button-for-images');
		
		$i18n['show_on_field_label'] = __( 'On which pages the "Pin it" button should be shown', 'jquery-pin-it-button-for-images' );
		$i18n['show_on_field_desc'] = __('Separate settings using commas. For the button to show up on a certain page, the page must be included in the "Show on" section and not included in the "Disable on" section. You can use the following settings:')
			. '<p>'
			. __( 'number (e.g. 588) - the ID of a certain page or post') . '<br/>'
			. __( '[front] - front page') . '<br/>'
			. __( '[single] - single posts') . '<br/>'
			. __( '[page] - single pages') . '<br/>'
			. __( '[archive] - archive pages') . '<br/>'
			. __( '[search] - search pages') . '<br/>'
			. __( '[category] - category pages') . '<br/>'
			. __( '[home] - blog page') . '</p>';
		return $i18n;
	}

	function get_module_settings() {
        return array (
            'slug' => 'select',
            'name' => __('Selection', 'jquery-pin-it-button-for-images'),
            'priority' => 0,
            'setting_name' => $this->get_options()->get_option_name()
        );
    }

	function get_options() {
		return new JPIBFI_Selection_Options();	
	}

	function get_settings_configuration($params) {

        $option_value = $this->options->get();
        $res = array();

        $res['image_selector'] = array (
            'key' => 'image_selector',
			'label' => __( 'Image selector', 'jquery-pin-it-button-for-images' ),
			'desc' => sprintf ( __( 'jQuery selector for all the images that should have the "Pin it" button. Set the value to %s if you want the "Pin it" button to appear only on images in content or %s to appear on all images on site (including sidebar, header and footer). If you know a thing or two about jQuery, you might use your own selector. %sClick here%s to read about jQuery selectors.', 'jquery-pin-it-button-for-images' ),
					'<strong>.jpibfi_container img</strong>',
					'<strong>img</strong>',
					'<a href="http://api.jquery.com/category/selectors/" target="_blank">',
					'</a>'
				)
        );

        $res['disabled_classes'] = array (
            'key' => 'disabled_classes',
			'label' => __( 'Disabled classes', 'jquery-pin-it-button-for-images' ),
			'desc' => __( 'Pictures with these CSS classes won\'t show the "Pin it" button. Please separate multiple classes with semicolons. Spaces are not accepted.',	'jquery-pin-it-button-for-images' )
        );

        $res['enabled_classes'] = array (
            'key' => 'enabled_classes',
			'label' => __( 'Enabled classes', 'jquery-pin-it-button-for-images' ),
			'desc' => __( 'Only pictures with these CSS classes will show the "Pin it" button. Please separate multiple classes with semicolons. If this field is empty, images with any (besides disabled ones) classes will show the Pin It button.', 'jquery-pin-it-button-for-images' ),
        );

		$local_args = array('min' => '0', 'step' => '1');
        $res['min_image_height'] = array_merge($local_args, array('key' => 'min_image_height', 'label' => __('Height', 'jquery-pin-it-button-for-images')));
        $res['min_image_width'] = array_merge($local_args, array('key' => 'min_image_width', 'label' => __('Width', 'jquery-pin-it-button-for-images')));

		$res['min_image_height_small'] = array_merge($local_args, array('key' => 'min_image_height_small', 'label' => __('Height', 'jquery-pin-it-button-for-images')));
        $res['min_image_width_small'] = array_merge($local_args, array('key' => 'min_image_width_small', 'label' => __('Width', 'jquery-pin-it-button-for-images')));

		$res['show_on'] = array (
			'key' => 'show_on',
			'label' => __( 'Show on', 'jquery-pin-it-button-for-images' ),
		);

		$res['disable_on'] = array (
			'key' => 'disable_on',
			'label' => __( 'Disable on', 'jquery-pin-it-button-for-images' ),
		);

        foreach($res as $key => $setting) {
            $res[$key]['value'] = $option_value[$key];
        }

        return $res;
    }

	public function sanitize_selection_options( $input ) {

		$this->sanitize_input($input);
		$output = $this->options->get();

		$validator = new JPIBFI_Settings_Validator($input, $output);
		
		foreach( $input as $key => $value ) {
			switch($key) {
				case 'disabled_classes':
				case 'enabled_classes':
					$field = 'disabled_classes' == $key
						? __( 'Disabled classes', 'jquery-pin-it-button-for-images' )
						: __( 'Enabled classes', 'jquery-pin-it-button-for-images' );
					$error_message = $field . ' - ' . __('the given value doesn\'t meet the requirements. Please correct it and try again.', 'jquery-pin-it-button-for-images');
					$validator->validate_css_class_list($key, $error_message, array());
					break;
				case 'min_image_height':
				case 'min_image_width':
					$field = 'min_image_height' == $key
						? __( 'Minimum image height', 'jquery-pin-it-button-for-images' )
						: __( 'Minimum image width', 'jquery-pin-it-button-for-images' );
					$error_message = $field . ' - ' . sprintf ( __('value must be a number greater or equal to %d.', 'jquery-pin-it-button-for-images'), '0' );
					$validator->validate_number($key, $error_message, array( 'min' => 0));
					break;
				default:
					$output[$key] = $value;
					break;
			}
		}
		return $output;
	}

	function save_settings($input){
        $result = new JPIBFI_Ajax_Result_Builder();
        $this->options->update($input);
        return $result
            ->set_model($input)
            ->set_message(__('Settings saved.', 'jquery-pin-it-button-for-images'))
            ->build();
    }
}