<?php

abstract class JPIBFI_Settings_Tab {

	protected abstract function get_module_settings();

	protected $ajax_custom_action;

	function __construct() {
		$this->ajax_custom_action = 'jpibfi_settings_custom';
		add_action( 'wp_ajax_' . $this->ajax_custom_action, array($this, 'ajax_custom') );
		add_filter( 'jpibfi_settings_ajax', array($this, 'filter_settings_ajax_custom'));
		add_filter( 'jpibfi_settings_tabs', array($this, 'filter_settings_tab'));

		$module_settings = $this->get_module_settings();
		$slug = $module_settings['slug'];
		add_filter('jpibfi_settings_i18n_' . $slug, array($this, 'filter_settings_i18n'));
	}

	function ajax_custom() {
        check_ajax_referer( $this->ajax_custom_action, 'nonce' );
        if (!current_user_can( 'manage_options' ))
            wp_die();

        $action = $_REQUEST['name'];
        $result = apply_filters($this->ajax_custom_action . $action, array());
        wp_send_json( $result );
    }

	function filter_settings_ajax_custom($ajax) {
		$ajax['customAction'] = $this->ajax_custom_action;
        $ajax['customActionNonce'] = wp_create_nonce( $this->ajax_custom_action );
		return $ajax;
	}

	function filter_settings_i18n($i18n){
        return $i18n;
    }

	function filter_settings_tab($tabs) {
        $module_settings = $this->get_module_settings();
        $tabs[] = $module_settings;
        return $tabs;
    }
}

abstract class JPIBFI_Settings_Base extends JPIBFI_Settings_Tab {

	protected $ajax_save_action;
	protected $options;
	public $settings_name;

	function __construct() {
		parent::__construct();
		$this->ajax_save_action = 'jpibfi_settings_save';
		$this->options = $this->get_options();
		$this->settings_name = $this->options->get_option_name();

		$module_settings = $this->get_module_settings();
		$slug = $module_settings['slug'];
		
		add_action( 'wp_ajax_' . $this->ajax_save_action, array($this, 'ajax_save_settings') );
		add_filter( 'jpibfi_settings_ajax', array($this, 'filter_settings_ajax_settings'));
		add_filter('jpibfi_option_names', array($this, 'add_option_name') );
		add_filter('jpibfi_settings_configuration_' . $slug, array($this, 'filter_settings_configuration'));
        add_filter('jpibfi_settings_save_' . $slug, array($this, 'filter_settings_save'));
        add_filter('jpibfi_settings_i18n_' . $slug, array($this, 'filter_settings_i18n'));
		
	}

	public function add_option_name($arr) {
		$arr[] = $this->settings_name;
		return $arr;
	}

	function ajax_save_settings() {
        check_ajax_referer( $this->ajax_save_action, 'nonce' );
        if (!current_user_can( 'manage_options' ))
            wp_die();

        $slug = $_REQUEST['tab'];
        $settings = json_decode(stripslashes($_REQUEST['settings']), true);
        $update_result = apply_filters('jpibfi_settings_save_' . $slug, $settings);
        wp_send_json( $update_result );
    }

	protected function get_checkbox_settings() {
		return array();
	}

	protected abstract function get_options();

	function filter_settings_ajax_settings($ajax) {
		$ajax['saveSettingsAction'] = $this->ajax_save_action;
        $ajax['saveSettingsNonce'] = wp_create_nonce( $this->ajax_save_action );
		return $ajax;
	}

	function filter_settings_tab($tabs) {
        $module_settings = $this->get_module_settings();
        $tabs[] = $module_settings;
        return $tabs;
    }

    function filter_settings_configuration($result){
        return $this->get_settings_configuration($params);
    }

    function filter_settings_save($settings){
        return $this->save_settings($settings);
    }

	function save_settings($input){
        $result = new JPIBFI_Ajax_Result_Builder();
        $this->options->update($input);
        return $result
            ->set_model($input)
            ->set_message(__('Settings saved.', 'jquery-pin-it-button-for-images'))
            ->build();
    }
}