<?php

class JPIBFI_Settings_Validator {

	private $input = null;
	private $output = null;

	function __construct($input_arr, &$output_arr){
		$this->input = $input_arr;
		$this->output = &$output_arr;
	}

	public function add_error($key, $error_text){
		add_settings_error(
			$key,
			esc_attr( 'settings_updated' ),
			$error_text
		);
	}

	public function validate_number($key, $error_message, $validator_settings){
        $this->validate($key, $error_message, 'v_number', $validator_settings);
	}

    public function validate_css_class_list($key, $error_message, $validation_settings){
        $this->validate($key, $error_message, 'v_css_class_names', $validator_settings);
    }

    private function validate($key, $error_message, $validator_name, $validator_settings){
        $value = $this->input[ $key ];
        $valid = call_user_func( array($this, $validator_name), $value, $validator_settings);
        $this->handle_validation_result($valid, $key, $error_message);
    }

	private function handle_validation_result($validation_result, $key, $error_message){
		if ( $validation_result ){
			$this->output[ $key ] = $this->input[ $key ];
		} else {
			$this->add_error($key, $error_message);
		}
	}

    /* V FUNCTIONS */

    /* Checks if given string contains class names separated by semicolons or is empty */
	private function v_css_class_names( $str, $settings ) {
		if ( 0 == strlen( $str ) )
			return true;

		$names = explode( ';', $str );
		$only_class_names = true;

		for( $i = 0; $i < count( $names ) && $only_class_names; $i++ )
			$only_class_names = 1 == preg_match( "/^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$/", $names [ $i ] );

		return $only_class_names;
	}

    private function v_number($value, $settings){
        if (isset($settings['required']) && false == $settings['required'] && '' == $value)
            return true;

        return is_numeric($value) 
            && (!isset($settings[ 'min' ]) || $value >= $settings['min'])
            && (!isset($settings[ 'max' ]) || $value <= $settings['max']);
    }

    /* END V FUNCTIONS */
}