<?php

class JPIBFI_Visual_Settings extends JPIBFI_Settings_Base {

	function filter_settings_i18n($i18n) {
		$i18n['margins_label'] = __( '"Pin it" button margins', 'jquery-pin-it-button-for-images' );
		$i18n['margins_desc'] = sprintf( __( 'Margins are used to adjust the position of the "Pin it" button, but not all margins are used on all button positions. Here is an example. If you\'re using the "%s" position, the button\'s position will be affected only by top and left margins. Bottom and right margins affect "%s" position, etc. The "%s" position does not use any margins at all.', 'jquery-pin-it-button-for-images' ),
			__( 'Top left', 'jquery-pin-it-button-for-images' ),
			__( 'Bottom right', 'jquery-pin-it-button-for-images' ),
			__( 'Middle', 'jquery-pin-it-button-for-images' )
		);
		$i18n['custom_button_label'] = __( 'Custom "Pin It" button', 'jquery-pin-it-button-for-images' );
		$i18n['custom_button_desc'] = __( 'Check the <b>Use custom image</b> checkbox, specify image\'s URL, height and width to use your own Pinterest button design. You can just upload an image using Wordpress media library if you wish.', 'jquery-pin-it-button-for-images' );
		$i18n['custom_button_preview'] = __( 'Custom Pin It button preview', 'jquery-pin-it-button-for-images' );
		$i18n['custom_button_upload'] = __( 'Upload an image using media library','jquery-pin-it-button-for-images');
		$i18n['custom_button_frame_title'] = __('Select your custom "Pin It" button', 'jquery-pin-it-button-for-images');
		$i18n['custom_button_frame_button_text'] = __('Use as "Pin It" button', 'jquery-pin-it-button-for-images');
		$i18n['pro_feature_error'] = sprintf(__('This feature is disabled in this version of the plugin. Consider buying <a target="_blank" href="%s">the PRO version</a>.', 'jquery-pin-it-button-for-images'), 'http://mrsztuczkens.me/jpibfi-pro/');

		return $i18n;
	}

	function get_module_settings() {
        return array (
            'slug' => 'visual',
            'name' => __( 'Visual', 'jquery-pin-it-button-for-images' ),
            'priority' => 1,
            'setting_name' => $this->get_options()->get_option_name()
        );
    }

	function get_options() {
		return new JPIBFI_Visual_Options();	
	}
	
	function get_settings_configuration($params) {

        $option_value = $this->options->get();
        $res = array();

        $res['show_button'] = array (
            'key' => 'show_button',
			'label' => __( 'Show button', 'jquery-pin-it-button-for-images' ),
			'options' => array (
				'hover' => __( 'On hover', 'jquery-pin-it-button-for-images' ),
				'always_touch' => __( 'Always on touch devices', 'jquery-pin-it-button-for-images' ),
				'always' => __( 'Always', 'jquery-pin-it-button-for-images' )
			),
			'desc' => __( 'When the "Pin it" button should be visible.', 'jquery-pin-it-button-for-images' )
        );

		$margin_args = array ('min' => '0', 'step' => '1', 'unit' => 'px');
        $res['button_margin_bottom'] = array_merge($margin_args, array('key' => 'button_margin_bottom', 'label' => __('Bottom', 'jquery-pin-it-button-for-images')));
        $res['button_margin_top'] = array_merge($margin_args, array('key' => 'button_margin_top', 'label' => __('Top', 'jquery-pin-it-button-for-images')));
        $res['button_margin_left'] = array_merge($margin_args, array('key' => 'button_margin_left', 'label' => __('Left', 'jquery-pin-it-button-for-images')));
        $res['button_margin_right'] = array_merge($margin_args, array('key' => 'button_margin_right', 'label' => __('Right', 'jquery-pin-it-button-for-images')));

		$res['button_position'] = array (
            'key' => 'button_position',
			'label' => __( '"Pin it" button position', 'jquery-pin-it-button-for-images' ),
			'options' => array (
				'top-left' => __( 'Top left', 'jquery-pin-it-button-for-images' ),
				'top-right' => __( 'Top right', 'jquery-pin-it-button-for-images' ),
				'bottom-left' => __( 'Bottom left', 'jquery-pin-it-button-for-images' ),
				'bottom-right' => __( 'Bottom right', 'jquery-pin-it-button-for-images' ),
				'middle' => __( 'Middle', 'jquery-pin-it-button-for-images' )
			),
			'desc' => __( 'Where the "Pin it" button should appear on the image.', 'jquery-pin-it-button-for-images' )
        );

		$res['description_option'] = array (
            'key' => 'description_option',
			'label' => __( 'Description source', 'jquery-pin-it-button-for-images' ),
			'options' => array (
				"post_title" => __( 'Post title', 'jquery-pin-it-button-for-images' ),
				"post_excerpt" => __( 'Post description (excerpt)', 'jquery-pin-it-button-for-images' ),
				"img_title" => __( 'Image title attribute', 'jquery-pin-it-button-for-images' ),
				"site_title" => __( 'Site title (Settings->General)', 'jquery-pin-it-button-for-images' ),
				"img_description" => __( 'Image description', 'jquery-pin-it-button-for-images' ),
				"img_caption" => __('Image caption', 'jquery-pin-it-button-for-images' ),
				"img_alt" => __( 'Image alt attribute', 'jquery-pin-it-button-for-images' )
			),
			'desc' => __( 'From where the Pinterest message should be taken. Check which sources should be considered and prioritize them by dragging and dropping. The description will come from the top source that has data. Please note that "Image description" and "Image caption" work properly only for images that were added to your Media Library.', 'jquery-pin-it-button-for-images' )
        );

		$res['pinLinkedImages'] = array (
			'key' => 'pinLinkedImages',
			'label' => __('Pin linked images', 'jquery-pin-it-button-for-images'),
			'text' => __('Active', 'jquery-pin-it-button-for-images'),
			'desc' => __('When checked, pins full-sized images instead of thumbnails (works only if you link thumbnails to their full versions).', 'jquery-pin-it-button-for-images')
		);

		$res['transparency_value'] = array (
			'key' => 'transparency_value',
			'label' => __('Transparency value', 'jquery-pin-it-button-for-images'),
			'desc' => sprintf ( __('Choose transparency (between %.02f and %.02f)', 'jquery-pin-it-button-for-images'), '0.00', '1.00' ),
			'min' => '0',
			'max' => '1',
			'step' => '0.01'
		);

		$res['use_custom_image'] = array (
			'key' => 'use_custom_image',
			'text' => __( 'Use custom image', 'jquery-pin-it-button-for-images' )
		);

		$res['custom_image_url'] = array (
			'key' => 'custom_image_url',
			'label' => __( 'URL address of the image', 'jquery-pin-it-button-for-images' )
		);

		$image_size = array ('min' => '0', 'step' => '1', 'unit' => 'px');
        $res['custom_image_height'] = array_merge($margin_args, array('key' => 'custom_image_height', 'label' => __( 'Height', 'jquery-pin-it-button-for-images' )));
        $res['custom_image_width'] = array_merge($margin_args, array('key' => 'custom_image_width', 'label' => __('Width', 'jquery-pin-it-button-for-images')));

        foreach($res as $key => $setting) {
            $res[$key]['value'] = $option_value[$key];
        }

        return $res;
    }

	public function visual_options_callback() {
		echo '<p>' . __('How it should look like', 'jquery-pin-it-button-for-images') . '</p>';
	}

	public function sanitize_visual_options( $input ) {

		$this->sanitize_input( $input );		
		$output = $this->options->get();

		$validator = new JPIBFI_Settings_Validator($input, $output);
		
		foreach( $input as $key => $value ) {

			switch($key) {
                case 'custom_image_height':
                case 'custom_image_width':
                    $name = "";
                    if ( 'custom_image_height' == $key )
                        $name = __('Custom image height', 'jquery-pin-it-button-for-images' );
                    else if ( 'custom_image_width' == $key )
                        $name = __('Custom image width', 'jquery-pin-it-button-for-images' );
					$error_message = $name . ' - ' . sprintf ( __('value must be empty or a number greater or equal to %d.', 'jquery-pin-it-button-for-images'), '0' );
					$validator->validate_number($key, $error_message, array( 'min' => 0, 'required' => false));
                    break;
				case 'transparency_value':
					$error_message = sprintf( __('Transparency value must be a number between %.02d and %.02f.', 'jquery-pin-it-button-for-images'), '0.00', '1.00' );
					$validator->validate_number($key, $error_message, array( 'min' => 0.0, 'max' => 1.0));
					break;
				default:
					$output[ $key ] = $value;
					break;
			}
		}
		return $this->options->sanitize($output);
	}

	function save_settings($input){
        $result = new JPIBFI_Ajax_Result_Builder();
        $this->options->update($input);
        return $result
            ->set_model($input)
            ->set_message(__('Settings saved.', 'jquery-pin-it-button-for-images'))
            ->build();
    }
}