<?php

class JPIBFI_Option_Converter {

    private $selection_options;
    private $visual_options;

    private $converted_option_name;
    private $converted_option_value;

    public function __construct() {
        $this->selection_options = new JPIBFI_Selection_Options();
        $this->visual_options = new JPIBFI_Visual_Options();

        $this->converted_option_name = 'jpibfi_options_version';
        $this->converted_option_value = '2.0';
    }

    public function convert_if_needed() {
        $converted_val = get_option( $this->converted_option_name );
        if ( $this->converted_option_value === $converted_val )
            return;

        $selection_options = get_option( 'jpibfi_selection_options' );
        if ( $selection_options ) {
            $selection_options = $this->convert_selection_options( $selection_options );
            $this->selection_options->update( $selection_options );
        }

        $visual_options = get_option( 'jpibfi_visual_options' );
        if ( $visual_options ) {
            $visual_options = $this->convert_visual_options( $visual_options );
            $this->visual_options->update( $visual_options );
        }
        $this->finish();
    }

    public function save_and_convert_if_needed($imported_options) {
        if ( !is_array( $imported_options ) )
            return;
        if ( $imported_options[ $this->converted_option_name ] == $this->converted_option_value )
            return;
        
        $selection_options = $imported_options[ 'jpibfi_selection_options' ];
        if ( $selection_options ) {
            $selection_options = $this->convert_selection_options( $selection_options );
            $this->selection_options->update( $selection_options );
        }

        $visual_options = $imported_options[ 'jpibfi_visual_options' ];
        if ( $visual_options ) {
            $visual_options = $this->convert_visual_options( $visual_options );
            $this->visual_options->update( $visual_options );
        }

        $this->finish();
    }

    private function convert_selection_options($options) {
        $new_options = array (
            'image_selector' => $options['image_selector'],
            'disabled_classes' => $options['disabled_classes'],
            'enabled_classes' => $options['enabled_classes'],
            'min_image_height' => is_numeric( $options['min_image_height'] ) ? intval( $options['min_image_height'] ) : 0,
            'min_image_height_small' => is_numeric( $options['min_image_height'] ) ? intval( $options['min_image_height'] ) : 0,
            'min_image_width' => is_numeric( $options['min_image_width'] ) ? intval( $options['min_image_width'] ) : 0,
            'min_image_width_small' => is_numeric( $options['min_image_width'] ) ? intval( $options['min_image_width'] ) : 0,
            'show_on' => $this->create_show_on( $options ),
            'disable_on' => $this->create_disable_on()
        );
        $defaults = $this->selection_options->get_default_options();
        return array_merge($defaults, $new_options);
    }

    private function create_show_on($selection_settings) {
        $show_on = array ();
        if ($selection_settings['show_on_home'] == "1")
            $show_on[] = '[front]';
        
        if ($selection_settings['show_on_single'] == "1")
            $show_on[] = '[single]';

        if ($selection_settings['show_on_page'] == "1")
            $show_on[] = '[page]';

        if ($selection_settings['show_on_category'] == "1") {
            $show_on[] = '[category]';
            $show_on[] = '[archive]';
            $show_on[] = '[search]';
        }

        if ($selection_settings['show_on_blog'] == "1")
            $show_on[] = '[home]';

        return implode(',', $show_on);
    }

    private function create_disable_on() {
        $result = array ();
        $args = array(
            'post_type'	=>	array ( 'page', 'post' ),
            'meta_query' =>	array (
                array ( 'key' => 'jpibfi_meta' )
            )
        );
        $my_query = new WP_Query( $args );
        if( $my_query->have_posts() ) {
            while( $my_query->have_posts() ) {
                $my_query->the_post();
                $post_meta = get_post_meta( get_the_ID(), 'jpibfi_meta', true );
                if ( array_key_exists( 'jpibfi_disable_for_post', $post_meta ) && '1' == $post_meta['jpibfi_disable_for_post'] ) {
                    $result[] = get_the_ID();
                }
            }
        }
        wp_reset_postdata();
        return implode(',', $result);
    }

    private function convert_visual_options($options) {
        $new_options = array (
            'show_button' => $options['show_button'],
            'button_margin_bottom' => is_numeric( $options['button_margin_bottom'] ) ? intval( $options['button_margin_bottom'] ) : 0,
            'button_margin_top' => is_numeric( $options['button_margin_top'] ) ? intval( $options['button_margin_top'] ) : 0,
            'button_margin_left' => is_numeric( $options['button_margin_left'] ) ? intval( $options['button_margin_left'] ) : 0,
            'button_margin_right' => is_numeric( $options['button_margin_right'] ) ? intval( $options['button_margin_right'] ) : 0,
            'button_position' => $this->convert_button_position( $options['button_position'] ),
            'description_option' => $this->convert_description_option( $options['description_option'] ),
            'pinLinkedImages' => $options['pinLinkedImages'] == '1',
            'transparency_value' => is_numeric( $options['transparency_value'] ) ? floatval( $options['transparency_value'] ) : 0.5,
            'use_custom_image' => $options['use_custom_image'] == '1',
            'custom_image_url' => $options['custom_image_url'],
            'custom_image_height' => is_numeric( $options['custom_image_height'] ) ? intval( $options['custom_image_height'] ) : 0,
            'custom_image_width' => is_numeric( $options['custom_image_width'] ) ? intval( $options['custom_image_width'] ) : 0
        );
        $defaults = $this->visual_options->get_default_options();
        return array_merge($defaults, $new_options);
    }

    private function convert_button_position( $button_position ) {
        switch ( $button_position ){
            case '0': return 'top-left';
            case '1': return 'top-right';
            case '2': return 'bottom-left';
            case '3': return 'bottom-right';
            case '4': return 'middle';
            default: return 'top-left';
        }
    }

    private function convert_description_option( $description_option ) {
        switch( $description_option ) {
            case '1': return array ( 'post_title' );
            case '2': return array ( 'post_excerpt' );
            case '3': return array ( 'img_title' );
            case '4': return array ( 'site_title' );
            case '5': return array ( 'img_description' );
            case '6': return array ( 'img_alt' );
            default: return array ( 'img_title', 'img_alt', 'post_title' );
        }
    }

    private function finish() {
        update_option( $this->converted_option_name, $this->converted_option_value );
        delete_option( 'jpibfi_advanced_options' );
        delete_option( 'jpibfi_lightbox_options' );
        delete_post_meta_by_key( 'jpibfi_meta' );
    }
}