<?php

abstract class JPIBFI_Options {

    abstract protected function get_option_name();

    abstract protected function get_default_options();

    protected function sanitize($input){
        return $input;
    }

    public function get() {
        $db_options = get_option( $this->get_option_name() );
        $db_options = $db_options != false ? $db_options : array();
        $defaults = $this->get_default_options();
        $merged = array_merge($defaults, $db_options);
        return $this->sanitize($merged);
    }

    public function update( $val ) {
        update_option( $this->get_option_name(), $val );
    }
}