<?php

class JPIBFI_Visual_Options extends JPIBFI_Options {

    private $image_height = 41;
    private $image_width = 65;

    function get_default_options() {
        $defaults = array(
            'show_button' => 'hover',
            'button_margin_bottom' => 20,
            'button_margin_top' => 20,
            'button_margin_left' => 20,
            'button_margin_right' => 20,
            'button_position' => 'top-left',
            'description_option' => array ( 'img_title', 'img_alt', 'post_title' ),
            'pinLinkedImages' => true,
            'transparency_value' => 0.5,
            'use_custom_image' => false,
            'custom_image_url' => '',
            'custom_image_height' => 0,
            'custom_image_width' => 0
        );
        return $defaults;
    }

    protected function sanitize($input){
        $input['show_button'] = 'hover';
        if ( !is_array( $input['description_option'] ) ) {
            $input['description_option'] = array ( 'img_title', 'img_alt', 'post_title' );
        }
        return $input;
    }

    public function get_options_for_view() {
        $options = $this->get();
        if ($options['use_custom_image']) {
            $options['pinImageWidth'] = $options['custom_image_width'];
            $options['pinImageHeight'] = $options['custom_image_height'];
        } else {
            $options['pinImageWidth'] = $this->image_width;
            $options['pinImageHeight'] = $this->image_height;
        }
        unset( $options['custom_image_width'], $options['custom_image_height'] );
        return $options;
    }

    public function get_option_name() {
        return 'jpibfi_visual_options';
    }
}