<?php
/**
 *       @file  qtrAjaxHandler.php
 *      @brief  This module contains AJAX callbacks
 *
 *     @author  Quttera (qtr), contactus@quttera.com
 *
 *   @internal
 *     Created  01/17/2016
 *    Compiler  gcc/g++
 *     Company  Quttera
 *   Copyright  Copyright (c) 2016, Quttera
 *
 * This source code is released for free distribution under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * =====================================================================================
 */

require_once('qtrExternalScanner.php');
require_once('qtrUtils.php');
require_once('qtrLogger.php');
require_once('qtrFilesScanner.php');
require_once('qtrStats.php');
require_once('qtrScanLock.php');
require_once('qtrIgnoreList.php');
require_once('qtrThreatsWhiteList.php');
require_once('qtrFilesWhiteList.php');

class CQtrAjaxHandler
{

    public static function RunExternalScan()
    {
        if(!current_user_can('manage_options'))
        {
            wp_die(__('You do not have sufficient permissions to access this page.') );
        }
        
        //check_ajax_referer( 'qtr_wm_scanner-scan' );
        $this_url = trim($_POST['_this']);        /* domain name of this server */
        $qtr_url  = trim($_POST['_qtr_url']);     /* quttera investigation server name */
        
        if( empty($this_url) )
        {
            $this_url = CQtrUtils::GetDomainName();
        }
        else if( empty($qtr_url) )
        {
            $qtr_url = "http://wp.quttera.com";
        }

        if( strpos($this_url, "://" ) != false )
        {
            $parse      = parse_url($this_url);
            $this_url   = $parse['host'];
        }
        /* 
        * validate input of host name 
        */
        if(filter_var(gethostbyname($this_url), FILTER_VALIDATE_IP) === FALSE )
        {
            /* send error to frontend */
            echo json_encode( array( 'content' => array( "state" => "Failed to access local server",
                                                        "age" => time(),
                                                        "url" => "localhost" )));
            exit;

        }
        
        /* validate quttera server address */
        if( filter_var($qtr_url, FILTER_VALIDATE_URL) === FALSE )
        {
            /* send error to fronend */
            echo json_encode( array( 'content' => array( "state" => "Failed to access remote server",
                                                        "age" => time(),
                                                        "url" => $this_url )));
            exit;
        }

        $investigation_url =  $qtr_url . "/wp_scan/" . $this_url;

        if( filter_var($investigation_url, FILTER_VALIDATE_URL) === FALSE )
        {
            echo json_encode( array( 'content' => array( "state" => "Remote server address is invalid",
                                                        "age" => time(),
                                                        "url" => "<undefined>" )));
            exit;
        }

        usleep(1000000); //sleep for a second

        //$output = file_get_contents($investigation_url);
        $output = CQtrExternalScanner::SendQuery( $investigation_url );
        
        if( empty($output) )
        {
            //$output = file_get_contents($investigation_url);
            $output = CQtrExternalScanner::SendQuery( $investigation_url );
        
            if( $output == false )
            {
                echo json_encode( array( 'content' => array( "state" => "Failed to access investigation server [ " . $qtr_url . " ]",
                                                            "age" => time(),
                                                            "url" => $this_url,
                                                            "img" => plugins_url( 'loader.gif', __FILE__ )) 
                                        ) 
                                );
                exit;
            }
        }
        
        $output = json_decode($output);
        
        //if state is not finished sleep for a second
        echo json_encode( array( 'content' => $output ) );
        exit;
    }


    public static function IsInternalScanNowRunning()
    {
        if( self::IsInternalScanRunning() ){
	        echo "yes";
	    }else{
            echo "no";
        }

        exit();
    }

    public static function RunInternalScan()
    {
        ignore_user_abort(true);
        ob_start();
        printf("%s:%d  Callback called. Root path: %s\n",__FILE__, __LINE__, ABSPATH );
        ob_flush();
        flush();
        ob_get_clean();

        $logger = new CQtrLogger();
        $logger->Info(sprintf("Starting investigation of %s",ABSPATH));

        /*
        if( self::IsInternalScanRunning() )
        {
            $logger->Error("Internal scan process already running");
            $output = $logger->GetAllLines();
            echo json_encode($output);
            exit(); 
        }*/

        if( self::IsInternalScanRunning() ){
            $logger->Info("Error, internal scan process already running");
            $output = $logger->GetAllLines();
            echo json_encode($output);
            exit();
        }

        if( !CQtrScanLock::Acquire() )
        {
            $logger->Error("Failed to lock internal scan process");
            $output = $logger->GetAllLines();
            echo json_encode($output);
            exit();            
        }

        $stats  = new CQtrStats();
        $stats->Reset(); 

        $exec_sem = new CQtrExecSem();
        $logger->Info("Update execution status to RUN");

        $exec_sem->ShouldStop('RUN');
        $exec_sem->StartedBy('DASHBOARD');

        $scanner = new CQtrFilesScanner();
        $scanner->Initialize();

        //$path =  dirname( __FILE__ ); 
        $path = ABSPATH;

        $logger->Info("Starting scan of $path");
        $scanner->ScanWordPress( $path );
        $logger->Info("Finalize engine execution");
        $scanner->Finalize();
        /*
         * release scan lock
         */
        CQtrScanLock::Release();

        $logger->Info(sprintf("Scan of %s is done.",$path));
        $output = $logger->GetAllLines();
        echo json_encode($output);
        exit();
    }


    public static function StopInternalScan()
    {

        $logger = new CQtrLogger();
        $logger->Info("Handling request to terminate internal scan");

        CQtrScanLock::Release();
        if( CQtrScanLock::IsLocked() ){
            $logger->Error("Failed to remove ScanLock");
            echo "Scan termination failed";
        }else{
            $logger->Info("ScanLock cleanup succeeded");
            echo "ScanLock released";
        }

        exit();

        $exec_sem = new CQtrExecSem();
        /*
        if( $exec_sem->ShouldStop() != "RUN" )
        {
            $logger->Info( "Internal scan is not running. Current execution state is " . $exec_sem->ShouldStop() );
            echo "Internal scan is not running. Current execution state is " . $exec_sem->ShouldStop();
            exit();
        }*/

        $logger->Info("Changing execution state to STOP");
        $exec_sem->ShouldStop('STOP');
        //echo json_encode("Termination done. Execution state" . $exec_sem->ShouldStop());
        if( self::IsInternalScanRunning() ){
            $logger->Error("Termination failed.");
            echo "Termination failed";
        }else{
            $logger->Info("Internal scan termination succeeded.");
            echo "Terminated successfully";
        }
        exit();
    }

    public static function GetLogLines()
    {
        $index  = 0;
        $logger = new CQtrLogger();
        
        if( isset( $_GET['start_line']) ) 
        {
            $index = intval( $_GET['start_line']);
        }

        else if( isset( $_POST['start_line']) ) 
        {
            $index = intval( $_POST['start_line']);
        }


        // $lines = $logger->GetFromLine($index);
        $lines = $logger->GetAllLines();
        echo json_encode($lines);
        exit();
    }

    public static function CleanLogLines()
    {
        $index  = 0;
        $logger = new CQtrLogger();
        $logger->Clean();        
        echo __FUNCTION__ . " called\n";
        exit();
    }


    public static function GetStats()
    {
        $stats      = new CQtrStats();
        $counters   = $stats->Get();
        echo json_encode($counters);
        exit();
    }

    public static function ScannerReport()
    {
        $file = dirname(__FILE__) . DIRECTORY_SEPARATOR . "quttera_wp_report.txt";

        if (file_exists($file)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename='.basename($file));
            header('Content-Transfer-Encoding: binary');
            header('Expires: 0');
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Pragma: public');
            header('Content-Length: ' . filesize($file));

            ob_clean();
            flush();
            readfile($file);
        }else{
            echo "Report has not been found";
        }

        exit();
    }

    public static function GetDetectedThreatsReport()
    {
        $ignore_list        = new CQtrIgnoreList();
        $files_white_list   = new CQtrFilesWhiteList();
        $threats_white_list = new CQtrThreatsWhiteList();

        $report             = new CQtrReport();
        $threats            = $report->Get();
        $output             = array();

        $files_white_list->Load();

        /* remove all ignored threats */
        foreach($threats as $threat ){

            if( $ignore_list->Get( $threat["FILE_MD5"], $threat["THREAT_SIG"] ) != NULL ){
                continue;
            }

            if( $threats_white_list->Get( $threat["FILE_MD5"], $threat["THREAT_SIG"] ) != NULL ){
                continue;
            }

            if( $files_white_list->IsWhiteListed( $threat["FILE_MD5"] ) ){
                continue;
            }
            /*
             * This is not ignored threat 
             */
            //$threat["FILE"] = substr($threat["FILE"],strlen(ABSPATH));
            array_push($output,$threat);
        }

        echo json_encode($output);
        exit();
    }


    public static function GetIgnoredThreatsReport()
    {
        $ignore_list    = new CQtrIgnoreList();
        $report         = new CQtrReport( );
        $threats        = $report->Get();
        $output         = array();

        /*
        echo json_encode( $ignore_list->GetList() );
        exit();
         */
        /* 
         * remove all not-ignored threats 
         */
        foreach( $threats as $threat )
        {
            /*
             * if threat is not part of the ignored list, remove it from output
             */
            if( $ignore_list->Get( $threat["FILE_MD5"], $threat["THREAT_SIG"] ) )
            {
                //unset($threats[$key]);
                array_push($output,$threat);
            }
        }

        echo json_encode($output);
        exit();
    }


    public static function IgnoreThreat()
    {
        $file   = "";
        $threat = "";

        if( isset( $_POST["FILE_MD5"] ) ){
            $file = $_POST["FILE_MD5"];
        }

        if( isset( $_POST["THREAT_SIG"] ) ){
            $threat = $_POST["THREAT_SIG"];
        }

        $ignore_list = new CQtrIgnoreList();
        if( !$ignore_list->Add($file,$threat) ){
            echo json_encode("Operation failed");
        }else if( $ignore_list->Get($file,$threat) == NULL ) {
            echo json_encode("Failed to retrieve just added threat for $file:$threat");
        }else{
            echo json_encode("Operation succeeded"); 
        }
        exit();
    }


    public static function RemoveFromIgnoreList()
    {
        $file   = "";
        $threat = "";

        if( isset( $_POST["FILE_MD5"] ) ){
            $file = $_POST["FILE_MD5"];
        }

        if( isset( $_POST["THREAT_SIG"] ) ){
            $threat = $_POST["THREAT_SIG"];
        }

        $ignore_list = new CQtrIgnoreList();
        if( !$ignore_list->Remove($file,$threat) ){
            echo json_encode("Operation failed");
        }else{
            echo json_encode("Operation succeeded"); 
        }
        exit();
    }

    public static function CleanIgnoreList()
    {
        $ignore_list = new CQtrIgnoreList();
        $ignore_list->Clean();
        echo json_encode("Operation succeeded");
        exit();
    }


    public static function WhiteListThreat()
    {

        $file   = "";
        $threat = "";

        if( isset( $_POST["FILE_MD5"] ) ){
            $file = $_POST["FILE_MD5"];
        }

        if( isset( $_POST["THREAT_SIG"] ) ){
            $threat = $_POST["THREAT_SIG"];
        }

        $ignore_list = new CQtrIgnoreList();
        $white_list  = new CQtrThreatsWhiteList();
        /*
         * Remove threat from ignored list if it is there
         */
        $ignore_list->Remove($file,$threat);

        if( !$white_list->Add($file,$threat) ){
            echo json_encode("Operation failed");
        }else if( $white_list->Get($file,$threat) == NULL ) {
            echo json_encode("Failed to retrieve just added threat for $file:$threat");
        }else{
            echo json_encode("Operation succeeded for $file:$threat"); 
        }
        exit();
    }


    public static function CleanThreatsWhiteList()
    {
        $white_list = new CQtrThreatsWhiteList();
        $white_list->Clean();
        echo json_encode("Operation succeeded");
        exit();
    }


    public static function WhiteListFile()
    {
        $file_path  = NULL;
        $file_sig   = NULL;
        if( isset($_POST["FILE_MD5"] ) ) {
            $file_sig = trim($_POST["FILE_MD5"]);
        }
        if( isset($_POST["FILE"]) ){
            $file_path = trim( $_POST["FILE"] );
        }

        if( $file_path == NULL && $file_sig == NULL ){
            echo json_encode("provided invalid input");
            exit();
        }

        $rc = FALSE;
        $white_list = new CQtrFilesWhiteList();
        $white_list->Load();
        $error = "operation succeeded";
        if( $file_sig ){
            $rc = $white_list->AddBySig( $file_sig );
            if( !$rc ){

                if( $white_list->IsWhiteListed( $file_sig ) ){
                    $error = "$file_sig already whitelisted";
                }else{
                    $error = "$file_sig failed due to invalid input";
                }
            }
        }else{
            $rc = $white_list->AddByPath( $file_path );
            if( !$rc ){
                if( $white_list->IsWhiteListedFile( $file_path ) ){
                    $error = "$file_path already whitelisted";
                }else{
                    $error = "$file_path failed due to invalid input";
                }
            }
        }

        echo json_encode($error);
        exit();
    }


    public static function  CleanFilesWhiteList()
    {   
        $white_list = new CQtrFilesWhiteList();
        if( $white_list->Clean() ){
            echo json_encode("Operation succeeded");
        } else {
            echo json_encode("Operation failed");
        }
        exit();
    }


    public static function IsInternalScanRunning()
    {
        $exist  = is_file( CQtrScanLock::LockName() );
        $locked = CQtrScanLock::IsLocked();
        if( $exist && !$locked )
        {
            /*
             * proccess locked scan, was killed
             */
            $logger = new CQtrLogger();
            $logger->Info(sprintf("Investigation of %s done",ABSPATH));
        }

        return $locked;
    }

}




?>
