<?php
/**
 * Plugin Name: r+ Reveal Shortcode
 * Plugin URI: http://themes.required.ch/
 * Description: A [reveal] shortcode plugin for the required+ Foundation parent theme and child themes, read the manual to get more info.
 * Version: 0.1.1
 * Author: required+ Team
 * Author URI: http://required.ch
 *
 * @package   required+ Foundation
 * @version   0.1.1
 * @author    Silvan Hagen <silvan@required.ch>
 * @copyright Copyright (c) 2012, Silvan Hagen
 * @link      http://themes.required.ch/theme-features/shortcodes/
 * @license   http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */

/**
 * REQ_Reveal Shortcode Class
 *
 * @version 0.1.0
 */
class REQ_Reveal {

    /**
     * Holds the stuff we want to output in the footer
     *
     * @since  0.1.0
     * @access public
     * @var    int
     */
    public $footer_content = array();

    /**
     * Sets up our actions/filters.
     *
     * @since 0.1.0
     * @access public
     * @return void
     */
    public function __construct() {

        /* Register shortcodes on 'init'. */
        add_action( 'init', array( &$this, 'register_shortcode' ) );

        add_action( 'wp_footer', array( &$this, 'add_footer_output' ) );

        /* Apply filters to the reveal content. */
        add_filter( 'req_reveal_content', array( &$this, 'inception_helper' ) );
        add_filter( 'req_reveal_content', 'wpautop' );
        add_filter( 'req_reveal_content', 'shortcode_unautop' );

    }

    /**
     * Registers the [reveal] shortcode.
     *
     * @since  0.1.0
     * @access public
     * @return void
     */
    public function register_shortcode() {
        add_shortcode( 'reveal', array( &$this, 'do_shortcode' ) );
    }

    /**
     * Returns the content of the reveal shortcode.
     *
     * @since  0.1.0
     * @access public
     * @param  array  $attr The user-inputted arguments.
     * @param  string $content The content to wrap in a shortcode.
     * @return string
     */
    public function do_shortcode( $attr, $content = null ) {

        global $post;

        /* If there's no content, just return back what we got. */
        if ( is_null( $content ) )
            return $content;

        /* Set up the default variables. */
        $output = '';
        $footer_output = '';
        $reveal_classes = array();
        $link_classes = array();

        /* Set up the default arguments. */
        $defaults = apply_filters(
            'req_reveal_defaults',
            array(
                'link'  => '',
                'class'  => '',
                'linkclass' => ''
            )
        );

        /* Parse the arguments. */
        $attr = shortcode_atts( $defaults, $attr );

        /* Allow devs to filter the arguments. */
        $attr = apply_filters( 'req_reveal_args', $attr );

        $reveal_classes[] = 'reveal-modal';

        if ( !empty( $attr['class'] ) ) {
            if ( !is_array( $attr['class'] ) )
                $attr['class'] = preg_split( '#\s+#', $attr['class'] );

            $reveal_classes = array_merge( $reveal_classes, $attr['class'] );
        }

        $reveal_class = join( ' ', array_map( 'sanitize_html_class', array_unique( $reveal_classes ) ) );

        if ( !empty( $attr['linkclass'] ) ) {
            if ( !is_array( $attr['linkclass'] ) )
                $attr['linkclass'] = preg_split( '#\s+#', $attr['linkclass'] );

            $link_classes = array_merge( $link_classes, $attr['linkclass'] );
        }

        $link_class = join( ' ', array_map( 'sanitize_html_class', array_unique( $link_classes ) ) );

        $modal_unique_id = 'required-reveal-' . $post->ID . '-' . rand( 1000, 9999 );

        $output = '<a href="#"  class="' . $link_class . '" data-reveal-id="'. esc_attr( $modal_unique_id ) .'">'. esc_attr( $attr['link'] ) . '</a>';

        $footer_output = '<div id="' . esc_attr( $modal_unique_id ) . '" class="' . $reveal_class . '">' . apply_filters('req_reveal_content', $content ) . '<a class="close-reveal-modal">&#215;</a></div>';

        $this->footer_content[] = $footer_output;

        //
        /* Return the output of the reveal. */
        return apply_filters( 'req_reveal', $output );
    }
    /**
     * Retuns the $content of the modal as reveal html
     */
    public function add_footer_output() {

        if ( !empty( $this->footer_content ) ) {

            echo '<!-- Output generated by [reveal] shortcode in this page: -->';

            foreach ( $this->footer_content as $reveal ) {
                echo $reveal;
            }

            echo '<!-- / [reveal] output -->';
        }

    }
    /**
     * Makes nested reveal shortcodes possible
     *
     * Idea from the super ugly: http://www.jshortcodes.com/
     * @param  string $content The content of the shortcode
     * @return string
     */
    public function inception_helper( $content ) {

        // Quick test for presence of possibly nested shortcodes
        if (strpos ($content, '[=') !== FALSE) {
            // remove one '=' --> un-nest one level
            $content = preg_replace('@(\[=*)=(r|/)@', "$1$2", $content);
        }
        return do_shortcode( $content );
    }

}

new REQ_Reveal();