DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1835 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=692 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_comments` VALUES("52","2134","k a t e","sunlit_december@hotmail.com","http://katewang.com/blog","64.131.169.171","2010-01-30 17:02:58","2010-01-30 17:02:58","Add my blog :]: katewang.com/blog
Neat video! Some reason my lagged like crazy even after I let it dl all the way :(. I\'ll try it again another time x]. Thanks for the experience again :]!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("51","2134","Jina of JAC","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.108","2010-01-30 01:05:17","2010-01-30 01:05:17","WILLIAM!!!!! I am even more excited and thrilled that you\'re our photographer! Awesome job!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("49","2134","Chris Chen","chris@chrischenstudios.com","http://www.ChrisChenStudios.com","63.83.24.2","2010-01-29 11:57:04","2010-01-29 11:57:04","Great job dude!  This video changed my mind...I am keeping the Steadicam Merlin.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("50","2134","Sarah Postma","sarah@sarahpostma.com","http://www.sarahpostma.com","173.70.225.20","2010-01-29 12:10:59","2010-01-29 12:10:59","What a fun video, William!  You\'ve got that fusion thing down.  :)
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("30","2128","syed","syphotography@gmail.com","http://syphotography.net","68.80.65.171","2010-01-09 17:02:59","2010-01-09 17:02:59","Beautiful images !! LOVE the one with the cab - perfect .  Btw Congrats on the new blog
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("31","2128","Scott Kretschmann","scott@scottkimages.com","http://www.scottkretschmann.com","74.67.0.3","2010-01-11 21:43:23","2010-01-11 21:43:23","Love the video such a great song! Will we be seeing you at Jason\'s FWF workshop next weekend??
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("32","2128","Jina of JAC","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.108","2010-01-12 21:58:15","2010-01-12 21:58:15","It\'s really cool to see the images come to life! Watching the \"AT WORK\" and the actually result is really cool! Love how vibrant everything looks!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("33","2128","jeevan","jkatwaru@gmail.com","http://www.jkatmoney.com","74.101.151.221","2010-01-14 03:04:05","2010-01-14 03:04:05","I love the video !
pretty interesting to see a behind the scenes take on everything.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("34","2128","williamchang","info@william-chang.com","","98.113.190.42","2010-01-14 18:13:57","2010-01-14 18:13:57","Hey Scott! Yes, I will be attending Jason\'s event next week.  Thank you all for your kind comments!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("35","2128","Rich Schaub","rich@richschaub.com","http://www.RichSchaub.com","67.84.7.52","2010-01-22 05:01:06","2010-01-22 05:01:06","Great Story! Great Moments!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("39","2132","Jina of JAC","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.108","2010-01-23 22:46:22","2010-01-23 22:46:22","aww! William! You are so poetic! What a beautiful job picturing a beautiful couple!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("40","2133","JP Sevillano","jpsevillano@yahoo.com","http://vanjesfoto.com/vjfblog","74.73.253.193","2010-01-25 00:16:57","2010-01-25 00:16:57","This is an awesome shot.  Those are some great locations
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("41","2133","Scott Kretschmann","scott@scottkimages.com","http://www.scottkretschmann.com","74.67.0.3","2010-01-26 22:37:29","2010-01-26 22:37:29","Great info...Thanks for posting!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("42","2133","johnlo","info@john-lo.com","http://www.john-lo.com","24.90.212.30","2010-01-27 17:58:01","2010-01-27 17:58:01","thx for sharing such great location...
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("43","2134","Scott Kretschmann","scott@scottkimages.com","http://www.scottkretschmann.com","74.67.0.3","2010-01-28 21:11:20","2010-01-28 21:11:20","AMAZING! You did a great job..thanks for everything!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("44","2134","johnlo","info@john-lo.com","http://www.john-lo.com","24.90.212.30","2010-01-28 21:19:19","2010-01-28 21:19:19","nice!   Good job with the video William.  that was totally awesome.  and huge thanks to you and Rob for making such an awesome event.  cant wait for the next one.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("45","2134","Jason Groupp","jaso@jasongroupp.com","http://jasongroupp.com","68.38.232.252","2010-01-28 21:25:31","2010-01-28 21:25:31","DUDE!  That rocks!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("46","2134","Carlos Bruno","cb@carlosbruno.com","","68.161.112.119","2010-01-28 22:00:30","2010-01-28 22:00:30","INCREDIBLE ... FANTASTIC WORK!
I am really proud (of myself) to have the chance (and be smart enough to sign up) to participated of this amazing network meet up. Looking forward for the next date!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("47","2134","William Eng","WilliamEng.NYC@gmail.com","http://www.wengphotography.com/blog","74.65.252.25","2010-01-28 22:45:07","2010-01-28 22:45:07","Nice!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("48","2134","Jacky Chen","jchen1013@gmail.com","","71.249.88.48","2010-01-28 22:53:47","2010-01-28 22:53:47","Nice Video..  Really looking forward for the next event.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("53","2134","Fitzpatrick Maurice","pmaurice529@verizon.net","http://www.bklynnativephotography.com","67.102.205.138","2010-02-01 13:01:45","2010-02-01 13:01:45","Dude... This is soooo proper!  Awesome Work!!!  Everyone looks amazing!
@Carlos... I\'m soooo with you dude!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("54","2134","Maggie Harkov","maggie@maggieharkov.com","http://www.maggieharkov.com","208.120.246.12","2010-02-01 13:03:18","2010-02-01 13:03:18","Awesome, William!  It was such fun and you did a great job putting this all together!  So happy to be a part of it!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("55","2135","johnlo","info@john-lo.com","http://www.john-lo.com","24.90.212.30","2010-02-01 08:14:19","2010-02-01 08:14:19","Nice set WIlliam!!   # 6 is my favorite.    Good Stuff!!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("56","2135","Co Ed Bridal Shower Games","","http://ibridalshowergames.com/co-ed-bridal-shower-games/","64.27.20.224","2010-03-04 15:18:13","2010-03-04 15:18:13","<strong>Co Ed Bridal Shower Games</strong>

Games and activities can be found to be tailored to a tra
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("57","2135","Elegant Architecture Bridal Shower Invitations","","http://wheedisb.info/elegant-architecture-bridal-shower-invitations.php","67.228.110.154","2010-12-01 16:26:59","2010-12-01 16:26:59","<strong>Elegant Architecture Bridal Shower Invitations</strong>

","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("58","2136","jenny","jenny@jennyliuphoto.com","http://jennyliublog.com","128.152.20.33","2010-04-14 23:25:21","2010-04-14 23:25:21","OMG how are they not cold? she\'s in short sleeves in winter?!  It was great seeing you at Jerry\'s seminar ! I can see why you like his work so much :)
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("59","2137","Jonelle Melville","jonellemelville@hotmail.com","","71.125.242.103","2010-07-09 22:23:12","2010-07-09 22:23:12","This is so cool! I stumbled on this website and noticed that\'s the exact dress I will be wearing when I  walk down the aisle in a matter of weeks!!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("60","2137","Moonlight Me Too Bridesmaid Dresses","","http://allfootgearrss.endofinternet.net/moonlight-me-too-bridesmaid-dresses","67.202.80.40","2010-07-09 17:55:34","2010-07-09 17:55:34","<strong>Moonlight Me Too Bridesmaid Dresses</strong>

Find bridesmaid dresses Moonlight- ME TOO! In the Me Too
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("61","2137","Me Too Accessories","","http://stylemapweb.endofinternet.org/me-too-accessories/","67.212.92.216","2011-01-25 23:19:40","2011-01-25 23:19:40","<strong>Me Too Accessories</strong>

Slip into Me Too shoes for all day casual Accessories & Gear
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("62","2138","nickBAETA","niklines@yahoo.com","","41.210.3.197","2010-09-28 13:41:32","2010-09-28 13:41:32","This is the coolest i have seen in years. U rock!!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("63","2138","JOse","J_o_e28@yahoo.com","","118.90.90.141","2011-01-21 20:11:06","2011-01-21 20:11:06","can I have one of those lenses pleaaaasssssseee !
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("64","2138","Photos That Inspire Photo Workshop","","http://straighticy.serveftp.org/photos-that-inspire-photo-workshop.asp","208.43.87.58","2010-08-23 00:18:31","2010-08-23 00:18:31","<strong>Photos That Inspire Photo Workshop</strong>

Dan snapped enough photos that were splitting them into MotorMavens-style tw
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("65","2139","Sarah Hassan","s_singh14@hotmail.com","","24.105.132.7","2010-07-31 12:42:57","2010-07-31 12:42:57","Breathtaking, Beautiful pictures.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("66","2140","johnlo","info@john-lo.com","http://www.john-lo.com","24.90.212.30","2010-07-29 20:07:32","2010-07-29 20:07:32","nice job!!!!  you really bring out the characters of this couple.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("67","2140","Anon","iwajad@me.com","","68.39.92.88","2010-07-30 00:30:20","2010-07-30 00:30:20","You are a great inspiration! :)
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("68","2140","Jina of JAC Beauty","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.108","2010-08-03 22:20:21","2010-08-03 22:20:21","William! I\'ve told you this many times before but ... I LOVE the clean look of all these pictures! True raw talent! These make me so excited for our session~~
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("69","2140","Rodney Robinson","rrobinson777@msn.com","","99.35.30.139","2010-08-05 01:05:18","2010-08-05 01:05:18","William, I Love Your Werk!! You Capture The Essence Of Love And Suspend That Moment In Time. Forever&Ever!! Brilliant My Friend!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("70","2141","Chris Chen","chris@chrischenstudios.com","http://www.chrischenstudios.com","24.185.50.254","2010-08-23 23:17:29","2010-08-23 23:17:29","Loving the Time Square photo.  Awesome set.  Congratulation Peter and Yan.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("71","2142","johnlo","info@john-lo.com","http://www.john-lo.com","38.117.225.123","2010-08-25 07:58:59","2010-08-25 07:58:59","very nice William.   Good job on these photos.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("72","2142","Country Club Wedding Invitations","","http://liemovi.info/country-club-wedding-invitations.aspx","67.228.110.154","2011-02-13 18:03:48","2011-02-13 18:03:48","<strong>Country Club Wedding Invitations</strong>

","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("73","2142","Country Club Wedding Invitations","","http://mphhind.info/country-club-wedding-invitations.php","67.228.110.154","2011-04-27 09:31:17","2011-04-27 09:31:17","<strong>Country Club Wedding Invitations</strong>

","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("74","2144","Patrick Pike","patrick@patrickpike.com","http://www.patrickpike.com","76.9.85.206","2010-09-15 00:06:39","2010-09-15 00:06:39","Great session with the perfect mix of loving emotion and raw city energy!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("75","2144","Jay Hsiang Studio","jay@jay-studio.com","http://www.jayhsiang.com","71.154.146.93","2010-09-24 17:38:56","2010-09-24 17:38:56","Such intimate photos! :)
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("76","2144","Shed Foundations","david@shed-building.net","http://www.shed-building.net/","89.172.203.187","2011-03-25 21:38:15","2011-03-25 21:38:15","Hello!
Very interesting site.
Excellent article, bookmarked for future referrence.
You know what you’re doing, so keep at it.
Thanks!!!
David.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("77","2146","johnlo","info@john-lo.com","http://www.john-lo.com","38.117.225.123","2010-10-07 07:42:21","2010-10-07 07:42:21","love the black and white shots.   Good Job WIlliam!!!!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("78","2146","Thomas &amp; Jennifer","jnellis@optonline.net","","24.190.55.92","2010-10-25 19:36:42","2010-10-25 19:36:42","William, Thomas and I thank you so much for your amazing work at our wedding.  We love the pics that you posted and can\'t wait to see all the rest.  Thank you again for everything.
Bride & Groom
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("79","2147","Jina of JAC Beauty","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.65","2010-10-13 20:39:12","2010-10-13 20:39:12","WHOA WHOA WHOA!!! You are an amazing ninja artist!! Thank you William :*) for such beautiful pictures.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("80","2147","Jina of JAC Beauty","jinapak@gmail.com","http://www.jacbeauty.com","208.120.171.65","2010-10-13 20:40:33","2010-10-13 20:40:33","WHOA WHOA WHOA!!! You are an amazing ninja artist!!! Thank you William :*) for such beautiful pictures! We seriously can not wait to party with you in December!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("81","2147","Rosemari Nam","rosemari.nam@gmail.com","","38.98.88.22","2010-10-14 15:46:16","2010-10-14 15:46:16","The pictures make me miss you two more!  I see glimpses of Yug that we normally don\'t get to see! Hehe.  Can\'t wait for Dec. !
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("82","2147","James","James@2bephoto.com","http://www.2bephoto.com/blog","68.173.129.243","2010-10-14 22:37:42","2010-10-14 22:37:42","Hey jina! finally~~ you got great shot. you look beautiful
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("83","2147","Jeniel","jcorpuz@gmail.com","http://www.jcorpuzblog.com","208.91.245.254","2010-10-15 10:17:32","2010-10-15 10:17:32","Looking forward to see the wedding photos.. great set Will.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("84","2148","johnlo photography","johnlo317@gmail.com","http://www.john-lo.com","38.121.143.178","2010-12-01 16:36:11","2010-12-01 16:36:11","nice job William!!!!  :)  Love the lst img alot. ..
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("85","2148","Tammy Labuda","labuda@sbcglobal.net","http://www.tammylabudaphotography.com","67.64.116.165","2010-12-03 00:23:14","2010-12-03 00:23:14","Wow!  William, so creative!  I\'m loving your use of light and your interesting and intimate use of lighting.  Great job!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("86","2148","clippingimages","shemul_07@yahoo.com","http://www.clippingimages.com","203.76.116.66","2011-01-16 23:32:04","2011-01-16 23:32:04","very innovative photography............
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("87","2148","Wedding Photographer New York","rusu55@yahoo.com","http://www.abphotostudio.com","207.38.224.110","2011-03-27 19:17:39","2011-03-27 19:17:39","Great photos. I really love the mod of the last photo.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("88","2149","tammy","labuda@sbcglobal.net","http://www.tammylabudaphotography.com","65.67.112.45","2010-12-06 23:54:02","2010-12-06 23:54:02","William, these are just FABULOUS!  When Michelle sent me the link to her engagement pics I was SO THRILLED to see that you were her photographer.  How exciting.  It seems she found a perfect fit.  You\'ve captured their love with such purity.  LOVE THESE!  Simply incredible!  Keep up the great work.  And, Michelle, you are stunning as always.  May you and your guy be happy for many, many, many years to come.
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("89","2150","clippingimages","shemul_07@yahoo.com","http://www.clippingimages.com","203.76.116.66","2011-01-15 23:15:45","2011-01-15 23:15:45","very innovative photography.........
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("91","2152","Jim Larson","jim@jimlarsonphotography.com","http://www.jimlarsonphotography.com","97.121.38.159","2011-03-23 01:42:17","2011-03-23 01:42:17","Very nice images, William.  Keep up the great work!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("92","2153","phyllis","fillycream@gmail.com","","96.250.212.251","2011-03-23 21:03:50","2011-03-23 21:03:50","i think this is your best album yet! =)
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("93","2156","Pawel Gdynia","pjakusz@gmail.com","http://www.jpj-media.blogspot.com","81.190.75.27","2011-04-19 14:47:21","2011-04-19 14:47:21","perfect colors! nice photos
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("94","2157","Julia","jtzou131@gmail.com","","198.45.18.20","2011-05-02 10:28:30","2011-05-02 10:28:30","The pics looks phenomenal Will.  It was so much fun working with you!  Can\'t wait to see what you\'ll produce from the big day!
","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("95","2160","Cindy","cindykwok@gmail.com","","71.183.176.176","2011-06-26 23:16:40","2011-06-26 23:16:40","These pictures are beautiful, Flo and Rich!  Can\'t wait to see the rest of them!
","0","1","","","0","0");


DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(20) DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(20) DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM AUTO_INCREMENT=206 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) NOT NULL DEFAULT '',
  `log_function` varchar(255) NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(20) DEFAULT NULL,
  `log_username` varchar(20) DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) DEFAULT NULL,
  `log_referrer` varchar(255) DEFAULT NULL,
  `log_data` longtext NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=66192 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(20) DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=41370 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_layerslider`;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE latin1_general_ci NOT NULL,
  `data` mediumtext COLLATE latin1_general_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(11) NOT NULL,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO `wp_layerslider` VALUES("1","Sample slider with 2D transitions","{\"properties\":{\"title\":\"Sample slider with 2D transitions\",\"width\":\"1280\",\"height\":\"720\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"glass\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 50px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"24,25,27,28,34,35,37,38,110,113\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg1.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Ladybug\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/ladybug.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"4600\",\"easingin\":\"easeOutQuad\",\"delayin\":\"0\",\"rotatein\":\"-10\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"544px\",\"left\":\"333px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Ladybug\",\"rel\":\"\"},{\"subtitle\":\"welcome to\",\"type\":\"h5\",\"image\":\"\",\"html\":\"welcome to\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"top\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"350px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"257px\",\"left\":\"50%\",\"style\":\"text-align: center; background: black; background: rgba(0,0,0,.75);  font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"LAYERSLIDER\",\"type\":\"h5\",\"image\":\"\",\"html\":\"LAYERSLIDER\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"400px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#444\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"363px\",\"left\":\"50%\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"The\",\"type\":\"h5\",\"image\":\"\",\"html\":\"The\",\"slidedirection\":\"fade\",\"durationin\":\"2000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"-90\",\"scalein\":\"2.5\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#cf431d\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"249px\",\"left\":\"384px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"content slider\",\"type\":\"h5\",\"image\":\"\",\"html\":\"content slider\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuart\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"5\",\"slideoutdirection\":\"top\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"285px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#cf431d\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"249px\",\"left\":\"490px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with\",\"type\":\"h5\",\"image\":\"\",\"html\":\"with\",\"slidedirection\":\"fade\",\"durationin\":\"2000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2200\",\"rotatein\":\"90\",\"scalein\":\"2.5\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"115px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#cf431d\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"249px\",\"left\":\"781px\",\"style\":\"text-align: center;  font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"breathtaking\",\"type\":\"h5\",\"image\":\"\",\"html\":\"breathtaking\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuart\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"5\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"270px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"325px\",\"left\":\"384px\",\"style\":\"text-align: center; background: black; background: rgba(0,0,0,.75); font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"transitions\",\"type\":\"h5\",\"image\":\"\",\"html\":\"transitions\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuart\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"5\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"236px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"325px\",\"left\":\"660px\",\"style\":\"text-align: center; background: black; background: rgba(0,0,0,.75); font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"and\",\"type\":\"h5\",\"image\":\"\",\"html\":\"and\",\"slidedirection\":\"fade\",\"durationin\":\"2000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2100\",\"rotatein\":\"90\",\"scalein\":\"2.5\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"110px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#444\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"401px\",\"left\":\"384px\",\"style\":\"text-align: center;  font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"awesome\",\"type\":\"h5\",\"image\":\"\",\"html\":\"awesome\",\"slidedirection\":\"bottom\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuart\",\"delayin\":\"1700\",\"rotatein\":\"0\",\"scalein\":\"5\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"205px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#444\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"401px\",\"left\":\"500px\",\"style\":\"text-align: center;  font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"features\",\"type\":\"h5\",\"image\":\"\",\"html\":\"features\",\"slidedirection\":\"fade\",\"durationin\":\"2000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2300\",\"rotatein\":\"-90\",\"scalein\":\"2.5\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"185px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#444\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"401px\",\"left\":\"711px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"76,77,78,79\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg3.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"5000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"200px\",\"left\":\"20px\",\"style\":\"text-align: center; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"touch-enabled\",\"type\":\"h5\",\"image\":\"\",\"html\":\"touch-enabled\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeOutBack\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\".1\",\"slideoutdirection\":\"left\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\"}\",\"top\":\"205px\",\"left\":\"85px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"500\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50PX\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"260px\",\"left\":\"20px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"responsive\",\"type\":\"h5\",\"image\":\"\",\"html\":\"responsive\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeOutBack\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\".1\",\"slideoutdirection\":\"left\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\"}\",\"top\":\"265px\",\"left\":\"85px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with timed layers   captions\",\"type\":\"h5\",\"image\":\"\",\"html\":\"with timed layers\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0\\u00a0captions\",\"slidedirection\":\"bottom\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\".5\",\"slideoutdirection\":\"bottom\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"90%\",\"left\":\"79%\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"&\",\"type\":\"h5\",\"image\":\"\",\"html\":\"&\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1250\",\"rotatein\":\"0\",\"scalein\":\"3\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"3\",\"level\":\"6\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"100px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#f4f8fc\\\\\\\"}\",\"top\":\"570.2899932861328px\",\"left\":\"1002.4000244140625px\",\"style\":\" font-weight: bold;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Clown Fish Text\",\"type\":\"h5\",\"image\":\"\",\"html\":\"Clown Fish\",\"slidedirection\":\"fade\",\"durationin\":\"450\",\"easingin\":\"easeOutQuart\",\"delayin\":\"1750\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"3\",\"level\":\"-1\",\"showuntil\":\"51\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"63%\",\"left\":\"60%\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Clown Fish Photo\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/fish-showcase-3.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"750\",\"easingin\":\"easeOutQuart\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"35%\",\"left\":\"60%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Clown Fish\",\"rel\":\"\"},{\"subtitle\":\"Blue Sergeonfish Text\",\"type\":\"h5\",\"image\":\"\",\"html\":\"Blue Sergeonfish\",\"slidedirection\":\"fade\",\"durationin\":\"450\",\"easingin\":\"easeOutQuart\",\"delayin\":\"3250\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"3\",\"level\":\"-1\",\"showuntil\":\"51\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"63%\",\"left\":\"60%\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Blue Sergeonfish Photo\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/fish-showcase-2.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"750\",\"easingin\":\"easeOutQuart\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"35%\",\"left\":\"60%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Blue Sergeonfish\",\"rel\":\"\"},{\"subtitle\":\"Yellow Tang Text\",\"type\":\"h5\",\"image\":\"\",\"html\":\"Yellow Tang\",\"slidedirection\":\"fade\",\"durationin\":\"450\",\"easingin\":\"easeOutQuart\",\"delayin\":\"4750\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"3\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#2e69ad\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#f0f6fd\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"63%\",\"left\":\"60%\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Yellow Tang Photo\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/fish-showcase-1.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"750\",\"easingin\":\"easeOutQuart\",\"delayin\":\"4500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"35%\",\"left\":\"60%\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Yellow Tang\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"11\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg41.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3300\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Bokeh\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bokeh.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"3600\",\"easingin\":\"easeOutQuad\",\"delayin\":\"0\",\"rotatein\":\"-35\",\"scalein\":\"2\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"35\",\"scaleout\":\"2\",\"level\":\"0\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-200px\",\"left\":\"-78px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Bokeh\",\"rel\":\"\"},{\"subtitle\":\"Tucan\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tucan.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuart\",\"delayin\":\"0\",\"rotatein\":\"20\",\"scalein\":\"1.2\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-10\",\"scaleout\":\"1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"81px\",\"left\":\"434px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tucan\",\"rel\":\"\"},{\"subtitle\":\"Brench\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/brench.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuart\",\"delayin\":\"0\",\"rotatein\":\"20\",\"scalein\":\"1.2\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"254px\",\"left\":\"634px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Brench\",\"rel\":\"\"},{\"subtitle\":\"with\",\"type\":\"h5\",\"image\":\"\",\"html\":\"with\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"35\",\"scaleout\":\"5\",\"level\":\"3\",\"showuntil\":\"701\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#94e60f\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"50%\",\"left\":\"30%\",\"style\":\" border-radius: 5px;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"the famous\",\"type\":\"h5\",\"image\":\"\",\"html\":\"the famous\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"35\",\"scaleout\":\"5\",\"level\":\"3\",\"showuntil\":\"351\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"black\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#94e60f\\\\\\\"}\",\"top\":\"57%\",\"left\":\"30%\",\"style\":\"box-shadow: -2px -2px 15px -3px black; border-radius: 5px;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"parallax effect\",\"type\":\"h5\",\"image\":\"\",\"html\":\"parallax effect\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"35\",\"scaleout\":\"5\",\"level\":\"4\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"60px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#94e60f\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"black\\\\\\\"}\",\"top\":\"67%\",\"left\":\"30%\",\"style\":\"box-shadow: -3px -3px 20px -3px black; border-radius: 5px;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"92,93\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/359529201_1280.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3400\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Video\",\"type\":\"div\",\"image\":\"\",\"html\":\"<iframe src=\\\\\\\"http:\\/\\/player.vimeo.com\\/video\\/52123602?title=0&byline=0&portrait=0\\\\\\\" width=\\\\\\\"1280\\\\\\\" height=\\\\\\\"720\\\\\\\" frameborder=\\\\\\\"0\\\\\\\" webkitAllowFullScreen mozallowfullscreen allowFullScreen><\\/iframe>\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"optional atuo-play\",\"type\":\"h5\",\"image\":\"\",\"html\":\"optional auto-play\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"500\",\"rotatein\":\"-90\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\"1.0\",\"level\":\"1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\"}\",\"top\":\"25px\",\"left\":\"85px\",\"style\":\" font-weight: normal; text-shadow: 0px 0px 20px #224177;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"with auto-pause slideshow\",\"type\":\"h5\",\"image\":\"\",\"html\":\"with auto-pause slideshow\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"-90\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\"1.0\",\"level\":\"1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\"}\",\"top\":\"85px\",\"left\":\"85px\",\"style\":\" font-weight: normal;  text-shadow: 0px 0px 20px #224177;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"easy to add full-sized or windowed videos\",\"type\":\"h5\",\"image\":\"\",\"html\":\"easy to add full-sized or windowed videos\",\"slidedirection\":\"right\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"4500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#224177\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"620px\",\"left\":\"640px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"500\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"55px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#224177\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"20px\",\"left\":\"20px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#224177\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"80px\",\"left\":\"20px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"click to play\",\"type\":\"h5\",\"image\":\"\",\"html\":\"click to play\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"4\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"7\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"24\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#444f70\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"50%\",\"left\":\"40%\",\"style\":\" font-weight: normal; opacity: .6; filter: alpha(opacity=60);\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg7a.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#3b173d\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"630px\",\"left\":\"40px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"you can use now long backgrounds on multiple slides...\",\"type\":\"h5\",\"image\":\"\",\"html\":\"you can now use long backgrounds on multiple slides...\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\"}\",\"top\":\"635px\",\"left\":\"105px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg7b.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"...to create a spectacular panorama slideshow!\",\"type\":\"h5\",\"image\":\"\",\"html\":\"...to create a spectacular panorama slideshow!\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\"}\",\"top\":\"635px\",\"left\":\"40px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"105,106\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg5.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"...and much more!\",\"type\":\"h5\",\"image\":\"\",\"html\":\"...and much more!\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0.5\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"0.5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"60px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ff7700\\\\\\\"}\",\"top\":\"100px\",\"left\":\"700px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"use with any HTML content\",\"type\":\"h5\",\"image\":\"\",\"html\":\"use with any HTML content\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"335px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"built-in powerful API\",\"type\":\"h5\",\"image\":\"\",\"html\":\"built-in powerful API\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"395px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"supports all major browsers\",\"type\":\"h5\",\"image\":\"\",\"html\":\"supports all major browsers\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"455px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"SEO friendly\",\"type\":\"h5\",\"image\":\"\",\"html\":\"SEO friendly\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"2300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"515px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"sample sliders included\",\"type\":\"h5\",\"image\":\"\",\"html\":\"sample sliders included\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"2800\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"575px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"free updates & support\",\"type\":\"h5\",\"image\":\"\",\"html\":\"free updates & support\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"3300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#85c201\\\\\\\"}\",\"top\":\"635px\",\"left\":\"761px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"500\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"330px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"390px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"450px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"510px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"570px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"3000\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#85c201\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"630px\",\"left\":\"700px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Cellphone\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/layerslider-on-cellphone.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"607px\",\"left\":\"164px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"LayerSlider on cellphone\",\"rel\":\"\"},{\"subtitle\":\"Tablet\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/layerslider-on-tablet.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"583px\",\"left\":\"222px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"LayerSlider on tablet\",\"rel\":\"\"},{\"subtitle\":\"Computer\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/layerslider-on-computer.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"457px\",\"left\":\"316px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"LayerSlider on computer\",\"rel\":\"\"}]}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("2","Sample slider with 3D transitions","{\"properties\":{\"title\":\"Sample slider with 3D transitions\",\"width\":\"1000\",\"height\":\"500\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"borderlesslight\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 50px;\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"hoverbottomnav\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"15\",\"2d_transitions\":\"all\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/abyss-bg.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"7200\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"BG fishes far\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg-fishes-far.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"50\",\"easingin\":\"linear\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"11000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"186px\",\"left\":\"701px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"BG fishes far 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg-fishes-far.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"50\",\"easingin\":\"linear\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"9000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"251px\",\"left\":\"857px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"BG fishes middle\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg-fishes-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"3000\",\"easingin\":\"linear\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"131px\",\"left\":\"358px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fishes\",\"rel\":\"\"},{\"subtitle\":\"BG fishes middle 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg-fishes-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"linear\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"196px\",\"left\":\"255px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fishes\",\"rel\":\"\"},{\"subtitle\":\"Abyss BG mask\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/abyss-bg-mask.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"0\",\"easingin\":\"linear\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"0\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Abyss\",\"rel\":\"\"},{\"subtitle\":\"LayerSlider\",\"type\":\"h1\",\"image\":\"\",\"html\":\"LayerSlider\",\"slidedirection\":\"fade\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"2500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"30%\",\"left\":\"50%\",\"style\":\"text-shadow: 0px 0px 20px white; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"3D\",\"type\":\"h1\",\"image\":\"\",\"html\":\"3D\",\"slidedirection\":\"fade\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"2500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"120px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"50%\",\"left\":\"50%\",\"style\":\"text-shadow: 0px 0px 20px white; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"demo slider\",\"type\":\"h1\",\"image\":\"\",\"html\":\"demo slider\",\"slidedirection\":\"fade\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"2500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"70%\",\"left\":\"50%\",\"style\":\"text-shadow: 0px 0px 20px white; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Shark\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/shark.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"6500\",\"easingin\":\"linear\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"0\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"1000px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Shark\",\"rel\":\"\"},{\"subtitle\":\"Small fish far\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-fish-far.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuad\",\"delayin\":\"2000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"4000\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"218px\",\"left\":\"481px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Small fish far 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-fish-far.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuad\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"286px\",\"left\":\"646px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Small fish middle\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-fish-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuad\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"4000\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"315px\",\"left\":\"325px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Small fish close\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-fish-close.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"4000\",\"easingin\":\"easeOutQuad\",\"delayin\":\"3500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"2500\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"695px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Small fish middle 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-fish-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"3000\",\"easingin\":\"linear\",\"delayin\":\"2800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"84px\",\"left\":\"458px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Medium fish middle\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/med-fish-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"5\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"272px\",\"left\":\"685px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Medium fish middle 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/med-fish-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"5300\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"2000\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"5\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"244px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Medium fish middle 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/med-fish-mid.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"4000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"6\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"200px\",\"left\":\"196px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Medium fish close\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/med-fish-close.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2400\",\"easingin\":\"easeOutExpo\",\"delayin\":\"5500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"2000\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"6\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"246px\",\"left\":\"339px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Big fish close\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/big-fish-close.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2000\",\"easingin\":\"easeOutCirc\",\"delayin\":\"3300\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"3000\",\"easingout\":\"easeInOutExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"7\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"12px\",\"left\":\"344px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"},{\"subtitle\":\"Big fish close 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/big-fish-close.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"6000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1700\",\"easingout\":\"easeInExpo\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"7\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"194px\",\"left\":\"454px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Fish\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"36\",\"2d_transitions\":\"all\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/3d-bg.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Small Cube 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"20px\",\"left\":\"106px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Small Cube 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"50\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"700\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"153px\",\"left\":\"342px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Small Cube 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"400\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"276px\",\"left\":\"252px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Small Cube 4\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"50\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"950\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"199px\",\"left\":\"585px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Small Cube 5\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/small-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"250\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"37px\",\"left\":\"525px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Say hello\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/sayhello.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"116px\",\"left\":\"86px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Say hello\",\"rel\":\"\"},{\"subtitle\":\"Mid cube 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/mid-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"50\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"100\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"190px\",\"left\":\"135px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Mid cube 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/mid-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"150\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"340px\",\"left\":\"322px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Mid cube 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/mid-cube-blur.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"300\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"398px\",\"left\":\"587px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Big Cube 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/big-cube.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"5\",\"showuntil\":\"300\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"211px\",\"left\":\"16px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"},{\"subtitle\":\"Big Cube 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/big-cube.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"3000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInBack\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"5\",\"showuntil\":\"50\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"251px\",\"left\":\"746px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Cube\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"58,74\",\"2d_transitions\":\"all\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/autumn-bg.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"5600\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Summer BG\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/summer-bg.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"2500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-1.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"9px\",\"left\":\"101px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-2.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"200\",\"rotatein\":\"-360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"210px\",\"left\":\"240px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-3.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"400\",\"rotatein\":\"360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"193px\",\"left\":\"480px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 4\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-4.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"600\",\"rotatein\":\"-360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"311px\",\"left\":\"623px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 5\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-5.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"800\",\"rotatein\":\"360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"407px\",\"left\":\"371px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 6\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-6.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"-360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"232px\",\"left\":\"392px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Autumn L 7\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/a-l-7.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"360\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"190px\",\"left\":\"67px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Autumn Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-1.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"9px\",\"left\":\"101px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-2.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"210px\",\"left\":\"240px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-3.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2900\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"193px\",\"left\":\"480px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 4\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-4.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"311px\",\"left\":\"623px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 5\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-5.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3300\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"407px\",\"left\":\"371px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 6\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-6.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"232px\",\"left\":\"392px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"Summer L 7\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/s-l-7.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"190px\",\"left\":\"67px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Spring Leaf\",\"rel\":\"\"},{\"subtitle\":\"The improve\",\"type\":\"p\",\"image\":\"\",\"html\":\"The improve\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"83px\",\"left\":\"277px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"is\",\"type\":\"p\",\"image\":\"\",\"html\":\"is\",\"slidedirection\":\"top\",\"durationin\":\"2000\",\"easingin\":\"easeOutElastic\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"60px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"62px\",\"left\":\"451px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"to change.\",\"type\":\"p\",\"image\":\"\",\"html\":\"to change.\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"83px\",\"left\":\"503px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"To be perfect\",\"type\":\"p\",\"image\":\"\",\"html\":\"To be perfect\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1750\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"137px\",\"left\":\"367px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"is\",\"type\":\"p\",\"image\":\"\",\"html\":\"is\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeOutElastic\",\"delayin\":\"2250\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"60px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"116px\",\"left\":\"555px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"to change often.\",\"type\":\"p\",\"image\":\"\",\"html\":\"to change often.\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1750\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"137px\",\"left\":\"608px\",\"style\":\"text-shadow: 0px 0px 10px white;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"- Winston Churchill\",\"type\":\"p\",\"image\":\"\",\"html\":\"- Winston Churchill\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"1000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', \\\\\'Helvetica Neue\\\\\', Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\"}\",\"top\":\"198px\",\"left\":\"722px\",\"style\":\"text-shadow: 0px 0px 10px white; font-style: italic;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"68,69,77,78\",\"2d_transitions\":\"all\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cubes-bg.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"10050\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Blur\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cubes-blur.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuad\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuad\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 1\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-1.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5700\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-2.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5100\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 3\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-3.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5200\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 4\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-4.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 5\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-5.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"900\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 6\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-6.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"4600\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 7\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-7.png\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"1100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"5100\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 8\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-8.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"4800\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Tile 9\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tile-9.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"2500\",\"easingin\":\"easeOutBack\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"4500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Tile\",\"rel\":\"\"},{\"subtitle\":\"Feature 1\",\"type\":\"p\",\"image\":\"\",\"html\":\"200+ 2D & 3D transitions with Transition Builder!\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"1500\",\"rotatein\":\"-120\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".5\",\"level\":\"3\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"4px solid white\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"7px\\\\\\\"}\",\"top\":\"45px\",\"left\":\"30px\",\"style\":\"box-shadow: 0px 3px 10px -3px #002c4b; background: #02cef7; background: -moz-linear-gradient(top, #02cef7 0%, #009bba 100%); background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#02cef7), color-stop(100%,#009bba)); background: -webkit-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -o-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -ms-linear-gradient(top, #02cef7 0%,#009bba 100%); background: linear-gradient(to bottom, #02cef7 0%,#009bba 100%); text-shadow: 0px -1px 1px #00819c;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Feature 2\",\"type\":\"p\",\"image\":\"\",\"html\":\"Use with any HTML content including embedded videos!\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"3000\",\"rotatein\":\"-120\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".5\",\"level\":\"3\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"4px solid white\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"7px\\\\\\\"}\",\"top\":\"360px\",\"left\":\"450px\",\"style\":\"box-shadow: 0px 3px 10px -3px #002c4b; background: #02cef7; background: -moz-linear-gradient(top, #02cef7 0%, #009bba 100%); background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#02cef7), color-stop(100%,#009bba)); background: -webkit-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -o-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -ms-linear-gradient(top, #02cef7 0%,#009bba 100%); background: linear-gradient(to bottom, #02cef7 0%,#009bba 100%); text-shadow: 0px -1px 1px #00819c;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Feature 3\",\"type\":\"p\",\"image\":\"\",\"html\":\"Responsive with Smart Resize & Touch-enabled!\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"4500\",\"rotatein\":\"120\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".5\",\"level\":\"3\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"4px solid white\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"7px\\\\\\\"}\",\"top\":\"100px\",\"left\":\"505px\",\"style\":\"box-shadow: 0px 3px 10px -3px #002c4b; background: #02cef7; background: -moz-linear-gradient(top, #02cef7 0%, #009bba 100%); background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#02cef7), color-stop(100%,#009bba)); background: -webkit-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -o-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -ms-linear-gradient(top, #02cef7 0%,#009bba 100%); background: linear-gradient(to bottom, #02cef7 0%,#009bba 100%); text-shadow: 0px -1px 1px #00819c;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Feature 4\",\"type\":\"p\",\"image\":\"\",\"html\":\"Multisite, Multi-language & Localization ready!\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeOutExpo\",\"delayin\":\"6000\",\"rotatein\":\"120\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInQuart\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".5\",\"level\":\"3\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"10px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"4px solid white\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Helvetica, Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"20px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"7px\\\\\\\"}\",\"top\":\"400px\",\"left\":\"10px\",\"style\":\"box-shadow: 0px 3px 10px -3px #002c4b; background: #02cef7; background: -moz-linear-gradient(top, #02cef7 0%, #009bba 100%); background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#02cef7), color-stop(100%,#009bba)); background: -webkit-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -o-linear-gradient(top, #02cef7 0%,#009bba 100%); background: -ms-linear-gradient(top, #02cef7 0%,#009bba 100%); background: linear-gradient(to bottom, #02cef7 0%,#009bba 100%); text-shadow: 0px -1px 1px #00819c;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"45,46,47,48,49,50\",\"2d_transitions\":\"all\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bbb-bg.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Clouds far\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bbb-clouds-far.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"2000\",\"easingin\":\"easeInOutQuad\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"50000\",\"easingout\":\"easeInQuad\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-90px\",\"left\":\"500px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Clouds\",\"rel\":\"\"},{\"subtitle\":\"Clouds close\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bbb-clouds-close.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"0\",\"easingin\":\"linear\",\"delayin\":\"10000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"40000\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"5\",\"showuntil\":\"1\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"-60px\",\"left\":\"1000\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Clouds\",\"rel\":\"\"},{\"subtitle\":\"Background mask\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bbb-bg-mask.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"0\",\"easingin\":\"linear\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"linear\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Mask\",\"rel\":\"\"},{\"subtitle\":\"Video frame\",\"type\":\"div\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutBack\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"510px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"291px\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"white\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"2px\\\\\\\"}\",\"top\":\"154px\",\"left\":\"465px\",\"style\":\"box-shadow: 0px 5px 35px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Embedded video (DIV sublayer)\",\"type\":\"div\",\"image\":\"\",\"html\":\"<iframe src=\\\\\\\"http:\\/\\/player.vimeo.com\\/video\\/47438073?title=0&byline=0&portrait=0&color=e4f000\\\\\\\" width=\\\\\\\"500\\\\\\\" height=\\\\\\\"281\\\\\\\" frameborder=\\\\\\\"0\\\\\\\" webkitAllowFullScreen mozallowfullscreen allowFullScreen><\\/iframe>\",\"slidedirection\":\"right\",\"durationin\":\"1500\",\"easingin\":\"easeOutBack\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"159\",\"left\":\"470\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Easy to embed...\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/easy.png\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"35px\",\"left\":\"715px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Easy to embed\",\"rel\":\"\"},{\"subtitle\":\"Features\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/vfeatures.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"5000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"37px\",\"left\":\"188px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Features\",\"rel\":\"\"},{\"subtitle\":\"Butterfly\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bi-colored-butterfly-source_ijc.gif\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"2000\",\"easingin\":\"easeOutBack\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"2\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"304px\",\"left\":\"159px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Butterfly\",\"rel\":\"\"},{\"subtitle\":\"Thinking about acorn\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/acorn.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"16000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"2000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"119px\",\"left\":\"234px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Acorn\",\"rel\":\"\"}]}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("3","Sample full width slider","{\"properties\":{\"title\":\"Sample full width slider\",\"width\":\"100%\",\"height\":\"400px\",\"forceresponsive\":\"on\",\"responsiveunder\":\"960\",\"sublayercontainer\":\"960\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"fullwidth\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"circletimer\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"24,25,27,28\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg7a.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#3b173d\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#eee\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"310px\",\"left\":\"40px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"you can add the slider elements into a centered container in full width mode\",\"type\":\"h5\",\"image\":\"\",\"html\":\"you can add the slider elements into a centered container in full width mode\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#eee\\\\\\\"}\",\"top\":\"320\",\"left\":\"104px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"110,111,112,113\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/bg6a.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"+\",\"type\":\"h5\",\"image\":\"\",\"html\":\"+\",\"slidedirection\":\"fade\",\"durationin\":\"750\",\"easingin\":\"easeOutQuint\",\"delayin\":\"0\",\"rotatein\":\"90\",\"scalein\":\".5\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"-90\",\"scaleout\":\".5\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#1e73be\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"100\\\\\\\"}\",\"top\":\"40px\",\"left\":\"40px\",\"style\":\" font-weight: normal; text-align: center;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"full width slider can be also responsive under a value of width\",\"type\":\"h5\",\"image\":\"\",\"html\":\"full width slider can be also responsive under a value of width\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeOutQuint\",\"delayin\":\"300\",\"rotatein\":\"0\",\"scalein\":\".8\",\"slideoutdirection\":\"fade\",\"durationout\":\"750\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".8\",\"level\":\"-1\",\"showuntil\":\"4000\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Arial, sans-serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"22px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#1e73be\\\\\\\"}\",\"top\":\"50\",\"left\":\"104px\",\"style\":\" font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"92,93,105\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/guitars.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("4","Carousel demo","{\"properties\":{\"title\":\"Carousel demo\",\"width\":\"1280\",\"height\":\"720\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"carousel\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"margin-bottom: 50px;\",\"navprevnext\":\"on\",\"navbuttons\":\"on\",\"thumb_nav\":\"always\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"73\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/tablet.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"only $499\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#ff7700\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"70%\",\"left\":\"25%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Sample price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"Sample price\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"-30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"63%\",\"left\":\"25%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"73\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/computer.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"only $1299\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#ff7700\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"80%\",\"left\":\"20%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Sample price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"Sample price\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"-30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"73%\",\"left\":\"20%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"73\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/phone.png\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"only $199\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#ff7700\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"50%\",\"left\":\"80%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Sample price\",\"type\":\"h6\",\"image\":\"\",\"html\":\"Sample price\",\"slidedirection\":\"fade\",\"durationin\":\"500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"-30\",\"scalein\":\".1\",\"slideoutdirection\":\"fade\",\"durationout\":\"500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\".1\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"20\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'Oswald\\\\\'\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"30px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#000000\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"5\\\\\\\"}\",\"top\":\"43%\",\"left\":\"80%\",\"style\":\"font-weight: 400; box-shadow: 0px 2px 8px -2px black;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("5","Sample content slider","{\"properties\":{\"title\":\"Sample content slider\",\"width\":\"600\",\"height\":\"200\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"minimal\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"thumb_nav\":\"disabled\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"0\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"0\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Content Title\",\"type\":\"h1\",\"image\":\"\",\"html\":\"Content Slider Example\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"10\",\"left\":\"10\",\"style\":\"text-shadow: none; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Text\",\"type\":\"p\",\"image\":\"\",\"html\":\"Hello, I\\\\\'m text so I\\\\\'m SEO friendly! Just try it: you can select me with your mouse :) Oh and I am also responsive!\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"280px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#555\\\\\\\"}\",\"top\":\"50\",\"left\":\"10\",\"wordwrap\":\"on\",\"style\":\"text-shadow: none; font-weight: normal; text-align: justify;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Text 2\",\"type\":\"p\",\"image\":\"\",\"html\":\"LayerSlider\\\\\'s new smart-resizing feature is resizing also text sublayers as well as images and embedded videos! Nice, huh?\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"280px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#555\\\\\\\"}\",\"top\":\"50\",\"left\":\"10\",\"wordwrap\":\"on\",\"style\":\"text-shadow: none; font-weight: normal; text-align: justify;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Image\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cs1.jpg\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\"}\",\"top\":\"15\",\"left\":\"315\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Content image\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"0\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"0\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Content Title\",\"type\":\"h1\",\"image\":\"\",\"html\":\"Transitions?\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"10\",\"left\":\"300\",\"style\":\"text-shadow: none; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Text\",\"type\":\"p\",\"image\":\"\",\"html\":\"Of course you can use all the transitions and easings like on image sublayers. You can slide or fade the text, you can use delays and effects.\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"280px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#555\\\\\\\"}\",\"top\":\"50\",\"left\":\"300\",\"wordwrap\":\"on\",\"style\":\"text-shadow: none; font-weight: normal; text-align: justify;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Image\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cs2.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"top\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\"}\",\"top\":\"15\",\"left\":\"15\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Content image\",\"rel\":\"\"},{\"subtitle\":\"Content Image 2\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cs3.jpg\",\"html\":\"\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\"}\",\"top\":\"15\",\"left\":\"15\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Content image\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"6000\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"0\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"0\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1000\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Content Title\",\"type\":\"h1\",\"image\":\"\",\"html\":\"Third title\",\"slidedirection\":\"left\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"left\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"36px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#333\\\\\\\"}\",\"top\":\"10\",\"left\":\"10\",\"style\":\"text-shadow: none; font-weight: normal;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Text\",\"type\":\"p\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam cursus ultrices massa id posuere. Sed mattis mollis sodales. Aliquam tincidunt dui enim, ac dignissim tortor. Vivamus posuere leo in tellus aliquet malesuada. Cras nibh dui, luctus id venenatis quis, faucibus vel nunc.\",\"slidedirection\":\"bottom\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"bottom\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"width\\\\\\\":\\\\\\\"280px\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"\\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#555\\\\\\\"}\",\"top\":\"50\",\"left\":\"10\",\"wordwrap\":\"on\",\"style\":\"text-shadow: none; font-weight: normal; text-align: justify;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Content Image\",\"type\":\"img\",\"image\":\"http:\\/\\/test2.william-chang.com\\/wp-content\\/plugins\\/LayerSlider\\/sampleslider\\/cs2.jpg\",\"html\":\"\",\"slidedirection\":\"top\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"fade\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"1500\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-top\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-right\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-bottom\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"5px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #ddd\\\\\\\"}\",\"top\":\"15\",\"left\":\"315\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"Content image\",\"rel\":\"\"},{\"subtitle\":\"Content Text 2\",\"type\":\"p\",\"image\":\"\",\"html\":\"Duis non lectus diam, a molestie mauris. Vestibulum accumsan tellus vel urna bibendum porta. Phasellus velit libero, dictum vel mattis ornare, condimentum vitae turpis. Donec consectetur magna nec eros ultricies eleifend. Nullam bibendum posuere ullamcorper. Nulla egestas.\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3000\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"3\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"50\",\"left\":\"310\",\"wordwrap\":\"on\",\"style\":\"font-family: \\\\\'HelveticaNeue-Light\\\\\', \\\\\'Helvetica Neue Light\\\\\', Helvetica, Arial, Serif; line-height: auto; color: #555; text-shadow: none; font-size: 15px; font-weight: normal; width: 280px; text-align: justify;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("6","Sample video gallery slider","{\"properties\":{\"title\":\"Sample video gallery slider\",\"width\":\"960\",\"height\":\"540\",\"responsive\":\"on\",\"responsiveunder\":\"0\",\"sublayercontainer\":\"0\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"borderlessdark\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"relativeurls\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Sublayer #1\",\"type\":\"div\",\"image\":\"\",\"html\":\"<iframe width=\\\\\\\"960\\\\\\\" height=\\\\\\\"540\\\\\\\" src=\\\\\\\"http:\\/\\/www.youtube.com\\/embed\\/1iIZeIy7TqM\\\\\\\" frameborder=\\\\\\\"0\\\\\\\" allowfullscreen><\\/iframe>\",\"slidedirection\":\"auto\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"\",\"level\":\"0\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Sublayer #1\",\"type\":\"div\",\"image\":\"\",\"html\":\"<iframe src=\\\\\\\"http:\\/\\/player.vimeo.com\\/video\\/10090962?badge=0\\\\\\\" width=\\\\\\\"960\\\\\\\" height=\\\\\\\"540\\\\\\\" frameborder=\\\\\\\"0\\\\\\\" webkitAllowFullScreen mozallowfullscreen allowFullScreen><\\/iframe>\",\"slidedirection\":\"auto\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"\",\"level\":\"0\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Sublayer #1\",\"type\":\"div\",\"image\":\"\",\"html\":\"<iframe src=\\\\\\\"http:\\/\\/player.vimeo.com\\/video\\/21206637?badge=0\\\\\\\" width=\\\\\\\"960\\\\\\\" height=\\\\\\\"540\\\\\\\" frameborder=\\\\\\\"0\\\\\\\" webkitAllowFullScreen mozallowfullscreen allowFullScreen><\\/iframe>\",\"slidedirection\":\"auto\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"\",\"slideoutdirection\":\"auto\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"\",\"level\":\"0\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0\",\"left\":\"0\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1382009901","1382009901","0","1");
INSERT INTO `wp_layerslider` VALUES("7","Home Slider","{\"properties\":{\"title\":\"Home Slider\",\"width\":\"100%\",\"height\":\"600\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/slide01_background.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer1.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"120px\",\"left\":\"-10px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer2.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"300\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"95px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer3.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"600\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer4.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"900\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"74px\",\"left\":\"278px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"span\",\"image\":\"\",\"html\":\"Flat Glass Style\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"230px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1900\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"330px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"375px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer_background3.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4300\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer07.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"74px\",\"left\":\"180px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer08.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"76px\",\"left\":\"182px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer091.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"139px\",\"left\":\"253px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer10.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"76px\",\"left\":\"593px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"span\",\"image\":\"\",\"html\":\"Retina Graphics\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"280px\",\"left\":\"350px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"400px\",\"left\":\"395px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"462px\",\"left\":\"500px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer8.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"5500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"okvir\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer41.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"700\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"73px\",\"left\":\"160px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"ekran\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer51.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"172px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"dugme\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer11.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"500px\",\"left\":\"265px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"krug\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer21.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"400\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"485px\",\"left\":\"250px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"zvucnik\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer31.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"100px\",\"left\":\"252px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"pozadina\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer9.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"144px\",\"left\":\"173px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"senka\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer6.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1900\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"172px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"logo\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer7.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"230px\",\"left\":\"210px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"cvet\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer101.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"169px\",\"left\":\"262px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"cvet2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer111.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"1px\",\"left\":\"457px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"title\",\"type\":\"span\",\"image\":\"\",\"html\":\"Perfect WordPress\",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"220px\",\"left\":\"503px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"subtitle\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"314px\",\"left\":\"507px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"button\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"357px\",\"left\":\"507px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/bla.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2200\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer5.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"95px\",\"left\":\"450px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Tell Your Story\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"305px\",\"left\":\"330px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7 is perfect for showcasing your work or business services.\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"800\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"390px\",\"left\":\"340px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1200\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"443px\",\"left\":\"470px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("8","Home Slider 2","{\"properties\":{\"title\":\"Home Slider 2\",\"width\":\"1100px\",\"height\":\"564\",\"responsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/slide1.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/ls2_phone.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"50px\",\"left\":\"735px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/ls2_coffee.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"250px\",\"left\":\"70px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Flat Glass Design\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"900\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"250px\",\"left\":\"185px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"320px\",\"left\":\"185px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/slide2.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/ls2_phone.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"50px\",\"left\":\"90px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/ls2_coffee.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"340px\",\"left\":\"460px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Flat Glass Design\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"900\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"50px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"340px\",\"left\":\"575px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"405px\",\"left\":\"575px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("9","Portfolio Slider","{\"properties\":{\"title\":\"Portfolio Slider\",\"width\":\"100%\",\"height\":\"400\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"#e74c3c\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/camera.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"400px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Show<br \\/>\\r\\nYour Work\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"75px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"80px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"80px\",\"left\":\"0px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"255px\",\"left\":\"5px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"315px\",\"left\":\"5px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/mobile.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"3px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Present Your<br \\/>\\r\\nProjects\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"75px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"80px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"80px\",\"left\":\"670px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"260px\",\"left\":\"675px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"315px\",\"left\":\"675px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("10","About Us","{\"properties\":{\"title\":\"About Us\",\"width\":\"100%\",\"height\":\"455\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/aboutslide1.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2500\",\"new_transitions\":\"on\",\"slidedirection\":\"bottom\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"span\",\"image\":\"\",\"html\":\"Steven Roberts\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"136px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#057afb\\\\\\\"}\",\"top\":\"160px\",\"left\":\"130px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Founder \\/ Head Of Enginering Department\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"330px\",\"left\":\"710px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/aboutslide2.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2500\",\"new_transitions\":\"on\",\"slidedirection\":\"bottom\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"span\",\"image\":\"\",\"html\":\"Karissa Young\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"136px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#057afb\\\\\\\"}\",\"top\":\"160px\",\"left\":\"130px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Founder \\/ Head Of Enginering Department\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"330px\",\"left\":\"140px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("11","Grid Slider","{\"properties\":{\"title\":\"Grid Slider\",\"width\":\"1100px\",\"height\":\"500\",\"responsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"68\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/Layer-Slider-01.png\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"3d_transitions\":\"68\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/Layer-Slider-02.png\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("12","Home Compact","{\"properties\":{\"title\":\"Home Compact\",\"width\":\"100%\",\"height\":\"375\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"#f8f8f8\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/logo_compact.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"30px\",\"left\":\"615px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"151px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ff3600\\\\\\\"}\",\"top\":\"75px\",\"left\":\"155px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"WordPress Theme\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"56px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"240px\",\"left\":\"20px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/logo_compact1.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"12px\",\"left\":\"160px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"151px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ff3600\\\\\\\"}\",\"top\":\"75px\",\"left\":\"660px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"WordPress Theme\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"56px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"240px\",\"left\":\"525px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382009943","1382009943","0","1");
INSERT INTO `wp_layerslider` VALUES("13","Home Slider","{\"properties\":{\"title\":\"Home Slider\",\"width\":\"100%\",\"height\":\"600\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"transparent\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/slide01_background.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer1.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"120px\",\"left\":\"-10px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer2.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"300\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"95px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer3.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"600\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"600\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"70px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer4.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"900\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"74px\",\"left\":\"278px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"span\",\"image\":\"\",\"html\":\"Flat Glass Style\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"230px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2000\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1900\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"330px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"800\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"375px\",\"left\":\"550px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer_background3.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4300\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2500\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer07.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"74px\",\"left\":\"180px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer08.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"76px\",\"left\":\"182px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer091.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"139px\",\"left\":\"253px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer10.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"76px\",\"left\":\"593px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #5\",\"type\":\"span\",\"image\":\"\",\"html\":\"Retina Graphics\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"280px\",\"left\":\"350px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #6\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"400px\",\"left\":\"395px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #7\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"462px\",\"left\":\"500px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer8.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"5500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"okvir\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer41.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"700\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"73px\",\"left\":\"160px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"ekran\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer51.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"172px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"dugme\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer11.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"100\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"500px\",\"left\":\"265px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"krug\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer21.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"400\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"485px\",\"left\":\"250px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"zvucnik\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer31.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1000\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"100px\",\"left\":\"252px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"pozadina\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer9.jpg\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"144px\",\"left\":\"173px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"senka\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer6.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1900\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"143px\",\"left\":\"172px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"logo\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer7.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"230px\",\"left\":\"210px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"cvet\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer101.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2500\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"169px\",\"left\":\"262px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"cvet2\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer111.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"600\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"2800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"1px\",\"left\":\"457px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"title\",\"type\":\"span\",\"image\":\"\",\"html\":\"Perfect WordPress\",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3100\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"220px\",\"left\":\"503px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"subtitle\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3400\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"314px\",\"left\":\"507px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"button\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"right\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"3700\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"357px\",\"left\":\"507px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/bla.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"left\",\"timeshift\":\"-1000\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"2200\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/layer5.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"200\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"right\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"95px\",\"left\":\"450px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Tell Your Story\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"400\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"70px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"305px\",\"left\":\"330px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7 is perfect for showcasing your work or business services.\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1300\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"800\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"390px\",\"left\":\"340px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"700\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"fade\",\"durationout\":\"700\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"1200\",\"rotateout\":\"0\",\"scaleout\":\"0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"443px\",\"left\":\"470px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382010044","1382010044","0","0");
INSERT INTO `wp_layerslider` VALUES("14","Home Slider 2","{\"properties\":{\"title\":\"Home Slider 2\",\"width\":\"1100px\",\"height\":\"564\",\"responsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2015\\/10\\/01-home.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2015\\/10\\/02-home.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2015\\/10\\/03-home.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/11\\/new-york-city-wedding-photographer-01.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/10\\/01-New-York-wedding-photographer-william-chang-photography.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2014\\/05\\/12-New-York-wedding-photographer-william-chang-photography.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/11\\/new-york-city-wedding-photographer-04.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/11\\/new-york-city-wedding-photographer-02.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"\",\"html\":\"\",\"slidedirection\":\"auto\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/11\\/william-chang-photography-09.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"4000\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}}]}","1382010044","1444751043","0","0");
INSERT INTO `wp_layerslider` VALUES("15","Portfolio Slider","{\"properties\":{\"title\":\"Portfolio Slider\",\"width\":\"100%\",\"height\":\"400\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"#e74c3c\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/camera.png\",\"html\":\"\",\"slidedirection\":\"right\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"0px\",\"left\":\"400px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Show<br \\/>\\r\\nYour Work\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"75px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"80px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"80px\",\"left\":\"0px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"255px\",\"left\":\"5px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"315px\",\"left\":\"5px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"8\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/mobile.png\",\"html\":\"\",\"slidedirection\":\"left\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"3px\",\"left\":\"0px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Present Your<br \\/>\\r\\nProjects\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"75px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"80px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"80px\",\"left\":\"670px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lorem ipsum dolor sit amet, feugiat ellen delicata \",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1200\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"260px\",\"left\":\"675px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #4\",\"type\":\"span\",\"image\":\"\",\"html\":\"<a href=\\\\\\\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\\\\\\" target=\\\\\\\"_self\\\\\\\" style=\\\\\\\"color: #fff;\\\\\\\">Read More<\\/a>\",\"slidedirection\":\"fade\",\"durationin\":\"800\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"padding-right\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"padding-left\\\\\\\":\\\\\\\"40px\\\\\\\",\\\\\\\"border-top\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-right\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-bottom\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"border-left\\\\\\\":\\\\\\\"1px solid #fff\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"15px\\\\\\\",\\\\\\\"line-height\\\\\\\":\\\\\\\"43px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\"}\",\"top\":\"315px\",\"left\":\"675px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 300;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382010044","1382010044","0","0");
INSERT INTO `wp_layerslider` VALUES("16","About Us","{\"properties\":{\"title\":\"About Us\",\"width\":\"100%\",\"height\":\"455\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/10\\/william-slide-new.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2500\",\"new_transitions\":\"on\",\"slidedirection\":\"bottom\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"span\",\"image\":\"\",\"html\":\"Meet William\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"136px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#44b1f5\\\\\\\"}\",\"top\":\"162px\",\"left\":\"187px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Founder \\/ Photographer\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"307px\",\"left\":\"771px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"1\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/william-chang.com\\/wp-content\\/uploads\\/2013\\/10\\/henley-slide.jpg\",\"thumbnail\":\"\",\"slidedelay\":\"2500\",\"new_transitions\":\"on\",\"slidedirection\":\"bottom\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"span\",\"image\":\"\",\"html\":\"Meet Henley\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"136px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#44b1f5\\\\\\\"}\",\"top\":\"169px\",\"left\":\"198px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"Lighting guru \\/ Photographer\",\"slidedirection\":\"right\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"1.0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"17px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"315px\",\"left\":\"208px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382010044","1386521781","0","0");
INSERT INTO `wp_layerslider` VALUES("17","Grid Slider","{\"properties\":{\"title\":\"Grid Slider\",\"width\":\"1100px\",\"height\":\"500\",\"responsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"68\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/Layer-Slider-01.png\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}},{\"properties\":{\"3d_transitions\":\"68\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/Layer-Slider-02.png\",\"thumbnail\":\"\",\"slidedelay\":\"3000\",\"new_transitions\":\"on\",\"slidedirection\":\"top\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"}}]}","1382010044","1382010044","0","0");
INSERT INTO `wp_layerslider` VALUES("18","Home Compact","{\"properties\":{\"title\":\"Home Compact\",\"width\":\"100%\",\"height\":\"375\",\"responsive\":\"on\",\"forceresponsive\":\"on\",\"responsiveunder\":\"1100\",\"sublayercontainer\":\"1100\",\"autostart\":\"on\",\"pauseonhover\":\"on\",\"firstlayer\":\"1\",\"animatefirstlayer\":\"on\",\"twowayslideshow\":\"on\",\"loops\":\"0\",\"forceloopnum\":\"on\",\"autoplayvideos\":\"on\",\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"keybnav\":\"on\",\"touchnav\":\"on\",\"skin\":\"preview\",\"backgroundcolor\":\"#f8f8f8\",\"backgroundimage\":\"\",\"sliderstyle\":\"\",\"navprevnext\":\"on\",\"navstartstop\":\"on\",\"navbuttons\":\"on\",\"hoverprevnext\":\"on\",\"thumb_nav\":\"hover\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_container_width\":\"60%\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"imgpreload\":\"on\",\"bodyinclude\":\"on\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: 10px; top: 10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"cbinit\":\"function(element) { }\",\"cbstart\":\"function(data) { }\",\"cbstop\":\"function(data) { }\",\"cbpause\":\"function(data) { }\",\"cbanimstart\":\"function(data) { }\",\"cbanimstop\":\"function(data) { }\",\"cbprev\":\"function(data) { }\",\"cbnext\":\"function(data) { }\"},\"layers\":[{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/logo_compact.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"30px\",\"left\":\"615px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"151px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ff3600\\\\\\\"}\",\"top\":\"75px\",\"left\":\"155px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"WordPress Theme\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"56px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"240px\",\"left\":\"20px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]},{\"properties\":{\"3d_transitions\":\"\",\"2d_transitions\":\"5\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"background\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"new_transitions\":\"on\",\"slidedirection\":\"right\",\"timeshift\":\"0\",\"durationin\":\"1500\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"durationout\":\"1500\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"layer_link\":\"\",\"layer_link_target\":\"_self\",\"id\":\"\",\"deeplink\":\"\"},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"type\":\"img\",\"image\":\"http:\\/\\/demo.qodeinteractive.com\\/satellite\\/wp-content\\/uploads\\/2013\\/09\\/logo_compact1.png\",\"html\":\"\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"0\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{}\",\"top\":\"12px\",\"left\":\"160px\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #2\",\"type\":\"span\",\"image\":\"\",\"html\":\"S7\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"800\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"151px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ff3600\\\\\\\"}\",\"top\":\"75px\",\"left\":\"660px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"},{\"subtitle\":\"Layer #3\",\"type\":\"span\",\"image\":\"\",\"html\":\"WordPress Theme\",\"slidedirection\":\"fade\",\"durationin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"delayin\":\"1600\",\"rotatein\":\"0\",\"scalein\":\"0\",\"slideoutdirection\":\"auto\",\"durationout\":\"1000\",\"easingout\":\"easeInOutQuint\",\"delayout\":\"0\",\"rotateout\":\"0\",\"scaleout\":\"1.0\",\"level\":\"-1\",\"showuntil\":\"0\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"56px\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#000000\\\\\\\"}\",\"top\":\"240px\",\"left\":\"525px\",\"style\":\"@import url(\\\\\'http:\\/\\/fonts.googleapis.com\\/css?family=Roboto:100,300\\\\\');\\r\\nfont-weight: 100;\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"qode interactive satellite\",\"rel\":\"\"}]}]}","1382010044","1382010044","0","0");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=1106942 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_options` VALUES("1","siteurl","http://test2.william-chang.com","yes");
INSERT INTO `wp_options` VALUES("2","blogname","NYC Wedding Photographer |Brooklyn portrait photographer","yes");
INSERT INTO `wp_options` VALUES("3","blogdescription","William Chang photography is based out of New York City and available to travel and photography your wedding anywhere world wide","yes");
INSERT INTO `wp_options` VALUES("4","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("5","admin_email","williamchang23@gmail.com","yes");
INSERT INTO `wp_options` VALUES("6","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("7","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("8","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("9","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("10","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("11","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("12","rss_use_excerpt","1","yes");
INSERT INTO `wp_options` VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("17","default_category","1","yes");
INSERT INTO `wp_options` VALUES("18","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("19","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("21","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("22","date_format","F j, Y","yes");
INSERT INTO `wp_options` VALUES("23","time_format","g:i A","yes");
INSERT INTO `wp_options` VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `wp_options` VALUES("28","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("29","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("31","gzipcompression","0","yes");
INSERT INTO `wp_options` VALUES("32","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("34","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("35","active_plugins","a:11:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:49:\"ap-extended-mime-types/ap-extended-mime-types.php\";i:3;s:41:\"better-wp-security/better-wp-security.php\";i:4;s:33:\"duplicate-post/duplicate-post.php\";i:5;s:67:\"jquery-pin-it-button-for-images/jquery-pin-it-button-for-images.php\";i:6;s:41:\"kiwi-logo-carousel/kiwi_logo_carousel.php\";i:7;s:45:\"limit-login-attempts/limit-login-attempts.php\";i:8;s:27:\"pretty-link/pretty-link.php\";i:9;s:51:\"visual-form-builder-pro/visual-form-builder-pro.php\";i:10;s:24:\"wordpress-seo/wp-seo.php\";}","yes");
INSERT INTO `wp_options` VALUES("693629","itsec_ipcheck","a:1:{s:7:\"api_ban\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("36","home","http://test2.william-chang.com","yes");
INSERT INTO `wp_options` VALUES("37","category_base","","yes");
INSERT INTO `wp_options` VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("39","advanced_edit","0","yes");
INSERT INTO `wp_options` VALUES("40","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("41","gmt_offset","","yes");
INSERT INTO `wp_options` VALUES("42","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("43","recently_edited","a:5:{i:0;s:81:\"/home/changtwo/public_html/williamchangnew/wp-content/themes/satellite/footer.php\";i:1;s:80:\"/home/changtwo/public_html/williamchangnew/wp-content/themes/satellite/style.css\";i:2;s:89:\"/home/changtwo/public_html/williamchangnew/wp-content/plugins/logo-slider/logo-slider.php\";i:4;s:111:\"/home/changtwo/public_html/williamchangnew/wp-content/plugins/ap-extended-mime-types/ap-extended-mime-types.php\";i:5;s:106:\"/home/changtwo/public_html/williamchangnew/wp-content/themes/satellite/blog_full_image_whole_post-loop.php\";}","no");
INSERT INTO `wp_options` VALUES("44","template","satellite","yes");
INSERT INTO `wp_options` VALUES("45","stylesheet","satellite","yes");
INSERT INTO `wp_options` VALUES("46","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("47","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("48","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("49","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("50","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("51","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("52","db_version","33056","yes");
INSERT INTO `wp_options` VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("54","upload_path","","yes");
INSERT INTO `wp_options` VALUES("55","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("56","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("57","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("58","tag_base","","yes");
INSERT INTO `wp_options` VALUES("59","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("60","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("61","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES("64","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("65","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("66","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("67","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("68","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES("69","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES("70","image_default_link_type","file","yes");
INSERT INTO `wp_options` VALUES("71","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("72","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("74","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("75","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("76","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("77","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("78","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("79","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("80","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("82","widget_categories","a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("83","widget_text","a:6:{i:2;a:3:{s:5:\"title\";s:34:\"New York City Wedding Photographer\";s:4:\"text\";s:964:\"As a New York City Wedding Photographer, I hope to capture the happiest moments of a couple\'s life with fresh and creative angles that reflect their natural style. In this website, I will share the beautiful weddings and events that I have had the pleasure of photographing for my wonderful clients. Please feel free to browse for my latest updates and find inspiration for wedding photography ideas. We would love to hear your love story, send us a message and say hello.

<div style=\"margin-top:10px;margin-bottom:10px;\" class=\"separator transparent\"></div>

<ul class=\"social_menu transparent\"><li class=\"twitter\"><a href=\"http://www.twitter.com/william_chang\" target=\"_blank\"><span>twitter</span></a></li><li class=\"facebook\"><a href=\"https://www.facebook.com/williamchangphotography\" target=\"_blank\"><span>facebook</span></a></li><li class=\"pinterest\"><a href=\"http://www.pinterest.com/williamchang23/\" target=\"_blank\"><span>pinterest</span></a></li></ul>\";s:6:\"filter\";b:0;}i:3;a:3:{s:5:\"title\";s:13:\"Wedding Types\";s:4:\"text\";s:812:\"[unordered_list style=\'circle\' animate=\'no\']
<ul>
<li><a href=\"http://william-chang.com/wedding-types/elopement-wedding-photography/\">Elopement Wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/indian-wedding-photography/\">Indian Wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/korean-wedding-photography/\">Korean Wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/same-sex-wedding-photography/\">Same-sex wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/chinese-wedding-photography/\">Chinese wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/italian-wedding-photography/\">Italian wedding</a></li>
<li><a href=\"http://william-chang.com/wedding-types/\">More wedding types...</a></li>
</ul>
[/unordered_list]\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:6:\"Venues\";s:4:\"text\";s:1149:\"[unordered_list style=\'circle\' animate=\'no\']
<ul>
<li><a title=\"Bourne Mansion\" href=\"http://william-chang.com/best-wedding-venues/bourne-mansion/\">Bourne Mansion</a></li>
	<li><a title=\"Celebrate at Snug Harbor\" href=\"http://william-chang.com/best-wedding-venues/celebrate-at-snug-harbor/\">Celebrate at Snug Harbor</a></li>
	<li><a title=\"Crest Hollow Country Club\" href=\"http://william-chang.com/best-wedding-venues/crest-hollow-country-club/\">Crest Hollow Country Club</a></li>
	<li><a title=\"Dyker Beach Golf Course\" href=\"http://william-chang.com/best-wedding-venues/dyker-beach-golf-course/\">Dyker Beach Golf Course</a></li>
	<li><a title=\"Gotham Hall\" href=\"http://william-chang.com/best-wedding-venues/gotham-hall/\">Gotham Hall</a></li>
        <li><a title=\"North Ritz Club\" href=\"http://william-chang.com/best-wedding-venues/north-ritz-club/\">North Ritz Club</a></li>
	<li><a title=\"Riviera at Massapequa\" href=\"http://william-chang.com/best-wedding-venues/riviera-at-massapequa/\">Riviera at Massapequa</a></li>
<li><a title=\"\" href=\"http://william-chang.com/best-wedding-venues/\">More Venues...</a></li>
</ul>
[/unordered_list]\";s:6:\"filter\";b:0;}i:5;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:479:\"© 2015 William Chang Photography - <img src=\"http://william-chang.com/wp-content/uploads/2013/10/072.png\" style=\"height:14px !important; margin-right: 4px;\" />718-395-7223 - <img src=\"http://william-chang.com/wp-content/uploads/2013/10/044.png\" style=\"height:14px !important; margin-right: 4px;\" />info@william-chang.com - <img src=\"http://william-chang.com/wp-content/uploads/2013/10/162.png\" style=\"height:14px !important; margin-right: 4px;\" />187 Avenue T Brooklyn, NY 11223\";s:6:\"filter\";b:0;}i:6;a:3:{s:5:\"title\";s:21:\"Photography locations\";s:4:\"text\";s:1066:\"[unordered_list style=\'circle\' animate=\'no\']
<ul>
<li><a href=\"http://william-chang.com/wedding-locations/city-hall-wedding-photography/\" title=\"City Hall Wedding Photography\">City Hall Wedding Photography</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/central-park/\" title=\"Central Park\">Central Park</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/brooklyn-bridge-park/\" title=\"Brooklyn Bridge Park\">Brooklyn Bridge Park</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/dumbo-brooklyn/\" title=\"Dumbo Brooklyn\">Dumbo Brooklyn</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/highline-park/\" title=\"Highline Park\">Highline Park</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/battery-park/\" title=\"Battery Park\">Battery Park</a></li>
	<li><a href=\"http://william-chang.com/wedding-locations/fort-tyron-park/\" title=\"Fort Tyron Park\">Fort Tyron Park</a></li>
<li><a href=\"http://william-chang.com/wedding-locations/\">More locations...</a></li>
</ul>
[/unordered_list]\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("85","uninstall_plugins","a:2:{s:67:\"jquery-pin-it-button-for-images/jquery-pin-it-button-for-images.php\";s:23:\"jpibfi_uninstall_plugin\";s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}}","no");
INSERT INTO `wp_options` VALUES("86","timezone_string","America/New_York","yes");
INSERT INTO `wp_options` VALUES("87","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("88","page_on_front","824","yes");
INSERT INTO `wp_options` VALUES("89","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("90","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","24448","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:16:\"vfb_create_forms\";b:1;s:14:\"vfb_edit_forms\";b:1;s:14:\"vfb_copy_forms\";b:1;s:16:\"vfb_delete_forms\";b:1;s:16:\"vfb_import_forms\";b:1;s:16:\"vfb_export_forms\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:21:\"vfb_edit_email_design\";b:1;s:18:\"vfb_view_analytics\";b:1;s:17:\"vfb_edit_settings\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:40:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"vfb_view_entries\";b:1;s:16:\"vfb_edit_entries\";b:1;s:18:\"vfb_delete_entries\";b:1;s:18:\"vfb_view_analytics\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:10:\"copy_posts\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:11:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:6:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("93","widget_search","a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("94","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-comments","a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("96","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_meta","a:2:{s:12:\"_multiwidget\";i:1;i:1;a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("98","sidebars_widgets","a:12:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"sidebar\";a:2:{i:0;s:14:\"recent-posts-2\";i:1;s:10:\"archives-2\";}s:12:\"sidebar_page\";a:0:{}s:11:\"header_left\";a:0:{}s:12:\"header_right\";a:0:{}s:8:\"sidearea\";a:0:{}s:15:\"footer_column_1\";a:1:{i:0;s:6:\"text-2\";}s:15:\"footer_column_2\";a:1:{i:0;s:6:\"text-4\";}s:15:\"footer_column_3\";a:1:{i:0;s:6:\"text-3\";}s:15:\"footer_column_4\";a:1:{i:0;s:6:\"text-6\";}s:11:\"footer_text\";a:1:{i:0;s:6:\"text-5\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("99","cron","a:8:{i:1448965256;a:1:{s:29:\"wp_session_garbage_collection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1448965319;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1448966909;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1448972696;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1448973540;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1449003857;a:1:{s:24:\"akismet_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1449015805;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("14693","limit_login_retries","a:1:{s:11:\"92.63.87.97\";i:3;}","no");
INSERT INTO `wp_options` VALUES("14694","limit_login_retries_valid","a:1:{s:11:\"92.63.87.97\";i:1448386118;}","no");
INSERT INTO `wp_options` VALUES("157","recently_activated","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("109","dashboard_widget_options","a:4:{s:25:\"dashboard_recent_comments\";a:1:{s:5:\"items\";i:5;}s:24:\"dashboard_incoming_links\";a:5:{s:4:\"home\";s:24:\"http://william-chang.com\";s:4:\"link\";s:100:\"http://blogsearch.google.com/blogsearch?scoring=d&partner=wordpress&q=link:http://william-chang.com/\";s:3:\"url\";s:139:\"http://blogsearch.google.com/blogsearch_feeds?scoring=d&ie=utf-8&num=10&output=rss&partner=wordpress&q=link:http://test2.william-chang.com/\";s:5:\"items\";i:10;s:9:\"show_date\";b:0;}s:17:\"dashboard_primary\";a:7:{s:4:\"link\";s:26:\"http://wordpress.org/news/\";s:3:\"url\";s:31:\"http://wordpress.org/news/feed/\";s:5:\"title\";s:14:\"WordPress Blog\";s:5:\"items\";i:2;s:12:\"show_summary\";i:1;s:11:\"show_author\";i:0;s:9:\"show_date\";i:1;}s:19:\"dashboard_secondary\";a:7:{s:4:\"link\";s:28:\"http://planet.wordpress.org/\";s:3:\"url\";s:33:\"http://planet.wordpress.org/feed/\";s:5:\"title\";s:20:\"Other WordPress News\";s:5:\"items\";i:5;s:12:\"show_summary\";i:0;s:11:\"show_author\";i:0;s:9:\"show_date\";i:0;}}","yes");
INSERT INTO `wp_options` VALUES("197","externimg_whichimgs","All","yes");
INSERT INTO `wp_options` VALUES("198","externimg_replacesrc","replace","yes");
INSERT INTO `wp_options` VALUES("199","externimg_custtagname","externimg","yes");
INSERT INTO `wp_options` VALUES("200","externimg_catlist","","yes");
INSERT INTO `wp_options` VALUES("201","externimg_authlist","","yes");
INSERT INTO `wp_options` VALUES("44435","limit_login_lockouts","a:1:{s:11:\"92.63.87.97\";i:1448344718;}","yes");
INSERT INTO `wp_options` VALUES("44436","limit_login_logged","a:350:{s:13:\"175.126.82.54\";a:1:{s:5:\"admin\";i:1;}s:12:\"108.61.47.99\";a:1:{s:5:\"admin\";i:1;}s:13:\"103.31.186.84\";a:1:{s:5:\"admin\";i:1;}s:13:\"188.190.99.79\";a:1:{s:5:\"admin\";i:2;}s:12:\"195.3.146.93\";a:1:{s:5:\"admin\";i:1;}s:12:\"72.69.33.132\";a:1:{s:6:\"wchang\";i:2;}s:13:\"188.10.31.169\";a:1:{s:5:\"admin\";i:4;}s:10:\"37.59.2.42\";a:2:{s:13:\"william chang\";i:1;s:5:\"admin\";i:1;}s:13:\"65.202.182.22\";a:1:{s:5:\"admin\";i:4;}s:13:\"176.102.38.69\";a:1:{s:5:\"admin\";i:1;}s:13:\"83.99.139.223\";a:2:{s:5:\"admin\";i:5;s:13:\"administrator\";i:2;}s:13:\"31.41.218.144\";a:1:{s:5:\"admin\";i:3;}s:11:\"70.32.99.42\";a:1:{s:5:\"admin\";i:4;}s:14:\"84.124.103.180\";a:1:{s:5:\"admin\";i:8;}s:14:\"46.118.114.251\";a:1:{s:5:\"admin\";i:1;}s:10:\"77.66.46.9\";a:1:{s:5:\"admin\";i:1;}s:15:\"213.251.189.203\";a:2:{s:13:\"Administrator\";i:1;s:4:\"test\";i:1;}s:13:\"82.146.38.254\";a:1:{s:5:\"admin\";i:1;}s:10:\"50.63.26.2\";a:1:{s:5:\"admin\";i:2;}s:13:\"176.102.37.92\";a:1:{s:5:\"admin\";i:1;}s:11:\"23.92.18.80\";a:1:{s:5:\"admin\";i:1;}s:13:\"192.155.89.30\";a:1:{s:5:\"admin\";i:1;}s:15:\"213.251.189.205\";a:1:{s:5:\"admin\";i:1;}s:13:\"24.37.140.226\";a:1:{s:13:\"Administrator\";i:1;}s:14:\"66.147.244.137\";a:1:{s:5:\"admin\";i:1;}s:13:\"66.175.219.65\";a:1:{s:5:\"admin\";i:1;}s:12:\"91.200.13.45\";a:1:{s:5:\"admin\";i:4;}s:12:\"82.146.60.55\";a:3:{s:5:\"admin\";i:1;s:13:\"william-chang\";i:1;s:13:\"administrator\";i:1;}s:13:\"72.89.161.248\";a:1:{s:5:\"admin\";i:4;}s:13:\"213.246.52.29\";a:2:{s:13:\"Administrator\";i:1;s:4:\"test\";i:1;}s:11:\"31.43.1.116\";a:1:{s:5:\"Admin\";i:1;}s:13:\"217.146.246.2\";a:1:{s:5:\"admin\";i:1;}s:14:\"109.74.215.118\";a:1:{s:5:\"Admin\";i:1;}s:14:\"111.240.15.219\";a:1:{s:5:\"admin\";i:1;}s:13:\"88.135.215.29\";a:1:{s:5:\"Admin\";i:1;}s:15:\"176.212.223.239\";a:1:{s:5:\"admin\";i:1;}s:13:\"188.27.44.160\";a:1:{s:5:\"Admin\";i:1;}s:12:\"94.72.63.244\";a:1:{s:5:\"Admin\";i:1;}s:14:\"91.196.121.248\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.57.162.161\";a:1:{s:5:\"Admin\";i:1;}s:14:\"176.99.203.205\";a:1:{s:5:\"Admin\";i:1;}s:11:\"87.3.26.185\";a:1:{s:5:\"Admin\";i:1;}s:15:\"176.119.185.206\";a:1:{s:13:\"william-chang\";i:1;}s:13:\"114.27.18.123\";a:1:{s:5:\"admin\";i:1;}s:15:\"109.198.227.184\";a:1:{s:5:\"admin\";i:1;}s:13:\"1.169.202.200\";a:1:{s:5:\"admin\";i:1;}s:14:\"94.233.206.245\";a:1:{s:5:\"admin\";i:1;}s:11:\"5.13.195.47\";a:1:{s:5:\"Admin\";i:1;}s:14:\"83.139.130.185\";a:1:{s:5:\"admin\";i:1;}s:13:\"94.158.221.37\";a:1:{s:5:\"Admin\";i:1;}s:14:\"93.170.132.120\";a:1:{s:5:\"admin\";i:1;}s:13:\"46.119.227.60\";a:1:{s:5:\"admin\";i:1;}s:13:\"77.120.172.86\";a:1:{s:5:\"Admin\";i:1;}s:11:\"5.166.17.38\";a:1:{s:5:\"Admin\";i:1;}s:14:\"176.195.228.74\";a:1:{s:5:\"Admin\";i:1;}s:14:\"109.68.173.126\";a:1:{s:5:\"Admin\";i:1;}s:13:\"200.125.98.15\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.221.232.63\";a:1:{s:5:\"Admin\";i:1;}s:13:\"1.164.112.151\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.222.169.73\";a:1:{s:5:\"Admin\";i:1;}s:13:\"79.118.137.43\";a:1:{s:5:\"Admin\";i:1;}s:15:\"188.116.128.244\";a:1:{s:5:\"Admin\";i:1;}s:14:\"79.101.181.152\";a:1:{s:5:\"Admin\";i:1;}s:12:\"42.61.92.150\";a:1:{s:5:\"Admin\";i:1;}s:13:\"188.134.49.28\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.206.156.37\";a:1:{s:5:\"admin\";i:1;}s:12:\"31.134.20.34\";a:1:{s:5:\"Admin\";i:1;}s:13:\"178.57.166.25\";a:1:{s:5:\"Admin\";i:1;}s:13:\"82.137.173.26\";a:1:{s:5:\"Admin\";i:1;}s:14:\"114.37.107.139\";a:1:{s:5:\"Admin\";i:1;}s:14:\"80.240.248.210\";a:1:{s:5:\"Admin\";i:1;}s:14:\"94.176.144.166\";a:1:{s:5:\"Admin\";i:1;}s:13:\"89.178.157.10\";a:1:{s:5:\"Admin\";i:1;}s:13:\"77.242.22.206\";a:1:{s:5:\"Admin\";i:1;}s:10:\"95.29.80.9\";a:1:{s:5:\"Admin\";i:1;}s:14:\"211.229.45.132\";a:1:{s:5:\"Admin\";i:1;}s:12:\"93.84.108.16\";a:1:{s:5:\"Admin\";i:1;}s:14:\"115.40.183.226\";a:1:{s:5:\"Admin\";i:1;}s:15:\"109.101.112.193\";a:1:{s:5:\"Admin\";i:1;}s:12:\"79.181.5.175\";a:1:{s:5:\"Admin\";i:1;}s:13:\"82.196.86.214\";a:1:{s:5:\"Admin\";i:1;}s:13:\"80.233.132.57\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.175.26.219\";a:1:{s:5:\"Admin\";i:1;}s:12:\"1.161.96.139\";a:1:{s:5:\"Admin\";i:1;}s:13:\"106.51.35.230\";a:1:{s:5:\"admin\";i:1;}s:11:\"95.78.61.39\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.205.91.250\";a:1:{s:5:\"Admin\";i:1;}s:13:\"176.53.193.25\";a:1:{s:5:\"Admin\";i:1;}s:13:\"188.233.138.2\";a:2:{s:5:\"admin\";i:1;s:5:\"Admin\";i:1;}s:14:\"118.170.178.77\";a:1:{s:5:\"Admin\";i:1;}s:14:\"111.252.243.99\";a:1:{s:5:\"Admin\";i:1;}s:15:\"130.204.234.151\";a:1:{s:5:\"Admin\";i:1;}s:11:\"61.18.79.33\";a:1:{s:5:\"Admin\";i:1;}s:14:\"177.225.118.54\";a:1:{s:5:\"Admin\";i:1;}s:13:\"62.162.193.38\";a:1:{s:5:\"Admin\";i:1;}s:12:\"37.46.228.27\";a:1:{s:5:\"Admin\";i:1;}s:13:\"37.54.245.121\";a:1:{s:5:\"admin\";i:1;}s:12:\"95.85.70.203\";a:1:{s:5:\"Admin\";i:1;}s:13:\"95.160.26.219\";a:1:{s:5:\"admin\";i:1;}s:13:\"219.92.17.238\";a:1:{s:5:\"Admin\";i:1;}s:11:\"46.11.31.65\";a:1:{s:5:\"Admin\";i:1;}s:13:\"37.235.144.55\";a:1:{s:5:\"Admin\";i:1;}s:13:\"217.24.244.39\";a:1:{s:5:\"Admin\";i:1;}s:15:\"178.219.145.124\";a:1:{s:5:\"Admin\";i:1;}s:13:\"37.200.235.51\";a:1:{s:5:\"Admin\";i:1;}s:9:\"94.79.7.2\";a:1:{s:5:\"Admin\";i:1;}s:12:\"94.143.42.58\";a:1:{s:5:\"Admin\";i:1;}s:14:\"82.135.148.187\";a:1:{s:5:\"Admin\";i:1;}s:14:\"176.213.14.128\";a:1:{s:5:\"admin\";i:1;}s:12:\"79.178.111.4\";a:1:{s:5:\"Admin\";i:1;}s:13:\"78.85.168.188\";a:1:{s:5:\"Admin\";i:1;}s:13:\"176.15.89.231\";a:1:{s:5:\"Admin\";i:1;}s:13:\"115.78.231.73\";a:1:{s:5:\"Admin\";i:1;}s:13:\"114.26.25.203\";a:1:{s:5:\"Admin\";i:1;}s:13:\"94.180.200.65\";a:1:{s:5:\"Admin\";i:1;}s:12:\"1.173.98.234\";a:1:{s:5:\"Admin\";i:1;}s:14:\"118.171.112.85\";a:1:{s:5:\"Admin\";i:1;}s:14:\"114.45.207.224\";a:1:{s:5:\"Admin\";i:1;}s:14:\"59.115.138.166\";a:1:{s:5:\"Admin\";i:1;}s:14:\"164.138.36.183\";a:1:{s:5:\"Admin\";i:1;}s:15:\"112.104.198.204\";a:1:{s:5:\"admin\";i:1;}s:14:\"89.137.220.208\";a:1:{s:5:\"Admin\";i:1;}s:14:\"81.182.179.168\";a:1:{s:5:\"Admin\";i:1;}s:15:\"222.255.251.130\";a:1:{s:5:\"Admin\";i:1;}s:12:\"113.186.7.87\";a:1:{s:5:\"Admin\";i:1;}s:13:\"212.7.253.108\";a:1:{s:5:\"Admin\";i:1;}s:12:\"46.73.134.24\";a:1:{s:5:\"Admin\";i:1;}s:14:\"92.255.212.185\";a:1:{s:5:\"Admin\";i:1;}s:13:\"79.126.248.18\";a:1:{s:5:\"Admin\";i:1;}s:13:\"2.180.127.194\";a:1:{s:5:\"Admin\";i:1;}s:13:\"114.40.142.99\";a:1:{s:5:\"Admin\";i:1;}s:14:\"220.137.51.166\";a:1:{s:5:\"Admin\";i:1;}s:14:\"118.160.44.147\";a:1:{s:5:\"Admin\";i:1;}s:12:\"176.99.70.21\";a:1:{s:5:\"Admin\";i:1;}s:13:\"5.141.190.165\";a:1:{s:5:\"Admin\";i:1;}s:12:\"36.225.25.57\";a:1:{s:5:\"Admin\";i:1;}s:15:\"109.165.131.231\";a:1:{s:5:\"Admin\";i:1;}s:15:\"188.191.144.122\";a:1:{s:5:\"Admin\";i:1;}s:13:\"115.43.232.21\";a:1:{s:5:\"admin\";i:1;}s:14:\"180.211.118.10\";a:1:{s:5:\"Admin\";i:1;}s:13:\"79.126.87.241\";a:1:{s:5:\"Admin\";i:1;}s:15:\"188.187.149.112\";a:1:{s:5:\"Admin\";i:1;}s:13:\"95.154.72.166\";a:1:{s:5:\"Admin\";i:1;}s:13:\"2.183.131.141\";a:1:{s:5:\"Admin\";i:1;}s:12:\"5.60.176.161\";a:1:{s:5:\"Admin\";i:1;}s:13:\"103.5.133.117\";a:1:{s:5:\"Admin\";i:1;}s:14:\"187.160.217.37\";a:1:{s:5:\"Admin\";i:1;}s:14:\"114.46.233.173\";a:1:{s:5:\"admin\";i:1;}s:15:\"109.242.135.126\";a:1:{s:5:\"Admin\";i:1;}s:13:\"202.62.104.20\";a:1:{s:5:\"admin\";i:1;}s:14:\"114.41.213.183\";a:1:{s:5:\"Admin\";i:1;}s:13:\"14.163.105.81\";a:1:{s:5:\"admin\";i:1;}s:14:\"188.232.28.126\";a:1:{s:5:\"Admin\";i:1;}s:12:\"95.32.180.88\";a:1:{s:5:\"Admin\";i:1;}s:13:\"91.140.197.39\";a:1:{s:5:\"Admin\";i:1;}s:14:\"42.114.248.165\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.47.107.198\";a:1:{s:5:\"Admin\";i:1;}s:14:\"188.247.111.34\";a:1:{s:5:\"Admin\";i:1;}s:14:\"82.178.119.228\";a:1:{s:5:\"admin\";i:1;}s:15:\"222.252.230.180\";a:1:{s:5:\"Admin\";i:1;}s:14:\"213.87.129.191\";a:1:{s:5:\"Admin\";i:1;}s:13:\"79.126.108.27\";a:1:{s:5:\"Admin\";i:1;}s:11:\"37.122.1.89\";a:1:{s:5:\"Admin\";i:1;}s:13:\"91.122.23.202\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.71.202.107\";a:1:{s:5:\"Admin\";i:1;}s:14:\"178.175.93.239\";a:1:{s:5:\"Admin\";i:1;}s:12:\"94.218.182.6\";a:1:{s:5:\"Admin\";i:1;}s:15:\"213.179.245.158\";a:1:{s:5:\"Admin\";i:1;}s:15:\"220.130.187.246\";a:1:{s:5:\"Admin\";i:1;}s:14:\"84.238.189.128\";a:1:{s:5:\"Admin\";i:1;}s:14:\"211.109.128.37\";a:1:{s:5:\"Admin\";i:1;}s:13:\"95.77.248.116\";a:1:{s:5:\"admin\";i:1;}s:14:\"217.36.106.195\";a:1:{s:5:\"Admin\";i:1;}s:14:\"185.38.249.130\";a:1:{s:5:\"admin\";i:1;}s:13:\"37.139.50.100\";a:1:{s:5:\"admin\";i:2;}s:11:\"64.31.25.60\";a:1:{s:5:\"admin\";i:10;}s:13:\"85.112.29.210\";a:1:{s:5:\"admin\";i:7;}s:13:\"5.135.165.206\";a:1:{s:5:\"admin\";i:16;}s:13:\"222.255.29.39\";a:1:{s:5:\"admin\";i:2;}s:13:\"64.34.173.227\";a:1:{s:5:\"admin\";i:34;}s:11:\"5.39.106.19\";a:1:{s:5:\"admin\";i:13;}s:11:\"89.47.253.2\";a:1:{s:5:\"admin\";i:18;}s:13:\"85.214.64.100\";a:1:{s:5:\"admin\";i:3;}s:13:\"182.253.3.222\";a:1:{s:13:\"Administrator\";i:1;}s:12:\"42.62.24.250\";a:1:{s:5:\"admin\";i:1;}s:14:\"46.102.232.243\";a:1:{s:5:\"admin\";i:3;}s:11:\"69.64.65.10\";a:1:{s:5:\"admin\";i:2;}s:14:\"198.50.112.114\";a:1:{s:5:\"admin\";i:5;}s:12:\"142.4.208.97\";a:1:{s:5:\"admin\";i:3;}s:15:\"213.251.189.208\";a:1:{s:5:\"admin\";i:6;}s:15:\"190.107.177.102\";a:1:{s:5:\"admin\";i:2;}s:14:\"93.170.131.250\";a:1:{s:5:\"admin\";i:1;}s:13:\"87.255.57.169\";a:1:{s:5:\"admin\";i:19;}s:13:\"62.193.193.96\";a:1:{s:5:\"admin\";i:11;}s:14:\"192.64.178.136\";a:1:{s:5:\"admin\";i:1;}s:15:\"203.195.184.151\";a:1:{s:5:\"admin\";i:2;}s:13:\"60.12.119.200\";a:1:{s:5:\"admin\";i:1;}s:14:\"209.217.255.50\";a:1:{s:5:\"admin\";i:1;}s:13:\"66.147.235.81\";a:1:{s:5:\"admin\";i:2;}s:12:\"88.86.81.212\";a:1:{s:5:\"admin\";i:2;}s:12:\"67.215.7.226\";a:1:{s:5:\"admin\";i:1;}s:13:\"37.205.32.122\";a:1:{s:5:\"admin\";i:1;}s:13:\"82.145.45.104\";a:1:{s:5:\"admin\";i:1;}s:12:\"185.9.157.31\";a:1:{s:5:\"admin\";i:2;}s:13:\"195.93.180.34\";a:1:{s:5:\"admin\";i:4;}s:11:\"5.9.121.109\";a:1:{s:5:\"admin\";i:5;}s:13:\"46.165.206.78\";a:1:{s:5:\"admin\";i:12;}s:12:\"89.248.60.70\";a:1:{s:5:\"admin\";i:1;}s:11:\"41.190.76.5\";a:1:{s:5:\"admin\";i:1;}s:14:\"62.212.130.150\";a:1:{s:5:\"admin\";i:1;}s:15:\"118.139.162.178\";a:1:{s:5:\"admin\";i:1;}s:12:\"83.96.132.85\";a:1:{s:5:\"admin\";i:1;}s:11:\"1.234.83.77\";a:1:{s:5:\"admin\";i:2;}s:14:\"166.63.127.244\";a:1:{s:5:\"admin\";i:3;}s:12:\"94.23.41.138\";a:1:{s:5:\"admin\";i:2;}s:13:\"91.208.16.231\";a:1:{s:5:\"admin\";i:1;}s:14:\"184.168.112.26\";a:1:{s:5:\"admin\";i:1;}s:13:\"97.74.127.145\";a:1:{s:5:\"admin\";i:2;}s:11:\"37.59.29.48\";a:1:{s:5:\"admin\";i:2;}s:12:\"69.85.84.194\";a:1:{s:5:\"admin\";i:2;}s:11:\"95.17.79.40\";a:1:{s:5:\"admin\";i:1;}s:12:\"80.97.64.148\";a:1:{s:5:\"admin\";i:1;}s:12:\"50.62.41.168\";a:1:{s:5:\"admin\";i:1;}s:13:\"61.93.247.153\";a:1:{s:5:\"admin\";i:1;}s:15:\"205.186.142.240\";a:1:{s:5:\"admin\";i:1;}s:14:\"210.210.178.20\";a:1:{s:5:\"admin\";i:2;}s:12:\"112.198.64.2\";a:1:{s:5:\"admin\";i:1;}s:14:\"64.207.147.191\";a:1:{s:5:\"admin\";i:1;}s:14:\"93.170.128.217\";a:1:{s:5:\"admin\";i:4;}s:14:\"109.108.57.156\";a:1:{s:5:\"admin\";i:2;}s:13:\"95.181.178.59\";a:1:{s:5:\"admin\";i:1;}s:13:\"87.119.255.26\";a:1:{s:5:\"admin\";i:2;}s:10:\"5.61.35.34\";a:1:{s:5:\"admin\";i:5;}s:15:\"178.126.244.179\";a:1:{s:5:\"admin\";i:1;}s:11:\"91.208.16.3\";a:1:{s:5:\"admin\";i:1;}s:11:\"46.109.66.4\";a:1:{s:5:\"admin\";i:3;}s:13:\"87.239.30.134\";a:1:{s:5:\"Admin\";i:1;}s:13:\"87.252.227.16\";a:1:{s:5:\"admin\";i:1;}s:14:\"173.201.34.215\";a:1:{s:5:\"admin\";i:2;}s:14:\"125.253.122.99\";a:1:{s:5:\"admin\";i:3;}s:15:\"188.165.202.118\";a:1:{s:5:\"admin\";i:1;}s:14:\"106.187.47.170\";a:1:{s:5:\"admin\";i:2;}s:14:\"189.91.198.211\";a:1:{s:5:\"Admin\";i:1;}s:13:\"187.22.80.200\";a:1:{s:5:\"Admin\";i:1;}s:14:\"188.72.126.182\";a:1:{s:5:\"admin\";i:4;}s:14:\"178.137.34.186\";a:1:{s:5:\"admin\";i:7;}s:13:\"46.105.105.58\";a:1:{s:5:\"admin\";i:1;}s:14:\"193.106.31.225\";a:1:{s:5:\"admin\";i:5;}s:13:\"185.50.250.98\";a:1:{s:5:\"admin\";i:2;}s:13:\"61.153.209.18\";a:1:{s:5:\"admin\";i:2;}s:10:\"84.240.9.6\";a:1:{s:5:\"admin\";i:1;}s:13:\"213.159.38.90\";a:1:{s:5:\"admin\";i:2;}s:14:\"163.177.154.22\";a:1:{s:5:\"admin\";i:1;}s:12:\"212.24.62.22\";a:2:{s:5:\"admin\";i:2;s:13:\"william-chang\";i:1;}s:14:\"195.114.19.195\";a:1:{s:5:\"admin\";i:5;}s:12:\"194.28.84.34\";a:1:{s:5:\"admin\";i:8;}s:14:\"89.248.166.153\";a:1:{s:5:\"admin\";i:2;}s:12:\"195.14.0.151\";a:1:{s:5:\"admin\";i:5;}s:14:\"91.142.210.158\";a:1:{s:5:\"admin\";i:24;}s:14:\"91.121.141.223\";a:1:{s:5:\"admin\";i:4;}s:14:\"74.208.184.251\";a:1:{s:5:\"admin\";i:3;}s:13:\"62.210.139.80\";a:1:{s:5:\"admin\";i:1;}s:12:\"216.70.90.99\";a:1:{s:5:\"admin\";i:4;}s:13:\"192.168.100.2\";a:1:{s:5:\"admin\";i:1;}s:14:\"207.58.135.162\";a:1:{s:5:\"admin\";i:6;}s:14:\"162.42.239.248\";a:1:{s:5:\"admin\";i:4;}s:13:\"198.89.122.74\";a:1:{s:5:\"admin\";i:4;}s:12:\"23.253.90.79\";a:1:{s:5:\"admin\";i:5;}s:14:\"166.78.169.147\";a:1:{s:5:\"admin\";i:6;}s:14:\"74.208.111.148\";a:1:{s:5:\"admin\";i:3;}s:15:\"129.121.182.100\";a:1:{s:5:\"admin\";i:2;}s:15:\"213.229.121.124\";a:1:{s:5:\"admin\";i:3;}s:14:\"96.126.103.244\";a:1:{s:5:\"admin\";i:1;}s:14:\"109.228.18.144\";a:1:{s:5:\"admin\";i:4;}s:12:\"95.141.32.86\";a:1:{s:5:\"admin\";i:1;}s:13:\"92.60.123.168\";a:1:{s:5:\"admin\";i:2;}s:13:\"93.189.94.143\";a:1:{s:5:\"admin\";i:2;}s:14:\"195.154.117.65\";a:1:{s:5:\"admin\";i:6;}s:13:\"209.148.90.10\";a:1:{s:5:\"admin\";i:1;}s:13:\"37.187.37.199\";a:1:{s:5:\"admin\";i:2;}s:14:\"133.242.22.177\";a:1:{s:5:\"admin\";i:4;}s:14:\"216.70.107.236\";a:1:{s:5:\"admin\";i:2;}s:14:\"82.165.143.210\";a:1:{s:5:\"admin\";i:6;}s:14:\"193.255.83.100\";a:1:{s:5:\"admin\";i:1;}s:14:\"95.110.145.224\";a:1:{s:5:\"admin\";i:4;}s:12:\"185.28.22.76\";a:1:{s:5:\"admin\";i:1;}s:13:\"217.147.85.95\";a:1:{s:5:\"admin\";i:1;}s:14:\"195.154.178.51\";a:1:{s:5:\"admin\";i:3;}s:14:\"182.160.155.72\";a:1:{s:5:\"admin\";i:2;}s:13:\"98.113.142.42\";a:1:{s:6:\"wchang\";i:1;}s:11:\"52.0.121.60\";a:1:{s:4:\"test\";i:1;}s:13:\"23.94.150.226\";a:1:{s:5:\"admin\";i:3;}s:12:\"62.141.44.69\";a:1:{s:5:\"admin\";i:1;}s:13:\"91.200.12.138\";a:1:{s:5:\"admin\";i:1;}s:12:\"176.123.25.8\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.10.104.240\";a:1:{s:5:\"admin\";i:1;}s:14:\"158.69.201.128\";a:1:{s:5:\"admin\";i:1;}s:14:\"198.100.150.16\";a:1:{s:5:\"admin\";i:1;}s:13:\"176.10.99.206\";a:1:{s:5:\"admin\";i:1;}s:14:\"185.65.135.228\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.126.252.12\";a:1:{s:5:\"admin\";i:1;}s:13:\"195.154.56.44\";a:1:{s:5:\"admin\";i:1;}s:13:\"176.10.99.200\";a:1:{s:5:\"admin\";i:1;}s:14:\"91.109.247.173\";a:1:{s:5:\"admin\";i:1;}s:14:\"95.211.101.231\";a:1:{s:5:\"admin\";i:1;}s:15:\"188.214.135.117\";a:1:{s:5:\"admin\";i:1;}s:15:\"188.214.135.124\";a:1:{s:5:\"admin\";i:1;}s:13:\"5.199.142.195\";a:1:{s:5:\"admin\";i:1;}s:14:\"92.222.113.177\";a:1:{s:5:\"admin\";i:1;}s:11:\"81.7.15.115\";a:1:{s:5:\"admin\";i:1;}s:11:\"37.48.65.76\";a:1:{s:5:\"admin\";i:1;}s:13:\"62.141.45.246\";a:1:{s:5:\"admin\";i:1;}s:13:\"209.222.8.196\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.126.252.11\";a:1:{s:5:\"admin\";i:1;}s:12:\"178.63.97.34\";a:1:{s:5:\"admin\";i:1;}s:12:\"188.138.9.49\";a:1:{s:5:\"admin\";i:1;}s:14:\"74.208.220.222\";a:1:{s:5:\"admin\";i:1;}s:13:\"109.163.234.5\";a:1:{s:5:\"admin\";i:1;}s:13:\"94.242.246.24\";a:1:{s:5:\"admin\";i:1;}s:14:\"209.249.157.69\";a:1:{s:5:\"admin\";i:1;}s:14:\"171.25.193.132\";a:1:{s:5:\"admin\";i:1;}s:13:\"94.26.140.150\";a:1:{s:5:\"admin\";i:1;}s:14:\"92.222.252.206\";a:1:{s:5:\"admin\";i:1;}s:12:\"176.123.26.3\";a:1:{s:5:\"admin\";i:1;}s:13:\"176.123.7.172\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.123.15.154\";a:1:{s:5:\"admin\";i:2;}s:14:\"176.123.26.130\";a:1:{s:5:\"admin\";i:1;}s:14:\"176.123.12.158\";a:1:{s:5:\"admin\";i:2;}s:13:\"176.123.9.139\";a:1:{s:5:\"admin\";i:1;}s:13:\"62.210.140.73\";a:1:{s:5:\"admin\";i:1;}s:13:\"36.248.187.85\";a:1:{s:5:\"admin\";i:1;}s:12:\"54.193.50.50\";a:1:{s:5:\"admin\";i:1;}s:13:\"54.193.51.226\";a:1:{s:5:\"admin\";i:1;}s:12:\"93.179.69.55\";a:1:{s:5:\"admin\";i:3;}s:11:\"93.24.30.45\";a:1:{s:5:\"admin\";i:1;}s:10:\"5.39.217.5\";a:1:{s:5:\"admin\";i:1;}s:12:\"45.56.154.14\";a:1:{s:5:\"admin\";i:1;}s:13:\"185.70.187.50\";a:1:{s:5:\"admin\";i:1;}s:13:\"37.187.176.58\";a:1:{s:5:\"admin\";i:1;}s:15:\"167.114.156.160\";a:1:{s:5:\"admin\";i:1;}s:13:\"104.233.86.91\";a:1:{s:5:\"admin\";i:4;}s:13:\"151.80.194.68\";a:1:{s:5:\"admin\";i:1;}s:14:\"178.32.216.214\";a:1:{s:5:\"admin\";i:1;}s:11:\"92.63.87.97\";a:2:{s:8:\"password\";i:1;s:5:\"admin\";i:2;}s:12:\"103.23.244.8\";a:1:{s:5:\"admin\";i:1;}s:14:\"162.144.151.73\";a:1:{s:5:\"admin\";i:1;}s:13:\"50.93.200.221\";a:1:{s:5:\"admin\";i:2;}s:11:\"92.63.87.10\";a:1:{s:17:\"william-chang.com\";i:1;}s:11:\"120.43.27.2\";a:1:{s:5:\"admin\";i:1;}s:13:\"120.34.99.202\";a:1:{s:5:\"admin\";i:1;}}","no");
INSERT INTO `wp_options` VALUES("44437","limit_login_lockouts_total","701","no");
INSERT INTO `wp_options` VALUES("209194","_wp_session_expires_6df32a70b2caa0d0eed439ec33f850aa","2787995880","no");
INSERT INTO `wp_options` VALUES("209256","_wp_session_expires_f6e81724e90481251b6f7feabce2148b","2788003004","no");
INSERT INTO `wp_options` VALUES("209266","_wp_session_1737228638ff80524ac00ec3d0349893","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e72ee7a0ab76621e7605f4975435e57d\";}\";}","no");
INSERT INTO `wp_options` VALUES("208317","_wp_session_expires_8571f16885c5fa7a4492ee72f53917cb","2787894946","no");
INSERT INTO `wp_options` VALUES("208321","_wp_session_3804c094f84d94948b749b127c39cbc0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1b125a80d8d2365aadd43f3d7ae0ae88\";}\";}","no");
INSERT INTO `wp_options` VALUES("208322","_wp_session_expires_3804c094f84d94948b749b127c39cbc0","2787895456","no");
INSERT INTO `wp_options` VALUES("208331","_wp_session_e59b8840b810ae6f4b09790f7c07181e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3a9363fca632be4c75254a1278c5e6db\";}\";}","no");
INSERT INTO `wp_options` VALUES("208332","_wp_session_expires_e59b8840b810ae6f4b09790f7c07181e","2787896478","no");
INSERT INTO `wp_options` VALUES("208337","_wp_session_3ba86a86a496359810112716f52fb3b6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"046b647e31df2d65b8fcc8de53416cb3\";}\";}","no");
INSERT INTO `wp_options` VALUES("208338","_wp_session_expires_3ba86a86a496359810112716f52fb3b6","2787898074","no");
INSERT INTO `wp_options` VALUES("208352","_wp_session_58784a2093de5cd07f502eeec935f8df","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fa40c3ea1a03dafbcf917d07babd337f\";}\";}","no");
INSERT INTO `wp_options` VALUES("208353","_wp_session_expires_58784a2093de5cd07f502eeec935f8df","2787899742","no");
INSERT INTO `wp_options` VALUES("208356","_wp_session_5ecb787f524b50911c7b2be64e0f14cb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a1e4533095d23ea30305038fcd3a72bb\";}\";}","no");
INSERT INTO `wp_options` VALUES("208357","_wp_session_expires_5ecb787f524b50911c7b2be64e0f14cb","2787900176","no");
INSERT INTO `wp_options` VALUES("208359","_wp_session_f1bf48006204bf1ccc115ae887f627c3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"95ba1722c080be9ce560414998324ea5\";}\";}","no");
INSERT INTO `wp_options` VALUES("208360","_wp_session_expires_f1bf48006204bf1ccc115ae887f627c3","2787901500","no");
INSERT INTO `wp_options` VALUES("208362","_wp_session_d45e6a947e1b95e04f44ba425a22467e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8de7456bac9837e49fbfd4a6b7a24955\";}\";}","no");
INSERT INTO `wp_options` VALUES("208363","_wp_session_expires_d45e6a947e1b95e04f44ba425a22467e","2787901684","no");
INSERT INTO `wp_options` VALUES("208379","_wp_session_8e25a9ef5ba504bdd66ff80252bc7161","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4e20ffff8b50584ff1df27a494d01c34\";}\";}","no");
INSERT INTO `wp_options` VALUES("208375","_wp_session_6209d097b6278014120c64b0f7f9d53e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e5a49f92eba58869e4eb152b0b1e973d\";}\";}","no");
INSERT INTO `wp_options` VALUES("208376","_wp_session_expires_6209d097b6278014120c64b0f7f9d53e","2787904082","no");
INSERT INTO `wp_options` VALUES("208380","_wp_session_expires_8e25a9ef5ba504bdd66ff80252bc7161","2787904376","no");
INSERT INTO `wp_options` VALUES("241432","_wp_session_expires_5b3b3efbb766ae3e41aa348be512e8a7","2791740786","no");
INSERT INTO `wp_options` VALUES("208413","_wp_session_05a504b04947a2008837b08b13279285","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"262220193958a209b6575f5e07703710\";}\";}","no");
INSERT INTO `wp_options` VALUES("208414","_wp_session_expires_05a504b04947a2008837b08b13279285","2787907420","no");
INSERT INTO `wp_options` VALUES("208425","_wp_session_c3ec680dd916172157c9605c0a7498e4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"86ddc53acd8712c9cd1e742407f99242\";}\";}","no");
INSERT INTO `wp_options` VALUES("208426","_wp_session_expires_c3ec680dd916172157c9605c0a7498e4","2787910102","no");
INSERT INTO `wp_options` VALUES("208437","_wp_session_1e46302e30a8911cc6f474989f228553","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"92475493fada64bf2e27916cde29741c\";}\";}","no");
INSERT INTO `wp_options` VALUES("208438","_wp_session_expires_1e46302e30a8911cc6f474989f228553","2787912322","no");
INSERT INTO `wp_options` VALUES("208440","_wp_session_29930e2b08cda73f4cf715a5960c99a1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ec60600a20814c45e2b209f66122ab42\";}\";}","no");
INSERT INTO `wp_options` VALUES("208441","_wp_session_expires_29930e2b08cda73f4cf715a5960c99a1","2787912456","no");
INSERT INTO `wp_options` VALUES("208451","_wp_session_fe6a6e6dd9f8dfc14b17dafd98932ab0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"404ba55ed2510fedb7c6ecec4ddfdfe5\";}\";}","no");
INSERT INTO `wp_options` VALUES("208452","_wp_session_expires_fe6a6e6dd9f8dfc14b17dafd98932ab0","2787913704","no");
INSERT INTO `wp_options` VALUES("208481","_wp_session_dcf5a081643193e1007a426bf9646534","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7d4d06ec89f6824c8eb441a9e1f7c58e\";}\";}","no");
INSERT INTO `wp_options` VALUES("208482","_wp_session_expires_dcf5a081643193e1007a426bf9646534","2787915856","no");
INSERT INTO `wp_options` VALUES("208484","_wp_session_f59c8fdcf5b7125fce96b30e3f820f7e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"16d262cea10d7a157f04d0fb9033f141\";}\";}","no");
INSERT INTO `wp_options` VALUES("208485","_wp_session_expires_f59c8fdcf5b7125fce96b30e3f820f7e","2787916258","no");
INSERT INTO `wp_options` VALUES("208518","_wp_session_1e1a42245f0f8e992a4284fb17cf9ada","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7c9fb55e98784c4c5db034389fea001d\";}\";}","no");
INSERT INTO `wp_options` VALUES("66720","akismet_spam_count","367","yes");
INSERT INTO `wp_options` VALUES("395606","itsec_file_change","a:9:{s:7:\"enabled\";b:1;s:6:\"method\";b:1;s:9:\"file_list\";a:1:{i:0;s:0:\"\";}s:5:\"types\";a:6:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".log\";i:4;s:3:\".mo\";i:5;s:3:\".po\";}s:5:\"email\";b:1;s:12:\"notify_admin\";b:1;s:5:\"split\";b:0;s:10:\"last_chunk\";b:0;s:8:\"last_run\";d:1448899730;}","yes");
INSERT INTO `wp_options` VALUES("209762","_wp_session_expires_e16f3fea9e47eb27fd3308e7fca7bbf3","2788080142","no");
INSERT INTO `wp_options` VALUES("209684","_wp_session_expires_a43c4bb6fefb82b09def18de0d6bb031","2788069592","no");
INSERT INTO `wp_options` VALUES("209700","_wp_session_expires_3dfbec5d5d13850fc005d0b25f8f4204","2788073970","no");
INSERT INTO `wp_options` VALUES("395605","itsec_backup","a:9:{s:6:\"method\";i:1;s:8:\"location\";s:86:\"/home/changtwo/public_html/williamchangnew/wp-content/uploads/ithemes-security/backups\";s:6:\"retain\";i:0;s:3:\"zip\";b:1;s:7:\"exclude\";a:3:{i:0;s:14:\"itsec_lockouts\";i:1;s:9:\"itsec_log\";i:2;s:10:\"itsec_temp\";}s:7:\"enabled\";b:1;s:8:\"interval\";i:3;s:9:\"all_sites\";b:0;s:8:\"last_run\";i:1448706135;}","yes");
INSERT INTO `wp_options` VALUES("209592","_wp_session_expires_4002f9ee74739dd13d15eae12105f20a","2788058142","no");
INSERT INTO `wp_options` VALUES("209515","_wp_session_ec35ee595066e2c92ba4b3bdbcb8a09e","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("209514","_wp_session_expires_ec35ee595066e2c92ba4b3bdbcb8a09e","2788040834","no");
INSERT INTO `wp_options` VALUES("212364","_wp_session_expires_eb3b9a191d2645e2c045125aa31f18d9","2788409376","no");
INSERT INTO `wp_options` VALUES("212367","_wp_session_e885c71d8452ac17115926c8a557e9b6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"18f8f5b61e05eae716b22309b7685033\";}\";}","no");
INSERT INTO `wp_options` VALUES("212368","_wp_session_expires_e885c71d8452ac17115926c8a557e9b6","2788410182","no");
INSERT INTO `wp_options` VALUES("212372","_wp_session_85698dba10b0a6766603c2928bbf1b2c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4b8f33dfe573a0926356b5e0ae26a60a\";}\";}","no");
INSERT INTO `wp_options` VALUES("209154","_wp_session_expires_e6436c7505ba24fa91f83e95841ce701","2787990482","no");
INSERT INTO `wp_options` VALUES("209165","_wp_session_91fa3a1836c6cb51a5a5a047eb613ea6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"668ddd660fb44fe93bd44d7b8ac7fb13\";}\";}","no");
INSERT INTO `wp_options` VALUES("209166","_wp_session_expires_91fa3a1836c6cb51a5a5a047eb613ea6","2787993546","no");
INSERT INTO `wp_options` VALUES("209170","_wp_session_09858392ed375c5871df9ec3712e79b0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"aa03c3ae7a58f071d4165a8463bd094d\";}\";}","no");
INSERT INTO `wp_options` VALUES("209171","_wp_session_expires_09858392ed375c5871df9ec3712e79b0","2787994344","no");
INSERT INTO `wp_options` VALUES("209175","_wp_session_3c958ef7516609a7eba5e8b7d2b376e1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0a96b2b9d48d4e70a6893e48490d665d\";}\";}","no");
INSERT INTO `wp_options` VALUES("209176","_wp_session_expires_3c958ef7516609a7eba5e8b7d2b376e1","2787994664","no");
INSERT INTO `wp_options` VALUES("259830","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"williamchang23@gmail.com\";s:7:\"version\";s:5:\"4.3.1\";s:9:\"timestamp\";i:1442331412;}","yes");
INSERT INTO `wp_options` VALUES("12963","limit_login_lockout_notify","log","yes");
INSERT INTO `wp_options` VALUES("12964","limit_login_notify_email_after","4","yes");
INSERT INTO `wp_options` VALUES("12965","limit_login_cookies","1","yes");
INSERT INTO `wp_options` VALUES("148","theme_mods_twentythirteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1382008333;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}}}}","yes");
INSERT INTO `wp_options` VALUES("149","current_theme","Satellite7 (shared on wplocker.com)","yes");
INSERT INTO `wp_options` VALUES("150","theme_mods_satellite","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:14:\"top-navigation\";i:16;}}","yes");
INSERT INTO `wp_options` VALUES("151","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("152","qode_options_satellite","a:216:{s:11:\"first_color\";s:7:\"#34c1f5\";s:12:\"second_color\";s:0:\"\";s:11:\"third_color\";s:0:\"\";s:16:\"background_color\";s:0:\"\";s:20:\"background_color_box\";s:0:\"\";s:15:\"highlight_color\";s:0:\"\";s:15:\"selection_color\";s:0:\"\";s:16:\"background_image\";s:0:\"\";s:24:\"pattern_background_image\";s:0:\"\";s:13:\"favicon_image\";s:63:\"http://william-chang.com/wp-content/uploads/2013/10/favicon.png\";s:12:\"google_fonts\";s:2:\"-1\";s:16:\"page_transitions\";s:1:\"0\";s:5:\"boxed\";s:2:\"no\";s:17:\"loading_animation\";s:2:\"on\";s:13:\"loading_image\";s:72:\"http://william-chang.com/wp-content/themes/satellite/img/ajax-loader.gif\";s:13:\"smooth_scroll\";s:3:\"yes\";s:14:\"responsiveness\";s:3:\"yes\";s:16:\"show_back_button\";s:2:\"no\";s:21:\"google_analytics_code\";s:13:\"UA-10783561-6\";s:22:\"internal_no_ajax_links\";s:0:\"\";s:10:\"custom_css\";s:576:\".home .latest_post_bottom{display:none;}
.home .latest_post_text span{display:none;}
.page-id-3271 p, .page-id-3473 p, .page-id-3471 p{margin-bottom:15px;}
.page-id-3271 .title .title_holder .container{padding-top:20px;}
.portfolio_like{display:none !important;}
.single .post_image{display:none;}
.single p{margin-bottom:15px;}
.single-post .title{height:190px;}
.page-id-174 .text_inner{display:none !important;}
.title.has_background{background-repeat: repeat !important}
.list.circle ul>li, .list.number ul>li, .list.number_with_background ul>li{font-size:15px;}\";s:9:\"custom_js\";s:0:\"\";s:13:\"meta_keywords\";s:0:\"\";s:16:\"meta_description\";s:0:\"\";s:16:\"disable_qode_seo\";s:2:\"no\";s:8:\"h1_color\";s:0:\"\";s:15:\"h1_google_fonts\";s:2:\"-1\";s:11:\"h1_fontsize\";s:0:\"\";s:13:\"h1_lineheight\";s:0:\"\";s:12:\"h1_fontstyle\";s:0:\"\";s:13:\"h1_fontweight\";s:0:\"\";s:8:\"h2_color\";s:0:\"\";s:15:\"h2_google_fonts\";s:2:\"-1\";s:11:\"h2_fontsize\";s:0:\"\";s:13:\"h2_lineheight\";s:0:\"\";s:12:\"h2_fontstyle\";s:0:\"\";s:13:\"h2_fontweight\";s:0:\"\";s:8:\"h3_color\";s:0:\"\";s:15:\"h3_google_fonts\";s:2:\"-1\";s:11:\"h3_fontsize\";s:0:\"\";s:13:\"h3_lineheight\";s:0:\"\";s:12:\"h3_fontstyle\";s:0:\"\";s:13:\"h3_fontweight\";s:0:\"\";s:8:\"h4_color\";s:0:\"\";s:15:\"h4_google_fonts\";s:2:\"-1\";s:11:\"h4_fontsize\";s:0:\"\";s:13:\"h4_lineheight\";s:0:\"\";s:12:\"h4_fontstyle\";s:0:\"\";s:13:\"h4_fontweight\";s:0:\"\";s:8:\"h5_color\";s:0:\"\";s:15:\"h5_google_fonts\";s:2:\"-1\";s:11:\"h5_fontsize\";s:0:\"\";s:13:\"h5_lineheight\";s:0:\"\";s:12:\"h5_fontstyle\";s:0:\"\";s:13:\"h5_fontweight\";s:0:\"\";s:8:\"h6_color\";s:0:\"\";s:15:\"h6_google_fonts\";s:2:\"-1\";s:11:\"h6_fontsize\";s:0:\"\";s:13:\"h6_lineheight\";s:0:\"\";s:12:\"h6_fontstyle\";s:0:\"\";s:13:\"h6_fontweight\";s:0:\"\";s:10:\"text_color\";s:0:\"\";s:17:\"text_google_fonts\";s:2:\"-1\";s:13:\"text_fontsize\";s:0:\"\";s:15:\"text_lineheight\";s:0:\"\";s:14:\"text_fontstyle\";s:0:\"\";s:15:\"text_fontweight\";s:0:\"\";s:11:\"text_margin\";s:0:\"\";s:10:\"link_color\";s:0:\"\";s:15:\"link_hovercolor\";s:0:\"\";s:14:\"link_fontstyle\";s:0:\"\";s:15:\"link_fontweight\";s:0:\"\";s:19:\"link_fontdecoration\";s:0:\"\";s:16:\"page_title_color\";s:0:\"\";s:23:\"page_title_google_fonts\";s:2:\"-1\";s:19:\"page_title_fontsize\";s:0:\"\";s:21:\"page_title_lineheight\";s:0:\"\";s:20:\"page_title_fontstyle\";s:0:\"\";s:21:\"page_title_fontweight\";s:0:\"\";s:19:\"page_subtitle_color\";s:0:\"\";s:26:\"page_subtitle_google_fonts\";s:2:\"-1\";s:22:\"page_subtitle_fontsize\";s:0:\"\";s:24:\"page_subtitle_lineheight\";s:0:\"\";s:23:\"page_subtitle_fontstyle\";s:0:\"\";s:24:\"page_subtitle_fontweight\";s:0:\"\";s:14:\"header_in_grid\";s:3:\"yes\";s:15:\"header_top_area\";s:3:\"yes\";s:14:\"menu_in_center\";s:2:\"no\";s:23:\"header_background_color\";s:0:\"\";s:30:\"header_background_color_scroll\";s:0:\"\";s:38:\"header_background_transparency_initial\";s:0:\"\";s:37:\"header_background_transparency_scroll\";s:0:\"\";s:10:\"logo_image\";s:60:\"http://william-chang.com/wp-content/uploads/2013/10/logo.png\";s:13:\"header_height\";s:0:\"\";s:20:\"header_height_scroll\";s:0:\"\";s:25:\"dropdown_background_color\";s:0:\"\";s:24:\"dropdown_separator_color\";s:0:\"\";s:10:\"menu_color\";s:0:\"\";s:15:\"menu_hovercolor\";s:0:\"\";s:17:\"menu_google_fonts\";s:2:\"-1\";s:13:\"menu_fontsize\";s:0:\"\";s:15:\"menu_lineheight\";s:0:\"\";s:14:\"menu_fontstyle\";s:0:\"\";s:15:\"menu_fontweight\";s:0:\"\";s:14:\"dropdown_color\";s:0:\"\";s:19:\"dropdown_hovercolor\";s:0:\"\";s:21:\"dropdown_google_fonts\";s:2:\"-1\";s:17:\"dropdown_fontsize\";s:0:\"\";s:19:\"dropdown_lineheight\";s:0:\"\";s:18:\"dropdown_fontstyle\";s:0:\"\";s:19:\"dropdown_fontweight\";s:0:\"\";s:23:\"dropdown_color_thirdlvl\";s:0:\"\";s:28:\"dropdown_hovercolor_thirdlvl\";s:0:\"\";s:30:\"dropdown_google_fonts_thirdlvl\";s:2:\"-1\";s:26:\"dropdown_fontsize_thirdlvl\";s:0:\"\";s:28:\"dropdown_lineheight_thirdlvl\";s:0:\"\";s:27:\"dropdown_fontstyle_thirdlvl\";s:0:\"\";s:28:\"dropdown_fontweight_thirdlvl\";s:0:\"\";s:12:\"mobile_color\";s:0:\"\";s:17:\"mobile_hovercolor\";s:0:\"\";s:19:\"mobile_google_fonts\";s:2:\"-1\";s:15:\"mobile_fontsize\";s:0:\"\";s:17:\"mobile_lineheight\";s:0:\"\";s:16:\"mobile_fontstyle\";s:0:\"\";s:17:\"mobile_fontweight\";s:0:\"\";s:22:\"mobile_separator_color\";s:0:\"\";s:22:\"title_background_color\";s:0:\"\";s:22:\"responsive_title_image\";s:2:\"no\";s:11:\"title_image\";s:0:\"\";s:17:\"fixed_title_image\";s:2:\"no\";s:12:\"title_height\";s:0:\"\";s:19:\"page_title_position\";s:1:\"0\";s:15:\"show_footer_top\";s:3:\"yes\";s:11:\"footer_text\";s:3:\"yes\";s:22:\"footer_top_title_color\";s:0:\"\";s:21:\"footer_top_text_color\";s:0:\"\";s:27:\"footer_top_background_color\";s:0:\"\";s:24:\"footer_bottom_text_color\";s:0:\"\";s:30:\"footer_bottom_background_color\";s:0:\"\";s:29:\"header_footer_separator_color\";s:0:\"\";s:15:\"separator_color\";s:0:\"\";s:19:\"separator_thickness\";s:0:\"\";s:19:\"separator_topmargin\";s:0:\"\";s:22:\"separator_bottommargin\";s:0:\"\";s:18:\"button_title_color\";s:0:\"\";s:23:\"button_title_hovercolor\";s:0:\"\";s:25:\"button_title_google_fonts\";s:2:\"-1\";s:21:\"button_title_fontsize\";s:0:\"\";s:23:\"button_title_lineheight\";s:0:\"\";s:22:\"button_title_fontstyle\";s:0:\"\";s:23:\"button_title_fontweight\";s:0:\"\";s:22:\"button_backgroundcolor\";s:0:\"\";s:19:\"message_title_color\";s:0:\"\";s:26:\"message_title_google_fonts\";s:2:\"-1\";s:22:\"message_title_fontsize\";s:0:\"\";s:24:\"message_title_lineheight\";s:0:\"\";s:23:\"message_title_fontstyle\";s:0:\"\";s:24:\"message_title_fontweight\";s:0:\"\";s:23:\"message_backgroundcolor\";s:0:\"\";s:19:\"message_bordercolor\";s:0:\"\";s:21:\"blockquote_font_color\";s:0:\"\";s:23:\"smooth_background_color\";s:0:\"\";s:16:\"smooth_bar_color\";s:0:\"\";s:16:\"enable_side_area\";s:2:\"no\";s:15:\"side_area_title\";s:0:\"\";s:26:\"side_area_background_color\";s:0:\"\";s:20:\"side_area_text_color\";s:0:\"\";s:14:\"parallax_speed\";s:1:\"1\";s:14:\"parallax_onoff\";s:2:\"on\";s:18:\"parallax_minheight\";s:3:\"400\";s:15:\"portfolio_style\";s:1:\"1\";s:23:\"lightbox_single_project\";s:2:\"no\";s:24:\"portfolio_columns_number\";s:1:\"2\";s:10:\"pagination\";s:1:\"1\";s:10:\"blog_style\";s:1:\"1\";s:21:\"category_blog_sidebar\";s:7:\"default\";s:18:\"blog_hide_comments\";s:2:\"no\";s:15:\"blog_page_range\";s:0:\"\";s:15:\"number_of_chars\";i:45;s:19:\"blog_single_sidebar\";s:7:\"default\";s:34:\"blog_single_sidebar_custom_display\";s:0:\"\";s:12:\"receive_mail\";s:0:\"\";s:19:\"enable_contact_form\";s:3:\"yes\";s:25:\"hide_contact_form_website\";s:3:\"yes\";s:10:\"email_from\";s:0:\"\";s:13:\"email_subject\";s:0:\"\";s:13:\"use_recaptcha\";s:2:\"no\";s:20:\"recaptcha_public_key\";s:0:\"\";s:21:\"recaptcha_private_key\";s:0:\"\";s:21:\"contact_heading_above\";s:0:\"\";s:17:\"enable_google_map\";s:3:\"yes\";s:21:\"google_maps_pin_image\";s:63:\"http://william-chang.com/wp-content/uploads/2013/10/pin-new.png\";s:19:\"google_maps_address\";s:58:\"William Chang Photography, 187 Avenue T, Brooklyn NY 11223\";s:20:\"google_maps_address2\";s:0:\"\";s:20:\"google_maps_address3\";s:0:\"\";s:20:\"google_maps_address4\";s:0:\"\";s:20:\"google_maps_address5\";s:0:\"\";s:16:\"google_maps_zoom\";s:0:\"\";s:18:\"google_maps_height\";s:3:\"300\";s:17:\"google_maps_style\";s:2:\"no\";s:17:\"google_maps_color\";s:0:\"\";s:24:\"google_maps_scroll_wheel\";s:2:\"no\";s:9:\"404_title\";s:0:\"\";s:12:\"404_subtitle\";s:0:\"\";s:8:\"404_text\";s:0:\"\";s:13:\"404_backlabel\";s:0:\"\";s:19:\"enable_social_share\";s:3:\"yes\";s:21:\"enable_facebook_share\";s:3:\"yes\";s:13:\"facebook_icon\";s:0:\"\";s:20:\"enable_twitter_share\";s:3:\"yes\";s:12:\"twitter_icon\";s:0:\"\";s:11:\"twitter_via\";s:0:\"\";s:18:\"enable_google_plus\";s:3:\"yes\";s:16:\"google_plus_icon\";s:0:\"\";s:21:\"post_types_names_post\";s:4:\"post\";s:21:\"post_types_names_page\";s:4:\"page\";}","yes");
INSERT INTO `wp_options` VALUES("254","category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("992339","portfolio_category_children","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("164","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("9342","db_upgraded","","yes");
INSERT INTO `wp_options` VALUES("3094","vfb-settings","a:6:{s:15:\"always-load-css\";s:1:\"1\";s:11:\"spam-points\";s:1:\"4\";s:15:\"max-upload-size\";s:2:\"25\";s:18:\"sender-mail-header\";s:33:\"wordpress@test2.william-chang.com\";s:20:\"recaptcha-public-key\";s:0:\"\";s:21:\"recaptcha-private-key\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("2525","vfb_pro_db_version","2.6","yes");
INSERT INTO `wp_options` VALUES("2527","vfb_dashboard_widget_options","a:1:{s:28:\"vfb_dashboard_recent_entries\";a:1:{s:5:\"items\";i:5;}}","yes");
INSERT INTO `wp_options` VALUES("2529","vfb_ignore_notice","1","yes");
INSERT INTO `wp_options` VALUES("5045","widget_rc_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("5263","jpibfi_visual_options","a:13:{s:18:\"transparency_value\";s:3:\"0.5\";s:18:\"description_option\";s:1:\"1\";s:16:\"use_custom_image\";s:1:\"0\";s:16:\"custom_image_url\";s:0:\"\";s:19:\"custom_image_height\";s:1:\"0\";s:18:\"custom_image_width\";s:1:\"0\";s:12:\"use_post_url\";s:1:\"0\";s:15:\"button_position\";s:1:\"0\";s:17:\"button_margin_top\";s:2:\"20\";s:19:\"button_margin_right\";s:2:\"20\";s:20:\"button_margin_bottom\";s:2:\"20\";s:18:\"button_margin_left\";s:2:\"20\";s:15:\"retina_friendly\";s:1:\"0\";}","yes");
INSERT INTO `wp_options` VALUES("5264","jpibfi_selection_options","a:10:{s:14:\"image_selector\";s:24:\"div.jpibfi_container img\";s:16:\"disabled_classes\";s:15:\"nopin;wp-smiley\";s:15:\"enabled_classes\";s:0:\"\";s:16:\"min_image_height\";s:3:\"300\";s:15:\"min_image_width\";s:3:\"300\";s:12:\"show_on_home\";s:1:\"1\";s:14:\"show_on_single\";s:1:\"1\";s:12:\"show_on_page\";s:1:\"1\";s:16:\"show_on_category\";s:1:\"1\";s:12:\"show_on_blog\";s:1:\"1\";}","yes");
INSERT INTO `wp_options` VALUES("5265","jpibfi_advanced_options","a:2:{s:5:\"debug\";s:1:\"0\";s:18:\"container_selector\";s:3:\"div\";}","yes");
INSERT INTO `wp_options` VALUES("5266","jpibfi_version","1.38","yes");
INSERT INTO `wp_options` VALUES("12958","limit_login_allowed_retries","3","yes");
INSERT INTO `wp_options` VALUES("12959","limit_login_lockout_duration","1800","yes");
INSERT INTO `wp_options` VALUES("12960","limit_login_allowed_lockouts","4","yes");
INSERT INTO `wp_options` VALUES("12961","limit_login_long_duration","86400","yes");
INSERT INTO `wp_options` VALUES("12962","limit_login_valid_duration","43200","yes");
INSERT INTO `wp_options` VALUES("9375","_transient_random_seed","88c43cd24c3f05e884360fee6c741ac0","yes");
INSERT INTO `wp_options` VALUES("12957","limit_login_client_type","REMOTE_ADDR","yes");
INSERT INTO `wp_options` VALUES("6963","wpseo","a:20:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:1;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"2.3.5\";s:11:\"alexaverify\";s:27:\"PXezZMAgeM2bvu8E2gglGd1Nqg4\";s:12:\"company_logo\";s:74:\"http://william-chang.com/wp-content/uploads/2015/04/william-chang-logo.png\";s:12:\"company_name\";s:25:\"William Chang Photography\";s:17:\"company_or_person\";s:7:\"company\";s:20:\"disableadvanced_meta\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("6964","wpseo_titles","a:71:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:1;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:1;s:6:\"noydir\";b:1;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page Not Found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:1;s:20:\"noindex-author-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:1;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:1;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:0;s:20:\"title-portfolio_page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-portfolio_page\";s:0:\"\";s:22:\"metakey-portfolio_page\";s:0:\"\";s:22:\"noindex-portfolio_page\";b:0;s:23:\"showdate-portfolio_page\";b:0;s:26:\"hideeditbox-portfolio_page\";b:0;s:30:\"title-ptarchive-portfolio_page\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:33:\"metadesc-ptarchive-portfolio_page\";s:0:\"\";s:32:\"metakey-ptarchive-portfolio_page\";s:0:\"\";s:32:\"bctitle-ptarchive-portfolio_page\";s:0:\"\";s:32:\"noindex-ptarchive-portfolio_page\";b:0;s:28:\"title-tax-portfolio_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-portfolio_category\";s:0:\"\";s:30:\"metakey-tax-portfolio_category\";s:0:\"\";s:34:\"hideeditbox-tax-portfolio_category\";b:0;s:30:\"noindex-tax-portfolio_category\";b:0;s:19:\"noindex-post_format\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("6967","wpseo_xml","a:11:{s:22:\"disable_author_sitemap\";b:0;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"xml_ping_yahoo\";b:0;s:12:\"xml_ping_ask\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("6968","wpseo_social","a:14:{s:9:\"fb_admins\";a:1:{i:1025471635;a:2:{s:4:\"name\";s:13:\"William Chang\";s:4:\"link\";s:36:\"https://www.facebook.com/nycweddings\";}}s:6:\"fbapps\";a:0:{}s:12:\"fbconnectkey\";s:32:\"550c22ac41ae402097cc852d6d7b14ce\";s:13:\"facebook_site\";s:48:\"https://www.facebook.com/williamchangphotography\";s:16:\"og_default_image\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:14:\"plus-publisher\";s:49:\"https://plus.google.com/+WilliamChangphotography/\";s:7:\"twitter\";b:0;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:10:\"fbadminapp\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("6969","wpseo_rss","a:1:{s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}","yes");
INSERT INTO `wp_options` VALUES("6970","wpseo_permalinks","a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:1;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("209193","_wp_session_6df32a70b2caa0d0eed439ec33f850aa","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6b9ed04028fb80b2e30f5fb663678880\";}\";}","no");
INSERT INTO `wp_options` VALUES("395608","itsec_ssl","a:3:{s:8:\"frontend\";i:0;s:5:\"login\";b:0;s:5:\"admin\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("395610","itsec_strong_passwords","a:2:{s:7:\"enabled\";b:1;s:4:\"roll\";s:13:\"administrator\";}","yes");
INSERT INTO `wp_options` VALUES("395611","itsec_tweaks","a:22:{s:13:\"protect_files\";b:1;s:24:\"suspicious_query_strings\";b:1;s:13:\"generator_tag\";b:1;s:18:\"wlwmanifest_header\";b:1;s:12:\"comment_spam\";b:1;s:14:\"disable_xmlrpc\";i:1;s:12:\"login_errors\";b:1;s:21:\"force_unique_nicename\";b:1;s:27:\"disable_unused_author_pages\";b:1;s:18:\"directory_browsing\";b:0;s:15:\"request_methods\";b:0;s:22:\"non_english_characters\";b:0;s:16:\"long_url_strings\";b:0;s:17:\"write_permissions\";b:0;s:14:\"edituri_header\";b:0;s:13:\"theme_updates\";b:0;s:14:\"plugin_updates\";b:0;s:12:\"core_updates\";b:0;s:14:\"random_version\";b:0;s:11:\"file_editor\";b:0;s:11:\"uploads_php\";b:0;s:11:\"safe_jquery\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("209761","_wp_session_e16f3fea9e47eb27fd3308e7fca7bbf3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e2c5327ef1ad01b2652a482260949841\";}\";}","no");
INSERT INTO `wp_options` VALUES("209619","_wp_session_expires_3b6d4f97e22299f4e4a511876f9d4399","2788059094","no");
INSERT INTO `wp_options` VALUES("209631","_wp_session_197a0ca2937b54d7a7990173d03706a5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"85509152655f7616a21bc5f240b8b696\";}\";}","no");
INSERT INTO `wp_options` VALUES("209618","_wp_session_3b6d4f97e22299f4e4a511876f9d4399","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3cbc35c063930242a5580b1db7d1ca97\";}\";}","no");
INSERT INTO `wp_options` VALUES("209699","_wp_session_3dfbec5d5d13850fc005d0b25f8f4204","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3d07c522f1735bc2b297d2b61ddcce54\";}\";}","no");
INSERT INTO `wp_options` VALUES("208519","_wp_session_expires_1e1a42245f0f8e992a4284fb17cf9ada","2787924490","no");
INSERT INTO `wp_options` VALUES("208871","_wp_session_5e71123c2b7a1b683765e2aec7956c5f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"570cb880029b377ddaaf5325b848556f\";}\";}","no");
INSERT INTO `wp_options` VALUES("214699","_wp_session_expires_5e71123c2b7a1b683765e2aec7956c5f","2788672476","no");
INSERT INTO `wp_options` VALUES("208913","_wp_session_6829c9a001d083340ed61778e8e631d9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"55b57afab9343c6fc8f808f43a353f4d\";}\";}","no");
INSERT INTO `wp_options` VALUES("212668","_wp_session_expires_6829c9a001d083340ed61778e8e631d9","2788454422","no");
INSERT INTO `wp_options` VALUES("208996","_wp_session_567f1f69db6ebf471b384516588b490d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"059f9f482c03c840f1748e3728eed028\";}\";}","no");
INSERT INTO `wp_options` VALUES("208997","_wp_session_expires_567f1f69db6ebf471b384516588b490d","2787976898","no");
INSERT INTO `wp_options` VALUES("395602","itsec_ban_users","a:4:{s:9:\"host_list\";a:5:{i:0;s:10:\"88.3.73.60\";i:1;s:15:\"151.238.212.166\";i:2;s:12:\"157.55.39.68\";i:3;s:13:\"157.55.39.242\";i:4;s:12:\"93.179.69.55\";}s:10:\"agent_list\";a:1:{i:0;s:0:\"\";}s:7:\"enabled\";b:0;s:7:\"default\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("395649","itsec_jquery_version","1.11.3","yes");
INSERT INTO `wp_options` VALUES("395604","itsec_brute_force","a:4:{s:7:\"enabled\";b:1;s:17:\"max_attempts_host\";i:5;s:17:\"max_attempts_user\";i:10;s:12:\"check_period\";i:5;}","yes");
INSERT INTO `wp_options` VALUES("46481","wordpress_api_key","44303fabe48b","yes");
INSERT INTO `wp_options` VALUES("46482","akismet_discard_month","false","yes");
INSERT INTO `wp_options` VALUES("46483","akismet_show_user_comments_approved","false","yes");
INSERT INTO `wp_options` VALUES("46484","akismet_available_servers","a:4:{s:12:\"66.135.58.62\";b:1;s:12:\"192.0.80.244\";b:1;s:12:\"66.135.58.61\";b:1;s:12:\"192.0.80.246\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("46485","akismet_connectivity_time","1386979513","yes");
INSERT INTO `wp_options` VALUES("209591","_wp_session_4002f9ee74739dd13d15eae12105f20a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8780d52502e394d749bd8ceb22972cad\";}\";}","no");
INSERT INTO `wp_options` VALUES("209267","_wp_session_expires_1737228638ff80524ac00ec3d0349893","2788003174","no");
INSERT INTO `wp_options` VALUES("209412","_wp_session_expires_b746ac8509e119a459683e06ac1813af","2788026244","no");
INSERT INTO `wp_options` VALUES("209447","_wp_session_9e1528c18375d000ca5679f33bf105b4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d95825850903af8670b844c091c87550\";}\";}","no");
INSERT INTO `wp_options` VALUES("209448","_wp_session_expires_9e1528c18375d000ca5679f33bf105b4","2788032734","no");
INSERT INTO `wp_options` VALUES("208242","_wp_session_d6c3935bbe0ceecb6968a79213481c10","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b25c3e74405d68fa5a67f08426ab048e\";}\";}","no");
INSERT INTO `wp_options` VALUES("208243","_wp_session_expires_d6c3935bbe0ceecb6968a79213481c10","2787881716","no");
INSERT INTO `wp_options` VALUES("208304","_wp_session_a0de1dcf2865ac8a831a8d4ebf3ef091","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4902496aa90fb63facd1e04b8d56de56\";}\";}","no");
INSERT INTO `wp_options` VALUES("208305","_wp_session_expires_a0de1dcf2865ac8a831a8d4ebf3ef091","2787893352","no");
INSERT INTO `wp_options` VALUES("208307","_wp_session_c0c9bce072ef3d2c94d146a56c0fd7bf","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cf7531671e9ac8fd7e46f0138918fccb\";}\";}","no");
INSERT INTO `wp_options` VALUES("395607","itsec_hide_backend","a:7:{s:7:\"enabled\";b:1;s:4:\"slug\";s:7:\"william\";s:12:\"theme_compat\";b:1;s:17:\"theme_compat_slug\";s:9:\"not_found\";s:16:\"post_logout_slug\";s:0:\"\";s:12:\"show-tooltip\";b:0;s:8:\"register\";s:15:\"wp-register.php\";}","yes");
INSERT INTO `wp_options` VALUES("208308","_wp_session_expires_c0c9bce072ef3d2c94d146a56c0fd7bf","2787893406","no");
INSERT INTO `wp_options` VALUES("208312","_wp_session_08e3d8eef8cfba697c879037c55bc734","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4d8ff170f30ed66f571608ca80d5f50e\";}\";}","no");
INSERT INTO `wp_options` VALUES("208313","_wp_session_expires_08e3d8eef8cfba697c879037c55bc734","2787894564","no");
INSERT INTO `wp_options` VALUES("395600","itsec_four_oh_four","a:5:{s:7:\"enabled\";b:1;s:12:\"check_period\";i:5;s:15:\"error_threshold\";i:20;s:10:\"white_list\";a:9:{i:0;s:12:\"/favicon.ico\";i:1;s:11:\"/robots.txt\";i:2;s:21:\"/apple-touch-icon.png\";i:3;s:33:\"/apple-touch-icon-precomposed.png\";i:4;s:17:\"/wp-content/cache\";i:5;s:18:\"/browserconfig.xml\";i:6;s:16:\"/crossdomain.xml\";i:7;s:11:\"/labels.rdf\";i:8;s:27:\"/trafficbasedsspsitemap.xml\";}s:5:\"types\";a:5:{i:0;s:4:\".jpg\";i:1;s:5:\".jpeg\";i:2;s:4:\".png\";i:3;s:4:\".gif\";i:4;s:4:\".css\";}}","yes");
INSERT INTO `wp_options` VALUES("209683","_wp_session_a43c4bb6fefb82b09def18de0d6bb031","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"774c0eae2dba51ceceaaf4d69d5700bd\";}\";}","no");
INSERT INTO `wp_options` VALUES("209680","_wp_session_expires_6c0dd167a0b50432070e26b4c3f0120f","2788069580","no");
INSERT INTO `wp_options` VALUES("209632","_wp_session_expires_197a0ca2937b54d7a7990173d03706a5","2788061682","no");
INSERT INTO `wp_options` VALUES("209637","_wp_session_957970a706b580db59f0a29a091889ef","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e4da64ee47e33a6727eade46970afb78\";}\";}","no");
INSERT INTO `wp_options` VALUES("209638","_wp_session_expires_957970a706b580db59f0a29a091889ef","2788062276","no");
INSERT INTO `wp_options` VALUES("209644","_wp_session_073b6d357ccc53ac1347fc77dea6af70","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7fe69dc07a73eaf27c23340ed5c58ac6\";}\";}","no");
INSERT INTO `wp_options` VALUES("209645","_wp_session_expires_073b6d357ccc53ac1347fc77dea6af70","2788063546","no");
INSERT INTO `wp_options` VALUES("209679","_wp_session_6c0dd167a0b50432070e26b4c3f0120f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"22c7837c1fd68948d8e519d113a60942\";}\";}","no");
INSERT INTO `wp_options` VALUES("208316","_wp_session_8571f16885c5fa7a4492ee72f53917cb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d91d0d438c9f9d9d263ebfe94c6ab8af\";}\";}","no");
INSERT INTO `wp_options` VALUES("241286","wpseo_internallinks","a:10:{s:20:\"breadcrumbs-404crumb\";s:0:\"\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:0:\"\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:0:\"\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:0:\"\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;}","yes");
INSERT INTO `wp_options` VALUES("326396","widget_related_posts_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326397","widget_qode-flickr-widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326391","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326392","widget_nav_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326393","widget_layerslider_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326394","widget_akismet_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326395","widget_vfb_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("218679","_wp_session_expires_e17464bf8a155d2ba5ba93a2d05444a6","2789199296","no");
INSERT INTO `wp_options` VALUES("209009","_wp_session_4dbd38d9e0fa5b91db73d547b1abc7b4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6914d03a105d753afa25a0d2c355cbbe\";}\";}","no");
INSERT INTO `wp_options` VALUES("209010","_wp_session_expires_4dbd38d9e0fa5b91db73d547b1abc7b4","2787979938","no");
INSERT INTO `wp_options` VALUES("209153","_wp_session_e6436c7505ba24fa91f83e95841ce701","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"94a7ee6ea6a92d0aa526f9c2dc2fca99\";}\";}","no");
INSERT INTO `wp_options` VALUES("395601","itsec_away_mode","a:4:{s:7:\"enabled\";b:1;s:4:\"type\";i:1;s:5:\"start\";i:1405645200;s:3:\"end\";i:1405749600;}","yes");
INSERT INTO `wp_options` VALUES("208090","_wp_session_expires_473165e3347c9b6341f9b81c70a2425a","2787846844","no");
INSERT INTO `wp_options` VALUES("208205","_wp_session_ff739866d767b2a8a868cd9942fd0650","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7c4797c933d2720f9716d9ebe308ea11\";}\";}","no");
INSERT INTO `wp_options` VALUES("208206","_wp_session_expires_ff739866d767b2a8a868cd9942fd0650","2787876664","no");
INSERT INTO `wp_options` VALUES("208208","_wp_session_d0d8b2a0eb9f4e29803d76e2084e6d75","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f1f53ea8d7e771616236381ed152e155\";}\";}","no");
INSERT INTO `wp_options` VALUES("208209","_wp_session_expires_d0d8b2a0eb9f4e29803d76e2084e6d75","2787876818","no");
INSERT INTO `wp_options` VALUES("208217","_wp_session_52988ba0c53ba594817f0ffcb53fc621","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f139cdc2d84f5590c5e452d8a00a1fe1\";}\";}","no");
INSERT INTO `wp_options` VALUES("208218","_wp_session_expires_52988ba0c53ba594817f0ffcb53fc621","2787877332","no");
INSERT INTO `wp_options` VALUES("208220","_wp_session_79b4baad3a6f01de1567ab0a81b8674a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"783e445eac92a15e11a6366c4b34ee3b\";}\";}","no");
INSERT INTO `wp_options` VALUES("208221","_wp_session_expires_79b4baad3a6f01de1567ab0a81b8674a","2787877570","no");
INSERT INTO `wp_options` VALUES("208223","_wp_session_7ac53839f698b23afd8a55db79135635","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"16e3f8917cb1964fa98e42de50814261\";}\";}","no");
INSERT INTO `wp_options` VALUES("208224","_wp_session_expires_7ac53839f698b23afd8a55db79135635","2787877574","no");
INSERT INTO `wp_options` VALUES("209768","_wp_session_19664e6479fd21add951c8d0cb49fa09","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5af9c3a9cb5fa09ab8faa1bda665efbd\";}\";}","no");
INSERT INTO `wp_options` VALUES("209769","_wp_session_expires_19664e6479fd21add951c8d0cb49fa09","2788080684","no");
INSERT INTO `wp_options` VALUES("209773","_wp_session_d0c5e3298337171da70f9346202158f6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c88a57ed310e91afdac60f1beb4247c1\";}\";}","no");
INSERT INTO `wp_options` VALUES("209774","_wp_session_expires_d0c5e3298337171da70f9346202158f6","2788081978","no");
INSERT INTO `wp_options` VALUES("209794","_wp_session_6740568e19cffb8543554ddd8f5e1393","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d5fc87d2d56f30d8f6af7826871153c4\";}\";}","no");
INSERT INTO `wp_options` VALUES("209795","_wp_session_expires_6740568e19cffb8543554ddd8f5e1393","2788085460","no");
INSERT INTO `wp_options` VALUES("209830","_wp_session_511ec0736c8148b8e9297d6f490d5a00","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5923a974015e7c4a5c030bb032b51a3e\";}\";}","no");
INSERT INTO `wp_options` VALUES("209831","_wp_session_expires_511ec0736c8148b8e9297d6f490d5a00","2788088516","no");
INSERT INTO `wp_options` VALUES("209892","_wp_session_8d9840ef1757e45ed04d57d3f96a168d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"49837e8cdc9af3dc8019ab86c2454b21\";}\";}","no");
INSERT INTO `wp_options` VALUES("209893","_wp_session_expires_8d9840ef1757e45ed04d57d3f96a168d","2788093370","no");
INSERT INTO `wp_options` VALUES("209900","_wp_session_0a121996220dd4fc2ddf0267a3d6171e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b3a995b641b19835ddc6c116cee06961\";}\";}","no");
INSERT INTO `wp_options` VALUES("209901","_wp_session_expires_0a121996220dd4fc2ddf0267a3d6171e","2788094110","no");
INSERT INTO `wp_options` VALUES("209909","_wp_session_5c82bfd1b6a6ecddf8c65e63f2905ab4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b1401f307c286edeed53a4af553e311b\";}\";}","no");
INSERT INTO `wp_options` VALUES("209910","_wp_session_expires_5c82bfd1b6a6ecddf8c65e63f2905ab4","2788095216","no");
INSERT INTO `wp_options` VALUES("209915","_wp_session_2f0b739f999a3821c368282b551f0b84","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"610fb63b42dd2bcec54038a696098152\";}\";}","no");
INSERT INTO `wp_options` VALUES("209916","_wp_session_expires_2f0b739f999a3821c368282b551f0b84","2788097684","no");
INSERT INTO `wp_options` VALUES("209921","_wp_session_1a76886846437aa57b3b956b9ab75a0f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a4245f9b9af659fe03a0758d5fc322b7\";}\";}","no");
INSERT INTO `wp_options` VALUES("209922","_wp_session_expires_1a76886846437aa57b3b956b9ab75a0f","2788098798","no");
INSERT INTO `wp_options` VALUES("209926","_wp_session_db82d6894e25fadd5409a5c00c5b9651","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f42d771a6217d4eeadb28f35e1c9610a\";}\";}","no");
INSERT INTO `wp_options` VALUES("209927","_wp_session_expires_db82d6894e25fadd5409a5c00c5b9651","2788099202","no");
INSERT INTO `wp_options` VALUES("209974","_wp_session_2924225688a5df19a6079c3d292a89fc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"030e05b70b5e64dc467a12b2ef77c15b\";}\";}","no");
INSERT INTO `wp_options` VALUES("209975","_wp_session_expires_2924225688a5df19a6079c3d292a89fc","2788104234","no");
INSERT INTO `wp_options` VALUES("209982","_wp_session_04ae82230552a0543fd5790f9a9e48e0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"353d3b4bee52d7dae08dd5981c96535f\";}\";}","no");
INSERT INTO `wp_options` VALUES("209983","_wp_session_expires_04ae82230552a0543fd5790f9a9e48e0","2788105174","no");
INSERT INTO `wp_options` VALUES("209987","_wp_session_114e45de36c28d2a5c44c2cf8345c116","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b5a46f4d5a428a165d28c19496708aae\";}\";}","no");
INSERT INTO `wp_options` VALUES("209988","_wp_session_expires_114e45de36c28d2a5c44c2cf8345c116","2788105340","no");
INSERT INTO `wp_options` VALUES("209993","_wp_session_b0341dc1a5fbeac64aa5575d6654a3d3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9758823b4fc8c4284066f2d41ca381ec\";}\";}","no");
INSERT INTO `wp_options` VALUES("209994","_wp_session_expires_b0341dc1a5fbeac64aa5575d6654a3d3","2788106412","no");
INSERT INTO `wp_options` VALUES("210022","_wp_session_0c9ed52bb4bcfdd06e62902dc09f45f0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0be874a21f11bcd01dc125ac1d33c678\";}\";}","no");
INSERT INTO `wp_options` VALUES("210023","_wp_session_expires_0c9ed52bb4bcfdd06e62902dc09f45f0","2788111158","no");
INSERT INTO `wp_options` VALUES("223614","_wp_session_expires_03fc5167f6e3ff18af02baf00d33f76f","2789834220","no");
INSERT INTO `wp_options` VALUES("210077","_wp_session_57d9c4acbba77e4862320e62b2584b1d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4a9b1e03dade964d250e476165a2f553\";}\";}","no");
INSERT INTO `wp_options` VALUES("210078","_wp_session_expires_57d9c4acbba77e4862320e62b2584b1d","2788113616","no");
INSERT INTO `wp_options` VALUES("210083","_wp_session_f16c85c84d27cb06e0dd102de91dcebd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"801d241ba156cbc31948a680a529d550\";}\";}","no");
INSERT INTO `wp_options` VALUES("210084","_wp_session_expires_f16c85c84d27cb06e0dd102de91dcebd","2788114826","no");
INSERT INTO `wp_options` VALUES("210108","_wp_session_c23967d46dad74aa9829fe17ceea7499","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4c7c9cba4ad66ae3e81522d7770f7115\";}\";}","no");
INSERT INTO `wp_options` VALUES("210109","_wp_session_expires_c23967d46dad74aa9829fe17ceea7499","2788117146","no");
INSERT INTO `wp_options` VALUES("210148","_wp_session_1fe523b43d59a4e3622ba168cd889a73","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"01690ba96769fe0422ce413945f8211b\";}\";}","no");
INSERT INTO `wp_options` VALUES("210149","_wp_session_expires_1fe523b43d59a4e3622ba168cd889a73","2788123640","no");
INSERT INTO `wp_options` VALUES("210474","_wp_session_expires_9a3ef2fdb762edd23e4a673b0ec1ddb7","2788160258","no");
INSERT INTO `wp_options` VALUES("210792","_wp_session_a1d1887c61debb0a347c9f0a999a2053","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ff1f57569389fd174186fe936aa1af11\";}\";}","no");
INSERT INTO `wp_options` VALUES("210793","_wp_session_expires_a1d1887c61debb0a347c9f0a999a2053","2788225432","no");
INSERT INTO `wp_options` VALUES("210821","_wp_session_927ac1358d472591cdf8538a510644a9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9dc267a67f4c2521120106cf8cc7a4d0\";}\";}","no");
INSERT INTO `wp_options` VALUES("210822","_wp_session_expires_927ac1358d472591cdf8538a510644a9","2788231814","no");
INSERT INTO `wp_options` VALUES("210849","_wp_session_285c429f053cc6a1712688ace2387d16","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"73f2c18c0d33e808535caa4bba35b2c3\";}\";}","no");
INSERT INTO `wp_options` VALUES("210850","_wp_session_expires_285c429f053cc6a1712688ace2387d16","2788236106","no");
INSERT INTO `wp_options` VALUES("210852","_wp_session_ca2f38e3d15a333b993f7d6fbdd8c33c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e3845f427cfd17ae1667d19c90d633c0\";}\";}","no");
INSERT INTO `wp_options` VALUES("210853","_wp_session_expires_ca2f38e3d15a333b993f7d6fbdd8c33c","2788236696","no");
INSERT INTO `wp_options` VALUES("210855","_wp_session_2f92976be03d869a26968357429074a5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f1382e401577248c7faa58e336f365f8\";}\";}","no");
INSERT INTO `wp_options` VALUES("210856","_wp_session_expires_2f92976be03d869a26968357429074a5","2788236744","no");
INSERT INTO `wp_options` VALUES("210864","_wp_session_2138637f22590486057aa2d1a93f2bae","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"375045ce17e47016ec7fd7f4f6c84a08\";}\";}","no");
INSERT INTO `wp_options` VALUES("210865","_wp_session_expires_2138637f22590486057aa2d1a93f2bae","2788237528","no");
INSERT INTO `wp_options` VALUES("210900","_wp_session_2e06f152c4c05a8e617b30d0ac1486ad","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7528fe084edb9cc16d45130cc7b7214c\";}\";}","no");
INSERT INTO `wp_options` VALUES("210901","_wp_session_expires_2e06f152c4c05a8e617b30d0ac1486ad","2788242210","no");
INSERT INTO `wp_options` VALUES("210945","_wp_session_f17de7b5d78fc28b210e00736a51f26f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c9a85bc0620f0014797a513def88bef9\";}\";}","no");
INSERT INTO `wp_options` VALUES("210946","_wp_session_expires_f17de7b5d78fc28b210e00736a51f26f","2788250152","no");
INSERT INTO `wp_options` VALUES("220917","_wp_session_83ce30d89719b465b3c33f544685f62c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"00b0245ab7dcbb5e6c66ec1bb1993dd3\";}\";}","no");
INSERT INTO `wp_options` VALUES("221967","_wp_session_expires_be6dbe10972a4c4a2a38a2146e3e274a","2789607272","no");
INSERT INTO `wp_options` VALUES("221997","_wp_session_9827684ffb3c5df46b4b9e1cd111d2df","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"29dded059e475f9be5a4dca90d8e17af\";}\";}","no");
INSERT INTO `wp_options` VALUES("220918","_wp_session_expires_83ce30d89719b465b3c33f544685f62c","2789444856","no");
INSERT INTO `wp_options` VALUES("220920","_wp_session_1a36fbafc1e9f1c3ea4c9755b1891630","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"abdcb22526fda45fe7f0fc4c4970616c\";}\";}","no");
INSERT INTO `wp_options` VALUES("220921","_wp_session_expires_1a36fbafc1e9f1c3ea4c9755b1891630","2789444998","no");
INSERT INTO `wp_options` VALUES("220946","_wp_session_86309f86c08c16a031dcd4bca3e411ee","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"60c12e3ecd066a046ee13dde880a1466\";}\";}","no");
INSERT INTO `wp_options` VALUES("211022","_wp_session_e7a8c3b461b21c1688f347ed208a7718","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2303cc6a28327fe6a6c18b660a5d9623\";}\";}","no");
INSERT INTO `wp_options` VALUES("211023","_wp_session_expires_e7a8c3b461b21c1688f347ed208a7718","2788276962","no");
INSERT INTO `wp_options` VALUES("222018","_wp_session_expires_bda020c6ec03beacc21e32dc5acd459c","2789615246","no");
INSERT INTO `wp_options` VALUES("224273","_wp_session_expires_3c774275317bc2f2b505bb4b72bf05cf","2789914400","no");
INSERT INTO `wp_options` VALUES("224276","_wp_session_expires_2520691d4c6f3c0466052a8d8cfc8af9","2789914400","no");
INSERT INTO `wp_options` VALUES("224480","_wp_session_2f515c5e0b823c3449b2422f018e5506","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ade531fbdc66aee827772dde8fd68fd3\";}\";}","no");
INSERT INTO `wp_options` VALUES("222317","_wp_session_e6e186b9193eef858a77c5b6e18be760","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"970a3e04a13b5aa35627369bf27160e2\";}\";}","no");
INSERT INTO `wp_options` VALUES("222318","_wp_session_expires_e6e186b9193eef858a77c5b6e18be760","2789648952","no");
INSERT INTO `wp_options` VALUES("222324","_wp_session_4ba998e10152ed1de10f20cf45db5de6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c5a8ce3046647db315cc6fc93bfd6d8b\";}\";}","no");
INSERT INTO `wp_options` VALUES("221596","_wp_session_cc672da63fcd538f812da112e30840f1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"be95283272c5ccc874fdb46bdc789c3d\";}\";}","no");
INSERT INTO `wp_options` VALUES("221493","_wp_session_expires_439b133c41206bff68a718f9052ef9f2","2789527588","no");
INSERT INTO `wp_options` VALUES("211064","_wp_session_b4a2afd8d10d3d2d773a793e6e4a3555","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"92d9087a87249e4c4c03001a6c021d0b\";}\";}","no");
INSERT INTO `wp_options` VALUES("211065","_wp_session_expires_b4a2afd8d10d3d2d773a793e6e4a3555","2788281162","no");
INSERT INTO `wp_options` VALUES("221492","_wp_session_439b133c41206bff68a718f9052ef9f2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c72410aa836636d9b5720b6bc764e856\";}\";}","no");
INSERT INTO `wp_options` VALUES("221391","_wp_session_expires_77e252d4a51c262b8f1d1df7e47acbfd","2789508628","no");
INSERT INTO `wp_options` VALUES("211085","_wp_session_ce886371012b9c8b9ba2cbfe461b3157","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"055d67983776cc5666ad53867136e371\";}\";}","no");
INSERT INTO `wp_options` VALUES("211086","_wp_session_expires_ce886371012b9c8b9ba2cbfe461b3157","2788283702","no");
INSERT INTO `wp_options` VALUES("221390","_wp_session_77e252d4a51c262b8f1d1df7e47acbfd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"90cb24fee5f30465a844f9b9e5dcfb95\";}\";}","no");
INSERT INTO `wp_options` VALUES("221374","_wp_session_expires_1ff765ee8abccd3bad70b8c45d682363","2789506324","no");
INSERT INTO `wp_options` VALUES("221373","_wp_session_1ff765ee8abccd3bad70b8c45d682363","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2f8f84494c630afc6cb302b75a269d6e\";}\";}","no");
INSERT INTO `wp_options` VALUES("211096","_wp_session_f69cf3555c138b6372b6c21eac5059ca","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"be873d74dc1042387cb69490abd83f65\";}\";}","no");
INSERT INTO `wp_options` VALUES("211097","_wp_session_expires_f69cf3555c138b6372b6c21eac5059ca","2788285152","no");
INSERT INTO `wp_options` VALUES("222017","_wp_session_bda020c6ec03beacc21e32dc5acd459c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a6eed8d9b6d189c98a99ab60c7c1b65e\";}\";}","no");
INSERT INTO `wp_options` VALUES("221332","_wp_session_expires_06cb222632e491355ec872e834e8c150","2789500334","no");
INSERT INTO `wp_options` VALUES("221331","_wp_session_06cb222632e491355ec872e834e8c150","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0cdccfecb190afff1032544b292f9bbe\";}\";}","no");
INSERT INTO `wp_options` VALUES("211140","_wp_session_ec89f5ff06413e7d3e0fa977482f3a45","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"57b9a94ad2524a71fd4cee16c4fb1701\";}\";}","no");
INSERT INTO `wp_options` VALUES("211141","_wp_session_expires_ec89f5ff06413e7d3e0fa977482f3a45","2788287058","no");
INSERT INTO `wp_options` VALUES("221303","_wp_session_expires_f654dff665732b7dd4a1308547119986","2789496204","no");
INSERT INTO `wp_options` VALUES("211153","_wp_session_f113374f7b04b32e798663d6e2610c4b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2eec6b898749bfaaad7f9d2fe5dcc1d3\";}\";}","no");
INSERT INTO `wp_options` VALUES("211154","_wp_session_expires_f113374f7b04b32e798663d6e2610c4b","2788288182","no");
INSERT INTO `wp_options` VALUES("221302","_wp_session_f654dff665732b7dd4a1308547119986","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fab9b370af63a25b8407aa812a212190\";}\";}","no");
INSERT INTO `wp_options` VALUES("211157","_wp_session_a051e2069ae6a0194f0943b0492096c4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c97a983c94c8f13e20aaf3312df0cd30\";}\";}","no");
INSERT INTO `wp_options` VALUES("211158","_wp_session_expires_a051e2069ae6a0194f0943b0492096c4","2788288294","no");
INSERT INTO `wp_options` VALUES("221290","_wp_session_expires_c16b31185d38610bf8249fe054ae61a9","2789494224","no");
INSERT INTO `wp_options` VALUES("221289","_wp_session_c16b31185d38610bf8249fe054ae61a9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1f465f8adb6310ff812421d18164e9d1\";}\";}","no");
INSERT INTO `wp_options` VALUES("221278","_wp_session_expires_555a9c743504d930acffeab0ef43e55e","2789492504","no");
INSERT INTO `wp_options` VALUES("221277","_wp_session_555a9c743504d930acffeab0ef43e55e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0f4526149e43a5bddff0774019ef1777\";}\";}","no");
INSERT INTO `wp_options` VALUES("221238","_wp_session_expires_6e4e397f4ac7cffc1f5c8264e8961ce6","2789489226","no");
INSERT INTO `wp_options` VALUES("221237","_wp_session_6e4e397f4ac7cffc1f5c8264e8961ce6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b69e8f189f3e80a30939fee5c07a5b12\";}\";}","no");
INSERT INTO `wp_options` VALUES("221188","_wp_session_expires_b0ece0774b7237e3fc3621ba800cc68c","2789481920","no");
INSERT INTO `wp_options` VALUES("221161","_wp_session_expires_b78ead5d255b529666184592eea4c8e9","2789477036","no");
INSERT INTO `wp_options` VALUES("221187","_wp_session_b0ece0774b7237e3fc3621ba800cc68c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ef2527a51b6c0428bfa8e995a49dc910\";}\";}","no");
INSERT INTO `wp_options` VALUES("221160","_wp_session_b78ead5d255b529666184592eea4c8e9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"317b23dbbd05f8c49c256a8ce6c37c4a\";}\";}","no");
INSERT INTO `wp_options` VALUES("221154","_wp_session_expires_5a9d352de7d3187e7848b9889b065f72","2789476150","no");
INSERT INTO `wp_options` VALUES("211222","_wp_session_a57e9b511998a02e35ac95bea0b98478","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"88411db088ce475cab6836c41b9875bc\";}\";}","no");
INSERT INTO `wp_options` VALUES("211223","_wp_session_expires_a57e9b511998a02e35ac95bea0b98478","2788295762","no");
INSERT INTO `wp_options` VALUES("221153","_wp_session_5a9d352de7d3187e7848b9889b065f72","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"27fa38678f1979beaa4d28877ab2d15c\";}\";}","no");
INSERT INTO `wp_options` VALUES("221115","_wp_session_expires_8b6576e9f0b574b5ea1740020679caf7","2789470072","no");
INSERT INTO `wp_options` VALUES("221114","_wp_session_8b6576e9f0b574b5ea1740020679caf7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c65fb573267dee29b5197a6a67e60683\";}\";}","no");
INSERT INTO `wp_options` VALUES("221110","_wp_session_expires_00f1e3a6feb5c1968f9f6856cd4dc281","2789469602","no");
INSERT INTO `wp_options` VALUES("211240","_wp_session_ea517a51490156d6675c05a79a015f44","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"34351f6be53c3b0c5a5aed4c2c3b4bdc\";}\";}","no");
INSERT INTO `wp_options` VALUES("211241","_wp_session_expires_ea517a51490156d6675c05a79a015f44","2788298246","no");
INSERT INTO `wp_options` VALUES("221109","_wp_session_00f1e3a6feb5c1968f9f6856cd4dc281","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"54b1d37a74f616a135c45d71132c3518\";}\";}","no");
INSERT INTO `wp_options` VALUES("211250","_wp_session_e8c250089db6b585b67a44e5bc6cb18b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"360e9bf7fdf2ce1ec6aef665b3a0919f\";}\";}","no");
INSERT INTO `wp_options` VALUES("211251","_wp_session_expires_e8c250089db6b585b67a44e5bc6cb18b","2788299532","no");
INSERT INTO `wp_options` VALUES("221966","_wp_session_be6dbe10972a4c4a2a38a2146e3e274a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d19c986d9a4fd6ab16e720141f2170fb\";}\";}","no");
INSERT INTO `wp_options` VALUES("221107","_wp_session_expires_0054be8076d905a97a64f78f7f31bccb","2789469562","no");
INSERT INTO `wp_options` VALUES("211272","_wp_session_7cf7aa8f08267b2b6983203b2894d8b6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9f5be4ba6591cdf5bab3f68205a9975e\";}\";}","no");
INSERT INTO `wp_options` VALUES("211273","_wp_session_expires_7cf7aa8f08267b2b6983203b2894d8b6","2788300744","no");
INSERT INTO `wp_options` VALUES("221106","_wp_session_0054be8076d905a97a64f78f7f31bccb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dc02bf364c89c04f52785d2b28ed0a3c\";}\";}","no");
INSERT INTO `wp_options` VALUES("221104","_wp_session_expires_8626df4bd76a89c7ecf1ec78a98d82a9","2789469546","no");
INSERT INTO `wp_options` VALUES("221103","_wp_session_8626df4bd76a89c7ecf1ec78a98d82a9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e2d96f10fd6048729e8ab4a30ae6f743\";}\";}","no");
INSERT INTO `wp_options` VALUES("221096","_wp_session_expires_bafe1bc03462ffcb2b201652585828a0","2789468758","no");
INSERT INTO `wp_options` VALUES("221095","_wp_session_bafe1bc03462ffcb2b201652585828a0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0e088bf2f87e5d76a378754a02abe00d\";}\";}","no");
INSERT INTO `wp_options` VALUES("221086","_wp_session_expires_cfb1df1a60bcbaaa71bae09970060a58","2789466748","no");
INSERT INTO `wp_options` VALUES("221085","_wp_session_cfb1df1a60bcbaaa71bae09970060a58","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"eff8eb7ccbbaa869513a926fdb7af458\";}\";}","no");
INSERT INTO `wp_options` VALUES("221083","_wp_session_expires_3b9cfea16ff22fa0e4796a668f8c41dc","2789465888","no");
INSERT INTO `wp_options` VALUES("221074","_wp_session_expires_76afe30628f7ce04f5c44ae182447cce","2789465334","no");
INSERT INTO `wp_options` VALUES("221056","_wp_session_8aafcb292b901bfd8e3ef7af26823cc7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"eebff50e49a1c3a41a975541ae41ec3e\";}\";}","no");
INSERT INTO `wp_options` VALUES("221035","_wp_session_expires_161f1078efc89a7fdb2c1c64a99cba41","2789460562","no");
INSERT INTO `wp_options` VALUES("211378","_wp_session_f147b3537c95e9304346786155f6252f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8d19ee84cfa323c65d6e81b7d1d1f7c8\";}\";}","no");
INSERT INTO `wp_options` VALUES("211379","_wp_session_expires_f147b3537c95e9304346786155f6252f","2788309166","no");
INSERT INTO `wp_options` VALUES("221082","_wp_session_3b9cfea16ff22fa0e4796a668f8c41dc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2544d5b9f8ca7a722d93953abb316234\";}\";}","no");
INSERT INTO `wp_options` VALUES("211398","_wp_session_6363ba79f0b06b39800190a6d4b2a8b4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"80ca2c07d7218b4142c3b18f2e7986aa\";}\";}","no");
INSERT INTO `wp_options` VALUES("237817","_wp_session_expires_6363ba79f0b06b39800190a6d4b2a8b4","2791411948","no");
INSERT INTO `wp_options` VALUES("221998","_wp_session_expires_9827684ffb3c5df46b4b9e1cd111d2df","2789613544","no");
INSERT INTO `wp_options` VALUES("221057","_wp_session_expires_8aafcb292b901bfd8e3ef7af26823cc7","2789461700","no");
INSERT INTO `wp_options` VALUES("221073","_wp_session_76afe30628f7ce04f5c44ae182447cce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6ea417f434519510e42e8b95336febdb\";}\";}","no");
INSERT INTO `wp_options` VALUES("220542","_wp_session_expires_0c1cf8dc6db6c7c570f0e10ac498e5ce","2789391738","no");
INSERT INTO `wp_options` VALUES("211448","_wp_session_expires_7ffc1634c8ca0b91e4f6e631597b6834","2788313614","no");
INSERT INTO `wp_options` VALUES("211450","_wp_session_expires_4ff1ed1bc242987cc0cd7ed841588dfd","2788313786","no");
INSERT INTO `wp_options` VALUES("211452","_wp_session_expires_f709a40475e92261e4da05b6d2b366b0","2788313802","no");
INSERT INTO `wp_options` VALUES("211454","_wp_session_expires_23ef7ee8e21ba4a95786298072668b09","2788313810","no");
INSERT INTO `wp_options` VALUES("211456","_wp_session_expires_639995c87ea19859a2c43e43d2b1f844","2788313820","no");
INSERT INTO `wp_options` VALUES("211458","_wp_session_expires_21cca38d933b2044d93c3dda0fe074c1","2788313844","no");
INSERT INTO `wp_options` VALUES("219957","_wp_session_expires_8fab608e1410e896b16869c988ff77d0","2789338848","no");
INSERT INTO `wp_options` VALUES("219956","_wp_session_8fab608e1410e896b16869c988ff77d0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a3e940f6e62b80480fd9a0e025d9fe69\";}\";}","no");
INSERT INTO `wp_options` VALUES("219905","_wp_session_expires_a529f71d52529941e16899e961ddbfd0","2789337382","no");
INSERT INTO `wp_options` VALUES("219904","_wp_session_a529f71d52529941e16899e961ddbfd0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b9c660ed6c2791ad1489d47657868ed5\";}\";}","no");
INSERT INTO `wp_options` VALUES("211489","_wp_session_727b0a052f1d44b8e0c55a2453988de9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"865991ca970b43d7dd352e51ebe3a3ea\";}\";}","no");
INSERT INTO `wp_options` VALUES("211490","_wp_session_expires_727b0a052f1d44b8e0c55a2453988de9","2788317908","no");
INSERT INTO `wp_options` VALUES("219874","_wp_session_expires_031e7e39bdcc18662011934a9214e474","2789335768","no");
INSERT INTO `wp_options` VALUES("219873","_wp_session_031e7e39bdcc18662011934a9214e474","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b7af735022644c1a55257eaf556cc856\";}\";}","no");
INSERT INTO `wp_options` VALUES("211499","_wp_session_08e52b3c075ef5e6f7ca5ef785bdf7ed","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d0c135027bea1d5ce9dbfdea5f2ccb91\";}\";}","no");
INSERT INTO `wp_options` VALUES("211500","_wp_session_expires_08e52b3c075ef5e6f7ca5ef785bdf7ed","2788318788","no");
INSERT INTO `wp_options` VALUES("219858","_wp_session_expires_72003e1594f66bfdd0a2777be08aeba5","2789332130","no");
INSERT INTO `wp_options` VALUES("219840","_wp_session_expires_470a9b7adc1e5a44be671b13d1962dc2","2789331334","no");
INSERT INTO `wp_options` VALUES("219857","_wp_session_72003e1594f66bfdd0a2777be08aeba5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"36b24f3b533bf900d40a4c6feacf4b1b\";}\";}","no");
INSERT INTO `wp_options` VALUES("219839","_wp_session_470a9b7adc1e5a44be671b13d1962dc2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c930059546096897681cfaf86d9c4868\";}\";}","no");
INSERT INTO `wp_options` VALUES("219807","_wp_session_expires_ace15685877538d7a82879ecb3175024","2789325322","no");
INSERT INTO `wp_options` VALUES("219803","_wp_session_expires_5ebb8740fecb3b2645ef9e138c6d8151","2789324160","no");
INSERT INTO `wp_options` VALUES("219806","_wp_session_ace15685877538d7a82879ecb3175024","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b8fd6161f490a4c537bd5442446a5da3\";}\";}","no");
INSERT INTO `wp_options` VALUES("219802","_wp_session_5ebb8740fecb3b2645ef9e138c6d8151","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ae763d0f9d2478eb7409beeb37282782\";}\";}","no");
INSERT INTO `wp_options` VALUES("219759","_wp_session_expires_5259a889b11fcd28188101c676dbbb38","2789318360","no");
INSERT INTO `wp_options` VALUES("219758","_wp_session_5259a889b11fcd28188101c676dbbb38","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0f22780e1c1ff5670c1ee7b94b3fe177\";}\";}","no");
INSERT INTO `wp_options` VALUES("219747","_wp_session_expires_cd7e38c0dd7cb2f99b3945e532345d17","2789317714","no");
INSERT INTO `wp_options` VALUES("211608","_wp_session_696e6c69b8505642030917105a10611f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b44b6454b2691485f844d628684dcf4c\";}\";}","no");
INSERT INTO `wp_options` VALUES("211609","_wp_session_expires_696e6c69b8505642030917105a10611f","2788329586","no");
INSERT INTO `wp_options` VALUES("219746","_wp_session_cd7e38c0dd7cb2f99b3945e532345d17","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ceafe2e7f549ffa64011d24d6dedcc7b\";}\";}","no");
INSERT INTO `wp_options` VALUES("219735","_wp_session_expires_84f2edb0ccb45b427ef81a21e9dd8bee","2789317318","no");
INSERT INTO `wp_options` VALUES("219715","_wp_session_expires_c4c0c9ac1c30a4d3a823f6f7c7a0f5d4","2789315402","no");
INSERT INTO `wp_options` VALUES("219734","_wp_session_84f2edb0ccb45b427ef81a21e9dd8bee","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cf101fffcc61c1ba9e026fcf8fe675f7\";}\";}","no");
INSERT INTO `wp_options` VALUES("219714","_wp_session_c4c0c9ac1c30a4d3a823f6f7c7a0f5d4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c99204dd7cd5eaac093aa00074b0c225\";}\";}","no");
INSERT INTO `wp_options` VALUES("219653","_wp_session_expires_4d9ab97d903a0efe9cbd5aa741ae0bc2","2789309316","no");
INSERT INTO `wp_options` VALUES("219652","_wp_session_4d9ab97d903a0efe9cbd5aa741ae0bc2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f7f1606d05f1e8f56c2c25e8ee1197a9\";}\";}","no");
INSERT INTO `wp_options` VALUES("219603","_wp_session_expires_afc1e0e996e81f64fa33817c941d4c35","2789302230","no");
INSERT INTO `wp_options` VALUES("219602","_wp_session_afc1e0e996e81f64fa33817c941d4c35","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d8ff7c789960476491bb2f1d0117cfbf\";}\";}","no");
INSERT INTO `wp_options` VALUES("219593","_wp_session_expires_2396be41df508b123c250bd36a700762","2789301816","no");
INSERT INTO `wp_options` VALUES("219592","_wp_session_2396be41df508b123c250bd36a700762","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f387b8a6754e2187a560d1e4f3553717\";}\";}","no");
INSERT INTO `wp_options` VALUES("219587","_wp_session_expires_75b9519bd733e8abf60b76322f5bf98c","2789301372","no");
INSERT INTO `wp_options` VALUES("219586","_wp_session_75b9519bd733e8abf60b76322f5bf98c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d62903b5dce211ec0162ba77eefcc9d8\";}\";}","no");
INSERT INTO `wp_options` VALUES("219578","_wp_session_expires_0a86f297f082561217d37c8744386f9a","2789300624","no");
INSERT INTO `wp_options` VALUES("219577","_wp_session_0a86f297f082561217d37c8744386f9a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"59d4d30ca5d7b241d399296ae113b92d\";}\";}","no");
INSERT INTO `wp_options` VALUES("219575","_wp_session_expires_7c3b4bf11e758cafcedb431b21d578a9","2789300620","no");
INSERT INTO `wp_options` VALUES("219574","_wp_session_7c3b4bf11e758cafcedb431b21d578a9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"87754a3107817dc284038f0627c6ef50\";}\";}","no");
INSERT INTO `wp_options` VALUES("219572","_wp_session_expires_490b03a0687e7290ef71e7ac91f55eae","2789300010","no");
INSERT INTO `wp_options` VALUES("219571","_wp_session_490b03a0687e7290ef71e7ac91f55eae","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8d900ec43cbba931a8642c6ba33fa983\";}\";}","no");
INSERT INTO `wp_options` VALUES("219567","_wp_session_expires_c5980a85328d0d45765198105f919edc","2789299648","no");
INSERT INTO `wp_options` VALUES("219566","_wp_session_c5980a85328d0d45765198105f919edc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"db86fb1ba57a74d74a563e041c665611\";}\";}","no");
INSERT INTO `wp_options` VALUES("219564","_wp_session_expires_b9676aaa5a7bc7d7be56aace51fba942","2789298814","no");
INSERT INTO `wp_options` VALUES("211793","_wp_session_a9d73fcab2d88b7d96e5f11d91cdc371","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b24bd11d26fd51f93b70407f0b4b1bc0\";}\";}","no");
INSERT INTO `wp_options` VALUES("211794","_wp_session_expires_a9d73fcab2d88b7d96e5f11d91cdc371","2788349266","no");
INSERT INTO `wp_options` VALUES("221597","_wp_session_expires_cc672da63fcd538f812da112e30840f1","2789543256","no");
INSERT INTO `wp_options` VALUES("219563","_wp_session_b9676aaa5a7bc7d7be56aace51fba942","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"533ca70b6432f575a9941d98e10b2f32\";}\";}","no");
INSERT INTO `wp_options` VALUES("219561","_wp_session_expires_a578b8e78e04d934d06796448df792cc","2789298778","no");
INSERT INTO `wp_options` VALUES("219560","_wp_session_a578b8e78e04d934d06796448df792cc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c29650710bb0c610a08beb9d4ca63c61\";}\";}","no");
INSERT INTO `wp_options` VALUES("219558","_wp_session_expires_50d22794dc2c29a88966b77dc8b7fa58","2789298492","no");
INSERT INTO `wp_options` VALUES("219512","_wp_session_expires_8e53b6d877629a54ac2702f730d3c707","2789291334","no");
INSERT INTO `wp_options` VALUES("230808","_wp_session_5b3b3efbb766ae3e41aa348be512e8a7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ba152e55ad032a3cfc56e88f0e3bed56\";}\";}","no");
INSERT INTO `wp_options` VALUES("219511","_wp_session_8e53b6d877629a54ac2702f730d3c707","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9826b04024b71556e55178f2cf1f4a5b\";}\";}","no");
INSERT INTO `wp_options` VALUES("219419","_wp_session_expires_4cf963ca7b2b0d62788b3f653fb9f79a","2789278404","no");
INSERT INTO `wp_options` VALUES("219418","_wp_session_4cf963ca7b2b0d62788b3f653fb9f79a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6936f1f449c40cd2276b8116cf744bd8\";}\";}","no");
INSERT INTO `wp_options` VALUES("219396","_wp_session_expires_2161ec3a1efda4c751d0a570e9aaad51","2789275582","no");
INSERT INTO `wp_options` VALUES("219395","_wp_session_2161ec3a1efda4c751d0a570e9aaad51","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"890906e13caafa24f85a8a3cb910f91b\";}\";}","no");
INSERT INTO `wp_options` VALUES("219388","_wp_session_expires_9d5b1fd8304031277b8618d042cce244","2789274424","no");
INSERT INTO `wp_options` VALUES("211843","_wp_session_8a8e59eb1cb5316b3d1b48ecf21d353a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f5bebd906fdfef526878884e385533d3\";}\";}","no");
INSERT INTO `wp_options` VALUES("211844","_wp_session_expires_8a8e59eb1cb5316b3d1b48ecf21d353a","2788356438","no");
INSERT INTO `wp_options` VALUES("219385","_wp_session_expires_966146424302dfe460cb7232f723e4a3","2789274166","no");
INSERT INTO `wp_options` VALUES("220953","_wp_session_expires_c721893a70dc425fa13cb2970c4f21d5","2789448852","no");
INSERT INTO `wp_options` VALUES("220947","_wp_session_expires_86309f86c08c16a031dcd4bca3e411ee","2789448378","no");
INSERT INTO `wp_options` VALUES("220949","_wp_session_6d1c019e5d8e675ea41d7e023448fc9c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9b5360ea2172fb1e5ab96bc195fbb415\";}\";}","no");
INSERT INTO `wp_options` VALUES("220950","_wp_session_expires_6d1c019e5d8e675ea41d7e023448fc9c","2789448844","no");
INSERT INTO `wp_options` VALUES("219387","_wp_session_9d5b1fd8304031277b8618d042cce244","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1889de48ec0e19b98e9515a8c2d075fb\";}\";}","no");
INSERT INTO `wp_options` VALUES("219384","_wp_session_966146424302dfe460cb7232f723e4a3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"efe72b90d771e0605bce6fe1df8b6f70\";}\";}","no");
INSERT INTO `wp_options` VALUES("219348","_wp_session_expires_0e9631f07a5c487ae2a1744c50569d12","2789268688","no");
INSERT INTO `wp_options` VALUES("219347","_wp_session_0e9631f07a5c487ae2a1744c50569d12","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"03f0a2d72314cd50c10f0051c1ca723c\";}\";}","no");
INSERT INTO `wp_options` VALUES("219277","_wp_session_expires_a317ef71956b3f400a20d879cbc70497","2789255780","no");
INSERT INTO `wp_options` VALUES("219276","_wp_session_a317ef71956b3f400a20d879cbc70497","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6e492024696e35331504ebacd509ca0b\";}\";}","no");
INSERT INTO `wp_options` VALUES("218760","_wp_session_expires_3df3e58a51a2224f447cce9723d26c55","2789202688","no");
INSERT INTO `wp_options` VALUES("220952","_wp_session_c721893a70dc425fa13cb2970c4f21d5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b166c33f2339da5050cda5acf414a2f5\";}\";}","no");
INSERT INTO `wp_options` VALUES("212139","_wp_session_cdc2318521e2137ec1e2a3031bbe9b2c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f22861206021efd1b1e27c5fb46b3723\";}\";}","no");
INSERT INTO `wp_options` VALUES("212140","_wp_session_expires_cdc2318521e2137ec1e2a3031bbe9b2c","2788383710","no");
INSERT INTO `wp_options` VALUES("212186","_wp_session_d383b286e07f47914572525ff2318b60","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"832ffb75c1f865a993fa2593d77e5547\";}\";}","no");
INSERT INTO `wp_options` VALUES("212187","_wp_session_expires_d383b286e07f47914572525ff2318b60","2788392742","no");
INSERT INTO `wp_options` VALUES("212314","_wp_session_expires_29f8f8ce20bcb74632f3727d73c5c154","2788408442","no");
INSERT INTO `wp_options` VALUES("212363","_wp_session_eb3b9a191d2645e2c045125aa31f18d9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"231b2de66226979f0ec8385c144ea68f\";}\";}","no");
INSERT INTO `wp_options` VALUES("212373","_wp_session_expires_85698dba10b0a6766603c2928bbf1b2c","2788410276","no");
INSERT INTO `wp_options` VALUES("212378","_wp_session_81eda03f1ea0261220f4e237018efdc8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7c1484dc23adf0a2f5fc7c569aca4bc1\";}\";}","no");
INSERT INTO `wp_options` VALUES("212379","_wp_session_expires_81eda03f1ea0261220f4e237018efdc8","2788410820","no");
INSERT INTO `wp_options` VALUES("212387","_wp_session_da72361f760dae02c3a77c03a2dfabac","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2c59f6566cbb33d84de5fc0e52d5c0c2\";}\";}","no");
INSERT INTO `wp_options` VALUES("212388","_wp_session_expires_da72361f760dae02c3a77c03a2dfabac","2788412388","no");
INSERT INTO `wp_options` VALUES("212394","_wp_session_3437fc7510b73fb6c903bf13af0e5d1a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"384b2c542aea1ba374f5d762d7c36a2d\";}\";}","no");
INSERT INTO `wp_options` VALUES("212395","_wp_session_expires_3437fc7510b73fb6c903bf13af0e5d1a","2788413286","no");
INSERT INTO `wp_options` VALUES("212520","_wp_session_1d3e25c625c77d46b0d878e30f6d4fdd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8386fb2cec8b297871170c17cdbfa18b\";}\";}","no");
INSERT INTO `wp_options` VALUES("213822","_wp_session_daef0002669dfde0fd1ffbbfc43c3d1c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"56530449466e5bfa3bc0aab32530401a\";}\";}","no");
INSERT INTO `wp_options` VALUES("213823","_wp_session_expires_daef0002669dfde0fd1ffbbfc43c3d1c","2788582046","no");
INSERT INTO `wp_options` VALUES("213827","_wp_session_7239e0ed8d54be73ad20b02fac3548be","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9398ef5f45e39f6191eeb30a355e65a0\";}\";}","no");
INSERT INTO `wp_options` VALUES("212521","_wp_session_expires_1d3e25c625c77d46b0d878e30f6d4fdd","2788436686","no");
INSERT INTO `wp_options` VALUES("212523","_wp_session_44c18ba64ae64ec21c0f7c950ce33c02","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2211d2b97abeb4cffec031df43b0bb0b\";}\";}","no");
INSERT INTO `wp_options` VALUES("212524","_wp_session_expires_44c18ba64ae64ec21c0f7c950ce33c02","2788436754","no");
INSERT INTO `wp_options` VALUES("212529","_wp_session_77a9df7de1eff76ad0fb5952a29e2966","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"691e8281d645cdd7ac5bffd89c82b6a3\";}\";}","no");
INSERT INTO `wp_options` VALUES("212530","_wp_session_expires_77a9df7de1eff76ad0fb5952a29e2966","2788437364","no");
INSERT INTO `wp_options` VALUES("212532","_wp_session_3a30002feeb6eb7185d264402847552a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5d0cc49ea94dd11895ca2919b9b578ff\";}\";}","no");
INSERT INTO `wp_options` VALUES("212533","_wp_session_expires_3a30002feeb6eb7185d264402847552a","2788437396","no");
INSERT INTO `wp_options` VALUES("212535","_wp_session_a322047051c6ef9d3d1ef81384f0c710","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7fbe67d651456a7d75b6047124f77f05\";}\";}","no");
INSERT INTO `wp_options` VALUES("212536","_wp_session_expires_a322047051c6ef9d3d1ef81384f0c710","2788437444","no");
INSERT INTO `wp_options` VALUES("212539","_wp_session_301c276c3f6a1cd79f87095ffe9433f1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"85b45814e65898b378696acfd4e11211\";}\";}","no");
INSERT INTO `wp_options` VALUES("212540","_wp_session_expires_301c276c3f6a1cd79f87095ffe9433f1","2788437872","no");
INSERT INTO `wp_options` VALUES("212542","_wp_session_110e9e3cfd3bbe5b0b26139e8eeccd95","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ce82adfebd6aa468c180a2e8af30cb0b\";}\";}","no");
INSERT INTO `wp_options` VALUES("212543","_wp_session_expires_110e9e3cfd3bbe5b0b26139e8eeccd95","2788437964","no");
INSERT INTO `wp_options` VALUES("212552","_wp_session_512be792cb03178fdce784a94bda785e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9208acb06b175f1d2be1c454d737fac8\";}\";}","no");
INSERT INTO `wp_options` VALUES("212553","_wp_session_expires_512be792cb03178fdce784a94bda785e","2788438398","no");
INSERT INTO `wp_options` VALUES("212580","_wp_session_377d43c1377bb24fc10935c3512b6da2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"56bacf90a1124678de2e5b975f2acac6\";}\";}","no");
INSERT INTO `wp_options` VALUES("212581","_wp_session_expires_377d43c1377bb24fc10935c3512b6da2","2788441964","no");
INSERT INTO `wp_options` VALUES("212628","_wp_session_a715261701ec56afb60aa5e71a0fea6e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"017dd93a15c460fee49590f88ad857ca\";}\";}","no");
INSERT INTO `wp_options` VALUES("212629","_wp_session_expires_a715261701ec56afb60aa5e71a0fea6e","2788447040","no");
INSERT INTO `wp_options` VALUES("212634","_wp_session_137f3c478d1ce7464e58e09b942020e9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c0f66a17a737e6cdae15a67da460e755\";}\";}","no");
INSERT INTO `wp_options` VALUES("212635","_wp_session_expires_137f3c478d1ce7464e58e09b942020e9","2788448134","no");
INSERT INTO `wp_options` VALUES("212639","_wp_session_11a0b710a8c1bd7d87b2a3a44eb27271","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"83f78aa5ac15a19c969ce46b6c4caece\";}\";}","no");
INSERT INTO `wp_options` VALUES("212640","_wp_session_expires_11a0b710a8c1bd7d87b2a3a44eb27271","2788448592","no");
INSERT INTO `wp_options` VALUES("212644","_wp_session_e7856475b5c41bb72d682225939ed7ef","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5456f74a87ddfb0811fb157325eef106\";}\";}","no");
INSERT INTO `wp_options` VALUES("212645","_wp_session_expires_e7856475b5c41bb72d682225939ed7ef","2788448924","no");
INSERT INTO `wp_options` VALUES("212675","_wp_session_42658b42f3f0b107a82e34012d27dce0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"11e99c451712678772dea163c68b6f68\";}\";}","no");
INSERT INTO `wp_options` VALUES("212676","_wp_session_expires_42658b42f3f0b107a82e34012d27dce0","2788454472","no");
INSERT INTO `wp_options` VALUES("212683","_wp_session_2901eab9d5ca0745d983f52d89cf44d1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"925f31e67112731a462dfc54660ab8f5\";}\";}","no");
INSERT INTO `wp_options` VALUES("212684","_wp_session_expires_2901eab9d5ca0745d983f52d89cf44d1","2788455148","no");
INSERT INTO `wp_options` VALUES("212703","_wp_session_deb52dfa184c19b6b3c314a4eccbb17b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"71bd22a3ad1c16c796f24a10cf0b5f38\";}\";}","no");
INSERT INTO `wp_options` VALUES("212704","_wp_session_expires_deb52dfa184c19b6b3c314a4eccbb17b","2788460984","no");
INSERT INTO `wp_options` VALUES("212708","_wp_session_ac15e35d1cb8310599f92913ebeb8838","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0a28e7520c45cb1e042e4fd469448c14\";}\";}","no");
INSERT INTO `wp_options` VALUES("212709","_wp_session_expires_ac15e35d1cb8310599f92913ebeb8838","2788461310","no");
INSERT INTO `wp_options` VALUES("213193","_wp_session_d565a9fcd51a5080dabd3feb0a678f6e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e23d17fd3ce4a0231ea1d867ace99bd7\";}\";}","no");
INSERT INTO `wp_options` VALUES("213194","_wp_session_expires_d565a9fcd51a5080dabd3feb0a678f6e","2788468892","no");
INSERT INTO `wp_options` VALUES("213223","_wp_session_6188578fc76c92a102d8e3584eb26d07","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"faf76b12e46239f08bad28384a7361f7\";}\";}","no");
INSERT INTO `wp_options` VALUES("213224","_wp_session_expires_6188578fc76c92a102d8e3584eb26d07","2788470050","no");
INSERT INTO `wp_options` VALUES("213228","_wp_session_89cd285d9bbdf90fb0b6c40e953c7a25","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"565f1d7f1273c22a9107b104ab50ac73\";}\";}","no");
INSERT INTO `wp_options` VALUES("213229","_wp_session_expires_89cd285d9bbdf90fb0b6c40e953c7a25","2788470472","no");
INSERT INTO `wp_options` VALUES("213316","_wp_session_8c72bd83b142bb2fd8482fce8b75a8aa","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("213315","_wp_session_expires_8c72bd83b142bb2fd8482fce8b75a8aa","2788482498","no");
INSERT INTO `wp_options` VALUES("213665","_wp_session_91150068ffe0563e9e0300e3bb1c2f77","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"688f8dc9624fecfce4c215b9230d34fc\";}\";}","no");
INSERT INTO `wp_options` VALUES("213666","_wp_session_expires_91150068ffe0563e9e0300e3bb1c2f77","2788544156","no");
INSERT INTO `wp_options` VALUES("213817","_wp_session_35d506f5cba163777ddf72693e707b4b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6f92edce63f27e22235d55b3008438aa\";}\";}","no");
INSERT INTO `wp_options` VALUES("213818","_wp_session_expires_35d506f5cba163777ddf72693e707b4b","2788581264","no");
INSERT INTO `wp_options` VALUES("213828","_wp_session_expires_7239e0ed8d54be73ad20b02fac3548be","2788583650","no");
INSERT INTO `wp_options` VALUES("213830","_wp_session_bb74a8ec13e2c726e04300c3ef33143c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"22d0b2ff86d7dc24de3506694a15eb6b\";}\";}","no");
INSERT INTO `wp_options` VALUES("213831","_wp_session_expires_bb74a8ec13e2c726e04300c3ef33143c","2788583932","no");
INSERT INTO `wp_options` VALUES("213884","_wp_session_c4cac12d31b923206b6448dfe8a24b33","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1fe8a053fa09684544b59f139cc0078d\";}\";}","no");
INSERT INTO `wp_options` VALUES("215174","_wp_session_7875759e87f0171d9716cbd08289b688","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1aaf07ec3f7fe968be512032d0c22aa3\";}\";}","no");
INSERT INTO `wp_options` VALUES("215175","_wp_session_expires_7875759e87f0171d9716cbd08289b688","2788757208","no");
INSERT INTO `wp_options` VALUES("213885","_wp_session_expires_c4cac12d31b923206b6448dfe8a24b33","2788594242","no");
INSERT INTO `wp_options` VALUES("213912","_wp_session_b5ecae05a67a67332095f9cd03557df9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"17b89fa07d6e8432bf876057ff684208\";}\";}","no");
INSERT INTO `wp_options` VALUES("213913","_wp_session_expires_b5ecae05a67a67332095f9cd03557df9","2788600794","no");
INSERT INTO `wp_options` VALUES("213989","_wp_session_e70d2a69c1f02f023977bbc8d9a68c25","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c38ba954f0dad9c4287675ed95657935\";}\";}","no");
INSERT INTO `wp_options` VALUES("213990","_wp_session_expires_e70d2a69c1f02f023977bbc8d9a68c25","2788610504","no");
INSERT INTO `wp_options` VALUES("213993","_wp_session_b94be7360790f4e97e933b0f814fd902","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b98039f50b198aba20ef85031b595ec3\";}\";}","no");
INSERT INTO `wp_options` VALUES("213994","_wp_session_expires_b94be7360790f4e97e933b0f814fd902","2788611170","no");
INSERT INTO `wp_options` VALUES("213996","_wp_session_598c2c3df8c64fba72d709148a0d40e3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9fbff196b4bf5338d8806d889f521b27\";}\";}","no");
INSERT INTO `wp_options` VALUES("213997","_wp_session_expires_598c2c3df8c64fba72d709148a0d40e3","2788611444","no");
INSERT INTO `wp_options` VALUES("213999","_wp_session_e2a5d952ce966e397062ed2f832d37ee","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"72060409748906aa1d788e860aad35ea\";}\";}","no");
INSERT INTO `wp_options` VALUES("214000","_wp_session_expires_e2a5d952ce966e397062ed2f832d37ee","2788611588","no");
INSERT INTO `wp_options` VALUES("214005","_wp_session_880dfbfc12e79315b9e9d18ec2e8052f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"685870a7480862db82ec6ebac98bf24b\";}\";}","no");
INSERT INTO `wp_options` VALUES("214006","_wp_session_expires_880dfbfc12e79315b9e9d18ec2e8052f","2788611834","no");
INSERT INTO `wp_options` VALUES("214018","_wp_session_18cc7d0498b83d1ac61d3ce9502b9f33","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"78a4ad25016ebc22b323710c2ab5f154\";}\";}","no");
INSERT INTO `wp_options` VALUES("214019","_wp_session_expires_18cc7d0498b83d1ac61d3ce9502b9f33","2788612634","no");
INSERT INTO `wp_options` VALUES("214021","_wp_session_ec384833e9e3fe9e91a70462030e8ab2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e01fee74b45b591dadc94b031072290e\";}\";}","no");
INSERT INTO `wp_options` VALUES("214022","_wp_session_expires_ec384833e9e3fe9e91a70462030e8ab2","2788612688","no");
INSERT INTO `wp_options` VALUES("214024","_wp_session_41aa4b118a0f89ddc17e927a3394d0e3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"471e70c216ac96cb3ba475282202372f\";}\";}","no");
INSERT INTO `wp_options` VALUES("214025","_wp_session_expires_41aa4b118a0f89ddc17e927a3394d0e3","2788612714","no");
INSERT INTO `wp_options` VALUES("214027","_wp_session_aee41cb15ef2a990ca0aa06feca59044","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1902d9f8d14916f8af8919fb6a212145\";}\";}","no");
INSERT INTO `wp_options` VALUES("214028","_wp_session_expires_aee41cb15ef2a990ca0aa06feca59044","2788612740","no");
INSERT INTO `wp_options` VALUES("214068","_wp_session_be8fd749e3e0618d67a26e7197e2565e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5cbe89ef5ffb6b25662457ab755f19d3\";}\";}","no");
INSERT INTO `wp_options` VALUES("214069","_wp_session_expires_be8fd749e3e0618d67a26e7197e2565e","2788619214","no");
INSERT INTO `wp_options` VALUES("214098","_wp_session_6f2266f4a01ddfa8a3b0670aad1e4adc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7841ce63757a76ffcfdabc86d3c18a79\";}\";}","no");
INSERT INTO `wp_options` VALUES("214099","_wp_session_expires_6f2266f4a01ddfa8a3b0670aad1e4adc","2788621768","no");
INSERT INTO `wp_options` VALUES("214149","_wp_session_d414f4e4046d2071c407b0a44aba1474","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"bd912dcfa79fd7ad1123a8d98354b225\";}\";}","no");
INSERT INTO `wp_options` VALUES("214150","_wp_session_expires_d414f4e4046d2071c407b0a44aba1474","2788627764","no");
INSERT INTO `wp_options` VALUES("214152","_wp_session_2f3abb30b8d66a1897234ff61ba160ea","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"266f28d9fa377c3161db2fd8ea389ba9\";}\";}","no");
INSERT INTO `wp_options` VALUES("214153","_wp_session_expires_2f3abb30b8d66a1897234ff61ba160ea","2788628246","no");
INSERT INTO `wp_options` VALUES("214158","_wp_session_f7d5672652f649db327bd191a0d9248f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7e399e945791acb77810d856b8a6ef1c\";}\";}","no");
INSERT INTO `wp_options` VALUES("214159","_wp_session_expires_f7d5672652f649db327bd191a0d9248f","2788629926","no");
INSERT INTO `wp_options` VALUES("214184","_wp_session_31ade4293fc60b1f1384e8a3d2fd27c0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0c84c0d08aba9a3132ad875858c6905b\";}\";}","no");
INSERT INTO `wp_options` VALUES("214185","_wp_session_expires_31ade4293fc60b1f1384e8a3d2fd27c0","2788632438","no");
INSERT INTO `wp_options` VALUES("214187","_wp_session_1f1933d53c26ab9e78a4d8ccbbad7624","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"09793cf408cb8f52d5351930303db48b\";}\";}","no");
INSERT INTO `wp_options` VALUES("214188","_wp_session_expires_1f1933d53c26ab9e78a4d8ccbbad7624","2788632886","no");
INSERT INTO `wp_options` VALUES("214226","_wp_session_d5a37914f7a73e64d9f7c6a6b9a3e5dd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4d2bb54ad8d9e76ee26e956ffd33dc39\";}\";}","no");
INSERT INTO `wp_options` VALUES("214227","_wp_session_expires_d5a37914f7a73e64d9f7c6a6b9a3e5dd","2788638946","no");
INSERT INTO `wp_options` VALUES("214241","_wp_session_091468380135ef407c059b2713ea2845","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"134dfcb24cae161746686d15b461b985\";}\";}","no");
INSERT INTO `wp_options` VALUES("214242","_wp_session_expires_091468380135ef407c059b2713ea2845","2788642964","no");
INSERT INTO `wp_options` VALUES("214301","_wp_session_95ea139851c88298427ee8abf8efe2b0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ed3ea475d3b4ce57c0ef9b71291bf099\";}\";}","no");
INSERT INTO `wp_options` VALUES("214302","_wp_session_expires_95ea139851c88298427ee8abf8efe2b0","2788650600","no");
INSERT INTO `wp_options` VALUES("214317","_wp_session_expires_600525be300fc01b2b409f97d57c3f6f","2788652696","no");
INSERT INTO `wp_options` VALUES("214320","_wp_session_expires_17f2512ec9ea2dc2b74482c847bc8e7a","2788652824","no");
INSERT INTO `wp_options` VALUES("214322","_wp_session_expires_b0c317e6a4a5be62c05fa7224b0c2913","2788652836","no");
INSERT INTO `wp_options` VALUES("214324","_wp_session_expires_8e4ff04c21342799a8510368abc179d2","2788652846","no");
INSERT INTO `wp_options` VALUES("214327","_wp_session_expires_297668784a1e39651310c0773aa6ae8d","2788652880","no");
INSERT INTO `wp_options` VALUES("214493","_wp_session_abac63289ce16543b0f4c395cb00e169","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"02f54d21fb5302c31efb6952fb234ac6\";}\";}","no");
INSERT INTO `wp_options` VALUES("214494","_wp_session_expires_abac63289ce16543b0f4c395cb00e169","2788658222","no");
INSERT INTO `wp_options` VALUES("214792","_wp_session_expires_6b7bbe75bd0d1c6d247d04fbfc8062ca","2788686336","no");
INSERT INTO `wp_options` VALUES("214638","_wp_session_3d9b33491c669c8fe524459a336e8675","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d60afa4710177c51f5e5e05f2ba7be39\";}\";}","no");
INSERT INTO `wp_options` VALUES("214639","_wp_session_expires_3d9b33491c669c8fe524459a336e8675","2788669436","no");
INSERT INTO `wp_options` VALUES("214880","_wp_session_dfbb5ce75e888f41a97541e305ab61d2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"42aa74904f2a50daed1de41e478d425d\";}\";}","no");
INSERT INTO `wp_options` VALUES("214881","_wp_session_expires_dfbb5ce75e888f41a97541e305ab61d2","2788698662","no");
INSERT INTO `wp_options` VALUES("214914","_wp_session_expires_7ce40ba66c47881cda5db8630b6aed86","2788704732","no");
INSERT INTO `wp_options` VALUES("215140","_wp_session_a720bedd48c1928491f11f0efd0c44fa","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9358bd739c6019c85e1b909a12248d0f\";}\";}","no");
INSERT INTO `wp_options` VALUES("215141","_wp_session_expires_a720bedd48c1928491f11f0efd0c44fa","2788751636","no");
INSERT INTO `wp_options` VALUES("215162","_wp_session_fb62b0443c40d4c0c961c6b33c55de42","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dbef1b4873f9ce4d464711586df07563\";}\";}","no");
INSERT INTO `wp_options` VALUES("215163","_wp_session_expires_fb62b0443c40d4c0c961c6b33c55de42","2788755582","no");
INSERT INTO `wp_options` VALUES("215316","_wp_session_d0e4a269f6fa9f3580f78dafe7c362da","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"faf1506326aeb66d90825a0dd1e050ca\";}\";}","no");
INSERT INTO `wp_options` VALUES("218671","_wp_session_expires_c76bcdb942e2d21e8488d6269c81d540","2789198716","no");
INSERT INTO `wp_options` VALUES("218576","_wp_session_14ec12d20ead8b57aefa325120a76dee","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e22f07a9908d4264f1c8cabb62a9fd25\";}\";}","no");
INSERT INTO `wp_options` VALUES("217419","_wp_session_expires_94f5204e0f8c1558f298826aeda83d22","2789043824","no");
INSERT INTO `wp_options` VALUES("215317","_wp_session_expires_d0e4a269f6fa9f3580f78dafe7c362da","2788783350","no");
INSERT INTO `wp_options` VALUES("215555","_wp_session_55ea9c331fa11df45639be6b1ed21dce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"93eb51f7dd3cef5331001bc9a5493170\";}\";}","no");
INSERT INTO `wp_options` VALUES("215556","_wp_session_expires_55ea9c331fa11df45639be6b1ed21dce","2788824894","no");
INSERT INTO `wp_options` VALUES("215696","_wp_session_ebbd7c60d0d519815020bc4c4fa25428","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"18c164af4f62d857ea785ec083108443\";}\";}","no");
INSERT INTO `wp_options` VALUES("215697","_wp_session_expires_ebbd7c60d0d519815020bc4c4fa25428","2788843340","no");
INSERT INTO `wp_options` VALUES("215699","_wp_session_756999dc5f2ea53b2e9291fa350ef406","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d90806311e6d60bfa9ea578bae836c76\";}\";}","no");
INSERT INTO `wp_options` VALUES("215700","_wp_session_expires_756999dc5f2ea53b2e9291fa350ef406","2788843374","no");
INSERT INTO `wp_options` VALUES("215703","_wp_session_60ce10770a0ff8a309dd95e511c78d38","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"378e69828a893682704c4927e6762650\";}\";}","no");
INSERT INTO `wp_options` VALUES("215704","_wp_session_expires_60ce10770a0ff8a309dd95e511c78d38","2788843384","no");
INSERT INTO `wp_options` VALUES("215714","_wp_session_733b0f86038e21b097e672fd373bdf93","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a2b2093c71149aa4353bfc7e82f991be\";}\";}","no");
INSERT INTO `wp_options` VALUES("215715","_wp_session_expires_733b0f86038e21b097e672fd373bdf93","2788844466","no");
INSERT INTO `wp_options` VALUES("215721","_wp_session_a321c00c0a48357c44fa00e58a2b9102","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8360147ccac5257a304d1b4d1070b83e\";}\";}","no");
INSERT INTO `wp_options` VALUES("215722","_wp_session_expires_a321c00c0a48357c44fa00e58a2b9102","2788845232","no");
INSERT INTO `wp_options` VALUES("215727","_wp_session_429220609362d4175641b6de9b0de1b3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c3c78fffa47d07955329424f7010435b\";}\";}","no");
INSERT INTO `wp_options` VALUES("215728","_wp_session_expires_429220609362d4175641b6de9b0de1b3","2788846072","no");
INSERT INTO `wp_options` VALUES("215736","_wp_session_6501560f9445bc1db188df5a9a24f1a5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e5f203323d8086d09ee2ec962c7b4905\";}\";}","no");
INSERT INTO `wp_options` VALUES("215737","_wp_session_expires_6501560f9445bc1db188df5a9a24f1a5","2788848558","no");
INSERT INTO `wp_options` VALUES("215739","_wp_session_6fc26770840d0e8c9be1c87ab75f246d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c0b8c0e8d40e7e365a1bc0b5e33abe99\";}\";}","no");
INSERT INTO `wp_options` VALUES("215740","_wp_session_expires_6fc26770840d0e8c9be1c87ab75f246d","2788848810","no");
INSERT INTO `wp_options` VALUES("215861","_wp_session_expires_c97fee07a865d2eba754cc34f4687b21","2788860682","no");
INSERT INTO `wp_options` VALUES("216021","_wp_session_expires_f13d473d13a703a98011f3290113db63","2788869072","no");
INSERT INTO `wp_options` VALUES("216113","_wp_session_expires_d724ed096a27660cbf1b714f3f6a16c9","2788882162","no");
INSERT INTO `wp_options` VALUES("216295","_wp_session_671cd4bd66bca36057912c9fd6aa477e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4d5dfc6d228181a09f53d6c5040d68f6\";}\";}","no");
INSERT INTO `wp_options` VALUES("216296","_wp_session_expires_671cd4bd66bca36057912c9fd6aa477e","2788921324","no");
INSERT INTO `wp_options` VALUES("216317","_wp_session_30300b1af365fa822f0b6da1d5b2d68d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"83402fd6685b9cf2fb19dc3306068e25\";}\";}","no");
INSERT INTO `wp_options` VALUES("216318","_wp_session_expires_30300b1af365fa822f0b6da1d5b2d68d","2788926844","no");
INSERT INTO `wp_options` VALUES("216321","_wp_session_2f5f35f14eb364b69ca85960e0534fe2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"60f2eed059cb7e67eeb49fbcab899fc4\";}\";}","no");
INSERT INTO `wp_options` VALUES("216322","_wp_session_expires_2f5f35f14eb364b69ca85960e0534fe2","2788928462","no");
INSERT INTO `wp_options` VALUES("216332","_wp_session_e9840ecbd4f8bec9f363525a06bb6b3a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"27b1f5b3767fad4c9450f2a0dda202c3\";}\";}","no");
INSERT INTO `wp_options` VALUES("216333","_wp_session_expires_e9840ecbd4f8bec9f363525a06bb6b3a","2788929716","no");
INSERT INTO `wp_options` VALUES("216459","_wp_session_expires_af80d75f8c41aa0f1d1c9eb45f571ddf","2788940544","no");
INSERT INTO `wp_options` VALUES("216484","_wp_session_42112ca7cd97e7144b37cbcd50aaca3b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ac1d9e4ea5e8e7f2c9918fd4ca84258f\";}\";}","no");
INSERT INTO `wp_options` VALUES("216485","_wp_session_expires_42112ca7cd97e7144b37cbcd50aaca3b","2788942850","no");
INSERT INTO `wp_options` VALUES("216568","_wp_session_bf3af3fee2f7bd41dd6df945b76c4f85","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d9dffc81335dd97a8dd0034599e257f5\";}\";}","no");
INSERT INTO `wp_options` VALUES("216569","_wp_session_expires_bf3af3fee2f7bd41dd6df945b76c4f85","2788954112","no");
INSERT INTO `wp_options` VALUES("216571","_wp_session_39ed7b0a96f8c2e014e2b8a7c289f48d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f0939b99068e220054d465ce1d7613a0\";}\";}","no");
INSERT INTO `wp_options` VALUES("216572","_wp_session_expires_39ed7b0a96f8c2e014e2b8a7c289f48d","2788954156","no");
INSERT INTO `wp_options` VALUES("216574","_wp_session_2091150036bf1a94b591ab1f3041725b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fd9747dbf74808136d8431b5dc5fa900\";}\";}","no");
INSERT INTO `wp_options` VALUES("216575","_wp_session_expires_2091150036bf1a94b591ab1f3041725b","2788954248","no");
INSERT INTO `wp_options` VALUES("216577","_wp_session_e1e9200afca930aa7cdad080971f8e62","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"12ca3993828535073e190be6961d7c18\";}\";}","no");
INSERT INTO `wp_options` VALUES("216578","_wp_session_expires_e1e9200afca930aa7cdad080971f8e62","2788954536","no");
INSERT INTO `wp_options` VALUES("216580","_wp_session_23c068516acbffa815cdee3c4a6abfbe","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d8573adfc4832cd2cac3890da4e7780c\";}\";}","no");
INSERT INTO `wp_options` VALUES("216581","_wp_session_expires_23c068516acbffa815cdee3c4a6abfbe","2788954616","no");
INSERT INTO `wp_options` VALUES("216585","_wp_session_536bfb509784af42cafb2a86d0d6dd34","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ec7bda825d84eb6f3cb47401cc5bf8f1\";}\";}","no");
INSERT INTO `wp_options` VALUES("216586","_wp_session_expires_536bfb509784af42cafb2a86d0d6dd34","2788955038","no");
INSERT INTO `wp_options` VALUES("216592","_wp_session_6d860425c5c5c6ec8bcda0aa5bb5149d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"171bce90bebd41d056e943924b244f56\";}\";}","no");
INSERT INTO `wp_options` VALUES("216593","_wp_session_expires_6d860425c5c5c6ec8bcda0aa5bb5149d","2788955400","no");
INSERT INTO `wp_options` VALUES("216599","_wp_session_9d40a0a249611e693874fd5e83a836c3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b269e8cc6917cb4b48609e2f2b20d311\";}\";}","no");
INSERT INTO `wp_options` VALUES("216600","_wp_session_expires_9d40a0a249611e693874fd5e83a836c3","2788955710","no");
INSERT INTO `wp_options` VALUES("216602","_wp_session_c580ec0494fe7d4f1cf931cbe7841b82","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b805793eba5303da2bbca87de44eb6a1\";}\";}","no");
INSERT INTO `wp_options` VALUES("216603","_wp_session_expires_c580ec0494fe7d4f1cf931cbe7841b82","2788955916","no");
INSERT INTO `wp_options` VALUES("216605","_wp_session_2cc834b6881030632306b6b1338d7f28","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"32f0ee8e71d9ac83c61e35684051adc7\";}\";}","no");
INSERT INTO `wp_options` VALUES("216606","_wp_session_expires_2cc834b6881030632306b6b1338d7f28","2788956300","no");
INSERT INTO `wp_options` VALUES("216621","_wp_session_dfca6affe30f597ac10537eaa8947893","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5d343078edc2203b186115fb5e11c8bd\";}\";}","no");
INSERT INTO `wp_options` VALUES("216622","_wp_session_expires_dfca6affe30f597ac10537eaa8947893","2788959680","no");
INSERT INTO `wp_options` VALUES("216659","_wp_session_04720f6abc1361c2071e9ccda5bfda4f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b191fa10becf9c47d14ea05ffb2c5e9d\";}\";}","no");
INSERT INTO `wp_options` VALUES("216660","_wp_session_expires_04720f6abc1361c2071e9ccda5bfda4f","2788965040","no");
INSERT INTO `wp_options` VALUES("216673","_wp_session_da1a5c8f10e1bef161dfe3c971427c13","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"870bd42143360b47676e37c1aedefe61\";}\";}","no");
INSERT INTO `wp_options` VALUES("216674","_wp_session_expires_da1a5c8f10e1bef161dfe3c971427c13","2788965834","no");
INSERT INTO `wp_options` VALUES("216699","_wp_session_749200701176411c1ef338313e545a86","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9f26f4dd3be2320eda1a7e9ba8b20801\";}\";}","no");
INSERT INTO `wp_options` VALUES("216700","_wp_session_expires_749200701176411c1ef338313e545a86","2788969456","no");
INSERT INTO `wp_options` VALUES("216706","_wp_session_b88a87f43b63f97297dcb3be08a2e9b4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"aa540bf45123b2c0f96b1cd2953fb517\";}\";}","no");
INSERT INTO `wp_options` VALUES("216707","_wp_session_expires_b88a87f43b63f97297dcb3be08a2e9b4","2788969880","no");
INSERT INTO `wp_options` VALUES("216713","_wp_session_c438bc7a8d9474ba4735b0275bdfb641","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c7e4d0bdf58ea9a2866219ad7258146f\";}\";}","no");
INSERT INTO `wp_options` VALUES("216714","_wp_session_expires_c438bc7a8d9474ba4735b0275bdfb641","2788971374","no");
INSERT INTO `wp_options` VALUES("216860","_wp_session_01b5dc638955c9000fbb325ffa6fb319","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"915ed8a355f390127dd95ee33901e8f6\";}\";}","no");
INSERT INTO `wp_options` VALUES("216861","_wp_session_expires_01b5dc638955c9000fbb325ffa6fb319","2788981166","no");
INSERT INTO `wp_options` VALUES("216867","_wp_session_950f100cddd43782ed03cebe2bdcefa4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"333a7f58e0c5ef7d1c4f16373b042390\";}\";}","no");
INSERT INTO `wp_options` VALUES("216868","_wp_session_expires_950f100cddd43782ed03cebe2bdcefa4","2788982538","no");
INSERT INTO `wp_options` VALUES("216893","_wp_session_3680b61e14bb5b6f31e4638855cb2481","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1af31cf95bcb1b9da2b133349dc21cf6\";}\";}","no");
INSERT INTO `wp_options` VALUES("216894","_wp_session_expires_3680b61e14bb5b6f31e4638855cb2481","2788986546","no");
INSERT INTO `wp_options` VALUES("217021","_wp_session_0014b83cbf3a1db2f47f26321fb2b812","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("217069","_wp_session_expires_eb0b2e374a0638baa5a7349046bb3a77","2789006692","no");
INSERT INTO `wp_options` VALUES("217020","_wp_session_expires_0014b83cbf3a1db2f47f26321fb2b812","2788999792","no");
INSERT INTO `wp_options` VALUES("217068","_wp_session_eb0b2e374a0638baa5a7349046bb3a77","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4f59394ee74c2c194b82d004eaf7413e\";}\";}","no");
INSERT INTO `wp_options` VALUES("217418","_wp_session_94f5204e0f8c1558f298826aeda83d22","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"20b5742ac285379b5e6c3a8cab4c946b\";}\";}","no");
INSERT INTO `wp_options` VALUES("218678","_wp_session_e17464bf8a155d2ba5ba93a2d05444a6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"880af144a4ccc7be1cddf6ba8f475d85\";}\";}","no");
INSERT INTO `wp_options` VALUES("217713","_wp_session_0f38efc759ae174e2c0835d57dea0ff8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"70aa4bd06612db7bdbaf2931986806a9\";}\";}","no");
INSERT INTO `wp_options` VALUES("217714","_wp_session_expires_0f38efc759ae174e2c0835d57dea0ff8","2789110960","no");
INSERT INTO `wp_options` VALUES("217770","_wp_session_16733655026af56eebacc7d92c9ee87c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"400840b497afe84c446f25b13bba4fc3\";}\";}","no");
INSERT INTO `wp_options` VALUES("217771","_wp_session_expires_16733655026af56eebacc7d92c9ee87c","2789120460","no");
INSERT INTO `wp_options` VALUES("217782","_wp_session_29a75d2c013929c751fa938f719129e7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4d4f1f2d2fc71b8450d17d76636b844d\";}\";}","no");
INSERT INTO `wp_options` VALUES("217783","_wp_session_expires_29a75d2c013929c751fa938f719129e7","2789121190","no");
INSERT INTO `wp_options` VALUES("217795","_wp_session_b97c144ee6599e792f31ee166ccea92b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b41f2602caf73089a95b680a66763cb5\";}\";}","no");
INSERT INTO `wp_options` VALUES("217796","_wp_session_expires_b97c144ee6599e792f31ee166ccea92b","2789122482","no");
INSERT INTO `wp_options` VALUES("217801","_wp_session_91b0a70c4fb3b090f6d135b71dac3ecd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fcc7008eb3e8e389abc758850eaef34f\";}\";}","no");
INSERT INTO `wp_options` VALUES("217802","_wp_session_expires_91b0a70c4fb3b090f6d135b71dac3ecd","2789123722","no");
INSERT INTO `wp_options` VALUES("217930","_wp_session_fed37cbed2b0faf26de53fbe3a69ad37","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e786cac597a266519150517ddbbc2b46\";}\";}","no");
INSERT INTO `wp_options` VALUES("217931","_wp_session_expires_fed37cbed2b0faf26de53fbe3a69ad37","2789134650","no");
INSERT INTO `wp_options` VALUES("218111","_wp_session_3ab1c35414998f162298933db03e4088","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"28757a1df7f4f14c125b9e20145331b2\";}\";}","no");
INSERT INTO `wp_options` VALUES("218112","_wp_session_expires_3ab1c35414998f162298933db03e4088","2789155762","no");
INSERT INTO `wp_options` VALUES("218158","_wp_session_7043f1068b759eaa44b4bd16d18aea9a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"007cf6b8e4b7316aa34b61a0a28c69c5\";}\";}","no");
INSERT INTO `wp_options` VALUES("218159","_wp_session_expires_7043f1068b759eaa44b4bd16d18aea9a","2789160248","no");
INSERT INTO `wp_options` VALUES("218164","_wp_session_c93392c6156f1ee672844408ca87d48d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"95ad1bb71fdad663a3e0ff556d617427\";}\";}","no");
INSERT INTO `wp_options` VALUES("218165","_wp_session_expires_c93392c6156f1ee672844408ca87d48d","2789161310","no");
INSERT INTO `wp_options` VALUES("218184","_wp_session_c4d9004e775fefbf2e91f91d36088628","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9b74de7e6c1fb6c4953011b7611a9627\";}\";}","no");
INSERT INTO `wp_options` VALUES("218185","_wp_session_expires_c4d9004e775fefbf2e91f91d36088628","2789163794","no");
INSERT INTO `wp_options` VALUES("218199","_wp_session_673870646e0aaf0400c217cba74d4939","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1e30a2a1adfced035a3a2d367b153a67\";}\";}","no");
INSERT INTO `wp_options` VALUES("218200","_wp_session_expires_673870646e0aaf0400c217cba74d4939","2789166828","no");
INSERT INTO `wp_options` VALUES("218214","_wp_session_8190281a173f68323b18daffd5a421c7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"168da7fa028e2dddcfcfb30f49d5ef53\";}\";}","no");
INSERT INTO `wp_options` VALUES("218215","_wp_session_expires_8190281a173f68323b18daffd5a421c7","2789169746","no");
INSERT INTO `wp_options` VALUES("218460","_wp_session_80d1857247233d4d1c1453bf639bf8fe","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"24bcd4338ff38583051b64dc9518c1f9\";}\";}","no");
INSERT INTO `wp_options` VALUES("218461","_wp_session_expires_80d1857247233d4d1c1453bf639bf8fe","2789177372","no");
INSERT INTO `wp_options` VALUES("218573","_wp_session_19f3efc9c81a1d859d068f98e09565ce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"052aaa43ae94802d347c07c994638ef4\";}\";}","no");
INSERT INTO `wp_options` VALUES("218574","_wp_session_expires_19f3efc9c81a1d859d068f98e09565ce","2789194836","no");
INSERT INTO `wp_options` VALUES("218577","_wp_session_expires_14ec12d20ead8b57aefa325120a76dee","2789194844","no");
INSERT INTO `wp_options` VALUES("218579","_wp_session_0253cbae7f3272bbcdd1ad34e554ad7d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1fa845da151903ffd5ad7cae0ac40b7d\";}\";}","no");
INSERT INTO `wp_options` VALUES("218580","_wp_session_expires_0253cbae7f3272bbcdd1ad34e554ad7d","2789194884","no");
INSERT INTO `wp_options` VALUES("218588","_wp_session_09842ec95756f58d3915ebc296af97db","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3a8b00ae26761b62a620494c05f30c0d\";}\";}","no");
INSERT INTO `wp_options` VALUES("218589","_wp_session_expires_09842ec95756f58d3915ebc296af97db","2789195746","no");
INSERT INTO `wp_options` VALUES("218611","_wp_session_bbe774b0f94f7c100d079ae4c7fa73a5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2bd5e524af741c74c106943bab03f948\";}\";}","no");
INSERT INTO `wp_options` VALUES("218612","_wp_session_expires_bbe774b0f94f7c100d079ae4c7fa73a5","2789197106","no");
INSERT INTO `wp_options` VALUES("218670","_wp_session_c76bcdb942e2d21e8488d6269c81d540","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ac43552735810aae8a246c3a64638498\";}\";}","no");
INSERT INTO `wp_options` VALUES("219554","_wp_session_9fa5c70e2cf454eb67d0879e48ee9fa8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9a19a8227d66abb592fad08c53babc2f\";}\";}","no");
INSERT INTO `wp_options` VALUES("219555","_wp_session_expires_9fa5c70e2cf454eb67d0879e48ee9fa8","2789298318","no");
INSERT INTO `wp_options` VALUES("219557","_wp_session_50d22794dc2c29a88966b77dc8b7fa58","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b805a4a8ff3d281532e10ac9b5279d10\";}\";}","no");
INSERT INTO `wp_options` VALUES("218682","_wp_session_eaae7b9b7990fa2ac9817d0d4986e90b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"45b7c77fb6c0bbbb080804e25390a9cc\";}\";}","no");
INSERT INTO `wp_options` VALUES("218683","_wp_session_expires_eaae7b9b7990fa2ac9817d0d4986e90b","2789199490","no");
INSERT INTO `wp_options` VALUES("218688","_wp_session_d2d098b43029a83c1defb0eb97b6488c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5c297b611bc14af638cf4065c76ae24a\";}\";}","no");
INSERT INTO `wp_options` VALUES("218689","_wp_session_expires_d2d098b43029a83c1defb0eb97b6488c","2789199754","no");
INSERT INTO `wp_options` VALUES("218701","_wp_session_dbaf0c66fe54adfe7798a813fb6d5dc3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b5cf9d5e62a396a7676dace217cfd226\";}\";}","no");
INSERT INTO `wp_options` VALUES("218702","_wp_session_expires_dbaf0c66fe54adfe7798a813fb6d5dc3","2789201010","no");
INSERT INTO `wp_options` VALUES("222023","_wp_session_cdce76fee9a14f6788a963ca79561280","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9d4e8bf93588bcb9578ae397824bf607\";}\";}","no");
INSERT INTO `wp_options` VALUES("222024","_wp_session_expires_cdce76fee9a14f6788a963ca79561280","2789615848","no");
INSERT INTO `wp_options` VALUES("222028","_wp_session_95d7d5c381061594369ce0f84473b3db","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"602d7aa9bfd0d58d923e74bf8749e6c5\";}\";}","no");
INSERT INTO `wp_options` VALUES("222029","_wp_session_expires_95d7d5c381061594369ce0f84473b3db","2789616150","no");
INSERT INTO `wp_options` VALUES("222064","_wp_session_4419e4ae498c580373ed68ea34ffd694","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7e33313fd4afbbcb17dbf5e70303e7c0\";}\";}","no");
INSERT INTO `wp_options` VALUES("223185","_wp_session_381e532097822d124b0a3327d02b0afd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d340fc5f7f66c285ae8d591c43a4ebda\";}\";}","no");
INSERT INTO `wp_options` VALUES("223186","_wp_session_expires_381e532097822d124b0a3327d02b0afd","2789752906","no");
INSERT INTO `wp_options` VALUES("223288","_wp_session_af92e5d48b02525c034098021b3505fc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e14005b7838f865178c62a4106be4fd7\";}\";}","no");
INSERT INTO `wp_options` VALUES("222065","_wp_session_expires_4419e4ae498c580373ed68ea34ffd694","2789621808","no");
INSERT INTO `wp_options` VALUES("222068","_wp_session_3b87b3d3e4eb172995e038b53cb6ff7a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6a35454db464c5677e0429bfae9068bf\";}\";}","no");
INSERT INTO `wp_options` VALUES("222069","_wp_session_expires_3b87b3d3e4eb172995e038b53cb6ff7a","2789622644","no");
INSERT INTO `wp_options` VALUES("222145","_wp_session_bbf67f225a6aaacfe0992f87f3120d02","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dca0c6e25fd420ed21d8aa9dbfa57f80\";}\";}","no");
INSERT INTO `wp_options` VALUES("222146","_wp_session_expires_bbf67f225a6aaacfe0992f87f3120d02","2789632056","no");
INSERT INTO `wp_options` VALUES("222325","_wp_session_expires_4ba998e10152ed1de10f20cf45db5de6","2789649800","no");
INSERT INTO `wp_options` VALUES("222331","_wp_session_febeab5a0c9f7170a4b10e5e4cd17313","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dc7ebd58560c5496da533f1cab405d80\";}\";}","no");
INSERT INTO `wp_options` VALUES("222332","_wp_session_expires_febeab5a0c9f7170a4b10e5e4cd17313","2789649906","no");
INSERT INTO `wp_options` VALUES("222335","_wp_session_158dcb353b0dcd79dbefd5bef94de517","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"20d36c8ab23433d91220364e1fc4928c\";}\";}","no");
INSERT INTO `wp_options` VALUES("222336","_wp_session_expires_158dcb353b0dcd79dbefd5bef94de517","2789649970","no");
INSERT INTO `wp_options` VALUES("222338","_wp_session_7568249255e40d61fdd2c7e77d90b541","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ef9cb42c731a28610e009c531b904de5\";}\";}","no");
INSERT INTO `wp_options` VALUES("222339","_wp_session_expires_7568249255e40d61fdd2c7e77d90b541","2789650054","no");
INSERT INTO `wp_options` VALUES("222341","_wp_session_99abf5b664d0bc500a608c565a5b7db5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"08d7d80f73fa0c06b9962a99540eed61\";}\";}","no");
INSERT INTO `wp_options` VALUES("222342","_wp_session_expires_99abf5b664d0bc500a608c565a5b7db5","2789650186","no");
INSERT INTO `wp_options` VALUES("222344","_wp_session_4e9d08c0ac96b5ef0a62cd8bec17fca9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0be326d5a75afa767d1311208f994d1c\";}\";}","no");
INSERT INTO `wp_options` VALUES("222345","_wp_session_expires_4e9d08c0ac96b5ef0a62cd8bec17fca9","2789650222","no");
INSERT INTO `wp_options` VALUES("222348","_wp_session_8fd33aa43b96b272b62cabb97bf49187","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b1a95390cf6c33db6365e066d0514c18\";}\";}","no");
INSERT INTO `wp_options` VALUES("222349","_wp_session_expires_8fd33aa43b96b272b62cabb97bf49187","2789650334","no");
INSERT INTO `wp_options` VALUES("222351","_wp_session_b2c9b1fbca1bc0e5913be74f836b642c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e2f07a3f7d3bc489c4287f4b6f395fc2\";}\";}","no");
INSERT INTO `wp_options` VALUES("222352","_wp_session_expires_b2c9b1fbca1bc0e5913be74f836b642c","2789650354","no");
INSERT INTO `wp_options` VALUES("222354","_wp_session_7924b76de41ce372c829d4fbf7a157be","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d2e82ce2cd59a9b112643504338859ed\";}\";}","no");
INSERT INTO `wp_options` VALUES("222355","_wp_session_expires_7924b76de41ce372c829d4fbf7a157be","2789650682","no");
INSERT INTO `wp_options` VALUES("222360","_wp_session_300f4cc12fa4b9ef5462037d53b2a611","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dc2cba4360efdfc23810a732ed51cdc8\";}\";}","no");
INSERT INTO `wp_options` VALUES("222361","_wp_session_expires_300f4cc12fa4b9ef5462037d53b2a611","2789650930","no");
INSERT INTO `wp_options` VALUES("222392","_wp_session_092deaf44da0bfe826f4fa9431582fd9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9d29dc58514094f4de5e9cea911802b0\";}\";}","no");
INSERT INTO `wp_options` VALUES("222393","_wp_session_expires_092deaf44da0bfe826f4fa9431582fd9","2789656352","no");
INSERT INTO `wp_options` VALUES("222409","_wp_session_8b3cc167a80a19206eaedee8967ed8c9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1e0f45bee809a5fbf043f884260ab6ce\";}\";}","no");
INSERT INTO `wp_options` VALUES("222410","_wp_session_expires_8b3cc167a80a19206eaedee8967ed8c9","2789659554","no");
INSERT INTO `wp_options` VALUES("222457","_wp_session_042bd1432c7c74675b56923bf82f3b09","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"750700f760632fec96a8f5e27daaae77\";}\";}","no");
INSERT INTO `wp_options` VALUES("222458","_wp_session_expires_042bd1432c7c74675b56923bf82f3b09","2789662152","no");
INSERT INTO `wp_options` VALUES("222462","_wp_session_f14bcc431a30040698f1f67e28011d22","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"75b8748a26a0993226bc4cfe7b7a8b58\";}\";}","no");
INSERT INTO `wp_options` VALUES("222463","_wp_session_expires_f14bcc431a30040698f1f67e28011d22","2789662358","no");
INSERT INTO `wp_options` VALUES("222528","_wp_session_366574615d85eb63b1ca8167df06fceb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6e4783d8414c2e23e08a1358beddd6fe\";}\";}","no");
INSERT INTO `wp_options` VALUES("222529","_wp_session_expires_366574615d85eb63b1ca8167df06fceb","2789674182","no");
INSERT INTO `wp_options` VALUES("222552","_wp_session_029b5c11653ea1e79be8ab6e97e230ee","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5e622044139b05b40829f558d99b8b4c\";}\";}","no");
INSERT INTO `wp_options` VALUES("222553","_wp_session_expires_029b5c11653ea1e79be8ab6e97e230ee","2789677368","no");
INSERT INTO `wp_options` VALUES("222581","_wp_session_ebfcf26f3d36a92f545cfd885a1f6148","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"033c11f50d27ed3823dd708ae14eadef\";}\";}","no");
INSERT INTO `wp_options` VALUES("222582","_wp_session_expires_ebfcf26f3d36a92f545cfd885a1f6148","2789679104","no");
INSERT INTO `wp_options` VALUES("222765","_wp_session_expires_9c9b79b97a839d3fed06f4134f5e02ed","2789708594","no");
INSERT INTO `wp_options` VALUES("223441","_wp_session_28286a84afd8323e1aaaf6f9e6ec4f66","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6e489f51de630bac84f9b701999f3ffe\";}\";}","no");
INSERT INTO `wp_options` VALUES("223442","_wp_session_expires_28286a84afd8323e1aaaf6f9e6ec4f66","2789804530","no");
INSERT INTO `wp_options` VALUES("223536","_wp_session_d7fca8afd2d5f7cfb846a8fbffed3b2d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"372254402c4e140cd7a6d88f4d4b9424\";}\";}","no");
INSERT INTO `wp_options` VALUES("222769","_wp_session_expires_64477de7019e029c588c7682ab517014","2789708752","no");
INSERT INTO `wp_options` VALUES("222767","_wp_session_expires_d82f8b4c6cd7b6a993868d724de66036","2789708610","no");
INSERT INTO `wp_options` VALUES("222771","_wp_session_expires_fd6a87b45b051e39c62230f7414201ea","2789708812","no");
INSERT INTO `wp_options` VALUES("222773","_wp_session_expires_fc3e5d66b6671e22862fba07e0b839e6","2789708828","no");
INSERT INTO `wp_options` VALUES("222775","_wp_session_expires_a901c8ea2a3ecc751611085f88ffbc35","2789708858","no");
INSERT INTO `wp_options` VALUES("222777","_wp_session_expires_269d39cecee350a939698cfc8691efef","2789708952","no");
INSERT INTO `wp_options` VALUES("223005","_wp_session_98879934166ec7d2a16be14f570a51f8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cb29d243c09e3e83f0542f7ffdfb37c8\";}\";}","no");
INSERT INTO `wp_options` VALUES("223006","_wp_session_expires_98879934166ec7d2a16be14f570a51f8","2789731938","no");
INSERT INTO `wp_options` VALUES("223289","_wp_session_expires_af92e5d48b02525c034098021b3505fc","2789774496","no");
INSERT INTO `wp_options` VALUES("223398","_wp_session_e3ddf1de8220b1c55c92a2845d110de3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1cad134fb8e5886172b2abc4e9341fd5\";}\";}","no");
INSERT INTO `wp_options` VALUES("224481","_wp_session_expires_2f515c5e0b823c3449b2422f018e5506","2789918576","no");
INSERT INTO `wp_options` VALUES("224533","_wp_session_06d6e3378e40e9c46dd6dfe3cd81b569","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"11ef894d3c812ecd6d32a899b686932c\";}\";}","no");
INSERT INTO `wp_options` VALUES("224534","_wp_session_expires_06d6e3378e40e9c46dd6dfe3cd81b569","2789919912","no");
INSERT INTO `wp_options` VALUES("223399","_wp_session_expires_e3ddf1de8220b1c55c92a2845d110de3","2789799308","no");
INSERT INTO `wp_options` VALUES("223403","_wp_session_6cf03d51bba3bc164421f9ffa95a7348","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"43bd28b36f82eeb5c5d742a2c3c538e8\";}\";}","no");
INSERT INTO `wp_options` VALUES("223404","_wp_session_expires_6cf03d51bba3bc164421f9ffa95a7348","2789800824","no");
INSERT INTO `wp_options` VALUES("223431","_wp_session_0ef896b2c52cd9b3495fcac87331ef25","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b454ed2df062212d64faba894b829f0f\";}\";}","no");
INSERT INTO `wp_options` VALUES("223432","_wp_session_expires_0ef896b2c52cd9b3495fcac87331ef25","2789804084","no");
INSERT INTO `wp_options` VALUES("223537","_wp_session_expires_d7fca8afd2d5f7cfb846a8fbffed3b2d","2789819746","no");
INSERT INTO `wp_options` VALUES("223555","_wp_session_68f9081ef3ba891f6a3736181db81097","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"40f76e4b7cb0d1fefca3d55799420081\";}\";}","no");
INSERT INTO `wp_options` VALUES("223556","_wp_session_expires_68f9081ef3ba891f6a3736181db81097","2789824406","no");
INSERT INTO `wp_options` VALUES("223696","_wp_session_f0cd79d7c5b8130c34b8d4abd891dd65","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8b28556de80ff6a82d70258c35e679b2\";}\";}","no");
INSERT INTO `wp_options` VALUES("223697","_wp_session_expires_f0cd79d7c5b8130c34b8d4abd891dd65","2789841078","no");
INSERT INTO `wp_options` VALUES("223712","_wp_session_8f0d9ec26d7dc285fb6588f78f31a793","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c0878ca8be5e049a09df0f24326370df\";}\";}","no");
INSERT INTO `wp_options` VALUES("223713","_wp_session_expires_8f0d9ec26d7dc285fb6588f78f31a793","2789843882","no");
INSERT INTO `wp_options` VALUES("223744","_wp_session_a4bd6d0ed27c617710478baaf72f4b31","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8f45293271e47673dfad491547217ee1\";}\";}","no");
INSERT INTO `wp_options` VALUES("223745","_wp_session_expires_a4bd6d0ed27c617710478baaf72f4b31","2789848482","no");
INSERT INTO `wp_options` VALUES("223747","_wp_session_e817591527f34df2a71732310b6e5b60","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7f8ee2e05f650ac8a2ae84e50e18d5bb\";}\";}","no");
INSERT INTO `wp_options` VALUES("223748","_wp_session_expires_e817591527f34df2a71732310b6e5b60","2789849062","no");
INSERT INTO `wp_options` VALUES("223751","_wp_session_cd2e08fc59dd5de4bfba31b4cd1af059","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6801140b8ad6871dfa810afb56f4bbae\";}\";}","no");
INSERT INTO `wp_options` VALUES("223752","_wp_session_expires_cd2e08fc59dd5de4bfba31b4cd1af059","2789850574","no");
INSERT INTO `wp_options` VALUES("223761","_wp_session_19d86747187097a0a8a47393d501f428","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7745b10c95b0437683a1d904a36ac5b5\";}\";}","no");
INSERT INTO `wp_options` VALUES("223762","_wp_session_expires_19d86747187097a0a8a47393d501f428","2789852072","no");
INSERT INTO `wp_options` VALUES("223792","_wp_session_157f6b06bf1785c4e8c0f6aa144473e5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0b0ab0224a0eba2b2303d4ef212b206e\";}\";}","no");
INSERT INTO `wp_options` VALUES("223793","_wp_session_expires_157f6b06bf1785c4e8c0f6aa144473e5","2789856532","no");
INSERT INTO `wp_options` VALUES("223841","_wp_session_887e1a858c61d2f84d02e24cd420c327","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"09019a60b4025ef50f23fc768b9c6661\";}\";}","no");
INSERT INTO `wp_options` VALUES("223842","_wp_session_expires_887e1a858c61d2f84d02e24cd420c327","2789862172","no");
INSERT INTO `wp_options` VALUES("223850","_wp_session_42aee220f51283e324e792e493b13289","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8a9f9819c0ffe045ca25eaeba5749855\";}\";}","no");
INSERT INTO `wp_options` VALUES("223851","_wp_session_expires_42aee220f51283e324e792e493b13289","2789863126","no");
INSERT INTO `wp_options` VALUES("223897","_wp_session_0dbce939ded441a1e9cd35738d7dcd4e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8f0cd912881b07927a879d78e9baec15\";}\";}","no");
INSERT INTO `wp_options` VALUES("223898","_wp_session_expires_0dbce939ded441a1e9cd35738d7dcd4e","2789871132","no");
INSERT INTO `wp_options` VALUES("223948","_wp_session_2f528f7b43663da7bd799a7a34190ca4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f4f7a5ca09d75d4b30d03f54074420ad\";}\";}","no");
INSERT INTO `wp_options` VALUES("225003","_wp_session_cca76e387f98936bf0b201223ff5cb12","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"05d72f1967f1262f59ffe7f585e27c96\";}\";}","no");
INSERT INTO `wp_options` VALUES("225004","_wp_session_expires_cca76e387f98936bf0b201223ff5cb12","2789992118","no");
INSERT INTO `wp_options` VALUES("225040","_wp_session_7cc54f04b6c6e35454c6eeae749bfcad","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"08910be5f79aa8357adab671f50e0a2e\";}\";}","no");
INSERT INTO `wp_options` VALUES("225041","_wp_session_expires_7cc54f04b6c6e35454c6eeae749bfcad","2790000960","no");
INSERT INTO `wp_options` VALUES("225111","_wp_session_d72f870be829ab55c6be596c62c0913e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1d4d4c2a6877f0b4fe1067c50d92fb75\";}\";}","no");
INSERT INTO `wp_options` VALUES("223949","_wp_session_expires_2f528f7b43663da7bd799a7a34190ca4","2789877598","no");
INSERT INTO `wp_options` VALUES("223953","_wp_session_585fac7ad02f3f80efc61d896a3f5742","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fbcb881eedd81a23eed7e36e80b2b3f2\";}\";}","no");
INSERT INTO `wp_options` VALUES("223954","_wp_session_expires_585fac7ad02f3f80efc61d896a3f5742","2789878866","no");
INSERT INTO `wp_options` VALUES("227883","_wp_session_expires_cd767cae2d80cc66f5266b8f987e05e5","2790362064","no");
INSERT INTO `wp_options` VALUES("224134","_wp_session_5f0c71a716b5905b3a8cee419f8920a3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9dadab2cdb27628bd291f1ecf4256312\";}\";}","no");
INSERT INTO `wp_options` VALUES("224135","_wp_session_expires_5f0c71a716b5905b3a8cee419f8920a3","2789902868","no");
INSERT INTO `wp_options` VALUES("224540","_wp_session_f34f5411c615b6b3de38d0358174bc54","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"edd634ff3c19c143636173f27a1b05b0\";}\";}","no");
INSERT INTO `wp_options` VALUES("224541","_wp_session_expires_f34f5411c615b6b3de38d0358174bc54","2789919968","no");
INSERT INTO `wp_options` VALUES("224543","_wp_session_b0ba19654bb9a80d016cb2c0a2d1aa3e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a1d926ed4c1d42a910ea8f093fc58da1\";}\";}","no");
INSERT INTO `wp_options` VALUES("224544","_wp_session_expires_b0ba19654bb9a80d016cb2c0a2d1aa3e","2789920026","no");
INSERT INTO `wp_options` VALUES("224550","_wp_session_cfad32d9b2a2f632caa0cd7071d288be","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e218193c7c41e2d45d0a0e95ef1fdd84\";}\";}","no");
INSERT INTO `wp_options` VALUES("224551","_wp_session_expires_cfad32d9b2a2f632caa0cd7071d288be","2789921678","no");
INSERT INTO `wp_options` VALUES("224771","_wp_session_ec8294e2b4cc9dce76dcbdd83146f835","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"375590beda84b005f1a84fc7f366a37d\";}\";}","no");
INSERT INTO `wp_options` VALUES("224772","_wp_session_expires_ec8294e2b4cc9dce76dcbdd83146f835","2789956296","no");
INSERT INTO `wp_options` VALUES("224783","_wp_session_de83cc2f1bc5ff25c5f9012c6c4442f9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c8777879f7ae47a0246ae246d0c7b81a\";}\";}","no");
INSERT INTO `wp_options` VALUES("224784","_wp_session_expires_de83cc2f1bc5ff25c5f9012c6c4442f9","2789958316","no");
INSERT INTO `wp_options` VALUES("224976","_wp_session_70c406fd2c9ee7b938567d15e09a1474","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"bd7d3875c103ea4896c321b43839e414\";}\";}","no");
INSERT INTO `wp_options` VALUES("225925","_wp_session_adf409df855f5bd173644821b6b3f529","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2afed62a2672e39df94833c5bc602d1b\";}\";}","no");
INSERT INTO `wp_options` VALUES("225926","_wp_session_expires_adf409df855f5bd173644821b6b3f529","2790101144","no");
INSERT INTO `wp_options` VALUES("225928","_wp_session_e2c0d29bbbd7dcf14de22cfae6472605","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"339f742acb006ce1928ccfc12802f12d\";}\";}","no");
INSERT INTO `wp_options` VALUES("225929","_wp_session_expires_e2c0d29bbbd7dcf14de22cfae6472605","2790101150","no");
INSERT INTO `wp_options` VALUES("225953","_wp_session_a074ae226d599697fa5c2e7ad88eb2b7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"58e8940b09e441857d66036dc21348ce\";}\";}","no");
INSERT INTO `wp_options` VALUES("224977","_wp_session_expires_70c406fd2c9ee7b938567d15e09a1474","2789989300","no");
INSERT INTO `wp_options` VALUES("225112","_wp_session_expires_d72f870be829ab55c6be596c62c0913e","2790008114","no");
INSERT INTO `wp_options` VALUES("225239","_wp_session_21def2a276201d7654aedc466bbd29c7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e6d5f1c5a0191ffbc1aae184bb77dd2b\";}\";}","no");
INSERT INTO `wp_options` VALUES("225240","_wp_session_expires_21def2a276201d7654aedc466bbd29c7","2790018322","no");
INSERT INTO `wp_options` VALUES("226360","_wp_session_216a970dc25f0221cfbdbee36aea67df","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b1c84b2e53fa189174ee8d93f4230e51\";}\";}","no");
INSERT INTO `wp_options` VALUES("226361","_wp_session_expires_216a970dc25f0221cfbdbee36aea67df","2790162878","no");
INSERT INTO `wp_options` VALUES("226365","_wp_session_551846c13c6668504b7c4cf477166391","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8746397b0277dca7c6b500f18548ff61\";}\";}","no");
INSERT INTO `wp_options` VALUES("226366","_wp_session_expires_551846c13c6668504b7c4cf477166391","2790162976","no");
INSERT INTO `wp_options` VALUES("226372","_wp_session_df01149a35319fbf8292e7de072e7130","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"53e67381250139aaddd52951b7759664\";}\";}","no");
INSERT INTO `wp_options` VALUES("225461","_wp_session_9a1c502134df765e75e8bf9458248aae","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"26e4ffefa359c19bd561f1d99e71bb04\";}\";}","no");
INSERT INTO `wp_options` VALUES("225462","_wp_session_expires_9a1c502134df765e75e8bf9458248aae","2790051382","no");
INSERT INTO `wp_options` VALUES("225710","_wp_session_afc042318763a7f9b5f8c488641c55ec","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2b68af63f172fd2546a5121029ee743e\";}\";}","no");
INSERT INTO `wp_options` VALUES("225711","_wp_session_expires_afc042318763a7f9b5f8c488641c55ec","2790072198","no");
INSERT INTO `wp_options` VALUES("225954","_wp_session_expires_a074ae226d599697fa5c2e7ad88eb2b7","2790105328","no");
INSERT INTO `wp_options` VALUES("225956","_wp_session_eb76a70db4913eee286858bc306365f7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ae00784517bd3cd0982afd460da27675\";}\";}","no");
INSERT INTO `wp_options` VALUES("225957","_wp_session_expires_eb76a70db4913eee286858bc306365f7","2790105336","no");
INSERT INTO `wp_options` VALUES("226203","_wp_session_09b3b504f4b7c8cf30bcf16b13db4f2b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d1cee7fc090b24d8cdfad31ee9d031c7\";}\";}","no");
INSERT INTO `wp_options` VALUES("227245","_wp_session_ddadc871c13f1632f0fed58c505ba7fa","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3ce83428ea42730f7f31b483970abe1d\";}\";}","no");
INSERT INTO `wp_options` VALUES("227246","_wp_session_expires_ddadc871c13f1632f0fed58c505ba7fa","2790273596","no");
INSERT INTO `wp_options` VALUES("227248","_wp_session_bfbe3e9093790772152ce626b9fcb4fb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5537e92c685369827428b2fe3a86e91d\";}\";}","no");
INSERT INTO `wp_options` VALUES("227249","_wp_session_expires_bfbe3e9093790772152ce626b9fcb4fb","2790273608","no");
INSERT INTO `wp_options` VALUES("226204","_wp_session_expires_09b3b504f4b7c8cf30bcf16b13db4f2b","2790140766","no");
INSERT INTO `wp_options` VALUES("226207","_wp_session_1c44e8b10d9e743cc3079f9fa4551efb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"104df4a38a2f927424a0e8bda9e18e3f\";}\";}","no");
INSERT INTO `wp_options` VALUES("226208","_wp_session_expires_1c44e8b10d9e743cc3079f9fa4551efb","2790141308","no");
INSERT INTO `wp_options` VALUES("226221","_wp_session_e04b71cdd78bcb3921b3564ea8bcbbda","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"864b06a6abf1ce12a4332d8d85cc47a5\";}\";}","no");
INSERT INTO `wp_options` VALUES("226222","_wp_session_expires_e04b71cdd78bcb3921b3564ea8bcbbda","2790143390","no");
INSERT INTO `wp_options` VALUES("226233","_wp_session_bf0fca54015311775363c000cf0ff007","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5157781ab1819c6e493e915be2a019ac\";}\";}","no");
INSERT INTO `wp_options` VALUES("226234","_wp_session_expires_bf0fca54015311775363c000cf0ff007","2790144336","no");
INSERT INTO `wp_options` VALUES("226319","_wp_session_40bdeedc09c0bb530696d7d71b657afb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cc60bb93236339b779aac78afbf7a523\";}\";}","no");
INSERT INTO `wp_options` VALUES("226320","_wp_session_expires_40bdeedc09c0bb530696d7d71b657afb","2790157014","no");
INSERT INTO `wp_options` VALUES("226373","_wp_session_expires_df01149a35319fbf8292e7de072e7130","2790163652","no");
INSERT INTO `wp_options` VALUES("226375","_wp_session_1dbcfbf2f0a243b01e902a9534500183","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4dc46d9f2007726267f05c535e4d3d64\";}\";}","no");
INSERT INTO `wp_options` VALUES("226376","_wp_session_expires_1dbcfbf2f0a243b01e902a9534500183","2790163888","no");
INSERT INTO `wp_options` VALUES("226378","_wp_session_82fa0866de14e0cc35968106e96ddf84","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d1a10c81c68b9419cf605764e4d36f6f\";}\";}","no");
INSERT INTO `wp_options` VALUES("226379","_wp_session_expires_82fa0866de14e0cc35968106e96ddf84","2790164184","no");
INSERT INTO `wp_options` VALUES("226386","_wp_session_2a041aa19b50fdc500e861e3fceaab2a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e9cac6487adeaaab3d860e421aa8a82b\";}\";}","no");
INSERT INTO `wp_options` VALUES("226387","_wp_session_expires_2a041aa19b50fdc500e861e3fceaab2a","2790165150","no");
INSERT INTO `wp_options` VALUES("226421","_wp_session_e34aeb246f15dcee7f6cd5431ef70edd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9cd741b4672c1a8155b5acc888504d23\";}\";}","no");
INSERT INTO `wp_options` VALUES("226422","_wp_session_expires_e34aeb246f15dcee7f6cd5431ef70edd","2790172716","no");
INSERT INTO `wp_options` VALUES("226433","_wp_session_dfb20f8c6576117290391036f59307fb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7b7df64660395bf6b4376b0b783a12ce\";}\";}","no");
INSERT INTO `wp_options` VALUES("226434","_wp_session_expires_dfb20f8c6576117290391036f59307fb","2790174036","no");
INSERT INTO `wp_options` VALUES("226443","_wp_session_8049f3abe214aeec62a76f93995db802","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"18059aa943175f35bee0ad563e285520\";}\";}","no");
INSERT INTO `wp_options` VALUES("226444","_wp_session_expires_8049f3abe214aeec62a76f93995db802","2790174716","no");
INSERT INTO `wp_options` VALUES("226463","_wp_session_902ade15f64888c6d87ea8a5b1a4a349","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2d3f4afbe6d2e18f72c497484df2b2fa\";}\";}","no");
INSERT INTO `wp_options` VALUES("226464","_wp_session_expires_902ade15f64888c6d87ea8a5b1a4a349","2790175568","no");
INSERT INTO `wp_options` VALUES("226483","_wp_session_efbd91517fead1a1a03539a7ac14d4f6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"07fc6177d2c6c3cc86c24e28ca701a0c\";}\";}","no");
INSERT INTO `wp_options` VALUES("226484","_wp_session_expires_efbd91517fead1a1a03539a7ac14d4f6","2790178722","no");
INSERT INTO `wp_options` VALUES("226576","_wp_session_844d0f86d384c694d6def65f9bf4793a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e67f1d645c76cd7de0cfeee89e993dd7\";}\";}","no");
INSERT INTO `wp_options` VALUES("226577","_wp_session_expires_844d0f86d384c694d6def65f9bf4793a","2790184800","no");
INSERT INTO `wp_options` VALUES("226616","_wp_session_32777f203d487aa1453df2d5bccd1ea4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cb09bab515abc597e7d079b44c55020b\";}\";}","no");
INSERT INTO `wp_options` VALUES("226617","_wp_session_expires_32777f203d487aa1453df2d5bccd1ea4","2790186476","no");
INSERT INTO `wp_options` VALUES("226648","_wp_session_2226fcd6bd0e251fa9d8efd2b4fa98ab","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"65dae77484e755140101ced48e2b4673\";}\";}","no");
INSERT INTO `wp_options` VALUES("226649","_wp_session_expires_2226fcd6bd0e251fa9d8efd2b4fa98ab","2790190692","no");
INSERT INTO `wp_options` VALUES("226694","_wp_session_8c73e89555fefab7836de067a199885e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3b701af5a7ae41b558be9c467d021fc2\";}\";}","no");
INSERT INTO `wp_options` VALUES("226695","_wp_session_expires_8c73e89555fefab7836de067a199885e","2790197490","no");
INSERT INTO `wp_options` VALUES("226702","_wp_session_3589993e38f293a9a458f7ad46d4553a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"41b483d9f4879bc56feef23484b98393\";}\";}","no");
INSERT INTO `wp_options` VALUES("226703","_wp_session_expires_3589993e38f293a9a458f7ad46d4553a","2790199802","no");
INSERT INTO `wp_options` VALUES("226927","_wp_session_expires_00c8a7a7450ff0d20e10eeee7b1f66ab","2790226168","no");
INSERT INTO `wp_options` VALUES("233220","_wp_session_dbd04b92bcfbee7f22e4ac4a1040b649","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f322f866b18eaffda684f51908cc8201\";}\";}","no");
INSERT INTO `wp_options` VALUES("227744","_wp_session_expires_6b4d115c1dbf45ae3ba266f6d26c48d2","2790343894","no");
INSERT INTO `wp_options` VALUES("230845","_wp_session_86c017e5cb96491d2a157081feb52265","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f0b91f668de200cf18603f20c03ff68e\";}\";}","no");
INSERT INTO `wp_options` VALUES("227734","_wp_session_ba29e5d24ff2a2fa6a9ddba9faf30128","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6dd157dc01b07b87dd7dc4a1c88038b1\";}\";}","no");
INSERT INTO `wp_options` VALUES("227735","_wp_session_expires_ba29e5d24ff2a2fa6a9ddba9faf30128","2790342830","no");
INSERT INTO `wp_options` VALUES("227763","_wp_session_f1fceea819836a6bf8473b1a38f26fce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2e1335d5dc9c930328b9301d97e887fd\";}\";}","no");
INSERT INTO `wp_options` VALUES("227764","_wp_session_expires_f1fceea819836a6bf8473b1a38f26fce","2790345512","no");
INSERT INTO `wp_options` VALUES("226931","_wp_session_expires_0a493e0e278fe79dbfad034ce9010f9c","2790226298","no");
INSERT INTO `wp_options` VALUES("226929","_wp_session_expires_d9f8e065f9fd69389b0a8993e51c84cd","2790226294","no");
INSERT INTO `wp_options` VALUES("226933","_wp_session_expires_e25dde62bb818f2e2cdd0bce60d34e83","2790226304","no");
INSERT INTO `wp_options` VALUES("226935","_wp_session_expires_8da6eff6f9f3f3cf28bc27f6e9911a02","2790226308","no");
INSERT INTO `wp_options` VALUES("226937","_wp_session_expires_01782c4fe5a303ac8f194545ed52b313","2790226314","no");
INSERT INTO `wp_options` VALUES("227165","_wp_session_6a1703b42b10e52cd2fc12f40cadb1cb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"bbfd39e621f187cae6607babc7711af0\";}\";}","no");
INSERT INTO `wp_options` VALUES("227171","_wp_session_expires_6a1703b42b10e52cd2fc12f40cadb1cb","2790263032","no");
INSERT INTO `wp_options` VALUES("227362","_wp_session_79778dc468e36d589d84dd1e76568ad7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f130043088727d38d97e00a5c14010d2\";}\";}","no");
INSERT INTO `wp_options` VALUES("227363","_wp_session_expires_79778dc468e36d589d84dd1e76568ad7","2790293148","no");
INSERT INTO `wp_options` VALUES("227480","_wp_session_6fdd08a863a0c4f008f2af81a1e40880","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f70fed070fe57f80a56807429318213a\";}\";}","no");
INSERT INTO `wp_options` VALUES("227481","_wp_session_expires_6fdd08a863a0c4f008f2af81a1e40880","2790307356","no");
INSERT INTO `wp_options` VALUES("233745","_wp_session_a6f6a5695cd9a9f03b0a756bab46106a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3f813ed826521390a4e334fcc18cb7c0\";}\";}","no");
INSERT INTO `wp_options` VALUES("228311","_wp_session_c7cc8a3ffbc8186026977d6e1cb4fa57","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dd6b8a58be48e6a23cce2ad4be105b84\";}\";}","no");
INSERT INTO `wp_options` VALUES("228312","_wp_session_expires_c7cc8a3ffbc8186026977d6e1cb4fa57","2790412474","no");
INSERT INTO `wp_options` VALUES("231059","_wp_session_expires_ddd195c7a5e1fa139f0066ceec996985","2790534662","no");
INSERT INTO `wp_options` VALUES("228566","_wp_session_expires_2e6a64d3fcbaac96cab9aa114812ee46","2790419242","no");
INSERT INTO `wp_options` VALUES("233746","_wp_session_expires_a6f6a5695cd9a9f03b0a756bab46106a","2790879552","no");
INSERT INTO `wp_options` VALUES("227574","_wp_session_540cbe5709e384b71c4bddf968c04560","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"029bfc50ceb8b51c4908494ba4cded45\";}\";}","no");
INSERT INTO `wp_options` VALUES("227575","_wp_session_expires_540cbe5709e384b71c4bddf968c04560","2790319924","no");
INSERT INTO `wp_options` VALUES("233654","_wp_session_expires_6a1163e5afc72a4f4e2cc78eda3b4ace","2790864138","no");
INSERT INTO `wp_options` VALUES("232338","_wp_session_fd46f61648e105085ab019cede13f7c4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5f59618b1f779d0fbc26d306ad8c159a\";}\";}","no");
INSERT INTO `wp_options` VALUES("233221","_wp_session_expires_dbd04b92bcfbee7f22e4ac4a1040b649","2790804030","no");
INSERT INTO `wp_options` VALUES("230778","_wp_session_5b5b9ae3f7daa5088c71241bacccffa2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c707d061404a5b354df9b09754f94c80\";}\";}","no");
INSERT INTO `wp_options` VALUES("230775","_wp_session_f7fffe1fa8e7d7192d6b15ffcaca02ea","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f31c6dcbf5d4c1a24e4897306b9471c8\";}\";}","no");
INSERT INTO `wp_options` VALUES("227892","_wp_session_e2fa9363558e3e04b7743390564394f0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7fe65a1817197be5369596637450e90b\";}\";}","no");
INSERT INTO `wp_options` VALUES("227893","_wp_session_expires_e2fa9363558e3e04b7743390564394f0","2790362266","no");
INSERT INTO `wp_options` VALUES("227898","_wp_session_300c2d4c0d28960f2a453489c4ed8bab","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e41f5c61840102bc2a45bd2e1f8f0378\";}\";}","no");
INSERT INTO `wp_options` VALUES("227899","_wp_session_expires_300c2d4c0d28960f2a453489c4ed8bab","2790362610","no");
INSERT INTO `wp_options` VALUES("227903","_wp_session_4dd171dcd44bf3dc83ddb148d8caab64","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"62b10a91bb49adb1aa18f32146ac6d32\";}\";}","no");
INSERT INTO `wp_options` VALUES("227904","_wp_session_expires_4dd171dcd44bf3dc83ddb148d8caab64","2790363358","no");
INSERT INTO `wp_options` VALUES("227906","_wp_session_59f12e0570fe50ef8b33df258c6ea139","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5c03cc7494adc1fc7d3b5c8a8acbfb76\";}\";}","no");
INSERT INTO `wp_options` VALUES("227907","_wp_session_expires_59f12e0570fe50ef8b33df258c6ea139","2790363512","no");
INSERT INTO `wp_options` VALUES("227917","_wp_session_4bfb864a83944ba0e036ee795fcd9b17","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ad1d68b969c8f313fca9826a28827f80\";}\";}","no");
INSERT INTO `wp_options` VALUES("227918","_wp_session_expires_4bfb864a83944ba0e036ee795fcd9b17","2790364032","no");
INSERT INTO `wp_options` VALUES("227920","_wp_session_9f8948ca2db6697352183217901a1483","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8db1cacc4a8014e444a36c7ebbdf985b\";}\";}","no");
INSERT INTO `wp_options` VALUES("227921","_wp_session_expires_9f8948ca2db6697352183217901a1483","2790364034","no");
INSERT INTO `wp_options` VALUES("227926","_wp_session_3b4bf65ee709f4754d1f2f7154245610","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"88e16fd76e4a6235a2ec06e7519d0db7\";}\";}","no");
INSERT INTO `wp_options` VALUES("227927","_wp_session_expires_3b4bf65ee709f4754d1f2f7154245610","2790364654","no");
INSERT INTO `wp_options` VALUES("227932","_wp_session_0e77de4f251a5c861a851b42aa7b133c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"966bb02587822732fc237445ac0dd41e\";}\";}","no");
INSERT INTO `wp_options` VALUES("227933","_wp_session_expires_0e77de4f251a5c861a851b42aa7b133c","2790365092","no");
INSERT INTO `wp_options` VALUES("227936","_wp_session_ec9ecd8b79ff97529037baa6536ca1f9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"389b8a97f278c303508fef6491917cdf\";}\";}","no");
INSERT INTO `wp_options` VALUES("227937","_wp_session_expires_ec9ecd8b79ff97529037baa6536ca1f9","2790365246","no");
INSERT INTO `wp_options` VALUES("227939","_wp_session_2ed757da8bbfa0679b0da875ef998fe0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"02088deeb0fd634adeff24351d187202\";}\";}","no");
INSERT INTO `wp_options` VALUES("227940","_wp_session_expires_2ed757da8bbfa0679b0da875ef998fe0","2790365602","no");
INSERT INTO `wp_options` VALUES("227942","_wp_session_07ec2aaf2f6400e38466089c3702426d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"33b8078addb86aba351370d8b5414cde\";}\";}","no");
INSERT INTO `wp_options` VALUES("227943","_wp_session_expires_07ec2aaf2f6400e38466089c3702426d","2790365924","no");
INSERT INTO `wp_options` VALUES("227945","_wp_session_dd09fa2ef7f6a34ddd5e45682875bf56","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"023481055a1ea53f54ad80f54961ba5f\";}\";}","no");
INSERT INTO `wp_options` VALUES("227946","_wp_session_expires_dd09fa2ef7f6a34ddd5e45682875bf56","2790366832","no");
INSERT INTO `wp_options` VALUES("228007","_wp_session_19b0de20099748311bc25403f968238b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3d4dab10affcf2a05b14e1eddc93d275\";}\";}","no");
INSERT INTO `wp_options` VALUES("228008","_wp_session_expires_19b0de20099748311bc25403f968238b","2790369174","no");
INSERT INTO `wp_options` VALUES("228127","_wp_session_028a8b1882e4cf8269495ebea070ef1f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"365a37a233030892694b3e228eb8d98b\";}\";}","no");
INSERT INTO `wp_options` VALUES("228090","_wp_session_c08d5d658bbc8070b076060333b20504","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b987d11d47c63d348570362008ce9d81\";}\";}","no");
INSERT INTO `wp_options` VALUES("228054","_wp_session_2581940dce7e7d36561045361e63fabb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"849bcede6641a2363e25e8c89ae79f49\";}\";}","no");
INSERT INTO `wp_options` VALUES("228055","_wp_session_expires_2581940dce7e7d36561045361e63fabb","2790374960","no");
INSERT INTO `wp_options` VALUES("228091","_wp_session_expires_c08d5d658bbc8070b076060333b20504","2790381540","no");
INSERT INTO `wp_options` VALUES("228128","_wp_session_expires_028a8b1882e4cf8269495ebea070ef1f","2790386252","no");
INSERT INTO `wp_options` VALUES("228134","_wp_session_3e8f148349f3862259b6ef1407942cba","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a6f6e4e81401d126f363b9ec09dc8b40\";}\";}","no");
INSERT INTO `wp_options` VALUES("228135","_wp_session_expires_3e8f148349f3862259b6ef1407942cba","2790387066","no");
INSERT INTO `wp_options` VALUES("228143","_wp_session_62efa1b194d238752d74beebd9232a5b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dbf768766d1608be1db6628a65a97ef8\";}\";}","no");
INSERT INTO `wp_options` VALUES("228144","_wp_session_expires_62efa1b194d238752d74beebd9232a5b","2790387790","no");
INSERT INTO `wp_options` VALUES("228217","_wp_session_b36cf8e1a1abc49dac6f57cd7230d5d0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ebf6e04abeb5980089d6f1f6a77a3dc1\";}\";}","no");
INSERT INTO `wp_options` VALUES("230779","_wp_session_expires_5b5b9ae3f7daa5088c71241bacccffa2","2790502998","no");
INSERT INTO `wp_options` VALUES("230782","_wp_session_c75e94834af76aff5975a1f1e6d82dfb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"135735b7f12077a56457cff1c75c2106\";}\";}","no");
INSERT INTO `wp_options` VALUES("230783","_wp_session_expires_c75e94834af76aff5975a1f1e6d82dfb","2790504276","no");
INSERT INTO `wp_options` VALUES("230846","_wp_session_expires_86c017e5cb96491d2a157081feb52265","2790508340","no");
INSERT INTO `wp_options` VALUES("228218","_wp_session_expires_b36cf8e1a1abc49dac6f57cd7230d5d0","2790397284","no");
INSERT INTO `wp_options` VALUES("228226","_wp_session_39f3c4b76f3fd796bb5b396ddad291ce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"033fc379c15f25c01498653e3aedc1d7\";}\";}","no");
INSERT INTO `wp_options` VALUES("228227","_wp_session_expires_39f3c4b76f3fd796bb5b396ddad291ce","2790399080","no");
INSERT INTO `wp_options` VALUES("228241","_wp_session_28ae7a577836bb7b7620921136e16d8d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"af6903c44f64d701e0602d3057b3e390\";}\";}","no");
INSERT INTO `wp_options` VALUES("228242","_wp_session_expires_28ae7a577836bb7b7620921136e16d8d","2790400144","no");
INSERT INTO `wp_options` VALUES("230539","_wp_session_6c01856e470236b6dd3e5ea6c7f1dc1c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"954294baa4b269175d28c021089f2b1b\";}\";}","no");
INSERT INTO `wp_options` VALUES("228303","_wp_session_e64a1198ed6a16549c50303e8aef60f0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e949e85ca294dacac5a2089d4c705eb5\";}\";}","no");
INSERT INTO `wp_options` VALUES("228304","_wp_session_expires_e64a1198ed6a16549c50303e8aef60f0","2790409114","no");
INSERT INTO `wp_options` VALUES("230540","_wp_session_expires_6c01856e470236b6dd3e5ea6c7f1dc1c","2790476260","no");
INSERT INTO `wp_options` VALUES("231635","_wp_session_expires_7548f9d2768f3bcfd107105658453727","2790585400","no");
INSERT INTO `wp_options` VALUES("232872","_wp_session_expires_cbd564341cab63c30dea5371f6859073","2790752348","no");
INSERT INTO `wp_options` VALUES("231795","_wp_session_expires_b3a6e35d9236fab42570eb89137d0e60","2790602686","no");
INSERT INTO `wp_options` VALUES("231868","_wp_session_1975b8349c8a72b3b56c5efbdf7345b3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"83ee205a08d9b93bac373b648fe805c9\";}\";}","no");
INSERT INTO `wp_options` VALUES("230776","_wp_session_expires_f7fffe1fa8e7d7192d6b15ffcaca02ea","2790502758","no");
INSERT INTO `wp_options` VALUES("233226","_wp_session_25a17692398b8cef4185409bf6925aa2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e2cb72df37a21d110d151d70c154bb10\";}\";}","no");
INSERT INTO `wp_options` VALUES("230899","_wp_session_ec939a6cb3c076db327cf72c2126d529","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c4e51c787d16976506ae30970628cdcb\";}\";}","no");
INSERT INTO `wp_options` VALUES("230900","_wp_session_expires_ec939a6cb3c076db327cf72c2126d529","2790519864","no");
INSERT INTO `wp_options` VALUES("230905","_wp_session_expires_16d91b78d0c8159ec1a1ae0a6380d8a0","2790520298","no");
INSERT INTO `wp_options` VALUES("232373","_wp_session_expires_d0cbdf7e3c6c553c8124db968b3ef577","2790703188","no");
INSERT INTO `wp_options` VALUES("230993","_wp_session_4e445b7c545eea49347036d7c3ac6516","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d2faf2f24e8a9ba1dade01b2c8648934\";}\";}","no");
INSERT INTO `wp_options` VALUES("230994","_wp_session_expires_4e445b7c545eea49347036d7c3ac6516","2790528160","no");
INSERT INTO `wp_options` VALUES("230998","_wp_session_d4a8c03d9200e34349cd5f6a16fc5d17","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"da85651379d7bd531ab5706495fee2cb\";}\";}","no");
INSERT INTO `wp_options` VALUES("230999","_wp_session_expires_d4a8c03d9200e34349cd5f6a16fc5d17","2790528600","no");
INSERT INTO `wp_options` VALUES("231021","_wp_session_e61ed88ecad37afed976f98250b4f958","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b398983b916a8cde92ac44845b5997d2\";}\";}","no");
INSERT INTO `wp_options` VALUES("231022","_wp_session_expires_e61ed88ecad37afed976f98250b4f958","2790531416","no");
INSERT INTO `wp_options` VALUES("231038","_wp_session_0bb2df340b8675b4562cd7b9a27f581c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"64d5c382184d4bcd04cc5db521891b9e\";}\";}","no");
INSERT INTO `wp_options` VALUES("231039","_wp_session_expires_0bb2df340b8675b4562cd7b9a27f581c","2790532650","no");
INSERT INTO `wp_options` VALUES("231042","_wp_session_ff163a72e1418c7e36b6109011114df2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b7616ba801de7d8f24b76f66c290ccda\";}\";}","no");
INSERT INTO `wp_options` VALUES("231043","_wp_session_expires_ff163a72e1418c7e36b6109011114df2","2790533028","no");
INSERT INTO `wp_options` VALUES("231044","_wp_session_expires_bc5baaeb8b1c60ca6472ca04020da8e0","2790533058","no");
INSERT INTO `wp_options` VALUES("231047","_wp_session_278f6c8323e4f4df1b283817755edb88","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"687b548216812f0ae490ce1d7b7ce6b3\";}\";}","no");
INSERT INTO `wp_options` VALUES("231048","_wp_session_expires_278f6c8323e4f4df1b283817755edb88","2790533202","no");
INSERT INTO `wp_options` VALUES("231053","_wp_session_73e7bb3be76fb58e66cd2737c01f8967","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"72c7088745835be676143c4d9e1c3f76\";}\";}","no");
INSERT INTO `wp_options` VALUES("231054","_wp_session_expires_73e7bb3be76fb58e66cd2737c01f8967","2790533620","no");
INSERT INTO `wp_options` VALUES("231056","_wp_session_09c24b112c7d6c677219a49074ac97c4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"958ae5bdb81e802c00b3e5d6032abfec\";}\";}","no");
INSERT INTO `wp_options` VALUES("231057","_wp_session_expires_09c24b112c7d6c677219a49074ac97c4","2790534580","no");
INSERT INTO `wp_options` VALUES("231064","_wp_session_4d45a028548b636f75e680c421db709c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4df02c5de8b398d566c8dd12bf096b5b\";}\";}","no");
INSERT INTO `wp_options` VALUES("231065","_wp_session_expires_4d45a028548b636f75e680c421db709c","2790535352","no");
INSERT INTO `wp_options` VALUES("231068","_wp_session_8112f0fc8ca0d4a1443ecc526c5d55af","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ed1725d48aff51fe3677f13d656e7900\";}\";}","no");
INSERT INTO `wp_options` VALUES("231069","_wp_session_expires_8112f0fc8ca0d4a1443ecc526c5d55af","2790535448","no");
INSERT INTO `wp_options` VALUES("231079","_wp_session_eb0ad3094b7f1324ab309894bd187f89","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1c3323873afd6734e786e65d2bf129aa\";}\";}","no");
INSERT INTO `wp_options` VALUES("231080","_wp_session_expires_eb0ad3094b7f1324ab309894bd187f89","2790536348","no");
INSERT INTO `wp_options` VALUES("231082","_wp_session_0f7b74fcb19fd14e02e50a3cf33209c0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e76c24704133816eaca339be1082dc41\";}\";}","no");
INSERT INTO `wp_options` VALUES("231083","_wp_session_expires_0f7b74fcb19fd14e02e50a3cf33209c0","2790536456","no");
INSERT INTO `wp_options` VALUES("231128","_wp_session_5dd09c1138a4b9f246a9e53d27a4ee03","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f54ae0bf46cda19d80b6281680b7d138\";}\";}","no");
INSERT INTO `wp_options` VALUES("231129","_wp_session_expires_5dd09c1138a4b9f246a9e53d27a4ee03","2790543738","no");
INSERT INTO `wp_options` VALUES("231281","_wp_session_expires_7c1b7268465d21b94c2de39cce4b3a9f","2790551368","no");
INSERT INTO `wp_options` VALUES("231236","_wp_session_69b84cd4763db7e1bad956dfb77a4654","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"15eb82a33c2366b9a94a6011cc902601\";}\";}","no");
INSERT INTO `wp_options` VALUES("231237","_wp_session_expires_69b84cd4763db7e1bad956dfb77a4654","2790548778","no");
INSERT INTO `wp_options` VALUES("231239","_wp_session_c9a2997a80b14c9389f4c5f90bc11555","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2a50e270df6a2ac9a884532e5e6c9e2b\";}\";}","no");
INSERT INTO `wp_options` VALUES("231240","_wp_session_expires_c9a2997a80b14c9389f4c5f90bc11555","2790548778","no");
INSERT INTO `wp_options` VALUES("231273","_wp_session_98c9a1d1f05481cea301344d60049ded","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9a8fa68b9444b73efeb1394930e7b849\";}\";}","no");
INSERT INTO `wp_options` VALUES("231274","_wp_session_expires_98c9a1d1f05481cea301344d60049ded","2790550354","no");
INSERT INTO `wp_options` VALUES("231279","_wp_session_1a5f05d21418478e2be0bffe3fe03ba6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"698859860089f19e76bae7cb8da7ebbe\";}\";}","no");
INSERT INTO `wp_options` VALUES("231280","_wp_session_expires_1a5f05d21418478e2be0bffe3fe03ba6","2790551180","no");
INSERT INTO `wp_options` VALUES("231337","_wp_session_7c1b7268465d21b94c2de39cce4b3a9f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"eba5b6a022bee6fc23fdcb927f24ad5f\";}\";}","no");
INSERT INTO `wp_options` VALUES("231386","_wp_session_3e4d5d6c49067857c028296de66f6d58","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"13ca1b895f4d26574998c41a46d3ed9b\";}\";}","no");
INSERT INTO `wp_options` VALUES("231387","_wp_session_expires_3e4d5d6c49067857c028296de66f6d58","2790557840","no");
INSERT INTO `wp_options` VALUES("233227","_wp_session_expires_25a17692398b8cef4185409bf6925aa2","2790805044","no");
INSERT INTO `wp_options` VALUES("231407","_wp_session_999402b72599a192826ce23b66204540","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4623ea9186e69e23a28700977d516c0c\";}\";}","no");
INSERT INTO `wp_options` VALUES("231408","_wp_session_expires_999402b72599a192826ce23b66204540","2790560086","no");
INSERT INTO `wp_options` VALUES("231460","_wp_session_expires_88ac0f3a5e96f9a54dbf094d386a13f8","2790571222","no");
INSERT INTO `wp_options` VALUES("231459","_wp_session_88ac0f3a5e96f9a54dbf094d386a13f8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"22d8931ae66e95105a634020dace486b\";}\";}","no");
INSERT INTO `wp_options` VALUES("232190","_wp_session_expires_a5553cbd9a8e6cbfcff24e19c7af1e21","2790673844","no");
INSERT INTO `wp_options` VALUES("232209","_wp_session_expires_c3851d882a1860a3f3790b929f67ff80","2790677094","no");
INSERT INTO `wp_options` VALUES("232231","_wp_session_b04b38453a33f4ec4f5da54ec2b767f0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0a576601f359fe347f473a688efba210\";}\";}","no");
INSERT INTO `wp_options` VALUES("232232","_wp_session_expires_b04b38453a33f4ec4f5da54ec2b767f0","2790680922","no");
INSERT INTO `wp_options` VALUES("232238","_wp_session_24a6180e6c8a35ec811d9f73ead4e013","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0e60811dc25767fa7e534f65b3094214\";}\";}","no");
INSERT INTO `wp_options` VALUES("231617","_wp_session_d0ec703f87db60e94032a91a220ff398","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c72ba0cd0a6e978b6426016876ea23df\";}\";}","no");
INSERT INTO `wp_options` VALUES("231618","_wp_session_expires_d0ec703f87db60e94032a91a220ff398","2790584250","no");
INSERT INTO `wp_options` VALUES("231634","_wp_session_7548f9d2768f3bcfd107105658453727","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9edb4dd5810dcbc1e8763190ddfc5262\";}\";}","no");
INSERT INTO `wp_options` VALUES("231869","_wp_session_expires_1975b8349c8a72b3b56c5efbdf7345b3","2790617352","no");
INSERT INTO `wp_options` VALUES("232078","_wp_session_e48e5276c41e560d64438cbd59b75301","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8bdad9ba76ace4ae35f81faf64d2cb48\";}\";}","no");
INSERT INTO `wp_options` VALUES("238908","_wp_session_expires_3d25a7c5d06c8d4c9819d17f9641236a","2791541766","no");
INSERT INTO `wp_options` VALUES("239747","_wp_session_c15337e122e1f0fe753e9d034528ac1c","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c6aee56b9d0e747e3408aef27dee21a4\";}\";}","no");
INSERT INTO `wp_options` VALUES("239018","_wp_session_47971cd4b47c0e3415450c9d49423f28","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"28d16ff462b331103d43db8eaafadc78\";}\";}","no");
INSERT INTO `wp_options` VALUES("233242","_wp_session_308da9d36f0121f5336e9183513a56c8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9107b4dde254ffd04ab8b2c1f9154956\";}\";}","no");
INSERT INTO `wp_options` VALUES("233083","_wp_session_expires_9db280158af5b13ee24ac875acd49c79","2790782270","no");
INSERT INTO `wp_options` VALUES("233218","_wp_session_expires_d25121f28a30e4ce1ab0aa7e75f3947b","2790804024","no");
INSERT INTO `wp_options` VALUES("233217","_wp_session_d25121f28a30e4ce1ab0aa7e75f3947b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"503a70c9f0f93f895dde878e3c0ec4fa\";}\";}","no");
INSERT INTO `wp_options` VALUES("232079","_wp_session_expires_e48e5276c41e560d64438cbd59b75301","2790656202","no");
INSERT INTO `wp_options` VALUES("232082","_wp_session_a0364ba7075edf9ce789e4835895f06e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"faa3c7a30157575fe22a05e7eab77113\";}\";}","no");
INSERT INTO `wp_options` VALUES("232083","_wp_session_expires_a0364ba7075edf9ce789e4835895f06e","2790656238","no");
INSERT INTO `wp_options` VALUES("232158","_wp_session_expires_58ed53cc96bc768eb588f69f4a1271fa","2790669758","no");
INSERT INTO `wp_options` VALUES("232208","_wp_session_c3851d882a1860a3f3790b929f67ff80","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0235ed8f45a8e173a3f4da5beeb3eb28\";}\";}","no");
INSERT INTO `wp_options` VALUES("232189","_wp_session_a5553cbd9a8e6cbfcff24e19c7af1e21","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"835fc3611bf47122d2165fdb8feb44a5\";}\";}","no");
INSERT INTO `wp_options` VALUES("232239","_wp_session_expires_24a6180e6c8a35ec811d9f73ead4e013","2790682600","no");
INSERT INTO `wp_options` VALUES("232339","_wp_session_expires_fd46f61648e105085ab019cede13f7c4","2790697428","no");
INSERT INTO `wp_options` VALUES("232661","_wp_session_expires_cd63cbf668af92693fc359f10fa1e5b1","2790738034","no");
INSERT INTO `wp_options` VALUES("232545","_wp_session_70477e55c9b24436fd37641b39b8cb5b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4da940429e6a1a3e4105563328cdde86\";}\";}","no");
INSERT INTO `wp_options` VALUES("232421","_wp_session_33d9697512290ac536ea5ccfcf40e53e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"650bf5af7e44cba4007beb992c929c9e\";}\";}","no");
INSERT INTO `wp_options` VALUES("232422","_wp_session_expires_33d9697512290ac536ea5ccfcf40e53e","2790708794","no");
INSERT INTO `wp_options` VALUES("232424","_wp_session_f44037987708c758504a8ea69a730f9a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b222854fa9209f8dd49431a20006ae7c\";}\";}","no");
INSERT INTO `wp_options` VALUES("232425","_wp_session_expires_f44037987708c758504a8ea69a730f9a","2790708914","no");
INSERT INTO `wp_options` VALUES("238921","_wp_session_expires_","2791543776","no");
INSERT INTO `wp_options` VALUES("232434","_wp_session_f7b00e8713c04787496c5a7b5c7d6257","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"67bc2aa21982f4696e3ff6ba53ea90e1\";}\";}","no");
INSERT INTO `wp_options` VALUES("232435","_wp_session_expires_f7b00e8713c04787496c5a7b5c7d6257","2790709158","no");
INSERT INTO `wp_options` VALUES("232437","_wp_session_3898468348a4bea49f95c1ed3eee706e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2059e300f3283c7b7e34b3ade0dd3d05\";}\";}","no");
INSERT INTO `wp_options` VALUES("232438","_wp_session_expires_3898468348a4bea49f95c1ed3eee706e","2790709496","no");
INSERT INTO `wp_options` VALUES("232443","_wp_session_5bf9624dbdd6c7e795f538c05d1728cb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d7c795e211005e83366c300581964aa0\";}\";}","no");
INSERT INTO `wp_options` VALUES("232444","_wp_session_expires_5bf9624dbdd6c7e795f538c05d1728cb","2790710200","no");
INSERT INTO `wp_options` VALUES("232449","_wp_session_13c303a55338cdce159e615d77bbcaa6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5c112caf2cac970289f026681e39c863\";}\";}","no");
INSERT INTO `wp_options` VALUES("232450","_wp_session_expires_13c303a55338cdce159e615d77bbcaa6","2790710954","no");
INSERT INTO `wp_options` VALUES("232452","_wp_session_af319dd3b9092399c7add65761e506a3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f591042588858e8f9e7819bebd29feca\";}\";}","no");
INSERT INTO `wp_options` VALUES("232453","_wp_session_expires_af319dd3b9092399c7add65761e506a3","2790711188","no");
INSERT INTO `wp_options` VALUES("232455","_wp_session_513115699cb41fa016d3ee4472fc1276","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"30806c14e509501e5ebd23eb79aaf8e3\";}\";}","no");
INSERT INTO `wp_options` VALUES("232456","_wp_session_expires_513115699cb41fa016d3ee4472fc1276","2790711196","no");
INSERT INTO `wp_options` VALUES("232467","_wp_session_2c36643c22d6f2aa994ab42534769096","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"02be2f7ea2f4e7e48b8898c2a2aadf1e\";}\";}","no");
INSERT INTO `wp_options` VALUES("232468","_wp_session_expires_2c36643c22d6f2aa994ab42534769096","2790711608","no");
INSERT INTO `wp_options` VALUES("232470","_wp_session_7a54a0e6dcde0076d6d5bc212e79c939","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ad5634cc0849bfe8e694cfb83852ea82\";}\";}","no");
INSERT INTO `wp_options` VALUES("232471","_wp_session_expires_7a54a0e6dcde0076d6d5bc212e79c939","2790711834","no");
INSERT INTO `wp_options` VALUES("232475","_wp_session_1dead86ec1a04d129e57d1424bf8bb13","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c26dda0429c17f69276ab84ddbe444a3\";}\";}","no");
INSERT INTO `wp_options` VALUES("232476","_wp_session_expires_1dead86ec1a04d129e57d1424bf8bb13","2790712048","no");
INSERT INTO `wp_options` VALUES("232515","_wp_session_8c8a98f9bd69321d07fc2d1aa2479c9e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b5694e3335539cae9f607d0baff692e7\";}\";}","no");
INSERT INTO `wp_options` VALUES("232516","_wp_session_expires_8c8a98f9bd69321d07fc2d1aa2479c9e","2790718656","no");
INSERT INTO `wp_options` VALUES("232546","_wp_session_expires_70477e55c9b24436fd37641b39b8cb5b","2790721940","no");
INSERT INTO `wp_options` VALUES("232557","_wp_session_expires_0281765fb3967ca0e51556ee23d5d5d5","2790723454","no");
INSERT INTO `wp_options` VALUES("232593","_wp_session_14c2c24616b3cae793f70157b0f658a9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0b453da604c8ad7e2c2f842addab783f\";}\";}","no");
INSERT INTO `wp_options` VALUES("232594","_wp_session_expires_14c2c24616b3cae793f70157b0f658a9","2790725798","no");
INSERT INTO `wp_options` VALUES("232637","_wp_session_6865054e8d820f9ffc3bcb873ac957b3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"836f6830ace036f4339d9b21cd025025\";}\";}","no");
INSERT INTO `wp_options` VALUES("232608","_wp_session_34fd7e548d6073e55c59e1760b225936","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8936668185a679fd8bcd18bbd9295067\";}\";}","no");
INSERT INTO `wp_options` VALUES("232609","_wp_session_expires_34fd7e548d6073e55c59e1760b225936","2790729246","no");
INSERT INTO `wp_options` VALUES("232638","_wp_session_expires_6865054e8d820f9ffc3bcb873ac957b3","2790734180","no");
INSERT INTO `wp_options` VALUES("232640","_wp_session_aa3e92bcf338a2ca832bf6a11d3a9a69","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2a1f5901644939d537adf147b2f41717\";}\";}","no");
INSERT INTO `wp_options` VALUES("232641","_wp_session_expires_aa3e92bcf338a2ca832bf6a11d3a9a69","2790734524","no");
INSERT INTO `wp_options` VALUES("232746","_wp_session_9d36a5e04ef1508050b88b15f12f310e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f59f0e8502e19a16b534fa607021e1a0\";}\";}","no");
INSERT INTO `wp_options` VALUES("232747","_wp_session_expires_9d36a5e04ef1508050b88b15f12f310e","2790739748","no");
INSERT INTO `wp_options` VALUES("233663","_wp_session_9073b2c68453602bba914f3e9c1a274d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"cb9330e44c484abccde3ca8bb559c600\";}\";}","no");
INSERT INTO `wp_options` VALUES("233664","_wp_session_expires_9073b2c68453602bba914f3e9c1a274d","2790865302","no");
INSERT INTO `wp_options` VALUES("233670","_wp_session_bd03812081f7556fafff7589ca94c415","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"574fbf12db7aa21ecf56bd83d77b8d30\";}\";}","no");
INSERT INTO `wp_options` VALUES("233671","_wp_session_expires_bd03812081f7556fafff7589ca94c415","2790866104","no");
INSERT INTO `wp_options` VALUES("232851","_wp_session_e907ba602d219e1871d70f6d71f8e717","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"57b22b363393f621bce36ef82074a8fa\";}\";}","no");
INSERT INTO `wp_options` VALUES("232852","_wp_session_expires_e907ba602d219e1871d70f6d71f8e717","2790748460","no");
INSERT INTO `wp_options` VALUES("232859","_wp_session_expires_51c2e0d9d755e72f24d6ff2ba940a32a","2790751150","no");
INSERT INTO `wp_options` VALUES("232878","_wp_session_expires_dd197e66c685784a599a75c4398de9a5","2790752396","no");
INSERT INTO `wp_options` VALUES("232880","_wp_session_expires_b84ededc96bb3f451deceed004343e3c","2790752402","no");
INSERT INTO `wp_options` VALUES("234519","_wp_session_expires_62ee3f28768d31e1924073c127d58857","2790963302","no");
INSERT INTO `wp_options` VALUES("232929","_wp_session_expires_85521421bd70220f66b8d5909b6e6463","2790760896","no");
INSERT INTO `wp_options` VALUES("233243","_wp_session_expires_308da9d36f0121f5336e9183513a56c8","2790808646","no");
INSERT INTO `wp_options` VALUES("233657","_wp_session_expires_dc56337daf6936ea5b6ba5d0efb255e9","2790864170","no");
INSERT INTO `wp_options` VALUES("233653","_wp_session_6a1163e5afc72a4f4e2cc78eda3b4ace","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f4c1b6322714879569f532daa300737c\";}\";}","no");
INSERT INTO `wp_options` VALUES("233475","_wp_session_4a24e36a72d246184060bd39651458be","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"42288ad27d4743b86ca4ec4c5454411e\";}\";}","no");
INSERT INTO `wp_options` VALUES("234305","_wp_session_expires_4776532687f5096c95f4935bfbcaf907","2790931268","no");
INSERT INTO `wp_options` VALUES("236761","_wp_session_expires_1d01b8cb124e332127b80aa853b60782","2791264996","no");
INSERT INTO `wp_options` VALUES("234336","_wp_session_34bc71c8827270a40c26793b51fede46","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f1f089e30af4628518830a97c2cca8d8\";}\";}","no");
INSERT INTO `wp_options` VALUES("234337","_wp_session_expires_34bc71c8827270a40c26793b51fede46","2790937586","no");
INSERT INTO `wp_options` VALUES("235641","_wp_session_aad54b60b85fdfd799cb55d63083f729","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7563e35140ad277895f7be04528b03ac\";}\";}","no");
INSERT INTO `wp_options` VALUES("233429","_wp_session_507d5cf6cd3668b1f2b83526eb201e35","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"939545d58a148faa150b1ffad7831f0b\";}\";}","no");
INSERT INTO `wp_options` VALUES("233430","_wp_session_expires_507d5cf6cd3668b1f2b83526eb201e35","2790832418","no");
INSERT INTO `wp_options` VALUES("233465","_wp_session_f4fafb53e7f7ca9e422031b294313fbb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"07b1d15d906ac4b305e187e12cf490e9\";}\";}","no");
INSERT INTO `wp_options` VALUES("233466","_wp_session_expires_f4fafb53e7f7ca9e422031b294313fbb","2790837756","no");
INSERT INTO `wp_options` VALUES("233476","_wp_session_expires_4a24e36a72d246184060bd39651458be","2790838690","no");
INSERT INTO `wp_options` VALUES("233656","_wp_session_dc56337daf6936ea5b6ba5d0efb255e9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b5b7abbd7b827050422f9a0516321a20\";}\";}","no");
INSERT INTO `wp_options` VALUES("233790","_wp_session_d1cd003540577ca53fe03985276a64fc","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c2c9faecd7f4cd63d24e6bf2f1edf853\";}\";}","no");
INSERT INTO `wp_options` VALUES("233791","_wp_session_expires_d1cd003540577ca53fe03985276a64fc","2790884924","no");
INSERT INTO `wp_options` VALUES("233794","_wp_session_0d8eac12f8a73b0bccc9c1c81de83a14","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9c058888f29f7b9ea08b37be86c606f7\";}\";}","no");
INSERT INTO `wp_options` VALUES("233795","_wp_session_expires_0d8eac12f8a73b0bccc9c1c81de83a14","2790885022","no");
INSERT INTO `wp_options` VALUES("233811","_wp_session_75861dc1c0c400956a8106f29a0a9300","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a33f715fc9ba3061ea48b280f806c22c\";}\";}","no");
INSERT INTO `wp_options` VALUES("233812","_wp_session_expires_75861dc1c0c400956a8106f29a0a9300","2790886064","no");
INSERT INTO `wp_options` VALUES("233816","_wp_session_75754254c3be50b1a2c5dd90fcdc5b86","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c2458b0c3a4e4c021be84cbd1930175f\";}\";}","no");
INSERT INTO `wp_options` VALUES("233817","_wp_session_expires_75754254c3be50b1a2c5dd90fcdc5b86","2790886578","no");
INSERT INTO `wp_options` VALUES("233820","_wp_session_984dba5b6cc9655a39f2cf417ae27220","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c2f7003ef4d5cef2c21440bc7bf67c32\";}\";}","no");
INSERT INTO `wp_options` VALUES("233821","_wp_session_expires_984dba5b6cc9655a39f2cf417ae27220","2790886796","no");
INSERT INTO `wp_options` VALUES("233823","_wp_session_d3e8e8047fee913884713a0f1e5a6bd4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1d4ddf271e1f562cf4b8df23451b9d35\";}\";}","no");
INSERT INTO `wp_options` VALUES("233824","_wp_session_expires_d3e8e8047fee913884713a0f1e5a6bd4","2790886806","no");
INSERT INTO `wp_options` VALUES("233826","_wp_session_94e44d54d995a0228394e55071bfe3f1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"035c715d143a719669e00a35d74a8157\";}\";}","no");
INSERT INTO `wp_options` VALUES("233827","_wp_session_expires_94e44d54d995a0228394e55071bfe3f1","2790886864","no");
INSERT INTO `wp_options` VALUES("233829","_wp_session_1a13d571a4afea3dc5523de5ff55fbd4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"84146eb7b04ec6eae14177b8c14ba2a7\";}\";}","no");
INSERT INTO `wp_options` VALUES("233830","_wp_session_expires_1a13d571a4afea3dc5523de5ff55fbd4","2790886890","no");
INSERT INTO `wp_options` VALUES("233832","_wp_session_52c58306aac3d986a99cc3ef532e14c6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2741a95b9508f80ed6a00e369a3ebea7\";}\";}","no");
INSERT INTO `wp_options` VALUES("233833","_wp_session_expires_52c58306aac3d986a99cc3ef532e14c6","2790886990","no");
INSERT INTO `wp_options` VALUES("233839","_wp_session_95c65844e21f0013ddde917647fa4529","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f1b6bc49e0c7af9bd4ec02edcffd3fb8\";}\";}","no");
INSERT INTO `wp_options` VALUES("233840","_wp_session_expires_95c65844e21f0013ddde917647fa4529","2790887404","no");
INSERT INTO `wp_options` VALUES("233849","_wp_session_0691af90fe9ac7e4db77db4d08c7d8ff","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a023a7d1171730afd6493ad82c4c3879\";}\";}","no");
INSERT INTO `wp_options` VALUES("233850","_wp_session_expires_0691af90fe9ac7e4db77db4d08c7d8ff","2790887774","no");
INSERT INTO `wp_options` VALUES("233929","_wp_session_6c41f0d2369a14530c89642bf29ac8cf","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("234969","_wp_session_8610337d7b4c592780dfcee46d561a7f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"804b6b9228f646604e77428b63c967e2\";}\";}","no");
INSERT INTO `wp_options` VALUES("233928","_wp_session_expires_6c41f0d2369a14530c89642bf29ac8cf","2790892846","no");
INSERT INTO `wp_options` VALUES("234104","_wp_session_expires_cb6a61ed3ce6d98e31a0b50c60fbd2d7","2790918612","no");
INSERT INTO `wp_options` VALUES("234060","_wp_session_1eafe099507b9b23df4bc27ab6a47bab","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"01d57f891467ee78744e3af0af81062e\";}\";}","no");
INSERT INTO `wp_options` VALUES("234970","_wp_session_expires_8610337d7b4c592780dfcee46d561a7f","2791026988","no");
INSERT INTO `wp_options` VALUES("234990","_wp_session_915034f4b6b56023fb4c9916c6987deb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"83c4f03f5f610675cb3c746c1e117473\";}\";}","no");
INSERT INTO `wp_options` VALUES("234991","_wp_session_expires_915034f4b6b56023fb4c9916c6987deb","2791028122","no");
INSERT INTO `wp_options` VALUES("234998","_wp_session_b8b43488aa9448904c68c245c0992131","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4866a4a75bd18e83093c66e5e2ab100d\";}\";}","no");
INSERT INTO `wp_options` VALUES("234061","_wp_session_expires_1eafe099507b9b23df4bc27ab6a47bab","2790913416","no");
INSERT INTO `wp_options` VALUES("234103","_wp_session_cb6a61ed3ce6d98e31a0b50c60fbd2d7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6ec7087c3e5ae178f271f7f64589e3d1\";}\";}","no");
INSERT INTO `wp_options` VALUES("234125","_wp_session_0d9f566da52234daa1f22b53a38aad0f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c06862cc90a7a634d96c06593063052d\";}\";}","no");
INSERT INTO `wp_options` VALUES("234126","_wp_session_expires_0d9f566da52234daa1f22b53a38aad0f","2790919706","no");
INSERT INTO `wp_options` VALUES("234177","_wp_session_8ee75b64c744010d1c4595b4de83bfce","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6beaefcffd639a9fd00b2c28a8ccd407\";}\";}","no");
INSERT INTO `wp_options` VALUES("234178","_wp_session_expires_8ee75b64c744010d1c4595b4de83bfce","2790929504","no");
INSERT INTO `wp_options` VALUES("234417","_wp_session_6c042a0a927889e6bc2376fd1ffdbe0e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"2dfe2bef5e0083686edea395ee738ef4\";}\";}","no");
INSERT INTO `wp_options` VALUES("234418","_wp_session_expires_6c042a0a927889e6bc2376fd1ffdbe0e","2790947048","no");
INSERT INTO `wp_options` VALUES("235778","_wp_session_expires_b7ebe288b272b5dcda5b4f10be5aaa48","2791118904","no");
INSERT INTO `wp_options` VALUES("235695","_wp_session_547fa01f05b3c2a9739f7c8897019fbb","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"807ff080c3562c399e839c73d134cb2a\";}\";}","no");
INSERT INTO `wp_options` VALUES("235696","_wp_session_expires_547fa01f05b3c2a9739f7c8897019fbb","2791107064","no");
INSERT INTO `wp_options` VALUES("235698","_wp_session_67c0a09765510e37df1d7a675226b2b0","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"00f6fd60d54135755a5f7e8ba36364f3\";}\";}","no");
INSERT INTO `wp_options` VALUES("235699","_wp_session_expires_67c0a09765510e37df1d7a675226b2b0","2791107204","no");
INSERT INTO `wp_options` VALUES("235700","_wp_session_expires_1d783e702f49d1e2fde856e3fc323b4c","2791107476","no");
INSERT INTO `wp_options` VALUES("234966","_wp_session_d7607fd23d39a4f9b693ba46986a4804","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c9a26a420a871a87f186b07be6820a6e\";}\";}","no");
INSERT INTO `wp_options` VALUES("234967","_wp_session_expires_d7607fd23d39a4f9b693ba46986a4804","2791026978","no");
INSERT INTO `wp_options` VALUES("234999","_wp_session_expires_b8b43488aa9448904c68c245c0992131","2791028472","no");
INSERT INTO `wp_options` VALUES("235006","_wp_session_747675711ff6b3d67c0db2fdf5468556","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"59b41c2fd3b4d618b7b99622ae68a1c1\";}\";}","no");
INSERT INTO `wp_options` VALUES("235007","_wp_session_expires_747675711ff6b3d67c0db2fdf5468556","2791028564","no");
INSERT INTO `wp_options` VALUES("235009","_wp_session_eca6d2e74495175afdc79fe153334951","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"42c215c9c0a1310222fbafa8dcf239ed\";}\";}","no");
INSERT INTO `wp_options` VALUES("235010","_wp_session_expires_eca6d2e74495175afdc79fe153334951","2791028586","no");
INSERT INTO `wp_options` VALUES("235017","_wp_session_fb3848e5e7a2e63f0e9af8de83b91653","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"30052bfe56b31fc854fb9ec3ef046188\";}\";}","no");
INSERT INTO `wp_options` VALUES("235018","_wp_session_expires_fb3848e5e7a2e63f0e9af8de83b91653","2791029632","no");
INSERT INTO `wp_options` VALUES("235020","_wp_session_d082879c287e51497c92fd3eac1cc164","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"96dcb7412f6d424feb6e68cb6dd09f08\";}\";}","no");
INSERT INTO `wp_options` VALUES("235021","_wp_session_expires_d082879c287e51497c92fd3eac1cc164","2791029730","no");
INSERT INTO `wp_options` VALUES("235025","_wp_session_06572de5a9ebf927b7825788d646b653","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b0f915701a26a6f84852d05e1ec92501\";}\";}","no");
INSERT INTO `wp_options` VALUES("235026","_wp_session_expires_06572de5a9ebf927b7825788d646b653","2791030294","no");
INSERT INTO `wp_options` VALUES("235035","_wp_session_13303052d8ba9d993a538cfd4807f6b5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7f499fa752700d67015322cf3d299e90\";}\";}","no");
INSERT INTO `wp_options` VALUES("235036","_wp_session_expires_13303052d8ba9d993a538cfd4807f6b5","2791032446","no");
INSERT INTO `wp_options` VALUES("235163","_wp_session_expires_407cbfec8c0167162835133d19fd7e54","2791049650","no");
INSERT INTO `wp_options` VALUES("235206","_wp_session_expires_596f80df6d3682f9a7637428020964b1","2791058768","no");
INSERT INTO `wp_options` VALUES("235144","_wp_session_f5251cd7304f6992d2aeedb19c1a5e22","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"84b64408fdd86968326c9621b2090c63\";}\";}","no");
INSERT INTO `wp_options` VALUES("235145","_wp_session_expires_f5251cd7304f6992d2aeedb19c1a5e22","2791048066","no");
INSERT INTO `wp_options` VALUES("235208","_wp_session_expires_78b80707e18b871c6839e2d977e81a4f","2791058770","no");
INSERT INTO `wp_options` VALUES("235486","_wp_session_fc216b6e54500af70bb47b72d7eeed56","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f792baa4b878333499e094d0c61272cd\";}\";}","no");
INSERT INTO `wp_options` VALUES("235332","_wp_session_ce8aee228d1128d087b92f22b66f627b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d4a8f38a0ba067d0fcc065f30c02c64c\";}\";}","no");
INSERT INTO `wp_options` VALUES("235333","_wp_session_expires_ce8aee228d1128d087b92f22b66f627b","2791070938","no");
INSERT INTO `wp_options` VALUES("235343","_wp_session_71ed8017b662fc5ab51c4ff948a56090","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e124cf75f11a8338ee19a4892475b21c\";}\";}","no");
INSERT INTO `wp_options` VALUES("235344","_wp_session_expires_71ed8017b662fc5ab51c4ff948a56090","2791072194","no");
INSERT INTO `wp_options` VALUES("235349","_wp_session_ffda0f37ce42245c1af5fb72a87dd4f4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"debcff8ea1180cc923620874d1eefa05\";}\";}","no");
INSERT INTO `wp_options` VALUES("235350","_wp_session_expires_ffda0f37ce42245c1af5fb72a87dd4f4","2791072726","no");
INSERT INTO `wp_options` VALUES("235352","_wp_session_d71a3034d77cd0128b288e85964f8866","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5b0aa82358d7550ebc11100e4482b587\";}\";}","no");
INSERT INTO `wp_options` VALUES("235353","_wp_session_expires_d71a3034d77cd0128b288e85964f8866","2791072896","no");
INSERT INTO `wp_options` VALUES("235357","_wp_session_3a09d35589b4196f0f0ea0fb9c8d2f29","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3ab20f2efb46ca019cf9d2f18bc1fc09\";}\";}","no");
INSERT INTO `wp_options` VALUES("235358","_wp_session_expires_3a09d35589b4196f0f0ea0fb9c8d2f29","2791073580","no");
INSERT INTO `wp_options` VALUES("235370","_wp_session_47d495a1e3c25e7b81571c4881dd73be","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e16821b71543d88ccacffc93bb4080ad\";}\";}","no");
INSERT INTO `wp_options` VALUES("235371","_wp_session_expires_47d495a1e3c25e7b81571c4881dd73be","2791074360","no");
INSERT INTO `wp_options` VALUES("235373","_wp_session_b4bbabdaabc059d6a08c636d68f8e850","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e8fecf71c9e86e75299412973163976d\";}\";}","no");
INSERT INTO `wp_options` VALUES("235374","_wp_session_expires_b4bbabdaabc059d6a08c636d68f8e850","2791074480","no");
INSERT INTO `wp_options` VALUES("235379","_wp_session_e7626770ad6d08261c49ae91eea2de7f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7276084d2e31568e3fddf1148cf42a2d\";}\";}","no");
INSERT INTO `wp_options` VALUES("235380","_wp_session_expires_e7626770ad6d08261c49ae91eea2de7f","2791075004","no");
INSERT INTO `wp_options` VALUES("235385","_wp_session_45b4cfe88beb025dac7c14bb87e3eb7a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d151f8184944cc2f5ad6bc07db349933\";}\";}","no");
INSERT INTO `wp_options` VALUES("235386","_wp_session_expires_45b4cfe88beb025dac7c14bb87e3eb7a","2791075834","no");
INSERT INTO `wp_options` VALUES("235396","_wp_session_da723579c165527ceff175fa40aad876","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f6e497d19948b9bdd892a04ad6df9d2b\";}\";}","no");
INSERT INTO `wp_options` VALUES("235397","_wp_session_expires_da723579c165527ceff175fa40aad876","2791076180","no");
INSERT INTO `wp_options` VALUES("235425","_wp_session_0d210cf93576b5b45c3701ef9f35679e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f396d4a1af95076ceb728a98c081d96f\";}\";}","no");
INSERT INTO `wp_options` VALUES("235426","_wp_session_expires_0d210cf93576b5b45c3701ef9f35679e","2791080492","no");
INSERT INTO `wp_options` VALUES("235449","_wp_session_0d5812bb4a15cbe1f8fe0ee5d75a3676","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0adc924d0d356452fe85e59aa4db2280\";}\";}","no");
INSERT INTO `wp_options` VALUES("235450","_wp_session_expires_0d5812bb4a15cbe1f8fe0ee5d75a3676","2791084610","no");
INSERT INTO `wp_options` VALUES("235460","_wp_session_d40fe0609efa9479fe57cf4ce2868d6a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ccd35fefff2dff294b9cc704f9c975b1\";}\";}","no");
INSERT INTO `wp_options` VALUES("235461","_wp_session_expires_d40fe0609efa9479fe57cf4ce2868d6a","2791085280","no");
INSERT INTO `wp_options` VALUES("236742","_wp_session_10da52a92ec8043f11fdafd6ec4b23e5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"842db12344129b4c1f11a21f8d5c9f53\";}\";}","no");
INSERT INTO `wp_options` VALUES("237714","_wp_session_0a6b5a2e9232a9207e4b50ea42aa0c59","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3a8c1be036a58ef4e33e57f0f5b1d1bd\";}\";}","no");
INSERT INTO `wp_options` VALUES("237715","_wp_session_expires_0a6b5a2e9232a9207e4b50ea42aa0c59","2791396494","no");
INSERT INTO `wp_options` VALUES("237721","_wp_session_48a5b32881e3bd7dbe0ff94c4fbd7f1e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e90be813651eec2ca8ae524232ba146e\";}\";}","no");
INSERT INTO `wp_options` VALUES("237722","_wp_session_expires_48a5b32881e3bd7dbe0ff94c4fbd7f1e","2791398774","no");
INSERT INTO `wp_options` VALUES("238907","_wp_session_3d25a7c5d06c8d4c9819d17f9641236a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b993992b6041cbdf5ef2baf94ec8f4b3\";}\";}","no");
INSERT INTO `wp_options` VALUES("237787","_wp_session_f2af2eb58b5ff58b1b87b5506a76a193","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e0d89d91a9105e7f7cbd9c20690c95d2\";}\";}","no");
INSERT INTO `wp_options` VALUES("235487","_wp_session_expires_fc216b6e54500af70bb47b72d7eeed56","2791089350","no");
INSERT INTO `wp_options` VALUES("235503","_wp_session_9d027d844d8d66d1eb7c543ce82a1b31","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5b7594a49219a84ccad3eedc0b9dc6a1\";}\";}","no");
INSERT INTO `wp_options` VALUES("235504","_wp_session_expires_9d027d844d8d66d1eb7c543ce82a1b31","2791089588","no");
INSERT INTO `wp_options` VALUES("235511","_wp_session_8bdd54b739fcd35bac457cf753c80e04","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9c7216cf54b15f45f4b3e7add7647db7\";}\";}","no");
INSERT INTO `wp_options` VALUES("235512","_wp_session_expires_8bdd54b739fcd35bac457cf753c80e04","2791089596","no");
INSERT INTO `wp_options` VALUES("235563","_wp_session_a9242c32f27cf5c322b055ed89304dd6","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"81543e6acfa064b8304f8c798f64a3e2\";}\";}","no");
INSERT INTO `wp_options` VALUES("235564","_wp_session_expires_a9242c32f27cf5c322b055ed89304dd6","2791090034","no");
INSERT INTO `wp_options` VALUES("235642","_wp_session_expires_aad54b60b85fdfd799cb55d63083f729","2791098946","no");
INSERT INTO `wp_options` VALUES("235702","_wp_session_expires_28360b3883094704fbf587a4905516ea","2791107484","no");
INSERT INTO `wp_options` VALUES("236691","_wp_session_40e1e7074487ba7d278b8f800846f780","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f0749304ebd9da96ad5a5ef725a6d790\";}\";}","no");
INSERT INTO `wp_options` VALUES("235757","_wp_session_fca429c45c79539dfafc84998af5a291","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a5643b065c9aa4a51947f46c9d8f38c3\";}\";}","no");
INSERT INTO `wp_options` VALUES("235758","_wp_session_expires_fca429c45c79539dfafc84998af5a291","2791115468","no");
INSERT INTO `wp_options` VALUES("235777","_wp_session_b7ebe288b272b5dcda5b4f10be5aaa48","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"f48c296e52946a84e984b8111c33335c\";}\";}","no");
INSERT INTO `wp_options` VALUES("235813","_wp_session_e83a8a9d7eac2f87e864331adc564daf","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7c578ba99b03bb7c95b063964b1873af\";}\";}","no");
INSERT INTO `wp_options` VALUES("235814","_wp_session_expires_e83a8a9d7eac2f87e864331adc564daf","2791125680","no");
INSERT INTO `wp_options` VALUES("235909","_wp_session_b5b08e967cdb938ec87330ab6c5ed564","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("235936","_wp_session_expires_c2189ce75858d1d93cf2b30bd8631d6d","2791147788","no");
INSERT INTO `wp_options` VALUES("235908","_wp_session_expires_b5b08e967cdb938ec87330ab6c5ed564","2791140268","no");
INSERT INTO `wp_options` VALUES("236029","_wp_session_expires_787e27eec70cd9fba734bc73310402fb","2791163656","no");
INSERT INTO `wp_options` VALUES("235981","_wp_session_6ba4aa622a0360a34ba87cea8be44740","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("235980","_wp_session_expires_6ba4aa622a0360a34ba87cea8be44740","2791154780","no");
INSERT INTO `wp_options` VALUES("236030","_wp_session_787e27eec70cd9fba734bc73310402fb","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("236692","_wp_session_expires_40e1e7074487ba7d278b8f800846f780","2791252370","no");
INSERT INTO `wp_options` VALUES("236949","_wp_session_1186ae3c8bcda5d84a8c2aaacb2816da","a:1:{s:11:\"vfb-token-1\";N;}","no");
INSERT INTO `wp_options` VALUES("236948","_wp_session_expires_1186ae3c8bcda5d84a8c2aaacb2816da","2791286548","no");
INSERT INTO `wp_options` VALUES("241614","_wp_session_9e8b714f54b867a5005e5359d789dbc8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"df363c8a3f068aad89bba626f8706d22\";}\";}","no");
INSERT INTO `wp_options` VALUES("237695","_wp_session_a7215c6e175f5386eb48de7fa00fff74","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e62a1c302c1078e77a1cf83c9fd606e3\";}\";}","no");
INSERT INTO `wp_options` VALUES("238372","_wp_session_expires_58431ec953479a18fa00625037b803f6","2791463094","no");
INSERT INTO `wp_options` VALUES("236706","_wp_session_92fbd8624beaa4428b80937576ac556a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ffe600044ba577662ecbe8424dcfa662\";}\";}","no");
INSERT INTO `wp_options` VALUES("236707","_wp_session_expires_92fbd8624beaa4428b80937576ac556a","2791256218","no");
INSERT INTO `wp_options` VALUES("236743","_wp_session_expires_10da52a92ec8043f11fdafd6ec4b23e5","2791261110","no");
INSERT INTO `wp_options` VALUES("236757","_wp_session_expires_bf70402cc23266d4be83ec07bb33f90c","2791264994","no");
INSERT INTO `wp_options` VALUES("236759","_wp_session_expires_2587087417d01b2c75938e30d2be6e9a","2791264994","no");
INSERT INTO `wp_options` VALUES("236763","_wp_session_expires_a3ce46269275e0a1e331e8b1bc6a9fd8","2791265002","no");
INSERT INTO `wp_options` VALUES("236765","_wp_session_expires_7db4ea7eb258dbb6b7302bd7999981fc","2791265008","no");
INSERT INTO `wp_options` VALUES("236783","_wp_session_4c750894d2122679113af81031dc9d71","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"703fd59d329f2901559ae40d6b1f864c\";}\";}","no");
INSERT INTO `wp_options` VALUES("236784","_wp_session_expires_4c750894d2122679113af81031dc9d71","2791268888","no");
INSERT INTO `wp_options` VALUES("236896","_wp_session_edc80a223a89c2b76b76fc731873de95","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"c324f8315fb5861f72344af83f3fc7cb\";}\";}","no");
INSERT INTO `wp_options` VALUES("236897","_wp_session_expires_edc80a223a89c2b76b76fc731873de95","2791281454","no");
INSERT INTO `wp_options` VALUES("238257","_wp_session_expires_0ceb682d65fca097b4e35123d662c8cd","2791449950","no");
INSERT INTO `wp_options` VALUES("238293","_wp_session_expires_9cd42a4d05d37029f33b92616fc0d9ca","2791454050","no");
INSERT INTO `wp_options` VALUES("238330","_wp_session_43497453a288157ccbc7fbc008e8fbb8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"14f77071649e5c669eb831a42117c5a7\";}\";}","no");
INSERT INTO `wp_options` VALUES("237696","_wp_session_expires_a7215c6e175f5386eb48de7fa00fff74","2791394320","no");
INSERT INTO `wp_options` VALUES("237788","_wp_session_expires_f2af2eb58b5ff58b1b87b5506a76a193","2791410330","no");
INSERT INTO `wp_options` VALUES("237921","_wp_session_ba417059e4943834e8bfe206d79710f4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9db2386d4a6bceff180463a169fc247a\";}\";}","no");
INSERT INTO `wp_options` VALUES("237922","_wp_session_expires_ba417059e4943834e8bfe206d79710f4","2791415680","no");
INSERT INTO `wp_options` VALUES("238112","_wp_session_90ffc4acfb1d8083e5a916082d966cff","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"88ba8986f3c63c1deb968fc8a88698e0\";}\";}","no");
INSERT INTO `wp_options` VALUES("241801","_wp_session_expires_8d800887e258c80a414c5797f28c453d","2791783842","no");
INSERT INTO `wp_options` VALUES("237953","_wp_session_expires_90b6468e5912e8c838df299ff958eaf4","2791419840","no");
INSERT INTO `wp_options` VALUES("237955","_wp_session_expires_a7d0d32a0058c91847787028f7ac10ab","2791419844","no");
INSERT INTO `wp_options` VALUES("237999","_wp_session_expires_d7139454f839075439913ecbfed04c58","2791424576","no");
INSERT INTO `wp_options` VALUES("238113","_wp_session_expires_90ffc4acfb1d8083e5a916082d966cff","2791440922","no");
INSERT INTO `wp_options` VALUES("239666","_wp_session_0d0742ce1da3723b3e7d6e6bf0e57b71","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"a3d4a734787e17bf3a57cca042b7edd6\";}\";}","no");
INSERT INTO `wp_options` VALUES("239120","_wp_session_f2ff153de120302dd5675295d1ea6f02","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"82d899f8b0676891bdc64b9f58b71a10\";}\";}","no");
INSERT INTO `wp_options` VALUES("238213","_wp_session_b08683cac1c281b33cea09c002344dc2","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9474d7dcfae5dbe9dc8f7bc515959641\";}\";}","no");
INSERT INTO `wp_options` VALUES("238214","_wp_session_expires_b08683cac1c281b33cea09c002344dc2","2791445192","no");
INSERT INTO `wp_options` VALUES("239121","_wp_session_expires_f2ff153de120302dd5675295d1ea6f02","2791572354","no");
INSERT INTO `wp_options` VALUES("238156","_wp_session_a36bae3bd08e3ddfda87a076680657d3","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"133fd202624f4c152b464a8a653817f4\";}\";}","no");
INSERT INTO `wp_options` VALUES("238138","_wp_session_expires_a36bae3bd08e3ddfda87a076680657d3","2791441278","no");
INSERT INTO `wp_options` VALUES("238177","_wp_session_49b9a6f09e15af3919a3bacf15c7fd96","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6bf629bc7ad18dd83f0bcdc9dae060d5\";}\";}","no");
INSERT INTO `wp_options` VALUES("238178","_wp_session_expires_49b9a6f09e15af3919a3bacf15c7fd96","2791444364","no");
INSERT INTO `wp_options` VALUES("238179","_wp_session_expires_56ec040efd622492cb96765681303379","2791444426","no");
INSERT INTO `wp_options` VALUES("238181","_wp_session_expires_14bedd4c70fa974c3fc6cbbb1ff8f4b6","2791444428","no");
INSERT INTO `wp_options` VALUES("238729","_wp_session_c7463534ff3cd3297e56e77e3e05345f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e2a1c8c51e3aa671a0d781921ddbfa60\";}\";}","no");
INSERT INTO `wp_options` VALUES("238256","_wp_session_0ceb682d65fca097b4e35123d662c8cd","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"be888e7381b4b6fbb0587b05571342ec\";}\";}","no");
INSERT INTO `wp_options` VALUES("238331","_wp_session_expires_43497453a288157ccbc7fbc008e8fbb8","2791456584","no");
INSERT INTO `wp_options` VALUES("238333","_wp_session_fe333af005e1fb28457034a298859fd9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"881f355ae928ae937279e28285a631f9\";}\";}","no");
INSERT INTO `wp_options` VALUES("238334","_wp_session_expires_fe333af005e1fb28457034a298859fd9","2791456660","no");
INSERT INTO `wp_options` VALUES("238361","_wp_session_84402e7e29016039e9b8f541e1ee1729","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"9d872d0750879bb9885393a2064e1a45\";}\";}","no");
INSERT INTO `wp_options` VALUES("238362","_wp_session_expires_84402e7e29016039e9b8f541e1ee1729","2791461528","no");
INSERT INTO `wp_options` VALUES("238369","_wp_session_13868f08c948fcc7927ce95ea902b161","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8c14a1c47031022c965791293852af03\";}\";}","no");
INSERT INTO `wp_options` VALUES("238370","_wp_session_expires_13868f08c948fcc7927ce95ea902b161","2791462648","no");
INSERT INTO `wp_options` VALUES("238412","_wp_session_ca7ae4d95254e0e8d0abcb8a7b0300e4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1d76d3505523e88284a65433fb49056e\";}\";}","no");
INSERT INTO `wp_options` VALUES("238413","_wp_session_expires_ca7ae4d95254e0e8d0abcb8a7b0300e4","2791468050","no");
INSERT INTO `wp_options` VALUES("238415","_wp_session_06a389e3926600671cae7c239769a9ab","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d0e242ee794a95a6be64a226750e521d\";}\";}","no");
INSERT INTO `wp_options` VALUES("238416","_wp_session_expires_06a389e3926600671cae7c239769a9ab","2791468122","no");
INSERT INTO `wp_options` VALUES("238425","_wp_session_d20c7d3faba4d2161d1f4f72af3c0fb7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ee2b66f5e7513e424defa90bf25205ae\";}\";}","no");
INSERT INTO `wp_options` VALUES("238426","_wp_session_expires_d20c7d3faba4d2161d1f4f72af3c0fb7","2791468672","no");
INSERT INTO `wp_options` VALUES("238435","_wp_session_fd88d07677bbe1ab655ba7076b59fe36","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6dc007d4f1107621775bd1c22e451457\";}\";}","no");
INSERT INTO `wp_options` VALUES("238436","_wp_session_expires_fd88d07677bbe1ab655ba7076b59fe36","2791469736","no");
INSERT INTO `wp_options` VALUES("238440","_wp_session_25091dd46653320ce256af91fe924962","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"193e6c544ec3d6751fd7aafa113b2fc6\";}\";}","no");
INSERT INTO `wp_options` VALUES("238441","_wp_session_expires_25091dd46653320ce256af91fe924962","2791470276","no");
INSERT INTO `wp_options` VALUES("238451","_wp_session_d09d46366fac7ea0bac6d0d3efa5621a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1ea8ce3d19b5b4959e4da5e789bc916a\";}\";}","no");
INSERT INTO `wp_options` VALUES("238452","_wp_session_expires_d09d46366fac7ea0bac6d0d3efa5621a","2791470716","no");
INSERT INTO `wp_options` VALUES("238456","_wp_session_dc50ddb6a57e2515a12ca4d9304c47b4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"0ce300dc8eee6b0ef9612ac44b3fa0a6\";}\";}","no");
INSERT INTO `wp_options` VALUES("238457","_wp_session_expires_dc50ddb6a57e2515a12ca4d9304c47b4","2791470928","no");
INSERT INTO `wp_options` VALUES("238460","_wp_session_726a5d90a7075c10aafd341646b4ecc9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"8cba8a4defa05cdbc2f2bb2bb7bd3dee\";}\";}","no");
INSERT INTO `wp_options` VALUES("238461","_wp_session_expires_726a5d90a7075c10aafd341646b4ecc9","2791471150","no");
INSERT INTO `wp_options` VALUES("238471","_wp_session_a9b6810d5d38872b7468f0684429fb32","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5b2932992dec9a1b64519204afa257aa\";}\";}","no");
INSERT INTO `wp_options` VALUES("238472","_wp_session_expires_a9b6810d5d38872b7468f0684429fb32","2791471828","no");
INSERT INTO `wp_options` VALUES("238478","_wp_session_8a8f3f8c398134448603e80a06bf4f94","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"7f16164dfcae6a974aa59708ce436ff0\";}\";}","no");
INSERT INTO `wp_options` VALUES("238479","_wp_session_expires_8a8f3f8c398134448603e80a06bf4f94","2791472556","no");
INSERT INTO `wp_options` VALUES("238487","_wp_session_9825a4e5a368ddbc23b2ff89d30b99a7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e64ac3a6cc613d192e319d0c496b250d\";}\";}","no");
INSERT INTO `wp_options` VALUES("238488","_wp_session_expires_9825a4e5a368ddbc23b2ff89d30b99a7","2791472710","no");
INSERT INTO `wp_options` VALUES("238730","_wp_session_expires_c7463534ff3cd3297e56e77e3e05345f","2791510220","no");
INSERT INTO `wp_options` VALUES("240215","_wp_session_expires_494e58ab89235e60d475eeb7fb21bc12","2791619446","no");
INSERT INTO `wp_options` VALUES("240343","_wp_session_expires_9c48bd2adf90533b0e698b0e43a88d0b","2791627894","no");
INSERT INTO `wp_options` VALUES("240361","_wp_session_21fdaa42fe6c1b4aa851cb710a4cdfa7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"041bd5c482f5e6c0f197a03c44a63870\";}\";}","no");
INSERT INTO `wp_options` VALUES("240362","_wp_session_expires_21fdaa42fe6c1b4aa851cb710a4cdfa7","2791630166","no");
INSERT INTO `wp_options` VALUES("240364","_wp_session_fbf518914ef6aeb22c4dcf64f6f789e5","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b1d61e0fb43361fefefb61537de942d6\";}\";}","no");
INSERT INTO `wp_options` VALUES("239019","_wp_session_expires_47971cd4b47c0e3415450c9d49423f28","2791560126","no");
INSERT INTO `wp_options` VALUES("239667","_wp_session_expires_0d0742ce1da3723b3e7d6e6bf0e57b71","2791580214","no");
INSERT INTO `wp_options` VALUES("239721","_wp_session_474151e649c938ced9bd93b32cc66bd9","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b702ff460b132da5f04a83d61574ffc2\";}\";}","no");
INSERT INTO `wp_options` VALUES("239722","_wp_session_expires_474151e649c938ced9bd93b32cc66bd9","2791583944","no");
INSERT INTO `wp_options` VALUES("239748","_wp_session_expires_c15337e122e1f0fe753e9d034528ac1c","2791588908","no");
INSERT INTO `wp_options` VALUES("239786","_wp_session_expires_35c077ba76d827a982979fa45f3c1805","2791592796","no");
INSERT INTO `wp_options` VALUES("239781","_wp_session_expires_3635e0c78a4cd66682677235a19058f4","2791592770","no");
INSERT INTO `wp_options` VALUES("239783","_wp_session_expires_069b6493e800cb393a0a8c91cc1d2cfe","2791592790","no");
INSERT INTO `wp_options` VALUES("239888","_wp_session_5fa03c57bda03d1ccd3faf8782bc0fd1","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"dea8e4b9f02af2f734bea75ae4cccc71\";}\";}","no");
INSERT INTO `wp_options` VALUES("239794","_wp_session_aa2921e5a21b866cacebba9c8de23daa","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"588d992b2e02aaa4a95a0cda4de793b8\";}\";}","no");
INSERT INTO `wp_options` VALUES("239795","_wp_session_expires_aa2921e5a21b866cacebba9c8de23daa","2791593498","no");
INSERT INTO `wp_options` VALUES("239822","_wp_session_d2f2b46b17abaf5c505faa160a1bc4fa","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"484513dee5afd8b71fca930eb6570eb2\";}\";}","no");
INSERT INTO `wp_options` VALUES("239823","_wp_session_expires_d2f2b46b17abaf5c505faa160a1bc4fa","2791596960","no");
INSERT INTO `wp_options` VALUES("239847","_wp_session_aa11726b6a85d788512450adf7575388","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"16e36ccb8c5b60463f99020b97240b30\";}\";}","no");
INSERT INTO `wp_options` VALUES("239848","_wp_session_expires_aa11726b6a85d788512450adf7575388","2791597874","no");
INSERT INTO `wp_options` VALUES("239859","_wp_session_4f18e8c3f484aa286a42bbcee725b430","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"6c8a978d40786d1c59dc447e56b9ef6f\";}\";}","no");
INSERT INTO `wp_options` VALUES("239860","_wp_session_expires_4f18e8c3f484aa286a42bbcee725b430","2791598030","no");
INSERT INTO `wp_options` VALUES("239864","_wp_session_0becfb34d84d5be210892831fd3a55a4","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"780b3b2e195716d1c470bfb7ac3ef3b8\";}\";}","no");
INSERT INTO `wp_options` VALUES("239865","_wp_session_expires_0becfb34d84d5be210892831fd3a55a4","2791598254","no");
INSERT INTO `wp_options` VALUES("239870","_wp_session_b564492dd77c8724f261140aef3b7421","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"4e50d6e7d580a7c78e4be9419dc74b39\";}\";}","no");
INSERT INTO `wp_options` VALUES("239871","_wp_session_expires_b564492dd77c8724f261140aef3b7421","2791598684","no");
INSERT INTO `wp_options` VALUES("239875","_wp_session_53d287680769f2c99a046fc692b77f0a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"602c27bd9b87d256b4d510f5e270c9aa\";}\";}","no");
INSERT INTO `wp_options` VALUES("239876","_wp_session_expires_53d287680769f2c99a046fc692b77f0a","2791598806","no");
INSERT INTO `wp_options` VALUES("239889","_wp_session_expires_5fa03c57bda03d1ccd3faf8782bc0fd1","2791599618","no");
INSERT INTO `wp_options` VALUES("239894","_wp_session_308120b7412ae042a5b91c17640dbba8","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"910ee5d654df8a0ee07b4bfa67175296\";}\";}","no");
INSERT INTO `wp_options` VALUES("239895","_wp_session_expires_308120b7412ae042a5b91c17640dbba8","2791599960","no");
INSERT INTO `wp_options` VALUES("239900","_wp_session_521f033763db925c1ae1d2cc9261638f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1056e97f62875e900ab3871930ae974a\";}\";}","no");
INSERT INTO `wp_options` VALUES("239901","_wp_session_expires_521f033763db925c1ae1d2cc9261638f","2791600634","no");
INSERT INTO `wp_options` VALUES("239947","_wp_session_5c930890ca235dfd8add4f07814e8083","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"42e7b32e89acfa07242bbb32d6504e9b\";}\";}","no");
INSERT INTO `wp_options` VALUES("395598","itsec_global","a:20:{s:11:\"write_files\";b:1;s:18:\"notification_email\";a:1:{i:0;s:24:\"williamchang23@gmail.com\";}s:12:\"backup_email\";a:1:{i:0;s:24:\"williamchang23@gmail.com\";}s:15:\"lockout_message\";s:5:\"error\";s:20:\"user_lockout_message\";s:56:\"You have been locked out due to too many login attempts.\";s:9:\"blacklist\";b:1;s:15:\"blacklist_count\";i:3;s:16:\"blacklist_period\";i:7;s:14:\"lockout_period\";i:15;s:18:\"lockout_white_list\";a:0:{}s:19:\"email_notifications\";b:1;s:8:\"log_type\";i:0;s:12:\"log_rotation\";i:30;s:12:\"log_location\";s:83:\"/home/changtwo/public_html/williamchangnew/wp-content/uploads/ithemes-security/logs\";s:11:\"did_upgrade\";b:0;s:14:\"allow_tracking\";b:0;s:10:\"nginx_file\";s:53:\"/home/changtwo/public_html/williamchangnew/nginx.conf\";s:24:\"infinitewp_compatibility\";b:0;s:8:\"log_info\";s:25:\"nyc-wedding-photogra-vyAK\";s:9:\"lock_file\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("239948","_wp_session_expires_5c930890ca235dfd8add4f07814e8083","2791604482","no");
INSERT INTO `wp_options` VALUES("240094","_wp_session_8d800887e258c80a414c5797f28c453d","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5f2d39baaac68dbb38e9fe28d2f7d2c1\";}\";}","no");
INSERT INTO `wp_options` VALUES("240141","_wp_session_332b584ed0545ddbb9113a6d124bcf3f","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"efe21e80aa433760ab5ef192cc1d901e\";}\";}","no");
INSERT INTO `wp_options` VALUES("240142","_wp_session_expires_332b584ed0545ddbb9113a6d124bcf3f","2791613936","no");
INSERT INTO `wp_options` VALUES("240152","_wp_session_e6fb9a31bc9067189cffd5e5996d7e6a","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"1ffce920799fea1b9c5f6b7cb917ab89\";}\";}","no");
INSERT INTO `wp_options` VALUES("240153","_wp_session_expires_e6fb9a31bc9067189cffd5e5996d7e6a","2791614428","no");
INSERT INTO `wp_options` VALUES("240171","_wp_session_c7dd4e35a2fd8e3f6d8d92a612856535","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b8850f674a8bf6d849d5165097ec6e29\";}\";}","no");
INSERT INTO `wp_options` VALUES("240172","_wp_session_expires_c7dd4e35a2fd8e3f6d8d92a612856535","2791615644","no");
INSERT INTO `wp_options` VALUES("240342","_wp_session_9c48bd2adf90533b0e698b0e43a88d0b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"e6c3774ada4a67579fc80f31af2e9c7a\";}\";}","no");
INSERT INTO `wp_options` VALUES("240214","_wp_session_494e58ab89235e60d475eeb7fb21bc12","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"5f1a18f2318af89a103403462bdcbcf1\";}\";}","no");
INSERT INTO `wp_options` VALUES("240365","_wp_session_expires_fbf518914ef6aeb22c4dcf64f6f789e5","2791630172","no");
INSERT INTO `wp_options` VALUES("240449","_wp_session_expires_5ee950869eccdd36f69747b4eb80a012","2791645754","no");
INSERT INTO `wp_options` VALUES("240608","_wp_session_expires_dc7391ad8121783e59cbcc593ed2abca","2791661066","no");
INSERT INTO `wp_options` VALUES("240497","_wp_session_89c242ff21f06765590f1569a191ec82","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"b88bc18b0b0385b3cfc0c83b797a32da\";}\";}","no");
INSERT INTO `wp_options` VALUES("240498","_wp_session_expires_89c242ff21f06765590f1569a191ec82","2791650816","no");
INSERT INTO `wp_options` VALUES("240500","_wp_session_27017f39a1d6b6c6641cff4ea03c7b23","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"aa360f72b77357c5fe7af5600ced9e61\";}\";}","no");
INSERT INTO `wp_options` VALUES("240501","_wp_session_expires_27017f39a1d6b6c6641cff4ea03c7b23","2791650824","no");
INSERT INTO `wp_options` VALUES("240508","_wp_session_5f6306196e27c74e9bda95f54feb19c7","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"ca70461db29cd7df4ffddb29053ca978\";}\";}","no");
INSERT INTO `wp_options` VALUES("240509","_wp_session_expires_5f6306196e27c74e9bda95f54feb19c7","2791651734","no");
INSERT INTO `wp_options` VALUES("240511","_wp_session_e986d020576670df9ca637fa5d97687e","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"d75c8acdcc6a5294b0ecc57dc66a558b\";}\";}","no");
INSERT INTO `wp_options` VALUES("240512","_wp_session_expires_e986d020576670df9ca637fa5d97687e","2791651742","no");
INSERT INTO `wp_options` VALUES("240515","_wp_session_4bd45b707bcbfab04f33b4f395383b00","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3fa17b51c2d57cff2721a5678730349a\";}\";}","no");
INSERT INTO `wp_options` VALUES("240516","_wp_session_expires_4bd45b707bcbfab04f33b4f395383b00","2791653164","no");
INSERT INTO `wp_options` VALUES("240518","_wp_session_01e83fbe8edc3df5aeddbf0e64146f6b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"df0855a9ab95e21746375c970246695e\";}\";}","no");
INSERT INTO `wp_options` VALUES("240519","_wp_session_expires_01e83fbe8edc3df5aeddbf0e64146f6b","2791653172","no");
INSERT INTO `wp_options` VALUES("240607","_wp_session_dc7391ad8121783e59cbcc593ed2abca","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"3598dba286ca38f5351fe2b6be2b79ec\";}\";}","no");
INSERT INTO `wp_options` VALUES("240793","_wp_session_bac385b81c786c5702855a2991b2556b","a:1:{s:11:\"vfb-token-1\";s:68:\"a:1:{s:14:\"vfb-csrf-token\";s:32:\"fb789d9c4371b1999531df960a119af1\";}\";}","no");
INSERT INTO `wp_options` VALUES("240794","_wp_session_expires_bac385b81c786c5702855a2991b2556b","2791689182","no");
INSERT INTO `wp_options` VALUES("1106708","_site_transient_timeout_itsec_upload_dir","1449020101","yes");
INSERT INTO `wp_options` VALUES("1106709","_site_transient_itsec_upload_dir","a:6:{s:4:\"path\";s:69:\"/home/changtwo/public_html/williamchangnew/wp-content/uploads/2015/11\";s:3:\"url\";s:51:\"http://william-chang.com/wp-content/uploads/2015/11\";s:6:\"subdir\";s:8:\"/2015/11\";s:7:\"basedir\";s:61:\"/home/changtwo/public_html/williamchangnew/wp-content/uploads\";s:7:\"baseurl\";s:43:\"http://william-chang.com/wp-content/uploads\";s:5:\"error\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("395597","itsec_data","a:5:{s:5:\"build\";i:4038;s:20:\"activation_timestamp\";i:1405643005;s:17:\"already_supported\";b:1;s:15:\"setup_completed\";b:1;s:18:\"tooltips_dismissed\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("241615","_wp_session_expires_9e8b714f54b867a5005e5359d789dbc8","2791763644","no");
INSERT INTO `wp_options` VALUES("326389","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("326390","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("395599","itsec_initials","a:3:{s:5:\"login\";b:0;s:5:\"admin\";b:0;s:11:\"file_editor\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("481645","duplicate_post_copyexcerpt","1","yes");
INSERT INTO `wp_options` VALUES("481646","duplicate_post_copyattachments","0","yes");
INSERT INTO `wp_options` VALUES("481647","duplicate_post_copychildren","0","yes");
INSERT INTO `wp_options` VALUES("481648","duplicate_post_copystatus","0","yes");
INSERT INTO `wp_options` VALUES("481649","duplicate_post_taxonomies_blacklist","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("481650","duplicate_post_show_row","1","yes");
INSERT INTO `wp_options` VALUES("481651","duplicate_post_show_adminbar","1","yes");
INSERT INTO `wp_options` VALUES("481652","duplicate_post_show_submitbox","1","yes");
INSERT INTO `wp_options` VALUES("481653","duplicate_post_version","2.6","yes");
INSERT INTO `wp_options` VALUES("395778","itsec_local_file_list","a:6363:{s:66:\"wp-content/plugins/kiwi-logo-carousel/kiwi_logo_carousel_order.php\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"398d8f6ceda339dacd3f5d1f7d2cc645\";}s:66:\"wp-content/plugins/kiwi-logo-carousel/kiwi_logo_carousel_admin.php\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"dc35f2736badc2f85578b982915380c8\";}s:60:\"wp-content/plugins/kiwi-logo-carousel/kiwi_logo_carousel.php\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"0ea6caf7e65f5521ea1959b79d3642c9\";}s:70:\"wp-content/plugins/kiwi-logo-carousel/languages/kiwi_logo_carousel.pot\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"69b390014cb6cd405adbd83901c80678\";}s:48:\"wp-content/plugins/kiwi-logo-carousel/readme.txt\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"d17ec8d475a4cb22399fc5819e7faf2a\";}s:84:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/jquery.bxslider.js\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"d7cbb6325591d3903b0bdd89733ba18c\";}s:91:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/plugins/jquery.fitvids.js\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"55e813eb3e253f97bb8053bffe8c6b49\";}s:94:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/plugins/jquery.easing.1.3.js\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"6516449ed5089677ed3d7e2f11fc8942\";}s:88:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/jquery.bxslider.min.js\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"b860635957ed570deb2cf994bd9a4913\";}s:75:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/readme.md\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"2b8f1f06b666052a8363f9f507fb6402\";}s:85:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/jquery.bxslider.css\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"0e97524a87bac1c6538097eb64f64b83\";}s:86:\"wp-content/plugins/kiwi-logo-carousel/third-party/jquery.bxslider/images/bx_loader.gif\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"931bdb6b50816b03206c66921760b246\";}s:95:\"wp-content/plugins/kiwi-logo-carousel/third-party/simple-page-ordering/simple-page-ordering.css\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"a3984773a9f3c21ce29f3df5c18cbf0b\";}s:94:\"wp-content/plugins/kiwi-logo-carousel/third-party/simple-page-ordering/simple-page-ordering.js\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"0f363d2220adaa7ac71c2d45e808585f\";}s:55:\"wp-content/plugins/kiwi-logo-carousel/custom-styles.css\";a:2:{s:1:\"d\";i:1439864794;s:1:\"h\";s:32:\"dfd1f4f7156caf69739cc817d704790e\";}s:74:\"wp-content/plugins/jquery-pin-it-button-for-images/js/upload-button-old.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"417363733f5b83b56ae998fe03004889\";}s:67:\"wp-content/plugins/jquery-pin-it-button-for-images/js/script.min.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"fc80cc347fc50b9656278604bdc9cf2d\";}s:74:\"wp-content/plugins/jquery-pin-it-button-for-images/js/upload-button-new.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"5338c3961f91bd0fdfab6e0f9ded542c\";}s:63:\"wp-content/plugins/jquery-pin-it-button-for-images/js/script.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"e9c2e882502db9fa22cac7bc039b7101\";}s:62:\"wp-content/plugins/jquery-pin-it-button-for-images/js/admin.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"d7286cd2f22e2a9646ceb12e0e56f161\";}s:70:\"wp-content/plugins/jquery-pin-it-button-for-images/js/admin-angular.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"06cb7fbc72ead583a4d4c98f6510bbbe\";}s:68:\"wp-content/plugins/jquery-pin-it-button-for-images/js/angular.min.js\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"75fb813ebaad1186f9fcd88fc2e9abb2\";}s:77:\"wp-content/plugins/jquery-pin-it-button-for-images/languages/jpibfi-es_ES.pot\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"5b49d9e30e4bedb9436c15c791e3f7f0\";}s:71:\"wp-content/plugins/jquery-pin-it-button-for-images/languages/jpibfi.pot\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"afe6c9e6ffc7e23052aa0f2c82137599\";}s:70:\"wp-content/plugins/jquery-pin-it-button-for-images/languages/index.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"803f140ddcb5ac869ecb7f47cf05350d\";}s:61:\"wp-content/plugins/jquery-pin-it-button-for-images/readme.txt\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"16baaf294f74527b133f86e2c0b7aedc\";}s:64:\"wp-content/plugins/jquery-pin-it-button-for-images/uninstall.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"76a4f074f8382aa9b3e4c187fa22e6de\";}s:97:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-visual-options.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"4a6f454a466615558b53555b311b23c9\";}s:98:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-admin-utilities.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"4d76848ed44a3c5d2f442a5767feda17\";}s:99:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-advanced-options.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"e25ff2e826dcb5850811740c7ee6f3d0\";}s:100:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-selection-options.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"6a02f962cc911498d8d27e6c0557d3e8\";}s:88:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-admin.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"d3d930ab67799cacceb53d09d46f6ae0\";}s:82:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/notice.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"2368a568619621ee2037135a3b7f0820\";}s:81:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/admin.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"048e849f0b2ec9cabb875fa46042c147\";}s:81:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/index.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:75:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/index.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:90:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/public/class-jpibfi-client.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"2c1235b3d6ddc795411dcb7a74fa6ccd\";}s:76:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/public/index.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:100:\"wp-content/plugins/jquery-pin-it-button-for-images/includes/public/class-jpibfi-client-utilities.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"de5f394f34d9db28f32e5ee6918080fc\";}s:60:\"wp-content/plugins/jquery-pin-it-button-for-images/index.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"9dceb70bad5cdbd631a99f968710b231\";}s:86:\"wp-content/plugins/jquery-pin-it-button-for-images/jquery-pin-it-button-for-images.php\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"76d28680cb05a76604f7eb536997c0c7\";}s:64:\"wp-content/plugins/jquery-pin-it-button-for-images/css/admin.css\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"69511a63d9c2d5aa86cbcd833b2c7aa7\";}s:64:\"wp-content/plugins/jquery-pin-it-button-for-images/css/style.css\";a:2:{s:1:\"d\";i:1411010304;s:1:\"h\";s:32:\"516e53d4bc096e5346c198cfc4e96eae\";}s:28:\"wp-content/plugins/hello.php\";a:2:{s:1:\"d\";i:1369274920;s:1:\"h\";s:32:\"52a7f011f362416f939a74215f7ebd12\";}s:43:\"wp-content/plugins/akismet/_inc/akismet.css\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"c8e7914736523e594837705d2c0e2714\";}s:39:\"wp-content/plugins/akismet/_inc/form.js\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"270f0cd7341bce6c2afacf2682e7690e\";}s:42:\"wp-content/plugins/akismet/_inc/akismet.js\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"09c02c732a401323bce97f3fc2b1e637\";}s:38:\"wp-content/plugins/akismet/akismet.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"c8a110c01b916aed48ca3fa41674d57d\";}s:44:\"wp-content/plugins/akismet/class.akismet.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"dedbe439abb24d15e7ee6a967c16b91a\";}s:50:\"wp-content/plugins/akismet/class.akismet-admin.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"1ea640fc01c689987bb35a11a6f8f885\";}s:38:\"wp-content/plugins/akismet/wrapper.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"f65ade0e264d0d4cbc42e28745198e23\";}s:37:\"wp-content/plugins/akismet/readme.txt\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"6c971cb404551dfcc03a063d9b209852\";}s:42:\"wp-content/plugins/akismet/views/stats.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"4491e9d145c5610b78fe742fa95a5420\";}s:43:\"wp-content/plugins/akismet/views/config.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"8571cc76976d930a6e53abe8e90c6db9\";}s:42:\"wp-content/plugins/akismet/views/start.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"52d19694ec16d382f7a0acecb7bf8c9a\";}s:43:\"wp-content/plugins/akismet/views/strict.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"c74eba0324f8a62b9b1ef94355861fb1\";}s:40:\"wp-content/plugins/akismet/views/get.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"7ba85bb5bdca316f6bd7a1d01b21d7d6\";}s:43:\"wp-content/plugins/akismet/views/notice.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"1e864b2ce92a5735317c49704a001a39\";}s:36:\"wp-content/plugins/akismet/index.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"cf6895af2050eb5ae7c0badda2604566\";}s:36:\"wp-content/plugins/akismet/.htaccess\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"d510e02c22cbdaa87747e769bcd916f5\";}s:51:\"wp-content/plugins/akismet/class.akismet-widget.php\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"ac2fc222d96b3c291fbcc74b8420b180\";}s:38:\"wp-content/plugins/akismet/LICENSE.txt\";a:2:{s:1:\"d\";i:1444782459;s:1:\"h\";s:32:\"b234ee4d69f5fce4486a80fdaf4a4263\";}s:68:\"wp-content/plugins/ap-extended-mime-types/ap-extended-mime-types.php\";a:2:{s:1:\"d\";i:1407813554;s:1:\"h\";s:32:\"dc79b394e50d0716de2b49aab5d29739\";}s:56:\"wp-content/plugins/ap-extended-mime-types/mime-types.txt\";a:2:{s:1:\"d\";i:1407813554;s:1:\"h\";s:32:\"53c60c91c08f1b29f1c4b9292babcee4\";}s:52:\"wp-content/plugins/ap-extended-mime-types/readme.txt\";a:2:{s:1:\"d\";i:1407813554;s:1:\"h\";s:32:\"8ff97184ba601fd8ecd11b5d2fcd24f8\";}s:59:\"wp-content/plugins/visual-form-builder-pro/form-preview.php\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"01d5a65a8cc549c288161581d32b7b3e\";}s:63:\"wp-content/plugins/visual-form-builder-pro/js/farbtastic.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"12dac67c39528e3b60b5ab9120cc13d4\";}s:68:\"wp-content/plugins/visual-form-builder-pro/js/jquery.metadata.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"059353487d65b302c4c1def7bbc59d1a\";}s:63:\"wp-content/plugins/visual-form-builder-pro/js/vfb-charts.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"73563826a10a61d97cbbd1d63a9ce5c2\";}s:59:\"wp-content/plugins/visual-form-builder-pro/js/vfb-charts.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f9bffb30ce986e4a9c2da4b36c53f2b8\";}s:63:\"wp-content/plugins/visual-form-builder-pro/js/vfb-validation.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f6b9ecc9b0e8fbcf03c026466153a0dd\";}s:58:\"wp-content/plugins/visual-form-builder-pro/js/vfb-admin.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c21c663727167fea467a70be1def87f7\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/jquery.ui.nestedSortable.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"e60dd2c9bacfa3522ef965dfda22022e\";}s:67:\"wp-content/plugins/visual-form-builder-pro/js/vfb-validation.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"e1be964c7a9b55b6dab5c256fdb6ad5f\";}s:59:\"wp-content/plugins/visual-form-builder-pro/js/farbtastic.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"2b34a0700c7a8746a29efecec9e2aad9\";}s:69:\"wp-content/plugins/visual-form-builder-pro/js/jquery.ui.timepicker.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d50b3dfccda2165e7881769922964131\";}s:83:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog_opera.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"61c2a2b27050f4564fb38d2af8975004\";}s:86:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor_iequirks.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"05187618ee7ac67630db33e5335d7b2b\";}s:83:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor_gecko.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"1643ab359598be48e257d1dc8df6564e\";}s:80:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor_ie.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"3eca9644101a3ce6d28bc40b7a4bf77f\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor_ie8.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"ca8514075be92412bd1fbee41e5c9a88\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor_ie7.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c065f7b98dfce0a40cc2e9f01b3eba49\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"16f82e3221956b72bdb7d569883ef789\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/editor.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"86998996d5bded72252c699ef65cf929\";}s:76:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/readme.md\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"a2e00abd50e5d5f7edb67d7de9f3216c\";}s:86:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog_iequirks.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"b0acb95e134fba8de6f3451e1401ea9a\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog_ie7.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d3036e6c6eec00d81096d7f653380ed8\";}s:80:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog_ie.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"4e61cf344391e683be30f28b08eb075f\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/skins/moono/dialog_ie8.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f07d4442a2ca3e068f8962952fe41519\";}s:67:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/contents.css\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"2fc0f6f42cc1cba1da1161dd1f2aa86f\";}s:89:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/plugins/dialog/dialogDefinition.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"73b1474cf9e14ab439d8b90183c6849b\";}s:83:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/plugins/link/dialogs/link.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f94502fd01e2d24b3f00b2d50ac15aa4\";}s:85:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/plugins/link/dialogs/anchor.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"ac94ef450e45432296059f21f7e2cacc\";}s:65:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/lang/en.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"13e68db2445153b70e294643959e6cd5\";}s:66:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/ckeditor.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"a71523871d466d6acd12eac59885fef8\";}s:64:\"wp-content/plugins/visual-form-builder-pro/js/ckeditor/config.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"664bd97927a539d1d3a291228f3d0184\";}s:64:\"wp-content/plugins/visual-form-builder-pro/js/jquery.metadata.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"01f700767eeeaa4d99479891c47c7351\";}s:60:\"wp-content/plugins/visual-form-builder-pro/js/raphael.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f8bf73b9bb18a97d9c54f59e4f995595\";}s:68:\"wp-content/plugins/visual-form-builder-pro/js/jquery.validate.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c593e70ef041ab387fefad5fe38a724c\";}s:62:\"wp-content/plugins/visual-form-builder-pro/js/vfb-admin.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"6083f0eb6bc27fa34cdd125e8d9af048\";}s:59:\"wp-content/plugins/visual-form-builder-pro/js/morris.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"fadac462637afd6cdc0cb0a0137629af\";}s:73:\"wp-content/plugins/visual-form-builder-pro/js/jquery.ui.timepicker.min.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"a8db95a50f8b6445ae96a3abe9be7db9\";}s:73:\"wp-content/plugins/visual-form-builder-pro/js/jquery.ui.nestedSortable.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"93d9639fea24fe9727aa9d7af925198c\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-es_ES.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"b760d15e7dd117f5e4dfbdf5dd8297e9\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-sv_SE.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"1bf8d27ef26c912ad6230134e4ae3178\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-he_IL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d1d88772c2450f012f1d3b0e81a6ab94\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-it_IT.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d1dc33b0e5beb16363ccedd793378797\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-fr_FR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"95cde50a8a1ccf6e9b97400955841ec2\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-pt_BR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"36354dfd7bdf2e3f0dc55e874da5bb01\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-en_GB.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"0aa534a56bb9682900f588f118aea2d3\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-ja_JP.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"2c0c3f2a7fde3ee99ea041c5a51c1bbc\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-pl_PL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"b33fd04364918f5256a30cc976577589\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-ko_KR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"42d87842e2a8deb4e602ce4654ea9e03\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-de_DE.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"85fcf7ff20f18126aa91aeb60c2013a8\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-en_AU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"45de91b08a8981bc5906b593d095cc96\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-ru_RU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c8595c90d8192228415184b0b4f1493c\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-zh_CN.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c69a54c3bdce45de0940454c17af2441\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-tr_TR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"082cf09640dafd116d32b948a2b8a09f\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-id_ID.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"848caac3cf11ff33772c81dedb3bbad8\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-cs_CS.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"03739882bd61bcd68ec9086072639b5b\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-zh_TW.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"1561ce0e396dfe50a7ed05f4a1437c70\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-en_US.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"3dc8d4d03bee6f63c38b45fa681e62af\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-hu_HU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"e0487f016bceaafe84c0dc747124ff84\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-ro_RO.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"74414164ccbf00e789a2e1872bc55889\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-nl_NL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"74ab9d57b59d18dd08e6e11a63c07ec8\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-el_GR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"4beb94f3b790feaab24b88b4d6f5e6aa\";}s:81:\"wp-content/plugins/visual-form-builder-pro/js/i18n/datepicker/datepicker-pt_PT.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"7daf3a146e75e5450dae4982e03aeada\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-fr_FR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f93d37c5d4624af60057ae5ac57205f4\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-zh_TW.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c627f86ed4b2a5944c4c926f604eed29\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-sv_SE.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f4d47dcaa9730efb7f05791955c68fb0\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-cs_CS.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d65249fecb9f50cb7ec6a4e519f5b27e\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-el_GR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"4d110df36a3dc1339cd7bdd4fa8530fe\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-en_AU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"f2940a78e676361f2a67b543c18fddda\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-ko_KR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"482b9ed16d2240c0d9df5c81f3b8eef7\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-zh_CN.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"c9f6a2b3eaf368aead755793cb74b994\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-es_ES.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"33eb668803ca50555f4ced5b0348c527\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-ja_JP.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"5800618d2b6f4bc3d0947fbc27e45735\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-it_IT.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"d505f3284979a12ad3c8a706ab92866d\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-pl_PL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"b279c322305cd5af155503c9c00a324a\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-en_GB.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"8a272839742fe49f526b37ddf1e5e873\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-pt_BR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"73541a9fc8abe432462392a60c480cbd\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-ru_RU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"903f67b7cbff849791f93082081c9d33\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-id_ID.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"031808221cc10c246d703d84d01365d8\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-ro_RO.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"e82dedd77776c57ec5376c9cdca67861\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-en_US.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"8a62ceb5105d09a585bf60c838744764\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-pt_PT.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"072e6421f85421a5928e00e70809f138\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-hu_HU.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"ca45baa6583794e1068c284cbb6a4f91\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-he_IL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"afd2c641d8f5a1b848876aad88a319a9\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-nl_NL.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"b15edea45f5d1718ddd336a2ea5c3b78\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-de_DE.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"fe69f260e1e46f8204694a4f8420e3fb\";}s:77:\"wp-content/plugins/visual-form-builder-pro/js/i18n/validate/messages-tr_TR.js\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"a045e723b2eaa26e3fd0600c6c88c461\";}s:70:\"wp-content/plugins/visual-form-builder-pro/visual-form-builder-pro.php\";a:2:{s:1:\"d\";i:1436914874;s:1:\"h\";s:32:\"0ffe51459430cd1831ea68dc3aa1039f\";}s:80:\"wp-content/plugins/visual-form-builder-pro/languages/visual-form-builder-pro.pot\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"5b6bb4a68b43da4c6de77c7c7d80dba6\";}s:53:\"wp-content/plugins/visual-form-builder-pro/readme.txt\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"40de7c6fd252d298594df6df00da2ece\";}s:56:\"wp-content/plugins/visual-form-builder-pro/uninstall.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"a9e12a915058509f54ca92ab84cf8f6b\";}s:72:\"wp-content/plugins/visual-form-builder-pro/includes/class-forms-list.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"4111fa7f4ca5045c235c4dbe427b1551\";}s:76:\"wp-content/plugins/visual-form-builder-pro/includes/class-email-designer.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"29c1372114a6f03c2acff81d715be769\";}s:76:\"wp-content/plugins/visual-form-builder-pro/includes/class-entries-detail.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"77827646350df7dc4fcd832e0cd5a8ed\";}s:74:\"wp-content/plugins/visual-form-builder-pro/includes/admin-form-creator.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"b8db5c3fca2e69f6d6c73cb5ea9355a6\";}s:78:\"wp-content/plugins/visual-form-builder-pro/includes/libraries/recaptchalib.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"b206569ed973563107c29902ca7ab35b\";}s:82:\"wp-content/plugins/visual-form-builder-pro/includes/libraries/class-wp-session.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"24a30b45c526767ea50cc58885b2e32c\";}s:76:\"wp-content/plugins/visual-form-builder-pro/includes/libraries/wp-session.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"3f22aa8b298654270cf4f17319d81d62\";}s:93:\"wp-content/plugins/visual-form-builder-pro/includes/libraries/class-recursive-arrayaccess.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"294f36d3f604431a9c8a23ed0e07753a\";}s:61:\"wp-content/plugins/visual-form-builder-pro/includes/email.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"af78eb35afb21d1e635c82c589a950b3\";}s:68:\"wp-content/plugins/visual-form-builder-pro/includes/class-widget.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"b35daff9a45f27ac3b67f3f2b6ca9875\";}s:70:\"wp-content/plugins/visual-form-builder-pro/includes/admin-new-form.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"efd975bde3d6d74d25caf35af804b32a\";}s:74:\"wp-content/plugins/visual-form-builder-pro/includes/class-entries-list.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"08fe0d8370df3eaf6082aa04500faac8\";}s:71:\"wp-content/plugins/visual-form-builder-pro/includes/class-analytics.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"f4c16b70311cdcbe3af4651a5bb3a107\";}s:82:\"wp-content/plugins/visual-form-builder-pro/includes/admin-field-options-helper.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"8b334cfbe45ee3e99ae3b0f65eb824c3\";}s:73:\"wp-content/plugins/visual-form-builder-pro/includes/class-forms-order.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"27ffe9c5917f15cf935f96d4bccffa5c\";}s:67:\"wp-content/plugins/visual-form-builder-pro/includes/form-output.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"9c28e9f4fba6fa2d63c6090c6a929039\";}s:68:\"wp-content/plugins/visual-form-builder-pro/includes/class-export.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"c5c98e9b3cd56039a4c509d1a00ca1d8\";}s:68:\"wp-content/plugins/visual-form-builder-pro/includes/class-import.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"5e6341a3aa5fc9aafd42605165f8f21c\";}s:69:\"wp-content/plugins/visual-form-builder-pro/includes/class-session.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"68e947fae50ab15927185d85125d8acf\";}s:75:\"wp-content/plugins/visual-form-builder-pro/includes/admin-field-options.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"484e237dd5034d67cacf37f5f2a51ab4\";}s:60:\"wp-content/plugins/visual-form-builder-pro/email-preview.php\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"f7d22cefba081148d80159fddf83f0db\";}s:74:\"wp-content/plugins/visual-form-builder-pro/css/visual-form-builder.min.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"0cab9c05dcfaa470508fcaf117aa21bc\";}s:76:\"wp-content/plugins/visual-form-builder-pro/css/visual-form-builder-admin.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"e8c3b47da620982765bed9b56eb4ee36\";}s:82:\"wp-content/plugins/visual-form-builder-pro/css/smoothness/jquery-ui-1.10.3.min.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"4392429af2c49d2fbdcd8b19957d207d\";}s:78:\"wp-content/plugins/visual-form-builder-pro/css/smoothness/jquery-ui-1.10.3.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"5d30b3eb61c22cc283fe43109c536587\";}s:85:\"wp-content/plugins/visual-form-builder-pro/css/smoothness/images/animated-overlay.gif\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"2b912f7c0653008ca28ebacda49025e7\";}s:70:\"wp-content/plugins/visual-form-builder-pro/css/visual-form-builder.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"a03c0a9c6182ceb0cb451fca36252f3d\";}s:80:\"wp-content/plugins/visual-form-builder-pro/css/visual-form-builder-admin.min.css\";a:2:{s:1:\"d\";i:1436914875;s:1:\"h\";s:32:\"281bf876892beeb513fa21d1b1ed71aa\";}s:48:\"wp-content/plugins/wordpress-seo/wpml-config.xml\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"50b796ce526056607463e93a60c37fe4\";}s:57:\"wp-content/plugins/wordpress-seo/js/wp-seo-dismissible.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"02b47baf87e77e92d90f0ea9290fbe23\";}s:55:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-gsc.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"e95c8f75b8ae3351d6fdbf34449b7f92\";}s:58:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-global.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"76a4506b7a095960f07495a1cba59bd8\";}s:61:\"wp-content/plugins/wordpress-seo/js/jquery.tablesorter.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"030b8389376a42ff3da186bf65806217\";}s:57:\"wp-content/plugins/wordpress-seo/js/wp-seo-bulk-editor.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"6422b5a60459cdd7eebcf11310449cbf\";}s:45:\"wp-content/plugins/wordpress-seo/js/.jshintrc\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a87e946e89fbe366e918afbdd3800f6a\";}s:61:\"wp-content/plugins/wordpress-seo/js/wp-seo-dismissible.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a6064e9421c91c56430431fc48c67ff9\";}s:57:\"wp-content/plugins/wordpress-seo/js/wp-seo-metabox.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"993a5f5cd642fc3d3dfb659b871c6488\";}s:57:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-media.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4bda7589a4831226392e9b21e5067943\";}s:49:\"wp-content/plugins/wordpress-seo/js/jquery.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2af828a00f951181da0e05771bf8d623\";}s:61:\"wp-content/plugins/wordpress-seo/js/wp-seo-bulk-editor.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"569bb0f2712c3ae45b6fa72eabdbb80f\";}s:56:\"wp-content/plugins/wordpress-seo/js/wp-seo-export.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9a3a1f280bdebd47c325da555e4e2150\";}s:54:\"wp-content/plugins/wordpress-seo/js/jquery.qtip.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"5616043426f9b840e5d1b5906e146817\";}s:59:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-gsc.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"0db2639094fc9495a48284acc06fffc5\";}s:60:\"wp-content/plugins/wordpress-seo/js/wp-seo-featured-image.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4b5600c4db90543a0bb8303a48885d0c\";}s:52:\"wp-content/plugins/wordpress-seo/js/wp-seo-export.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8bec08a66735000d36c60a3a91fa5726\";}s:45:\"wp-content/plugins/wordpress-seo/js/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:51:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9a19dd4eb5ebb6ea338a5e58e634645d\";}s:61:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-media.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1b2becb642f30a55f63c95cbed6598d8\";}s:55:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"cd637ca024fe6cffbc0c708b035197f4\";}s:64:\"wp-content/plugins/wordpress-seo/js/wp-seo-featured-image.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a528c3220bd68db270f8fdfaddcb5428\";}s:62:\"wp-content/plugins/wordpress-seo/js/wp-seo-admin-global.min.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8bd22324ff25b5a121c2a872e359e411\";}s:53:\"wp-content/plugins/wordpress-seo/js/wp-seo-metabox.js\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8467c5f48d3255c569237deef2965ef8\";}s:64:\"wp-content/plugins/wordpress-seo/admin/class-opengraph-admin.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"12228f172d0bf70e32f16fa1b3bd1653\";}s:71:\"wp-content/plugins/wordpress-seo/admin/class-bulk-editor-list-table.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"b7218516afa0a9e38746174a5863e572\";}s:59:\"wp-content/plugins/wordpress-seo/admin/class-yoast-form.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c6d91925962e747e9e5a0b92bf80e9a8\";}s:59:\"wp-content/plugins/wordpress-seo/admin/class-customizer.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8300ce89a55e065c131d22fc4f7b2c90\";}s:77:\"wp-content/plugins/wordpress-seo/admin/class-bulk-title-editor-list-table.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"b8b907236df5497f9bc05dbd47f6620b\";}s:81:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-mapper.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1ce34342cfe4ba3831a9cd226b2abe1a\";}s:83:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-settings.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"3b726e22eec33a0790a6d3faa01862b3\";}s:91:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-category-filters.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"6f6e8684ef4636b24f9e57b6281617be\";}s:81:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-config.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"551ef1172af030f34d0fcdf6b9eb9c07\";}s:80:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-issue.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"cbc9658160f3ef9a0ed60eceacdad8dc\";}s:88:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-platform-tabs.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"48a1cbdff85058ac9d85968ca6b2ef63\";}s:74:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"88c32b9fba69425991ab98ff8654d920\";}s:80:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-count.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"21c5309667644ed499f17696e898a367\";}s:82:\"wp-content/plugins/wordpress-seo/admin/google_search_console/views/gsc-display.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"90526414e6e32f406a701d063f7ec790\";}s:90:\"wp-content/plugins/wordpress-seo/admin/google_search_console/views/gsc-create-redirect.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"f2d00728aaddeea8b3bab4cc2feca395\";}s:86:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-bulk-action.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"6e539d9a8667e96fae94492c65b750bf\";}s:81:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-marker.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"f3f9cdb5f2fed73a72ece17d4c7a22f0\";}s:79:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-ajax.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2bfb6b5ee93dbe3227abb984842e1938\";}s:81:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-issues.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"757e6396557f931d7301a8289a45e853\";}s:80:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-table.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2557ae8a150eadf5a1de874457f00c65\";}s:82:\"wp-content/plugins/wordpress-seo/admin/google_search_console/class-gsc-service.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ae11d36c582eec97d2e5f44075a6a015\";}s:71:\"wp-content/plugins/wordpress-seo/admin/class-yoast-dashboard-widget.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"88ccebbe5db5b5863fabbcd7684ade51\";}s:74:\"wp-content/plugins/wordpress-seo/admin/class-yoast-notification-center.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"917dce15f87937f3f386d709420a4525\";}s:64:\"wp-content/plugins/wordpress-seo/admin/class-plugin-conflict.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"23a73b2f6c411187600defcb14551649\";}s:70:\"wp-content/plugins/wordpress-seo/admin/class-yoast-plugin-conflict.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1ff84617dec8edac909f861f42b68343\";}s:67:\"wp-content/plugins/wordpress-seo/admin/class-yoast-notification.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2d45bb423c87bfab7a3c7f503dea9303\";}s:64:\"wp-content/plugins/wordpress-seo/admin/class-snippet-preview.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9d576c90ac2437ad60d928129adccd42\";}s:57:\"wp-content/plugins/wordpress-seo/admin/pages/licenses.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"7e025571c79da234ba81cab271fc5a4c\";}s:58:\"wp-content/plugins/wordpress-seo/admin/pages/dashboard.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d22cdd5cd0319dc76231b4d6731fac24\";}s:57:\"wp-content/plugins/wordpress-seo/admin/pages/advanced.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"327d213e443cf8fe1b305d26f402e60b\";}s:54:\"wp-content/plugins/wordpress-seo/admin/pages/tools.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"5ac012b78f510d726145c891e9515194\";}s:54:\"wp-content/plugins/wordpress-seo/admin/pages/metas.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"40102e105f2e4bae23aac4707fa83173\";}s:61:\"wp-content/plugins/wordpress-seo/admin/pages/xml-sitemaps.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"09869430c3e64f5694abfd881fe65e2c\";}s:55:\"wp-content/plugins/wordpress-seo/admin/pages/social.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"399676a983d8d13be51edcc2cbc6edd9\";}s:56:\"wp-content/plugins/wordpress-seo/admin/pages/network.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1adaed58fd75ee61b8dcc85147fd5072\";}s:80:\"wp-content/plugins/wordpress-seo/admin/ajax/class-yoast-plugin-conflict-ajax.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"0ce11739265405a4b23b25681c98db50\";}s:64:\"wp-content/plugins/wordpress-seo/admin/class-import-external.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9d3db4acb1586bdfcc17b9d34478c4cd\";}s:57:\"wp-content/plugins/wordpress-seo/admin/class-pointers.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"33ccab9d8d43cb67a1d29dd407985d71\";}s:57:\"wp-content/plugins/wordpress-seo/admin/class-taxonomy.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"510514f000a0950b4b2035b729a5ab9e\";}s:63:\"wp-content/plugins/wordpress-seo/admin/class-sitemaps-admin.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"11c462b7be037cc4698a7f13fec860e5\";}s:67:\"wp-content/plugins/wordpress-seo/admin/class-admin-user-profile.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d3e650cae05e7700c751a12889dc62ab\";}s:69:\"wp-content/plugins/wordpress-seo/admin/class-import-woothemes-seo.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d473b3db5fd7bcfcecf829b7010d1284\";}s:56:\"wp-content/plugins/wordpress-seo/admin/class-metabox.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"fdaa5c02c0e1fb7e7ead711b485a3513\";}s:47:\"wp-content/plugins/wordpress-seo/admin/ajax.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d3098aa5b2f3b8d5140f144e89cfe5f9\";}s:55:\"wp-content/plugins/wordpress-seo/admin/class-export.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"f4835e6854589ad5be04aa0ca20be9f3\";}s:65:\"wp-content/plugins/wordpress-seo/admin/views/tool-file-editor.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"bd9bcc4377e893b19e7141d018273fe0\";}s:56:\"wp-content/plugins/wordpress-seo/admin/views/tab-rss.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"81a6d1afe25f91c961fa5331c0d10db3\";}s:63:\"wp-content/plugins/wordpress-seo/admin/views/tab-permalinks.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"81086f72b7d8fc0fbc1e626de29490e7\";}s:64:\"wp-content/plugins/wordpress-seo/admin/views/tab-breadcrumbs.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"dcd217aad742c5f9cc46c74927caaa36\";}s:67:\"wp-content/plugins/wordpress-seo/admin/views/tool-import-export.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"7824f2efd7ec8ad67ca14c8e363ac2a4\";}s:65:\"wp-content/plugins/wordpress-seo/admin/views/dashboard-widget.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c90560cec7f1c7423351f1c61d7bacc4\";}s:61:\"wp-content/plugins/wordpress-seo/admin/views/user-profile.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1b9eae487941f494570129b617cba239\";}s:54:\"wp-content/plugins/wordpress-seo/admin/views/about.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"65aff9f098ad7bc801a57505cd623a4d\";}s:65:\"wp-content/plugins/wordpress-seo/admin/views/tool-bulk-editor.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"b8c6291bc1c10aa4e0753f2ff55dcb95\";}s:48:\"wp-content/plugins/wordpress-seo/admin/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:55:\"wp-content/plugins/wordpress-seo/admin/class-import.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"edb560b50cc7a71b2b58e8cbed6aa9b4\";}s:54:\"wp-content/plugins/wordpress-seo/admin/class-admin.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"28227aab4562cadd3f6d346707b96529\";}s:69:\"wp-content/plugins/wordpress-seo/admin/class-yoast-textstatistics.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"cf7f96debf4afffc3feab428a9bd40fc\";}s:64:\"wp-content/plugins/wordpress-seo/admin/class-social-facebook.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"0a48991f0c95f7bcaad4a2cc6f0dfb94\";}s:62:\"wp-content/plugins/wordpress-seo/admin/class-import-aioseo.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"90c9371f9ffe4128ca549b9fb4278dab\";}s:59:\"wp-content/plugins/wordpress-seo/admin/class-admin-init.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"347db9b326875fd203a7196c4cd1f57e\";}s:83:\"wp-content/plugins/wordpress-seo/admin/class-bulk-description-editor-list-table.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"610d6e5fee280de67af1d62d959ac20e\";}s:55:\"wp-content/plugins/wordpress-seo/admin/class-config.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"37a381ee6f00c835f7b3adc7e5ea58d6\";}s:60:\"wp-content/plugins/wordpress-seo/frontend/class-frontend.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"027015f66f48a01bf5eacd60e6b5439c\";}s:59:\"wp-content/plugins/wordpress-seo/frontend/class-json-ld.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9292af5e45618ee6e2f6d80287f92f95\";}s:61:\"wp-content/plugins/wordpress-seo/frontend/class-opengraph.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"19bf2f10ae08115a54aca072573965ed\";}s:59:\"wp-content/plugins/wordpress-seo/frontend/class-twitter.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4cf8b8ac1c072d07b0bc68520a3f8670\";}s:51:\"wp-content/plugins/wordpress-seo/frontend/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:62:\"wp-content/plugins/wordpress-seo/frontend/class-googleplus.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"7023eb048a068b3131fec32d3ef3a822\";}s:63:\"wp-content/plugins/wordpress-seo/frontend/class-breadcrumbs.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"089446faab4071f6f50471a5c99f7e50\";}s:52:\"wp-content/plugins/wordpress-seo/vendor/autoload.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"456afc3e5a925a07fb80bda8bd31435d\";}s:95:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/lib/xrstf/Composer52/Generator.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"417df818c0f1b500c094ef76f3703caa\";}s:97:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/lib/xrstf/Composer52/ClassLoader.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c8b909e2a65a5ecec42bc17d69f47f98\";}s:103:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/lib/xrstf/Composer52/AutoloadGenerator.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"747ef0f09e1532b34260d499819c5b09\";}s:68:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/.hgtags\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a519f901e3160d22932d1513f772ee00\";}s:70:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/README.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"0a75ffbf1376fc7dbfc2b53ee7d67aad\";}s:68:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/LICENSE\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1ae51299e61cc92df308666da6d69906\";}s:77:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/.hg_archival.txt\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"69ec38c85be630aee9e50ee3f53f5b4c\";}s:74:\"wp-content/plugins/wordpress-seo/vendor/xrstf/composer-php52/composer.json\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"34b124775d22dc18ecd58981ecb37f1d\";}s:55:\"wp-content/plugins/wordpress-seo/vendor/autoload_52.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ee6547f25bf40201007948c6a4bf07ce\";}s:64:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/README.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ee1769fd384ba5065a5ae82560f517bc\";}s:73:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/class-api-libs.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"35262d1c9fd3d5f258c535e19feb8ecc\";}s:92:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/external/URITemplateParser.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"dc829ddd424801e2bc4bf83bfb5e698c\";}s:84:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_Signer.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ed78766d5af59b6aee16ef014dab316c\";}s:89:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_PemVerifier.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d4809b10e2f9eb2f2437a14ca9e73817\";}s:84:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_OAuth2.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"096eddf13bedc0163c62b85d83569110\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_AuthNone.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a3946bcf8b60a092d60744dee1266268\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_Verifier.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"851557c80027139df2f9350125db07c7\";}s:98:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_AssertionCredentials.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"347509bcad7389e6c5f81b98324008a4\";}s:82:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_Auth.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8a07098941ce118f7084e69d0aff3198\";}s:87:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_P12Signer.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2f66588beef914e30cd60451f914ff8a\";}s:89:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/auth/Google_LoginTicket.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"1940b66e883dfc149f811bb8e18ee27d\";}s:72:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/config.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"73ee822eb83ebed1ff1a0f638f9aa4a5\";}s:93:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_BatchRequest.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"b384420af6ee85b54d736e678b24ae1a\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_Model.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4f19707bcd70b314d27b6685014e5ad8\";}s:96:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_MediaFileUpload.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4116ceb1e809eaa5ba3b94416a7cc157\";}s:88:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_Service.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ec8a0d396772ea1bcbffa730bb213343\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_Utils.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"ee855b579bcdd34667d4b4c309c6328f\";}s:96:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/service/Google_ServiceResource.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"2dcb4d2b2b0d00a85671c2bb4e86c28f\";}s:87:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_CacheParser.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"351bfee9e04c3c3cc5a07b1bb2158e87\";}s:78:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_IO.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"28a5eded74ca33ee82fbb2867bf793a8\";}s:87:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_HttpRequest.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"fb4f60d443ed475226b2b5950a0e0273\";}s:80:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_WPIO.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"113120e4596ca5bffd02710e4986b27f\";}s:76:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/cacerts.pem\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"0d806fdc81ab8ec35c05b7dc869dd208\";}s:82:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_CurlIO.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"b02d7b9832ea0a3c69d172d264b64d93\";}s:80:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/io/Google_REST.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"e4d006ff7aad82ea3eb234dd60b3fd66\";}s:84:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/cache/Google_Cache.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"23496c6bfc015794fa459d7e92ef3af0\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/cache/Google_WPCache.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c789103a392b78860108f9716fc866cf\";}s:79:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/google/Google_Client.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8efa3083e79bd1e5b9e6f393f823b471\";}s:75:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/class-api-google.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"96ec370173148c3913f649546e5f4dfc\";}s:82:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/class-api-google-client.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a1767c649e80bfb344685099bf4ab1ba\";}s:68:\"wp-content/plugins/wordpress-seo/vendor/yoast/api-libs/composer.json\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"265b7f60d60acbfb495cc03dfca73c40\";}s:87:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/samples/sample-plugin.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"f65dcd7b85f0f7bcbc9b308a6c4d443d\";}s:79:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/samples/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"364cec32d3b2896bb5313a84f54280c8\";}s:96:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/samples/sample-theme-functions.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"6d07150cffcea84478eab8a0d858a5f7\";}s:88:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/samples/sample-product.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"7cf8e596f7928b20218d29d84f5f13be\";}s:86:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-update-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"aea06f3a4c69f2b9cd4288c3833eacc5\";}s:71:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/README.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"38c497ef28e6dd32d0a9b283cda07b3f\";}s:71:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/.gitigore\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"5f2910f55baf601d46ce0de32bd02f32\";}s:79:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-product.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"05371bb36817511cb6763c6a34bd40a1\";}s:92:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-theme-update-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"39e84ff8eb8f141544ab15422771de04\";}s:73:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/phpunit.xml\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"e5248d140dae362978ca0c16b8dea4f5\";}s:78:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/views/script.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8d8207449c564f4797c7d2703cb6336b\";}s:77:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/views/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"364cec32d3b2896bb5313a84f54280c8\";}s:76:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/views/form.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"90099af6bfc10e694f32c90874dac868\";}s:71:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/index.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"364cec32d3b2896bb5313a84f54280c8\";}s:94:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-plugin-license-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"73101ad379b7e76f77a3d192bf8c0dad\";}s:93:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-theme-license-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"4527296a323c6ebb97b97ac33894f616\";}s:87:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-license-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"761a7e09627004386806d5e9150c36d4\";}s:93:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-plugin-update-manager.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"8ea937a0ba65875d3423a457c8c23080\";}s:73:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/.travis.yml\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c1cdf10d58d72d2305248e6597be5336\";}s:75:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/composer.json\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"072b7e39bb3bdad2c023cf1a34fe2644\";}s:83:\"wp-content/plugins/wordpress-seo/vendor/yoast/license-manager/class-api-request.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"327ef530e92b75936fd063ef49288127\";}s:67:\"wp-content/plugins/wordpress-seo/vendor/yoast/i18n-module/README.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"d596db92bb48c6b9edfa9d0846815af3\";}s:73:\"wp-content/plugins/wordpress-seo/vendor/yoast/i18n-module/i18n-module.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"5f931a6db09049bc66332000f55c1227\";}s:65:\"wp-content/plugins/wordpress-seo/vendor/yoast/i18n-module/LICENSE\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"784d7dc7357bd924e8d5642892bf1b6b\";}s:71:\"wp-content/plugins/wordpress-seo/vendor/yoast/i18n-module/composer.json\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"f3be2d26cdc032362b2a0be22d70bc47\";}s:72:\"wp-content/plugins/wordpress-seo/vendor/composer/autoload_namespaces.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"7ee2282bad4befcc4826470907c41018\";}s:66:\"wp-content/plugins/wordpress-seo/vendor/composer/ClassLoader52.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"c8b909e2a65a5ecec42bc17d69f47f98\";}s:63:\"wp-content/plugins/wordpress-seo/vendor/composer/installed.json\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"6e6dcd74839fea2ff6293adbce8ea0b2\";}s:66:\"wp-content/plugins/wordpress-seo/vendor/composer/autoload_real.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9278f3c3032f11322f435bd0c05be155\";}s:69:\"wp-content/plugins/wordpress-seo/vendor/composer/autoload_real_52.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a83ff5f0dea889d0bb0f6271057d0114\";}s:56:\"wp-content/plugins/wordpress-seo/vendor/composer/LICENSE\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"084a034acbad39464e3df608c6dc064f\";}s:66:\"wp-content/plugins/wordpress-seo/vendor/composer/autoload_psr4.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"dd3a00f0d13eb29781edd8c77d4c5100\";}s:64:\"wp-content/plugins/wordpress-seo/vendor/composer/ClassLoader.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9c1e7fe1a9eb1693e07ee4420ca5361e\";}s:70:\"wp-content/plugins/wordpress-seo/vendor/composer/autoload_classmap.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9140deec8a29d76ab32ebca5f52d2777\";}s:42:\"wp-content/plugins/wordpress-seo/README.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"40d14ba2582e4650844e24ff7ddce1dd\";}s:48:\"wp-content/plugins/wordpress-seo/CONTRIBUTING.md\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a18de4e180c69301ca649260a2b432d4\";}s:48:\"wp-content/plugins/wordpress-seo/codeclimate.yml\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"a77ad8689d09b4e3eb19844389cf6cbb\";}s:46:\"wp-content/plugins/wordpress-seo/changelog.txt\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9683422cecdce2821aebaa93c4b6b88b\";}s:48:\"wp-content/plugins/wordpress-seo/wp-seo-main.php\";a:2:{s:1:\"d\";i:1443105852;s:1:\"h\";s:32:\"9dd882bef4a584be8d2c8c1c2f3bd409\";}s:60:\"wp-content/plugins/wordpress-seo/languages/wordpress-seo.pot\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"867d41084c19b549b8b094d36b650b68\";}s:52:\"wp-content/plugins/wordpress-seo/languages/index.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"e1482e64ec9bdeede4197ff83025553e\";}s:43:\"wp-content/plugins/wordpress-seo/readme.txt\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"d4a2c1d24051fc328b0d47b1a608ab1a\";}s:42:\"wp-content/plugins/wordpress-seo/index.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:44:\"wp-content/plugins/wordpress-seo/license.txt\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"9eef91148a9b14ec7f9df333daebc746\";}s:51:\"wp-content/plugins/wordpress-seo/images/waiting.gif\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"e9034923ca8a43e969a54000298c3a0f\";}s:49:\"wp-content/plugins/wordpress-seo/images/index.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:65:\"wp-content/plugins/wordpress-seo/inc/wpseo-non-ajax-functions.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"a88d4675240d9b81be91aba2579b4348\";}s:57:\"wp-content/plugins/wordpress-seo/inc/class-wpseo-meta.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"ed6435b9f8f09cdb87995bbee79a9ee3\";}s:54:\"wp-content/plugins/wordpress-seo/inc/class-upgrade.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"20f3b2d2e7c7cc472b97573b0108aad9\";}s:56:\"wp-content/plugins/wordpress-seo/inc/wpseo-functions.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"4a73d975dde45a19303bf67af0367062\";}s:63:\"wp-content/plugins/wordpress-seo/inc/class-sitemap-timezone.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"471d8b4d676da29f06e1566a7b05a82c\";}s:63:\"wp-content/plugins/wordpress-seo/inc/class-wpseo-statistics.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"f44588f452e8923cdb610a95f8c312e7\";}s:58:\"wp-content/plugins/wordpress-seo/inc/class-wpseo-utils.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"8b8ac3b068f802d6d278468de4e6accb\";}s:65:\"wp-content/plugins/wordpress-seo/inc/class-wpseo-replace-vars.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"afe43ba76617396be925061a677a2a29\";}s:46:\"wp-content/plugins/wordpress-seo/inc/index.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:55:\"wp-content/plugins/wordpress-seo/inc/class-sitemaps.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"5bf6613af329a40c20112f7ac8013cb8\";}s:54:\"wp-content/plugins/wordpress-seo/inc/class-rewrite.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"09d8144a89118446eeccd552b2694d88\";}s:71:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-rss.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"cc876ab603abf7fe5cf8e24503d1cb27\";}s:74:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-taxonomy-meta.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"2466f88f8d7a730b1e52072773571779\";}s:81:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-internallinks.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"d401523821118e74c1b5105146849def\";}s:78:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-permalinks.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"42e9d3a9a48ea6ac188fbf3f51beba14\";}s:74:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-titles.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"5d8e65a6105a918271b973e6a916b3bf\";}s:71:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-xml.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"260850f2b66c7c65f2c5c107fcc6f40e\";}s:74:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-social.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"cd061571208337b760f24e16ef431488\";}s:68:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-options.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"22032ccf9760e2f67269919f0d6e72a0\";}s:73:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-wpseo.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"7c0d03990f885f3522db41853cc7cdf8\";}s:67:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"927119c59ef894987f984d609f0269ff\";}s:70:\"wp-content/plugins/wordpress-seo/inc/options/class-wpseo-option-ms.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"ab6ddc9adf885d8bb8f5a39dab04c759\";}s:59:\"wp-content/plugins/wordpress-seo/css/featured-image.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"f41563149322473e07cd2b1704c0a7f5\";}s:54:\"wp-content/plugins/wordpress-seo/css/edit-page.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"9e4c662e47037b87527e0ccce96ddee5\";}s:54:\"wp-content/plugins/wordpress-seo/css/taxonomy-meta.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"49a11278164e4ea9c816a64ba47e6009\";}s:54:\"wp-content/plugins/wordpress-seo/css/dashboard.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"c4ed6c86045367694b1db2788122de78\";}s:51:\"wp-content/plugins/wordpress-seo/css/jquery.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"891931cbd84cbd0d3d10d3339342fa5c\";}s:50:\"wp-content/plugins/wordpress-seo/css/edit-page.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"bddc90ff24557a31ce6c79c996b59ea9\";}s:61:\"wp-content/plugins/wordpress-seo/css/yst_plugin_tools.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"2cc8bd523108f19bf62c020c6c43e026\";}s:54:\"wp-content/plugins/wordpress-seo/css/wpseo-rtl.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"527d9c0f36e349628c8314739df8f904\";}s:50:\"wp-content/plugins/wordpress-seo/css/wpseo-rtl.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"6c86ebd56f6fedb8e55beb5170abfd07\";}s:58:\"wp-content/plugins/wordpress-seo/css/taxonomy-meta.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"b5f862478fe582275281855e4d3af7f8\";}s:57:\"wp-content/plugins/wordpress-seo/css/metabox-tabs.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"321be189fb3d43d9588b34ae6b2d788b\";}s:56:\"wp-content/plugins/wordpress-seo/css/xml-sitemap-xsl.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"e8c941f9848681c72bb0d8eca9166a21\";}s:57:\"wp-content/plugins/wordpress-seo/css/yst_plugin_tools.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"ae6c73e79da0b8b51e119d58867c3b97\";}s:52:\"wp-content/plugins/wordpress-seo/css/jquery.qtip.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"b8cbc4d222a5f62554fb1576963d7e47\";}s:62:\"wp-content/plugins/wordpress-seo/css/wpseo-dismissible.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"5175efabc4cdd28fedcf35a0d2020dad\";}s:60:\"wp-content/plugins/wordpress-seo/css/metabox-classic.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"8f539261027f99e6a89b135d0158bd2a\";}s:49:\"wp-content/plugins/wordpress-seo/css/adminbar.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"add2f5fc57fb2087a6c117f525a3362a\";}s:53:\"wp-content/plugins/wordpress-seo/css/metabox-tabs.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"dd62149cfc7775c5a17484f791fa4627\";}s:46:\"wp-content/plugins/wordpress-seo/css/index.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"45d09bb48b4f308b8f63baab8f416733\";}s:56:\"wp-content/plugins/wordpress-seo/css/metabox-classic.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"1052ee3869ca2db26cebd994118bb68b\";}s:56:\"wp-content/plugins/wordpress-seo/css/jquery.qtip.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"6fa1b7ce01c0bdc927c9f662f74ddf21\";}s:58:\"wp-content/plugins/wordpress-seo/css/metabox-fresh.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"36e283df504f655fc7f23a73468970ee\";}s:50:\"wp-content/plugins/wordpress-seo/css/dashboard.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"e2e608e669aee58c93e616c381cc7b3e\";}s:53:\"wp-content/plugins/wordpress-seo/css/adminbar.min.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"203269ca6ae7fcc93ab7b23d3e0ef28c\";}s:58:\"wp-content/plugins/wordpress-seo/css/wpseo-dismissible.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"9cc5f403d6fc9cc7af63b2e59c420df2\";}s:54:\"wp-content/plugins/wordpress-seo/css/metabox-fresh.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"0e3171e37d6e49e79f07dcbae1f344bb\";}s:55:\"wp-content/plugins/wordpress-seo/css/featured-image.css\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"b5f6aef5028e4f0a1d888ab56e7acfb5\";}s:43:\"wp-content/plugins/wordpress-seo/wp-seo.php\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"7550d69916cced04ae3d4c5c97ea0c44\";}s:43:\"wp-content/plugins/wordpress-seo/phpdoc.xml\";a:2:{s:1:\"d\";i:1443105853;s:1:\"h\";s:32:\"37dcd1c5dd0f4b36272a74dfbaecaa4e\";}s:28:\"wp-content/plugins/error_log\";a:2:{s:1:\"d\";i:1445518669;s:1:\"h\";s:32:\"ceac756268a7834d30d25bff15fb91d3\";}s:46:\"wp-content/plugins/pretty-link/prli-groups.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"7147116028f273788f458f74dcb49f86\";}s:53:\"wp-content/plugins/pretty-link/js/prli-admin-links.js\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"fcbd4240b54fe112e0651f8f04c6a1e1\";}s:50:\"wp-content/plugins/pretty-link/js/jquery.clippy.js\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"d85393779afa6ba67de148b6b2090133\";}s:44:\"wp-content/plugins/pretty-link/js/clippy.swf\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"b0125fa4276f0734dc6f9345292a9176\";}s:74:\"wp-content/plugins/pretty-link/classes/controllers/PrliLinksController.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"95d24b80440116529a1ed534b9405ed3\";}s:75:\"wp-content/plugins/pretty-link/classes/controllers/PrliGroupsController.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"38723aecfedb66e5c540cc048f6d845a\";}s:80:\"wp-content/plugins/pretty-link/classes/controllers/PrliBookmarkletController.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"d62ae927ade3e79e9eb55d430c96a29d\";}s:72:\"wp-content/plugins/pretty-link/classes/controllers/PrliAppController.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"85ae3584f0e2cda6a5d5ba09cced404c\";}s:66:\"wp-content/plugins/pretty-link/classes/helpers/PrliLinksHelper.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"2b72267a2a79382bb55b1bf0ea272f9b\";}s:64:\"wp-content/plugins/pretty-link/classes/helpers/PrliAppHelper.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"d693fe75d64303687016ae3a86e139ad\";}s:73:\"wp-content/plugins/pretty-link/classes/views/prli-clicks/csv_download.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"9d6167e8ab95d5642e36788dff91ab5c\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-clicks/csv.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"5efb39e3b94ffc1da17b882d57dfa478\";}s:65:\"wp-content/plugins/pretty-link/classes/views/prli-clicks/head.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"63dc7dcc25d5f3ad5dcd4963a6e489c7\";}s:65:\"wp-content/plugins/pretty-link/classes/views/prli-clicks/list.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"3f6847901adde550232f6c485730ff11\";}s:74:\"wp-content/plugins/pretty-link/classes/views/prli-options/pro-settings.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"2167c07b5bb47e1c6d496445a7a4b41a\";}s:66:\"wp-content/plugins/pretty-link/classes/views/prli-options/head.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"82f9ab66db4de21e0f03d96c8f902610\";}s:66:\"wp-content/plugins/pretty-link/classes/views/prli-options/form.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"4b608b39b147379068bcba6066257cc5\";}s:65:\"wp-content/plugins/pretty-link/classes/views/prli-groups/edit.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"3b4b33bb9f5f73addd9eb03d224e7449\";}s:65:\"wp-content/plugins/pretty-link/classes/views/prli-groups/head.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"1027ba4ad0ccc0707b34b9baa9b154e6\";}s:65:\"wp-content/plugins/pretty-link/classes/views/prli-groups/list.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"e117f7d4463d9caaf0e053bc33c49a5b\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-groups/new.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"37753b3edf40dbe65c183d7336fcc305\";}s:71:\"wp-content/plugins/pretty-link/classes/views/prli-tools/bookmarklet.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"35a8ddeb2a2e36781d61fc946def9f6e\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-tools/form.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"f467ba0950e7b5494c1fd6bfdb8f1e2a\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-links/edit.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"56da825714719d9652d260362e571398\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-links/list.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"0b54ca73001fa286db6185607094e539\";}s:63:\"wp-content/plugins/pretty-link/classes/views/prli-links/new.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"1591594e009ee7309ccccb8648c1ff51\";}s:64:\"wp-content/plugins/pretty-link/classes/views/prli-links/form.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"82f335f869a9618e0f026c62dd60d117\";}s:65:\"wp-content/plugins/pretty-link/classes/views/shared/table-nav.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"44d47f76607cb3f62c69fde6e2d7d7eb\";}s:66:\"wp-content/plugins/pretty-link/classes/views/shared/jsredirect.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"a223fe7d9048b50a5d3e7f1df553f0a1\";}s:66:\"wp-content/plugins/pretty-link/classes/views/shared/title_text.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"36dd168c92bb98a7594ee7cf31c38169\";}s:59:\"wp-content/plugins/pretty-link/classes/views/shared/nav.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"0c0c1c9882c858c06b6f3f908e0f7fd2\";}s:62:\"wp-content/plugins/pretty-link/classes/views/shared/errors.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"9ed4b0e8fb95bea2a4bccb41bd857fa8\";}s:70:\"wp-content/plugins/pretty-link/classes/views/shared/link-table-nav.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"8ebfb57a96381c524379d2cb01ea4505\";}s:77:\"wp-content/plugins/pretty-link/classes/views/prli-dashboard-widget/widget.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"4464fe3e3eb092ac6c7999bcf7abb2c0\";}s:60:\"wp-content/plugins/pretty-link/classes/models/models.inc.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"9e4396f7dd57c2913e500b51ea899def\";}s:59:\"wp-content/plugins/pretty-link/classes/models/PrliClick.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"bc18bcee3ddddc1f2de2e909d048c3c3\";}s:59:\"wp-content/plugins/pretty-link/classes/models/PrliGroup.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"9212d2c5f2d38766fe3ab34f3e042a5d\";}s:62:\"wp-content/plugins/pretty-link/classes/models/PrliLinkMeta.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"bafe735e13395f77f04b3f7c9b23c521\";}s:58:\"wp-content/plugins/pretty-link/classes/models/PrliLink.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"eba5cc15e2167dec875d55a22ee78503\";}s:59:\"wp-content/plugins/pretty-link/classes/models/PrliUtils.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"072adc8583fca6ef7d237ca07ccc38ad\";}s:61:\"wp-content/plugins/pretty-link/classes/models/PrliOptions.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"bc1d3e92e1470af5d8b804d26c1306d9\";}s:60:\"wp-content/plugins/pretty-link/classes/models/PrliUpdate.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"f0ad49513f67f45efb6cc75713c385a2\";}s:51:\"wp-content/plugins/pretty-link/prli-bookmarklet.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"619deadc4b16f90764396cff192cc31a\";}s:46:\"wp-content/plugins/pretty-link/prli-xmlrpc.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"a5b2a4892765a3bcaa25a9a15fbf4203\";}s:43:\"wp-content/plugins/pretty-link/prli-api.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"1ba9255841885db5d2e3f123fcf7fe6f\";}s:45:\"wp-content/plugins/pretty-link/prli-tools.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"35d82e173e246bfa1019feb01cd14bb9\";}s:41:\"wp-content/plugins/pretty-link/readme.txt\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"1f33f987a8eb10f313c513565c508aa3\";}s:47:\"wp-content/plugins/pretty-link/prli-options.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"f2ea1dc3429009ab47daf461127d9d7e\";}s:44:\"wp-content/plugins/pretty-link/prli-main.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"e832610f90c9fac37cf10a92f9b80b50\";}s:56:\"wp-content/plugins/pretty-link/prli-dashboard-widget.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"aaa6a035a1c9308e006ffdd09824c0f3\";}s:61:\"wp-content/plugins/pretty-link/includes/php/php_browsecap.ini\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"f63ce5719bbf8d450109d5b737998f13\";}s:46:\"wp-content/plugins/pretty-link/pretty-link.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"a45e919e3c4de81d881f8f94f479f3e3\";}s:52:\"wp-content/plugins/pretty-link/prli-pro-settings.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"6585177d8d6a440bcf55073ff2ecae0e\";}s:46:\"wp-content/plugins/pretty-link/prli-config.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"94e60a21d1653fde13becbe777a2fd46\";}s:47:\"wp-content/plugins/pretty-link/images/tweet.gif\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"6e67940e455bb8c1bef45f3e560f22d6\";}s:51:\"wp-content/plugins/pretty-link/images/co.mments.gif\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"3a8a824eb8a035631ce2187543d75296\";}s:49:\"wp-content/plugins/pretty-link/images/retweet.gif\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"e833df2b8808da17e83356a23cefbd05\";}s:50:\"wp-content/plugins/pretty-link/images/url_icon.gif\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"6c314fb479ee573ab8ee41be2a7a92bc\";}s:55:\"wp-content/plugins/pretty-link/css/prli-admin-links.css\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"94c29df3c34293b9f592ca108b2d6e2d\";}s:53:\"wp-content/plugins/pretty-link/prli-image-lookups.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"0d689148bf5bd66ae9d8173360c66184\";}s:46:\"wp-content/plugins/pretty-link/prli-clicks.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"4ca80c2219fc7475ec2182c68f1df603\";}s:48:\"wp-content/plugins/pretty-link/prli-add-link.php\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"9f7d41067b202def01f85428dbbe6c74\";}s:51:\"wp-content/plugins/pretty-link/i18n/pretty-link.pot\";a:2:{s:1:\"d\";i:1436914564;s:1:\"h\";s:32:\"4ab9acf99e7a16a34504a87832176bf9\";}s:39:\"wp-content/plugins/LayerSlider/init.php\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"eb39852dcbd15bdba3cf280825aca326\";}s:56:\"wp-content/plugins/LayerSlider/skins/minimal/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:53:\"wp-content/plugins/LayerSlider/skins/minimal/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"12a92190387c645598e919df09987d4b\";}s:66:\"wp-content/plugins/LayerSlider/skins/borderlesslight3d/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"4f31acc6c5e9aa3e15d9e8a2475c5f55\";}s:63:\"wp-content/plugins/LayerSlider/skins/borderlesslight3d/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"c08f1c979ba318c785ce9e108a81a0f5\";}s:54:\"wp-content/plugins/LayerSlider/skins/glass/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:51:\"wp-content/plugins/LayerSlider/skins/glass/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"bc481392c81acab1393f11f7736923d0\";}s:58:\"wp-content/plugins/LayerSlider/skins/fullwidth/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:55:\"wp-content/plugins/LayerSlider/skins/fullwidth/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"b3f8dbdbfa285ce58cf629f72e93c2ed\";}s:60:\"wp-content/plugins/LayerSlider/skins/defaultskin/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:57:\"wp-content/plugins/LayerSlider/skins/defaultskin/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"43461c47d6853954b7df5663708077c7\";}s:57:\"wp-content/plugins/LayerSlider/skins/carousel/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"4f31acc6c5e9aa3e15d9e8a2475c5f55\";}s:54:\"wp-content/plugins/LayerSlider/skins/carousel/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"86e04178853cbcb48b2804584b607d2d\";}s:57:\"wp-content/plugins/LayerSlider/skins/darkskin/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"e32ddf7c031699fc4f43ce30a9d57c39\";}s:54:\"wp-content/plugins/LayerSlider/skins/darkskin/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"7aa8160d6a51a6644ce5c94b5455683d\";}s:64:\"wp-content/plugins/LayerSlider/skins/borderlesslight/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"4f31acc6c5e9aa3e15d9e8a2475c5f55\";}s:61:\"wp-content/plugins/LayerSlider/skins/borderlesslight/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"2473f57f10bd6f0774e269cc7f48154d\";}s:55:\"wp-content/plugins/LayerSlider/skins/noskin/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:52:\"wp-content/plugins/LayerSlider/skins/noskin/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"38ef5d685e14d73ae722de05e32e611c\";}s:63:\"wp-content/plugins/LayerSlider/skins/borderlessdark/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"e82577eeffcfdbb0ee0b96210a4c9afd\";}s:60:\"wp-content/plugins/LayerSlider/skins/borderlessdark/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"81f75d27f86e83b442572e9660983df8\";}s:65:\"wp-content/plugins/LayerSlider/skins/borderlessdark3d/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"e32ddf7c031699fc4f43ce30a9d57c39\";}s:62:\"wp-content/plugins/LayerSlider/skins/borderlessdark3d/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"6c937a06bcac530ed839dc9659891a69\";}s:62:\"wp-content/plugins/LayerSlider/skins/fullwidthdark/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"e32ddf7c031699fc4f43ce30a9d57c39\";}s:59:\"wp-content/plugins/LayerSlider/skins/fullwidthdark/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"77f91e85513a68c68363ea8f5ce49046\";}s:56:\"wp-content/plugins/LayerSlider/skins/preview/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:53:\"wp-content/plugins/LayerSlider/skins/preview/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"ad61b9545a6a3de25b3218681a373518\";}s:58:\"wp-content/plugins/LayerSlider/skins/lightskin/loading.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"088b0fa7c6f5ef8a6f0c838999b4a2de\";}s:55:\"wp-content/plugins/LayerSlider/skins/lightskin/skin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"76dd2fcd0e9a152ac268a844249e03b3\";}s:50:\"wp-content/plugins/LayerSlider/js/jquerytransit.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"03bb1197b3cbcf89a1dc47e0f6d0a86f\";}s:66:\"wp-content/plugins/LayerSlider/js/layerslider.transitiongallery.js\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"dca10e4bbff37eb4eee292a65d19ee0a\";}s:44:\"wp-content/plugins/LayerSlider/js/builder.js\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"6352decb6964e301a9f5cea799a69ade\";}s:60:\"wp-content/plugins/LayerSlider/js/layerslider.transitions.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"b4949369baa25c6e20f483e6109d7cef\";}s:69:\"wp-content/plugins/LayerSlider/js/layerslider.kreaturamedia.jquery.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"47f73c8bb2ebf59121c938698a0acc96\";}s:42:\"wp-content/plugins/LayerSlider/js/admin.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"f7d2b6c0aba13a9fe0a94e7957c260fc\";}s:66:\"wp-content/plugins/LayerSlider/js/minicolors/jquery.minicolors.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"fa31c614adb91806edd2e13162fc7e6b\";}s:65:\"wp-content/plugins/LayerSlider/js/minicolors/jquery.minicolors.js\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"43c177ae3cfe0898a16fe78339ae7507\";}s:69:\"wp-content/plugins/LayerSlider/js/minicolors/jquery.minicolors.min.js\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"b37bfa0ed73d567852aea3245cc68fb1\";}s:54:\"wp-content/plugins/LayerSlider/js/jquery-easing-1.3.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"e91e3a60e7765ffa4ead2aa4a0a53e62\";}s:47:\"wp-content/plugins/LayerSlider/style_editor.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"b31151b50e03b66b89fa32a6867929c3\";}s:41:\"wp-content/plugins/LayerSlider/editor.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"2718de1c614bf64e92641f60b0080a6c\";}s:65:\"wp-content/plugins/LayerSlider/sampleslider/sample_transitions.js\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"1f65b36db3d6ced91e21ce24fb04b3c2\";}s:62:\"wp-content/plugins/LayerSlider/sampleslider/sample_sliders.txt\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"29379a3b18548077ec08c6195e9d103d\";}s:79:\"wp-content/plugins/LayerSlider/sampleslider/bi-colored-butterfly-source_ijc.gif\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"90fadf8e4debfd34a179c64cc10aa66c\";}s:38:\"wp-content/plugins/LayerSlider/add.php\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"dd93210aa66fd673b76e7aacc1348c6b\";}s:55:\"wp-content/plugins/LayerSlider/docs/other_features.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"20077389a66e64afd37976203ac23692\";}s:53:\"wp-content/plugins/LayerSlider/docs/slider_types.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"60c592fcf0ffb5b42eccc61fd14eb6d7\";}s:56:\"wp-content/plugins/LayerSlider/docs/styles_overview.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"4daf007551f491a6cec17c3effd990cb\";}s:55:\"wp-content/plugins/LayerSlider/docs/wysiwyg_editor.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"18c065997a3b79c7725859dd71ecc36a\";}s:59:\"wp-content/plugins/LayerSlider/docs/transition_easings.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"d95b4e21bf4f095f843aba4603cf088c\";}s:53:\"wp-content/plugins/LayerSlider/docs/exportimport.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"3f8f05a00139fc8745b58b095e4b7ddd\";}s:54:\"wp-content/plugins/LayerSlider/docs/transition_3d.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"2350636b19ad3efe73f662b35a3ff0a9\";}s:56:\"wp-content/plugins/LayerSlider/docs/event_callbacks.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"a4c69339605f27544973d77988354613\";}s:57:\"wp-content/plugins/LayerSlider/docs/managing_sliders.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"fdfd69bb0ea69304fe156d7571351b0a\";}s:57:\"wp-content/plugins/LayerSlider/docs/sublayer_options.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"4d9e93fb8a191e0e511c085a758ad703\";}s:54:\"wp-content/plugins/LayerSlider/docs/home_overview.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"1c443279a42c5d02384e6287b3ad2d17\";}s:54:\"wp-content/plugins/LayerSlider/docs/layer_options.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"f23108dac316c43d0fae81f9aae3e1df\";}s:54:\"wp-content/plugins/LayerSlider/docs/sample_slider.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"1d3e8aa4f43967831393c26abaeac057\";}s:44:\"wp-content/plugins/LayerSlider/docs/api.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"47b0e9df2f32e78c37ead37b0ba3f6ac\";}s:55:\"wp-content/plugins/LayerSlider/docs/gettingstarted.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"f193e7644f7fd7d3daced096ab94bc77\";}s:54:\"wp-content/plugins/LayerSlider/docs/edit_overview.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"e012f4810859a693f53b95b8ed2407d2\";}s:44:\"wp-content/plugins/LayerSlider/docs/faq.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"3ea60e25257f05dd8221c5d742686187\";}s:57:\"wp-content/plugins/LayerSlider/docs/embedding_videos.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"70f89af0ba7eafbdb1cc17523035fb63\";}s:57:\"wp-content/plugins/LayerSlider/docs/inserting_slider.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"6722a2443a5bc5ac9445c78a7c5a0330\";}s:60:\"wp-content/plugins/LayerSlider/docs/transition_overview.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"a1abf7e16c55ccb6c5f894f5a5bdb9d4\";}s:54:\"wp-content/plugins/LayerSlider/docs/skin_overview.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"e86de05323d7ce2d8979ac6c21fb6ebc\";}s:57:\"wp-content/plugins/LayerSlider/docs/transition_start.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"d0d1ae4d87635958756ed356b5b920ff\";}s:57:\"wp-content/plugins/LayerSlider/docs/language_support.html\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"ab3800689e160b1a6c010032ca7c45dd\";}s:39:\"wp-content/plugins/LayerSlider/edit.php\";a:2:{s:1:\"d\";i:1382008346;s:1:\"h\";s:32:\"e1e9ce65dfc098953d8433e138dd0e2a\";}s:41:\"wp-content/plugins/LayerSlider/slider.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"06b3679cd0b605f3c697308d7be20262\";}s:39:\"wp-content/plugins/LayerSlider/list.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"af60a853f3022dd59e6f8d3b6a19ee80\";}s:68:\"wp-content/plugins/LayerSlider/css/layerslider.transitiongallery.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"7403818cbde4cb26bd75ddfded40080c\";}s:44:\"wp-content/plugins/LayerSlider/css/admin.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"66919f7ae412c2010f904bdfb568f280\";}s:44:\"wp-content/plugins/LayerSlider/css/blank.gif\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"76084e29cb2cf72b320e888edc583dfb\";}s:45:\"wp-content/plugins/LayerSlider/css/global.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"807b375f85d9fda1b7c1a243e3ac1c7c\";}s:50:\"wp-content/plugins/LayerSlider/css/layerslider.css\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"80651e7f60418a359286c4322d2dc2ea\";}s:46:\"wp-content/plugins/LayerSlider/layerslider.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"9500a56e090ca81b3fc3c61d7007d69a\";}s:42:\"wp-content/plugins/LayerSlider/builder.php\";a:2:{s:1:\"d\";i:1382008345;s:1:\"h\";s:32:\"f7a35cbf660e67dfce6d7baf896c5ac8\";}s:28:\"wp-content/plugins/index.php\";a:2:{s:1:\"d\";i:1239843424;s:1:\"h\";s:32:\"96137494913a1f730a592e8932af394e\";}s:65:\"wp-content/plugins/better-wp-security/core/class-itsec-notify.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"295cd4fcf982eff5c6c81adf0974502c\";}s:92:\"wp-content/plugins/better-wp-security/core/class-ithemes-sync-verb-itsec-release-lockout.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"6457a548a8f8ffee5ea0eb53eccb639e\";}s:70:\"wp-content/plugins/better-wp-security/core/js/admin-global-settings.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"cd77355904d3c8c275c20a04a333c23e\";}s:71:\"wp-content/plugins/better-wp-security/core/js/admin-dashboard-footer.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"d1ea81a598b60670cd986f8e621ce017\";}s:60:\"wp-content/plugins/better-wp-security/core/js/admin-modal.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"848fd443789ce43691748a7cfb202522\";}s:64:\"wp-content/plugins/better-wp-security/core/js/admin-whitelist.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"21b15ea55fd26b9e255a29be1ddccbba\";}s:55:\"wp-content/plugins/better-wp-security/core/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:52:\"wp-content/plugins/better-wp-security/core/js/url.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"599383847667e2d1ca51a959143ed207\";}s:64:\"wp-content/plugins/better-wp-security/core/js/admin-dashboard.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"90c89987a892a380cb933a59af1eb326\";}s:57:\"wp-content/plugins/better-wp-security/core/js/tracking.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"af44ef090dd429c67ab3c5b0ca0fa42b\";}s:59:\"wp-content/plugins/better-wp-security/core/js/admin-logs.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"69ffc55192426976cbf0f4883c1ca4da\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/js/admin-four-oh-four.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"45b5ac6b844b96ee18e5500a6dd80678\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/class-itsec-four-oh-four.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a4475b9d56d0d023bfd02694364f6f8e\";}s:96:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/class-itsec-four-oh-four-log.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f729573f11f97375cc6e8a8af9f7cf38\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"cc685e2aaceb7e09e567a62b16e72174\";}s:98:\"wp-content/plugins/better-wp-security/core/modules/four-oh-four/class-itsec-four-oh-four-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"04b74619c09a150e563ee91492374f25\";}s:98:\"wp-content/plugins/better-wp-security/core/modules/content-directory/js/admin-content_directory.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"5f81e27e3e013a7afffe69b4ad428caa\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/content-directory/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:108:\"wp-content/plugins/better-wp-security/core/modules/content-directory/class-itsec-content-directory-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"92c138674fffdf7c8ce7988c84dd4b30\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/content-directory/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/ban-users/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/ban-users/js/admin-ban_users.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a25c79323346673ea6b30b10fa1d91e5\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/ban-users/class-itsec-ban-users-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"c52e67535f5c7ad0fcd6c2859673e3d0\";}s:91:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-litespeed.inc\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"cd11308af5ed2e01eb01001270264836\";}s:87:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-nginx.inc\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"89abe006c49ce40f736175b1e06784c3\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/ban-users/lists/hackrepair-apache.inc\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"cd11308af5ed2e01eb01001270264836\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/ban-users/class-itsec-ban-users.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"e434c4482163caf0d2c7515ed27e8f4b\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/ban-users/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/ban-users/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"4a94aca3090863b9d5a793decdb51972\";}s:84:\"wp-content/plugins/better-wp-security/core/modules/salts/class-itsec-salts-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"0021b0595bf603becba0c8f73cb28ee2\";}s:66:\"wp-content/plugins/better-wp-security/core/modules/salts/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:66:\"wp-content/plugins/better-wp-security/core/modules/salts/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1da3de4382bc608d351f7ea26c91a813\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/core/class-itsec-core-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"93dd5de83bf689ba2559d25a4619226b\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/core/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/core/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ebb79310f32bc568e61fc6c2eaf50b0b\";}s:69:\"wp-content/plugins/better-wp-security/core/modules/core/img/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:83:\"wp-content/plugins/better-wp-security/core/modules/backup/js/jquery.multi-select.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1a0dd3138876ec438b3ff0bb93752209\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/backup/js/admin-backup.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ceb0b4480fa99c6203e4e80386238fa1\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/backup/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/backup/class-itsec-backup-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"7ab482a3da96667275753c84c5358d07\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/backup/class-itsec-backup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"caa38dc062524ed501db48bedadebd8f\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/backup/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/backup/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"b1d5f1b2f160707f85507bb11607352f\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/backup/img/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/backup/css/admin-backup.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"10069259f7ceb36eac85fed355d571a9\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/backup/css/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/backup/css/multi-select.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"8317a4491407795d85521c820897dbff\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/tweaks/class-itsec-tweaks.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"5098d494920953485b9c164378c331f2\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/tweaks/class-itsec-tweaks-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"116507016126bdeab228a76930b8be97\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/tweaks/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/tweaks/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"86e97de699f5a5f70e0e40479b6f71f5\";}s:84:\"wp-content/plugins/better-wp-security/core/modules/admin-user/js/admin-admin-user.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1fd96f3c6412b0b509c8f23d9634f1b5\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/admin-user/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/admin-user/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/admin-user/class-itsec-admin-user-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"8ca4ef7190f3145d4cd391d779540a63\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/js/admin-hide-backend.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"3033bf6548214e7d59af829168156701\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/class-itsec-hide-backend.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1b06eb7caa7aec3acaba0f041475be8c\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:98:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/class-itsec-hide-backend-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"90efd67ad1959e48e9d06d8b09fe95e6\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/hide-backend/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"8cbdf5b73f5f0a38a0a9b6a2ac6a1e5e\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/ssl/class-itsec-ssl-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1c8b495e68ed738bc83adaa8b7fc6e6f\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/ssl/js/admin-ssl.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"97bf3e778204ebfa45b94a2c3c9c0bec\";}s:67:\"wp-content/plugins/better-wp-security/core/modules/ssl/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/ssl/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:64:\"wp-content/plugins/better-wp-security/core/modules/ssl/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"43e8dc3cfe15143667d5e5267f36fb9d\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/ssl/class-itsec-ssl.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ce376b471b14a06b30d57d5646a63811\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/database-prefix/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:104:\"wp-content/plugins/better-wp-security/core/modules/database-prefix/class-itsec-database-prefix-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"093bcfd7aeae77797b0c09e108f8f429\";}s:104:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-scan-results-template.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"295b49ccae34aca54b5d250c76cb2594\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/malware/js/malware.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f1a1e9af4d9efffed71bb76b97d07ad6\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/malware/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-scanner.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f1df1b694c66ec33a0760358461eeba5\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-log.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"36d97bd89a974fdaa70f39d6b7791d05\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/malware/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/malware/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"65149bdb753bb8658a0206a2e3ac15ba\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f4784d8a8b115135b342a3d3d67a9b61\";}s:108:\"wp-content/plugins/better-wp-security/core/modules/malware/class-ithemes-sync-verb-itsec-do-malware-scan.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"fbfffe0d3e8606acb1e22f9dcc7a15f5\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/malware/css/malware.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"b9e4db76674d4e2b815055c0660eb090\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/malware/css/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:113:\"wp-content/plugins/better-wp-security/core/modules/malware/class-ithemes-sync-verb-itsec-get-malware-scan-log.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1981ab27fd0f1ea55d67fab8c768bd22\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/malware/class-itsec-malware.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"170f653cb38049328a1d52a07eacb5a0\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/help/class-itsec-help-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"05ad3022e0966e38aeb09ca333f0dc4c\";}s:65:\"wp-content/plugins/better-wp-security/core/modules/help/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:60:\"wp-content/plugins/better-wp-security/core/modules/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:71:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/js/admin-ipcheck.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"23678a888d1c4931e22b95661e967f49\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/class-itsec-ipcheck-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"9a84513e5123dded50a79b15d07e0540\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/class-itsec-ipcheck.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"9e5087f38748dde727b0ba4bf8ce5a45\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:68:\"wp-content/plugins/better-wp-security/core/modules/ipcheck/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"d0df63016b0e7012a6baf4d667361a0a\";}s:73:\"wp-content/plugins/better-wp-security/core/modules/away-mode/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:82:\"wp-content/plugins/better-wp-security/core/modules/away-mode/js/admin-away-mode.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"7ec5147185ec4df40a7fde2265607ec0\";}s:108:\"wp-content/plugins/better-wp-security/core/modules/away-mode/class-ithemes-sync-verb-itsec-get-away-mode.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"38181c574ba6a5652840b95086d05d87\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/away-mode/class-itsec-away-mode-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1a6d2dcc8bcd7ce6be59eb5c6bdb8498\";}s:113:\"wp-content/plugins/better-wp-security/core/modules/away-mode/class-ithemes-sync-verb-itsec-override-away-mode.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"dd22f0bcd5a1e1da5ee6bdf683b674cb\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/away-mode/class-itsec-away-mode.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"5ecbf71b0eb55335654abc33db06824f\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/away-mode/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:70:\"wp-content/plugins/better-wp-security/core/modules/away-mode/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"2dd70dea820b5e5afc2d6b367ac21f85\";}s:103:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/smoothness/jquery-ui-1.10.4.custom.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"56e344959af5a4037cb52db55cd29c02\";}s:85:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/smoothness/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:92:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/smoothness/images/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:103:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/smoothness/images/animated-overlay.gif\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"2b912f7c0653008ca28ebacda49025e7\";}s:74:\"wp-content/plugins/better-wp-security/core/modules/away-mode/css/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/js/strong-passwords.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f1a73782fa086c7a5445f9e49c1975dc\";}s:80:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:96:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/js/admin-strong-passwords.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"47f08849c75a057486126a6b11da239b\";}s:106:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/class-itsec-strong-passwords-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"327ee3bafd84acaf692b8adc16225f63\";}s:100:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/class-itsec-strong-passwords.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"2abb22f96a51a315423ebc4928320659\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:77:\"wp-content/plugins/better-wp-security/core/modules/strong-passwords/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"84b6e2078d673f7637b1b8b67af41a1c\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/admin-file-change-warning.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"892b85a2b487aeb8f07ece552a6f8924\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/file-change/js/admin-file-change.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"db9ed1f79f076824eaed41a4bbc1f5ea\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-itsec-file-change-log.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"2779419bda531bcd7ea85cc2682e95f8\";}s:96:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-itsec-file-change-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"24799f47bdc51bec086530ce08b50d71\";}s:114:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-ithemes-sync-verb-itsec-perform-file-scan.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"be3cf5c4fe48c12d9446986fccc12713\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/file-change/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/file-change/filetree/jqueryFileTree.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"60f395cd20597c1609bea2fc572d3d4d\";}s:89:\"wp-content/plugins/better-wp-security/core/modules/file-change/filetree/jqueryFileTree.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"58cb1c7b9671dc7c9cf3955f0a1ece01\";}s:81:\"wp-content/plugins/better-wp-security/core/modules/file-change/filetree/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/file-change/filetree/images/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/file-change/filetree/images/spinner.gif\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"9a8269421303631316be4ab5e34870e1\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/file-change/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a1acbe3a5aa1bc72e931be82feb6b7c7\";}s:79:\"wp-content/plugins/better-wp-security/core/modules/file-change/images/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/file-change/class-itsec-file-change.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"5aed6216c334704c3f301701e4cfc46a\";}s:88:\"wp-content/plugins/better-wp-security/core/modules/file-change/css/admin-file-change.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"0bfecf7f29cf40852cb1cde80605f6ce\";}s:76:\"wp-content/plugins/better-wp-security/core/modules/file-change/css/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:86:\"wp-content/plugins/better-wp-security/core/modules/brute-force/js/admin-brute-force.js\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"f8d46e51fcc0472fb880899fb50f1414\";}s:75:\"wp-content/plugins/better-wp-security/core/modules/brute-force/js/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:96:\"wp-content/plugins/better-wp-security/core/modules/brute-force/class-itsec-brute-force-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"85e54ae872832809285b4f254b5d94ca\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/brute-force/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:94:\"wp-content/plugins/better-wp-security/core/modules/brute-force/class-itsec-brute-force-log.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"afb4fbc6813379e6a705679ce0fbee1b\";}s:90:\"wp-content/plugins/better-wp-security/core/modules/brute-force/class-itsec-brute-force.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"0866ff26f7cfbee0f00f6fb0289d94bb\";}s:72:\"wp-content/plugins/better-wp-security/core/modules/brute-force/setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1c715871a2a579c0f4e57f0861b603a6\";}s:76:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-wp-list-table.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ad12b4ee76a173a953b5a0e00b336a4e\";}s:71:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-file.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"b4a8cb9ad1e22fcffed51407fc5e27f1\";}s:76:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-directory.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"0775974023f09386c7845ef87318c423\";}s:56:\"wp-content/plugins/better-wp-security/core/lib/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:78:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-config-file.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ced67d7ec02e7d196e89bbc273ac7fca\";}s:74:\"wp-content/plugins/better-wp-security/core/lib/class-itsec-lib-utility.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"6d2fbc1135a47e970214ed4393cfcf10\";}s:54:\"wp-content/plugins/better-wp-security/core/history.txt\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"eb4495ea86b4b93bc72e4c3690b4ccdd\";}s:63:\"wp-content/plugins/better-wp-security/core/class-itsec-sync.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"715b620ab717c0b84d1c6cd4fa7c93a5\";}s:95:\"wp-content/plugins/better-wp-security/core/class-ithemes-sync-verb-itsec-get-temp-whitelist.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"ead39c001279cf7e978c576e681dd5b0\";}s:74:\"wp-content/plugins/better-wp-security/core/class-itsec-global-settings.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"505efeb603ea9fec0c3e1fa3ed2b8b1d\";}s:64:\"wp-content/plugins/better-wp-security/core/class-itsec-files.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"bb2a960451bb783e47c9107e950415b4\";}s:63:\"wp-content/plugins/better-wp-security/core/class-itsec-core.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"87b1e17683963a57cd15f1d7ebf7ae30\";}s:95:\"wp-content/plugins/better-wp-security/core/class-ithemes-sync-verb-itsec-set-temp-whitelist.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"d34208a1f69d7d4b793930ac89393343\";}s:64:\"wp-content/plugins/better-wp-security/core/class-itsec-setup.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"cfb6d5f481f6886097431555f82cba96\";}s:66:\"wp-content/plugins/better-wp-security/core/class-itsec-lockout.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"908fc0379b19b4b044b4342c5e717af6\";}s:74:\"wp-content/plugins/better-wp-security/core/class-itsec-logger-all-logs.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"6306ecbf5c1bfff081fbabe6ba741be1\";}s:62:\"wp-content/plugins/better-wp-security/core/class-itsec-lib.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"20cbb940582eddfc1f75e0ac787c0fc1\";}s:52:\"wp-content/plugins/better-wp-security/core/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:65:\"wp-content/plugins/better-wp-security/core/class-itsec-logger.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"430b4b3ef1163de5558a326ca53a7c39\";}s:91:\"wp-content/plugins/better-wp-security/core/class-ithemes-sync-verb-itsec-get-everything.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"30bfba13b42142384c9c5e9b69011bd4\";}s:74:\"wp-content/plugins/better-wp-security/core/class-itsec-dashboard-admin.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"5486cc08887e137fcd5e09b808e43f87\";}s:56:\"wp-content/plugins/better-wp-security/core/img/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:89:\"wp-content/plugins/better-wp-security/core/class-ithemes-sync-verb-itsec-get-lockouts.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a4efe2fe48feb3881c86eb5bd911a747\";}s:58:\"wp-content/plugins/better-wp-security/core/css/ithemes.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"064c18dcd6dfdeed71a87dd8c18d6a31\";}s:56:\"wp-content/plugins/better-wp-security/core/css/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:63:\"wp-content/plugins/better-wp-security/core/css/itsec_notice.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"c626d3afe5b9235f34d6cbde136b5532\";}s:60:\"wp-content/plugins/better-wp-security/core/content/perms.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"de8a65411ec2c4c93a7a0db6b810b59b\";}s:61:\"wp-content/plugins/better-wp-security/core/content/system.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a81dca6ad71752c2da4d0684de152865\";}s:60:\"wp-content/plugins/better-wp-security/core/content/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a5eb3a234af13e4af877ef721778894b\";}s:61:\"wp-content/plugins/better-wp-security/core/content/status.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"3e0c2393da7bedff43d9f719b878896a\";}s:61:\"wp-content/plugins/better-wp-security/lib/icon-fonts/init.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"daf9ccc98e1dd336debfd9523d34f9ce\";}s:61:\"wp-content/plugins/better-wp-security/lib/icon-fonts/load.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"7a36ea8313f8bdbd123c037f75b0e3e6\";}s:64:\"wp-content/plugins/better-wp-security/lib/icon-fonts/history.txt\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a1314384f4d9242b5ffef5a365473efa\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.ttf\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"3638c3971bed7ade6547754a896668e8\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.svg\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"80804bef4ecda4805e6f87f9325a77af\";}s:77:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.woff\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"1849448daea1ad4ba5d53cc439b2e773\";}s:68:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:76:\"wp-content/plugins/better-wp-security/lib/icon-fonts/fonts/ithemes-icons.eot\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"806a53b830f29c4e1a92398a5233dbce\";}s:67:\"wp-content/plugins/better-wp-security/lib/icon-fonts/icon-fonts.css\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"07a63c161dc5e944dd1450699dd47ebb\";}s:62:\"wp-content/plugins/better-wp-security/lib/icon-fonts/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"edd44fb57046348bb90a9bca014b6b4f\";}s:81:\"wp-content/plugins/better-wp-security/lib/one-version/class-itsec-one-version.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"70e8d57576b930f92fd41f36e8200a6b\";}s:63:\"wp-content/plugins/better-wp-security/lib/one-version/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"a226c6de61cbbe874fc9a631effa7efc\";}s:51:\"wp-content/plugins/better-wp-security/lib/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"56d4439768678cd301f9a9f140f9440b\";}s:49:\"wp-content/plugins/better-wp-security/history.txt\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"e81efcd049a4b3c5d29853af5151beb4\";}s:52:\"wp-content/plugins/better-wp-security/lang/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"56d4439768678cd301f9a9f140f9440b\";}s:65:\"wp-content/plugins/better-wp-security/lang/better-wp-security.pot\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"6df3480aba6444c86e3f75bdfdc78d68\";}s:60:\"wp-content/plugins/better-wp-security/better-wp-security.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"52ba9ad005590b266b9f48876afc0c5c\";}s:48:\"wp-content/plugins/better-wp-security/readme.txt\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"4511ca63fb37817f4c4fe976da541037\";}s:47:\"wp-content/plugins/better-wp-security/index.php\";a:2:{s:1:\"d\";i:1443105849;s:1:\"h\";s:32:\"56d4439768678cd301f9a9f140f9440b\";}s:59:\"wp-content/plugins/duplicate-post/duplicate-post-common.php\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"217d2c6d6e385fb54e9c2d82543aee80\";}s:45:\"wp-content/plugins/duplicate-post/gpl-2.0.txt\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"b234ee4d69f5fce4486a80fdaf4a4263\";}s:44:\"wp-content/plugins/duplicate-post/readme.txt\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"70f8bc09acca59c834ebc95b8348ccd3\";}s:58:\"wp-content/plugins/duplicate-post/duplicate-post-admin.php\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"32cc1606490c263ae9c3bc1d9537b8e9\";}s:60:\"wp-content/plugins/duplicate-post/duplicate-post-options.php\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"b4938a596a9fcb8b8fe37da8108c3268\";}s:52:\"wp-content/plugins/duplicate-post/duplicate-post.php\";a:2:{s:1:\"d\";i:1409400432;s:1:\"h\";s:32:\"c40ad87186c807ccd1d0c42e904c037d\";}s:56:\"wp-content/plugins/limit-login-attempts/screenshot-3.gif\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"9d88cb86a2bc5432f2d557e4e0937cdc\";}s:64:\"wp-content/plugins/limit-login-attempts/limit-login-attempts.php\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"4df8195c9a455804aba5db6c53f06174\";}s:56:\"wp-content/plugins/limit-login-attempts/screenshot-2.gif\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"d0221ac413d4522b12f52468f9f92054\";}s:56:\"wp-content/plugins/limit-login-attempts/screenshot-1.gif\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"64e36e6e162a7d442aff613ea19b1205\";}s:50:\"wp-content/plugins/limit-login-attempts/readme.txt\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"cb920183db0bec710043d2ee0a53dd5a\";}s:64:\"wp-content/plugins/limit-login-attempts/limit-login-attempts.pot\";a:2:{s:1:\"d\";i:1383659358;s:1:\"h\";s:32:\"53fbb0162e39b2e8cabf5652bf74e6b3\";}s:20:\"wp-content/index.php\";a:2:{s:1:\"d\";i:1326063672;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:43:\"wp-content/themes/satellite/wpml-config.xml\";a:2:{s:1:\"d\";i:1382074386;s:1:\"h\";s:32:\"634f08a66fd97238b4f9762c82c31456\";}s:39:\"wp-content/themes/satellite/toolbar.php\";a:2:{s:1:\"d\";i:1382074384;s:1:\"h\";s:32:\"d86059c8b2c366fde2692ecd5a51d5b5\";}s:47:\"wp-content/themes/satellite/js/jquery.appear.js\";a:2:{s:1:\"d\";i:1382074283;s:1:\"h\";s:32:\"39ecc1a1295c56092991dface741e1e1\";}s:41:\"wp-content/themes/satellite/js/toolbar.js\";a:2:{s:1:\"d\";i:1382074373;s:1:\"h\";s:32:\"c69fe55593619ada1bdb81a274f1f269\";}s:41:\"wp-content/themes/satellite/js/plugins.js\";a:2:{s:1:\"d\";i:1382074360;s:1:\"h\";s:32:\"4df0ed4073f3a36c7b6fd66bb003e603\";}s:52:\"wp-content/themes/satellite/js/admin/qode_sidebar.js\";a:2:{s:1:\"d\";i:1382074228;s:1:\"h\";s:32:\"b07a249927a363123600e6fc73e70996\";}s:51:\"wp-content/themes/satellite/js/admin/colorpicker.js\";a:2:{s:1:\"d\";i:1382074223;s:1:\"h\";s:32:\"b7b867ffc0579bfd61842a2b3f5cb2e1\";}s:47:\"wp-content/themes/satellite/js/admin/default.js\";a:2:{s:1:\"d\";i:1382074225;s:1:\"h\";s:32:\"56fa6ac65658bf55658ce4841c2d0759\";}s:52:\"wp-content/themes/satellite/js/jquery.prettyPhoto.js\";a:2:{s:1:\"d\";i:1382074315;s:1:\"h\";s:32:\"51d2c2977e3dbb58e8ee5a5f52673aa0\";}s:52:\"wp-content/themes/satellite/js/jquery.mixitup.min.js\";a:2:{s:1:\"d\";i:1382074306;s:1:\"h\";s:32:\"67226249c374fdde04a5091f7129bcfb\";}s:56:\"wp-content/themes/satellite/js/jquery.hoverIntent.min.js\";a:2:{s:1:\"d\";i:1382074295;s:1:\"h\";s:32:\"b4cfa1d07f60eebd4746a3941196bd67\";}s:48:\"wp-content/themes/satellite/js/jquery.fitvids.js\";a:2:{s:1:\"d\";i:1382074285;s:1:\"h\";s:32:\"1f43a50a237dc7e6145961443b48df26\";}s:45:\"wp-content/themes/satellite/js/woocommerce.js\";a:2:{s:1:\"d\";i:1382074376;s:1:\"h\";s:32:\"23a57026f6cd92dbe77924fed2a8e7da\";}s:55:\"wp-content/themes/satellite/js/jquery.nicescroll.min.js\";a:2:{s:1:\"d\";i:1382074311;s:1:\"h\";s:32:\"b712773d7565901cfaa401ff8d03e190\";}s:53:\"wp-content/themes/satellite/js/modernizr-2.6.2.min.js\";a:2:{s:1:\"d\";i:1382074330;s:1:\"h\";s:32:\"42306a279a9e831515347ae319181cd1\";}s:44:\"wp-content/themes/satellite/js/custom_js.php\";a:2:{s:1:\"d\";i:1382074249;s:1:\"h\";s:32:\"24c6e9905a3872699a0b9d767922015f\";}s:42:\"wp-content/themes/satellite/js/ajax.min.js\";a:2:{s:1:\"d\";i:1382074235;s:1:\"h\";s:32:\"28a26c7177751941e925a08c69afa80c\";}s:52:\"wp-content/themes/satellite/js/flashmediaelement.swf\";a:2:{s:1:\"d\";i:1382074269;s:1:\"h\";s:32:\"03dc1336e5697e4ceda3a7f4b99b71c7\";}s:43:\"wp-content/themes/satellite/js/qode-like.js\";a:2:{s:1:\"d\";i:1382074363;s:1:\"h\";s:32:\"90a9a3aca53b8f51a71023b1bb94b341\";}s:48:\"wp-content/themes/satellite/js/jquery.isotope.js\";a:2:{s:1:\"d\";i:1382074303;s:1:\"h\";s:32:\"6d47cccc7cb377fb74a9a0379d35545c\";}s:38:\"wp-content/themes/satellite/js/ajax.js\";a:2:{s:1:\"d\";i:1382074232;s:1:\"h\";s:32:\"c9e0c0fa51f112c5cd66369dc48efef9\";}s:41:\"wp-content/themes/satellite/js/counter.js\";a:2:{s:1:\"d\";i:1382074247;s:1:\"h\";s:32:\"8f29129079c630cd27e9613626ed230a\";}s:50:\"wp-content/themes/satellite/js/default_dynamic.php\";a:2:{s:1:\"d\";i:1382074253;s:1:\"h\";s:32:\"2c584b6df59058e5c0ad4472648014b5\";}s:47:\"wp-content/themes/satellite/js/doubletaptogo.js\";a:2:{s:1:\"d\";i:1382074265;s:1:\"h\";s:32:\"b37b4448aec48e1a156f7c8ec0459aea\";}s:51:\"wp-content/themes/satellite/js/jquery-1.10.2.min.js\";a:2:{s:1:\"d\";i:1382074280;s:1:\"h\";s:32:\"841dc30647f93349b7d8ef61deebe411\";}s:45:\"wp-content/themes/satellite/js/jquery.form.js\";a:2:{s:1:\"d\";i:1382074293;s:1:\"h\";s:32:\"95ef5c3a6b4ec45bd965b8a1a66e32b5\";}s:39:\"wp-content/themes/satellite/js/html5.js\";a:2:{s:1:\"d\";i:1382074271;s:1:\"h\";s:32:\"6425ccec7077472f3fb2ed8ad8f64c8c\";}s:55:\"wp-content/themes/satellite/js/jquery.flexslider-min.js\";a:2:{s:1:\"d\";i:1382074289;s:1:\"h\";s:32:\"a4a2e2a36685656f844d11df1911e53c\";}s:45:\"wp-content/themes/satellite/js/default.min.js\";a:2:{s:1:\"d\";i:1382074263;s:1:\"h\";s:32:\"a988e30e45e5caeb3dee9c56f22811d6\";}s:41:\"wp-content/themes/satellite/js/default.js\";a:2:{s:1:\"d\";i:1382074258;s:1:\"h\";s:32:\"4115b620bca0c6c28ffd016f9dbde58e\";}s:59:\"wp-content/themes/satellite/js/jquery.stylish-select.min.js\";a:2:{s:1:\"d\";i:1382074317;s:1:\"h\";s:32:\"04190eb0d8bdd1062c55eb24faa34905\";}s:45:\"wp-content/themes/satellite/js/select2.min.js\";a:2:{s:1:\"d\";i:1382074369;s:1:\"h\";s:32:\"4def06ec51f3977106a00c71f14f21db\";}s:54:\"wp-content/themes/satellite/js/jquery.waitforimages.js\";a:2:{s:1:\"d\";i:1382074320;s:1:\"h\";s:32:\"0f3172beb3db0f130abcd2f234c8c0bf\";}s:43:\"wp-content/themes/satellite/js/Chart.min.js\";a:2:{s:1:\"d\";i:1382074242;s:1:\"h\";s:32:\"b4d289db3f185e5c3f7ae8695441a62d\";}s:61:\"wp-content/themes/satellite/js/mediaelement-and-player.min.js\";a:2:{s:1:\"d\";i:1382074326;s:1:\"h\";s:32:\"e854f51e180eda867a08d5a2ca29e358\";}s:40:\"wp-content/themes/satellite/category.php\";a:2:{s:1:\"d\";i:1382074358;s:1:\"h\";s:32:\"ec4ff538a0cbde0c00377aaf57ee5f22\";}s:58:\"wp-content/themes/satellite/widgets/flickr-qode-widget.php\";a:2:{s:1:\"d\";i:1382074229;s:1:\"h\";s:32:\"4aa7c824595f6e23b0a0c92b989d5fb8\";}s:60:\"wp-content/themes/satellite/widgets/format_blog-standard.php\";a:2:{s:1:\"d\";i:1382074231;s:1:\"h\";s:32:\"ce2b5d715b87f9768572779907d33fc0\";}s:59:\"wp-content/themes/satellite/widgets/relate_posts_widget.php\";a:2:{s:1:\"d\";i:1382074234;s:1:\"h\";s:32:\"6c29a9285b1b0c3850c6919226cef45e\";}s:65:\"wp-content/themes/satellite/20131203-04.09.23-header.php.wpseobak\";a:2:{s:1:\"d\";i:1386043763;s:1:\"h\";s:32:\"d8edabdbd810d60032f7fd2260e12449\";}s:36:\"wp-content/themes/satellite/home.php\";a:2:{s:1:\"d\";i:1422543966;s:1:\"h\";s:32:\"9f7b37157cd3f9ac73612f726179ad64\";}s:35:\"wp-content/themes/satellite/404.php\";a:2:{s:1:\"d\";i:1382074315;s:1:\"h\";s:32:\"901355b605be9d502f53ece6e482c32c\";}s:65:\"wp-content/themes/satellite/20131203-04.09.57-header.php.wpseobak\";a:2:{s:1:\"d\";i:1386043797;s:1:\"h\";s:32:\"7f178a07bf63654c39c3adf2c29792c2\";}s:71:\"wp-content/themes/satellite/plugins/layersliderwp-4.6.1.installable.zip\";a:2:{s:1:\"d\";i:1382074412;s:1:\"h\";s:32:\"6ad16ac374a429331bcf4e2d33e92a09\";}s:36:\"wp-content/themes/satellite/page.php\";a:2:{s:1:\"d\";i:1422545899;s:1:\"h\";s:32:\"9c570c231f15f5b71cfbe23f52bac7fe\";}s:63:\"wp-content/themes/satellite/blog_full_image_whole_post-loop.php\";a:2:{s:1:\"d\";i:1382074321;s:1:\"h\";s:32:\"becd50ee45e7d140ee64fdff71fb2989\";}s:38:\"wp-content/themes/satellite/single.php\";a:2:{s:1:\"d\";i:1386909210;s:1:\"h\";s:32:\"95bd95fc88eaf9c5845c98b07ab86c5a\";}s:44:\"wp-content/themes/satellite/contact-page.php\";a:2:{s:1:\"d\";i:1382478359;s:1:\"h\";s:32:\"e244218b7424708eb5f4a25194978825\";}s:53:\"wp-content/themes/satellite/blog-full-width-image.php\";a:2:{s:1:\"d\";i:1383051306;s:1:\"h\";s:32:\"1a55097a166fb796d26606dae4333364\";}s:53:\"wp-content/themes/satellite/blog_small_image-loop.php\";a:2:{s:1:\"d\";i:1382074334;s:1:\"h\";s:32:\"7c6ddbe05bc48d5fb5e6ea1af5e51551\";}s:59:\"wp-content/themes/satellite/woocommerce/loop/pagination.php\";a:2:{s:1:\"d\";i:1382074272;s:1:\"h\";s:32:\"10a41b398f771273f475df08dba85f07\";}s:59:\"wp-content/themes/satellite/woocommerce/loop/loop-start.php\";a:2:{s:1:\"d\";i:1382074270;s:1:\"h\";s:32:\"0a5787416524e358e374dd7f681264bf\";}s:53:\"wp-content/themes/satellite/woocommerce/cart/cart.php\";a:2:{s:1:\"d\";i:1382074245;s:1:\"h\";s:32:\"ad08c8d02385828e14f4bfaf7ceecf36\";}s:59:\"wp-content/themes/satellite/woocommerce/cart/cart-empty.php\";a:2:{s:1:\"d\";i:1382074242;s:1:\"h\";s:32:\"ce85656150ef43f610f80546c14f157a\";}s:71:\"wp-content/themes/satellite/woocommerce/myaccount/form-edit-address.php\";a:2:{s:1:\"d\";i:1382074277;s:1:\"h\";s:32:\"0a149bfc323df4a7f4257baca6efca85\";}s:64:\"wp-content/themes/satellite/woocommerce/myaccount/my-address.php\";a:2:{s:1:\"d\";i:1382074285;s:1:\"h\";s:32:\"56138c024c262e8bca13490d1e2068bd\";}s:64:\"wp-content/themes/satellite/woocommerce/myaccount/form-login.php\";a:2:{s:1:\"d\";i:1382074279;s:1:\"h\";s:32:\"92e9bf59dc85ed87bbbd27ac24241ebb\";}s:72:\"wp-content/themes/satellite/woocommerce/myaccount/form-lost-password.php\";a:2:{s:1:\"d\";i:1382074282;s:1:\"h\";s:32:\"d759ded83ad62c97217c00471aced1bc\";}s:66:\"wp-content/themes/satellite/woocommerce/content-single-product.php\";a:2:{s:1:\"d\";i:1382074265;s:1:\"h\";s:32:\"37d2df32884aac2bd43a79f3780f466a\";}s:79:\"wp-content/themes/satellite/woocommerce/single-product/add-to-cart/quantity.php\";a:2:{s:1:\"d\";i:1382074296;s:1:\"h\";s:32:\"1baf500f14b68ca248039c87e2758a2d\";}s:68:\"wp-content/themes/satellite/woocommerce/single-product/tabs/tabs.php\";a:2:{s:1:\"d\";i:1382074300;s:1:\"h\";s:32:\"75115f3136f171aa7a43d1230d59cf08\";}s:69:\"wp-content/themes/satellite/woocommerce/woocommerce_configuration.php\";a:2:{s:1:\"d\";i:1382074303;s:1:\"h\";s:32:\"a6b013c0df885f5b5b0f280b77b12c8f\";}s:59:\"wp-content/themes/satellite/woocommerce/shop/form-login.php\";a:2:{s:1:\"d\";i:1382074289;s:1:\"h\";s:32:\"e143bde3b02914688b351ab4d7277c64\";}s:66:\"wp-content/themes/satellite/woocommerce/checkout/form-shipping.php\";a:2:{s:1:\"d\";i:1382074258;s:1:\"h\";s:32:\"61c0167f55b1468370a0ceab6213b52b\";}s:61:\"wp-content/themes/satellite/woocommerce/checkout/thankyou.php\";a:2:{s:1:\"d\";i:1382074260;s:1:\"h\";s:32:\"98b1926fc0d7a1ddc71380e6e2c186ef\";}s:65:\"wp-content/themes/satellite/woocommerce/checkout/form-billing.php\";a:2:{s:1:\"d\";i:1382074250;s:1:\"h\";s:32:\"96c6ade110f991bdb75a9c0d7b151db2\";}s:63:\"wp-content/themes/satellite/woocommerce/checkout/form-login.php\";a:2:{s:1:\"d\";i:1382074254;s:1:\"h\";s:32:\"940158ff7695f1e9134583bb0adbb685\";}s:48:\"wp-content/themes/satellite/blog_single-loop.php\";a:2:{s:1:\"d\";i:1396959677;s:1:\"h\";s:32:\"a53e3aa4b4f790c21bc461f96aebfcb5\";}s:43:\"wp-content/themes/satellite/woocommerce.php\";a:2:{s:1:\"d\";i:1382074385;s:1:\"h\";s:32:\"9fb733924fa5e9baf1f266023fc5242c\";}s:37:\"wp-content/themes/satellite/error_log\";a:2:{s:1:\"d\";i:1442341825;s:1:\"h\";s:32:\"3f8d8e49b2145ebc37f2770d88f37202\";}s:38:\"wp-content/themes/satellite/header.php\";a:2:{s:1:\"d\";i:1387061364;s:1:\"h\";s:32:\"d35f84ed2152ec714db51c977235baac\";}s:67:\"wp-content/themes/satellite/includes/qode_shortcodes_pie_chart3.php\";a:2:{s:1:\"d\";i:1382074286;s:1:\"h\";s:32:\"7badb080e3caa3b424d588c0aa86e195\";}s:64:\"wp-content/themes/satellite/includes/qode_shortcodes_message.php\";a:2:{s:1:\"d\";i:1382074278;s:1:\"h\";s:32:\"6e981f83afd09598845ccb7521253255\";}s:55:\"wp-content/themes/satellite/includes/qode_shortcodes.js\";a:2:{s:1:\"d\";i:1382074321;s:1:\"h\";s:32:\"2968172e1f81de91413d5a00223adc29\";}s:56:\"wp-content/themes/satellite/includes/qode_shortcodes.ico\";a:2:{s:1:\"d\";i:1382074316;s:1:\"h\";s:32:\"5f8d670580539f2c29184cac635c79c8\";}s:66:\"wp-content/themes/satellite/includes/qode_shortcodes_accordion.php\";a:2:{s:1:\"d\";i:1382074249;s:1:\"h\";s:32:\"c03d8a8fe49129a1a198b53341dab020\";}s:64:\"wp-content/themes/satellite/includes/qode_shortcodes_counter.php\";a:2:{s:1:\"d\";i:1382074257;s:1:\"h\";s:32:\"e0be2ca7fe2f69e2b310e1ff1a1b42dd\";}s:74:\"wp-content/themes/satellite/includes/qode_shortcodes_progress_bar_icon.php\";a:2:{s:1:\"d\";i:1382074301;s:1:\"h\";s:32:\"7d986e08ba8da4e8b2517c672da3aaf2\";}s:67:\"wp-content/themes/satellite/includes/qode_shortcodes_pie_chart2.php\";a:2:{s:1:\"d\";i:1382074283;s:1:\"h\";s:32:\"7badb080e3caa3b424d588c0aa86e195\";}s:68:\"wp-content/themes/satellite/includes/qode_shortcodes_blockquotes.php\";a:2:{s:1:\"d\";i:1382074251;s:1:\"h\";s:32:\"a758d8329f68f4508cd151ea47017ef5\";}s:68:\"wp-content/themes/satellite/includes/qode_shortcodes_latest_post.php\";a:2:{s:1:\"d\";i:1382074273;s:1:\"h\";s:32:\"9de55350997a8ddb7f6da2c108cc6ac0\";}s:63:\"wp-content/themes/satellite/includes/qode_shortcodes_popup.html\";a:2:{s:1:\"d\";i:1382074290;s:1:\"h\";s:32:\"c890810220f4a77c3c56cdf6b1f00c17\";}s:71:\"wp-content/themes/satellite/includes/qode_shortcodes_unordered_list.php\";a:2:{s:1:\"d\";i:1382074311;s:1:\"h\";s:32:\"3f8c08d2009c1bab14423338e367976f\";}s:67:\"wp-content/themes/satellite/includes/qode_shortcodes_line_graph.php\";a:2:{s:1:\"d\";i:1382074276;s:1:\"h\";s:32:\"556796fa6aecc84d673903877336c575\";}s:50:\"wp-content/themes/satellite/includes/qode-menu.php\";a:2:{s:1:\"d\";i:1382074331;s:1:\"h\";s:32:\"1890bc99172b0d19b120ecb0d2f1bb5f\";}s:66:\"wp-content/themes/satellite/includes/qode_shortcodes_pie_chart.php\";a:2:{s:1:\"d\";i:1382074281;s:1:\"h\";s:32:\"19ae01f45294942151580af794fdb492\";}s:54:\"wp-content/themes/satellite/includes/custom-fields.php\";a:2:{s:1:\"d\";i:1382074230;s:1:\"h\";s:32:\"0097fc1bdac7118d7ee4e2a95f759d54\";}s:72:\"wp-content/themes/satellite/includes/qode_shortcodes_icon_with_title.php\";a:2:{s:1:\"d\";i:1382074268;s:1:\"h\";s:32:\"193731c6bb5d834f9a2fb0d449d62ec6\";}s:59:\"wp-content/themes/satellite/includes/edit_custom_walker.php\";a:2:{s:1:\"d\";i:1382074233;s:1:\"h\";s:32:\"37b9cbbbc0e8d73fbf78cc780ea020ed\";}s:68:\"wp-content/themes/satellite/includes/class-tgm-plugin-activation.php\";a:2:{s:1:\"d\";i:1382074222;s:1:\"h\";s:32:\"5bc54daaaf97ae4e66583236d5538e15\";}s:53:\"wp-content/themes/satellite/includes/recaptchalib.php\";a:2:{s:1:\"d\";i:1382074346;s:1:\"h\";s:32:\"d49db79094e6ac67b2043ffa0dbeec2d\";}s:62:\"wp-content/themes/satellite/includes/qode_shortcodes_video.php\";a:2:{s:1:\"d\";i:1382074313;s:1:\"h\";s:32:\"d9dc1d85a0876b4335229ab2cf638a68\";}s:51:\"wp-content/themes/satellite/includes/shortcodes.php\";a:2:{s:1:\"d\";i:1383789666;s:1:\"h\";s:32:\"e6dce519062abb26b3432923a52bc0ce\";}s:71:\"wp-content/themes/satellite/includes/qode_shortcodes_portfolio_list.php\";a:2:{s:1:\"d\";i:1382074292;s:1:\"h\";s:32:\"a7948b79f7395a589d57286a2a6fd45e\";}s:60:\"wp-content/themes/satellite/includes/qode-custom-sidebar.php\";a:2:{s:1:\"d\";i:1382074325;s:1:\"h\";s:32:\"1138bf54043793d5e79ccb807697cf2b\";}s:75:\"wp-content/themes/satellite/includes/qode_shortcodes_elements_animation.php\";a:2:{s:1:\"d\";i:1382074264;s:1:\"h\";s:32:\"6cc32a035de0fef758392feb544c9c52\";}s:62:\"wp-content/themes/satellite/includes/qode_shortcodes_icons.php\";a:2:{s:1:\"d\";i:1382074271;s:1:\"h\";s:32:\"6927743bb5f010c13753638d6424751b\";}s:65:\"wp-content/themes/satellite/includes/qode_shortcodes_dropcaps.php\";a:2:{s:1:\"d\";i:1382074260;s:1:\"h\";s:32:\"c6cf3a335f3d3f3ac5ed5b2360c3616f\";}s:70:\"wp-content/themes/satellite/includes/qode_shortcodes_pricing_table.php\";a:2:{s:1:\"d\";i:1382074295;s:1:\"h\";s:32:\"2a971721705a064f96a16b27c281b20f\";}s:50:\"wp-content/themes/satellite/includes/qode-like.php\";a:2:{s:1:\"d\";i:1382074327;s:1:\"h\";s:32:\"06f611e4a087ea9523734282a3b27d9b\";}s:67:\"wp-content/themes/satellite/includes/custom-fields-post-formats.php\";a:2:{s:1:\"d\";i:1382074224;s:1:\"h\";s:32:\"7c14df5060e9107269c10951144ec687\";}s:63:\"wp-content/themes/satellite/includes/qode_shortcodes_button.php\";a:2:{s:1:\"d\";i:1382074254;s:1:\"h\";s:32:\"6da9656d7c78bda8342bdcff61d807d6\";}s:50:\"wp-content/themes/satellite/includes/ajax_mail.php\";a:2:{s:1:\"d\";i:1382074217;s:1:\"h\";s:32:\"ca0452b905c9ecb2419d9e42a8e75788\";}s:80:\"wp-content/themes/satellite/includes/qode_shortcodes_progress_bar_horizontal.php\";a:2:{s:1:\"d\";i:1382074297;s:1:\"h\";s:32:\"f271f0e9a0d2bfdfa8042d751b1b3989\";}s:68:\"wp-content/themes/satellite/includes/qode_shortcodes_social_icon.php\";a:2:{s:1:\"d\";i:1382074305;s:1:\"h\";s:32:\"a38bd1c8ee4e9baf656587394e4d010a\";}s:66:\"wp-content/themes/satellite/includes/qode_shortcodes_separator.php\";a:2:{s:1:\"d\";i:1382074303;s:1:\"h\";s:32:\"ff6d418e3c9f3736fa02c1eeff378444\";}s:53:\"wp-content/themes/satellite/includes/qode-options.php\";a:2:{s:1:\"d\";i:1382074342;s:1:\"h\";s:32:\"068cc5083f02b5d0cb3fde8263874a60\";}s:68:\"wp-content/themes/satellite/includes/qode_shortcodes_testimonial.php\";a:2:{s:1:\"d\";i:1382074308;s:1:\"h\";s:32:\"7c84ab0b0fee7c44150a2bfa98c2a9b9\";}s:53:\"wp-content/themes/satellite/includes/google-fonts.php\";a:2:{s:1:\"d\";i:1382074247;s:1:\"h\";s:32:\"8bb6f195a7915fe913c381df76f47a00\";}s:53:\"wp-content/themes/satellite/single-portfolio_page.php\";a:2:{s:1:\"d\";i:1382074383;s:1:\"h\";s:32:\"f70e9e57063b8387342fed200b226e54\";}s:44:\"wp-content/themes/satellite/blog-masonry.php\";a:2:{s:1:\"d\";i:1382074348;s:1:\"h\";s:32:\"1ff52268adeb11e059a2f0abfe3f63a4\";}s:37:\"wp-content/themes/satellite/index.php\";a:2:{s:1:\"d\";i:1422544045;s:1:\"h\";s:32:\"ec2c266a32e8b18e9a5660d9f47fadfe\";}s:39:\"wp-content/themes/satellite/archive.php\";a:2:{s:1:\"d\";i:1382074318;s:1:\"h\";s:32:\"3803990fa6b268a49867ebe9def69921\";}s:38:\"wp-content/themes/satellite/search.php\";a:2:{s:1:\"d\";i:1382074380;s:1:\"h\";s:32:\"67eb93aa053afe2df4c668690c776373\";}s:42:\"wp-content/themes/satellite/full_width.php\";a:2:{s:1:\"d\";i:1382074363;s:1:\"h\";s:32:\"b33f8b58e5b8e9f8181af71ebc58bf8c\";}s:37:\"wp-content/themes/satellite/style.css\";a:2:{s:1:\"d\";i:1386047059;s:1:\"h\";s:32:\"bf4f4639c20662e8cf2dc6065a8d8817\";}s:49:\"wp-content/themes/satellite/blog_masonry-loop.php\";a:2:{s:1:\"d\";i:1382074327;s:1:\"h\";s:32:\"fce71cfac6b0d7972ef6200b5722f6f1\";}s:42:\"wp-content/themes/satellite/searchform.php\";a:2:{s:1:\"d\";i:1383791459;s:1:\"h\";s:32:\"e29536d34e4dfde3ad03d35015f2d431\";}s:61:\"wp-content/themes/satellite/blog-full-width-image-content.php\";a:2:{s:1:\"d\";i:1382074340;s:1:\"h\";s:32:\"872f9dbf7d81b075fd4393dfe0bc4b9b\";}s:95:\"wp-content/themes/satellite/licence/layerslider-responsive-wordpress-slider-plugin--license.txt\";a:2:{s:1:\"d\";i:1382074218;s:1:\"h\";s:32:\"b318234bb9e590392a3c7feb9a0b4c18\";}s:43:\"wp-content/themes/satellite/licence/GPL.txt\";a:2:{s:1:\"d\";i:1382074216;s:1:\"h\";s:32:\"0f696556e1732d6a6d2f70e7157b5497\";}s:47:\"wp-content/themes/satellite/img/ajax-loader.gif\";a:2:{s:1:\"d\";i:1382074206;s:1:\"h\";s:32:\"b562bf6b67ae7d815bbbc8b76a714279\";}s:43:\"wp-content/themes/satellite/img/favicon.ico\";a:2:{s:1:\"d\";i:1382074209;s:1:\"h\";s:32:\"ffdd372c1a03ebaa13b04e6e526884af\";}s:41:\"wp-content/themes/satellite/functions.php\";a:2:{s:1:\"d\";i:1383803206;s:1:\"h\";s:32:\"8aca3309981cb0cd3694d703c3e3bb61\";}s:48:\"wp-content/themes/satellite/blog-small-image.php\";a:2:{s:1:\"d\";i:1383051440;s:1:\"h\";s:32:\"dc2d45ae185e383091645af7e978c53f\";}s:46:\"wp-content/themes/satellite/css/stylesheet.css\";a:2:{s:1:\"d\";i:1382074999;s:1:\"h\";s:32:\"9a53b568a822cf7b3b16a5032fc95752\";}s:73:\"wp-content/themes/satellite/css/font-awesome/font/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1382074502;s:1:\"h\";s:32:\"8cca2f02b0af2da365ff4d1755f29146\";}s:65:\"wp-content/themes/satellite/css/font-awesome/font/FontAwesome.otf\";a:2:{s:1:\"d\";i:1382074510;s:1:\"h\";s:32:\"8daab3c4f8252e0c3a3069ac0913b4a4\";}s:74:\"wp-content/themes/satellite/css/font-awesome/font/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1382074506;s:1:\"h\";s:32:\"b683029bafe0305ac2234038a03e1541\";}s:73:\"wp-content/themes/satellite/css/font-awesome/font/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1382074497;s:1:\"h\";s:32:\"f99a231ed57ee113b50b1c3e9f9fcdc3\";}s:73:\"wp-content/themes/satellite/css/font-awesome/font/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1382074488;s:1:\"h\";s:32:\"5ae23ad29b67289a1375d2043e289c52\";}s:69:\"wp-content/themes/satellite/css/font-awesome/css/font-awesome-ie7.css\";a:2:{s:1:\"d\";i:1382074471;s:1:\"h\";s:32:\"2984ce7c2ee292a2a6ef882ca55c4264\";}s:69:\"wp-content/themes/satellite/css/font-awesome/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1382074481;s:1:\"h\";s:32:\"7fbe76cdac6093784895bb4989203e5a\";}s:65:\"wp-content/themes/satellite/css/font-awesome/css/font-awesome.css\";a:2:{s:1:\"d\";i:1382074478;s:1:\"h\";s:32:\"192636ca135bd99a933dfe3ab57cc854\";}s:73:\"wp-content/themes/satellite/css/font-awesome/css/font-awesome-ie7.min.css\";a:2:{s:1:\"d\";i:1382074475;s:1:\"h\";s:32:\"4efc20143a3957f447ceeaa53695ceb6\";}s:58:\"wp-content/themes/satellite/css/woocommerce_responsive.css\";a:2:{s:1:\"d\";i:1382075011;s:1:\"h\";s:32:\"d716803fc2b6a0a60b190efec0f85d7c\";}s:53:\"wp-content/themes/satellite/css/admin/colorpicker.css\";a:2:{s:1:\"d\";i:1382074346;s:1:\"h\";s:32:\"6681d6d76b41daa8baf901c0f944207d\";}s:54:\"wp-content/themes/satellite/css/admin/qode_sidebar.css\";a:2:{s:1:\"d\";i:1382074462;s:1:\"h\";s:32:\"ea6e34fdb0906bc946d96f36fe9e6efb\";}s:66:\"wp-content/themes/satellite/css/admin/images/colorpicker_indic.gif\";a:2:{s:1:\"d\";i:1382074376;s:1:\"h\";s:32:\"f485d07540a89502e36dc1a55cec05d0\";}s:54:\"wp-content/themes/satellite/css/admin/images/blank.gif\";a:2:{s:1:\"d\";i:1382074353;s:1:\"h\";s:32:\"d60a1cb0e1e9b9a8abc64214bb749a55\";}s:61:\"wp-content/themes/satellite/css/admin/images/custom_indic.gif\";a:2:{s:1:\"d\";i:1382074408;s:1:\"h\";s:32:\"04660eb352eb259581a36a0fe8da2d4d\";}s:67:\"wp-content/themes/satellite/css/admin/images/colorpicker_select.gif\";a:2:{s:1:\"d\";i:1382074390;s:1:\"h\";s:32:\"cec464162af0cce10348e7bb7701ef86\";}s:53:\"wp-content/themes/satellite/css/admin/admin-style.css\";a:2:{s:1:\"d\";i:1382074339;s:1:\"h\";s:32:\"0a177b973503e20f5584c7aef2ae2edb\";}s:50:\"wp-content/themes/satellite/css/stylesheet.min.css\";a:2:{s:1:\"d\";i:1383553478;s:1:\"h\";s:32:\"49f2231f8b3891a4786bc5b3a3252c67\";}s:47:\"wp-content/themes/satellite/css/woocommerce.css\";a:2:{s:1:\"d\";i:1382075018;s:1:\"h\";s:32:\"a98492e910431a37a3e6ccc76bef94fc\";}s:43:\"wp-content/themes/satellite/css/toolbar.css\";a:2:{s:1:\"d\";i:1382075009;s:1:\"h\";s:32:\"ae0cf2c0533505d19569c925a18325b3\";}s:49:\"wp-content/themes/satellite/css/style_dynamic.php\";a:2:{s:1:\"d\";i:1382074989;s:1:\"h\";s:32:\"088b31ce7a9388cad7acd98606e1d5e8\";}s:51:\"wp-content/themes/satellite/css/woocommerce.min.css\";a:2:{s:1:\"d\";i:1382075021;s:1:\"h\";s:32:\"46b6397273e7023c3cd4045bb25011a6\";}s:50:\"wp-content/themes/satellite/css/responsive.min.css\";a:2:{s:1:\"d\";i:1382074982;s:1:\"h\";s:32:\"813ba1c5fd2031bb2b3b0e2f5d85ce21\";}s:46:\"wp-content/themes/satellite/css/custom_css.php\";a:2:{s:1:\"d\";i:1382074464;s:1:\"h\";s:32:\"b9f1bc56fb1028a48ef3200112571bcc\";}s:62:\"wp-content/themes/satellite/css/woocommerce_responsive.min.css\";a:2:{s:1:\"d\";i:1382075014;s:1:\"h\";s:32:\"8d84165b6601d1b7b1c0708b2e0920af\";}s:46:\"wp-content/themes/satellite/css/responsive.css\";a:2:{s:1:\"d\";i:1382074980;s:1:\"h\";s:32:\"ca25fd5b6e0c1febfff6e6e36fd767a6\";}s:66:\"wp-content/themes/satellite/css/img/prettyPhoto/default/loader.gif\";a:2:{s:1:\"d\";i:1382074823;s:1:\"h\";s:32:\"8393c5f7e394698f751ee6a11fff3dc7\";}s:58:\"wp-content/themes/satellite/css/img/prettyPhoto/loader.gif\";a:2:{s:1:\"d\";i:1382074839;s:1:\"h\";s:32:\"8393c5f7e394698f751ee6a11fff3dc7\";}s:55:\"wp-content/themes/satellite/css/img/select2-spinner.gif\";a:2:{s:1:\"d\";i:1382074893;s:1:\"h\";s:32:\"7b9776076d5fceef4993b55c9383dedd\";}s:54:\"wp-content/themes/satellite/css/img/audio/controls.svg\";a:2:{s:1:\"d\";i:1382074529;s:1:\"h\";s:32:\"40f56f5a736da4effeb790cedb8a52f0\";}s:60:\"wp-content/themes/satellite/css/style_dynamic_responsive.php\";a:2:{s:1:\"d\";i:1382074985;s:1:\"h\";s:32:\"e93d1d1e6abe61fa8dc78daafd7925e2\";}s:38:\"wp-content/themes/satellite/footer.php\";a:2:{s:1:\"d\";i:1422537477;s:1:\"h\";s:32:\"e7452bd8145342a77b0dd85bfe563eef\";}s:40:\"wp-content/themes/satellite/comments.php\";a:2:{s:1:\"d\";i:1382074357;s:1:\"h\";s:32:\"8d230d30f17501280b320cde540bbbd2\";}s:39:\"wp-content/themes/satellite/sidebar.php\";a:2:{s:1:\"d\";i:1382074378;s:1:\"h\";s:32:\"6ccf323bf6f79894084678bd7f139efc\";}s:52:\"wp-content/themes/satellite/blog_full_image-loop.php\";a:2:{s:1:\"d\";i:1382074324;s:1:\"h\";s:32:\"2f061a4590d5d986e86dfef1b974aab3\";}s:27:\"wp-content/themes/index.php\";a:2:{s:1:\"d\";i:1239843424;s:1:\"h\";s:32:\"96137494913a1f730a592e8932af394e\";}s:36:\"wp-content/uploads/rc_geositemap.xml\";a:2:{s:1:\"d\";i:1382482050;s:1:\"h\";s:32:\"efc351056f5415274d0808adeed1e1f1\";}s:71:\"wp-content/uploads/2014/08/battery-garden-wedding-photos-01-300x218.gif\";a:2:{s:1:\"d\";i:1407813828;s:1:\"h\";s:32:\"edd7c136bd574d11eb58c74705711ddb\";}s:71:\"wp-content/uploads/2014/08/battery-garden-wedding-photos-01-540x300.gif\";a:2:{s:1:\"d\";i:1407813828;s:1:\"h\";s:32:\"6bb8b8caded0e9c4de71feebfedd8227\";}s:71:\"wp-content/uploads/2014/08/battery-garden-wedding-photos-01-150x150.gif\";a:2:{s:1:\"d\";i:1407813828;s:1:\"h\";s:32:\"745c4a45bac2104115c320ce59c768be\";}s:71:\"wp-content/uploads/2014/08/battery-garden-wedding-photos-01-240x135.gif\";a:2:{s:1:\"d\";i:1407813828;s:1:\"h\";s:32:\"1e9be131e4f029feca11c2ae1447b6cc\";}s:71:\"wp-content/uploads/2014/08/battery-garden-wedding-photos-01-540x540.gif\";a:2:{s:1:\"d\";i:1407813828;s:1:\"h\";s:32:\"a3c5b34c131618c8a335af06f1671f24\";}s:96:\"wp-content/uploads/ithemes-security/backups/backup-nyc-wedding-photogra-1407962890-jNhAGbEnf.zip\";a:2:{s:1:\"d\";i:1407977299;s:1:\"h\";s:32:\"098898c04f2f76d8813ba699d88a0a6e\";}s:96:\"wp-content/uploads/ithemes-security/backups/backup-nyc-wedding-photogra-1408222871-ek1V2Mx4b.zip\";a:2:{s:1:\"d\";i:1408237280;s:1:\"h\";s:32:\"54a09b0acf9f221376c77228c49078e0\";}s:96:\"wp-content/uploads/ithemes-security/backups/backup-nyc-wedding-photogra-1407962890-jNhAGbEnf.sql\";a:2:{s:1:\"d\";i:1407977297;s:1:\"h\";s:32:\"02bf9477d2edcdcd02f61fd422059f8a\";}s:96:\"wp-content/uploads/ithemes-security/backups/backup-nyc-wedding-photogra-1408222871-ek1V2Mx4b.sql\";a:2:{s:1:\"d\";i:1408237279;s:1:\"h\";s:32:\"a2f090fcc8b2336c02c29bca6af0b890\";}s:53:\"wp-content/uploads/ithemes-security/backups/.htaccess\";a:2:{s:1:\"d\";i:1405643005;s:1:\"h\";s:32:\"209634bb0238704c4874c35d615ae59e\";}s:52:\"wp-content/uploads/ithemes-security/itsec_away.confg\";a:2:{s:1:\"d\";i:1405643274;s:1:\"h\";s:32:\"b326b5062b2f0e69046810717534cb09\";}s:45:\"wp-content/uploads/ithemes-security/.htaccess\";a:2:{s:1:\"d\";i:1405643005;s:1:\"h\";s:32:\"209634bb0238704c4874c35d615ae59e\";}s:50:\"wp-content/uploads/ithemes-security/logs/.htaccess\";a:2:{s:1:\"d\";i:1405643005;s:1:\"h\";s:32:\"209634bb0238704c4874c35d615ae59e\";}s:23:\"wp-content/uploads/.vcf\";a:2:{s:1:\"d\";i:1382482050;s:1:\"h\";s:32:\"5fcd865203e6945e0d6280ade83f0719\";}s:23:\"wp-content/uploads/.kml\";a:2:{s:1:\"d\";i:1382482050;s:1:\"h\";s:32:\"1a4e765a5298afe566429606faf5e76e\";}s:16:\"wp-trackback.php\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"8fecf12e8ea164ba98d8236b0fb56c0b\";}s:20:\"wp-config-sample.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a20860141582d318f1d4c612fbfcabc7\";}s:12:\"wp-login.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"73d6b30645505ef713993ddabef349fa\";}s:15:\"wp-settings.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b71937336a917678a25a66f0ff750131\";}s:11:\"wp-load.php\";a:2:{s:1:\"d\";i:1430392225;s:1:\"h\";s:32:\"21ca69e84195c73e27a091d0c0d0b6a6\";}s:20:\"wp-comments-post.php\";a:2:{s:1:\"d\";i:1430392225;s:1:\"h\";s:32:\"91c0d3c3f1d0a5f06ca9b225f966e6a7\";}s:11:\"wp-cron.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f28242f5766d6525b949f376813236d3\";}s:38:\"wp-includes/class-wp-ajax-response.php\";a:2:{s:1:\"d\";i:1430392225;s:1:\"h\";s:32:\"723660307dc0646dc48251f6a8b05cc6\";}s:28:\"wp-includes/class-snoopy.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"dccbd26d4d7ae80f4d1472923b769e96\";}s:19:\"wp-includes/rss.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f3b9280e8ca919f20d1e4e96ee5a4813\";}s:20:\"wp-includes/http.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"87c1f1028fe11974dade7c5e81e4f941\";}s:28:\"wp-includes/ms-functions.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0d03a037fb58286dc3264324f2b700d6\";}s:34:\"wp-includes/feed-atom-comments.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"640325b054336bc1dc0ea50975bbdcdb\";}s:20:\"wp-includes/date.php\";a:2:{s:1:\"d\";i:1430392225;s:1:\"h\";s:32:\"90759815031baee38d3c9f19e34f4907\";}s:26:\"wp-includes/class-pop3.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0f16fbc95d57b7e73f51f08f399966fe\";}s:31:\"wp-includes/class-wp-editor.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ee6c66b9a58eb45407e81d7fe17cb0a5\";}s:29:\"wp-includes/script-loader.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d739c8af6eb1895e358f945cec81be3f\";}s:20:\"wp-includes/load.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e0a59aeb8d516829de111865ef440435\";}s:29:\"wp-includes/link-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1c57b921223f94eab7d75a0152d1fb86\";}s:26:\"wp-includes/formatting.php\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"5311094f43c7252b22c71fd4dee43f03\";}s:40:\"wp-includes/class-wp-customize-panel.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"496347d72cb3707d87af65b2b9e1e29e\";}s:36:\"wp-includes/js/customize-base.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"2eac88d29658e3be60fb3502410e1d18\";}s:31:\"wp-includes/js/heartbeat.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1a30d2f3f43f2e3fb867298e53cad1a1\";}s:35:\"wp-includes/js/wp-auth-check.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"4584099c38e5ed5f6f44644a79b6e473\";}s:23:\"wp-includes/js/utils.js\";a:2:{s:1:\"d\";i:1417657004;s:1:\"h\";s:32:\"01b7f89601bfa36ffee09f056f2cc38a\";}s:29:\"wp-includes/js/wp-util.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d099d4d6b145900b334fc3215ff55791\";}s:27:\"wp-includes/js/swfobject.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"9ffdba2cff497d701684657e329871f5\";}s:55:\"wp-includes/js/mediaelement/silverlightmediaelement.xap\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"a83ab83a3d43222e4ba77cf96e0074aa\";}s:49:\"wp-includes/js/mediaelement/flashmediaelement.swf\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"2400c991b8473d44a7edc75605496760\";}s:40:\"wp-includes/js/mediaelement/controls.svg\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"40f56f5a736da4effeb790cedb8a52f0\";}s:47:\"wp-includes/js/mediaelement/wp-mediaelement.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b386228e88380ff75bcf293d432db6a4\";}s:45:\"wp-includes/js/mediaelement/froogaloop.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"2a8742c0ac1cdbec23be44a7d4e9a3c9\";}s:39:\"wp-includes/js/mediaelement/loading.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"76b326f4d44222126fee21076595bef5\";}s:39:\"wp-includes/js/mediaelement/bigplay.svg\";a:2:{s:1:\"d\";i:1417657004;s:1:\"h\";s:32:\"ea090d716dd05e4024c29283f3c88d0d\";}s:42:\"wp-includes/js/mediaelement/wp-playlist.js\";a:2:{s:1:\"d\";i:1417657004;s:1:\"h\";s:32:\"0ec99859384076f01ce50727d9bf18b3\";}s:54:\"wp-includes/js/mediaelement/mediaelementplayer.min.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"2ca8d8977881d5e608aa01c45bac7dce\";}s:46:\"wp-includes/js/mediaelement/wp-mediaelement.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"9f38d89f0e227bebd5ba84ac75e10f5a\";}s:58:\"wp-includes/js/mediaelement/mediaelement-and-player.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1abc152ca7ae762a29ac997bc779a187\";}s:34:\"wp-includes/js/media-models.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bc01c1de1fdb0176783247e8a754a60b\";}s:30:\"wp-includes/js/mce-view.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"42c639526ec5b00732f0fb2e7b0d6a53\";}s:25:\"wp-includes/js/wp-util.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"705199da293ca7cfc6e98ea0b52774cb\";}s:27:\"wp-includes/js/heartbeat.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"25e9e78d00555f2e724456104eff7af0\";}s:25:\"wp-includes/js/twemoji.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c5e2468d0609ca34092c9d68466332ba\";}s:34:\"wp-includes/js/customize-models.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3a799b747d1cc99f440ec4630a32e040\";}s:30:\"wp-includes/js/media-editor.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"20f9f27717e6b1fd22576cdffba06336\";}s:25:\"wp-includes/js/wp-a11y.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"807223bbf40755fb69e7a55413c63a4d\";}s:39:\"wp-includes/js/wp-list-revisions.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"b4031fcf4f4279be864d4bd82f7fc46c\";}s:35:\"wp-includes/js/wp-list-revisions.js\";a:2:{s:1:\"d\";i:1386979565;s:1:\"h\";s:32:\"47510d7560d22a974c8c0eec6e24bcbd\";}s:30:\"wp-includes/js/autosave.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"2eec8f2c408c881c6715ce0f682f3707\";}s:33:\"wp-includes/js/wp-emoji-loader.js\";a:2:{s:1:\"d\";i:1430966072;s:1:\"h\";s:32:\"d4a819f73ff1a4574a969c9e46d6f117\";}s:30:\"wp-includes/js/backbone.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"88fee57a12be8ea719ed85fe29f062d3\";}s:30:\"wp-includes/js/zxcvbn-async.js\";a:2:{s:1:\"d\";i:1386979565;s:1:\"h\";s:32:\"97a79e96a815b200139356055d752333\";}s:43:\"wp-includes/js/customize-preview-widgets.js\";a:2:{s:1:\"d\";i:1417657004;s:1:\"h\";s:32:\"a01ebc7a7becb4597d71d379bcdab4be\";}s:27:\"wp-includes/js/quicktags.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"213aa843be923e9b3cd4e8231551d01d\";}s:34:\"wp-includes/js/media-editor.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"725a37e46661f84f85a5602e6cc33d02\";}s:45:\"wp-includes/js/customize-preview-nav-menus.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"272fac6db6ba470a966e5e363fff1335\";}s:28:\"wp-includes/js/media-grid.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1e05c8c75113e18fb3626f7ddbe07cbd\";}s:36:\"wp-includes/js/crop/marqueeHoriz.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"8cccae9c1ebafdb83be602e4d44c6f0a\";}s:30:\"wp-includes/js/crop/cropper.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"1d97b296d918482e1273c56fbff6a8e2\";}s:35:\"wp-includes/js/crop/marqueeVert.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"ae9accf100a4b9930639adff52d4dcc7\";}s:31:\"wp-includes/js/crop/cropper.css\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"6b79350bf46e0f692a4d1b2807ed0399\";}s:34:\"wp-includes/js/customize-loader.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"2130932604d2718d1e9d11e800ab7e93\";}s:37:\"wp-includes/js/swfupload/swfupload.js\";a:2:{s:1:\"d\";i:1417657004;s:1:\"h\";s:32:\"ef3ae9014525cf81187afaa61bca737e\";}s:51:\"wp-includes/js/swfupload/plugins/swfupload.speed.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"415a3787846bb6c2d745602c2afb73ac\";}s:51:\"wp-includes/js/swfupload/plugins/swfupload.queue.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"9953522fbd4a1b02bbf635a92d76cd8f\";}s:53:\"wp-includes/js/swfupload/plugins/swfupload.cookies.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"7fa57ec00dda88dd6b5c2037ccb4d5cf\";}s:55:\"wp-includes/js/swfupload/plugins/swfupload.swfobject.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"ccb51571a75637db08545caaf2ed9e73\";}s:38:\"wp-includes/js/swfupload/swfupload.swf\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"bd5a25f23589652ca472d41fe1484f0c\";}s:36:\"wp-includes/js/swfupload/license.txt\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"cbe05bb060c85e07882dc06ff751577a\";}s:40:\"wp-includes/js/swfupload/handlers.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"96592c6b3fad580ce04e12bc3047ef3b\";}s:36:\"wp-includes/js/swfupload/handlers.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"14b2d04fdb85bc1f171cf3dfb2987dca\";}s:29:\"wp-includes/js/hoverIntent.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"cab3598b438a9e63984f1c6e9dd79b01\";}s:38:\"wp-includes/js/wp-emoji-release.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1c64b125732c6fe54928ee058ea72595\";}s:29:\"wp-includes/js/twemoji.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9cfd48e37348e36a3caa072318531b08\";}s:32:\"wp-includes/js/media-grid.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d01d7c54b7f1e87d1b3c9e7d9cd8589c\";}s:34:\"wp-includes/js/zxcvbn-async.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"3196e9b61f703909e139ce7e049a7ffd\";}s:29:\"wp-includes/js/wp-a11y.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"860cbbecce6b0a5fcbb0c0faa956011a\";}s:24:\"wp-includes/js/wplink.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bb9a4f6e9e3f4f0578a8216e47621127\";}s:49:\"wp-includes/js/customize-preview-nav-menus.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"696de30f3cf4547a2aaa8fe0e952b6d1\";}s:29:\"wp-includes/js/colorpicker.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"f01017ca562067f4840eb2b6f99f2daf\";}s:31:\"wp-includes/js/admin-bar.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5bd4dfd347e0592a6bc8a5b9d6b070fc\";}s:31:\"wp-includes/js/wp-auth-check.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"a28190f5ed5d6bfa0702e414b65a2156\";}s:38:\"wp-includes/js/customize-loader.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"920192c0f83cb413dcbd4c2d8907496d\";}s:26:\"wp-includes/js/wp-emoji.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"504d2cee82879a8d64df784d9f2e9928\";}s:29:\"wp-includes/js/masonry.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"69717d4569676f401e97dcec54f10ebc\";}s:35:\"wp-includes/js/comment-reply.min.js\";a:2:{s:1:\"d\";i:1386979566;s:1:\"h\";s:32:\"1b1e9d1d12fcc51a151e7e0688bc695f\";}s:31:\"wp-includes/js/comment-reply.js\";a:2:{s:1:\"d\";i:1386979566;s:1:\"h\";s:32:\"d30ad028653d4eac285a1d4d06567bbd\";}s:32:\"wp-includes/js/customize-base.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"5dca30a4679d1aedaacebd16a4a1a0ff\";}s:46:\"wp-includes/js/imgareaselect/imgareaselect.css\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"7d28cad92829b3d633a087b5f3b595af\";}s:52:\"wp-includes/js/imgareaselect/jquery.imgareaselect.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7a0e1bfc429252530cfb8318f53a5986\";}s:46:\"wp-includes/js/imgareaselect/border-anim-v.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"20c97a21993cf137ead9fdbecbc42aa8\";}s:46:\"wp-includes/js/imgareaselect/border-anim-h.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"5ac3c42cc86e745a5e36b67b4c70a134\";}s:56:\"wp-includes/js/imgareaselect/jquery.imgareaselect.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"25f42e049e65ee16d442799755724025\";}s:28:\"wp-includes/js/wplink.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5318022592bd8ec613a3ec32e68d47e9\";}s:31:\"wp-includes/js/jquery/jquery.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"207abeb83412721d556faeba36e00822\";}s:43:\"wp-includes/js/jquery/jquery-migrate.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"512b871a2830e44259bc3ce3343afcd0\";}s:46:\"wp-includes/js/jquery/jquery.ui.touch-punch.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"4cc86d1003c45134d6838f13e3885db1\";}s:43:\"wp-includes/js/jquery/jquery.hotkeys.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"e353217d4555ab5c62b367be6889813d\";}s:41:\"wp-includes/js/jquery/jquery.color.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"ff2db8dbf145ce47f31781eef33e764a\";}s:49:\"wp-includes/js/jquery/jquery.table-hotkeys.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"e56f81676f199db7bf937e69a64909fa\";}s:40:\"wp-includes/js/jquery/jquery.schedule.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"0426b39754aa6bc766d89ea4c41bbd06\";}s:45:\"wp-includes/js/jquery/jquery.table-hotkeys.js\";a:2:{s:1:\"d\";i:1386979566;s:1:\"h\";s:32:\"a706ead694231e74fd6750b1670580a5\";}s:36:\"wp-includes/js/jquery/suggest.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"21a79ede04fa5ee9017e6bdbdba5bfe9\";}s:32:\"wp-includes/js/jquery/suggest.js\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"bf55f3b46b05aa372a0bed97b848de9e\";}s:36:\"wp-includes/js/jquery/jquery.form.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"e5afd8e41d2ec22c19932b068cd90a71\";}s:48:\"wp-includes/js/jquery/jquery.serialize-object.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"d15c29a18d9ffa8b9b4ae86c3c0cfa22\";}s:37:\"wp-includes/js/jquery/jquery.query.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"3bcc587af2c7b01fc6fbc9c077050143\";}s:43:\"wp-includes/js/jquery/ui/effect-size.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"3a14499e6b9543cd2a85be995dab077f\";}s:46:\"wp-includes/js/jquery/ui/effect-explode.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"605955a2ff9bbd517d58d90651f730d8\";}s:43:\"wp-includes/js/jquery/ui/progressbar.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"a5e9438e7bac8acb9a71ccf4741009cd\";}s:45:\"wp-includes/js/jquery/ui/effect-bounce.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d8967fe0305451de35920fd4fbe18d53\";}s:41:\"wp-includes/js/jquery/ui/accordion.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"617307799c0ec636db3df228d57790da\";}s:43:\"wp-includes/js/jquery/ui/effect-drop.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"57fe560887cac7a5b2598188463290e8\";}s:44:\"wp-includes/js/jquery/ui/autocomplete.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"87848b50d8b543b6fe1a38a97a6aea5c\";}s:44:\"wp-includes/js/jquery/ui/effect-slide.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"fa23475fb01c8f4d56da98ca0c1179b5\";}s:40:\"wp-includes/js/jquery/ui/sortable.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"0ed316ce58771b0297b783130e6b5e94\";}s:43:\"wp-includes/js/jquery/ui/effect-fade.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"9f6fd64f4f5ff5893b7b72a235246d0c\";}s:42:\"wp-includes/js/jquery/ui/datepicker.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"82e28aae0e34a07a0b13ce604d021b14\";}s:44:\"wp-includes/js/jquery/ui/effect-shake.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"a0274a6716560eeaccaf0090400f7095\";}s:43:\"wp-includes/js/jquery/ui/effect-clip.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"c7939457e8ab231b951713475a056173\";}s:36:\"wp-includes/js/jquery/ui/tabs.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4572c6f0dae66c956ef9774756800b92\";}s:42:\"wp-includes/js/jquery/ui/selectmenu.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"cb7db4cbaa328e395a680c78692236f0\";}s:41:\"wp-includes/js/jquery/ui/draggable.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"500b56f16499ad4010c6cb1159a00ef7\";}s:39:\"wp-includes/js/jquery/ui/spinner.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"b2d7a9df2f6b0f264851faf33b6ac7d6\";}s:38:\"wp-includes/js/jquery/ui/slider.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"7d09316c34df2686e1515795ef0f4cc8\";}s:43:\"wp-includes/js/jquery/ui/effect-puff.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"fe496d6c9d63bc47854084c8b3fc20d6\";}s:42:\"wp-includes/js/jquery/ui/selectable.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"51f19c22fb1d7b1bbf428b4de4f01fce\";}s:39:\"wp-includes/js/jquery/ui/tooltip.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"b75d47d283918bef01b8cdcc4045511e\";}s:44:\"wp-includes/js/jquery/ui/effect-blind.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"addbe09f173c4f1bd86d41ac5f3b4f4c\";}s:36:\"wp-includes/js/jquery/ui/core.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"204d1573e5f9ad0d0c9b61bdffe4a37b\";}s:40:\"wp-includes/js/jquery/ui/position.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9396d719a4eadde27896ce30327a3a89\";}s:37:\"wp-includes/js/jquery/ui/mouse.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"e4a138275da8ed21bf8e49d9b210b884\";}s:38:\"wp-includes/js/jquery/ui/effect.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"1441d6a28c1e7069c1e21b757f2b6082\";}s:41:\"wp-includes/js/jquery/ui/droppable.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"1a4b2271fd48cc6494bc94967e41b150\";}s:38:\"wp-includes/js/jquery/ui/button.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6e0e045d3fe4766ba1cd3ae5830f5307\";}s:38:\"wp-includes/js/jquery/ui/widget.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0bb0af0869341cca0236ba99d4ea092f\";}s:36:\"wp-includes/js/jquery/ui/menu.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"279b59ffd3e6ed2da1397cb06ce13ec0\";}s:38:\"wp-includes/js/jquery/ui/dialog.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"24036156f5137bd484089907f52c9530\";}s:44:\"wp-includes/js/jquery/ui/effect-scale.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d57d0830652c29c3e0e301b02b6db754\";}s:48:\"wp-includes/js/jquery/ui/effect-highlight.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"95e8ebe62adf187fb4c3b84eb5bef821\";}s:41:\"wp-includes/js/jquery/ui/resizable.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"3f04b22aeae2579369c558e39db6d5bf\";}s:46:\"wp-includes/js/jquery/ui/effect-pulsate.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d31b2660850bd11ed7f4118ee166f1e9\";}s:47:\"wp-includes/js/jquery/ui/effect-transfer.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"07e5b0dea800777dd2108788b56ef90b\";}s:43:\"wp-includes/js/jquery/ui/effect-fold.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"8d365ec1b3a7ee82f93c9afd441e456c\";}s:40:\"wp-includes/js/jquery/jquery.form.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"dbc3808473def00fce45fe564dc72dcb\";}s:39:\"wp-includes/js/jquery/jquery-migrate.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"90e237d5f01035b958feaf514ef27f7a\";}s:43:\"wp-includes/js/jquery/jquery.masonry.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"928adcedcd52b828e51f9ec291655e01\";}s:39:\"wp-includes/js/jquery/jquery.hotkeys.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"e29483a8ca26a0dd8b0d1146c6b0a6e9\";}s:29:\"wp-includes/js/media-views.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3a7456ca374af47b36df25b8db73a9b6\";}s:30:\"wp-includes/js/wp-emoji.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f58df83b99c2e5bf0c6fe5f6313450f0\";}s:30:\"wp-includes/js/media-models.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"98fa336128f3c0da0271f568a0cc05d3\";}s:27:\"wp-includes/js/utils.min.js\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"41fa39bcefcede21b93beb099cfa78d7\";}s:28:\"wp-includes/js/wp-pointer.js\";a:2:{s:1:\"d\";i:1386979566;s:1:\"h\";s:32:\"35cb8b380bbd1f2eaa723ac49ba5f3f0\";}s:26:\"wp-includes/js/autosave.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"63fd697c7d66f00cefc6430b8c53c92f\";}s:38:\"wp-includes/js/customize-models.min.js\";a:2:{s:1:\"d\";i:1399589300;s:1:\"h\";s:32:\"4f4b04852e86713b9f7490e74ee8820a\";}s:34:\"wp-includes/js/wp-ajax-response.js\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"4eee92d2ee86812037ed3afbcab3bf9a\";}s:28:\"wp-includes/js/zxcvbn.min.js\";a:2:{s:1:\"d\";i:1386979566;s:1:\"h\";s:32:\"a14cd5113bd0d57563c1a9b63cae05f8\";}s:33:\"wp-includes/js/hoverIntent.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"ca500ade854c31417faf5762e31b9d00\";}s:33:\"wp-includes/js/customize-views.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fab2f195182995d82502a8ab7f0c79d9\";}s:41:\"wp-includes/js/jcrop/jquery.Jcrop.min.css\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"56cc9ea201dc2f4b910e78bfacac9211\";}s:40:\"wp-includes/js/jcrop/jquery.Jcrop.min.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"2f61ab984c177275c71e34ff1a17c102\";}s:30:\"wp-includes/js/jcrop/Jcrop.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"5a8bfd37651305bdafbcf2cd51b0254b\";}s:36:\"wp-includes/js/thickbox/thickbox.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"255290108a1c6a8ad31f6fa1415978a7\";}s:35:\"wp-includes/js/thickbox/thickbox.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"20baaf5da31ddd92caab7962d15c0ac3\";}s:44:\"wp-includes/js/thickbox/loadingAnimation.gif\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"ce2268030dd2151b63cdf4ffc2f626ba\";}s:27:\"wp-includes/js/json2.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"34a938334208cacfd97631b04283ddd9\";}s:30:\"wp-includes/js/wpdialog.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"d22d9fa5bb00ba0667080da846c4a1be\";}s:37:\"wp-includes/js/customize-views.min.js\";a:2:{s:1:\"d\";i:1399589300;s:1:\"h\";s:32:\"05b8ea5fb11adb182563ddb989e091d1\";}s:33:\"wp-includes/js/media-views.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7c56e29067eccb592238ea9e0650bed4\";}s:23:\"wp-includes/js/json2.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"74d903049683e5bbea9ccb7544a42bca\";}s:26:\"wp-includes/js/mce-view.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5d93951714ec40da1cd2defc66fb4ce0\";}s:27:\"wp-includes/js/shortcode.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"eb207a02d03e3196d9d14ad139327fb5\";}s:33:\"wp-includes/js/wp-backbone.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"b569e29ff8fd482e0ee75e1494085621\";}s:30:\"wp-includes/js/wp-lists.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"8802453513507186e7cff5316d83bc1e\";}s:33:\"wp-includes/js/colorpicker.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"58ab2fba61b092b0f4efe8aaa3b2864e\";}s:34:\"wp-includes/js/media-audiovideo.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"17236090dcb388dd84b091ae7e373ae4\";}s:39:\"wp-includes/js/customize-preview.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"b8e325486884be9894b081ebac0d54ad\";}s:32:\"wp-includes/js/wp-pointer.min.js\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"368f987c644d70580097e48066c99082\";}s:31:\"wp-includes/js/quicktags.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fa5d97a49168b7454a06fa0e195fce4d\";}s:29:\"wp-includes/js/wp-backbone.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"fdaba653baf259db7cb3d7a4d76a2970\";}s:53:\"wp-includes/js/tinymce/skins/wordpress/wp-content.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f1aacaf6e127e33987f04a8304d4764d\";}s:54:\"wp-includes/js/tinymce/skins/lightgray/content.min.css\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"b7c6c39dbee52e316139d6f41ec805ca\";}s:55:\"wp-includes/js/tinymce/skins/lightgray/skin.ie7.min.css\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"cea6608407da4b0d07f4bdad387059c2\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.eot\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"e33420c71c1a5c429069874d1de98a8b\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.svg\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"006a3d1ce8aad3f9d3d6a9c3f6129a36\";}s:57:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.woff\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5acd099f84c92a932b0e2897f49be665\";}s:54:\"wp-includes/js/tinymce/skins/lightgray/fonts/readme.md\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"7a0f64800cf38b2be8d3dc4540ec31dd\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.svg\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"473611093dd8089b0ed33c199725a723\";}s:63:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.woff\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d725b287d3d6816c20520a31924fde17\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.ttf\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"20eaff7be8a4f2cde874a39a898155c4\";}s:62:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce-small.ttf\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"b86135446ecf06e0ac722d6d8f403550\";}s:56:\"wp-includes/js/tinymce/skins/lightgray/fonts/tinymce.eot\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a4e6a52223e2edbd1bc2b621ec7c08c3\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/anchor.gif\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"abd3613571800fdcc891181d5f34f840\";}s:52:\"wp-includes/js/tinymce/skins/lightgray/img/trans.gif\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"12bf9e19374920de3146a64775f46a5e\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/loader.gif\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"394bafc3cc4dfb3a0ee48c1f54669539\";}s:53:\"wp-includes/js/tinymce/skins/lightgray/img/object.gif\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"f3726450d7457d750a2f4d9441c7ee20\";}s:51:\"wp-includes/js/tinymce/skins/lightgray/skin.min.css\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"fa7377e0da20941e25af2944599e42db\";}s:61:\"wp-includes/js/tinymce/skins/lightgray/content.inline.min.css\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"35b20a1298ab637a58ac70fa73df335c\";}s:37:\"wp-includes/js/tinymce/tinymce.min.js\";a:2:{s:1:\"d\";i:1442331405;s:1:\"h\";s:32:\"8dbe59343ccc14e1c3be2204e4c68c6a\";}s:42:\"wp-includes/js/tinymce/utils/form_utils.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f9c61354383f5a50a9a77b902dfdae7f\";}s:38:\"wp-includes/js/tinymce/utils/mctabs.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b9b50ddbe07c754a6b656b0fdada3500\";}s:48:\"wp-includes/js/tinymce/utils/editable_selects.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"eb642a0aba7a8666a7b1472230fcb374\";}s:40:\"wp-includes/js/tinymce/utils/validate.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c42b5160bdbefd1293d76b30520757f4\";}s:46:\"wp-includes/js/tinymce/plugins/media/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"abba483f4f8fd4d1bb3883dfdbde63b9\";}s:50:\"wp-includes/js/tinymce/plugins/media/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"4c19cd169dac570c6d6675fa82a4f3e5\";}s:52:\"wp-includes/js/tinymce/plugins/media/moxieplayer.swf\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"4e59d34efb2da0b9a033596a85e4b1ef\";}s:47:\"wp-includes/js/tinymce/plugins/wplink/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"1cfe476c543e87f1bf2ad3ac091dc920\";}s:51:\"wp-includes/js/tinymce/plugins/wplink/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"30d7bde04e460530a72425ee649a16d5\";}s:52:\"wp-includes/js/tinymce/plugins/colorpicker/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"22538c49f524050bd8300b44526abc2a\";}s:56:\"wp-includes/js/tinymce/plugins/colorpicker/plugin.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"1581bb02286f54b4fb0cce52d2ef61c7\";}s:55:\"wp-includes/js/tinymce/plugins/directionality/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5f21385b1f4513568d611d595040d141\";}s:59:\"wp-includes/js/tinymce/plugins/directionality/plugin.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"60de57253ca9143a6f1e4aff10fc39d2\";}s:51:\"wp-includes/js/tinymce/plugins/fullscreen/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ed15397c76c49fb9518bdb1b912a55ef\";}s:55:\"wp-includes/js/tinymce/plugins/fullscreen/plugin.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d47998057f5f31758add87f462076fe2\";}s:46:\"wp-includes/js/tinymce/plugins/lists/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"a50a5f7469bc374bdf17a75c0cd4d98a\";}s:50:\"wp-includes/js/tinymce/plugins/lists/plugin.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"6bdcee3180998f7f8e13dc4917d8f9a9\";}s:43:\"wp-includes/js/tinymce/plugins/hr/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"428c9fb47a7b83fa0440a15886d0b11a\";}s:47:\"wp-includes/js/tinymce/plugins/hr/plugin.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"5c23255ad2d11db3f72c33b649f1389a\";}s:50:\"wp-includes/js/tinymce/plugins/wordpress/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e2622abed0990e5fa1c0a46ec9857c81\";}s:54:\"wp-includes/js/tinymce/plugins/wordpress/plugin.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6e47a30fdc90cb4b42de68acf864c71a\";}s:47:\"wp-includes/js/tinymce/plugins/wpview/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"381abc41a9cbc190de2ef74a2e393b06\";}s:51:\"wp-includes/js/tinymce/plugins/wpview/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"e608364cb27dcf58e94433c8c3f02518\";}s:48:\"wp-includes/js/tinymce/plugins/wpemoji/plugin.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"1d793200d7b3e0f80818903ca5721bc7\";}s:52:\"wp-includes/js/tinymce/plugins/wpemoji/plugin.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"7ceb852c73b74dc1b5f5f015be95506d\";}s:48:\"wp-includes/js/tinymce/plugins/charmap/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"a3a422577ac81c9ef6d7036869c30c7b\";}s:52:\"wp-includes/js/tinymce/plugins/charmap/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"218b586940473a3d64d408b22fa603ae\";}s:50:\"wp-includes/js/tinymce/plugins/wpdialogs/plugin.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"06f7aecb5bdfa28739eea0a498d15a81\";}s:54:\"wp-includes/js/tinymce/plugins/wpdialogs/plugin.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"eafbb1478981e337981d287474e240b8\";}s:52:\"wp-includes/js/tinymce/plugins/wpeditimage/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"1368498ecb829d4e2c9d74efd0dc522e\";}s:56:\"wp-includes/js/tinymce/plugins/wpeditimage/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"aa3dc74f38e3be71febb90a89d2166a8\";}s:49:\"wp-includes/js/tinymce/plugins/tabfocus/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0001917ebec06ecb3fbf863f38f4af52\";}s:53:\"wp-includes/js/tinymce/plugins/tabfocus/plugin.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"d810b096023695b38bf682f20774af98\";}s:53:\"wp-includes/js/tinymce/plugins/wpautoresize/plugin.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"640cbc0058638c4fb0400370dbcf25a3\";}s:57:\"wp-includes/js/tinymce/plugins/wpautoresize/plugin.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"564cd5d11909d4675327b6f71fa09269\";}s:50:\"wp-includes/js/tinymce/plugins/wpgallery/plugin.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"b10eadbf41e88b236ac764bd26e653f9\";}s:54:\"wp-includes/js/tinymce/plugins/wpgallery/plugin.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"b229462e6a542696fbf6bd4917c9074f\";}s:46:\"wp-includes/js/tinymce/plugins/paste/plugin.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"afc4c67509b5f5b52fd2b7556836b69c\";}s:50:\"wp-includes/js/tinymce/plugins/paste/plugin.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"d41da4c3b9d07e54055ad9ab13b9112b\";}s:50:\"wp-includes/js/tinymce/plugins/textcolor/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ff76dd12efde3c20a321d00058535b3f\";}s:54:\"wp-includes/js/tinymce/plugins/textcolor/plugin.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"a5ca0a92e1bdf1fbf3f9a07db5573092\";}s:49:\"wp-includes/js/tinymce/plugins/compat3x/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"790e3c426331bcdfbb33c636090b6194\";}s:53:\"wp-includes/js/tinymce/plugins/compat3x/plugin.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"5798e3d2fb0180a9179b8bd7cf728eae\";}s:54:\"wp-includes/js/tinymce/plugins/compat3x/css/dialog.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"96b3a37270049ad482e5e0b14b2bff89\";}s:46:\"wp-includes/js/tinymce/plugins/image/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e60f8eb665759cface17e2662e085ecd\";}s:50:\"wp-includes/js/tinymce/plugins/image/plugin.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e0503423284ee602ddafaeb8dd074147\";}s:54:\"wp-includes/js/tinymce/plugins/wptextpattern/plugin.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d4d46a49f3589ec1c136ab912a2da7ca\";}s:58:\"wp-includes/js/tinymce/plugins/wptextpattern/plugin.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"8291a8caa3672971dc61b332ecc437c3\";}s:39:\"wp-includes/js/tinymce/wp-tinymce.js.gz\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"ef12d9d3ef6c25d448e428619e49b730\";}s:37:\"wp-includes/js/tinymce/wp-tinymce.php\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"8a620ab81dc7307f7072b1d312924876\";}s:43:\"wp-includes/js/tinymce/langs/wp-langs-en.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"08f8669f7453b17563a62e6bbb376137\";}s:34:\"wp-includes/js/tinymce/license.txt\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"045d04e17422d99e338da75b9c749b7c\";}s:45:\"wp-includes/js/tinymce/themes/modern/theme.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"7b4a867a84575f7d26a9377b1eae7cbf\";}s:49:\"wp-includes/js/tinymce/themes/modern/theme.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"a9c521859ff01e0528336828800db2cf\";}s:40:\"wp-includes/js/tinymce/tiny_mce_popup.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"83efe579f26f25ac80fe550402db2467\";}s:27:\"wp-includes/js/admin-bar.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d97a1899a7f641e693928f5a47c33de4\";}s:47:\"wp-includes/js/customize-preview-widgets.min.js\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"05c7517e06bb14b5eaa336c261b99b81\";}s:25:\"wp-includes/js/tw-sack.js\";a:2:{s:1:\"d\";i:1383181182;s:1:\"h\";s:32:\"b989a5bd84f6ebcbc1393ec003e6e991\";}s:29:\"wp-includes/js/tw-sack.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bc4487194e1f88126b8a500ad47e6889\";}s:37:\"wp-includes/js/wp-emoji-loader.min.js\";a:2:{s:1:\"d\";i:1430966072;s:1:\"h\";s:32:\"26ce699f92d7bd2d7dee5ff0827b296c\";}s:38:\"wp-includes/js/plupload/wp-plupload.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"659d8f1d3bfd32cf405f6591d0521e7c\";}s:42:\"wp-includes/js/plupload/plupload.flash.swf\";a:2:{s:1:\"d\";i:1429662355;s:1:\"h\";s:32:\"aeb99cfd67b07d467f9c39c1228c7e53\";}s:42:\"wp-includes/js/plupload/wp-plupload.min.js\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"1d8eb51f53f479c82c6c660f7f40ad40\";}s:35:\"wp-includes/js/plupload/license.txt\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"751419260aa954499f7abaabaa882bbe\";}s:39:\"wp-includes/js/plupload/handlers.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"813ceb60612a365924d271704d03d95c\";}s:44:\"wp-includes/js/plupload/plupload.full.min.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"9349f636c747a5e983020a1cb7213a44\";}s:35:\"wp-includes/js/plupload/handlers.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"c9d857501549cabf90a9c546f0556729\";}s:48:\"wp-includes/js/plupload/plupload.silverlight.xap\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"3c524750546de1b3aab36ff60719aebb\";}s:26:\"wp-includes/js/wpdialog.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"72e8395fd44d4039009c5396888fa6ba\";}s:26:\"wp-includes/js/wp-lists.js\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"c54ced2e822b232f2ad8a5f34930386f\";}s:32:\"wp-includes/js/underscore.min.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"929daff1019e5493c0486bfb7a642e2e\";}s:38:\"wp-includes/js/media-audiovideo.min.js\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"aedd794ce915a1b424abcfa487a27876\";}s:35:\"wp-includes/js/customize-preview.js\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"eead944332db05e2cdde148dac2cdabe\";}s:38:\"wp-includes/js/wp-ajax-response.min.js\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"f64f062c6a647e25c7fe883edb139121\";}s:31:\"wp-includes/js/shortcode.min.js\";a:2:{s:1:\"d\";i:1399589301;s:1:\"h\";s:32:\"18ba5832006079f3bcbdeb4c38c92adf\";}s:38:\"wp-includes/certificates/ca-bundle.crt\";a:2:{s:1:\"d\";i:1397846942;s:1:\"h\";s:32:\"978976c7bbfab9219a6f0a8a66a4da6f\";}s:20:\"wp-includes/feed.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9079d5de1d0ce24e41be6fca807be33a\";}s:23:\"wp-includes/atomlib.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6ff12e8342f26fb6a7402a05c8552789\";}s:23:\"wp-includes/session.php\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"29137c6fd72e3b6558be0b2b7d4e17fd\";}s:24:\"wp-includes/category.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7fe788f54bdbd3cca6a0f6eb047f560c\";}s:33:\"wp-includes/nav-menu-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5792f1c7fbe309c80c9788e332296454\";}s:24:\"wp-includes/template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c1082de0d06e484bd6f96c6a505142a7\";}s:23:\"wp-includes/widgets.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"c86541295210e626cfb9b903e0d19996\";}s:25:\"wp-includes/class-IXR.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5b35b24deb9fa653bc21930c5c082d22\";}s:24:\"wp-includes/revision.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9681cf22f338b82185d101e012f81ccf\";}s:33:\"wp-includes/pomo/translations.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"70ceb81d023473eb86cd95ef96a2d739\";}s:28:\"wp-includes/pomo/streams.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"da1ad489968e66354b95787bb9da92f4\";}s:23:\"wp-includes/pomo/po.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fb7514d4b01267af213f7830be38e357\";}s:26:\"wp-includes/pomo/entry.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0434002fe4ebffa620261de12487e02f\";}s:23:\"wp-includes/pomo/mo.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9a74e7dd40da5d849e4fd4a46fffb6b9\";}s:44:\"wp-includes/class-wp-customize-nav-menus.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"22f11b76109e055297debf1d051106f3\";}s:36:\"wp-includes/ms-default-constants.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4450a7b433edecd44ab122163ffe78df\";}s:24:\"wp-includes/ms-files.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d1b36f4a30038939309d41be68c26176\";}s:42:\"wp-includes/class-wp-customize-widgets.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b4cb9aab4994dc546ceed3ecbaca322a\";}s:39:\"wp-includes/post-thumbnail-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"60f062518ec63f708c06904b8e846560\";}s:20:\"wp-includes/kses.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a838db624ccfcd76431c96c64ec03c31\";}s:30:\"wp-includes/class-wp-error.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4b41f801534a440694ae4f6139823d68\";}s:34:\"wp-includes/feed-rss2-comments.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fca41fda847b85db0840a0ae18024160\";}s:32:\"wp-includes/comment-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c524f0482260090c82c62b7fe4437776\";}s:37:\"wp-includes/class.wp-dependencies.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5db9eaa9beb728667a8ecc5790290ead\";}s:21:\"wp-includes/query.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5f62d8bafa835c18c05320dd70eb5400\";}s:22:\"wp-includes/update.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3d7b80ce841d5fd1214d89d4db17818b\";}s:28:\"wp-includes/class-phpass.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f733676d9ae68943316d4d3921afa8bd\";}s:40:\"wp-includes/class-wp-http-ixr-client.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"08b78bb212f51718b6e9aeb7f76c0bc4\";}s:36:\"wp-includes/pluggable-deprecated.php\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"84dba0f9d4eb8476be216c22c8a4f32d\";}s:21:\"wp-includes/media.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"8deb5434efed8a0ddc9ae25c26797401\";}s:22:\"wp-includes/plugin.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a54ca88faa0764f834972699bd9451f9\";}s:38:\"wp-includes/class-wp-xmlrpc-server.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"f828ced088f4d79dc6338d67987c490e\";}s:20:\"wp-includes/user.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"cf38d70d2306414588980f879e55eb92\";}s:33:\"wp-includes/category-template.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"ac9229ff90cca16f11fef19dbd3f2f27\";}s:34:\"wp-includes/class-wp-admin-bar.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7a42f415f611040024609d283d449dc6\";}s:23:\"wp-includes/comment.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c0d720e5c1833f00cded856a1f7e0a9c\";}s:36:\"wp-includes/ID3/module.audio.ogg.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7bdc813a7fa95feceed4f6d4b37d3c97\";}s:37:\"wp-includes/ID3/module.audio.flac.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"055003ea7c0388fd73107113d3ed3bc3\";}s:37:\"wp-includes/ID3/module.tag.apetag.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"346c8c1b97caecba5592a91452fa3949\";}s:47:\"wp-includes/ID3/module.audio-video.matroska.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"639aa5ae894b396a00fb53fc8069e74a\";}s:30:\"wp-includes/ID3/getid3.lib.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"c52de7647222fe4b24e2ea04755f99b8\";}s:26:\"wp-includes/ID3/getid3.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"97bcd61856df7afa653d491775efda5c\";}s:36:\"wp-includes/ID3/module.audio.dts.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f3ea566007c94c03372eb6f46c5d2001\";}s:43:\"wp-includes/ID3/module.audio-video.riff.php\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"ee82540f026662197f7003474fd92de2\";}s:38:\"wp-includes/ID3/module.tag.lyrics3.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1255f9fb3380ba93dd223981b21832ed\";}s:26:\"wp-includes/ID3/readme.txt\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"9396dfe1c69c938eb17f564c4e5bab18\";}s:36:\"wp-includes/ID3/module.audio.ac3.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e81c4500fb4c3b224fd2f9a78ba66427\";}s:42:\"wp-includes/ID3/module.audio-video.asf.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"286b1999c151b7ba01cfd57c24e134cf\";}s:27:\"wp-includes/ID3/license.txt\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"35d98aadf8f7cc6851336651f7a66b98\";}s:42:\"wp-includes/ID3/module.audio-video.flv.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6b834869b62c57fea91851b146dce3d3\";}s:36:\"wp-includes/ID3/module.tag.id3v1.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"2b368be9e19051d00cac0e67341d051d\";}s:36:\"wp-includes/ID3/module.tag.id3v2.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f26306a3858ad4074679d94f2aeead4e\";}s:38:\"wp-includes/ID3/license.commercial.txt\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0a3b670896fc4a8067adb2c6d978418e\";}s:36:\"wp-includes/ID3/module.audio.mp3.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"eb87257b2f0507f4ac5591d4226dfc86\";}s:48:\"wp-includes/ID3/module.audio-video.quicktime.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"272dfd6e4c391f20611a11d921e66eeb\";}s:25:\"wp-includes/canonical.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1ca000ee6b0f42cfc898c0d063b738c9\";}s:32:\"wp-includes/general-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bdcc5e71a0a4599d6bba62b4e00b7ad6\";}s:30:\"wp-includes/class-wp-embed.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d48ad9835f5fff597323db7af96f980d\";}s:21:\"wp-includes/wp-db.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"29bb91f8c26d89f8f438ef235c21922c\";}s:37:\"wp-includes/class-wp-image-editor.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6a0f1c048ff8571f4ee555f04501ae60\";}s:29:\"wp-includes/post-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b8f8aad5ab246c755d50586782c210f9\";}s:24:\"wp-includes/ms-blogs.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9fc249b42ddde4e519c9023489d94479\";}s:45:\"wp-includes/class-wp-image-editor-imagick.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"79c35505b8004a3c26762bc8044a04ff\";}s:31:\"wp-includes/author-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"016d84e5998fe4e0795e9a4f66d4c1d8\";}s:25:\"wp-includes/feed-atom.php\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"e37135428b98f334acc2ea4406100a57\";}s:31:\"wp-includes/default-widgets.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"defd705b63adc03e33d3edb5fa1e3dc8\";}s:26:\"wp-includes/class-feed.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0f2b4413ee727e39ac40d94095e72489\";}s:20:\"wp-includes/vars.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"11a39afebff70d896e4a048de67846cd\";}s:22:\"wp-includes/option.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3496dcad0e1b7599317267c16ff549bc\";}s:27:\"wp-includes/wlwmanifest.xml\";a:2:{s:1:\"d\";i:1386979568;s:1:\"h\";s:32:\"dfd490b6f383ea02a269031ff05e8896\";}s:31:\"wp-includes/class-phpmailer.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"27c283e9738829458b381f0c631f1f24\";}s:24:\"wp-includes/nav-menu.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"0515adf09e2761b581533fa6bb820a97\";}s:28:\"wp-includes/class-oembed.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"74b9ef4e84e46c6cca203d8f9374dfda\";}s:24:\"wp-includes/feed-rss.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"45270d7a1f9f693c7a258cadb371e891\";}s:24:\"wp-includes/bookmark.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"abd78e431bb84a2ad8bb818acef925fc\";}s:40:\"wp-includes/class-wp-image-editor-gd.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"56c0ba8353d1f678f7b1ef15f58f2800\";}s:23:\"wp-includes/version.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"b5f10177ccd1f484f0610fcfa51107a1\";}s:31:\"wp-includes/class-wp-walker.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b975708d9d54c244c118bdf93da5e9da\";}s:37:\"wp-includes/SimplePie/HTTP/Parser.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"5725c7d0fb347f1c08df3690a58f3609\";}s:34:\"wp-includes/SimplePie/gzdecode.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"c538e2bc0e866197db616c17841134d4\";}s:35:\"wp-includes/SimplePie/Enclosure.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"122e861f42eb6e01ce8d4b0f11fb735d\";}s:33:\"wp-includes/SimplePie/Locator.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"8073a4c6da1bb33b877576665ef5eab5\";}s:30:\"wp-includes/SimplePie/Misc.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"cecde679c62dd50207d8d25ece1a4b89\";}s:32:\"wp-includes/SimplePie/Author.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"348071ed105ff0418b25964e771ba331\";}s:32:\"wp-includes/SimplePie/Parser.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"52bb2ee462e7e414a77efdc7ebf52bcc\";}s:30:\"wp-includes/SimplePie/Core.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"a4ae19a923b890f2dcf7e2d415fd1ad2\";}s:34:\"wp-includes/SimplePie/Sanitize.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"42d8b8c0cf46b5d8a511e0ae48b88f75\";}s:34:\"wp-includes/SimplePie/Registry.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"1cc8a2e6c0b5dd3176398d6400f0d9b8\";}s:35:\"wp-includes/SimplePie/Exception.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"094bfd76269c9fcc3c5cda8f05d05335\";}s:30:\"wp-includes/SimplePie/File.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"aeba08ad6b558736ea0aaf2beb2925b7\";}s:31:\"wp-includes/SimplePie/Cache.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"79fc9017a23a836f4d0f68f7764ca734\";}s:46:\"wp-includes/SimplePie/Decode/HTML/Entities.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"45975e2fcf0d428691a55a2394252f61\";}s:33:\"wp-includes/SimplePie/Caption.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"bdbabcdcca426a4dadf6675bc4c4ebe9\";}s:32:\"wp-includes/SimplePie/Source.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"8e83bb1de3e018f0537bb32a8c9617ff\";}s:46:\"wp-includes/SimplePie/Content/Type/Sniffer.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"7c72c3f369855562d96c77ece1c7db33\";}s:34:\"wp-includes/SimplePie/Net/IPv6.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"a546790e216abdd9801795949fb6b40f\";}s:48:\"wp-includes/SimplePie/XML/Declaration/Parser.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"8fb1da7028c385bb9d4203c9f6732362\";}s:29:\"wp-includes/SimplePie/IRI.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"6e16ff20d3e68692cf3b617b875f36f5\";}s:36:\"wp-includes/SimplePie/Parse/Date.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"9a0a326d308c1e48a0f89bd3ce6e2760\";}s:35:\"wp-includes/SimplePie/Copyright.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"bd7fbf68b954a9d50955cc808db7cb6a\";}s:32:\"wp-includes/SimplePie/Rating.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"3d7013a46d09c74b0ee3d8af617412fb\";}s:32:\"wp-includes/SimplePie/Credit.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"0385e4a14de78c8b2a167f3e0aea197c\";}s:30:\"wp-includes/SimplePie/Item.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"104510e221fa08437aec008e633cdca7\";}s:34:\"wp-includes/SimplePie/Cache/DB.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"0659bf084f55a303f5922edc62bcfbf6\";}s:40:\"wp-includes/SimplePie/Cache/Memcache.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"f69d4a55b2a1168531535107ab843fb6\";}s:36:\"wp-includes/SimplePie/Cache/Base.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"9443eda189bbd9325d0c9c045d237c6a\";}s:36:\"wp-includes/SimplePie/Cache/File.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"a33dbb0540ecc29cc6425b14100953d1\";}s:37:\"wp-includes/SimplePie/Cache/MySQL.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"e8911ece15df42ca43991a48d5785687\";}s:37:\"wp-includes/SimplePie/Restriction.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"2a191e7168116418817388113bd57914\";}s:34:\"wp-includes/SimplePie/Category.php\";a:2:{s:1:\"d\";i:1383181181;s:1:\"h\";s:32:\"ba7ec8cc3f13d4f27f2e0adcaf64bb2a\";}s:31:\"wp-includes/template-loader.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"de8e839d9f078c13336f75967cca59d9\";}s:28:\"wp-includes/post-formats.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"7991c2630150a35c231555ad3aa4557b\";}s:20:\"wp-includes/post.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3220c2db9cb0e7b4b048318f546e29a0\";}s:32:\"wp-includes/class.wp-scripts.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"021bb2208761eec79699febbb1d487c6\";}s:25:\"wp-includes/feed-rss2.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"508875491e48ebaecf2627d350b87ad9\";}s:25:\"wp-includes/admin-bar.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ffc6c2855977bc60251a2abc3c6f7d2f\";}s:30:\"wp-includes/media-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"eea634d0bc09162900c3b598a98b1b2d\";}s:28:\"wp-includes/registration.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"7198cf8d485e8ddcb2b3bb49a6d069da\";}s:26:\"wp-includes/shortcodes.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"b268cee6f570735e51378802ce211b46\";}s:31:\"wp-includes/class-simplepie.php\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"5973e0728909826d97bef5443b8ef72e\";}s:36:\"wp-includes/functions.wp-scripts.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f57615639435b645ddbed0d3c1d45ad9\";}s:31:\"wp-includes/fonts/dashicons.svg\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"21e6b28a2d95d779f553565c7831c97d\";}s:31:\"wp-includes/fonts/dashicons.eot\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f379d2e99493ad79891d8300bf7a4a31\";}s:31:\"wp-includes/fonts/dashicons.ttf\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4e1e8fbebedb4172f1635a4cf29624e8\";}s:32:\"wp-includes/fonts/dashicons.woff\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a880efb5c3ff8d61a495354352f81afb\";}s:26:\"wp-includes/deprecated.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4ba34b202310c5fca1b9c19a496465f6\";}s:29:\"wp-includes/rss-functions.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"67b3b8bbb2d4166c5da5346a306c3d9d\";}s:22:\"wp-includes/locale.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3bf20ab2b23efc32d6fd448a88315461\";}s:21:\"wp-includes/theme.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"92e1b884057bd0d6b9cf1f7d3fd1a90c\";}s:31:\"wp-includes/class.wp-styles.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"de0c9d70c5357a739c5b8a8a953be9ef\";}s:25:\"wp-includes/Text/Diff.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6c70d59e9e9a6e9bd11537719313e32a\";}s:38:\"wp-includes/Text/Diff/Engine/shell.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"75ab41dc91cd7e4aaa5e74a5f9e6eeba\";}s:39:\"wp-includes/Text/Diff/Engine/native.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"e5ad272a18821212bee3c3df2ae8780e\";}s:39:\"wp-includes/Text/Diff/Engine/string.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"5eee1f967840b952b502c6993dbbfad3\";}s:38:\"wp-includes/Text/Diff/Engine/xdiff.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"d6b91fc8628a0c0474ad58389a475815\";}s:34:\"wp-includes/Text/Diff/Renderer.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fc8720df4330b50f59374fdc40d94753\";}s:41:\"wp-includes/Text/Diff/Renderer/inline.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"880ae56e35b150b4b2c7e9d94227e81e\";}s:29:\"wp-includes/ms-deprecated.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"127be50737468a78f08e9c704118e01f\";}s:28:\"wp-includes/capabilities.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a31014e49ae0a01dde010296608345e9\";}s:35:\"wp-includes/functions.wp-styles.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"541d22db98d97a3255a8abfa90dddbd9\";}s:20:\"wp-includes/cron.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"00ab3d6a1c05de5a4b384991ddb766b6\";}s:42:\"wp-includes/class-wp-customize-manager.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a2f68ed4ade6069b2a376d9577d5f9c3\";}s:23:\"wp-includes/rewrite.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"d23e5fda4cb1d1e8e041f697018916d0\";}s:31:\"wp-includes/default-filters.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"dc4cbaa8db7bfb58459a74eb35056d92\";}s:33:\"wp-includes/default-constants.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e5c8b4095a4545de0a297cacec182627\";}s:27:\"wp-includes/ms-settings.php\";a:2:{s:1:\"d\";i:1417657005;s:1:\"h\";s:32:\"8a8d737615b5c982687aa82aca65f893\";}s:23:\"wp-includes/ms-load.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"3b3909d2f696036025990b997614fe5a\";}s:21:\"wp-includes/cache.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"426603785e51a63e450d6528272a70a9\";}s:23:\"wp-includes/wp-diff.php\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"7a7b02df261fb505e0de51fbd0d2e822\";}s:20:\"wp-includes/meta.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"091937220130df289041ecbb831fde04\";}s:26:\"wp-includes/class-json.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"1efa820611eebaeaf096d9ccfb8f2e43\";}s:26:\"wp-includes/class-smtp.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f0ab44d18d1be855d4e593fa5e2f089b\";}s:40:\"wp-includes/images/smilies/icon_cool.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"96467eb5ae18dfa22ea1c0fa3e74380e\";}s:39:\"wp-includes/images/smilies/icon_mad.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"d7be08b669651a63080cfe7b9004d330\";}s:43:\"wp-includes/images/smilies/icon_neutral.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"8a95dbfaa99809b0150687ae0cb45aed\";}s:43:\"wp-includes/images/smilies/icon_exclaim.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"5ce371458c1a2148595f5f3daf7b5fc8\";}s:40:\"wp-includes/images/smilies/icon_wink.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"d01a4f87055ac0fce8a66739d80434ba\";}s:40:\"wp-includes/images/smilies/icon_razz.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"17cbe5cbade2b4ec3d85be4ac9409add\";}s:45:\"wp-includes/images/smilies/icon_surprised.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"299972b5cdd1f1e0690dd95e4038bd87\";}s:40:\"wp-includes/images/smilies/icon_idea.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"bdb3226d2568b8c1edf8f453b1e872e6\";}s:41:\"wp-includes/images/smilies/icon_arrow.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"bfcab5090b1280bbe495dbead4d2281f\";}s:43:\"wp-includes/images/smilies/icon_twisted.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"62abd50ca92eb2381a7c60e351f64c46\";}s:39:\"wp-includes/images/smilies/icon_lol.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"d4f04dc65a387ca9b8c0f22ca8c0ec8c\";}s:41:\"wp-includes/images/smilies/icon_smile.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"b2984729c3b6cdc07508b88b5c0a4d1e\";}s:43:\"wp-includes/images/smilies/icon_redface.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"1c6d8b101c821641f983175221346112\";}s:39:\"wp-includes/images/smilies/icon_cry.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"453e7a3f8bbb417008f06d576c41d060\";}s:39:\"wp-includes/images/smilies/icon_eek.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"a6c65fa6ff738ef6c46a4e80a65f7aa0\";}s:44:\"wp-includes/images/smilies/icon_confused.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"7fefa473594650055a36b9e3062c9a91\";}s:40:\"wp-includes/images/smilies/icon_evil.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"63bf101bd3d4f7564d3cf31822218d2e\";}s:44:\"wp-includes/images/smilies/icon_question.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"d22775b2e32645907141f788c36d4e9d\";}s:39:\"wp-includes/images/smilies/icon_sad.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"1a273db3c34f6afb3fed75417ca5e7b6\";}s:44:\"wp-includes/images/smilies/icon_rolleyes.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"afc8bbc65fcbd2b82a3e2c1ab41a216a\";}s:43:\"wp-includes/images/smilies/icon_mrgreen.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"fde9e44a8aae0e89bd527792b4779aca\";}s:43:\"wp-includes/images/smilies/icon_biggrin.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"c7597052fe2b16db307d6bd14e7b8c6b\";}s:29:\"wp-includes/images/wpspin.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"dd4e6dd268a70ce4c1c5143b1a4092dd\";}s:32:\"wp-includes/images/wpspin-2x.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"7def33aad959cd289d49ddf2a41f076d\";}s:36:\"wp-includes/images/down_arrow-2x.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"a073b8a1ee9b2482017f3628da40a861\";}s:33:\"wp-includes/images/down_arrow.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"65dcc85d3a75ff5776fbe3df0122b7e2\";}s:38:\"wp-includes/images/crystal/license.txt\";a:2:{s:1:\"d\";i:1397846947;s:1:\"h\";s:32:\"f05db54c63e36918479b6651930dcfe7\";}s:28:\"wp-includes/images/blank.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"48bb2baaf4353109f7c2665d96aa390b\";}s:33:\"wp-includes/images/spinner-2x.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"5c1371bcb4392968647852a9c9df5d6c\";}s:29:\"wp-includes/images/xit-2x.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"8fb0729c541cbdc4609faf3f4ad02fc7\";}s:26:\"wp-includes/images/xit.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"e5012902a358fbb96031acdcf048d7ca\";}s:30:\"wp-includes/images/spinner.gif\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"b0a3dde331637e27aa6476d476481871\";}s:38:\"wp-includes/registration-functions.php\";a:2:{s:1:\"d\";i:1383181183;s:1:\"h\";s:32:\"5f3f3cb7c6d126548d7848dd5893434c\";}s:34:\"wp-includes/ms-default-filters.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"986ea4ae642955431825bf9c085987ad\";}s:25:\"wp-includes/functions.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9a799929c801302c09e30bd3956b2b3c\";}s:42:\"wp-includes/class-wp-customize-setting.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"78b9507eb8676c9710622fcc6084c5f2\";}s:42:\"wp-includes/class-wp-customize-control.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9d7f78d6cbec490603b934c9f5c6a34b\";}s:43:\"wp-includes/theme-compat/comments-popup.php\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"5885552f89b4c18061da8c2e753c122e\";}s:35:\"wp-includes/theme-compat/header.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"58b491459624d60cbde033c11de8972f\";}s:35:\"wp-includes/theme-compat/footer.php\";a:2:{s:1:\"d\";i:1397846947;s:1:\"h\";s:32:\"c6207e0b437e8e4d8f13dde9f8b5c93d\";}s:37:\"wp-includes/theme-compat/comments.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b948f25994b0743bee52974985a12d39\";}s:36:\"wp-includes/theme-compat/sidebar.php\";a:2:{s:1:\"d\";i:1397846947;s:1:\"h\";s:32:\"3e1abfa5fc227d5775166faa86842e48\";}s:22:\"wp-includes/compat.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"9622bca63975b41f05783fcb25774d57\";}s:24:\"wp-includes/feed-rdf.php\";a:2:{s:1:\"d\";i:1419363208;s:1:\"h\";s:32:\"da3c43fff6f29048bc2c4427a4cf3769\";}s:24:\"wp-includes/class-wp.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bd9f0fa15c7f40ce86ba7bc414e749c9\";}s:37:\"wp-includes/css/wp-auth-check-rtl.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"e8a7ffcfde36022642abee85dd4b629c\";}s:41:\"wp-includes/css/customize-preview.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"531c56155495680f35003643b5cfaa48\";}s:40:\"wp-includes/css/jquery-ui-dialog-rtl.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"81df1614adc93799fc9fd6b4b81c4633\";}s:34:\"wp-includes/css/wp-pointer.min.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"f2c8a14e896d48cb9f2c3367228ef562\";}s:37:\"wp-includes/css/admin-bar-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"334de15df8332ef1cbebbcdc105c9a90\";}s:41:\"wp-includes/css/wp-auth-check-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f25622d7920e308f35585f91572ac755\";}s:37:\"wp-includes/css/wp-auth-check.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"82e0a49003600469a595f3362d318f2c\";}s:37:\"wp-includes/css/customize-preview.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ff2b06049dc65d95cd7f18988e6e7dd1\";}s:27:\"wp-includes/css/buttons.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"92489bf36e3759bf16fb38fb13a34d0e\";}s:30:\"wp-includes/css/wp-pointer.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"3d7c74b9bf7260ded6960f7d7c3f1e9c\";}s:35:\"wp-includes/css/buttons-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"bbb7feb905e67321f8f9fecdd391a30e\";}s:33:\"wp-includes/css/admin-bar-rtl.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fbccb3a9d9e326432416170f500febe6\";}s:38:\"wp-includes/css/wp-pointer-rtl.min.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"6c3e135352318e69b359fc37bff0b3bc\";}s:33:\"wp-includes/css/wp-auth-check.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"8d5e06994737d4e3e35fd0688151f55e\";}s:39:\"wp-includes/css/media-views-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b809a39abbf9269fb8ca45854dee66e7\";}s:26:\"wp-includes/css/editor.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"624d68ea15072444280b4f4e4f4522ec\";}s:29:\"wp-includes/css/admin-bar.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5a46c32fd25c44db97927a28bcb170b3\";}s:33:\"wp-includes/css/dashicons.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"e65f96d4f5227b3b03c118b731b6f921\";}s:30:\"wp-includes/css/editor.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"8df6a448a11dc26010e5e58ffd258ff3\";}s:31:\"wp-includes/css/buttons-rtl.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"440f128e2267419185ce47d2f8d0505c\";}s:29:\"wp-includes/css/dashicons.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"a6907bc29f0d2dcf9a44bf4a56bceca4\";}s:44:\"wp-includes/css/jquery-ui-dialog-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5b2c5aa1462672e6856632e1901ece55\";}s:33:\"wp-includes/css/admin-bar.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"4eeb8803dcb88361aeceeeb6339a3a51\";}s:34:\"wp-includes/css/editor-rtl.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6f495e61e507d0ed5a7a9de7019b0f4a\";}s:40:\"wp-includes/css/jquery-ui-dialog.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"726d1f1796a539919fd0406404dd24e2\";}s:36:\"wp-includes/css/jquery-ui-dialog.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"0a1016dec8649f08c0f31bbb5c36cd01\";}s:34:\"wp-includes/css/wp-pointer-rtl.css\";a:2:{s:1:\"d\";i:1430392226;s:1:\"h\";s:32:\"d7e0cd8698b0111eee1a6a5f8b4c924a\";}s:30:\"wp-includes/css/editor-rtl.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"78ace8b0870478e309e40a7bbf5e3389\";}s:35:\"wp-includes/css/media-views-rtl.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"fe2e1045e95e3356a585bb83c8958fe0\";}s:31:\"wp-includes/css/media-views.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"6002f66791922cb455a1cbdcfb3e5d6e\";}s:31:\"wp-includes/css/buttons.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"650111cdcaee6c61ba5d238448345b2c\";}s:35:\"wp-includes/css/media-views.min.css\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"ff33874b8a636d534226e66ff2bd87f2\";}s:25:\"wp-includes/pluggable.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"4f1e31b0f7061fd9e879a751e2b0f5ca\";}s:24:\"wp-includes/taxonomy.php\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"e15f8b52dce314724d23932e0818c267\";}s:42:\"wp-includes/class-wp-customize-section.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"951a5e89a07f3999d4d88396c19effa6\";}s:30:\"wp-includes/class-wp-theme.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"82a816f8fd822ddc1c6d145c453b093f\";}s:26:\"wp-includes/class-http.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"cb69dae259f4de4bb9243d00a8df64ba\";}s:33:\"wp-includes/bookmark-template.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"5c9d1ab160985e1940028b225c48937e\";}s:20:\"wp-includes/l10n.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"f51413af43c8b2bd1686479614151a62\";}s:11:\"readme.html\";a:2:{s:1:\"d\";i:1442331406;s:1:\"h\";s:32:\"29c26e3150a452ccea556ee308935691\";}s:10:\"xmlrpc.php\";a:2:{s:1:\"d\";i:1441159547;s:1:\"h\";s:32:\"b81903fdb0c4b40c3e64869864e709cd\";}s:46:\"test/wp-content/plugins/font-awesome/README.md\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"32b4e0be64797070c6f9f491144a3a97\";}s:47:\"test/wp-content/plugins/font-awesome/plugin.php\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"0f2a2bf6503aed05f6c615b1f7c1d06c\";}s:62:\"test/wp-content/plugins/font-awesome/assets/js/font-awesome.js\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"b3fa16ec6bf277b9b3cac1dee6b656ba\";}s:72:\"test/wp-content/plugins/font-awesome/assets/font/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"8cca2f02b0af2da365ff4d1755f29146\";}s:64:\"test/wp-content/plugins/font-awesome/assets/font/FontAwesome.otf\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"8daab3c4f8252e0c3a3069ac0913b4a4\";}s:73:\"test/wp-content/plugins/font-awesome/assets/font/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"b683029bafe0305ac2234038a03e1541\";}s:72:\"test/wp-content/plugins/font-awesome/assets/font/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"f99a231ed57ee113b50b1c3e9f9fcdc3\";}s:72:\"test/wp-content/plugins/font-awesome/assets/font/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"5ae23ad29b67289a1375d2043e289c52\";}s:74:\"test/wp-content/plugins/font-awesome/assets/FontAwesomeIconsCheatsheet.pdf\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"4428d556d0a9d55c2efa366a1ccafdfe\";}s:71:\"test/wp-content/plugins/font-awesome/assets/css/admin/editor_styles.css\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"7c95e21e413ca54440466bb07705c91e\";}s:68:\"test/wp-content/plugins/font-awesome/assets/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"7fbe76cdac6093784895bb4989203e5a\";}s:72:\"test/wp-content/plugins/font-awesome/assets/css/font-awesome-ie7.min.css\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"4efc20143a3957f447ceeaa53695ceb6\";}s:57:\"test/wp-content/plugins/font-awesome/build_js_iconlist.rb\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"70c69c3cad3d29c71747461e6c6bfd59\";}s:47:\"test/wp-content/plugins/font-awesome/readme.txt\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"1f387e29a205efe109deed7ddaaf9e06\";}s:52:\"test/wp-content/plugins/font-awesome/build/icons.yml\";a:2:{s:1:\"d\";i:1446031222;s:1:\"h\";s:32:\"6d9e78630956cb5d3121ef6a514b8ed3\";}s:67:\"test/wp-content/plugins/news-page-slider/js/jquery.jcarousel.min.js\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"c3f1d015071fac07d94ad271b5aa0909\";}s:63:\"test/wp-content/plugins/news-page-slider/js/news-page-slider.js\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"dd90f0d5f632ade2fa5ee86e5610e02e\";}s:52:\"test/wp-content/plugins/news-page-slider/js/admin.js\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"a898ac17aca679d18456fcba6a67514d\";}s:53:\"test/wp-content/plugins/news-page-slider/js/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:67:\"test/wp-content/plugins/news-page-slider/class-news-page-slider.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"9aaba277bdf33aca3f9952f162e6a750\";}s:51:\"test/wp-content/plugins/news-page-slider/README.txt\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"3ac4ddcf899c245474099c170b8c5b56\";}s:59:\"test/wp-content/plugins/news-page-slider/lib/aq_resizer.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"ef4e0d99d8579858d0f8dd20dc611c2c\";}s:58:\"test/wp-content/plugins/news-page-slider/lib/lessc.inc.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"beff4a4a313799903e76728a6a8afc6d\";}s:66:\"test/wp-content/plugins/news-page-slider/lang/news-page-slider.pot\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4b228b2fa0a982565bdfb192760bd663\";}s:55:\"test/wp-content/plugins/news-page-slider/lang/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:64:\"test/wp-content/plugins/news-page-slider/assets/less/public.less\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"0950ce965dac85ab4b59f18431a12ca8\";}s:57:\"test/wp-content/plugins/news-page-slider/assets/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:62:\"test/wp-content/plugins/news-page-slider/assets/css/index.html\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"d984e4ea8d45a7ac0b3de73b3bd52419\";}s:62:\"test/wp-content/plugins/news-page-slider/assets/css/public.css\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"b803a3b9b72516228357de39c90de11e\";}s:54:\"test/wp-content/plugins/news-page-slider/uninstall.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"11cec65f31de1eb61c7f6f2ff7f8c0e8\";}s:61:\"test/wp-content/plugins/news-page-slider/news-page-slider.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"b41dcda498ea658a89fb9b942d7109d8\";}s:59:\"test/wp-content/plugins/news-page-slider/templates/loop.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"15d94d82791f6c97cb1b96329c497613\";}s:59:\"test/wp-content/plugins/news-page-slider/templates/list.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"6fcccde5509810732937f787522ee799\";}s:49:\"test/wp-content/plugins/news-page-slider/ajax.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"e0fa3cb332c3fd36d44413497b39d829\";}s:55:\"test/wp-content/plugins/news-page-slider/views/edit.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"aab94127ec2d12c733af592f541ff0a0\";}s:56:\"test/wp-content/plugins/news-page-slider/views/admin.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"d9fcdcca6b8392b71e2136f8c1e6c873\";}s:57:\"test/wp-content/plugins/news-page-slider/views/public.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"138352e5f0ab390e378029aa54acb51a\";}s:56:\"test/wp-content/plugins/news-page-slider/views/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:55:\"test/wp-content/plugins/news-page-slider/views/list.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"f708e762da29fa000efc76e62bc8450f\";}s:50:\"test/wp-content/plugins/news-page-slider/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:52:\"test/wp-content/plugins/news-page-slider/LICENSE.txt\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"39bba7d2cf0ba1036f2a6e2be52fe3f0\";}s:54:\"test/wp-content/plugins/news-page-slider/css/admin.css\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"1b7a24d10463e92da3d5c7fdeafe24db\";}s:54:\"test/wp-content/plugins/news-page-slider/css/index.php\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"4efa6f3be90e6ad32a02271ca4958308\";}s:53:\"test/wp-content/plugins/news-page-slider/css/blur.svg\";a:2:{s:1:\"d\";i:1439352290;s:1:\"h\";s:32:\"490477a36a91ade47bde77e2c553bbf7\";}s:79:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/upload-button-old.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"417363733f5b83b56ae998fe03004889\";}s:72:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/script.min.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"fc80cc347fc50b9656278604bdc9cf2d\";}s:79:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/upload-button-new.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"5338c3961f91bd0fdfab6e0f9ded542c\";}s:68:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/script.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"e9c2e882502db9fa22cac7bc039b7101\";}s:67:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/admin.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"d7286cd2f22e2a9646ceb12e0e56f161\";}s:75:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/admin-angular.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"06cb7fbc72ead583a4d4c98f6510bbbe\";}s:73:\"test/wp-content/plugins/jquery-pin-it-button-for-images/js/angular.min.js\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"75fb813ebaad1186f9fcd88fc2e9abb2\";}s:82:\"test/wp-content/plugins/jquery-pin-it-button-for-images/languages/jpibfi-es_ES.pot\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"5b49d9e30e4bedb9436c15c791e3f7f0\";}s:76:\"test/wp-content/plugins/jquery-pin-it-button-for-images/languages/jpibfi.pot\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"afe6c9e6ffc7e23052aa0f2c82137599\";}s:75:\"test/wp-content/plugins/jquery-pin-it-button-for-images/languages/index.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"803f140ddcb5ac869ecb7f47cf05350d\";}s:66:\"test/wp-content/plugins/jquery-pin-it-button-for-images/readme.txt\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"16baaf294f74527b133f86e2c0b7aedc\";}s:69:\"test/wp-content/plugins/jquery-pin-it-button-for-images/uninstall.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"76a4f074f8382aa9b3e4c187fa22e6de\";}s:102:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-visual-options.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"4a6f454a466615558b53555b311b23c9\";}s:103:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-admin-utilities.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"4d76848ed44a3c5d2f442a5767feda17\";}s:104:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-advanced-options.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"e25ff2e826dcb5850811740c7ee6f3d0\";}s:105:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-selection-options.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"6a02f962cc911498d8d27e6c0557d3e8\";}s:93:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/class-jpibfi-admin.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"d3d930ab67799cacceb53d09d46f6ae0\";}s:87:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/notice.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"2368a568619621ee2037135a3b7f0820\";}s:86:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/admin.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"048e849f0b2ec9cabb875fa46042c147\";}s:86:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/views/index.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:80:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/admin/index.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:95:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/public/class-jpibfi-client.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"2c1235b3d6ddc795411dcb7a74fa6ccd\";}s:81:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/public/index.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"af45d51e1e206f190753bea1a82559a0\";}s:105:\"test/wp-content/plugins/jquery-pin-it-button-for-images/includes/public/class-jpibfi-client-utilities.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"de5f394f34d9db28f32e5ee6918080fc\";}s:65:\"test/wp-content/plugins/jquery-pin-it-button-for-images/index.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"9dceb70bad5cdbd631a99f968710b231\";}s:91:\"test/wp-content/plugins/jquery-pin-it-button-for-images/jquery-pin-it-button-for-images.php\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"76d28680cb05a76604f7eb536997c0c7\";}s:69:\"test/wp-content/plugins/jquery-pin-it-button-for-images/css/admin.css\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"69511a63d9c2d5aa86cbcd833b2c7aa7\";}s:69:\"test/wp-content/plugins/jquery-pin-it-button-for-images/css/style.css\";a:2:{s:1:\"d\";i:1445444446;s:1:\"h\";s:32:\"516e53d4bc096e5346c198cfc4e96eae\";}s:55:\"test/wp-content/plugins/ss-font-awesome-icon/README.txt\";a:2:{s:1:\"d\";i:1446031338;s:1:\"h\";s:32:\"d9c0ccc1581c5a46cb6d1a5ae709b587\";}s:57:\"test/wp-content/plugins/ss-font-awesome-icon/fa-icons.php\";a:2:{s:1:\"d\";i:1446031338;s:1:\"h\";s:32:\"2ea94490db16fc4bfa3d79ecd3d22a10\";}s:58:\"test/wp-content/plugins/ss-font-awesome-icon/css/style.css\";a:2:{s:1:\"d\";i:1446031338;s:1:\"h\";s:32:\"493588dc369a3235810c105ccb11286e\";}s:48:\"test/wp-content/plugins/akismet/_inc/akismet.css\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"c8e7914736523e594837705d2c0e2714\";}s:44:\"test/wp-content/plugins/akismet/_inc/form.js\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"270f0cd7341bce6c2afacf2682e7690e\";}s:47:\"test/wp-content/plugins/akismet/_inc/akismet.js\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"09c02c732a401323bce97f3fc2b1e637\";}s:43:\"test/wp-content/plugins/akismet/akismet.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"c8a110c01b916aed48ca3fa41674d57d\";}s:49:\"test/wp-content/plugins/akismet/class.akismet.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"dedbe439abb24d15e7ee6a967c16b91a\";}s:55:\"test/wp-content/plugins/akismet/class.akismet-admin.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"1ea640fc01c689987bb35a11a6f8f885\";}s:43:\"test/wp-content/plugins/akismet/wrapper.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"f65ade0e264d0d4cbc42e28745198e23\";}s:42:\"test/wp-content/plugins/akismet/readme.txt\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"6c971cb404551dfcc03a063d9b209852\";}s:47:\"test/wp-content/plugins/akismet/views/stats.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"4491e9d145c5610b78fe742fa95a5420\";}s:48:\"test/wp-content/plugins/akismet/views/config.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"8571cc76976d930a6e53abe8e90c6db9\";}s:47:\"test/wp-content/plugins/akismet/views/start.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"52d19694ec16d382f7a0acecb7bf8c9a\";}s:48:\"test/wp-content/plugins/akismet/views/strict.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"c74eba0324f8a62b9b1ef94355861fb1\";}s:45:\"test/wp-content/plugins/akismet/views/get.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"7ba85bb5bdca316f6bd7a1d01b21d7d6\";}s:48:\"test/wp-content/plugins/akismet/views/notice.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"1e864b2ce92a5735317c49704a001a39\";}s:41:\"test/wp-content/plugins/akismet/index.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"cf6895af2050eb5ae7c0badda2604566\";}s:41:\"test/wp-content/plugins/akismet/.htaccess\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"d510e02c22cbdaa87747e769bcd916f5\";}s:56:\"test/wp-content/plugins/akismet/class.akismet-widget.php\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"ac2fc222d96b3c291fbcc74b8420b180\";}s:43:\"test/wp-content/plugins/akismet/LICENSE.txt\";a:2:{s:1:\"d\";i:1444758084;s:1:\"h\";s:32:\"b234ee4d69f5fce4486a80fdaf4a4263\";}s:71:\"test/wp-content/plugins/dfd-custom-taxonomies/dfd-custom-taxonomies.php\";a:2:{s:1:\"d\";i:1439352275;s:1:\"h\";s:32:\"4964fa8061ac4ec622653e48d9d1393c\";}s:65:\"test/wp-content/plugins/wordpress-importer/wordpress-importer.php\";a:2:{s:1:\"d\";i:1439516435;s:1:\"h\";s:32:\"76cb5c04b2230948673fd3d4ee80ec76\";}s:75:\"test/wp-content/plugins/wordpress-importer/languages/wordpress-importer.pot\";a:2:{s:1:\"d\";i:1439516435;s:1:\"h\";s:32:\"5893805913a50e3d9651ef68da6357c8\";}s:53:\"test/wp-content/plugins/wordpress-importer/readme.txt\";a:2:{s:1:\"d\";i:1439516435;s:1:\"h\";s:32:\"0558786c6742fe7df8851c51dda988d1\";}s:76:\"test/wp-content/plugins/wordpress-importer/tmp-wordpress-importer-readme.pot\";a:2:{s:1:\"d\";i:1439516435;s:1:\"h\";s:32:\"62a0c7c6ebb5d91135ce89505483ea30\";}s:54:\"test/wp-content/plugins/wordpress-importer/parsers.php\";a:2:{s:1:\"d\";i:1439516435;s:1:\"h\";s:32:\"0fff493c273f20a274c37d956a240145\";}s:86:\"test/wp-content/plugins/wonderplugin-carousel/app/class-wonderplugin-carousel-view.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"3703a53b38d49adafa040d92b56b82f4\";}s:89:\"test/wp-content/plugins/wonderplugin-carousel/app/class-wonderplugin-carousel-creator.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"772c4132cad8874bac35ce5502f7633e\";}s:92:\"test/wp-content/plugins/wonderplugin-carousel/app/class-wonderplugin-carousel-controller.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"8e056898f9f09e5443601df6c177add3\";}s:92:\"test/wp-content/plugins/wonderplugin-carousel/app/class-wonderplugin-carousel-list-table.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"a18563acc5f03641db284a6ae386a516\";}s:85:\"test/wp-content/plugins/wonderplugin-carousel/app/wonderplugin-carousel-functions.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"3beefb00777a6bd04265b7d33c23efa9\";}s:82:\"test/wp-content/plugins/wonderplugin-carousel/app/wonderplugin-carousel-creator.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"e71d97fcad75197409237d30a6d758bb\";}s:81:\"test/wp-content/plugins/wonderplugin-carousel/app/wonderplugincarouseltemplate.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"db947876ba3aa249fc97b7d79fe38bc0\";}s:87:\"test/wp-content/plugins/wonderplugin-carousel/app/class-wonderplugin-carousel-model.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"8c4de54746a7f4bab97cf08c063bc5eb\";}s:70:\"test/wp-content/plugins/wonderplugin-carousel/wonderplugincarousel.css\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"f6fbb0ac2f484afd9041789c25602633\";}s:70:\"test/wp-content/plugins/wonderplugin-carousel/wonderplugincarousel.php\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"f7a57d9739eb0ca13a9f0b2ec2e21e9f\";}s:62:\"test/wp-content/plugins/wonderplugin-carousel/engine/jquery.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"219073097031d9c1a95a1291d66f3a10\";}s:71:\"test/wp-content/plugins/wonderplugin-carousel/engine/html5boxplayer.swf\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"7044ca568ef6884c54becb1c6a71d942\";}s:76:\"test/wp-content/plugins/wonderplugin-carousel/engine/wonderplugincarousel.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"08816e62dcb06f97cf8f19d2c2cdbf8f\";}s:73:\"test/wp-content/plugins/wonderplugin-carousel/engine/lightbox-loading.gif\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"7b0935b69a5d4f04400080ada2939ce4\";}s:71:\"test/wp-content/plugins/wonderplugin-carousel/engine/froogaloop2.min.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"2a8742c0ac1cdbec23be44a7d4e9a3c9\";}s:81:\"test/wp-content/plugins/wonderplugin-carousel/engine/wonderplugincarouselskins.js\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"25c52428f0fcbf57bf5f8c2f0b5655ba\";}s:64:\"test/wp-content/plugins/wonderplugin-carousel/images/loading.gif\";a:2:{s:1:\"d\";i:1445436970;s:1:\"h\";s:32:\"be1cede97289c13920048f238fd37b85\";}s:68:\"test/wp-content/plugins/wonderplugin-gallery/wonderplugingallery.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"c44a771f70a40fda3927667f4c50adee\";}s:80:\"test/wp-content/plugins/wonderplugin-gallery/app/wonderplugin-gallery-creator.js\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"b4356e5dfdb75d9ab660ea1035d0d57f\";}s:90:\"test/wp-content/plugins/wonderplugin-gallery/app/class-wonderplugin-gallery-list-table.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"a2ab08cf5697869c59950ccc31c4538e\";}s:83:\"test/wp-content/plugins/wonderplugin-gallery/app/wonderplugin-gallery-functions.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"3beefb00777a6bd04265b7d33c23efa9\";}s:84:\"test/wp-content/plugins/wonderplugin-gallery/app/class-wonderplugin-gallery-view.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"5d2ad7098a7c1204c874553e332a6347\";}s:85:\"test/wp-content/plugins/wonderplugin-gallery/app/class-wonderplugin-gallery-model.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"2093ff557313e5f4ee133bea89ce5a91\";}s:87:\"test/wp-content/plugins/wonderplugin-gallery/app/class-wonderplugin-gallery-creator.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"a1bc3df3bc09e9c43121dae4c13b30b7\";}s:90:\"test/wp-content/plugins/wonderplugin-gallery/app/class-wonderplugin-gallery-controller.php\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"56895f86d5d596cefedacb1f96c720dc\";}s:79:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/horizontal/index.html\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:87:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/horizontal/loading_center.gif\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"7b0935b69a5d4f04400080ada2939ce4\";}s:80:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/horizontal/loading.gif\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:78:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/mediapage/index.html\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:86:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/mediapage/loading_center.gif\";a:2:{s:1:\"d\";i:1445699951;s:1:\"h\";s:32:\"7b0935b69a5d4f04400080ada2939ce4\";}s:79:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/mediapage/loading.gif\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:68:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/index.html\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:77:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/vertical/index.html\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:85:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/vertical/loading_center.gif\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:78:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/vertical/loading.gif\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:74:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/light/index.html\";a:2:{s:1:\"d\";i:1445699952;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:82:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/light/loading_center.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"7b0935b69a5d4f04400080ada2939ce4\";}s:75:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/light/loading.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:77:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/darkness/index.html\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:85:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/darkness/loading_center.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:78:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/darkness/loading.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:76:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/gallery/index.html\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:84:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/gallery/loading_center.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"7b0935b69a5d4f04400080ada2939ce4\";}s:77:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/gallery/loading.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:92:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/gallery/carouselarrows-32-32-0.psd\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"765dcb036d6c376cc307e5754bdf52d3\";}s:77:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/showcase/index.html\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:85:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/showcase/loading_center.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:78:\"test/wp-content/plugins/wonderplugin-gallery/engine/skins/showcase/loading.gif\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"bd72dde32e02048026f50306cb4f7aa7\";}s:70:\"test/wp-content/plugins/wonderplugin-gallery/engine/html5boxplayer.swf\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"7044ca568ef6884c54becb1c6a71d942\";}s:70:\"test/wp-content/plugins/wonderplugin-gallery/engine/froogaloop2.min.js\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"697e27602626e38fbf2d3847a8e11b1e\";}s:74:\"test/wp-content/plugins/wonderplugin-gallery/engine/wonderplugingallery.js\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"581f9098c428ab5b0e9b4a480d0f6460\";}s:68:\"test/wp-content/plugins/wonderplugin-gallery/wonderplugingallery.css\";a:2:{s:1:\"d\";i:1445699953;s:1:\"h\";s:32:\"39b8b36d3c5bfa461652d567d74107b1\";}s:63:\"test/wp-content/plugins/wonderplugin-gallery/images/loading.gif\";a:2:{s:1:\"d\";i:1445699954;s:1:\"h\";s:32:\"be1cede97289c13920048f238fd37b85\";}s:75:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-icontext.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"f4a9f2e73b8c07595bb54bc888ebcc52\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/config/admin-options-fields.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e5fe233ef59a3a5c5d2dda8670fdef7e\";}s:69:\"test/wp-content/plugins/agp-font-awesome-collection/config/config.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8a189b4b6ef0779fb40f499795a72c63\";}s:76:\"test/wp-content/plugins/agp-font-awesome-collection/config/admin-options.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"546a8a8b04f1021a174f049fb7523de2\";}s:76:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-container.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b4531ce7271507bbe35c55dffab53d64\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/config/admin-options-fieldset.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"eea3e44c7bed9345bda7ea142ca64724\";}s:71:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-icon.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"052fb2193cc52d7b1b7af1b5441e62e9\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-button.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8e63d7887b577114464b9ab7b13670f6\";}s:75:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-dropdown.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"a05f0cdf72a04913b35b1b1749a6caf5\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/config/admin-menu.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e25b73cf1d752a37777c740d5df194c3\";}s:75:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-fieldset.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"07f28ff0b18fa4b5ba5bb321b0645b13\";}s:74:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-version.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"d34efd49e6ae48c10726f38e4ad5e917\";}s:81:\"test/wp-content/plugins/agp-font-awesome-collection/config/admin-options-tabs.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"bf126d52989d6d6f14bf396ccdf4cd7e\";}s:72:\"test/wp-content/plugins/agp-font-awesome-collection/config/fac-blank.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"5ccf8cd1b2db37540959068ec0534daf\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_TaxonomyIcons.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"fb578260b54084700e303c6e3f5e6600\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/classes/widget/Fac_PromotionSlider.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"84318f3d7ef1d018212f50205c4dd358\";}s:90:\"test/wp-content/plugins/agp-font-awesome-collection/classes/widget/Fac_Promotion.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"179f51441355c59b9b4a6a66e25f9570\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/classes/walker/Fac_WalkerNavMenuEdit.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8b8b213c17a73b51d0f7ea110ee34662\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_MenuIcons.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"00a32ddc943ea30b1edf346008bfb946\";}s:78:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Ajax.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"054a059e135bce4d7b80573c5d0d995d\";}s:84:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Shortcodes.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"854fab178af4d554ea8d88ed8df09d60\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/classes/persistence/Fac_IconRepository.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"157c4bbea505c2204a248de2c1f29f56\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/classes/persistence/Fac_IconEntity.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"91feef2d61718c09bf3dbcd9b5a669c2\";}s:79:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Icons.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"860526dce4d8cda234efe4cc982644eb\";}s:80:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Slider.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"d83e19d5c413bc4c48e5010161c1d3c8\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"d762be9b247890ced55b488c03cc892a\";}s:82:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Settings.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8502d717d344510731621ad7ee7ce480\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/classes/Fac_Constructor.class.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"dff7bcbcecafe7c9dddfb8e15bd1c1b9\";}s:65:\"test/wp-content/plugins/agp-font-awesome-collection/classmap.json\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"51681985d986b4ecf3dfe36384ade378\";}s:71:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/autoload.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"62f8c24681df96e73515363eb4b417a8\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/Spyc.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"6626a1da01728785f62989dfdf2e620c\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/COPYING\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b0987325db5fa8e52b7076860d8e2e0a\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/README.md\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"f25bb638f15eb0162e969e607a2f12c2\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/ParseTest.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b8ae2cdf1eac95d96715c2d0a41cf181\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/failing1.yaml\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0ef99a6ae65297ed98adb19c3c2f814b\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/indent_1.yaml\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"71efbf3d1f009ea941349d39245115b3\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/DumpTest.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"cf48a83f4367635ac462cfca8eb7607b\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/RoundTripTest.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0725910e6aebc365933068d768923440\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/quotes.yaml\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"054f5355f300d9127aa1e597cf5682d9\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/IndentTest.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8bbc29736129372af2121c5fafe1dfdd\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/tests/comments.yaml\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"6cb681c4f58b7a5f92965b9ba65f5132\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/php4/5to4.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"1bee498adf3521f220ef2f22aff84389\";}s:92:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/php4/test.php4\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e7f605110f596ff0344431a08dc77b10\";}s:92:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/php4/spyc.php4\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"013ea7fe6257e8cebe0f17dbf2115bb7\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/examples/yaml-load.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"10189cd25b80e661fd5ed7019942a7df\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/examples/yaml-dump.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"c18b833f0057beb6a5845bf4335c68e0\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/spyc.yaml\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"476c3758d906a14ae5dac79ac1316026\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/mustangostang/spyc/composer.json\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"51741fb349715f27ed3a000f1f223ed9\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Output.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"11ae9bd49dbf7b2aaaf8248a37036d67\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Configurable.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"4083092cd9a06fcf6fd3597800632ac6\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor/import.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0210f8a9d2b76396629581a711c7891a\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor/processExtends.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"658e983668311b3ea4b337b44e65ae56\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor/joinSelector.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2e00ad14ce96759700e8084b20006515\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor/extendFinder.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b3d3bf2a661aee46de94acc438b339bd\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor/toCSS.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"3e7caaa8814953c5741291a51c7f26b4\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/NameValue.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8e4e50da2126cbd2a149c6079386acd9\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Keyword.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2eceab9009091c37150a18c6264b82b0\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Expression.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2cbefe86e487c939817bc38b19a15ba3\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Condition.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8777875b00cba62d8b98f8cd63b911b9\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Rule.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"3804b0c7258bbf8b3b675ca3c6a24890\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/DefaultFunc.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"efab3ab6d6b6ba77c346aacd36cfdcc6\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Dimension.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"34cfdface2c9eec6a9e1dba1b3683955\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Value.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"ee56b10012047cfd9348ac6e708b99ee\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Ruleset.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"528b42a3a2e66ab4323da335aaeabe3c\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Attribute.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"facc0c025e5980a71edb4c05f57229e6\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Variable.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"bb31eb19ec6d92e3ccf70991f2e766a6\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Mixin/Call.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b7bb736297d8599554f5201f09799b3c\";}s:111:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Mixin/Definition.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"a70dee694af4f4c2676c2f0b307328e6\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Paren.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7cbe95eab97fcdb53293e695396c22d2\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Directive.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"306399394541ab1c08dc4d36f538d1d7\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Unit.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"89b1193f7bcd13befe6d5e13bcedb053\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/UnitConversions.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"84ff9e76c961392e58dcc8961c859583\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/UnicodeDescriptor.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"604d5fc740c837ec717d7b3e7917d1df\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Assignment.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"189e7290c39946b0e74150d419a450bb\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Media.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0ac244a02b48a1803a706eaaf09c6d01\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Quoted.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7845fd8eba9aba52945240e786ba361d\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Negative.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e0df292b66eb3b8965e7ecde6cab3290\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Comment.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8d4ec82d7c16d6e7f891c218763fea40\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Call.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"053e3cf02cc0ca29a5c4b236a23c36a3\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Color.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"096e1c980f3a670a5f5f07e2aba3c96f\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Url.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8226a4af7f32f2bb583e6d22511fb50a\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/DetachedRuleset.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"1251a21ab57301fd9aa5335455dbb6fd\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Alpha.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"9e77e638452dfa952c37e3c8a7c8ee08\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Anonymous.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"dd48db1ed7f41c3ece7ff58d034f0e41\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Javascript.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2675f8dac30aea38e49f8dd8bedf538f\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Extend.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"051b68ef3e37ce698b2cb46bb694ee19\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Element.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"a0804be1320634a9e71a0c0648d09387\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Selector.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8c62d808c119aa67ff7841001f62bc62\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Import.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"4aa62d2bd79e4df2a6f1b599b9caa1f4\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/RulesetCall.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"44414e8dbd3ccd1a8076e31f88590c1c\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree/Operation.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"dfd3fa0701484387c1a28c9c84e10219\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Output/Mapped.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"f45074dc910c30a8d97f3777c89939f5\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Parser.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"dce1997c621491d8075abfa0d572730e\";}s:94:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Mime.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"dddfd5c1cce36f86f9db10ae576eeca7\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Functions.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"c6ee99610c3dc9e24581e2acaefd7605\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Cache.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"6d271ca52fa1dcfbbd454a3676e4bce3\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Visitor.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"a3cf7b51d22c19b6f843ac794f8b354d\";}s:94:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Tree.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8e671a3b5fd55d42a47afecc0a8045f5\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Exception/Parser.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2d72585190b0c2262a5f60505111edc3\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Exception/Chunk.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e311e5c50f09dcb4fbfb4175d331b52d\";}s:108:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Exception/Compiler.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"596cacfb7f4184735d3929eb79c1533a\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Colors.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8483585fe2ee7ccd323c36f25b9e9419\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Less.php.combine\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"bdbdda71bf61236bb67dc30e3d160c0b\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/VisitorReplacing.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"b8a9737b8f1dbb00f2df49918c58f6a1\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Environment.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"453994bcf288736ad3c6f3ee0ab91694\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Version.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0fe384ee36e64dc06667036ef1432ec2\";}s:109:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/SourceMap/Generator.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"39ec9f0f3e7e831a67ffd7bf63ad70bc\";}s:109:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/SourceMap/Base64VLQ.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"ec48b0234dda55834586a603e7c081a7\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/.easymin/ignore_prefixes\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"152d0c94173995f46cf39c4923eda41e\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lib/Less/Autoloader.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7514b5e9b3d08412eec10fd50cb03b24\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/.gitattributes\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0ece5ca4688baa49dcc7dd967294d561\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/README.md\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"4b89e6a859156d55a7519aef5d99c3a7\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/.gitignore\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"06a124191e660a240d78cd986f1d9e80\";}s:84:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/LICENSE\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"ffb8ec36d0616f5b1199a7326ae28b06\";}s:90:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/lessc.inc.php\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"af4e7ba10d43ea628a0f7d4c65e2c294\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/bin/lessc\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"5340625c17ae2ec3adaba2eedf16ef7b\";}s:90:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/oyejorge/less.php/composer.json\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"c45075e47a4d0f146db445ffb5fe9895\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_core.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"ef059a98cf9de6ca5b77ee6850771cf0\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_variables.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"667c28ce24bc245dd0b3b8578ea2d083\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_mixins.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"2052155a929be2769df84be98617f310\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_icons.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"bf191ec4814fc5a8f3039782acebf31c\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_animated.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"39ff4f359a7b81d6585075715f41e5dc\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_stacked.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"5594237226aedfbca2fa1c7f4604c214\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_list.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7107e80b053928271d5fcf422dc29490\";}s:109:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_rotated-flipped.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"9f5d4bc6fadea89328d2aac26574a9d8\";}s:109:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_bordered-pulled.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"4cad0df17bf40327feae33fa9a6c6ba2\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_path.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"ab5a9e8388563e097b5ce835601f01d2\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/font-awesome.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"0647c61c2fc0af2d3110b3e021df2167\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_fixed-width.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"9277ab6964a434d499873687b00be906\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/scss/_larger.scss\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e95931566f6fc6ad5685c4fa9802e206\";}s:92:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/README.md\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"3551a5f82dfd91ffa0c63ea1212c6649\";}s:93:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/bower.json\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"d6671a826bebed977d2b973d0011bf0b\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/Makefile\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7839ea656de0444f4d7dee45bb020c34\";}s:93:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/.gitignore\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8771f708f4f953120c85589ad0957a63\";}s:108:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/bordered-pulled.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"898f90e40876883214bbd121b0c20e9f\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/mixins.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"63afa4054431cd255dd522314d42fe01\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/fixed-width.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"5e07ec001f8d21bd279c12ee542813f7\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/font-awesome.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"4f6e61c4223f6a8192e93abca2a8a99c\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/path.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"3ae443e0386cc3a69ff47d641aefb74b\";}s:108:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/rotated-flipped.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"a8476cdc50c264abd11ff59d6a9dd025\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/larger.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"8cb65280c0f889daf72626c21a7c8628\";}s:98:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/icons.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"e6fe3b4dd15172925a4a705dd665a971\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/list.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"975571323cf880a4a30601998236b027\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/animated.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"08baef05e05301cabc91599a54921081\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/stacked.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"518e2b2d263982d2caa1e6514b4b4eac\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/core.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"fb4efe4ae63737706875bbbfc7b7e9af\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/less/variables.less\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"96deacae046c32ee7f4d9e0567a0484b\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1447903361;s:1:\"h\";s:32:\"7c87870ab40d63cfb8870c1f183f9939\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1447903362;s:1:\"h\";s:32:\"668743fe7258676f8ef8f9b47d2a623e\";}s:113:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dfb02f8f6d0cedc009ee5887cc68f1f3\";}s:114:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/fontawesome-webfont.woff2\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4b5a84aaf1c9485e060c503a0ff8cadb\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"76a4f23c6be74fd309e0d0fd2c27a5de\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"45c73723862c6fc5eb3d6961db2d71fb\";}s:97:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/component.json\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a96ae2ff39d7ec1efe1d131a1d3be4c1\";}s:107:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"0831cba6a670e405168b84aa20798347\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/css/font-awesome.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"8e12157da5fc90094ae4113ba110456b\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/components/font-awesome/composer.json\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"605dcf3fc94abdc730b91a2e4084605a\";}s:72:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/bin/lessc.bat\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"557eabbb2e41ffc78595d95b68486919\";}s:68:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/bin/lessc\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ea2a6fc9a5d846a3feecdfd2f8a9b35e\";}s:89:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/agpfontawesome/icons/icons.yml\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"264c36feed08e63302607a87fafb9a26\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/autoload_namespaces.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f3eef7152a43a52c3ca2c79a0ae8465f\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/autoload_files.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a910a62cc27502bdf818a1e757d8ca1f\";}s:82:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/installed.json\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d317cb12ec3c69dac51cc38a59e755a9\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/autoload_real.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"80157ddf73b305a94c54afe2c4217970\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/autoload_psr4.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dd3a00f0d13eb29781edd8c77d4c5100\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/ClassLoader.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"34d839144753232357cd717d22a9aa90\";}s:89:\"test/wp-content/plugins/agp-font-awesome-collection/vendor/composer/autoload_classmap.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"185e9bd1004613ceedea66c583932d79\";}s:61:\"test/wp-content/plugins/agp-font-awesome-collection/README.md\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"37a5979c715de3892d96eb9f6b1e4844\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/agp-font-awesome-collection.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"244fd857f54920b96c26ea3ec2240e0b\";}s:69:\"test/wp-content/plugins/agp-font-awesome-collection/assets/js/main.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ee8ac4bb25838d9abf25c0ed7a083cf7\";}s:70:\"test/wp-content/plugins/agp-font-awesome-collection/assets/js/admin.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"29fe69d02ae4042b58f5c034b72dd2af\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/assets/js/fac-icon.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"36921497752a9f019f08461ee2623ad0\";}s:78:\"test/wp-content/plugins/agp-font-awesome-collection/assets/repeater/js/main.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f2f9808a4484bbbcfa3b43941f4eab04\";}s:79:\"test/wp-content/plugins/agp-font-awesome-collection/assets/repeater/js/admin.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c9db52cee4b472573816787c3413369f\";}s:81:\"test/wp-content/plugins/agp-font-awesome-collection/assets/repeater/css/admin.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dbee97fd0bb11b1ea05e5dc639a2cab7\";}s:81:\"test/wp-content/plugins/agp-font-awesome-collection/assets/repeater/css/style.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dbee97fd0bb11b1ea05e5dc639a2cab7\";}s:84:\"test/wp-content/plugins/agp-font-awesome-collection/assets/libs/jquery.mobile.min.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"0b038231b5bca7f90df9c336abca12ac\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/assets/libs/colorbox/jquery.colorbox-min.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"da2d04baa23b2df3337c8e41db46c6a9\";}s:85:\"test/wp-content/plugins/agp-font-awesome-collection/assets/libs/colorbox/colorbox.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c2024b87bcfaf5b57d187a9ffd330a4d\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/assets/libs/colorbox/images/loading.gif\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c0f95423d88f040b9f7f44a627831738\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/assets/libs/responsiveslides.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"858fb17a128c1a5190e806fce0d93733\";}s:77:\"test/wp-content/plugins/agp-font-awesome-collection/assets/images/spinner.gif\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"b494fceca79586281a29c9462b09c85a\";}s:72:\"test/wp-content/plugins/agp-font-awesome-collection/assets/css/admin.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"720dbed1e5f69ce60dc328a885839bbb\";}s:72:\"test/wp-content/plugins/agp-font-awesome-collection/assets/css/style.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"1c5df579e6e14f69cfbbe8c5458f77f4\";}s:62:\"test/wp-content/plugins/agp-font-awesome-collection/.gitignore\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"aebc143c7f272cb6abe05059966dfa30\";}s:88:\"test/wp-content/plugins/agp-font-awesome-collection/agp-font-awesome-collection-init.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"28575e423ac7aef8020e79d2066316a6\";}s:82:\"test/wp-content/plugins/agp-font-awesome-collection/types/shortcodes-post-type.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4faec53d3e815d440f177b2024cda5bc\";}s:79:\"test/wp-content/plugins/agp-font-awesome-collection/types/sliders-post-type.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4832d5b09ac62fbf79d1aeb55497073d\";}s:62:\"test/wp-content/plugins/agp-font-awesome-collection/readme.txt\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"5e7b33a371d66b486fb9019829507a80\";}s:82:\"test/wp-content/plugins/agp-font-awesome-collection/templates/widget/promotion.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f271de43b24ab2dfffc745dce1a9b732\";}s:93:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/horizontal/row.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"91e5b8c35e86536ec89cc46ce139943d\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/horizontal/header.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"0b31032dfcd842b100d02a9624878e62\";}s:96:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/horizontal/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"7c682a0d17ca450498b55c88a6d99a8c\";}s:91:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/vertical/row.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"2ad8b8d0cd909955bf4aa023f84ee24d\";}s:94:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/vertical/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"23a2d6623c49d7b8dfe982c80fda9298\";}s:89:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/slider/parameters.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a9a4d877503407e38befb5e5aecb4d53\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/constructor.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4446be06e48574efd77bd431c22c51aa\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/element-params.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ffa76bae82f1bf154102f3e1ab0c7e8c\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/text.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"db23816a4662767bc188bc84285156c2\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/select.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c9cc34c6dd97df5587e7355358cdf090\";}s:105:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/fa-select.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"5b9c6055b3f366641b4b590a09714788\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/checkbox.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f5e62212e6414ce8e16e4f43d95accc1\";}s:107:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/colorpicker.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"0686139efb21db6ef58dd388349f12be\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/fields/textarea.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"377a05fb1f783f77fe9468a94783b07a\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/element-preview.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"0b4a62a0c3235f3687b5063dcd54da8a\";}s:101:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/element-list.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"1b84e78d67e8005384e8740b3156c209\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/render-page.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"41854e0a05d003321bc9060f43a06acb\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/constructor/form/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"3d07e7cc999b5f2bc963e6a9613c0073\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/templates/admin/options/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"31f9f3464ff8ee4ceba1a7baadfcc770\";}s:72:\"test/wp-content/plugins/agp-font-awesome-collection/templates/button.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d4d4e4018d7dc7cffb25fa1c17172e09\";}s:70:\"test/wp-content/plugins/agp-font-awesome-collection/templates/icon.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"5832e72fc8e3fbf2f334222c81602d16\";}s:75:\"test/wp-content/plugins/agp-font-awesome-collection/templates/container.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"86ba1754b44664165ab0d2d07af4fc91\";}s:86:\"test/wp-content/plugins/agp-font-awesome-collection/templates/taxonomies/icons-add.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d9df9eaea1e04af8f1d00651dee0b9e6\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/templates/taxonomies/icons-edit.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4ffe3b93112023f7c0c99266c60e421f\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/templates/default.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ce407ff5715c837d02b1aba7975bf512\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/templates/version.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ebc51f823330a4ef30584d3d001e0594\";}s:74:\"test/wp-content/plugins/agp-font-awesome-collection/templates/dropdown.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"5f0ef1a62d258d262f809986c6e18c2e\";}s:74:\"test/wp-content/plugins/agp-font-awesome-collection/templates/icontext.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c10ed35501437289682e77d8c68bd750\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/templates/sliders/default/slide.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a5b75d689d3b7155d977cb609f6f40ae\";}s:88:\"test/wp-content/plugins/agp-font-awesome-collection/templates/sliders/default/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"883b425477015c3a787ebbd007d60cd7\";}s:59:\"test/wp-content/plugins/agp-font-awesome-collection/LICENSE\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"8264535c0c4e9c6c335635c4026a8022\";}s:83:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/agp-core-functions.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"64370e405aec851f0ad2051094d8f0b2\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/config/Agp_ConfigAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"959df3e383e260e0f78a9ee0c5f5b736\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/config/Agp_SettingsAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a5e05c3a8c587b82a84028e058e4eb2c\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/fields/Agp_RepeaterAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"33b838364e29d96353db85a87007ec01\";}s:99:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/database/Agp_MySqlDb.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"227a7325a44fab2c69e775f95c91be8f\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/database/Agp_DbAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"eeacd27410be282cb2e1c29765b30103\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/ajax/Agp_AjaxAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"1cf14113395e6fe9abaa609b6158264f\";}s:107:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/error/Agp_DbConnectException.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"bab0c415ca093a47fac2d49b158f9739\";}s:106:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/error/Agp_ExceptionAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"04333d7770925985506096a6f987f6b8\";}s:107:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/error/Agp_ExceptionInterface.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"73eacdab5e9edad60c5e198dd4abaefd\";}s:93:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/Agp_Autoloader.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"5cb31d2d9d70fdb8317900b5d782e8a2\";}s:117:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/Agp_SingleSelectRepository.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"1c747891b3428960b7911eb4319aaa3b\";}s:116:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/Agp_MultiSelectRepository.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"78527e1391f773f3b3f631fef47265e1\";}s:116:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/entity/Agp_EntityAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"cb8096b7b62b289041ebb109c3c8d240\";}s:108:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/entity/Agp_Entity.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"645d38f10beb2dcdc9c60457930e16dd\";}s:116:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/entity/Agp_TaxonomyEntity.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"9941c748786bd6dbef4e8bb1c6ea0968\";}s:112:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/entity/Agp_PostEntity.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"501386d899171476928164f4540ac56a\";}s:110:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/session/Agp_Session.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"7e9b04f97cc9a8a01d6393960b85dd93\";}s:118:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/session/Agp_SessionAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"153d140693e6b1e04dae6f01391fe9ec\";}s:117:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/session/Agp_CookieAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"71ad34b0d82907894fc968f5f5b36c2c\";}s:113:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/persistence/Agp_RepositoryAbstract.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f827652352fbf9c0ac72d56af596e29e\";}s:89:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/Agp_Module.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"171a304efa9225c09cc14b4a9466c725\";}s:92:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/classes/curl/Agp_Curl.class.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"415f516e5a0f0f478bfc5aa4f6584298\";}s:70:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/README.md\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a1ff90b52a96514f3633918ea93b6bd6\";}s:87:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/assets/repeater/js/main.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"f2f9808a4484bbbcfa3b43941f4eab04\";}s:88:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/assets/repeater/js/admin.js\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"2cf69743c2e55f75ee632b66877253f5\";}s:90:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/assets/repeater/css/admin.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dbee97fd0bb11b1ea05e5dc639a2cab7\";}s:90:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/assets/repeater/css/style.css\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dbee97fd0bb11b1ea05e5dc639a2cab7\";}s:73:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/agp-core.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d43e0b5bcfd6fe13243213dafe7e6474\";}s:71:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/readme.txt\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"6f7e171186d04c8daf1f5543fad6d1c9\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/fields/repeater/row.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"b4112cdd534ed82f01657dc144204bbe\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/fields/repeater/header.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"4216243553da47214535a3fefb6d66ec\";}s:103:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/fields/repeater/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"dc74db8f3f31f7fc5c0a38977a5e5203\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/hidden.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"e534ce9dbbfcd13ac87a4613efe0a433\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/text.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"c7fdaa96a412c8739dcca226ec0aa802\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/select.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"ac80ed1d6b4e996183b00ff227968735\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/checkbox.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d2d55eeb146a5771da2c7b565f946467\";}s:107:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/colorpicker.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"17cf8412ad34ad68640d6d1dd6dc34d0\";}s:104:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/textarea.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"a42eccd7330da137ab1886615076d37c\";}s:102:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/fields/number.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"928189a047c03be7cd01dd8a8f7c3e3d\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/render-page.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"7840b18e1f109ae61044ce5da3f111dd\";}s:100:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/render-tabs.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"d8755bc945c84add17b99580b9ac1406\";}s:95:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/templates/admin/options/layout.php\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"3adea222f88dfbcc7b8daac9d2812093\";}s:68:\"test/wp-content/plugins/agp-font-awesome-collection/agp-core/LICENSE\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"8264535c0c4e9c6c335635c4026a8022\";}s:65:\"test/wp-content/plugins/agp-font-awesome-collection/composer.json\";a:2:{s:1:\"d\";i:1447903363;s:1:\"h\";s:32:\"cf61ecd20207b3b32cb1af1bff9eca4a\";}s:64:\"test/wp-content/plugins/advanced-custom-fields/js/field-group.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"1e0063c1c69fae6b4d322858ffaa428f\";}s:69:\"test/wp-content/plugins/advanced-custom-fields/js/tinymce.code.min.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"7ee0c9abb650905bf373c93f9de4cd13\";}s:62:\"test/wp-content/plugins/advanced-custom-fields/js/input.min.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"16e8e1f4cffa13c10bd9d6acc2be5f5a\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/js/field-group.min.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"ddad50648ec2027df38f8c2ca867ea60\";}s:58:\"test/wp-content/plugins/advanced-custom-fields/js/input.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"924449d15cc7d2808c5bc213abebab6e\";}s:74:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/addons.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"4bebfcf4545dc7991798399dbbdbdb75\";}s:73:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/input.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"1fabc949969ed613f7e175769e2e8fc9\";}s:79:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/third_party.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"50730b2da70527c8a7a99670496d5eef\";}s:76:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/location.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"9159cef982909bae1ff707cd8a5c2b9a\";}s:77:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/revisions.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"f19eaf907f8c9ee5c7f2e22dbd74a01b\";}s:85:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/everything_fields.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"b24d7a33f24e47bc57e0833606792c21\";}s:72:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/post.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"7bf5a80af06eb66ccd3d9502f52ac7d9\";}s:80:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/field_groups.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"46af9a1066098b28c54927afff35faa1\";}s:74:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/export.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"7ffdfad2435901b2f78c3c3dbf8a727c\";}s:79:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/field_group.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"217a865c5295a7c2ee197a51873b9df4\";}s:75:\"test/wp-content/plugins/advanced-custom-fields/core/controllers/upgrade.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"bccb29744912abb02f19e8884b162ff6\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/core/fields/dummy.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"009933ff53f4f799dfcd29b4491801ad\";}s:67:\"test/wp-content/plugins/advanced-custom-fields/core/fields/text.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"278e160e87c7e1444ce7dcd457822403\";}s:69:\"test/wp-content/plugins/advanced-custom-fields/core/fields/select.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"b1227e35b359e23ba15b920d9f4ba0da\";}s:70:\"test/wp-content/plugins/advanced-custom-fields/core/fields/wysiwyg.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"67fd494118fb1d239f894ab77aa362e3\";}s:70:\"test/wp-content/plugins/advanced-custom-fields/core/fields/message.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"dfa2e50c211a889f782a961bf05e8644\";}s:75:\"test/wp-content/plugins/advanced-custom-fields/core/fields/relationship.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"ad42cd48179b4e703ebbc6d1af337fb9\";}s:67:\"test/wp-content/plugins/advanced-custom-fields/core/fields/file.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"ae9b6b8218fcef28b50f81fd7e59c1d6\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/core/fields/image.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"6690a23d53edeeaf72b8d5dba103a2ea\";}s:67:\"test/wp-content/plugins/advanced-custom-fields/core/fields/user.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"ed0c114d1043f8994a38ebe9bb5a56d4\";}s:75:\"test/wp-content/plugins/advanced-custom-fields/core/fields/color_picker.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"4d9a3301404c35e9e62b0cbe30960f58\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/core/fields/email.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"e6b30c69b9c47fd25ee531352800fd8d\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/core/fields/radio.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"b0169cc5ee8f004f335d187bd348b57e\";}s:73:\"test/wp-content/plugins/advanced-custom-fields/core/fields/google-map.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"a903c00b83c64ccbf40af6c13cc52e39\";}s:73:\"test/wp-content/plugins/advanced-custom-fields/core/fields/true_false.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"246efd0f190c827c447a2789cf24dfed\";}s:71:\"test/wp-content/plugins/advanced-custom-fields/core/fields/password.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"654b686295e7402ba7a102a5bd2526ad\";}s:72:\"test/wp-content/plugins/advanced-custom-fields/core/fields/page_link.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"5ab7b83fb7b7dd397b3347642efa2dc4\";}s:66:\"test/wp-content/plugins/advanced-custom-fields/core/fields/tab.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"ca140401d0c80d455d0e43859abad0e7\";}s:92:\"test/wp-content/plugins/advanced-custom-fields/core/fields/date_picker/style.date_picker.css\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"2fcb7eefce041574fb551ae54a77bda5\";}s:94:\"test/wp-content/plugins/advanced-custom-fields/core/fields/date_picker/jquery.ui.datepicker.js\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"1162e333325c0f29abc0a2c667c4bbf8\";}s:86:\"test/wp-content/plugins/advanced-custom-fields/core/fields/date_picker/date_picker.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"8d60da2c1fe5c2a95655c53d3f906839\";}s:71:\"test/wp-content/plugins/advanced-custom-fields/core/fields/checkbox.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"73fb8120a3e4f0f8d5d86e6171f028d7\";}s:74:\"test/wp-content/plugins/advanced-custom-fields/core/fields/post_object.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"b6a8abb49a778cae8adaea1b85ce022a\";}s:68:\"test/wp-content/plugins/advanced-custom-fields/core/fields/_base.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"c5648c5669a0395209c32bf98100e615\";}s:71:\"test/wp-content/plugins/advanced-custom-fields/core/fields/taxonomy.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"08a257553702033aeb92b6ce4112884e\";}s:71:\"test/wp-content/plugins/advanced-custom-fields/core/fields/textarea.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"cd8308ca72277ca0d32f406813b8473a\";}s:69:\"test/wp-content/plugins/advanced-custom-fields/core/fields/number.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"c434d828e07265291fbcb55044510eb7\";}s:73:\"test/wp-content/plugins/advanced-custom-fields/core/fields/_functions.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"4591bbc0d326d3638a6ed14838a6fdd8\";}s:59:\"test/wp-content/plugins/advanced-custom-fields/core/api.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"8282096246d92a4501c28f087c08eab6\";}s:77:\"test/wp-content/plugins/advanced-custom-fields/core/views/meta_box_fields.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"64578e295f9be067b2e95dbf31485f3b\";}s:79:\"test/wp-content/plugins/advanced-custom-fields/core/views/meta_box_location.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"32d9c847e549aab357b17eb071e04002\";}s:78:\"test/wp-content/plugins/advanced-custom-fields/core/views/meta_box_options.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"12e17b5b6b6db932699d00cc4b7ab96d\";}s:70:\"test/wp-content/plugins/advanced-custom-fields/core/actions/export.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"c00316ae7c9404becdffe3b5981f1893\";}s:59:\"test/wp-content/plugins/advanced-custom-fields/lang/acf.pot\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"4e09b04e60400fde7cf12b3dc0f771bc\";}s:56:\"test/wp-content/plugins/advanced-custom-fields/README.md\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"718cfeee95c24a25b9715de50984b9f4\";}s:54:\"test/wp-content/plugins/advanced-custom-fields/acf.php\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"14fd39f45a752613c87c59ef4c1a7b15\";}s:57:\"test/wp-content/plugins/advanced-custom-fields/readme.txt\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"7eda2b4ebc6dfc5cbbd04beb29495635\";}s:70:\"test/wp-content/plugins/advanced-custom-fields/images/wpspin_light.gif\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"67f40a30bfa13743e5c4e86bfa467a90\";}s:73:\"test/wp-content/plugins/advanced-custom-fields/images/wpspin_light@2x.gif\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"450b52bd860e667a0fa3c00b82b58a18\";}s:60:\"test/wp-content/plugins/advanced-custom-fields/css/input.css\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"6b0670407b5b0509da00fe1d711d8bbb\";}s:58:\"test/wp-content/plugins/advanced-custom-fields/css/acf.css\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"54e639565d037178c758298d53457cd8\";}s:61:\"test/wp-content/plugins/advanced-custom-fields/css/global.css\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"227fffa960e0b59688431d2b59180928\";}s:66:\"test/wp-content/plugins/advanced-custom-fields/css/field-group.css\";a:2:{s:1:\"d\";i:1446218582;s:1:\"h\";s:32:\"3059354ee3213e14ee53ba724249e839\";}s:63:\"test/wp-content/plugins/simple-custom-css/simple-custom-css.php\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"3d216cdd91deb98f845c57abbd32fba0\";}s:52:\"test/wp-content/plugins/simple-custom-css/readme.txt\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"2d47523e7cca7de5447376df92d67671\";}s:60:\"test/wp-content/plugins/simple-custom-css/includes/admin.php\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"cb56e320f348cd33dce33fd1c0bd7db2\";}s:61:\"test/wp-content/plugins/simple-custom-css/includes/public.php\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"4072f677e6358dacaa51cde9c998926b\";}s:49:\"test/wp-content/plugins/simple-custom-css/LICENSE\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"b81fc52df02cd6a6d95e6310c951ae95\";}s:67:\"test/wp-content/plugins/simple-custom-css/codemirror/codemirror.css\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"bdbe39e786e581c2cc1bf12d5434c300\";}s:66:\"test/wp-content/plugins/simple-custom-css/codemirror/codemirror.js\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"c1a5548b00ab3cfe256852a5fb20c6da\";}s:59:\"test/wp-content/plugins/simple-custom-css/codemirror/css.js\";a:2:{s:1:\"d\";i:1445066838;s:1:\"h\";s:32:\"5f8380f52c246014d3d5460e7ee35ba8\";}s:43:\"test/wp-content/plugins/revslider/.DS_Store\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"09ce797e800e21714f615a846b3a473c\";}s:61:\"test/wp-content/plugins/revslider/admin/assets/js/tbld-4.3.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"1cc6e180a3f94d249bb50edb69559f3e\";}s:64:\"test/wp-content/plugins/revslider/admin/assets/js/edit_layers.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"418a3ad87ba9b9afb4686f828ab447a4\";}s:57:\"test/wp-content/plugins/revslider/admin/assets/js/tbld.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"79289846b12aa3f54477802dc7057892\";}s:73:\"test/wp-content/plugins/revslider/admin/assets/js/edit_layers_timeline.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"178c26e4dbf7750bb68bd1debea47781\";}s:61:\"test/wp-content/plugins/revslider/admin/assets/js/newvideo.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"552b2e9071cce507447b6d76f999d7b0\";}s:61:\"test/wp-content/plugins/revslider/admin/assets/js/oldvideo.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"bcd22b4c1e6a1d93b0e80d6a0920996e\";}s:61:\"test/wp-content/plugins/revslider/admin/assets/js/tbld-3.9.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"cd0ff7bee751a86900d61f618d6ea5dd\";}s:63:\"test/wp-content/plugins/revslider/admin/assets/js/css_editor.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"eaf864eb2c40d96d1663e1e5f66ecf83\";}s:58:\"test/wp-content/plugins/revslider/admin/assets/js/admin.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e72b4fc56faeb982d64c7723c3c3c1cb\";}s:61:\"test/wp-content/plugins/revslider/admin/assets/js/settings.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"50b08946b4b3e8058250fd7aed4477d0\";}s:65:\"test/wp-content/plugins/revslider/admin/assets/js/jquery.tipsy.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"5a4f11bec90d01c15b537ccff6d9f1d7\";}s:59:\"test/wp-content/plugins/revslider/admin/assets/js/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:67:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/xml.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"4304a1cbddb1f976e42893f59de690a1\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/loadmode.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e9082cfbad2713724646c44e7afcf177\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/closetag.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a379e22ef4f9da609b7a04503e4d1b75\";}s:86:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/match-highlighter.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"96ecd377fc615660e47a8d427857ddc1\";}s:80:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/simple-hint.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"53d28d8109faf1740c237a3eff1cafcb\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/pig-hint.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"061691a4eb0b93e8ef9f1dfa571995e7\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/foldcode.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e673a41ba4f1540070f13b8ad86b4164\";}s:79:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/formatting.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"6a8b25e8a084135c83d90b77258e9c64\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/dialog.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"1883f8872dfd4f75f08c17d055f32134\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/dialog.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"b77cdba4fbece47b4924ed1861013c71\";}s:87:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/runmode-standalone.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a0efd2e9f150da30457624a3f7067947\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/search.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a0953841015f8567a90985a873429cf9\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/searchcursor.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"ae64a29e4e6046b5dcbcddd6df2c35fa\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/simple-hint.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"55a5102f1b82825aa13530eb6f037d04\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/xml-hint.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a0561c068a9ed936aead92563a911d6d\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/overlay.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"240c5026842d9bce7fbdf4abc6088a6a\";}s:84:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/javascript-hint.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"2533dc0b779d154e8f3144ae1901a04d\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/runmode.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"5c5eb7d1f7b0193315b0128077e7c5e7\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/util/multiplex.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"35131d08d564597bc9f9548361ad3e2f\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/codemirror.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e3417a4d21c098485fc9e9a6af55d5e0\";}s:74:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/codemirror.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"81682a84405442f32b7365b1d1a414f2\";}s:70:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:67:\"test/wp-content/plugins/revslider/admin/assets/js/codemirror/css.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"66179d3c258cddc45929e0d22bffde5e\";}s:62:\"test/wp-content/plugins/revslider/admin/assets/js/rev_admin.js\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"0ffb3a7ec2a431a44a7307b34179d2cc\";}s:56:\"test/wp-content/plugins/revslider/admin/assets/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"03efe17b1c4a21753f7d07ee17e77395\";}s:83:\"test/wp-content/plugins/revslider/admin/assets/imports/highlight-carousel/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/imports/contenttabs/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:74:\"test/wp-content/plugins/revslider/admin/assets/imports/news-hero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/imports/twitter-feed/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:80:\"test/wp-content/plugins/revslider/admin/assets/imports/webproductlight/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/imports/mainfeature/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:83:\"test/wp-content/plugins/revslider/admin/assets/imports/highlight-showcase/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:88:\"test/wp-content/plugins/revslider/admin/assets/imports/news-gallery-post-based/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:79:\"test/wp-content/plugins/revslider/admin/assets/imports/flickr-gallery/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/imports/sportshero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:68:\"test/wp-content/plugins/revslider/admin/assets/imports/gym/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/imports/facebook-feed/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/imports/classic-carousel/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/imports/notgeneric/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/imports/insta-gallery/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/imports/photography/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:84:\"test/wp-content/plugins/revslider/admin/assets/imports/levanorestaurantbar/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:80:\"test/wp-content/plugins/revslider/admin/assets/imports/newsletter-hero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:76:\"test/wp-content/plugins/revslider/admin/assets/imports/youtubehero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:87:\"test/wp-content/plugins/revslider/admin/assets/imports/web-product-light-hero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/imports/classicslider/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/imports/search-form-hero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:88:\"test/wp-content/plugins/revslider/admin/assets/imports/media-carousel-autoplay/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:74:\"test/wp-content/plugins/revslider/admin/assets/imports/imagehero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/imports/web-product-dark/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:81:\"test/wp-content/plugins/revslider/admin/assets/imports/showcasecarousel/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:86:\"test/wp-content/plugins/revslider/admin/assets/imports/web-product-dark-hero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:64:\"test/wp-content/plugins/revslider/admin/assets/imports/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/imports/vimeo-gallery/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/imports/news-bg-video/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:72:\"test/wp-content/plugins/revslider/admin/assets/imports/fashion/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:74:\"test/wp-content/plugins/revslider/admin/assets/imports/vimeohero/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:82:\"test/wp-content/plugins/revslider/admin/assets/imports/media-gallery-two/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:85:\"test/wp-content/plugins/revslider/admin/assets/imports/photography-carousel/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/imports/news-video/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/imports/news-gallery/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:80:\"test/wp-content/plugins/revslider/admin/assets/imports/youtube-gallery/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:72:\"test/wp-content/plugins/revslider/admin/assets/images/tooltips/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/images/slidersources/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:77:\"test/wp-content/plugins/revslider/admin/assets/images/sliderpresets/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:63:\"test/wp-content/plugins/revslider/admin/assets/images/tipsy.gif\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"84c683bb61e04eed786306a59ae8cbf5\";}s:71:\"test/wp-content/plugins/revslider/admin/assets/images/toolbar/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:71:\"test/wp-content/plugins/revslider/admin/assets/images/sources/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:72:\"test/wp-content/plugins/revslider/admin/assets/images/sources/notice.txt\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a6e5630563c9e2f6edf2e26e546d3f0f\";}s:80:\"test/wp-content/plugins/revslider/admin/assets/images/navigationeditor/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:78:\"test/wp-content/plugins/revslider/admin/assets/images/sliderselector/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/admin/assets/images/mainoptions/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:63:\"test/wp-content/plugins/revslider/admin/assets/images/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:64:\"test/wp-content/plugins/revslider/admin/assets/images/loader.gif\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"cf46f7db4c452ea2a94d33eabca8ba93\";}s:60:\"test/wp-content/plugins/revslider/admin/assets/css/tipsy.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"c34c8131ee3d5cb6f501e109aba2a521\";}s:66:\"test/wp-content/plugins/revslider/admin/assets/css/font/egfont.ttf\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e424d23cebd02d4d0540f5512b6c6b27\";}s:66:\"test/wp-content/plugins/revslider/admin/assets/css/font/egfont.eot\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"7984e569c52953b66336cae93405f80b\";}s:67:\"test/wp-content/plugins/revslider/admin/assets/css/font/egfont.woff\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"247b82360d5b852302c873313cd3cfca\";}s:65:\"test/wp-content/plugins/revslider/admin/assets/css/font/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:66:\"test/wp-content/plugins/revslider/admin/assets/css/font/egfont.svg\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"4db56e156255fcef2e959d0d4a001508\";}s:60:\"test/wp-content/plugins/revslider/admin/assets/css/admin.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"cc66c1b39fca24bc25cc17e7ac6f33b2\";}s:66:\"test/wp-content/plugins/revslider/admin/assets/css/edit_layers.css\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d5b227a9f6e5c95e772df1a5241e1cce\";}s:60:\"test/wp-content/plugins/revslider/admin/assets/css/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:65:\"test/wp-content/plugins/revslider/admin/revslider-admin.class.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"bbc6e11abaec54da093a8cd49a89acb8\";}s:62:\"test/wp-content/plugins/revslider/admin/views/slide-editor.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"5bf3dc673f1879683afbd5b3224b50bf\";}s:79:\"test/wp-content/plugins/revslider/admin/views/system/dialog-global-settings.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d9b02edb1c382d67d45d7ef1a0d4b876\";}s:73:\"test/wp-content/plugins/revslider/admin/views/system/dialog-copy-move.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"3fb647a14a416cc342cfa169b090772e\";}s:69:\"test/wp-content/plugins/revslider/admin/views/system/dialog-video.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"e011c9b7e89ceddef0a87d092ad30538\";}s:62:\"test/wp-content/plugins/revslider/admin/views/system/index.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:67:\"test/wp-content/plugins/revslider/admin/views/system/validation.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"f41f661177d4ad39a2581b4941942491\";}s:65:\"test/wp-content/plugins/revslider/admin/views/slider-overview.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"a01667764ef34de92ac6ecac7e97b8c6\";}s:63:\"test/wp-content/plugins/revslider/admin/views/slider-editor.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"8563e838efac2e8d4bb46473cbbeafb5\";}s:74:\"test/wp-content/plugins/revslider/admin/views/templates/slide-selector.php\";a:2:{s:1:\"d\";i:1446219102;s:1:\"h\";s:32:\"53922a7660dd64093c2680c099a75da1\";}s:79:\"test/wp-content/plugins/revslider/admin/views/templates/slider-main-options.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"4d36f8901932e90028dbb0ab4cede01a\";}s:73:\"test/wp-content/plugins/revslider/admin/views/templates/wpml-selector.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"9e5caffd177a3a3e82e65cc3dc4a59ad\";}s:66:\"test/wp-content/plugins/revslider/admin/views/templates/slides.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"6561f6601333d72cedd5a012990c5257\";}s:71:\"test/wp-content/plugins/revslider/admin/views/templates/slides-list.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"bc5f70ab06ea446e68a2d87a997ca6ef\";}s:72:\"test/wp-content/plugins/revslider/admin/views/templates/sliders-list.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1f8161979a8b1e4046663e408639215d\";}s:73:\"test/wp-content/plugins/revslider/admin/views/templates/create-slider.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"3ccd4083d279d4b0cbdfb42aa5cfa41d\";}s:77:\"test/wp-content/plugins/revslider/admin/views/templates/template-selector.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"5caa731761406f20bd39102f01da7dbe\";}s:82:\"test/wp-content/plugins/revslider/admin/views/templates/slide-general-settings.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1a50140e9a5c47b0e83de1277a888d27\";}s:84:\"test/wp-content/plugins/revslider/admin/views/templates/template-slider-selector.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"78df6800433748bcbb05d49d76afeb8b\";}s:65:\"test/wp-content/plugins/revslider/admin/views/templates/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:71:\"test/wp-content/plugins/revslider/admin/views/templates/slide-stage.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"ac2669df986dbfbf01a1184e5b846f08\";}s:71:\"test/wp-content/plugins/revslider/admin/views/templates/edit-slider.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"601bd44464161207cddbd593dd1e2990\";}s:64:\"test/wp-content/plugins/revslider/admin/views/slide-overview.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b32724aa9c3bf7be0136d3d198ecfc59\";}s:55:\"test/wp-content/plugins/revslider/admin/views/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:67:\"test/wp-content/plugins/revslider/admin/views/navigation-editor.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1104b60bf0a8440253568d7fa7baece7\";}s:61:\"test/wp-content/plugins/revslider/admin/views/master-view.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"c284f191f852183a1fbd966a1599ad6d\";}s:49:\"test/wp-content/plugins/revslider/admin/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"03efe17b1c4a21753f7d07ee17e77395\";}s:50:\"test/wp-content/plugins/revslider/backup/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:47:\"test/wp-content/plugins/revslider/revslider.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"aa7c869db43aa1b789491122897387fe\";}s:57:\"test/wp-content/plugins/revslider/languages/revslider.pot\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"22b9fd74c1f329e4d4183f228e011780\";}s:53:\"test/wp-content/plugins/revslider/languages/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:47:\"test/wp-content/plugins/revslider/uninstall.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b6afcf66151560ae6db477c652dc5bb8\";}s:63:\"test/wp-content/plugins/revslider/includes/operations.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1baf8ad3fc9321c508ec4d3c2663f347\";}s:59:\"test/wp-content/plugins/revslider/includes/slider.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"9769eb83137eb78057130a6ed3a226c4\";}s:62:\"test/wp-content/plugins/revslider/includes/extension.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"3c0f52fa30bad2cd123e7c29082eafb9\";}s:59:\"test/wp-content/plugins/revslider/includes/output.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"39d7d85976ca9d84595600bb4999030b\";}s:60:\"test/wp-content/plugins/revslider/includes/tinybox.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7fab7e67c0f5d661bfce869cf461fd3a\";}s:60:\"test/wp-content/plugins/revslider/includes/globals.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"4ef20d62e090fcc6d7561d894eb67df6\";}s:58:\"test/wp-content/plugins/revslider/includes/slide.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"c12c41c538cd443424ef66e2a8cc58af\";}s:52:\"test/wp-content/plugins/revslider/includes/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:63:\"test/wp-content/plugins/revslider/includes/navigation.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"6285d56a538de6f7a185ec4cf2f42903\";}s:69:\"test/wp-content/plugins/revslider/includes/external-sources.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7039f04e1ea7bb1ae332426e3e32e6b9\";}s:61:\"test/wp-content/plugins/revslider/includes/template.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"f4f1e465fb92d65375b5f002804ea21d\";}s:73:\"test/wp-content/plugins/revslider/includes/framework/base-front.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"052acd746e0438dea7c248fb09152cc5\";}s:65:\"test/wp-content/plugins/revslider/includes/framework/db.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"40cde0007eead0d2e296bb1117e39c2e\";}s:77:\"test/wp-content/plugins/revslider/includes/framework/em-integration.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"4fac68d93ed3cedd2f43f59bae4d585d\";}s:73:\"test/wp-content/plugins/revslider/includes/framework/newsletter.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"fb755ac4886f6db0e54281b16b2a6158\";}s:72:\"test/wp-content/plugins/revslider/includes/framework/functions.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"a0dce70c856e953557c3695822540e0b\";}s:82:\"test/wp-content/plugins/revslider/includes/framework/functions-wordpress.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"a21138bc331f9fd00e6e12972f53a978\";}s:74:\"test/wp-content/plugins/revslider/includes/framework/include-framework.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"a712d1256abbba7fc31a0c2e7ec10795\";}s:67:\"test/wp-content/plugins/revslider/includes/framework/base.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"52e697f7d981ae4c7a9c1f3ef435eb82\";}s:73:\"test/wp-content/plugins/revslider/includes/framework/aq-resizer.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b6ab2e8773e68ec9f4c3aa5c98db96bf\";}s:76:\"test/wp-content/plugins/revslider/includes/framework/plugin-update.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"ab932db6c0aad763c38356c3ed298e12\";}s:62:\"test/wp-content/plugins/revslider/includes/framework/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:69:\"test/wp-content/plugins/revslider/includes/framework/update.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"2c23ccde9a9fbafddc637d500f5117a2\";}s:67:\"test/wp-content/plugins/revslider/includes/framework/wpml.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"9b53e8dba02f8854da6a4353bfcecd30\";}s:76:\"test/wp-content/plugins/revslider/includes/framework/elements-base.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"0f7ebe4e027de4638c09dfcc88370ae3\";}s:73:\"test/wp-content/plugins/revslider/includes/framework/base-admin.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b0e32e408d481b4be4c68efc57873656\";}s:72:\"test/wp-content/plugins/revslider/includes/framework/cssparser.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b6c8cbfedcc5d77169891ecd12f6dff5\";}s:59:\"test/wp-content/plugins/revslider/includes/widget.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"8cc1d66a5e66647d2762ca351fe278e8\";}s:50:\"test/wp-content/plugins/revslider/release_log.html\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"657900d492b4f552b8dc2cb491cdb7c3\";}s:43:\"test/wp-content/plugins/revslider/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:86:\"test/wp-content/plugins/revslider/public/assets/js/jquery.themepunch.revolution.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"bc7789223ef787e1900cd4c614db79b8\";}s:97:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.actions.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"aed6ce21a17f74857cf1155a587e07b2\";}s:97:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.kenburn.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"68fa29e120fab9f8baae3fc4a0a838c0\";}s:95:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.video.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7e07415726a232c0cc13a11d87bf3410\";}s:99:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.migration.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1bc0afe87ebb386ddd818a2ac2a8a11a\";}s:100:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.navigation.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"0acc8d54c5b33103461b3ef93ac4e90e\";}s:98:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.parallax.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"caded4766e51cef0e08cb3e9ef34ae38\";}s:71:\"test/wp-content/plugins/revslider/public/assets/js/extensions/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:100:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.slideanims.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"95951f84aef59662e878dfa0860de9e8\";}s:104:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.layeranimation.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"e4d00445e5f6b86d3a8d6439520ebd72\";}s:98:\"test/wp-content/plugins/revslider/public/assets/js/extensions/revolution.extension.carousel.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"ab09799092cd0e9332540a60cd2bcedd\";}s:100:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.kenburn.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7f479ecfa01035d8046a769d48af064a\";}s:101:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.parallax.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"2bad8b9c0bbfa01261efd8a5d61fdc0b\";}s:103:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.navigation.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"f654abdffc06d083c22a67aec7b99c9a\";}s:98:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.video.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"8a69017d598bcc3dc3ae34d7340fca1e\";}s:100:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.actions.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"723f405faaae50a136b9a459f4bf0a39\";}s:107:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.layeranimation.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"6d3f1622b4badbe77bd5eef53e048ed8\";}s:78:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:101:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.carousel.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"2a31acef8bc07de17c38cb1d68484090\";}s:103:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.slideanims.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b6bdba24320253da8ca1df7b3bdceee2\";}s:102:\"test/wp-content/plugins/revslider/public/assets/js/extensions/source/revolution.extension.migration.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"e3c7e003a510c7cd3dd33b0c3f5a34be\";}s:81:\"test/wp-content/plugins/revslider/public/assets/js/jquery.themepunch.tools.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"305282342a8d6846232ee2dc18a08227\";}s:60:\"test/wp-content/plugins/revslider/public/assets/js/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:81:\"test/wp-content/plugins/revslider/public/assets/js/jquery.themepunch.enablelog.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"f846c7bfef1815dc6f91c9c392336b9e\";}s:88:\"test/wp-content/plugins/revslider/public/assets/js/source/jquery.themepunch.tools.min.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"eb86ca01626fb5a6a4c3aaaace2c7c19\";}s:89:\"test/wp-content/plugins/revslider/public/assets/js/source/jquery.themepunch.revolution.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"a277f3acb1c833ff1e373918a90d6b08\";}s:67:\"test/wp-content/plugins/revslider/public/assets/js/source/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:88:\"test/wp-content/plugins/revslider/public/assets/js/source/jquery.themepunch.enablelog.js\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"f846c7bfef1815dc6f91c9c392336b9e\";}s:72:\"test/wp-content/plugins/revslider/public/assets/assets/sources/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:64:\"test/wp-content/plugins/revslider/public/assets/assets/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:65:\"test/wp-content/plugins/revslider/public/assets/assets/loader.gif\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"4b3afb84b2b71ef56df09997a350bd04\";}s:96:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"c4668ed2440df82d3fd2f8be9d31d07d\";}s:88:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"19231917733e2bcdf257c9be99cdbaf1\";}s:97:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d95d6f5d5ab7cfefd09651800b69bd54\";}s:96:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"26efb89ed5261b9be06bf30c659fbc75\";}s:82:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:96:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7149833697a959306ec3012a8588dcfa\";}s:76:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:91:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"ed05bfd415df47c95c9f655b7a1fc6d4\";}s:87:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/css/font-awesome.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"acc72fba39ff411dc6e9443d13998567\";}s:80:\"test/wp-content/plugins/revslider/public/assets/fonts/font-awesome/css/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/public/assets/fonts/revicons/revicons.eot\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"2feb69ccb596730c72920c6ba3e37ef8\";}s:75:\"test/wp-content/plugins/revslider/public/assets/fonts/revicons/revicons.ttf\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"17629a5dfe0d3c3946cf401e1895f091\";}s:76:\"test/wp-content/plugins/revslider/public/assets/fonts/revicons/revicons.woff\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"04eb8fc57f27498e5ae37523e3bfb2c7\";}s:72:\"test/wp-content/plugins/revslider/public/assets/fonts/revicons/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:75:\"test/wp-content/plugins/revslider/public/assets/fonts/revicons/revicons.svg\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"1142a254da20b59e7d10ac39e78c4fbf\";}s:63:\"test/wp-content/plugins/revslider/public/assets/fonts/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:97:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.ttf\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"01798bc13e33afc36a52f2826638d386\";}s:97:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.eot\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"71394c0c7ad6c1e7d5c77e8ac292fba5\";}s:97:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.svg\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"dedf26989fdd78c33cb9ae664a604d6c\";}s:98:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/fonts/Pe-icon-7-stroke.woff\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b38ef310874bdd008ac14ef3db939032\";}s:86:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/fonts/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:80:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:95:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"bef1263df0f939c21c4810509b7f268e\";}s:84:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/css/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:85:\"test/wp-content/plugins/revslider/public/assets/fonts/pe-icon-7-stroke/css/helper.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"90b5a0d5b6499dfbc25fe868533b2b3b\";}s:57:\"test/wp-content/plugins/revslider/public/assets/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:64:\"test/wp-content/plugins/revslider/public/assets/css/openhand.cur\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"b06c243f534d9c5461d16528156cd5a8\";}s:66:\"test/wp-content/plugins/revslider/public/assets/css/closedhand.cur\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"a8c874b93b3d848f39a71260c57e3863\";}s:64:\"test/wp-content/plugins/revslider/public/assets/css/settings.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"fffe0414fbf7e20d184c8003a01882b2\";}s:73:\"test/wp-content/plugins/revslider/public/assets/css/captions-original.css\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"7a65ff5a76f6daed83bd54721366c4c1\";}s:61:\"test/wp-content/plugins/revslider/public/assets/css/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:50:\"test/wp-content/plugins/revslider/public/index.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:66:\"test/wp-content/plugins/revslider/public/revslider-front.class.php\";a:2:{s:1:\"d\";i:1446219103;s:1:\"h\";s:32:\"46686c2455b48da448a91657418b03bd\";}s:51:\"test/wp-content/plugins/contact-form-7/settings.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"604bc2e242d08abd2dbcd39997e72aa9\";}s:55:\"test/wp-content/plugins/contact-form-7/modules/date.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"5aff600ebeaefde4de88715d776395de\";}s:57:\"test/wp-content/plugins/contact-form-7/modules/submit.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"294287dfca790843328ff550a7d34aeb\";}s:55:\"test/wp-content/plugins/contact-form-7/modules/text.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"a5c6959f9e6e47c5d9a60fb75c909e55\";}s:57:\"test/wp-content/plugins/contact-form-7/modules/select.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"e6f24db78e92bf060067c7f5758efb82\";}s:55:\"test/wp-content/plugins/contact-form-7/modules/file.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"5ee439cc0469434ffe19015a0913df7e\";}s:72:\"test/wp-content/plugins/contact-form-7/modules/really-simple-captcha.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"e676c4da3d4715dfab59c00b3ebca3a5\";}s:59:\"test/wp-content/plugins/contact-form-7/modules/response.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"e554c2087e630d735c702e44602f4a54\";}s:58:\"test/wp-content/plugins/contact-form-7/modules/akismet.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"48168b156c2cc22dfaa27dd8c2b1b792\";}s:61:\"test/wp-content/plugins/contact-form-7/modules/acceptance.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"ff9729e446bcebb73944f2e1fa9f90bb\";}s:59:\"test/wp-content/plugins/contact-form-7/modules/flamingo.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"f6d22b593ec62f46775ca168f3420d4a\";}s:56:\"test/wp-content/plugins/contact-form-7/modules/listo.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"d775cb97fc17c5af8cea7c043a5a0790\";}s:60:\"test/wp-content/plugins/contact-form-7/modules/recaptcha.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"5b7256f4c51753c5144188f31e113795\";}s:59:\"test/wp-content/plugins/contact-form-7/modules/checkbox.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"a84bb6a56e59a7833de49967d34705fd\";}s:56:\"test/wp-content/plugins/contact-form-7/modules/count.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"3e9619295b1ee6db956f7f41f4e4f962\";}s:55:\"test/wp-content/plugins/contact-form-7/modules/quiz.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"edad491e2e4449bb1c94e57f90d7bab7\";}s:58:\"test/wp-content/plugins/contact-form-7/modules/jetpack.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"dee51308eba4638bee726b9c6f880e21\";}s:59:\"test/wp-content/plugins/contact-form-7/modules/textarea.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"9e98eab20fff39104511adaafdf804ee\";}s:57:\"test/wp-content/plugins/contact-form-7/modules/number.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"d06212d889496e10c77d7382788fdbf5\";}s:64:\"test/wp-content/plugins/contact-form-7/admin/js/tag-generator.js\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"6780af261037722a42772be17bb07e70\";}s:58:\"test/wp-content/plugins/contact-form-7/admin/js/scripts.js\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"a0bd9c1336ac95cc4d308bef46848113\";}s:66:\"test/wp-content/plugins/contact-form-7/admin/edit-contact-form.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"8a71a751c4b04a6c1eb48c748f1f8389\";}s:54:\"test/wp-content/plugins/contact-form-7/admin/admin.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"afbf8edbf6db001d7c1d926ddabfb73b\";}s:88:\"test/wp-content/plugins/contact-form-7/admin/includes/class-contact-forms-list-table.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"d25f061d580a3290b050a7c10baccf9b\";}s:64:\"test/wp-content/plugins/contact-form-7/admin/includes/editor.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"569c56cbcfdb7205d08ffe8c3efa2cb2\";}s:71:\"test/wp-content/plugins/contact-form-7/admin/includes/tag-generator.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"572aaaf7737047bb4ffff77dc1147032\";}s:73:\"test/wp-content/plugins/contact-form-7/admin/includes/admin-functions.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"8467c731c1d5c2fef02209b83671fa6b\";}s:67:\"test/wp-content/plugins/contact-form-7/admin/includes/help-tabs.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"932db0a8e00ef989501626984479be18\";}s:59:\"test/wp-content/plugins/contact-form-7/admin/css/styles.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"84d52febe9ddd06eeac4e045fa181507\";}s:63:\"test/wp-content/plugins/contact-form-7/admin/css/styles-rtl.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"a72a2e00b8117311e60fc4c7b13b6320\";}s:67:\"test/wp-content/plugins/contact-form-7/languages/contact-form-7.pot\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"6b97e162e3349537f459b64363de36a9\";}s:59:\"test/wp-content/plugins/contact-form-7/languages/readme.txt\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"0b6e2d40f9d96ce84049fe4495aa54c3\";}s:49:\"test/wp-content/plugins/contact-form-7/readme.txt\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"742ca7284ca7f17be610af2184ea39ef\";}s:52:\"test/wp-content/plugins/contact-form-7/uninstall.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"61be2af9e9463a04d3140773e39e7bee\";}s:60:\"test/wp-content/plugins/contact-form-7/wp-contact-form-7.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"4e4f9ad1af14fa1516686de05aa4ab43\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/formatting.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"8aa10a3689fcf8fcee01beaaeaadef9e\";}s:92:\"test/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery-ui.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"d172b560b073f3bc42fea160bbff96a2\";}s:96:\"test/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery-ui.min.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"60f0405edd95e7135ec6a0bbc36d1385\";}s:98:\"test/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/jquery.ui.theme.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"2c238464ee5deea4320eada193f15378\";}s:106:\"test/wp-content/plugins/contact-form-7/includes/js/jquery-ui/themes/smoothness/images/animated-overlay.gif\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"2b912f7c0653008ca28ebacda49025e7\";}s:61:\"test/wp-content/plugins/contact-form-7/includes/js/scripts.js\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"c455310236d441a123ed0b5a97d6f2e0\";}s:65:\"test/wp-content/plugins/contact-form-7/includes/js/jquery.form.js\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"08a24670beb2eae7ef79a6d5ac23874b\";}s:69:\"test/wp-content/plugins/contact-form-7/includes/js/jquery.form.min.js\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"f448c593c242d134e9733a84c7a4d26c\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/submission.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"3c72a527b1fc088bbf2c82a395049c66\";}s:64:\"test/wp-content/plugins/contact-form-7/includes/contact-form.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"7e501e61aa69001aa78afd9c2b00c48a\";}s:73:\"test/wp-content/plugins/contact-form-7/includes/contact-form-template.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"9fed2b7b7d2f0ac45980b36f2d417a82\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/shortcodes.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"945b16ee205719d93ccc4e34b720b36c\";}s:56:\"test/wp-content/plugins/contact-form-7/includes/mail.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"e0823ee9992239da4fb24175e1e6690a\";}s:63:\"test/wp-content/plugins/contact-form-7/includes/integration.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"1f42492673a6dfc41061d06f38478cc6\";}s:64:\"test/wp-content/plugins/contact-form-7/includes/capabilities.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"6484f207c2029b129c53d1e09b3cb59f\";}s:56:\"test/wp-content/plugins/contact-form-7/includes/pipe.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"2ee6fd182c42107fb3efdbdf777b8a93\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/validation.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"b8b09285f6f97d37bccf124aea121904\";}s:61:\"test/wp-content/plugins/contact-form-7/includes/functions.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"93646c3810125f3d8188c2a03b7e93a7\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/controller.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"d07436780a2fae055d6e7be37548d057\";}s:62:\"test/wp-content/plugins/contact-form-7/includes/css/styles.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"febbda4768d2fa237c794ce80866d7a7\";}s:66:\"test/wp-content/plugins/contact-form-7/includes/css/styles-rtl.css\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"515d4bdbca19494847b979264c3d39e2\";}s:59:\"test/wp-content/plugins/contact-form-7/includes/upgrade.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"af77155353989ce7a325c634490ea4b5\";}s:56:\"test/wp-content/plugins/contact-form-7/includes/l10n.php\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"453fe50caddb7f82382c3bbe8c1710b3\";}s:50:\"test/wp-content/plugins/contact-form-7/license.txt\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"aafc3fcdda162b256ec04e64cf2d3f69\";}s:61:\"test/wp-content/plugins/contact-form-7/images/ajax-loader.gif\";a:2:{s:1:\"d\";i:1446218587;s:1:\"h\";s:32:\"af962b37779a443a77ab836b3b7a93f5\";}s:33:\"test/wp-content/plugins/index.php\";a:2:{s:1:\"d\";i:1439342082;s:1:\"h\";s:32:\"67442c5615eba73d105c0715c6620850\";}s:53:\"test/wp-content/plugins/surbma-font-awesome/README.md\";a:2:{s:1:\"d\";i:1446031333;s:1:\"h\";s:32:\"807af21de46f0b7f6e308967dc0fda6c\";}s:77:\"test/wp-content/plugins/surbma-font-awesome/languages/surbma-font-awesome.pot\";a:2:{s:1:\"d\";i:1446031333;s:1:\"h\";s:32:\"88edfb3d5826ed7991dafb49b5f6725a\";}s:54:\"test/wp-content/plugins/surbma-font-awesome/readme.txt\";a:2:{s:1:\"d\";i:1446031333;s:1:\"h\";s:32:\"795223f7ca2e80d6e19ff768ea5d60d5\";}s:67:\"test/wp-content/plugins/surbma-font-awesome/surbma-font-awesome.php\";a:2:{s:1:\"d\";i:1446031333;s:1:\"h\";s:32:\"87c72ea7600cc9dec79980349bcc3848\";}s:73:\"test/wp-content/plugins/js_composer/config/shortcode-vc-tta-accordion.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9331b0fef464de370d340eebd7ca2de0\";}s:72:\"test/wp-content/plugins/js_composer/config/shortcode-vc-icon-element.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0be46396225eed90ca15396201d55940\";}s:68:\"test/wp-content/plugins/js_composer/config/shortcode-vc-tta-tabs.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bb715773b3dc75fa930e61edfec2d0ab\";}s:71:\"test/wp-content/plugins/js_composer/config/shortcode-vc-tta-section.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a0b22500501dbaad2e2d739ba29c7096\";}s:63:\"test/wp-content/plugins/js_composer/config/shortcode-vc-btn.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"033efcb5131bcd320de2e4782e5a1e90\";}s:72:\"test/wp-content/plugins/js_composer/config/shortcode-vc-tta-pageable.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"92f661c0b2ba47353538f3772d8b1938\";}s:50:\"test/wp-content/plugins/js_composer/config/map.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"53d3376a0a5d986e7e4937151691687d\";}s:64:\"test/wp-content/plugins/js_composer/config/shortcode-vc-cta3.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"79f537c4bac3f90329ea629ba8486466\";}s:68:\"test/wp-content/plugins/js_composer/config/shortcode-vc-tta-tour.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c8ed77ff4561c650e2be15a0cd7db85b\";}s:56:\"test/wp-content/plugins/js_composer/config/templates.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"24de55de3949d3234d8e49791a80e7bf\";}s:47:\"test/wp-content/plugins/js_composer/credits.txt\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"628691bedd05b8c6819e0428eef9210f\";}s:55:\"test/wp-content/plugins/js_composer/vendor/autoload.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fa9ded4a9eeaa96ab9201cab48cdc8f5\";}s:81:\"test/wp-content/plugins/js_composer/vendor/mmihey/PHP-Instagram-effects/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3a598dc82487ed40b6d4c9a56314ad9e\";}s:79:\"test/wp-content/plugins/js_composer/vendor/mmihey/PHP-Instagram-effects/LICENCE\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4e2402b6f7290e689516af939f140ca8\";}s:92:\"test/wp-content/plugins/js_composer/vendor/mmihey/PHP-Instagram-effects/src/Image/Filter.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7c5e04da497a49bde883613f3423ef8f\";}s:75:\"test/wp-content/plugins/js_composer/vendor/composer/autoload_namespaces.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6c1eacac0fe1dfddc9b557fb73c8cf44\";}s:66:\"test/wp-content/plugins/js_composer/vendor/composer/installed.json\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"95897824a20dced5b8d5a8fd284acebf\";}s:69:\"test/wp-content/plugins/js_composer/vendor/composer/autoload_real.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"02551ecad696baed58617c2e95ef869a\";}s:69:\"test/wp-content/plugins/js_composer/vendor/composer/autoload_psr4.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd3a00f0d13eb29781edd8c77d4c5100\";}s:67:\"test/wp-content/plugins/js_composer/vendor/composer/ClassLoader.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"34d839144753232357cd717d22a9aa90\";}s:73:\"test/wp-content/plugins/js_composer/vendor/composer/autoload_classmap.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8645d3a4e3ad87e7cf4d88a46717aab4\";}s:56:\"test/wp-content/plugins/js_composer/vc_classmap.json.php\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f6262ceb14744c1027f15717baa10403\";}s:53:\"test/wp-content/plugins/js_composer/locale/readme.txt\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"716914002a6f3c08c6b3789d2038e505\";}s:66:\"test/wp-content/plugins/js_composer/assets/js/js_composer_front.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c94219190cca282f3f992ad4539ef51a\";}s:77:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/custom_views.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0e18681cd1a96c8573373f8f95c82623\";}s:83:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/shortcodes_builder.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"80bf34ef451b8a26134f410b43876f0d\";}s:81:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/vc_page_editable.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"df26fc6df165502a5faad5d40918ed60\";}s:70:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/build.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cf356f895efaf9b3c9413d98a42c59b3\";}s:89:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/vendors/plugins/jwplayer.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c070915e33399785ab0f923a0d5ec5e3\";}s:80:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/frontend_editor.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8ffa327b7a853ffa5c576d6d0f85c9d6\";}s:71:\"test/wp-content/plugins/js_composer/assets/js/frontend_editor/models.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b0b12d304921061045d13230d1a6b7ac\";}s:87:\"test/wp-content/plugins/js_composer/assets/js/lib/vc-pointers/vc-pointers-controller.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5faa0b2473f2b1ac6cb02a8f5a6fbf10\";}s:73:\"test/wp-content/plugins/js_composer/assets/js/lib/vc-pointers/pointers.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5241be737f34313839da3faf79529a61\";}s:83:\"test/wp-content/plugins/js_composer/assets/js/lib/vc-pointers/vc-pointer-message.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"021e36190501823f249f9309798e4d89\";}s:63:\"test/wp-content/plugins/js_composer/assets/js/lib/deprecated.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2d621cce7ad4314c9c9de87d676434e4\";}s:59:\"test/wp-content/plugins/js_composer/assets/js/lib/events.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e811409348de374aaa1e2ba794bcd1d0\";}s:60:\"test/wp-content/plugins/js_composer/assets/js/lib/vc_less.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2801e638a9f2eba95aa9bf594a6dd050\";}s:63:\"test/wp-content/plugins/js_composer/assets/js/editors/panels.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"24e828af5cb20632e36c3666f4e10bcd\";}s:82:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-panel-row-layout.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"29f75d809e025c90e72d3fc17e034f59\";}s:83:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-helper-panel-tabs.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f92a66733819517ed3d71c4b2628aba8\";}s:81:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-extend-backbone.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b4409e2d32dc6005e12eca44e6375731\";}s:85:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-panel-post-settings.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c75a8fb5ea7cc8952ec1e975751c596c\";}s:97:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-helper-panel-view-header-footer.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f47a30f43e19b06f2e582b92dad15431\";}s:83:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-panel-add-element.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1f47bd976933a70d5b6ea73164c96f0e\";}s:93:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-helper-panel-view-draggable.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ea21fac82e5405f951794d58fafacb01\";}s:84:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-panel-edit-element.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bfd73fe5595d2fdb038488e8ebd378e4\";}s:87:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-panel-template-window.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"78ad06b1749e23029698fd108b545ad1\";}s:75:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-tabs-line.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"15588e4c6fdb248e783f93d459521605\";}s:93:\"test/wp-content/plugins/js_composer/assets/js/editors/ui/vc_ui-helper-panel-view-resizable.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2a788d5d4a0dffb3cc091a29e8966efc\";}s:75:\"test/wp-content/plugins/js_composer/assets/js/vendors/qtranslate_backend.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"70623ad7ef9b13ed53872a8b5c1d022f\";}s:79:\"test/wp-content/plugins/js_composer/assets/js/vendors/advanced_custom_fields.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3b67aae8c9a681c257fbd3e9977f63be\";}s:68:\"test/wp-content/plugins/js_composer/assets/js/vendors/woocommerce.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"32328114ae3781831abb8bddb2ebf24d\";}s:76:\"test/wp-content/plugins/js_composer/assets/js/vendors/qtranslate_frontend.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"abf3deb5c519cb2a08dbddb9f0860da5\";}s:80:\"test/wp-content/plugins/js_composer/assets/js/vendors/woocommerce-add-to-cart.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"902b7ca09549975e55e136fb0026df9a\";}s:72:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-models.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"64afe6af9797d0af376b5dbbd8ee62c3\";}s:69:\"test/wp-content/plugins/js_composer/assets/js/backend/media-editor.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7554d426f2f65b584c80bbae8f0e231f\";}s:73:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-storage.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1c84eb7794104026a0ad80d6601f0919\";}s:72:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-teaser.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"60fa79b9328daa7479e8ff733d3eaa5c\";}s:71:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-tools.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ecd5990eb29d5a5bc4eb478bf8c35a43\";}s:78:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-custom-views.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3d50eb212efac1d002233f2bef96b1a6\";}s:76:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-automapper.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b473c67bddf70e977b1574cb3eb1ead8\";}s:67:\"test/wp-content/plugins/js_composer/assets/js/backend/deprecated.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"322af2f930b4ec35f69e6f1c5eaa3071\";}s:79:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-settings-page.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6bf1169681d43c722bafafc296537a12\";}s:70:\"test/wp-content/plugins/js_composer/assets/js/backend/composer-view.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"70f059485d1f19faf32d375280526a23\";}s:74:\"test/wp-content/plugins/js_composer/assets/js/params/vc_grid_item/param.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7f77bacc00fd5eda1fba8fae547819b0\";}s:75:\"test/wp-content/plugins/js_composer/assets/js/params/vc_grid_item/editor.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"946cd06f99243e1649d388f4a5399312\";}s:66:\"test/wp-content/plugins/js_composer/assets/js/params/css_editor.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d7bae3f2c9ff05d22cac8eea4db36664\";}s:59:\"test/wp-content/plugins/js_composer/assets/js/params/all.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e23dc7b40478c9d9291494eca4cc1081\";}s:69:\"test/wp-content/plugins/js_composer/assets/js/params/params_preset.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"643d46f8742713435389c02fa261853a\";}s:69:\"test/wp-content/plugins/js_composer/assets/js/params/column_offset.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"250145ca4a99d999d4d8083538176a0a\";}s:69:\"test/wp-content/plugins/js_composer/assets/js/params/composer-atts.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"231771bb677ebbed34755188be29f9fb\";}s:67:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5ff9b2eb7bb6175b4956fa1e91a44294\";}s:86:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_lazy_masonry.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1e42b30afbb2026b7828623ab8e554d5\";}s:83:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_load_more.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f4cb177dc73617760c0d3bb2ef150756\";}s:78:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_lazy.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7f5c4baaee0a5e21522da6488be79aa9\";}s:91:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_load_more_masonry.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ec5a419774e65adfef3c664d7d7563e3\";}s:84:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_pagination.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5f42049334e2b471e1a950985da55e6f\";}s:85:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_all_masonry.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f4f2209199e6ff40ea8017b22bb80d53\";}s:77:\"test/wp-content/plugins/js_composer/assets/js/components/vc_grid_style_all.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bc320d3cc13a0f6929e9b8247ee22e35\";}s:77:\"test/wp-content/plugins/js_composer/assets/lib/vc_line_chart/vc_line_chart.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"24ca4f4673967f7142c81f117dd200a1\";}s:77:\"test/wp-content/plugins/js_composer/assets/lib/php.default/php.default.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ec26124be1c0b725779e44f57b15c7f7\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/vc_accordion/vc-accordion.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"70b33e4b60e4fa94de7bb6d363d675a2\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/vc_round_chart/vc_round_chart.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"14174f6ac1ee441d864fd4e377e1880c\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/vc-tta-autoplay/vc-tta-autoplay.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"aacce8959350f452b99cff9cf3c01ff9\";}s:74:\"test/wp-content/plugins/js_composer/assets/lib/vc_chart/jquery.vc_chart.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5062735c772d8979a3ea69b5fc4db301\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/waypoints/waypoints.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ac5840cf0870ecc0833ec7f0b46abdac\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/js/jquery.prettyPhoto.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"42e8a7f68ce7305e8c8583bcf27c8ac9\";}s:65:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/README\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8e3ab3382ff758d85bcf3cdfdb83f93c\";}s:112:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/dark_rounded/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:101:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/dark_rounded/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4297900ae2d9d0c4eb00d1c15462fb19\";}s:112:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/light_square/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:101:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/light_square/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:96:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/default/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8393c5f7e394698f751ee6a11fff3dc7\";}s:113:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/light_rounded/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:102:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/light_rounded/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:111:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/dark_square/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:100:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/dark_square/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4297900ae2d9d0c4eb00d1c15462fb19\";}s:108:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/facebook/default_thumbnail.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ed52db277173876860b62071785a2177\";}s:97:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/images/prettyPhoto/facebook/loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"df46993044576f83f2c2cc1a64e18f31\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/prettyphoto/css/prettyPhoto.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d20fd38e678f8ce9e9157df28741580a\";}s:65:\"test/wp-content/plugins/js_composer/assets/lib/vc_tabs/vc-tabs.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"68ebfda223f62b86220a2704956c72a5\";}s:69:\"test/wp-content/plugins/js_composer/assets/lib/vc_tabs/vc-tabs.old.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1a8ff51b6cdb012903bd77bba05487b9\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/autosuggest/jquery.autoSuggest.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2aa8533be17c83f2258106d2dde8faba\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/autosuggest/jquery.autoSuggest.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8b65898e843a284d65267bf9f37e5ece\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a77d39b97a27d80b88e0378e9fa130c2\";}s:96:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.theme.green.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e41f4a5e04080deccf5d0190fa2ecd5e\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/ajax-loader.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"01000918725acebd286de3787fca4ee0\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.carousel.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0a4d54b1b0c3a313c5bae1c74765357c\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.theme.default.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1236b5b3a75594d6f5ec110e435d8b2d\";}s:98:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.theme.default.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bbf1e38284b091f8cb50ea92f0943a0b\";}s:93:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.carousel.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3877391556313b5c7afb824e09f09359\";}s:92:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/assets/owl.theme.green.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0633615ecd3b8d655f0450600fe666eb\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/LICENSE\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1c3de5717178b64d49a1dd6276cdbc81\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/owl.carousel.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"32c1e1dcf248758339d96486a5e24ffc\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/owl-carousel2-dist/owl.carousel.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"80c5adc7c71158057ec7c466d61dbe99\";}s:77:\"test/wp-content/plugins/js_composer/assets/lib/vc_image_zoom/vc_image_zoom.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"32a23a0bb02fc1958b498b96b7d1832c\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/animate-css/animate.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"55009d64191e6f9e712a841773ee6611\";}s:70:\"test/wp-content/plugins/js_composer/assets/lib/bower/skrollr/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e312cb38ff2aa533c4148a42c75100c2\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/skrollr/dist/skrollr.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c8bdfc99c3ad3718bbe2e93ee25f2db5\";}s:95:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/fonts/fontawesome-webfont.ttf\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c4668ed2440df82d3fd2f8be9d31d07d\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/fonts/FontAwesome.otf\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"19231917733e2bcdf257c9be99cdbaf1\";}s:96:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/fonts/fontawesome-webfont.woff\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d95d6f5d5ab7cfefd09651800b69bd54\";}s:95:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/fonts/fontawesome-webfont.svg\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"65bcbc899f379216109acd0b6c494618\";}s:95:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/fonts/fontawesome-webfont.eot\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7149833697a959306ec3012a8588dcfa\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/font-awesome/css/font-awesome.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"feda974a77ea5783b8be673f142b7c88\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/vcIconPicker/jquery.fonticonpicker.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"09c4e7a7c10928144c9058d9296f7d77\";}s:117:\"test/wp-content/plugins/js_composer/assets/lib/bower/vcIconPicker/themes/grey-theme/jquery.fonticonpicker.vcgrey.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6753fb959fb0140c88567456c4f24bfe\";}s:116:\"test/wp-content/plugins/js_composer/assets/lib/bower/vcIconPicker/themes/grey-theme/jquery.fonticonpicker.vcgrey.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a751d0c1528dc6fb42da374a8c2c8987\";}s:120:\"test/wp-content/plugins/js_composer/assets/lib/bower/vcIconPicker/themes/grey-theme/jquery.fonticonpicker.vcgrey.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9fe70d75aeecbb17b07a9aae59567f35\";}s:99:\"test/wp-content/plugins/js_composer/assets/lib/bower/vcIconPicker/css/jquery.fonticonpicker.min.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e691271c322856786097c99ac290183b\";}s:71:\"test/wp-content/plugins/js_composer/assets/lib/bower/scrollTo/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c307196dc139fea908eeb77d8cc813d6\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/scrollTo/jquery.scrollTo.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3424df5663cf253a2d48b38402c43828\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/scrollTo/jquery.scrollTo.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7d954d1357b424bc1c17fe944fa96b0a\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/bower/scrollTo/changes.txt\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6a5937ba7c041737b1d8628fd4702f8e\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/imagesloaded/imagesloaded.pkgd.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"511ef2f6ee750edc32bb5c8d5d324e7e\";}s:72:\"test/wp-content/plugins/js_composer/assets/lib/bower/lessjs/dist/less.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4731c04d6df0184f519bbde61c48fdac\";}s:76:\"test/wp-content/plugins/js_composer/assets/lib/bower/lessjs/dist/less.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a799e13047cf98ac2c474b46cfda9599\";}s:70:\"test/wp-content/plugins/js_composer/assets/lib/bower/chartjs/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f55f567f8b37d778a1d7dd72c8a76893\";}s:69:\"test/wp-content/plugins/js_composer/assets/lib/bower/chartjs/Chart.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3d9055e69acd17fe0e8e3050883a2fb1\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/bower/chartjs/Chart.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7d8fd0c1dc6732675a1bd453a3f643a1\";}s:104:\"test/wp-content/plugins/js_composer/assets/lib/bower/jquery-ui-tabs-rotate/reference-implementation.html\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"432fdfdd4c3a2fd90fced90d6927cb0d\";}s:99:\"test/wp-content/plugins/js_composer/assets/lib/bower/jquery-ui-tabs-rotate/jquery-ui-tabs-rotate.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"20144aecaf895cf2a5e6923bb0e23fc0\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/bower/jquery-ui-tabs-rotate/README\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fd66989030e0a5aa761950b2de7348d0\";}s:76:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/button.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8f77f2911dd85d19cf162e873e002d9f\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/alert.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a9baf28358ffd0318251c903656dfba6\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/affix.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7b6483303fbb36207d34368b26cdb8b7\";}s:77:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/tooltip.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cbc8d0f6074c8d4b82d65a33b4462d24\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/transition.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9bf890aed54314c60f6e2f136d0c55a8\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/modal.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"99d58c72b81d190acfc09910be681327\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/dropdown.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d73369cd1d635ebaafb90fcfe1fd2791\";}s:77:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/popover.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7cce4d07bf36dbd4fbbb3ed28cbc71b3\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/scrollspy.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"25c8024ee60033a9b69341681ac4782a\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/collapse.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"73d3264a948b97c6c4833263a16778c3\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/tab.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"daea65ce5cfd27b2acd4d48a796ed09f\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/js/carousel.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e5db8109ab33806fedc1abe07bd0cd66\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c27679fdc7a793f3ef833ad1136a957f\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"394c9a1adcfd0dbd151dd5a466097985\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/jumbotron.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b69196767afbf1c6cd7866bfac4a215c\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/glyphicons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6ce2ee18b3e6dd304c06524f764abdb0\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/dropdowns.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"448b79b092145fb2b72591f17d75cbb0\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/navs.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d7bc4830d176f06ab882d1e375dc79f6\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/type.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"796254a09d33d1b55a0af59078753f29\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/media.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0772388431f540b03877cf5519d7a3d6\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/modals.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ae66349bf6d6f7c146c1f37cf1cd3421\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/buttons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9045db0e868ffd5de130b4b0517a9231\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/component-animations.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"833c81a0f3f56822e9de569bd03c5ffd\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/normalize.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cdcbbb33b9e0d6194451b37eff6cf74b\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/tooltip.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e95d7b009aa11771bb86cb0f16192bff\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/labels.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"18e545cfb7385e21c753ba236824210a\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/responsive-embed.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"48c4cc4bdf27c622ee44fed95e5e3992\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/alerts.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6e45fd732dfe839c6174a6b154a2706e\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/pagination.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e66fac501c05eb12a671fbbc8d332cf3\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/badges.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"95a80e3c31dcd7215f9251fa6a8b6189\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/button-groups.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f5f5803155dfc84e9df82512ac7ab72f\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/bootstrap.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"795f03e9246302d89820ab9f944d249a\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/list-group.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6d04b70c8199af36742afc252f3d5481\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/panels.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"335fd851a3110b4d2bc173bb6e6c7d02\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/progress-bars.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d459e0cf836ba21c3a4b30bda5f87a45\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/tables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e2a3550a2ecc068cfa5fb5b1157490bb\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/close.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e6b8bbb5dfb0bfa0f5f0a329aa11f8c0\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/utilities.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"32d06c96051b6cd191c6f6d8d00fb7c5\";}s:82:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/popovers.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"458fff7529ccd0897335376d64f799c8\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/forms.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2ba9ca845da60d4a450b299971e8a5d2\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/theme.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"52929d56e68f1fbf3a3eb0c7e3c8ae0a\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/pager.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d9ac01b29527f9da10ec0a0d5047a019\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/input-groups.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d8539e0b587c344d4ca75e1539698f8a\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/responsive-utilities.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8a64c69dcfc081a7858285f1ab2992f5\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/scaffolding.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"51356c12675334f88a9cb1945889792d\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/navbar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2eb60090010568710a3a1444f2c21d2e\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2f25b9b6c2c15a72aaeebd386ff9f5e7\";}s:99:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/nav-vertical-align.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a9e830f1c39bd7e89679fe6ea200763c\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/opacity.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1be3f12daf02e4f36a4b7896b377c773\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/text-overflow.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"97f3e435fd0a2d7734213f94483a685e\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/buttons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dddedf720ed5baea7d24446fdb4dd61a\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/image.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0af48a82a48f4a2e0ae68afdc5295e5f\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/labels.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e9248fda51f0a2e15fdfae9a23da1dae\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/clearfix.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8e9c9440f515f1586205aa595ae713ba\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/resize.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b6ef275960e5f97b064c1aff7d6b3951\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/text-emphasis.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a94099d8756dec84aeb54e7f022ab6e2\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/alerts.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"78aa25760d223bf51d8d4edf59c2d384\";}s:95:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/grid-framework.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"20eeb16ebc94f062bab9c032f3414364\";}s:91:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/pagination.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d1670390120629299270f67d56466b5b\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/hide-text.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e588fdb4311e69e3a5fcee7ebe9c6c99\";}s:91:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/list-group.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"66e3e724e2fc3c9089ac1cd006084e0c\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/panels.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"702aa4b209e98934500dce0833b13798\";}s:96:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/vendor-prefixes.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"80c823aa5decc01fc1b26dfeebb66400\";}s:102:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/responsive-visibility.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"74fcac885ba966f828a373f405b755b4\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/gradients.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"16a24c0e580c0d2516269b0593893395\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/forms.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c4e8df63320154809f60d5001d4b24e0\";}s:92:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/nav-divider.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"846f793e8d601915b31d2d7699bc35ab\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/border-radius.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"30d64faff1cc98361fb1ec89b4e29418\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/tab-focus.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"888e1e5f8e41a88aaa1afa58214b072e\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/table-row.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3b3855aeeb76f7dd6868d68303d18a2e\";}s:93:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/center-block.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e2328a0e18978ca3f20412c36b014865\";}s:99:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/background-variant.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"34c5b4585baca57889dc1d390f563ae5\";}s:93:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/progress-bar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a6ddfc8dc309d26f14ce8500308b175a\";}s:93:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/reset-filter.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ff42fe79f10deeaea892af691711fa33\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/mixins/size.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cb591f72667a90bbc04e539332278019\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/code.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"523710562413ea45b7581b628eddce28\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/print.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"339deed7cdfe94651f37fd7ed604c29c\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/wells.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"496407c34cd52fab0c1ca1d17f0353a1\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/thumbnails.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0867dbfe76890faf4e10db63f4b5e948\";}s:82:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/carousel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4dfe7eeb533aac6c9c2f477f0d597d30\";}s:83:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/variables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"648fc0b411a58ae0a6c0c5e687167c0d\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/less/breadcrumbs.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7dce9541e6a59de6301403a7d25036fa\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/dist/js/bootstrap.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0e3d82fd4a6813829c0288b39fb98434\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/bower/bootstrap3/dist/js/bootstrap.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"25fcc8b3e425c70fa90d31f2115e9d86\";}s:74:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/json_parse.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"931eb9ad1d8ca330581a083289afd23d\";}s:69:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/cycle.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5971ecb05d3449fbd49e8a060a7de6a1\";}s:80:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/json_parse_state.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d9453705a5f1c328ce379c2d7a4246dd\";}s:69:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/json2.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f97cd64fa7f3d3d3728786288fef56c8\";}s:67:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/README\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8ac5f66ba87e7260a45af2c688313c4b\";}s:68:\"test/wp-content/plugins/js_composer/assets/lib/bower/json-js/json.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8c01056f87b26376a7791f6c1a562800\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/jquery.flexslider.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"01c2eb5fa4f3ad48e5d18f24a34543bf\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/fonts/flexslider-icon.svg\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"10e8a5455c4522c48aa975eacd4f0023\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/fonts/flexslider-icon.ttf\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b4c9e5057989b9727a5df4e0a21af33c\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/fonts/flexslider-icon.eot\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9c9cb7a6055043933ba68854f521af45\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/fonts/flexslider-icon.woff\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f8b92f66539473eea649c8514eb836a0\";}s:76:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/README.mdown\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"890470ff5f3fca82c01b741b153768ea\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/flexslider.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0dcd7e62c5e0f882550b1c61612fb2fc\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/bower/flexslider/jquery.flexslider-min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9ec3c315b67f434aabc4da58eabc6c3a\";}s:76:\"test/wp-content/plugins/js_composer/assets/lib/bower/zoom/jquery.zoom.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"79ae9189ee120aa9a26f81399104c62f\";}s:67:\"test/wp-content/plugins/js_composer/assets/lib/bower/zoom/readme.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"efe6553f59c21593312a75c279614e6a\";}s:72:\"test/wp-content/plugins/js_composer/assets/lib/bower/zoom/jquery.zoom.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"650cff27691fe87946e7747bf1cd27d3\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/bower/masonry/README.mdown\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"35db1ea0d84485d8c8669d772ae98469\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/bower/masonry/dist/masonry.pkgd.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b7eb7f398ba96c71d150545e79a7f589\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/masonry/dist/masonry.pkgd.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4718bbecd682b9701ec534a0a582aab9\";}s:97:\"test/wp-content/plugins/js_composer/assets/lib/bower/twbs-pagination/jquery.twbsPagination.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9b3ee1acb5496059d22fb18cfb8a2d1f\";}s:96:\"test/wp-content/plugins/js_composer/assets/lib/bower/ace-builds/src-min-noconflict/worker-css.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e07c90bb62747d4c738179a36a846d80\";}s:98:\"test/wp-content/plugins/js_composer/assets/lib/bower/ace-builds/src-min-noconflict/theme-chrome.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e28d16cb55d12000ff675beae3b58d97\";}s:89:\"test/wp-content/plugins/js_composer/assets/lib/bower/ace-builds/src-min-noconflict/ace.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8fda0bf06e60ee1629de3d212e34cc6c\";}s:94:\"test/wp-content/plugins/js_composer/assets/lib/bower/ace-builds/src-min-noconflict/mode-css.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e08b9c77d53a7178f89410e51bd6da6f\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/isotope/CONTRIBUTING.mdown\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bbccc35235ee1ed01b4e5e3c06a950f9\";}s:73:\"test/wp-content/plugins/js_composer/assets/lib/bower/isotope/README.mdown\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"69e50af0080452ecb4907516471812c5\";}s:81:\"test/wp-content/plugins/js_composer/assets/lib/bower/isotope/dist/isotope.pkgd.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8d94a4845b75094187b897047cfb77f1\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/isotope/dist/isotope.pkgd.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"95ed1955938c1024a682da5565431c98\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/bower/progress-circle/README.md\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"911bfb7e0fb23f89e5e0a0032c84c81b\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/progress-circle/ProgressCircle.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f5bb5e4309515fd49c9f573c715bea4a\";}s:85:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/jquery.nivo.slider.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d3356754fe8c2e45837b1efbfe7d3264\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/nivoslider.jquery.json\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"22365e32facada291f8b8ef48395d342\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/jquery.nivo.slider.pack.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0cf3f8b677dcd27b6d46f4a56d65fdb2\";}s:79:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/nivo-slider.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"51b2916fcb7a9f89a21b70e0c7688a59\";}s:70:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/README\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"becc172e4ba87a2e994ad54b879d79b2\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/license.txt\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b33de89b9b54413e6afd18b47102982a\";}s:84:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/dark/dark.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"db452a5ecbe16d40078f5c0f439e6f05\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/dark/loading.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd6b7b0bf5c3af22499abc0a9ee1e1b2\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/bar/loading.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd6b7b0bf5c3af22499abc0a9ee1e1b2\";}s:82:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/bar/bar.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"58f95f303855cd8bea1a1aaab6d730c8\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/default/default.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d66e12b55df8510fe05b9d4fb1aaaf07\";}s:90:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/default/loading.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd6b7b0bf5c3af22499abc0a9ee1e1b2\";}s:86:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/light/light.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"eede2daf7c7aec7a4e444b60a7ce3a89\";}s:88:\"test/wp-content/plugins/js_composer/assets/lib/bower/nivoslider/themes/light/loading.gif\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd6b7b0bf5c3af22499abc0a9ee1e1b2\";}s:87:\"test/wp-content/plugins/js_composer/assets/lib/jcarousellite/jcarousellite_1.0.1.min.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"da2fa9afa62f7fdb12aecd847b277ea8\";}s:76:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/js/vc_carousel.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2c0ecc22ec1d170eaddc6b75a4ab5378\";}s:75:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/js/transition.js\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"387d56a602ba85b74c1b58e8c58ba524\";}s:97:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/fonts/glyphicons-halflings-regular.eot\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b30e2603f37d19d579fafbcb448faee9\";}s:98:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/fonts/glyphicons-halflings-regular.woff\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fc4f5426b64b683a2ed14841acae06d7\";}s:97:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/fonts/glyphicons-halflings-regular.ttf\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7ca49988b0d938abb855b6570f84ba6e\";}s:97:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/fonts/glyphicons-halflings-regular.svg\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3b31e1de93290779334c84c9b07c6eed\";}s:66:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/LICENSE\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3b83ef96387f14655fc854ddc3c6bd57\";}s:82:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/css/vc_carousel.css.map\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"960a1a7f53f0ef1c874f027fbecc9630\";}s:78:\"test/wp-content/plugins/js_composer/assets/lib/vc_carousel/css/vc_carousel.css\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a9a04971472c70dddd6184ae91882728\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/config/admin_variables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3839253949dbb7baab3ca330f8364d0f\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/config/variables_common.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6d8adede85122a4201608b4f91884792\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/config/variables_colors.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e5b1332f78f6d294b314d90871763e48\";}s:69:\"test/wp-content/plugins/js_composer/assets/less/config/variables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fe0ee610de2a8962460c33aa7af029a0\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_modals.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"78a9cee115bfd5a8b0cd137761b23f21\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_preloader.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"389ec94d3f525656366e88021fd736d2\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_switcher.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"372bd23a0adba68e5f77667451c11be7\";}s:69:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_table.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3f0c95b5535c77ab7cf860fa75ab01ee\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_messages.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cb095338b203901a8e08e19ec0391bc0\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_teaser_box.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a7d14022378596e8c8485abb1a95d8df\";}s:89:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_license_activation_notice.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8be46f4cf3e20a89404a834de2ff588a\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_panels.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2ad2dab1971a1500d6d0e1199eca08f8\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_navbar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9833b09c7b0aa3dd2391af7ecc1340f7\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_buttons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9a3d61da7bde151083bcc7b198d49cc0\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_default_templates.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"662888781aa7c16f6800b9994d841afc\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_placeholder.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"32f12a6792d49a9f8e46c3518058ef2e\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_welcome.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3c6678fee0421123171b616d32034d1e\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/modules/vc_helper.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"13713f1192277293ea5a7ddb9930bd31\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-flex-bootstrap.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c13b8773b4b96ac7448ab2aa35b043f8\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-fonts.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bde3bee69f03ac3de8640adf41dea59f\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel-templates.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6165de66230e1659a12b94ed9ff5332b\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel-row-layout.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"72fc6b6524245c0836a57f33e30dd18f\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-gaps.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5b283d193895302da819508afc0c1750\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-tabs-line.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6bac11ddb4b266ba989fb13a90b3c01d\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-prompt.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1da5dfcbb313a2e82f3d05cb2b47ed18\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-icon-pixel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9ef5c8cf465d7a3d0a2f6857499bcfb2\";}s:95:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel/vc_ui-panel-content.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"91b83e9ea33198c505926edac0e5fc7d\";}s:94:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel/vc_ui-panel-footer.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2f82feae133448e82f3d993584d33d5e\";}s:94:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel/vc_ui-panel-window.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d7ef7c888b694d0948e183ca7229e003\";}s:94:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel/vc_ui-panel-header.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4a00f3d543d81a7d9cc20ce559b16c89\";}s:87:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel/vc_ui-panel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"947e39fc6eda5e637d3c23986afdf06d\";}s:88:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-panel-edit-element.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"647167ed7c68f43090ce90afe18df31a\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-dropdown.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4b6ad16825771e93625cf6b7714ce0a4\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/modules/ui/vc_ui-button.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9609c7e543a751cedc69dbd7c4aaae79\";}s:61:\"test/wp-content/plugins/js_composer/assets/less/lib/grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"927caf580d600c6046184f35bbe0a0be\";}s:62:\"test/wp-content/plugins/js_composer/assets/less/lib/utils.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"446bccb8f6b64f68e74f05fc7a231aee\";}s:65:\"test/wp-content/plugins/js_composer/assets/less/lib/parallax.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e210a93ded635359e15c0d1ca8c63a8c\";}s:65:\"test/wp-content/plugins/js_composer/assets/less/lib/controls.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b3671a3fbadcbd14f146af97ea85d505\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/lib/frontend_editor_controls.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"09eeabef6cfb44b0b84240babd4b1cda\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/lib/frontend_draganddrop.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f4ed7d535fa4d39502b66bed6202257a\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/lib/backend_draganddrop.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a8053df7b17e6560b7c9aa17feab9823\";}s:68:\"test/wp-content/plugins/js_composer/assets/less/lib/pixel_icons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c6801035d13464fc954f1431275cb4e9\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/lib/bootstrap-components.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"eb6a3b40504e40295f9cda14df359de6\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/lib/resizable_modal.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ebff1126cf669f8b91107399dbe9604a\";}s:67:\"test/wp-content/plugins/js_composer/assets/less/lib/vc_pointer.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"354928a660b8cd237c2c6e668617108e\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/lib/backend_grid_element_pointers.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"afa9ebeeebefe1cc9cf9a66fd0e11252\";}s:63:\"test/wp-content/plugins/js_composer/assets/less/lib/editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ba84a82e7b9dd761d204d3e0a73a2fc9\";}s:65:\"test/wp-content/plugins/js_composer/assets/less/lib/wpb_icon.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"aee36a8a21b29beb34ed523b1a8835eb\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/lib/backend_controls.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"27accc37055b41f32120592e96384c11\";}s:66:\"test/wp-content/plugins/js_composer/assets/less/lib/vc_mixins.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f0e5a61d481423a4be64a3c792871352\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/lib/admin_bar_button.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"df94a20d73f54f50a3d6c712ba5242ae\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/lib/responsive-utilities.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a842bd4e38e39a686780948bead22351\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/lib/frontend_vc_elements.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fdfd154c669ca5c392610c29a2148bad\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/lib/media-gallery.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b819a1ed231bdff72f6596d224f0a428\";}s:64:\"test/wp-content/plugins/js_composer/assets/less/lib/vc_font.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a694a0bc50377c70386d9f8dfcc10737\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/lib/css3_animations.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b3139bee53d6ba64570156aa5bc95e91\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/lib/elements_icons.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"10fd3980a3b22606c45d501f45ff49e9\";}s:63:\"test/wp-content/plugins/js_composer/assets/less/lib/vc_row.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6ee7b09c2b96619edaa089cbc47697b1\";}s:62:\"test/wp-content/plugins/js_composer/assets/less/lib/front.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d019d15029a44a79c1976d0ce9448944\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/vendor/gravity_form.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2d569ef2c877d98bff8b69a6b984ebf7\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/vendor/woocommerce.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1dbb076a4747983ea4060e762d09a969\";}s:68:\"test/wp-content/plugins/js_composer/assets/less/vendor/jwplayer.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"77a1eb6530ee14810b32946177cfe455\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/vendor/layerslider.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d5487851723ea59b208b45278ba2a47c\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/vendor/rev_slider.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"81b9bdc4e3f468dba6452b54e118cee6\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/vendor/contact_form_7.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f4fac8c81a3272f763e9c1d791626830\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_responsive.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"613dac1fbee3a8b9a94267630bb29cbf\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/_shortcodes_container.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"94b052df374686851c3a01c212eef2d6\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_cta3_editform.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e9d069271367b7bcf6125ec8357c805e\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_button3.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"20532b9144609a1151ea5a38c952ceee\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_separator.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"626f5d4f210a37f0b133609718c8cd00\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_teaser_grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c4b0f539d7f49ca72f972587f8a436ef\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_carousel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"92f84b0c549f20a060a3aef6b45c97b8\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_widgetised_column.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f8e213d24158f7b8f899c9b6d0d51aa6\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_icon_element.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b1d652d7a32e06e57dc50ee25683a951\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_call_to_action.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7efa3e31767ccd06fe66c59ead9e06dc\";}s:95:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_message_box/vc_message_box_2.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"461dddc2671c668673a304d86b4229bd\";}s:103:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_message_box/vc_message_box_variables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"37386ef095ef162cccfdf8717cf1d784\";}s:100:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_message_box/vc_message_box_mixins.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e21bcb7637a07e3da001db705cb66507\";}s:99:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_message_box/vc_message_box_front.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b4336b8d1b9fc7bac1c7aea1df371538\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_social_btns.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"aac4f155517e60c0fbf72f2454ef1317\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_zoom.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9de197214d60d62ca2174bf1f1717f52\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_twitter.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"531344625f8ee44534df738dd5a7236a\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_custom_heading.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9e8c2353c6dac7a45ea4bee3dd44b6e2\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_progress_bar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"895dfccf5da32b42611a110965373572\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_tta.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3f48c0b5d926776b1e73d21fd230feb3\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_post_slider.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5ca1dd907865f87741dcd0bae707dbac\";}s:88:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-icon-controls.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ce300683ac4540d9cd3c1772fcc5e3b6\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-mixins.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1ebca56e13f2b0ecad9852335beb5f3f\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-core.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b20e25b04b89c76ff3e6788c7d8eaf4c\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-variables.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e9ca520770ce1a6f252afdc88c8c5067\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-colors.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e5f7cd05bdce636b03b39ed0822979de\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-options.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ac8017b4af64dd6a340186fb10828297\";}s:90:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/tta/vc_tta-frontend-editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b9592935a352bb09c16f42ea9c740e40\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_image_gallery.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a819425a5650b3bb712ee423b12aff3b\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_alert.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7d13f435c3f476a74f94328844aa4210\";}s:89:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_gap.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"de3ff508d6247f1e6a3687ad5409dda2\";}s:101:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_pagination_dots.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"77853fb0b60fc2c31dfb0212eb03a06d\";}s:93:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_loading.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8bfc63105a127ac87def01388d544a92\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0cd900e8b9091b7691621e4a1823bd40\";}s:91:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_style.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"60a49f343dc28f5a1a0b2a95c90e32b7\";}s:94:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_carousel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"116ac1cdbac9932a13e255400bd3636e\";}s:107:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/filter_styles/filter_dropdown.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"821bec57b93f4d43b8e69b208fcf11fd\";}s:119:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/filter_styles/filter_default_less_rounded.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f3b0c131b7bf91966b87db00916a37ff\";}s:105:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/filter_styles/filter_filled.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"85eae5aee851944391082dc6b61efc45\";}s:106:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/filter_styles/filter_default.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c586cb914fec4140c233577e4e7669d4\";}s:107:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/filter_styles/filter_bordered.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3f48fa6b45bdd96f7c78f0d303fad58d\";}s:104:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_pagination_numbers.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d34af11dcd6875df737f8a365e972423\";}s:92:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_filter.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"9a7d214bfbeb520e1b8b4b07db244143\";}s:92:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_basic_grid/vc_grid_arrows.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a04e7f2a6e6ddc7b639523b8a5bcb65f\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_video_widget.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1481eec3edb7f93982b82022050a8396\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_single_image.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"896195bfa7f0313fcf4bf577da3b4b04\";}s:83:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_button3_editform.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a73d93167e7ec5ad0cbab8808a7e8bea\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_pagination.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"745754ece53d16bb959939879501c66e\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_tabs_tour_accordion.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ebb7027f642a475e4d5717f26365f38f\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_flickr.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"27ccf7774c4038810d16ba7908f17644\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_button.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7588bc5e76b73038cb6ba1b75711f66a\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_call_to_action3.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"dd400c978747f36c33ef35775153a5c0\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_charts.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"caff271b55a7a44eec349fc4dea7c98f\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_google_maps.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"74c4665bc4ea8fd0dc82ff19dbeaed60\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_toggle.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"385346422f437a12a590843cd7b5dc08\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/shortcodes/vc_pie.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"66fc346848cbebd757453904043d6adc\";}s:87:\"test/wp-content/plugins/js_composer/assets/less/js_composer_frontend_editor_iframe.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"81a56abcaf68683712753977b0a4780a\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/js_composer_backend_editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"92d8e46bd3ab7314df3bbd97b04bca32\";}s:63:\"test/wp-content/plugins/js_composer/assets/less/vc_lte_ie9.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"85106e4c27e5f416c984195f641b065a\";}s:69:\"test/wp-content/plugins/js_composer/assets/less/pages/vc_welcome.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"afe3da5c1676b19cbf0dcd60959f084c\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/js_composer_settings.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2f6e910bb4da22db00c2e5212e9d12da\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/popups/panel_post_settings.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7ffdc95a799c31bf492a6d5f6df84108\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/popups/panel_edit_layout.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5079c3af0bf8b2793b7698facd1c2204\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/popups/panel_edit_form.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"186d372a81b9d86dda6d945959434c63\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/popups/modal_add_element.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d47f1c81fc5a21d43b534e328d0f2594\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/params/sorted_list.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a287a536fc40051736e83176527a7ac8\";}s:72:\"test/wp-content/plugins/js_composer/assets/less/params/autocomplete.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"095bcf0c72b646ba5150e29e23b5455f\";}s:88:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/vc_gitem_editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f6078a72a1e17801074b2a158473ed5a\";}s:102:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_row_admin.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f5b5fd1f813de176e40191c5ff904923\";}s:107:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_animated_block.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fa8f79b0f914e4a017ee8d0c29bcc953\";}s:96:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_col.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cbe12f049665afa35abdf4673846c7bb\";}s:99:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_zone_c.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5a78f26930f48742fbc909af0e5d520e\";}s:97:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_zone.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3d6ded7b141d29a3bc00881b727dc74b\";}s:96:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_row.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"76fe7f9e203a31b363867aba6119bfdc\";}s:99:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_zone_a.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0d0ce987c726cf5b8bd62b9111a500f5\";}s:102:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_post_data.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8c79cc7f07e26b73fc0de993b8691b0c\";}s:113:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_animated_block_admin.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"73f15fd2968234e77643cbbf645cbd74\";}s:115:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_gitem_zone_height_mode.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"899bbb87f59657ea251e412ec88e1648\";}s:103:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_zone_admin.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2aa2db7cf6cde53784296935f37d91e9\";}s:99:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/shortcodes/vc_gitem_zone_b.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"a0a52f3c43c69b3940ed0b2133b50e58\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/vc_grid_item.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fa20c6240ec9c2f089b4485a0448be63\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/preview.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"18f9b8f4da3708b5e82fd33581529cce\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_item/navbar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:67:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2c07a66d2761f5eadff95cf823c428dd\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/params/iconpicker.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f9ef2a582e989eb54ab214718613695c\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/params/column_offset.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"191a383c47eff5478321eb1dd1b60254\";}s:68:\"test/wp-content/plugins/js_composer/assets/less/params/dropdown.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"81fee7ce1a3283c5531e268c3996b9f0\";}s:64:\"test/wp-content/plugins/js_composer/assets/less/params/loop.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"21a5626b5a36bcae25465fbc3d27263f\";}s:76:\"test/wp-content/plugins/js_composer/assets/less/params/vc_message_color.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"0bfefb23b5158c51f02b1d03084575ed\";}s:70:\"test/wp-content/plugins/js_composer/assets/less/params/css_editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6d0b9acdea159786874e97590075d112\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/params/param_group.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8c936cd4111475024807413b80dbdb04\";}s:67:\"test/wp-content/plugins/js_composer/assets/less/params/vc_link.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"86272c6988315f27c00a1d3ca4364ff9\";}s:75:\"test/wp-content/plugins/js_composer/assets/less/params/vc_grid_element.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7984bb804beb88f96eb2b2682ae25512\";}s:71:\"test/wp-content/plugins/js_composer/assets/less/params/colorpicker.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1123df759a0b940e6c7cd1509251b23e\";}s:66:\"test/wp-content/plugins/js_composer/assets/less/params/hidden.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1c7dd9fb792a881c8a51b274c6a19143\";}s:73:\"test/wp-content/plugins/js_composer/assets/less/params/options_field.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"757ea069c56714a46e4288a5a6509beb\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_button3.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"fe998af08b1033a8f0adfe03d3ecc1c9\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_separator.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"14e8db9bbba568d8f7895cda54756734\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_video.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"080509fd8e7de103f1c1f909c4f0bae2\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_wp_widget.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"37b7e7fdc8efdcb94dc2476e5e2c6166\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/rows_columns.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2f0655700616877f998d34ab73ab8390\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/content_block.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cf1b5cca1aac6658bf30ad14cf6c3582\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_gmaps.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"70e3b98e25f92ea4c2d3fb41e75fe3a9\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_pinterest.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ecd2ae848f94403c48af72a64b102864\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_teaser_grid.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"47d3d83a5d4f0b4d4e193d80eeb868b8\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_tour.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ce829fc6aa802d16a1bbb362387165f1\";}s:88:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_accordion_tab.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"34885cf451ca1050bea3c2d73c63cc24\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_tweetmeme.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"89d39293c964a0c29c16fd04c79a7ae1\";}s:79:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_tabs.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e85cc023acf1edb6073d6bb34d980a38\";}s:88:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/empty_containers.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"84cab60c8239a609fb5cba35b3236e8a\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_twitter.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"1172516e9a5ce81c931fe152764b2e4c\";}s:87:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_progress_bar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"74ba06d3a749e275c82d796e235b50e4\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_tta.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"226f68fd0b0b72a43f7bdf001c1777a2\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_gallery.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"074bfa11aec3052b47efd4984501a896\";}s:87:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_posts_slider.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"075c8e2cac30ed1a50eef955736d6c8b\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_column_text.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"e9966392ce68fb1cc19cf49be54ae230\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_message_box.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"4b7e2b246649323ade44eb12cf263ae8\";}s:90:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_images_carousel.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"c37b53859539c58e776ebda668d05b27\";}s:83:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_facebook.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ecb3708466ee716c1f0f79a353cbfe94\";}s:89:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_widget_sidebar.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"24621d53ad117ad395b72bf7c9c8da9b\";}s:87:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_single_image.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"3a420d4b8473a26b67199d7fc289a38c\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_cta_button.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"27b12dfa05bf233f3da2fa37341f77f7\";}s:86:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_empty_space.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ea2c0832788bd3d267ec7ac6eba2c01a\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_flickr.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2657d1f8ba4e53677cce948889147aa2\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_button.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"849c9939831643b8339e41d965b5bf08\";}s:83:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_raw_html.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7ffdff6de46ad353119a2df1b5ffd3e2\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_tab.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"524f4b1752e5dcb78cdef56d42da7787\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_raw_js.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"d41d8cd98f00b204e9800998ecf8427e\";}s:90:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_call_to_action3.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"cbf754557f4ada52be053386043f32d7\";}s:84:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_accordion.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"7939e34567e1731f27610f2a0c6c4f00\";}s:85:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_googleplus.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8a27c1b83554e6fb3fd2faf45c15e585\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_charts.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6f32cc4c99d9a3420c26189ca254f17a\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_toggle.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ec9fce53eedce4b7cf8eb7c709c5092b\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/backend_shortcodes/vc_pie.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"8d70e79ed0a10a532e1d594f6342346c\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/custom_css.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"f9be29bf2ff078a39983320d615fe3d5\";}s:77:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/automapper.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"ce7f7d184e9014373e36df120113c827\";}s:78:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/element_css.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"92f7fd3ab14fe16e05fea2be01694a58\";}s:83:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/general_settings.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"921a05e0facc0f59654ecfe41a653f1b\";}s:82:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/product_license.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"b2e2fe5be3c0a38925fb1c343d6ebf77\";}s:81:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/design_options.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"bce3c385c30215da0d8c62560b49952a\";}s:74:\"test/wp-content/plugins/js_composer/assets/less/settings_tabs/tabs_ui.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"2a4c1e133496404a8114786b41904d8e\";}s:80:\"test/wp-content/plugins/js_composer/assets/less/js_composer_frontend_editor.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"5452e4bf451ae56d3cb10c7d8ce11379\";}s:64:\"test/wp-content/plugins/js_composer/assets/less/js_composer.less\";a:2:{s:1:\"d\";i:1446218652;s:1:\"h\";s:32:\"6e093ee4ff